/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.bpmn.parser.handler;

import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.SendTask;
import org.flowable.engine.impl.bpmn.behavior.WebServiceActivityBehavior;
import org.flowable.engine.impl.bpmn.parser.BpmnParse;
import org.flowable.engine.impl.bpmn.parser.handler.AbstractActivityBpmnParseHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendTaskParseHandler
extends AbstractActivityBpmnParseHandler<SendTask> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SendTaskParseHandler.class);

    @Override
    public Class<? extends BaseElement> getHandledType() {
        return SendTask.class;
    }

    @Override
    protected void executeParse(BpmnParse bpmnParse, SendTask sendTask) {
        if (StringUtils.isNotEmpty((CharSequence)sendTask.getType())) {
            if ("mail".equalsIgnoreCase(sendTask.getType())) {
                sendTask.setBehavior((Object)bpmnParse.getActivityBehaviorFactory().createMailActivityBehavior(sendTask));
            } else if ("camel".equalsIgnoreCase(sendTask.getType())) {
                sendTask.setBehavior((Object)bpmnParse.getActivityBehaviorFactory().createCamelActivityBehavior(sendTask));
            } else if ("dmn".equalsIgnoreCase(sendTask.getType())) {
                sendTask.setBehavior((Object)bpmnParse.getActivityBehaviorFactory().createDmnActivityBehavior(sendTask));
            }
        } else if ("##WebService".equalsIgnoreCase(sendTask.getImplementationType()) && StringUtils.isNotEmpty((CharSequence)sendTask.getOperationRef())) {
            WebServiceActivityBehavior webServiceActivityBehavior = bpmnParse.getActivityBehaviorFactory().createWebServiceActivityBehavior(sendTask, bpmnParse.getBpmnModel());
            sendTask.setBehavior((Object)webServiceActivityBehavior);
        } else {
            LOGGER.warn("One of the attributes 'type' or 'operation' is mandatory on sendTask {}", (Object)sendTask.getId());
        }
    }
}

