/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.entitylink.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.flowable.common.engine.impl.AbstractServiceConfiguration;
import org.flowable.entitylink.api.EntityLinkService;
import org.flowable.entitylink.api.history.HistoricEntityLinkService;
import org.flowable.entitylink.service.impl.EntityLinkServiceImpl;
import org.flowable.entitylink.service.impl.HistoricEntityLinkServiceImpl;
import org.flowable.entitylink.service.impl.persistence.entity.EntityLinkEntityManager;
import org.flowable.entitylink.service.impl.persistence.entity.EntityLinkEntityManagerImpl;
import org.flowable.entitylink.service.impl.persistence.entity.HistoricEntityLinkEntityManager;
import org.flowable.entitylink.service.impl.persistence.entity.HistoricEntityLinkEntityManagerImpl;
import org.flowable.entitylink.service.impl.persistence.entity.data.EntityLinkDataManager;
import org.flowable.entitylink.service.impl.persistence.entity.data.HistoricEntityLinkDataManager;
import org.flowable.entitylink.service.impl.persistence.entity.data.impl.MybatisEntityLinkDataManager;
import org.flowable.entitylink.service.impl.persistence.entity.data.impl.MybatisHistoricEntityLinkDataManager;

public class EntityLinkServiceConfiguration
extends AbstractServiceConfiguration<EntityLinkServiceConfiguration> {
    protected EntityLinkService entityLinkService = new EntityLinkServiceImpl(this);
    protected HistoricEntityLinkService historicEntityLinkService = new HistoricEntityLinkServiceImpl(this);
    protected EntityLinkDataManager entityLinkDataManager;
    protected HistoricEntityLinkDataManager historicEntityLinkDataManager;
    protected EntityLinkEntityManager entityLinkEntityManager;
    protected HistoricEntityLinkEntityManager historicEntityLinkEntityManager;
    protected ObjectMapper objectMapper;

    public EntityLinkServiceConfiguration(String engineName) {
        super(engineName);
    }

    protected EntityLinkServiceConfiguration getService() {
        return this;
    }

    public void init() {
        this.configuratorsBeforeInit();
        this.initDataManagers();
        this.initEntityManagers();
        this.configuratorsAfterInit();
    }

    public void initDataManagers() {
        if (this.entityLinkDataManager == null) {
            this.entityLinkDataManager = new MybatisEntityLinkDataManager(this);
        }
        if (this.historicEntityLinkDataManager == null) {
            this.historicEntityLinkDataManager = new MybatisHistoricEntityLinkDataManager(this);
        }
    }

    public void initEntityManagers() {
        if (this.entityLinkEntityManager == null) {
            this.entityLinkEntityManager = new EntityLinkEntityManagerImpl(this, this.entityLinkDataManager);
        }
        if (this.historicEntityLinkEntityManager == null) {
            this.historicEntityLinkEntityManager = new HistoricEntityLinkEntityManagerImpl(this, this.historicEntityLinkDataManager);
        }
    }

    public EntityLinkServiceConfiguration getIdentityLinkServiceConfiguration() {
        return this;
    }

    public EntityLinkService getEntityLinkService() {
        return this.entityLinkService;
    }

    public EntityLinkServiceConfiguration setEntityLinkService(EntityLinkService entityLinkService) {
        this.entityLinkService = entityLinkService;
        return this;
    }

    public HistoricEntityLinkService getHistoricEntityLinkService() {
        return this.historicEntityLinkService;
    }

    public EntityLinkServiceConfiguration setHistoricEntityLinkService(HistoricEntityLinkService historicEntityLinkService) {
        this.historicEntityLinkService = historicEntityLinkService;
        return this;
    }

    public EntityLinkDataManager getEntityLinkDataManager() {
        return this.entityLinkDataManager;
    }

    public EntityLinkServiceConfiguration setEntityLinkDataManager(EntityLinkDataManager entityLinkDataManager) {
        this.entityLinkDataManager = entityLinkDataManager;
        return this;
    }

    public HistoricEntityLinkDataManager getHistoricEntityLinkDataManager() {
        return this.historicEntityLinkDataManager;
    }

    public EntityLinkServiceConfiguration setHistoricEntityLinkDataManager(HistoricEntityLinkDataManager historicEntityLinkDataManager) {
        this.historicEntityLinkDataManager = historicEntityLinkDataManager;
        return this;
    }

    public EntityLinkEntityManager getEntityLinkEntityManager() {
        return this.entityLinkEntityManager;
    }

    public EntityLinkServiceConfiguration setEntityLinkEntityManager(EntityLinkEntityManager entityLinkEntityManager) {
        this.entityLinkEntityManager = entityLinkEntityManager;
        return this;
    }

    public HistoricEntityLinkEntityManager getHistoricEntityLinkEntityManager() {
        return this.historicEntityLinkEntityManager;
    }

    public EntityLinkServiceConfiguration setHistoricEntityLinkEntityManager(HistoricEntityLinkEntityManager historicEntityLinkEntityManager) {
        this.historicEntityLinkEntityManager = historicEntityLinkEntityManager;
        return this;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public EntityLinkServiceConfiguration setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
        return this;
    }
}

