/*
 * Decompiled with CFR 0.152.
 */
package org.fossnova.json;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import org.fossnova.finder.FactoryFinder;
import org.fossnova.json.JsonArray;
import org.fossnova.json.JsonBoolean;
import org.fossnova.json.JsonNumber;
import org.fossnova.json.JsonObject;
import org.fossnova.json.JsonString;
import org.fossnova.json.JsonValue;
import org.fossnova.json.stream.JsonException;
import org.fossnova.json.stream.JsonReader;

public abstract class JsonValueFactory {
    private static final JsonValueFactory FACTORY = (JsonValueFactory)FactoryFinder.find(JsonValueFactory.class);

    protected JsonValueFactory() {
    }

    public static JsonValueFactory getInstance() {
        return FACTORY;
    }

    public abstract JsonObject newJsonObject();

    public abstract JsonArray newJsonArray();

    public abstract JsonBoolean newJsonBoolean(Boolean var1);

    public abstract JsonNumber newJsonNumber(Number var1);

    public abstract JsonString newJsonString(String var1);

    public abstract JsonValue readFrom(JsonReader var1) throws IOException, JsonException;

    public abstract JsonValue readFrom(Reader var1) throws IOException, JsonException;

    public abstract JsonValue readFrom(String var1) throws IOException, JsonException;

    public abstract JsonValue readFrom(InputStream var1) throws IOException, JsonException;

    public abstract JsonValue readFrom(InputStream var1, Charset var2) throws IOException, JsonException;

    static {
        if (FACTORY == null) {
            throw new IllegalStateException("Factory not configured: " + JsonValueFactory.class.getName());
        }
    }
}

