/*
 * Decompiled with CFR 0.152.
 */
package com.fossnova.json;

import com.fossnova.json.JsonBoolean;
import com.fossnova.json.JsonNumber;
import com.fossnova.json.JsonString;
import com.fossnova.json.JsonStructure;
import com.fossnova.json.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;
import org.fossnova.json.JsonValue;
import org.fossnova.json.stream.JsonException;

final class JsonArray
extends JsonStructure
implements org.fossnova.json.JsonArray,
RandomAccess {
    private static final long serialVersionUID = 1L;
    private final List<JsonValue> list = new ArrayList<JsonValue>();

    JsonArray() {
    }

    public boolean add(String value) {
        return this.list.add((JsonValue)this.toJsonString(value));
    }

    public boolean add(Number value) {
        return this.list.add((JsonValue)this.toJsonNumber(value));
    }

    public boolean add(Boolean value) {
        return this.list.add((JsonValue)this.toJsonBoolean(value));
    }

    public boolean add(JsonValue value) {
        return this.list.add(value);
    }

    public boolean addNull() {
        return this.list.add(null);
    }

    public void add(int index, String value) {
        this.list.add(index, (JsonValue)this.toJsonString(value));
    }

    public void add(int index, Number value) {
        this.list.add(index, (JsonValue)this.toJsonNumber(value));
    }

    public void add(int index, Boolean value) {
        this.list.add(index, (JsonValue)this.toJsonBoolean(value));
    }

    public void add(int index, JsonValue value) {
        this.list.add(index, value);
    }

    public void addNull(int index) {
        this.list.add(index, null);
    }

    public boolean addAll(Collection<? extends JsonValue> values) {
        return this.list.addAll(values);
    }

    public boolean addAll(int index, Collection<? extends JsonValue> values) {
        return this.list.addAll(index, values);
    }

    public boolean contains(String value) {
        return this.list.contains(this.toJsonString(value));
    }

    public boolean contains(Number value) {
        return this.list.contains(this.toJsonNumber(value));
    }

    public boolean contains(Boolean value) {
        return this.list.contains(this.toJsonBoolean(value));
    }

    public boolean contains(JsonValue value) {
        return this.list.contains(value);
    }

    public boolean containsNull() {
        return this.list.contains(null);
    }

    public boolean contains(Object value) {
        if (value instanceof String) {
            return this.contains((String)value);
        }
        if (value instanceof Number) {
            return this.contains((Number)value);
        }
        if (value instanceof Boolean) {
            return this.contains((Boolean)value);
        }
        return value == null ? this.containsNull() : this.contains((JsonValue)value);
    }

    public boolean containsAll(Collection<?> values) {
        for (Object o : values) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    public int indexOf(String value) {
        return this.list.indexOf(this.toJsonString(value));
    }

    public int indexOf(Number value) {
        return this.list.indexOf(this.toJsonNumber(value));
    }

    public int indexOf(Boolean value) {
        return this.list.indexOf(this.toJsonBoolean(value));
    }

    public int indexOf(JsonValue value) {
        return this.list.indexOf(value);
    }

    public int indexOfNull() {
        return this.list.indexOf(null);
    }

    public int indexOf(Object value) {
        if (value instanceof String) {
            return this.indexOf((String)value);
        }
        if (value instanceof Number) {
            return this.indexOf((Number)value);
        }
        if (value instanceof Boolean) {
            return this.indexOf((Boolean)value);
        }
        return value == null ? this.indexOfNull() : this.indexOf((JsonValue)value);
    }

    public int lastIndexOf(String value) {
        return this.list.lastIndexOf(this.toJsonString(value));
    }

    public int lastIndexOf(Number value) {
        return this.list.lastIndexOf(this.toJsonNumber(value));
    }

    public int lastIndexOf(Boolean value) {
        return this.list.lastIndexOf(this.toJsonBoolean(value));
    }

    public int lastIndexOf(JsonValue value) {
        return this.list.lastIndexOf(value);
    }

    public int lastIndexOfNull() {
        return this.list.lastIndexOf(null);
    }

    public int lastIndexOf(Object value) {
        if (value instanceof String) {
            return this.lastIndexOf((String)value);
        }
        if (value instanceof Number) {
            return this.lastIndexOf((Number)value);
        }
        if (value instanceof Boolean) {
            return this.lastIndexOf((Boolean)value);
        }
        return value == null ? this.lastIndexOfNull() : this.lastIndexOf((JsonValue)value);
    }

    public Iterator<JsonValue> iterator() {
        return this.list.iterator();
    }

    public JsonValue get(int index) {
        return this.list.get(index);
    }

    public boolean remove(String value) {
        return this.list.remove(this.toJsonString(value));
    }

    public boolean remove(Number value) {
        return this.list.remove(this.toJsonNumber(value));
    }

    public boolean remove(Boolean value) {
        return this.list.remove(this.toJsonBoolean(value));
    }

    public boolean remove(JsonValue value) {
        return this.list.remove(value);
    }

    public boolean removeNull() {
        return this.list.remove(null);
    }

    public boolean remove(Object value) {
        if (value instanceof String) {
            return this.remove((String)value);
        }
        if (value instanceof Number) {
            return this.remove((Number)value);
        }
        if (value instanceof Boolean) {
            return this.remove((Boolean)value);
        }
        return value == null ? this.removeNull() : this.remove((JsonValue)value);
    }

    public JsonValue remove(int index) {
        return this.list.remove(index);
    }

    public boolean removeAll(Collection<?> values) {
        return this.list.removeAll(this.toJsonValuesCollection(values));
    }

    public int size() {
        return this.list.size();
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public void clear() {
        this.list.clear();
    }

    public JsonValue set(int index, String value) {
        return this.list.set(index, (JsonValue)this.toJsonString(value));
    }

    public JsonValue set(int index, Number value) {
        return this.list.set(index, (JsonValue)this.toJsonNumber(value));
    }

    public JsonValue set(int index, Boolean value) {
        return this.list.set(index, (JsonValue)this.toJsonBoolean(value));
    }

    public JsonValue set(int index, JsonValue value) {
        return this.list.set(index, value);
    }

    public JsonValue setNull(int index) {
        return this.list.set(index, null);
    }

    public ListIterator<JsonValue> listIterator() {
        return this.list.listIterator();
    }

    public ListIterator<JsonValue> listIterator(int index) {
        return this.list.listIterator(index);
    }

    public JsonValue[] toArray() {
        return this.list.toArray(new JsonValue[this.list.size()]);
    }

    public <T> T[] toArray(T[] a) {
        return this.list.toArray(a);
    }

    public boolean retainAll(Collection<?> values) {
        return this.list.retainAll(this.toJsonValuesCollection(values));
    }

    public List<JsonValue> subList(int fromIndex, int toIndex) {
        return this.list.subList(fromIndex, toIndex);
    }

    public int hashCode() {
        return this.list.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JsonArray)) {
            return false;
        }
        JsonArray a = (JsonArray)o;
        return this.list.equals(a.list);
    }

    @Override
    public JsonArray clone() {
        JsonArray retVal = new JsonArray();
        for (JsonValue jsonValue : this.list) {
            retVal.add(jsonValue != null ? jsonValue.clone() : null);
        }
        return retVal;
    }

    public String toString() {
        return this.list.toString();
    }

    @Override
    protected void writeTo(JsonWriter jsonWriter) throws IOException, JsonException {
        jsonWriter.writeArrayStart();
        for (JsonValue jsonValue : this.list) {
            if (jsonValue instanceof JsonString) {
                jsonWriter.writeString(((JsonString)jsonValue).getString());
                continue;
            }
            if (jsonValue instanceof JsonNumber) {
                jsonWriter.writeNumber(jsonValue.toString());
                continue;
            }
            if (jsonValue instanceof JsonBoolean) {
                jsonWriter.writeBoolean(((JsonBoolean)jsonValue).getBoolean());
                continue;
            }
            if (jsonValue instanceof JsonStructure) {
                ((JsonStructure)jsonValue).writeTo(jsonWriter);
                continue;
            }
            if (jsonValue == null) {
                jsonWriter.writeNull();
                continue;
            }
            throw new IllegalStateException();
        }
        jsonWriter.writeArrayEnd();
        jsonWriter.flush();
    }
}

