/*
 * Decompiled with CFR 0.152.
 */
package com.fossnova.json;

import com.fossnova.json.JsonBoolean;
import com.fossnova.json.JsonNumber;
import com.fossnova.json.JsonString;
import com.fossnova.json.JsonStructure;
import com.fossnova.json.stream.JsonWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.fossnova.json.JsonValue;
import org.fossnova.json.stream.JsonException;

final class JsonObject
extends JsonStructure
implements org.fossnova.json.JsonObject {
    private static final long serialVersionUID = 1L;
    private final Map<String, JsonValue> map = new HashMap<String, JsonValue>();

    JsonObject() {
    }

    public JsonValue put(String key, String value) {
        return this.putInternal(key, (JsonValue)this.toJsonString(value));
    }

    public JsonValue put(String key, Boolean value) {
        return this.putInternal(key, (JsonValue)this.toJsonBoolean(value));
    }

    public JsonValue put(String key, Number value) {
        return this.putInternal(key, (JsonValue)this.toJsonNumber(value));
    }

    public JsonValue put(String key, JsonValue value) {
        return this.putInternal(key, value);
    }

    public JsonValue putNull(String key) {
        return this.putInternal(key, null);
    }

    public boolean containsKey(Object key) {
        return this.containsKey((String)key);
    }

    public boolean containsKey(String key) {
        return this.map.containsKey(key);
    }

    public boolean containsValue(Object value) {
        if (value instanceof String) {
            return this.containsValue((String)value);
        }
        if (value instanceof Number) {
            return this.containsValue((Number)value);
        }
        if (value instanceof Boolean) {
            return this.containsValue((Boolean)value);
        }
        return value == null ? this.containsNullValue() : this.containsValue((JsonValue)value);
    }

    public boolean containsValue(Boolean value) {
        return this.map.containsValue(this.toJsonBoolean(value));
    }

    public boolean containsValue(Number value) {
        return this.map.containsValue(this.toJsonNumber(value));
    }

    public boolean containsValue(String value) {
        return this.map.containsValue(this.toJsonString(value));
    }

    public boolean containsValue(JsonValue value) {
        return this.map.containsValue(value);
    }

    public boolean containsNullValue() {
        return this.map.containsValue(null);
    }

    public Collection<JsonValue> values() {
        return this.map.values();
    }

    public Set<Map.Entry<String, JsonValue>> entrySet() {
        return this.map.entrySet();
    }

    public Set<String> keySet() {
        return this.map.keySet();
    }

    public JsonValue get(String key) {
        return this.map.get(key);
    }

    public JsonValue get(Object key) {
        return this.get((String)key);
    }

    public JsonValue remove(String key) {
        return this.map.remove(key);
    }

    public JsonValue remove(Object key) {
        return this.remove((String)key);
    }

    public void putAll(Map<? extends String, ? extends JsonValue> jsonObject) {
        this.map.putAll(jsonObject);
    }

    public void clear() {
        this.map.clear();
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JsonObject)) {
            return false;
        }
        JsonObject a = (JsonObject)o;
        return this.map.equals(a.map);
    }

    public String toString() {
        return this.map.toString();
    }

    @Override
    public JsonObject clone() {
        JsonObject retVal = new JsonObject();
        Iterator<String> iterator = this.map.keySet().iterator();
        while (iterator.hasNext()) {
            String jsonKey;
            JsonValue jsonValue = this.map.get(jsonKey = iterator.next());
            retVal.put(jsonKey, jsonValue != null ? jsonValue.clone() : null);
        }
        return retVal;
    }

    @Override
    protected void writeTo(JsonWriter jsonWriter) throws IOException, JsonException {
        jsonWriter.writeObjectStart();
        for (String jsonKey : this.map.keySet()) {
            jsonWriter.writeString(jsonKey);
            JsonValue jsonValue = this.map.get(jsonKey);
            if (jsonValue instanceof JsonBoolean) {
                jsonWriter.writeBoolean(((JsonBoolean)jsonValue).getBoolean());
                continue;
            }
            if (jsonValue instanceof JsonNumber) {
                jsonWriter.writeNumber(jsonValue.toString());
                continue;
            }
            if (jsonValue instanceof JsonString) {
                jsonWriter.writeString(((JsonString)jsonValue).getString());
                continue;
            }
            if (jsonValue instanceof JsonStructure) {
                ((JsonStructure)jsonValue).writeTo(jsonWriter);
                continue;
            }
            if (jsonValue == null) {
                jsonWriter.writeNull();
                continue;
            }
            throw new IllegalStateException();
        }
        jsonWriter.writeObjectEnd();
        jsonWriter.flush();
    }

    JsonValue putInternal(String key, JsonValue value) {
        if (key == null) {
            throw new NullPointerException("JSON key cannot be null");
        }
        return this.map.put(key, value);
    }
}

