/*
 * Decompiled with CFR 0.152.
 */
package com.fossnova.json;

import com.fossnova.json.JsonBoolean;
import com.fossnova.json.JsonNumber;
import com.fossnova.json.JsonString;
import com.fossnova.json.stream.JsonWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashSet;
import org.fossnova.json.JsonValue;
import org.fossnova.json.stream.JsonException;
import org.fossnova.json.stream.JsonStreamFactory;

abstract class JsonStructure
implements JsonValue {
    private static final long serialVersionUID = 1L;

    JsonStructure() {
    }

    public final void writeTo(org.fossnova.json.stream.JsonWriter output) throws IOException, JsonException {
        JsonStructure.assertNotNullParameter(output);
        this.writeTo((JsonWriter)output);
    }

    public final void writeTo(Writer output) throws IOException, JsonException {
        JsonStructure.assertNotNullParameter(output);
        this.writeTo(JsonStreamFactory.getInstance().newJsonWriter(output));
    }

    public final void writeTo(OutputStream output) throws IOException, JsonException {
        JsonStructure.assertNotNullParameter(output);
        this.writeTo(JsonStreamFactory.getInstance().newJsonWriter(output));
    }

    public final void writeTo(OutputStream output, Charset charset) throws IOException, JsonException {
        JsonStructure.assertNotNullParameter(output);
        JsonStructure.assertNotNullParameter(charset);
        this.writeTo(JsonStreamFactory.getInstance().newJsonWriter(output, charset));
    }

    protected abstract void writeTo(JsonWriter var1) throws IOException, JsonException;

    final JsonString toJsonString(String value) {
        return value != null ? new JsonString(value) : null;
    }

    final JsonBoolean toJsonBoolean(Boolean value) {
        return value != null ? new JsonBoolean(value) : null;
    }

    final JsonNumber toJsonNumber(Number value) {
        if (value instanceof Byte) {
            return new JsonNumber(value.byteValue());
        }
        if (value instanceof Short) {
            return new JsonNumber(value.shortValue());
        }
        if (value instanceof Integer) {
            return new JsonNumber(value.intValue());
        }
        if (value instanceof Long) {
            return new JsonNumber(value.longValue());
        }
        if (value instanceof Float) {
            return new JsonNumber(value.floatValue());
        }
        if (value instanceof Double) {
            return new JsonNumber(value.doubleValue());
        }
        if (value instanceof BigInteger) {
            return new JsonNumber((BigInteger)value);
        }
        if (value instanceof BigDecimal) {
            return new JsonNumber((BigDecimal)value);
        }
        if (value == null) {
            return null;
        }
        throw new IllegalStateException();
    }

    final Collection<JsonValue> toJsonValuesCollection(Collection<?> values) {
        if (values == null) {
            return null;
        }
        HashSet<JsonValue> jsonValues = new HashSet<JsonValue>();
        for (Object value : values) {
            if (value instanceof String) {
                jsonValues.add((JsonValue)this.toJsonString((String)value));
                continue;
            }
            if (value instanceof Number) {
                jsonValues.add((JsonValue)this.toJsonNumber((Number)value));
                continue;
            }
            if (value instanceof Boolean) {
                jsonValues.add((JsonValue)this.toJsonBoolean((Boolean)value));
                continue;
            }
            jsonValues.add((JsonValue)value);
        }
        return jsonValues;
    }

    public JsonStructure clone() {
        throw new UnsupportedOperationException();
    }

    private static void assertNotNullParameter(Object o) {
        if (o == null) {
            throw new NullPointerException("Parameter cannot be null");
        }
    }
}

