/*
 * Decompiled with CFR 0.152.
 */
package com.fossnova.json;

import com.fossnova.json.JsonArray;
import com.fossnova.json.JsonBoolean;
import com.fossnova.json.JsonNumber;
import com.fossnova.json.JsonObject;
import com.fossnova.json.JsonString;
import com.fossnova.json.stream.JsonReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import org.fossnova.json.JsonValue;
import org.fossnova.json.stream.JsonEvent;
import org.fossnova.json.stream.JsonException;
import org.fossnova.json.stream.JsonStreamFactory;

public final class JsonValueFactory
extends org.fossnova.json.JsonValueFactory {
    public JsonObject newJsonObject() {
        return new JsonObject();
    }

    public JsonArray newJsonArray() {
        return new JsonArray();
    }

    public JsonBoolean newJsonBoolean(Boolean value) {
        JsonValueFactory.assertNotNullParameter(value);
        return new JsonBoolean(value);
    }

    public JsonNumber newJsonNumber(Number value) {
        JsonValueFactory.assertNotNullParameter(value);
        if (value instanceof Byte) {
            return new JsonNumber((Byte)value);
        }
        if (value instanceof Short) {
            return new JsonNumber((Short)value);
        }
        if (value instanceof Integer) {
            return new JsonNumber((Integer)value);
        }
        if (value instanceof Long) {
            return new JsonNumber((Long)value);
        }
        if (value instanceof Float) {
            return new JsonNumber(((Float)value).floatValue());
        }
        if (value instanceof Double) {
            return new JsonNumber((Double)value);
        }
        if (value instanceof BigInteger) {
            return new JsonNumber((BigInteger)value);
        }
        if (value instanceof BigDecimal) {
            return new JsonNumber((BigDecimal)value);
        }
        throw new IllegalStateException();
    }

    public JsonString newJsonString(String value) {
        JsonValueFactory.assertNotNullParameter(value);
        return new JsonString(value);
    }

    public JsonValue readFrom(org.fossnova.json.stream.JsonReader input) throws IOException, JsonException {
        JsonValueFactory.assertNotNullParameter(input);
        return this.readFrom((JsonReader)input);
    }

    public JsonValue readFrom(Reader input) throws IOException, JsonException {
        JsonValueFactory.assertNotNullParameter(input);
        return this.readFrom(JsonStreamFactory.getInstance().newJsonReader(input));
    }

    public JsonValue readFrom(String input) throws IOException, JsonException {
        JsonValueFactory.assertNotNullParameter(input);
        return this.readFrom(new StringReader(input));
    }

    public JsonValue readFrom(InputStream input) throws IOException, JsonException {
        JsonValueFactory.assertNotNullParameter(input);
        return this.readFrom(JsonStreamFactory.getInstance().newJsonReader(input));
    }

    public JsonValue readFrom(InputStream input, Charset charset) throws IOException, JsonException {
        JsonValueFactory.assertNotNullParameter(input);
        JsonValueFactory.assertNotNullParameter(charset);
        return this.readFrom(JsonStreamFactory.getInstance().newJsonReader(input, charset));
    }

    private JsonValue readFrom(JsonReader jsonReader) throws IOException, JsonException {
        JsonEvent jsonEvent = jsonReader.next();
        if (jsonEvent == JsonEvent.OBJECT_START) {
            return this.readJsonObjectFrom(jsonReader);
        }
        if (jsonEvent == JsonEvent.ARRAY_START) {
            return this.readJsonArrayFrom(jsonReader);
        }
        if (jsonEvent == JsonEvent.STRING) {
            return new JsonString(jsonReader.getString());
        }
        if (jsonEvent == JsonEvent.NUMBER) {
            return new JsonNumber(jsonReader.getNumber());
        }
        if (jsonEvent == JsonEvent.BOOLEAN) {
            return new JsonBoolean(jsonReader.getBoolean());
        }
        if (jsonEvent == JsonEvent.NULL) {
            return null;
        }
        throw new IllegalStateException();
    }

    private JsonObject readJsonObjectFrom(JsonReader jsonReader) throws IOException, JsonException {
        JsonObject jsonObject = this.newJsonObject();
        JsonEvent jsonEvent = jsonReader.next();
        while (jsonEvent != JsonEvent.OBJECT_END) {
            Object jsonValue;
            String jsonKey = jsonReader.getString();
            jsonEvent = jsonReader.next();
            if (jsonEvent == JsonEvent.STRING) {
                jsonValue = new JsonString(jsonReader.getString());
            } else if (jsonEvent == JsonEvent.NUMBER) {
                jsonValue = new JsonNumber(jsonReader.getNumber());
            } else if (jsonEvent == JsonEvent.BOOLEAN) {
                jsonValue = new JsonBoolean(jsonReader.getBoolean());
            } else if (jsonEvent == JsonEvent.NULL) {
                jsonValue = null;
            } else if (jsonEvent == JsonEvent.OBJECT_START) {
                jsonValue = this.readJsonObjectFrom(jsonReader);
            } else if (jsonEvent == JsonEvent.ARRAY_START) {
                jsonValue = this.readJsonArrayFrom(jsonReader);
            } else {
                throw new IllegalStateException();
            }
            jsonObject.putInternal(jsonKey, (JsonValue)jsonValue);
            jsonEvent = jsonReader.next();
        }
        return jsonObject;
    }

    private JsonArray readJsonArrayFrom(JsonReader jsonReader) throws IOException, JsonException {
        JsonArray jsonArray = this.newJsonArray();
        JsonEvent jsonEvent = jsonReader.next();
        while (jsonEvent != JsonEvent.ARRAY_END) {
            Object jsonValue;
            if (jsonEvent == JsonEvent.STRING) {
                jsonValue = new JsonString(jsonReader.getString());
            } else if (jsonEvent == JsonEvent.NUMBER) {
                jsonValue = new JsonNumber(jsonReader.getNumber());
            } else if (jsonEvent == JsonEvent.BOOLEAN) {
                jsonValue = new JsonBoolean(jsonReader.getBoolean());
            } else if (jsonEvent == JsonEvent.NULL) {
                jsonValue = null;
            } else if (jsonEvent == JsonEvent.OBJECT_START) {
                jsonValue = this.readJsonObjectFrom(jsonReader);
            } else if (jsonEvent == JsonEvent.ARRAY_START) {
                jsonValue = this.readJsonArrayFrom(jsonReader);
            } else {
                throw new IllegalStateException();
            }
            jsonArray.add((JsonValue)jsonValue);
            jsonEvent = jsonReader.next();
        }
        return jsonArray;
    }

    private static void assertNotNullParameter(Object o) {
        if (o == null) {
            throw new NullPointerException("Parameter cannot be null");
        }
    }
}

