/*
 * Decompiled with CFR 0.152.
 */
package com.fossnova.json.stream;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.Set;
import org.fossnova.json.stream.JsonEvent;
import org.fossnova.json.stream.JsonException;

final class JsonGrammarAnalyzer {
    private static final byte OBJECT_START = 1;
    private static final byte ARRAY_START = 2;
    private static final byte STRING = 4;
    private static final byte COLON = 8;
    private final Deque<Set<String>> jsonKeys = new ArrayDeque<Set<String>>();
    private byte[] stack = new byte[8];
    private boolean canWriteColon;
    private boolean canWriteComma;
    private int index;
    JsonEvent currentEvent;
    boolean finished;

    JsonGrammarAnalyzer() {
    }

    boolean isColonExpected() {
        return this.canWriteColon;
    }

    boolean isCommaExpected() {
        return this.canWriteComma;
    }

    void putObjectEnd() throws JsonException {
        if (this.finished || this.index == 0 || this.stack[this.index - 1] != 1 || this.currentEvent == null) {
            throw this.newJsonException(this.getExpectingTokensMessage());
        }
        this.currentEvent = JsonEvent.OBJECT_END;
        --this.index;
        if (this.index > 0) {
            if (this.stack[this.index - 1] == 8) {
                this.index -= 2;
                this.canWriteComma = true;
            } else if (this.stack[this.index - 1] == 2) {
                this.canWriteComma = true;
            }
        }
        this.jsonKeys.removeLast();
        if (this.index == 0) {
            this.finished = true;
        }
    }

    void putArrayEnd() throws JsonException {
        if (this.finished || this.index == 0 || this.stack[this.index - 1] != 2 || this.currentEvent == null) {
            throw this.newJsonException(this.getExpectingTokensMessage());
        }
        this.currentEvent = JsonEvent.ARRAY_END;
        --this.index;
        if (this.index > 0) {
            if (this.stack[this.index - 1] == 8) {
                this.index -= 2;
                this.canWriteComma = true;
            } else if (this.stack[this.index - 1] == 2) {
                this.canWriteComma = true;
            }
        } else {
            this.finished = true;
        }
    }

    void putNumber() throws JsonException {
        if (this.finished || this.canWriteComma || this.index != 0 && (this.stack[this.index - 1] & 0xA) == 0) {
            throw this.newJsonException(this.getExpectingTokensMessage());
        }
        this.currentEvent = JsonEvent.NUMBER;
        if (this.index == 0) {
            this.finished = true;
            return;
        }
        if (this.stack[this.index - 1] == 8) {
            this.index -= 2;
        }
        this.canWriteComma = true;
    }

    void putBoolean() throws JsonException {
        if (this.finished || this.canWriteComma || this.index != 0 && (this.stack[this.index - 1] & 0xA) == 0) {
            throw this.newJsonException(this.getExpectingTokensMessage());
        }
        this.currentEvent = JsonEvent.BOOLEAN;
        if (this.index == 0) {
            this.finished = true;
            return;
        }
        if (this.stack[this.index - 1] == 8) {
            this.index -= 2;
        }
        this.canWriteComma = true;
    }

    void putNull() throws JsonException {
        if (this.finished || this.canWriteComma || this.index != 0 && (this.stack[this.index - 1] & 0xA) == 0) {
            throw this.newJsonException(this.getExpectingTokensMessage());
        }
        this.currentEvent = JsonEvent.NULL;
        if (this.index == 0) {
            this.finished = true;
            return;
        }
        if (this.stack[this.index - 1] == 8) {
            this.index -= 2;
        }
        this.canWriteComma = true;
    }

    void putString() throws JsonException {
        if (this.finished || this.canWriteComma || this.index != 0 && (this.stack[this.index - 1] & 0xB) == 0) {
            throw this.newJsonException(this.getExpectingTokensMessage());
        }
        this.currentEvent = JsonEvent.STRING;
        if (this.index == 0) {
            this.finished = true;
            return;
        }
        if (this.stack[this.index - 1] == 1) {
            if (this.index == this.stack.length) {
                this.doubleStack();
            }
            this.stack[this.index++] = 4;
            this.canWriteColon = true;
            return;
        }
        if (this.stack[this.index - 1] == 8) {
            this.index -= 2;
        }
        this.canWriteComma = true;
    }

    void putKey(String jsonKey) throws JsonException {
        if (this.stack[this.index - 1] == 4 && !this.jsonKeys.getLast().add(jsonKey)) {
            throw this.newJsonException("JSON keys have to be unique. The key '" + jsonKey + "' already exists");
        }
    }

    void putObjectStart() throws JsonException {
        if (this.finished || this.canWriteComma || this.index != 0 && (this.stack[this.index - 1] & 0xA) == 0) {
            throw this.newJsonException(this.getExpectingTokensMessage());
        }
        this.currentEvent = JsonEvent.OBJECT_START;
        if (this.index == this.stack.length) {
            this.doubleStack();
        }
        this.stack[this.index++] = 1;
        this.jsonKeys.addLast(new HashSet());
    }

    void putArrayStart() throws JsonException {
        if (this.finished || this.canWriteComma || this.index != 0 && (this.stack[this.index - 1] & 0xA) == 0) {
            throw this.newJsonException(this.getExpectingTokensMessage());
        }
        this.currentEvent = JsonEvent.ARRAY_START;
        if (this.index == this.stack.length) {
            this.doubleStack();
        }
        this.stack[this.index++] = 2;
    }

    void putColon() throws JsonException {
        if (this.finished || !this.canWriteColon) {
            throw this.newJsonException(this.getExpectingTokensMessage());
        }
        this.currentEvent = null;
        if (this.index == this.stack.length) {
            this.doubleStack();
        }
        this.stack[this.index++] = 8;
        this.canWriteColon = false;
    }

    void putComma() throws JsonException {
        if (this.finished || !this.canWriteComma) {
            throw this.newJsonException(this.getExpectingTokensMessage());
        }
        this.currentEvent = null;
        this.canWriteComma = false;
    }

    private String getExpectingTokensMessage() {
        if (this.index == 0) {
            if (!this.finished) {
                return "Expecting { [";
            }
            return "JSON processing finished";
        }
        if (this.stack[this.index - 1] == 1) {
            if (!this.canWriteComma) {
                return "Expecting } STRING";
            }
            return "Expecting , }";
        }
        if (this.stack[this.index - 1] == 2) {
            if (!this.canWriteComma) {
                if (this.currentEvent != null) {
                    return "Expecting ] { [ STRING NUMBER true false null";
                }
                return "Expecting { [ STRING NUMBER true false null";
            }
            return "Expecting , ]";
        }
        if (this.stack[this.index - 1] == 8) {
            return "Expecting { [ STRING NUMBER true false null";
        }
        if (this.stack[this.index - 1] == 4) {
            return "Expecting :";
        }
        throw new IllegalStateException();
    }

    private void doubleStack() {
        byte[] oldData = this.stack;
        this.stack = new byte[oldData.length * 2];
        System.arraycopy(oldData, 0, this.stack, 0, oldData.length);
    }

    void close(boolean write) throws JsonException {
        if (!this.finished) {
            throw this.newJsonException("Detected attempt to " + (write ? "write" : "read") + " uncomplete JSON stream");
        }
        this.currentEvent = null;
    }

    JsonException newJsonException(String s) {
        this.finished = true;
        this.currentEvent = null;
        return new JsonException(s);
    }
}

