/*
 * Decompiled with CFR 0.152.
 */
package com.fossnova.json.stream;

import com.fossnova.json.stream.JsonGrammarAnalyzer;
import com.fossnova.json.stream.Utils;
import java.io.IOException;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.fossnova.json.stream.JsonEvent;
import org.fossnova.json.stream.JsonException;

public final class JsonReader
implements org.fossnova.json.stream.JsonReader {
    private static final char[] NULL = "null".toCharArray();
    private static final char[] TRUE = "true".toCharArray();
    private static final char[] FALSE = "false".toCharArray();
    private final Reader in;
    private final JsonGrammarAnalyzer analyzer;
    private char[] buffer = new char[1024];
    private int position;
    private int limit;
    private int numberOffset;
    private int numberLength;
    private int stringOffset;
    private int stringLength;
    private boolean jsonBoolean;
    private boolean closed;

    JsonReader(Reader in) {
        this.in = in;
        this.analyzer = new JsonGrammarAnalyzer();
    }

    public void close() throws IOException, JsonException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            this.analyzer.close(false);
        }
        finally {
            this.in.close();
        }
    }

    public boolean getBoolean() {
        if (this.analyzer.currentEvent != JsonEvent.BOOLEAN) {
            throw new IllegalStateException();
        }
        return this.jsonBoolean;
    }

    public String getNumber() {
        if (this.analyzer.currentEvent != JsonEvent.NUMBER) {
            throw new IllegalStateException();
        }
        return new String(this.buffer, this.numberOffset, this.numberLength);
    }

    public String getString() {
        if (this.analyzer.currentEvent != JsonEvent.STRING) {
            throw new IllegalStateException();
        }
        return new String(this.buffer, this.stringOffset, this.stringLength);
    }

    public byte getByte() {
        return Byte.parseByte(this.getNumber());
    }

    public short getShort() {
        return Short.parseShort(this.getNumber());
    }

    public int getInt() {
        return Integer.parseInt(this.getNumber());
    }

    public long getLong() {
        return Long.parseLong(this.getNumber());
    }

    public BigInteger getBigInteger() {
        return new BigInteger(this.getNumber());
    }

    public BigDecimal getBigDecimal() {
        return new BigDecimal(this.getNumber());
    }

    public float getFloat() {
        return Float.parseFloat(this.getNumber());
    }

    public double getDouble() {
        return Double.parseDouble(this.getNumber());
    }

    public boolean isArrayEnd() {
        return this.analyzer.currentEvent == JsonEvent.ARRAY_END;
    }

    public boolean isArrayStart() {
        return this.analyzer.currentEvent == JsonEvent.ARRAY_START;
    }

    public boolean isNumber() {
        return this.analyzer.currentEvent == JsonEvent.NUMBER;
    }

    public boolean isObjectEnd() {
        return this.analyzer.currentEvent == JsonEvent.OBJECT_END;
    }

    public boolean isObjectStart() {
        return this.analyzer.currentEvent == JsonEvent.OBJECT_START;
    }

    public boolean isString() {
        return this.analyzer.currentEvent == JsonEvent.STRING;
    }

    public boolean isNull() {
        return this.analyzer.currentEvent == JsonEvent.NULL;
    }

    public boolean isBoolean() {
        return this.analyzer.currentEvent == JsonEvent.BOOLEAN;
    }

    public boolean hasNext() {
        return !this.analyzer.finished;
    }

    public JsonEvent next() throws IOException, JsonException {
        int currentChar;
        this.ensureOpen();
        if (this.analyzer.finished && !this.hasMoreData()) {
            throw new IllegalStateException("No more JSON tokens available");
        }
        block12: while (true) {
            currentChar = this.position < this.limit ? this.buffer[this.position++] : this.read();
            switch (currentChar) {
                case 34: {
                    this.analyzer.putString();
                    this.readString();
                    if (this.analyzer.isColonExpected()) {
                        this.analyzer.putKey(this.getString());
                    }
                    return this.analyzer.currentEvent;
                }
                case 58: {
                    this.analyzer.putColon();
                    continue block12;
                }
                case 44: {
                    this.analyzer.putComma();
                    continue block12;
                }
                case 45: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    this.analyzer.putNumber();
                    this.numberOffset = this.position - 1;
                    this.readNumber();
                    return this.analyzer.currentEvent;
                }
                case 102: 
                case 116: {
                    this.analyzer.putBoolean();
                    this.jsonBoolean = currentChar == 116;
                    this.readString(this.jsonBoolean ? TRUE : FALSE);
                    return this.analyzer.currentEvent;
                }
                case 110: {
                    this.analyzer.putNull();
                    this.readString(NULL);
                    return this.analyzer.currentEvent;
                }
                case 123: {
                    this.analyzer.putObjectStart();
                    return this.analyzer.currentEvent;
                }
                case 91: {
                    this.analyzer.putArrayStart();
                    return this.analyzer.currentEvent;
                }
                case 125: {
                    this.analyzer.putObjectEnd();
                    return this.analyzer.currentEvent;
                }
                case 93: {
                    this.analyzer.putArrayEnd();
                    return this.analyzer.currentEvent;
                }
            }
            if (!Utils.isWhitespace(currentChar)) break;
            this.processWhitespaces();
        }
        if (currentChar >= 0) {
            throw this.newJsonException("Unexpected character '" + Utils.toUnicodeString(currentChar) + "' while reading JSON stream");
        }
        throw this.newJsonException("Unexpected EOF while reading JSON stream");
    }

    private void processWhitespaces() throws IOException {
        do {
            if (this.position == this.limit) {
                this.limit = 0;
                this.position = 0;
                this.fillBuffer();
                if (this.position != this.limit) continue;
                return;
            }
            if (this.position != this.limit - 1) continue;
            this.buffer[0] = this.buffer[this.position];
            this.limit = 1;
            this.position = 0;
            this.fillBuffer();
        } while (Utils.isWhitespace(this.buffer[this.position++]));
        --this.position;
    }

    private boolean hasMoreData() throws IOException {
        if (this.position == this.limit) {
            if (this.limit == this.buffer.length) {
                this.limit = 0;
                this.position = 0;
            }
            this.fillBuffer();
        }
        return this.position != this.limit;
    }

    private void fillBuffer() throws IOException {
        do {
            int read;
            if ((read = this.in.read(this.buffer, this.limit, this.buffer.length - this.limit)) == -1) {
                return;
            }
            this.limit += read;
        } while (this.limit != this.buffer.length);
    }

    private int read() throws IOException {
        return this.hasMoreData() ? this.buffer[this.position++] : -1;
    }

    private void readString() throws IOException, JsonException {
        boolean escaped = false;
        this.stringLength = 0;
        boolean copy = false;
        do {
            if (this.stringLength == 0) {
                this.stringOffset = this.position;
            }
            while (this.position != this.limit) {
                char currentChar = this.buffer[this.position++];
                if (escaped) {
                    copy = true;
                    if (currentChar == 'b') {
                        this.buffer[this.stringOffset + this.stringLength++] = 8;
                    } else if (currentChar == 'f') {
                        this.buffer[this.stringOffset + this.stringLength++] = 12;
                    } else if (currentChar == 'n') {
                        this.buffer[this.stringOffset + this.stringLength++] = 10;
                    } else if (currentChar == 'r') {
                        this.buffer[this.stringOffset + this.stringLength++] = 13;
                    } else if (currentChar == 't') {
                        this.buffer[this.stringOffset + this.stringLength++] = 9;
                    } else if (currentChar == '\"') {
                        this.buffer[this.stringOffset + this.stringLength++] = 34;
                    } else if (currentChar == '/') {
                        this.buffer[this.stringOffset + this.stringLength++] = 47;
                    } else if (currentChar == '\\') {
                        this.buffer[this.stringOffset + this.stringLength++] = 92;
                    } else if (currentChar == 'u') {
                        if (this.limit - this.position >= 4) {
                            try {
                                this.buffer[this.stringOffset + this.stringLength++] = (char)Integer.parseInt(new String(this.buffer, this.position, 4), 16);
                            }
                            catch (NumberFormatException e) {
                                throw this.newJsonException("Invalid JSON unicode sequence. Expecting 4 hexadecimal digits but got '" + new String(this.buffer, this.position, 4) + "'");
                            }
                            this.position += 4;
                        } else {
                            if (this.stringOffset != 0) {
                                if (this.stringLength > 0) {
                                    System.arraycopy(this.buffer, this.stringOffset, this.buffer, 0, this.stringLength);
                                }
                                this.position = this.stringLength;
                                this.limit = this.stringLength;
                                this.stringOffset = 0;
                            }
                            while (this.limit + 4 > this.buffer.length) {
                                this.doubleBuffer();
                            }
                            this.fillBuffer();
                            if (this.limit - this.position < 4) {
                                throw this.newJsonException("Unexpected EOF while reading JSON string");
                            }
                            try {
                                this.buffer[this.stringOffset + this.stringLength++] = (char)Integer.parseInt(new String(this.buffer, this.position, 4), 16);
                            }
                            catch (NumberFormatException e) {
                                throw this.newJsonException("Invalid JSON unicode sequence. Expecting 4 hexadecimal digits but got '" + new String(this.buffer, this.position, 4) + "'");
                            }
                            this.position += 4;
                        }
                    } else {
                        throw this.newJsonException("Unexpected character '" + Utils.toUnicodeString(currentChar) + "' after escape character while reading JSON string");
                    }
                    escaped = false;
                    continue;
                }
                if (currentChar == '\"') {
                    return;
                }
                if (currentChar == '\\') {
                    escaped = true;
                    continue;
                }
                if (Utils.isControl(currentChar)) {
                    throw this.newJsonException("Unexpected control character '" + Utils.toUnicodeString(currentChar) + "' while reading JSON string");
                }
                if (copy) {
                    this.buffer[this.stringOffset + this.stringLength] = currentChar;
                }
                ++this.stringLength;
            }
            if (this.stringOffset != 0 && this.stringLength > 0) {
                System.arraycopy(this.buffer, this.stringOffset, this.buffer, 0, this.stringLength);
                this.position = this.stringLength;
                this.limit = this.stringLength;
                this.stringOffset = 0;
                continue;
            }
            if (this.stringOffset != 0 || this.limit != this.buffer.length) continue;
            this.doubleBuffer();
        } while (this.hasMoreData());
        throw this.newJsonException("Unexpected EOF while reading JSON string");
    }

    private void readString(char[] expected) throws IOException, JsonException {
        int i;
        if (this.position < this.limit - expected.length + 1) {
            for (i = 1; i < expected.length; ++i) {
                if (this.buffer[this.position++] == expected[i]) continue;
                throw this.newJsonException("Unexpected character '" + Utils.toUnicodeString(this.buffer[--this.position]) + "' while reading JSON " + new String(expected) + " token");
            }
        } else {
            while (true) {
                if (this.position < this.limit && i != expected.length) {
                    if (this.buffer[this.position++] == expected[i++]) continue;
                    throw this.newJsonException("Unexpected character '" + Utils.toUnicodeString(this.buffer[this.position - 1]) + "' while reading JSON " + new String(expected) + " token");
                }
                if (i == expected.length) {
                    return;
                }
                if (!this.hasMoreData()) break;
            }
            throw this.newJsonException("Unexpected EOF while reading JSON " + new String(expected) + " token");
        }
    }

    private void readNumber() throws IOException, JsonException {
        while (true) {
            if (this.position < this.limit) {
                if (Utils.isNumberChar(this.buffer[this.position++])) continue;
                --this.position;
            }
            this.numberLength = this.position - this.numberOffset;
            if (this.position < this.limit) break;
            if (this.numberOffset != 0) {
                System.arraycopy(this.buffer, this.numberOffset, this.buffer, 0, this.numberLength);
                this.position = this.numberLength;
                this.limit = this.numberLength;
                this.numberOffset = 0;
            } else if (this.limit == this.buffer.length) {
                this.doubleBuffer();
            }
            if (!this.hasMoreData()) break;
        }
        if (!Utils.isNumberString(this.buffer, this.numberOffset, this.numberLength)) {
            throw this.newJsonException("Incorrect JSON number: '" + this.getNumber() + "'");
        }
    }

    private void doubleBuffer() {
        char[] oldData = this.buffer;
        this.buffer = new char[oldData.length * 2];
        System.arraycopy(oldData, 0, this.buffer, 0, oldData.length);
    }

    private JsonException newJsonException(String message) {
        return this.analyzer.newJsonException(message);
    }

    private void ensureOpen() {
        if (this.closed) {
            throw new IllegalStateException("JSON reader have been closed");
        }
    }
}

