/*
 * Decompiled with CFR 0.152.
 */
package com.fossnova.json.stream;

import com.fossnova.json.stream.JsonReader;
import com.fossnova.json.stream.JsonWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;

public final class JsonStreamFactory
extends org.fossnova.json.stream.JsonStreamFactory {
    private static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");

    public JsonReader newJsonReader(Reader reader) {
        JsonStreamFactory.assertNotNullParameter(reader);
        return new JsonReader(reader);
    }

    public JsonReader newJsonReader(InputStream stream) {
        return this.newJsonReader(stream, DEFAULT_CHARSET);
    }

    public JsonReader newJsonReader(InputStream stream, Charset charset) {
        JsonStreamFactory.assertNotNullParameter(stream);
        JsonStreamFactory.assertNotNullParameter(charset);
        return this.newJsonReader(new InputStreamReader(stream, charset));
    }

    public JsonWriter newJsonWriter(Writer writer) {
        JsonStreamFactory.assertNotNullParameter(writer);
        return new JsonWriter(writer);
    }

    public JsonWriter newJsonWriter(OutputStream stream) {
        return this.newJsonWriter(stream, DEFAULT_CHARSET);
    }

    public JsonWriter newJsonWriter(OutputStream stream, Charset charset) {
        JsonStreamFactory.assertNotNullParameter(stream);
        JsonStreamFactory.assertNotNullParameter(charset);
        return this.newJsonWriter(new OutputStreamWriter(stream, charset));
    }

    private static void assertNotNullParameter(Object o) {
        if (o == null) {
            throw new NullPointerException("Parameter cannot be null");
        }
    }
}

