/*
 * Decompiled with CFR 0.152.
 */
package com.fossnova.json.stream;

import com.fossnova.json.stream.JsonGrammarAnalyzer;
import com.fossnova.json.stream.Utils;
import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.fossnova.json.stream.JsonException;

public final class JsonWriter
implements org.fossnova.json.stream.JsonWriter {
    private final JsonGrammarAnalyzer analyzer;
    private final Writer out;
    private final char[] buffer = new char[1024];
    private int limit;
    private boolean closed;

    JsonWriter(Writer out) {
        this.out = out;
        this.analyzer = new JsonGrammarAnalyzer();
    }

    public void close() throws IOException, JsonException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            this.flush();
            this.analyzer.close(true);
        }
        finally {
            this.out.close();
        }
    }

    public void flush() throws IOException {
        if (this.limit > 0) {
            this.out.write(this.buffer, 0, this.limit);
            this.limit = 0;
            this.out.flush();
        }
    }

    public JsonWriter writeObjectStart() throws IOException, JsonException {
        this.writeOptionalColonOrComma();
        this.analyzer.putObjectStart();
        this.write('{');
        return this;
    }

    public JsonWriter writeObjectEnd() throws IOException, JsonException {
        this.analyzer.putObjectEnd();
        this.write('}');
        return this;
    }

    public JsonWriter writeArrayStart() throws IOException, JsonException {
        this.writeOptionalColonOrComma();
        this.analyzer.putArrayStart();
        this.write('[');
        return this;
    }

    public JsonWriter writeArrayEnd() throws IOException, JsonException {
        this.analyzer.putArrayEnd();
        this.write(']');
        return this;
    }

    public JsonWriter writeString(String data) throws IOException, JsonException {
        if (data == null) {
            throw new NullPointerException("Parameter cannot be null");
        }
        this.writeOptionalColonOrComma();
        this.analyzer.putString();
        if (this.analyzer.isColonExpected()) {
            this.analyzer.putKey(data);
        }
        this.encode(data);
        return this;
    }

    public JsonWriter writeNull() throws IOException, JsonException {
        this.writeOptionalColonOrComma();
        this.analyzer.putNull();
        if (this.limit + 4 > this.buffer.length) {
            this.out.write(this.buffer, 0, this.limit);
            this.limit = 0;
        }
        this.buffer[this.limit++] = 110;
        this.buffer[this.limit++] = 117;
        this.buffer[this.limit++] = 108;
        this.buffer[this.limit++] = 108;
        return this;
    }

    public JsonWriter writeBoolean(boolean data) throws IOException, JsonException {
        this.writeOptionalColonOrComma();
        this.analyzer.putBoolean();
        if (this.limit + 5 > this.buffer.length) {
            this.out.write(this.buffer, 0, this.limit);
            this.limit = 0;
        }
        if (data) {
            this.buffer[this.limit++] = 116;
            this.buffer[this.limit++] = 114;
            this.buffer[this.limit++] = 117;
            this.buffer[this.limit++] = 101;
        } else {
            this.buffer[this.limit++] = 102;
            this.buffer[this.limit++] = 97;
            this.buffer[this.limit++] = 108;
            this.buffer[this.limit++] = 115;
            this.buffer[this.limit++] = 101;
        }
        return this;
    }

    public JsonWriter writeByte(byte data) throws IOException, JsonException {
        this.writeOptionalColonOrComma();
        this.analyzer.putNumber();
        this.encode(data);
        return this;
    }

    public JsonWriter writeShort(short data) throws IOException, JsonException {
        this.writeOptionalColonOrComma();
        this.analyzer.putNumber();
        this.encode(data);
        return this;
    }

    public JsonWriter writeInt(int data) throws IOException, JsonException {
        this.writeOptionalColonOrComma();
        this.analyzer.putNumber();
        this.encode(data);
        return this;
    }

    public JsonWriter writeLong(long data) throws IOException, JsonException {
        this.writeOptionalColonOrComma();
        this.analyzer.putNumber();
        this.encode(data);
        return this;
    }

    public JsonWriter writeFloat(float data) throws IOException, JsonException {
        return this.writeNumber(String.valueOf(data));
    }

    public JsonWriter writeDouble(double data) throws IOException, JsonException {
        return this.writeNumber(String.valueOf(data));
    }

    public JsonWriter writeBigInteger(BigInteger data) throws IOException, JsonException {
        if (data == null) {
            throw new NullPointerException("Parameter cannot be null");
        }
        return this.writeNumber(String.valueOf(data));
    }

    public JsonWriter writeBigDecimal(BigDecimal data) throws IOException, JsonException {
        if (data == null) {
            throw new NullPointerException("Parameter cannot be null");
        }
        return this.writeNumber(String.valueOf(data));
    }

    public JsonWriter writeNumber(String data) throws IOException, JsonException {
        this.writeOptionalColonOrComma();
        this.analyzer.putNumber();
        this.write(data, 0, data.length());
        return this;
    }

    private void writeOptionalColonOrComma() throws IOException, JsonException {
        if (this.analyzer.isColonExpected()) {
            this.analyzer.putColon();
            this.write(':');
        } else if (this.analyzer.isCommaExpected()) {
            this.analyzer.putComma();
            this.write(',');
        }
    }

    private void write(char c) throws IOException {
        if (this.limit == this.buffer.length) {
            this.out.write(this.buffer, 0, this.limit);
            this.limit = 0;
        }
        this.buffer[this.limit++] = c;
    }

    private void write(String data, int dataBegin, int dataEnd) throws IOException {
        while (dataBegin < dataEnd) {
            int count = Math.min(dataEnd - dataBegin, this.buffer.length - this.limit);
            data.getChars(dataBegin, dataBegin + count, this.buffer, this.limit);
            dataBegin += count;
            this.limit += count;
            if (this.limit != this.buffer.length) continue;
            this.out.write(this.buffer, 0, this.buffer.length);
            this.limit = 0;
        }
    }

    private void encode(String s) throws IOException {
        this.write('\"');
        int dataBegin = 0;
        for (int dataEnd = 0; dataEnd < s.length(); ++dataEnd) {
            char c = s.charAt(dataEnd);
            while (c != '\\' && c != '\"' && !Utils.isControl(c) && ++dataEnd < s.length()) {
                c = s.charAt(dataEnd);
            }
            if (dataBegin < dataEnd) {
                this.write(s, dataBegin, dataEnd);
                if (dataEnd == s.length()) break;
            }
            dataBegin = dataEnd + 1;
            this.write('\\');
            if (c == '\\' || c == '\"') {
                this.write(c);
                continue;
            }
            if (c == '\b') {
                this.write('b');
                continue;
            }
            if (c == '\f') {
                this.write('f');
                continue;
            }
            if (c == '\n') {
                this.write('n');
                continue;
            }
            if (c == '\r') {
                this.write('r');
                continue;
            }
            if (c == '\t') {
                this.write('t');
                continue;
            }
            this.write('u');
            String hexString = Integer.toHexString(c);
            for (int j = 0; j < 4 - hexString.length(); ++j) {
                this.write('0');
            }
            this.write(hexString, 0, hexString.length());
        }
        this.write('\"');
    }

    private void encode(long l) throws IOException {
        int intQuotient;
        int remainder;
        boolean negative;
        int writeIndex;
        if (this.buffer.length - this.limit < 20) {
            this.out.write(this.buffer, 0, this.limit);
            this.limit = 0;
        }
        this.limit = writeIndex = this.limit + Utils.stringSizeOf(l);
        boolean bl = negative = l < 0L;
        if (!negative) {
            l = -l;
        }
        while (l < Integer.MIN_VALUE) {
            long longQuotient = l / 100L;
            remainder = (int)(longQuotient * 100L - l);
            l = longQuotient;
            this.buffer[--writeIndex] = Utils.ONES[remainder];
            this.buffer[--writeIndex] = Utils.TENS[remainder];
        }
        int i = (int)l;
        while (i <= -100) {
            intQuotient = i / 100;
            remainder = intQuotient * 100 - i;
            i = intQuotient;
            this.buffer[--writeIndex] = Utils.ONES[remainder];
            this.buffer[--writeIndex] = Utils.TENS[remainder];
        }
        intQuotient = i / 10;
        remainder = intQuotient * 10 - i;
        this.buffer[--writeIndex] = (char)(48 + remainder);
        if (intQuotient < 0) {
            this.buffer[--writeIndex] = (char)(48 - intQuotient);
        }
        if (negative) {
            this.buffer[--writeIndex] = 45;
        }
    }

    private void encode(int i) throws IOException {
        int remainder;
        int quotient;
        boolean negative;
        int writeIndex;
        if (this.buffer.length - this.limit < 11) {
            this.out.write(this.buffer, 0, this.limit);
            this.limit = 0;
        }
        this.limit = writeIndex = this.limit + Utils.stringSizeOf(i);
        boolean bl = negative = i < 0;
        if (!negative) {
            i = -i;
        }
        while (i <= -100) {
            quotient = i / 100;
            remainder = quotient * 100 - i;
            i = quotient;
            this.buffer[--writeIndex] = Utils.ONES[remainder];
            this.buffer[--writeIndex] = Utils.TENS[remainder];
        }
        quotient = i / 10;
        remainder = quotient * 10 - i;
        this.buffer[--writeIndex] = (char)(48 + remainder);
        if (quotient < 0) {
            this.buffer[--writeIndex] = (char)(48 - quotient);
        }
        if (negative) {
            this.buffer[--writeIndex] = 45;
        }
    }

    private void ensureOpen() {
        if (this.closed) {
            throw new IllegalStateException("JSON writer have been closed");
        }
    }
}

