/*
 * Decompiled with CFR 0.152.
 */
package com.fossnova.json.stream;

final class Utils {
    static final char[] ONES = new char[100];
    static final char[] TENS = new char[100];

    private Utils() {
    }

    static boolean isNumberString(char[] number, int offset, int length) {
        int startIndex = number[offset] == '-' ? offset + 1 : offset;
        int dotIndex = offset;
        int eIndex = offset;
        int limit = offset + length;
        for (int i = startIndex; i < limit; ++i) {
            if ('0' <= number[i] && number[i] <= '9') continue;
            if (number[i] == '.') {
                if (i == startIndex || i == limit - 1) {
                    return false;
                }
                if (dotIndex != offset || eIndex != offset) {
                    return false;
                }
                if (i - startIndex > 1 && number[startIndex] == '0') {
                    return false;
                }
                dotIndex = i;
                continue;
            }
            if (number[i] == 'e' || number[i] == 'E') {
                if (i == startIndex || i == limit - 1) {
                    return false;
                }
                if (eIndex != offset) {
                    return false;
                }
                if (i == limit - 2 && (number[i + 1] == '+' || number[i + 1] == '-')) {
                    return false;
                }
                if (dotIndex > offset && i - dotIndex == 1) {
                    return false;
                }
                if (dotIndex == offset && i - startIndex > 1 && number[startIndex] == '0') {
                    return false;
                }
                eIndex = i;
                if (i >= limit - 1 || number[i + 1] != '+' && number[i + 1] != '-') continue;
                ++i;
                continue;
            }
            return false;
        }
        if (dotIndex == offset && eIndex == offset && length - (startIndex - offset) > 1) {
            return number[startIndex] != '0';
        }
        return true;
    }

    static boolean isControl(int c) {
        return c <= 31 || c >= 127 && c <= 159;
    }

    static boolean isWhitespace(int c) {
        return c == 32 || c == 9 || c == 13 || c == 10;
    }

    static boolean isNumberChar(int c) {
        return 48 <= c && c <= 57 || c == 45 || c == 43 || c == 46 || c == 101 || c == 69;
    }

    static String toUnicodeString(int c) {
        StringBuilder sb = new StringBuilder();
        sb.append('\\').append('u');
        String hexString = Integer.toHexString(c);
        for (int j = 0; j < 4 - hexString.length(); ++j) {
            sb.append('0');
        }
        sb.append(hexString);
        return sb.toString();
    }

    static int stringSizeOf(long l) {
        int signSize = 1;
        if (l >= 0L) {
            signSize = 0;
            l = -l;
        }
        long temp = -10L;
        for (int j = 1; j < 19; ++j) {
            if (l > temp) {
                return j + signSize;
            }
            temp = 10L * temp;
        }
        return 19 + signSize;
    }

    static int stringSizeOf(int i) {
        int signSize = 1;
        if (i >= 0) {
            signSize = 0;
            i = -i;
        }
        int temp = -10;
        for (int j = 1; j < 10; ++j) {
            if (i > temp) {
                return j + signSize;
            }
            temp = 10 * temp;
        }
        return 10 + signSize;
    }

    static {
        for (int i = 0; i < 100; ++i) {
            Utils.ONES[i] = (char)(48 + i % 10);
            Utils.TENS[i] = (char)(48 + i / 10);
        }
    }
}

