/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.api;

import java.util.Iterator;
import org.gatein.api.GateIn;
import org.gatein.api.id.Id;
import org.gatein.api.portal.Navigation;
import org.gatein.api.portal.Page;
import org.gatein.api.portal.Portal;
import org.gatein.api.portal.Site;
import org.gatein.api.util.IterableIdentifiableCollection;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public abstract class NavigationPortletTestCase {
    protected GateIn gateIn;

    @BeforeTest
    public abstract void setUp();

    @Test
    public void shouldListSpecificGroupPages() {
        Id groupId = this.gateIn.groupId("platform", new String[]{"administrators"});
        Site adminSite = this.gateIn.getGroupSite(groupId);
        Navigation navigation = adminSite.getNavigation();
        IterableIdentifiableCollection adminNodes = navigation.getAll();
        assert (2 == adminNodes.size());
        Iterator iterator = adminNodes.iterator();
        Navigation administrationNode = (Navigation)iterator.next();
        assert ("Administration".equals(administrationNode.getDisplayName()));
        assert (2 == administrationNode.size());
        IterableIdentifiableCollection children = administrationNode.getAll();
        for (Navigation child : children) {
            assert (child.equals(administrationNode.get((Object)child.getName())));
            Page target = child.getTargetPage();
            assert (target.equals(this.gateIn.get(target.getId())));
            assert (target.getInboundNavigations().contains(child.getId()));
        }
        Navigation wsrp = (Navigation)iterator.next();
        assert ("WSRP".equals(wsrp.getDisplayName()));
        assert (1 == wsrp.size());
        assert (!iterator.hasNext());
    }

    @Test(enabled=false)
    public void shouldListGroupPages() {
        Id id = this.gateIn.userId("root");
        IterableIdentifiableCollection rootSites = this.gateIn.getGroupSites(id);
        assert (3 == rootSites.size());
        Iterator sites = rootSites.iterator();
        this.checkGroupSite((Site)sites.next(), 0, 2, "Administrators");
        this.checkGroupSite((Site)sites.next(), 1, 1, "Executive Board");
        this.checkGroupSite((Site)sites.next(), 2, 1, "Users");
    }

    private void checkGroupSite(Site site, int priority, int navigationsNumber, String groupName) {
        assert (Site.GROUP.equals(site.getType()));
        assert (priority == site.getPriority());
        assert (site.getDisplayName().contains(groupName));
        IterableIdentifiableCollection navigations = site.getNavigation().getAll();
        assert (navigationsNumber == navigations.size());
        for (Navigation navigation : navigations) {
            assert (site.equals(navigation.getSite()));
        }
    }

    @Test(enabled=false)
    public void shouldListSitePages() {
        Id id = this.gateIn.userId("root");
        IterableIdentifiableCollection portalResult = this.gateIn.getPortalSites(id);
        assert (1 == portalResult.size());
        Iterator portals = portalResult.iterator();
        Portal portal = (Portal)portals.next();
        assert (Site.PORTAL.equals(portal.getType()));
        assert ("classic".equals(portal.getName()));
        assert (this.gateIn.getPortal(this.gateIn.siteId(Site.PORTAL, "classic")).equals(portal));
        IterableIdentifiableCollection navigations = portal.getNavigation().getAll();
        assert (2 == navigations.size());
    }

    @Test(enabled=false)
    public void shouldListDashboardPages() {
        Id id = this.gateIn.userId("root");
        Site dashboard = this.gateIn.getDashboard(id);
        assert (Site.DASHBOARD.equals(dashboard.getType()));
        IterableIdentifiableCollection nodes = dashboard.getNavigation().getAll();
        assert (1 == nodes.size());
        assert ("Dashboard".equals(((Navigation)nodes.iterator().next()).getDisplayName()));
    }
}

