/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.api.content;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Comparator;
import org.gatein.api.GateIn;
import org.gatein.api.content.Category;
import org.gatein.api.content.ContentRegistry;
import org.gatein.api.content.Gadget;
import org.gatein.api.content.ManagedContent;
import org.gatein.api.content.Portlet;
import org.gatein.api.id.Id;
import org.gatein.api.portal.Portal;
import org.gatein.api.util.Filter;
import org.gatein.api.util.IterableIdentifiableCollection;
import org.gatein.api.util.Query;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public abstract class ContentTestCase {
    protected Portal portal;
    protected GateIn gateIn;

    @BeforeTest
    public abstract void setUp();

    @Test
    public void getInexistentCategoryShouldReturnNull() {
        assert (this.portal.getContentRegistry().getCategory("inexistent") == null);
    }

    @Test
    public void getOrCreateInexistentCategoryShouldCreateANewCategory() {
        assert (this.portal.getContentRegistry().getOrCreateCategory("inexistent") != null);
    }

    @Test
    public void assigningContentToACategory() {
        ContentRegistry registry = this.portal.getContentRegistry();
        Category category = registry.getOrCreateCategory("category");
        Id id = this.gateIn.portletId("application", "portlet");
        Portlet portlet = (Portlet)registry.get(id);
        ManagedContent managedContent = category.addContent(id);
        assert (managedContent != null);
        assert (portlet.equals(managedContent.getContent()));
        String name = managedContent.getName();
        assert (managedContent.equals(category.getManagedContent(name)));
        assert (category.contains(name));
        assert (category.getKnownManagedContentNames().contains((Object)name));
        Id wsrp = this.gateIn.wsrpPortletId("invoker", "portlet");
        ManagedContent managedWSRP = category.addContent(wsrp);
        assert (managedWSRP != null);
        assert (category.contains(managedWSRP.getName()));
    }

    @Test
    public void assigningAnApplicationToACategory() {
        ContentRegistry registry = this.portal.getContentRegistry();
        Category category = registry.getOrCreateCategory("category");
        Portlet portlet = (Portlet)registry.get(this.gateIn.portletId("application", "portlet"));
        assert (portlet.getName().equals(portlet.getDisplayName()));
        Id id = portlet.getId();
        ManagedContent managed = category.addContent(id);
        assert (managed != null);
        assert (portlet.equals(managed.getContent()));
        assert (managed.equals(category.getManagedContent(managed.getName())));
        IterableIdentifiableCollection managedContents = registry.getManagedContents(Query.builder().where((Filter)new Filter<ManagedContent>(){

            public boolean accept(ManagedContent item) {
                return item.getContent() instanceof Portlet;
            }
        }).orderBy((Comparator)new Comparator<ManagedContent>(){

            @Override
            public int compare(ManagedContent o1, ManagedContent o2) {
                return o1.getName().compareTo(o2.getName());
            }
        }).build());
        assert (1 == managedContents.size());
        for (ManagedContent managedContent : managedContents) {
            assert (managed.equals(managedContent));
        }
        managed.setDisplayName("displayName");
        assert ("displayName".equals(managed.getDisplayName()));
    }

    @Test
    public void assigningAGadgetToACategory() throws URISyntaxException, MalformedURLException {
        ContentRegistry registry = this.portal.getContentRegistry();
        Category category = registry.getOrCreateCategory("category");
        Id gadgetId = this.gateIn.gadgetId("gadgetName");
        Gadget gadget = (Gadget)registry.get(gadgetId);
        assert ("gadgetName".equals(gadget.getName()));
        ManagedContent managedContent = category.addContent(gadgetId);
        assert (managedContent != null);
        assert (gadget.equals(managedContent.getContent()));
        assert (managedContent.equals(category.getManagedContent(managedContent.getName())));
        URI uri = new URI("http://foo.bar.com/gadget.xml");
        gadgetId = this.gateIn.gadgetId(uri);
        gadget = (Gadget)registry.get(gadgetId);
        assert (!gadget.isLocal());
        assert (uri.equals(gadget.getURI()));
        assert (uri.equals(((Gadget.RemoteData)gadget.getData()).getURI()));
        managedContent = category.addContent(gadgetId);
        assert (managedContent != null);
        assert (gadget.equals(managedContent.getContent()));
        assert (managedContent.equals(category.getManagedContent(managedContent.getName())));
    }

    @Test
    public void creatingAGadgetFromSource() {
        ContentRegistry registry = this.portal.getContentRegistry();
        Gadget gadget = registry.createGadget("gadget", "source");
        assert (this.gateIn.gadgetId("gadget").equals((Object)gadget.getId()));
        assert (gadget.getURI() != null);
        assert (gadget.isLocal());
        assert (gadget.getData() instanceof Gadget.LocalData);
        assert ("source".equals(((Gadget.LocalData)gadget.getData()).getSource()));
        assert (gadget.getReferenceURI() != null);
        assert (gadget.equals(registry.get(gadget.getId())));
    }

    @Test
    public void removeContentFromCategory() {
        ContentRegistry registry = this.portal.getContentRegistry();
        Category category = registry.getOrCreateCategory("category");
        Id id = this.gateIn.portletId("application", "portlet");
        Portlet portlet = (Portlet)registry.get(id);
        ManagedContent managed = category.addContent(id);
        assert (category.contains(managed.getName()));
        category.removeContent(managed.getName());
        assert (!category.contains(managed.getName()));
    }
}

