/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.api.id;

import java.util.regex.Pattern;
import org.gatein.api.id.Component;
import org.testng.annotations.Test;

public class ComponentTestCase {
    @Test(expectedExceptions={IllegalArgumentException.class})
    public void aComponentShouldHaveANonNullName() {
        new Component(null, Object.class, null, true, false);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void aComponentShouldHaveANonEmptyName() {
        new Component("", Object.class, null, true, false);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void aComponentShouldHaveAValidationPattern() {
        new Component("name", Object.class, null, true, false);
    }

    @Test
    public void isRequiredShouldWork() {
        Component foo = new Component("foo", Object.class, Pattern.compile(".*"), true, false);
        assert ("foo".equals(foo.getName()));
        assert (foo.isRequired());
        foo = new Component("foo", Object.class, Pattern.compile(".*"), false, false);
        assert (!foo.isRequired());
    }

    @Test
    public void isHierarchicalShouldWork() {
        Component foo = new Component("foo", Object.class, Pattern.compile(".*"), true, true);
        assert ("foo".equals(foo.getName()));
        assert (foo.isHierarchical());
        foo = new Component("foo", Object.class, Pattern.compile(".*"), false, false);
        assert (!foo.isHierarchical());
    }
}

