/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.api.id;

import java.util.Arrays;
import java.util.regex.Pattern;
import org.gatein.api.id.Context;
import org.gatein.api.id.Identifiable;
import org.testng.annotations.Test;

public class ContextTestCase {
    private static final String CONTAINER_COMPONENT_NAME = "containerComponent";
    private static final String PORTAL_COMPONENT_NAME = "portalComponent";
    private static final String INVOKER_COMPONENT_NAME = "invokerComponent";
    private static final String PORTLET_COMPONENT_NAME = "portletComponent";
    private static final String INSTANCE_COMPONENT_NAME = "instanceComponent";
    private static final Context CONTEXT = Context.builder().withDefaultSeparator("=").requiredComponent("containerComponent", Identifiable.class, Pattern.compile("container")).requiredComponent("portalComponent", Identifiable.class, Pattern.compile("portal")).optionalComponent("invokerComponent", Identifiable.class, Pattern.compile(".*")).optionalComponent("portletComponent", Identifiable.class, Pattern.compile(".*")).optionalComponent("instanceComponent", Identifiable.class, Pattern.compile(".*Instance$")).ignoreRemainingAfterFirstMissingOptional().build();

    @Test(expectedExceptions={IllegalStateException.class})
    public void contextBuilderBuildShouldProperlyFailOnEmptyContext() {
        Context.builder().build();
    }

    @Test
    public void simpleContext() {
        Context context = Context.builder().withDefaultSeparator("-").requiredComponent("component", Identifiable.class, Pattern.compile(".*")).build();
        assert (0 == context.getIndexFor("component"));
        assert (context.isComponentRequired("component"));
        context.validate(new String[]{"foo"});
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testExtraComponents() {
        CONTEXT.validate(new String[]{"container", "portal", "foo", "bar", "barInstance", "unknown"});
    }

    @Test
    public void testPortletCase() {
        CONTEXT.validate(new String[]{"container", "portal"});
        CONTEXT.validate(new String[]{"container", "portal", "foo"});
        CONTEXT.validate(new String[]{"container", "portal", "foo", "bar"});
        CONTEXT.validate(new String[]{"container", "portal", "foo", "bar", "barInstance"});
    }

    @Test
    public void simpleHierarchicalContextShouldWork() {
        Context context = Context.builder().withDefaultSeparator("/").requiredComponent("foo", Identifiable.class, Pattern.compile(".*foo$")).requiredUnboundedHierarchicalComponent("bar", Identifiable.class, Pattern.compile("^bar.*")).build();
        assert (context.isComponentUnboundedHierarchical("bar"));
        assert (context.isComponentRequired("bar"));
        context.validate(new String[]{"foo", "bar"});
        context.validate(new String[]{"foo", "bar", "bar"});
    }

    @Test
    public void shouldProperlyWorkWhenSeparatorIsRequiredInFirstPosition() {
        Context context = Context.builder().withDefaultSeparator("/").requiredComponent("root", Identifiable.class, Pattern.compile("\\w+")).requiredUnboundedHierarchicalComponent("bar", Identifiable.class, Pattern.compile("\\w+")).requireSeparatorInFirstPosition().build();
        assert (Arrays.equals(new String[]{"foo", "bar"}, context.extractComponents("/foo/bar")));
        try {
            context.extractComponents("foo/bar");
            assert (false) : "Should have failed";
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void missingRequiredHierarchicalShouldBeDetected() {
        Context context = Context.builder().withDefaultSeparator("/").requiredComponent("foo", Identifiable.class, Pattern.compile(".*foo$")).requiredUnboundedHierarchicalComponent("bar", Identifiable.class, Pattern.compile("^bar.*")).build();
        context.validate(new String[]{"foo"});
    }

    @Test
    public void shouldValidateProperlyWhenThereAreRequiredComponentsAfterHierarchical() {
        Context context = Context.builder().withDefaultSeparator("/").requiredComponent("foo", Identifiable.class, Pattern.compile(".*foo$")).requiredUnboundedHierarchicalComponent("bar", Identifiable.class, Pattern.compile("^bar.*")).requiredComponent("baz", Identifiable.class, Pattern.compile("^baz\\d*")).build();
        context.validate(new String[]{"foo", "bar", "baz"});
        context.validate(new String[]{"foo", "bar", "bar2", "baz"});
    }
}

