/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.api.id;

import java.util.regex.Pattern;
import org.gatein.api.GateIn;
import org.gatein.api.id.Context;
import org.gatein.api.id.Id;
import org.gatein.api.id.Identifiable;
import org.testng.Assert;
import org.testng.annotations.Test;

public class IdTestCase {
    private static final String CONTAINER_COMPONENT_NAME = "containerComponent";
    private static final String PORTAL_COMPONENT_NAME = "portalComponent";
    private static final String INVOKER_COMPONENT_NAME = "invokerComponent";
    private static final String PORTLET_COMPONENT_NAME = "portletComponent";
    private static final String INSTANCE_COMPONENT_NAME = "instanceComponent";
    private Context context = Context.builder().withDefaultSeparator("=").requiredComponent("containerComponent", Identifiable.class, Pattern.compile("container")).requiredComponent("portalComponent", Identifiable.class, Pattern.compile("portal")).optionalComponent("invokerComponent", Identifiable.class, Pattern.compile(".*")).optionalComponent("portletComponent", Identifiable.class, Pattern.compile(".*")).optionalComponent("instanceComponent", Identifiable.class, Pattern.compile(".*Instance$")).ignoreRemainingAfterFirstMissingOptional().build();
    private static final String CONTAINER = "container";
    private static final String PORTAL = "portal";
    private static final String INVOKER = "invoker";
    private static final String PORTLET = "portlet";
    private static final String INSTANCE = "fooInstance";

    @Test
    public void testRoundtripParsing() {
        Id key = Id.create((Context)this.context, (String)CONTAINER, (String[])new String[]{PORTAL, INVOKER, PORTLET, INSTANCE});
        Id parsed = Id.parse((Context)key.getOriginalContext(), (String)key.toString());
        assert (key.equals((Object)parsed));
        assert (CONTAINER.equals(key.getComponent(CONTAINER_COMPONENT_NAME)));
        assert (PORTAL.equals(key.getComponent(PORTAL_COMPONENT_NAME)));
        assert (INVOKER.equals(key.getComponent(INVOKER_COMPONENT_NAME)));
        assert (PORTLET.equals(key.getComponent(PORTLET_COMPONENT_NAME)));
        assert (INSTANCE.equals(key.getComponent(INSTANCE_COMPONENT_NAME)));
        key = Id.create((Context)this.context, (String)CONTAINER, (String[])new String[]{PORTAL, INVOKER});
        parsed = Id.parse((Context)key.getOriginalContext(), (String)key.toString());
        assert (key.equals((Object)parsed));
        assert (CONTAINER.equals(key.getComponent(CONTAINER_COMPONENT_NAME)));
        assert (PORTAL.equals(key.getComponent(PORTAL_COMPONENT_NAME)));
        assert (INVOKER.equals(parsed.getComponent(INVOKER_COMPONENT_NAME)));
        assert (parsed.getComponent(PORTLET_COMPONENT_NAME) == null);
        assert (parsed.getComponent(INSTANCE_COMPONENT_NAME) == null);
        key = Id.create((Context)this.context, (String)CONTAINER, (String[])new String[]{PORTAL});
        parsed = Id.parse((Context)key.getOriginalContext(), (String)key.toString());
        assert (key.equals((Object)parsed));
        assert (CONTAINER.equals(key.getComponent(CONTAINER_COMPONENT_NAME)));
        assert (PORTAL.equals(key.getComponent(PORTAL_COMPONENT_NAME)));
        assert (parsed.getComponent(INVOKER_COMPONENT_NAME) == null);
        assert (parsed.getComponent(PORTLET_COMPONENT_NAME) == null);
        assert (parsed.getComponent(INSTANCE_COMPONENT_NAME) == null);
        key = Id.create((Context)this.context, (String)CONTAINER, (String[])new String[]{PORTAL, null, PORTLET});
        parsed = Id.parse((Context)key.getOriginalContext(), (String)key.toString());
        assert (key.equals((Object)parsed));
        assert (CONTAINER.equals(key.getComponent(CONTAINER_COMPONENT_NAME)));
        assert (PORTAL.equals(key.getComponent(PORTAL_COMPONENT_NAME)));
        assert (parsed.getComponent(INVOKER_COMPONENT_NAME) == null);
        assert (parsed.getComponent(PORTLET_COMPONENT_NAME) == null);
        assert (parsed.getComponent(INSTANCE_COMPONENT_NAME) == null);
        key = Id.create((Context)this.context, (String)CONTAINER, (String[])new String[]{PORTAL, INVOKER, null, INSTANCE});
        parsed = Id.parse((Context)key.getOriginalContext(), (String)key.toString());
        assert (key.equals((Object)parsed));
        assert (CONTAINER.equals(key.getComponent(CONTAINER_COMPONENT_NAME)));
        assert (PORTAL.equals(key.getComponent(PORTAL_COMPONENT_NAME)));
        assert (INVOKER.equals(parsed.getComponent(INVOKER_COMPONENT_NAME)));
        assert (parsed.getComponent(PORTLET_COMPONENT_NAME) == null);
        assert (parsed.getComponent(INSTANCE_COMPONENT_NAME) == null);
    }

    @Test
    public void testRoundtripParsingWithRequiredFirstSeparator() {
        Context context = Context.builder().withDefaultSeparator("/").requiredUnboundedHierarchicalComponent("foo", Identifiable.class, Pattern.compile("\\w+")).requireSeparatorInFirstPosition().build();
        Id key = Id.create((Context)context, (String)"foo", (String[])new String[]{"bar", "baz"});
        Id parsed = Id.parse((Context)key.getOriginalContext(), (String)key.toString());
        assert (key.equals((Object)parsed));
    }

    @Test
    public void getParentShouldWork() {
        Id portal = Id.create((Context)this.context, (String)CONTAINER, (String[])new String[]{PORTAL});
        Id invoker = Id.create((Context)this.context, (String)CONTAINER, (String[])new String[]{PORTAL, INVOKER});
        assert (portal.equals((Object)invoker.getParent()));
        Id portlet = Id.create((Context)this.context, (String)CONTAINER, (String[])new String[]{PORTAL, INVOKER, PORTLET});
        assert (invoker.equals((Object)portlet.getParent()));
        Id instance = Id.create((Context)this.context, (String)CONTAINER, (String[])new String[]{PORTAL, INVOKER, PORTLET, INSTANCE});
        assert (portlet.equals((Object)instance.getParent()));
    }

    @Test
    public void testRoundtripParsingWithHierarchicalComponents() {
        Context groupContext = Context.builder().withDefaultSeparator("/").requiredUnboundedHierarchicalComponent("root", Identifiable.class, Pattern.compile("\\w*")).build();
        Id id = Id.create((Context)groupContext, (String)"root", (String[])new String[]{"1", "2", "3", "4"});
        assert (id.equals((Object)Id.parse((Context)id.getOriginalContext(), (String)id.toString())));
        Id parent = Id.create((Context)groupContext, (String)"root", (String[])new String[]{"1", "2", "3"});
        assert (parent.equals((Object)id.getParent()));
    }

    @Test
    public void testRootComponent() {
        Id key = Id.create((Context)Context.builder().withDefaultSeparator("-").requiredComponent(CONTAINER_COMPONENT_NAME, Identifiable.class, Pattern.compile(CONTAINER)).build(), (String)CONTAINER, (String[])new String[0]);
        assert (CONTAINER.equals(key.getRootComponent()));
        assert (key.getParent() == null);
        key = Id.create((Context)this.context, (String)CONTAINER, (String[])new String[]{PORTAL, INVOKER, PORTLET, INSTANCE});
        assert (CONTAINER.equals(key.getRootComponent()));
    }

    @Test
    public void testPortletNameWithSlash() {
        Id key = Id.create((Context)this.context, (String)CONTAINER, (String[])new String[]{PORTAL, INVOKER, "category/portlet"});
        Id parsed = Id.parse((Context)key.getOriginalContext(), (String)key.toString());
        assert (key.equals((Object)parsed));
        assert (CONTAINER.equals(key.getComponent(CONTAINER_COMPONENT_NAME)));
        assert (PORTAL.equals(key.getComponent(PORTAL_COMPONENT_NAME)));
        assert (INVOKER.equals(parsed.getComponent(INVOKER_COMPONENT_NAME)));
        assert ("category/portlet".equals(parsed.getComponent(PORTLET_COMPONENT_NAME)));
    }

    @Test
    public void shouldNotSetOptionalComponents() {
        assert (Id.create((Context)this.context, (String)CONTAINER, (String[])new String[]{PORTAL, INVOKER, null}).equals((Object)Id.create((Context)this.context, (String)CONTAINER, (String[])new String[]{PORTAL, INVOKER})));
    }

    @Test
    public void testGetChildFor() {
        Id key = Id.create((Context)this.context, (String)CONTAINER, (String[])new String[]{PORTAL});
        Id child = key.getIdForChild(INVOKER);
        assert (Id.create((Context)this.context, (String)CONTAINER, (String[])new String[]{PORTAL, INVOKER, null}).equals((Object)child));
        child = child.getIdForChild(PORTLET);
        assert (Id.create((Context)this.context, (String)CONTAINER, (String[])new String[]{PORTAL, INVOKER, PORTLET}).equals((Object)child));
        child = child.getIdForChild(INSTANCE);
        assert (Id.create((Context)this.context, (String)CONTAINER, (String[])new String[]{PORTAL, INVOKER, PORTLET, INSTANCE}).equals((Object)child));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testAnIdShouldAlwaysHaveAPortalKey() {
        Id.create((Context)this.context, null, (String[])new String[0]);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testGetChildForShouldFailOnNullChildId() {
        Id.create((Context)this.context, (String)CONTAINER, (String[])new String[]{PORTAL}).getIdForChild(null);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void anIdShouldAlwaysHaveARoot() {
        Id.create((Context)Context.builder().withDefaultSeparator("-").requiredComponent("foo", Identifiable.class, Pattern.compile(".*")).build(), null, (String[])new String[0]);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void shouldNotBePossibleToCreateAnIdWithoutAContext() {
        Id.create(null, null, (String[])new String[0]);
    }

    @Test
    public void testPortletIdsScenarios() {
        Id id = Id.create((Context)this.context, (String)CONTAINER, (String[])new String[]{PORTAL});
        assert (CONTAINER.equals(id.getComponent(CONTAINER_COMPONENT_NAME)));
        assert (PORTAL.equals(id.getComponent(PORTAL_COMPONENT_NAME)));
        Assert.assertEquals((String)id.toString(this.context), (String)"container=portal");
        try {
            Id.create((Context)this.context, null, (String[])new String[0]);
            Assert.fail((String)"Should have failed as containerComponent is required");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            Id.create((Context)this.context, (String)"foo", (String[])new String[0]);
            Assert.fail((String)"Should have failed as only 'container' is allowed as value for containerComponent");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            Id.create((Context)this.context, (String)CONTAINER, (String[])new String[0]);
            Assert.fail((String)"Should have failed as portalComponent is required");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            Id.create((Context)this.context, (String)CONTAINER, (String[])new String[]{"goo"});
            Assert.fail((String)"Should have failed as only 'portal' is allowed as value for portalComponent");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getIdentifiableTypeShouldReturnTheReifiedType() {
        Id foo = Id.create((Context)A.context, A.class, (String)"foo", (String[])new String[0]);
        assert (A.class.equals((Object)foo.getIdentifiableType()));
    }

    private static class A
    implements Identifiable<A> {
        static final Context context = Context.builder().requiredComponent("foo", A.class, Pattern.compile(".*")).build();

        private A() {
        }

        public Id<A> getId() {
            return Id.create((Context)context, A.class, (String)"foo", (String[])new String[0]);
        }

        public String getName() {
            return null;
        }

        public String getDisplayName() {
            return null;
        }

        public GateIn getGateIn() {
            return null;
        }
    }
}

