/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.api.portal;

import org.gatein.api.GateIn;
import org.gatein.api.id.Id;
import org.gatein.api.portal.Navigation;
import org.gatein.api.portal.Page;
import org.gatein.api.portal.Portal;
import org.gatein.api.portal.Site;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public abstract class NavigationTestCase {
    protected GateIn gateIn;

    @BeforeTest
    public abstract void setUp();

    @Test
    public void creatingASimplePage() {
        Portal portal = this.gateIn.getDefaultPortal();
        String name = "name";
        String title = "title";
        Page page = (Page)portal.getPageRegistry().createAndAdd((Object)name);
        assert (name.equals(page.getId().toString()));
        assert (name.equals(page.getTitle())) : "By default, a Page's title should be the same as its name";
        assert (portal.equals(page.getSite()));
        page.setTitle(title);
        assert (title.equals(page.getTitle()));
    }

    @Test
    public void creatingANavigationShouldLinkNavigationAndNode() {
        Id classic = this.gateIn.siteId(Site.PORTAL, "classic");
        Portal portal = (Portal)this.gateIn.get(classic);
        assert (portal.equals(this.gateIn.getPortal(classic)));
        Page page = (Page)portal.getPageRegistry().get(classic.getIdForChild("page"));
        Id pageId = page.getId();
        assert (page.equals(this.gateIn.get(pageId)));
        Navigation nav = (Navigation)portal.getNavigation().get((Object)"page");
        assert (page.equals(nav.getTargetPage()));
        Page sub = (Page)portal.getPageRegistry().get((Object)"sub");
        assert (sub.equals(this.gateIn.get(pageId.getIdForChild("sub"))));
        Navigation navigation = portal.createNavigationTo(sub, portal.getNavigation());
        assert (sub.equals(navigation.getTargetPage()));
        assert (sub.getInboundNavigations().contains(navigation.getId()));
        assert (portal.getNavigation().contains((Object)navigation.getName()));
        Navigation inboundNavigation = sub.createInboundNavigationIn((Site)portal, portal.getNavigation());
        assert (sub.equals(inboundNavigation.getTargetPage()));
        assert (sub.getInboundNavigations().contains(inboundNavigation.getId()));
        assert (portal.getNavigation().contains((Object)inboundNavigation.getName()));
    }
}

