/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.api.util;

import org.gatein.api.id.Id;
import org.gatein.api.id.Identifiable;
import org.gatein.api.util.HierarchicalContainer;
import org.testng.annotations.Test;

public abstract class HierarchicalContainerTestCase {
    protected HierarchicalContainer<String, Identifiable> container;

    @Test
    public void createAndAddShouldBeIdempotent() {
        String foo = "foo";
        assert (this.container.createAndAdd((Object)foo).equals(this.container.createAndAdd(this.container.getIdForChild((Object)foo))));
        String bar = "bar";
        assert (this.container.createAndAdd(this.container.getIdForChild((Object)bar)).equals(this.container.createAndAdd((Object)bar)));
    }

    @Test
    public void keyAndIdEquivalenceShouldWorkFine() {
        String fooName = "foo";
        Identifiable foo = this.container.createAndAdd((Object)fooName);
        Id fooId = foo.getId();
        assert (fooId.equals((Object)this.container.getIdForChild((Object)fooName)));
        assert (this.container.contains((Object)fooName));
        assert (this.container.contains(fooId));
        assert (foo.equals(this.container.get((Object)fooName)));
        assert (foo.equals(this.container.get(fooId)));
    }
}

