/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.api.id;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gatein.api.id.ParameterValidation;

public class Component<T> {
    private final String name;
    private final Matcher matcher;
    private final String validationPattern;
    private final boolean required;
    private final boolean hierarchical;
    private final Class<T> identifiedComponentClass;

    public Component(String name, Class<T> identifiedComponentClass, Pattern validationPattern, boolean required, boolean hierarchical) {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty(name, "Component name", null);
        ParameterValidation.throwIllegalArgExceptionIfNull(validationPattern, "Validation pattern");
        ParameterValidation.throwIllegalArgExceptionIfNull(identifiedComponentClass, "Class of the objects identified by this component");
        this.name = name;
        this.matcher = validationPattern.matcher("");
        this.validationPattern = validationPattern.toString();
        this.required = required;
        this.identifiedComponentClass = identifiedComponentClass;
        this.hierarchical = hierarchical;
    }

    public String getName() {
        return this.name;
    }

    public void validate(String componentValue) {
        if (!ParameterValidation.isNullOrEmpty(componentValue)) {
            this.matcher.reset(componentValue);
            if (!this.matcher.matches()) {
                throw new IllegalArgumentException("Invalid value '" + componentValue + "'. Valid values should match: '" + this.validationPattern + "'");
            }
        } else if (this.required) {
            throw new IllegalArgumentException("Component '" + this.name + "' is required.");
        }
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean isHierarchical() {
        return this.hierarchical;
    }

    public Class<T> getIdentifiedComponentClass() {
        return this.identifiedComponentClass;
    }
}

