/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.api.id;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.gatein.api.id.Component;
import org.gatein.api.id.Id;
import org.gatein.api.id.Identifiable;
import org.gatein.api.id.ParameterValidation;

public class Context {
    private static final String LIST_SEPARATOR = ", ";
    private final LinkedHashMap<String, ComponentIndex> namesToComponents;
    private final int requiredCardinality;
    private final String knownComponents;
    private final String requiredComponents;
    private final String defaultSeparator;
    private final boolean ignoreRemainingAfterFirstMissingOptional;
    private boolean hasHierarchicalComponents;
    private boolean requiresSeparatorInFirstPosition;

    private Context(String defaultSeparator, List<Component> componentList, boolean ignoreRemainingAfterFirstMissingOptional) {
        ParameterValidation.throwIllegalArgExceptionIfNull(componentList, "Component list");
        int size = componentList.size();
        this.namesToComponents = new LinkedHashMap(size);
        this.ignoreRemainingAfterFirstMissingOptional = ignoreRemainingAfterFirstMissingOptional;
        StringBuilder knownComponentsSB = new StringBuilder();
        int current = 1;
        int required = 0;
        for (Component component : componentList) {
            this.addComponent(component, current - 1);
            if (component.isRequired()) {
                ++required;
            }
            if (!this.hasHierarchicalComponents && component.isHierarchical()) {
                this.hasHierarchicalComponents = true;
            }
            String name = component.getName();
            this.buildString(knownComponentsSB, name, current <= size, LIST_SEPARATOR);
        }
        this.requiredCardinality = required;
        StringBuilder requiredComponentsSB = new StringBuilder();
        int requiredIndex = 0;
        for (Component component : componentList) {
            if (!component.isRequired()) continue;
            this.buildString(requiredComponentsSB, component.getName(), ++requiredIndex < this.requiredCardinality, LIST_SEPARATOR);
        }
        this.knownComponents = knownComponentsSB.toString();
        this.requiredComponents = requiredComponentsSB.toString();
        this.defaultSeparator = defaultSeparator;
    }

    private void buildString(StringBuilder sb, String toAppend, boolean appendSeparator, String separator) {
        sb.append(toAppend);
        if (appendSeparator) {
            sb.append(separator);
        }
    }

    private void addComponent(Component component, int i) {
        ParameterValidation.throwIllegalArgExceptionIfNull(component, "Component");
        this.namesToComponents.put(component.getName(), new ComponentIndex(this.namesToComponents.size(), component));
    }

    public void setSeparator(String separator, int position) {
    }

    protected int getIndexFor(String component) {
        return this.getComponentOrFail(component).index;
    }

    private Component getComponentAt(int index) {
        for (Map.Entry<String, ComponentIndex> entry : this.namesToComponents.entrySet()) {
            ComponentIndex componentIndex = entry.getValue();
            if (index != componentIndex.index) continue;
            return componentIndex.component;
        }
        throw this.errorOnUnknownComponent("No component with index: " + index);
    }

    private IllegalArgumentException errorOnUnknownComponent(String message) {
        throw new IllegalArgumentException(message + ". Known components are: " + this.knownComponents);
    }

    protected void validate(String value, int index) {
        for (ComponentIndex componentIndex : this.namesToComponents.values()) {
            if (index != componentIndex.index) continue;
            componentIndex.component.validate(value);
            return;
        }
        throw this.errorOnUnknownComponent("No component with index: " + index);
    }

    Component getComponent(String component) {
        return this.getComponentOrFail(component).component;
    }

    private ComponentIndex getComponentOrFail(String component) {
        ComponentIndex index = this.namesToComponents.get(component);
        if (index == null) {
            throw this.errorOnUnknownComponent("Unknown component: " + component);
        }
        return index;
    }

    public String toString(Id id) {
        ParameterValidation.throwIllegalArgExceptionIfNull(id, "Id to output as String");
        StringBuilder sb = new StringBuilder(111);
        if (this.requiresSeparatorInFirstPosition) {
            sb.append(this.defaultSeparator);
        }
        int componentNumber = id.getComponentNumber();
        String[] components = id.getComponents();
        this.validate(id, components);
        int index = 0;
        for (String component : components) {
            sb.append(component);
            if (index < componentNumber - 1) {
                sb.append(this.defaultSeparator);
            }
            ++index;
        }
        return sb.toString();
    }

    void validate(String ... componentValues) {
        this.validate((Id)null, componentValues);
    }

    void validate(Id id, String ... componentValues) {
        int componentNumber = this.namesToComponents.size();
        int valueNumber = componentValues.length;
        if (valueNumber < this.requiredCardinality || !this.hasHierarchicalComponents && valueNumber > componentNumber) {
            throw new IllegalArgumentException("Wrong number of components: " + valueNumber + ". Was expecting at most " + componentNumber + " values for components: " + this.knownComponents + "; among which '" + this.requiredComponents + "' are required. Got: " + Arrays.toString(componentValues));
        }
        boolean error = false;
        StringBuilder sb = null;
        int testComponentNumber = Math.max(componentNumber, valueNumber);
        String[] nullPaddedValues = Arrays.copyOf(componentValues, testComponentNumber);
        int currentComponent = 0;
        int actualCurrentComponent = 0;
        if (!this.hasHierarchicalComponents) {
            for (ComponentIndex index : this.namesToComponents.values()) {
                try {
                    index.component.validate(nullPaddedValues[currentComponent]);
                    if (id != null && currentComponent < valueNumber) {
                        id.associateCurrentValueWith(currentComponent, index.component.getName());
                    }
                }
                catch (Exception e) {
                    error = true;
                    sb = this.createErrorMessage(sb, e.getLocalizedMessage());
                }
                ++currentComponent;
            }
        } else {
            ArrayList<ComponentIndex> components = new ArrayList<ComponentIndex>(this.namesToComponents.values());
            for (String value : nullPaddedValues) {
                if (currentComponent >= componentNumber) {
                    currentComponent = componentNumber - 1;
                }
                ComponentIndex index = (ComponentIndex)components.get(currentComponent);
                try {
                    index.component.validate(value);
                    if (id != null) {
                        id.associateCurrentValueWith(actualCurrentComponent, index.component.getName());
                    }
                }
                catch (Exception e) {
                    if (currentComponent > 1) {
                        Component component = ((ComponentIndex)components.get(currentComponent - 1)).component;
                        if (component.isHierarchical()) {
                            try {
                                component.validate(value);
                                if (id != null) {
                                    id.associateCurrentValueWith(actualCurrentComponent, index.component.getName());
                                }
                                --currentComponent;
                                error = false;
                            }
                            catch (Exception e1) {
                                error = true;
                                sb = this.createErrorMessage(sb, e1.getLocalizedMessage());
                            }
                        }
                    }
                    error = true;
                    sb = this.createErrorMessage(sb, e.getLocalizedMessage());
                }
                ++currentComponent;
                ++actualCurrentComponent;
            }
        }
        if (error) {
            throw new IllegalArgumentException("Invalid components:\n" + sb.toString());
        }
    }

    private StringBuilder createErrorMessage(StringBuilder sb, String message) {
        if (sb == null) {
            sb = new StringBuilder(111);
        }
        sb.append(message).append("\n");
        return sb;
    }

    public String[] extractComponents(String idAsString) {
        if (this.requiresSeparatorInFirstPosition) {
            if (!idAsString.startsWith(this.defaultSeparator)) {
                throw new IllegalArgumentException("Context requires separator '" + this.defaultSeparator + "' in first position. Given composite was: " + idAsString);
            }
            idAsString = idAsString.substring(this.defaultSeparator.length());
        }
        return idAsString.split(this.defaultSeparator);
    }

    public boolean isComponentRequired(String component) {
        return this.getComponentOrFail(component).component.isRequired();
    }

    public boolean isComponentUnboundedHierarchical(String component) {
        return this.getComponentOrFail(component).component.isHierarchical();
    }

    public static ContextBuilder builder() {
        return new ContextBuilder();
    }

    private void requiresSeparatorInFirstPosition() {
        this.requiresSeparatorInFirstPosition = true;
    }

    public static class ContextBuilder {
        private List<Component> components = new ArrayList<Component>(7);
        private String defaultSeparator;
        private boolean ignoreRemainingAfterFirstMissingOptional;
        private boolean requireSeparatorInFirstPosition;

        private ContextBuilder() {
        }

        public <T extends Identifiable<T>> ContextBuilder requiredComponent(String name, Class<T> componentType, Pattern validationPattern) {
            this.components.add(new Component<T>(name, componentType, validationPattern, true, false));
            return this;
        }

        public <T extends Identifiable> ContextBuilder optionalComponent(String name, Class<T> componentType, Pattern validationPattern) {
            this.components.add(new Component<T>(name, componentType, validationPattern, false, false));
            return this;
        }

        public <T extends Identifiable> ContextBuilder requiredUnboundedHierarchicalComponent(String firstComponentName, Class<T> componentType, Pattern validationPattern) {
            this.components.add(new Component<T>(firstComponentName, componentType, validationPattern, true, true));
            return this;
        }

        public ContextBuilder withDefaultSeparator(String defaultSeparator) {
            this.defaultSeparator = defaultSeparator;
            return this;
        }

        public ContextBuilder ignoreRemainingAfterFirstMissingOptional() {
            this.ignoreRemainingAfterFirstMissingOptional = true;
            return this;
        }

        public ContextBuilder requireSeparatorInFirstPosition() {
            this.requireSeparatorInFirstPosition = true;
            return this;
        }

        public Context build() {
            if (this.components.isEmpty()) {
                throw new IllegalStateException("Cannot build a Context with empty components");
            }
            Context context = new Context(this.defaultSeparator, this.components, this.ignoreRemainingAfterFirstMissingOptional);
            if (this.requireSeparatorInFirstPosition) {
                context.requiresSeparatorInFirstPosition();
            }
            return context;
        }
    }

    private static class ComponentIndex {
        private final int index;
        private final Component component;

        private ComponentIndex(int index, Component component) {
            this.index = index;
            this.component = component;
        }
    }
}

