/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.api.id;

import java.util.Arrays;
import org.gatein.api.id.Context;
import org.gatein.api.id.Identifiable;
import org.gatein.api.id.ParameterValidation;

public abstract class Id<T extends Identifiable>
implements Comparable<Id> {
    protected final Context originalContext;
    private final Class<T> identifiableType;

    private Id(Context context, Class<T> identifiableType) {
        this.originalContext = context;
        this.identifiableType = identifiableType;
    }

    public String toString(Context context) {
        return context.toString(this);
    }

    public Class<T> getIdentifiableType() {
        return this.identifiableType;
    }

    public String toString() {
        return this.originalContext.toString(this);
    }

    public static Id create(Context context, String rootComponent, String ... additionalComponent) {
        return Id.create(context, Identifiable.class, rootComponent, additionalComponent);
    }

    public static <T extends Identifiable> Id<T> create(Context context, Class<T> type, String rootComponent, String ... additionalComponents) {
        ParameterValidation.throwIllegalArgExceptionIfNull(context, "Context");
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty(rootComponent, "root component", null);
        return Id.internalCreate(context, type, true, rootComponent, additionalComponents);
    }

    private static <T extends Identifiable> Id<T> internalCreate(Context context, Class<T> type, boolean revalidate, String rootComponent, String ... additionalComponents) {
        if (ParameterValidation.existsAndIsNotEmpty(additionalComponents)) {
            int length = additionalComponents.length;
            int indexOfFirstNull = -1;
            int current = 0;
            for (String additionalComponent : additionalComponents) {
                if (ParameterValidation.isNullOrEmpty(additionalComponent)) {
                    indexOfFirstNull = current;
                    break;
                }
                ++current;
            }
            length = indexOfFirstNull != -1 ? indexOfFirstNull : length;
            String[] components = new String[length + 1];
            System.arraycopy(additionalComponents, 0, components, 1, length);
            components[0] = rootComponent;
            return Id.internalCreate(context, type, revalidate, components);
        }
        SimpleId id = new SimpleId(context, type, rootComponent);
        if (revalidate) {
            context.validate(id, rootComponent);
        }
        return id;
    }

    private static <T extends Identifiable> Id<T> internalCreate(Context context, Class<T> type, boolean revalidate, String ... components) {
        if (ParameterValidation.existsAndIsNotEmpty(components)) {
            Id id = components.length == 1 ? new SimpleId(context, type, components[0]) : new ComplexId<T>(context, type, components);
            if (revalidate) {
                context.validate(id, components);
            }
            return id;
        }
        throw new IllegalArgumentException("A valid root component is required to create an Id.");
    }

    public static Id parse(Context context, String idAsString) {
        return Id.parse(context, idAsString, Identifiable.class);
    }

    public static <U extends Identifiable<U>> Id<U> parse(Context context, String idAsString, Class<U> expectedType) {
        ParameterValidation.throwIllegalArgExceptionIfNull(context, "Context to interpret String as an Id");
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty(idAsString, "String to interpret as Id", null);
        String[] components = context.extractComponents(idAsString);
        return Id.internalCreate(context, expectedType, false, components);
    }

    public Id getIdForChild(String childId) {
        ParameterValidation.throwIllegalArgExceptionIfNull(this, "Parent resource");
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty(childId, "child identifier", null);
        String[] components = this.getComponents();
        int childIndex = components.length;
        Context context = this.getOriginalContext();
        context.validate(childId, childIndex);
        String[] newComponents = new String[childIndex + 1];
        System.arraycopy(components, 0, newComponents, 0, childIndex);
        newComponents[childIndex] = childId;
        return Id.internalCreate(context, Identifiable.class, false, newComponents);
    }

    public String getComponent(String component) {
        int index = this.originalContext.getIndexFor(component);
        return this.getComponent(index, component, this.originalContext);
    }

    protected abstract String getComponent(int var1, String var2, Context var3);

    protected abstract String[] getComponents();

    public Context getOriginalContext() {
        return this.originalContext;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Id)) {
            return false;
        }
        Id id = (Id)o;
        return Arrays.equals(this.getComponents(), id.getComponents());
    }

    public int hashCode() {
        return Arrays.hashCode(this.getComponents());
    }

    @Override
    public int compareTo(Id o) {
        if (this.equals(o)) {
            return 0;
        }
        return this.toString().compareTo(o.toString());
    }

    public abstract int getComponentNumber();

    public abstract String getRootComponent();

    abstract void associateCurrentValueWith(int var1, String var2);

    abstract String getComponentNameFor(int var1);

    public Id getParent() {
        int componentNumber = this.getComponentNumber();
        if (componentNumber > 1) {
            int parent = componentNumber - 1;
            return Id.internalCreate(this.originalContext, this.originalContext.getComponent(this.getComponentNameFor(parent)).getIdentifiedComponentClass(), true, Arrays.copyOf(this.getComponents(), parent));
        }
        return null;
    }

    private static class ComplexId<T extends Identifiable>
    extends Id<T> {
        private final String[] components;
        private final String[] associatedComponentName;

        public ComplexId(Context context, Class<T> identifiableType, String[] components) {
            super(context, identifiableType);
            this.components = components;
            this.associatedComponentName = new String[components.length];
        }

        @Override
        protected String getComponent(int index, String component, Context context) {
            if (index < 0 || index >= this.components.length) {
                if (context.isComponentRequired(component)) {
                    throw new IllegalArgumentException("Unknown component: " + component);
                }
                return null;
            }
            return this.components[index];
        }

        @Override
        public String[] getComponents() {
            return this.components;
        }

        @Override
        public int getComponentNumber() {
            return this.components.length;
        }

        @Override
        public String getRootComponent() {
            return this.components[0];
        }

        @Override
        void associateCurrentValueWith(int currentComponent, String componentName) {
            this.associatedComponentName[currentComponent] = componentName;
        }

        @Override
        String getComponentNameFor(int currentComponent) {
            return this.associatedComponentName[currentComponent];
        }
    }

    private static class SimpleId<T extends Identifiable>
    extends Id<T> {
        private final String root;
        private String componentName;

        private SimpleId(Context context, Class<T> identifiableType, String rootComponent) {
            super(context, identifiableType);
            this.root = rootComponent;
        }

        @Override
        protected String getComponent(int index, String component, Context context) {
            if (index != 0) {
                if (context.isComponentRequired(component)) {
                    throw new IllegalArgumentException("Unknown component: " + component);
                }
                return null;
            }
            return this.root;
        }

        @Override
        public String[] getComponents() {
            return new String[]{this.root};
        }

        @Override
        public int getComponentNumber() {
            return 1;
        }

        @Override
        public String getRootComponent() {
            return this.root;
        }

        @Override
        void associateCurrentValueWith(int currentComponent, String componentName) {
            if (currentComponent != 0) {
                throw new IllegalStateException("Shouldn't be possible");
            }
            this.componentName = componentName;
        }

        @Override
        String getComponentNameFor(int componentIndex) {
            if (componentIndex != 0) {
                throw new IllegalArgumentException("Invalid component index: " + componentIndex);
            }
            return this.componentName;
        }
    }
}

