/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.api.util;

import java.lang.reflect.ParameterizedType;
import java.util.HashMap;
import java.util.Map;

public abstract class Type<T, C> {
    private final String name;
    private final Class<T> valueType;
    private final Class<C> originatingClass;
    private static final Map<Class, Map<String, Type>> registeredTypes = new HashMap<Class, Map<String, Type>>(7);

    public Type(String name) {
        this.name = name;
        this.valueType = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        this.originatingClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[1];
        this.register(name);
    }

    private void register(String name) {
        Map<String, Type> typeMap = Type.getTypeMapFor(this.originatingClass);
        typeMap.put(name, this);
    }

    private static Map<String, Type> getTypeMapFor(Class originatingClass) {
        Map<String, Type> typeMap = registeredTypes.get(originatingClass);
        if (typeMap == null) {
            typeMap = new HashMap<String, Type>(7);
            registeredTypes.put(originatingClass, typeMap);
        }
        return typeMap;
    }

    public static Type forName(String name, Class originatingClass) {
        Map<String, Type> typeMap = Type.getTypeMapFor(originatingClass);
        Type type = typeMap.get(name);
        if (type != null) {
            return type;
        }
        throw new IllegalArgumentException("Unknown Type: " + name + " for originating class " + originatingClass.getCanonicalName());
    }

    public String getName() {
        return this.name;
    }

    public Class<T> getValueType() {
        return this.valueType;
    }

    public Class<C> getOriginatingClass() {
        return this.originatingClass;
    }
}

