/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.api;

import java.util.Collection;
import java.util.Iterator;
import org.gatein.api.GateIn;
import org.gatein.api.id.Id;
import org.gatein.api.portal.Navigation;
import org.gatein.api.portal.Page;
import org.gatein.api.portal.Portal;
import org.gatein.api.portal.Site;
import org.gatein.api.util.IterableIdentifiableCollection;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public abstract class NavigationPortletTestCase {
    protected GateIn gateIn;

    @BeforeTest
    public abstract void setUp();

    @Test
    public void shouldListSpecificGroupPages() {
        Site adminSite = this.gateIn.getGroupSite(new String[]{"platform", "administrators"});
        Navigation navigation = adminSite.getNavigation();
        Collection adminNodes = navigation.getChildren();
        assert (2 == adminNodes.size());
        Iterator iterator = adminNodes.iterator();
        Navigation administrationNode = (Navigation)iterator.next();
        assert ("Administration".equals(administrationNode.getDisplayName()));
        assert (2 == administrationNode.getChildren().size());
        Collection children = administrationNode.getChildren();
        for (Navigation child : children) {
            assert (child.equals(administrationNode.getChild(child.getName())));
            Page target = child.getTargetPage();
            assert (target.equals(this.gateIn.get((Id)target.getId())));
        }
        Navigation wsrp = (Navigation)iterator.next();
        assert ("WSRP".equals(wsrp.getDisplayName()));
        assert (1 == wsrp.getChildren().size());
        assert (!iterator.hasNext());
    }

    @Test(enabled=false)
    public void shouldListGroupPages() {
        IterableIdentifiableCollection rootSites = this.gateIn.getGroupSites("root");
        assert (3 == rootSites.size());
        Iterator sites = rootSites.iterator();
        this.checkGroupSite((Site)sites.next(), 0, 2, "Administrators");
        this.checkGroupSite((Site)sites.next(), 1, 1, "Executive Board");
        this.checkGroupSite((Site)sites.next(), 2, 1, "Users");
    }

    private void checkGroupSite(Site site, int priority, int navigationsNumber, String groupName) {
        assert (Site.GROUP.equals(site.getType()));
        assert (priority == site.getPriority());
        assert (site.getDisplayName().contains(groupName));
        Collection navigations = site.getNavigation().getChildren();
        assert (navigationsNumber == navigations.size());
        for (Navigation navigation : navigations) {
            assert (site.equals(navigation.getSite()));
        }
    }

    @Test(enabled=false)
    public void shouldListSitePages() {
        IterableIdentifiableCollection portalResult = this.gateIn.getPortalSites("root");
        assert (1 == portalResult.size());
        Iterator portals = portalResult.iterator();
        Portal portal = (Portal)portals.next();
        assert (Site.PORTAL.equals(portal.getType()));
        assert ("classic".equals(portal.getName()));
        assert (this.gateIn.getPortal(Site.Id.createPortal((String)"classic")).equals(portal));
        Collection navigations = portal.getNavigation().getChildren();
        assert (2 == navigations.size());
    }

    @Test(enabled=false)
    public void shouldListDashboardPages() {
        Site dashboard = this.gateIn.getDashboard("root");
        assert (Site.DASHBOARD.equals(dashboard.getType()));
        Collection nodes = dashboard.getNavigation().getChildren();
        assert (1 == nodes.size());
        assert ("Dashboard".equals(((Navigation)nodes.iterator().next()).getDisplayName()));
    }
}

