/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.api.content;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import org.gatein.api.GateIn;
import org.gatein.api.content.Category;
import org.gatein.api.content.Content;
import org.gatein.api.content.ContentRegistry;
import org.gatein.api.content.Gadget;
import org.gatein.api.content.ManagedContent;
import org.gatein.api.content.Portlet;
import org.gatein.api.content.WSRP;
import org.gatein.api.id.Id;
import org.gatein.api.portal.Portal;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public abstract class ContentTestCase {
    protected Portal portal;
    protected GateIn gateIn;

    @BeforeTest
    public abstract void setUp();

    @Test
    public void getInexistentCategoryShouldReturnNull() {
        assert (this.portal.getContentRegistry().getCategory("inexistent") == null);
    }

    @Test
    public void getOrCreateInexistentCategoryShouldCreateANewCategory() {
        assert (this.portal.getContentRegistry().getOrCreateCategory("inexistent") != null);
    }

    @Test
    public void assigningContentToACategory() {
        ContentRegistry registry = this.portal.getContentRegistry();
        Category category = registry.getOrCreateCategory("category");
        Portlet.Id id = this.gateIn.portletId("application", "portlet");
        Portlet portlet = (Portlet)registry.get((Id)id);
        ManagedContent managedContent = category.addContent((Content.Id)id, portlet.getName());
        assert (managedContent != null);
        assert (portlet.equals(managedContent.getContent()));
        String name = managedContent.getName();
        assert (managedContent.equals(category.getManagedContent(name)));
        assert (category.contains(name));
        assert (category.getKnownManagedContentNames().contains((Object)name));
        WSRP.Id wsrp = this.gateIn.wsrpPortletId("invoker", "portlet");
        ManagedContent managedWSRP = category.addContent((Content.Id)wsrp, "foo");
        assert (managedWSRP != null);
        assert (category.contains(managedWSRP.getName()));
    }

    @Test
    public void assigningAnApplicationToACategory() {
        ContentRegistry registry = this.portal.getContentRegistry();
        Category category = registry.getOrCreateCategory("category");
        Portlet portlet = (Portlet)registry.get((Id)this.gateIn.portletId("application", "portlet"));
        assert (portlet.getName().equals(portlet.getDisplayName()));
        Content.Id id = portlet.getId();
        ManagedContent managed = category.addContent(id, portlet.getName());
        assert (managed != null);
        assert (portlet.equals(managed.getContent()));
        assert (managed.equals(category.getManagedContent(managed.getName())));
    }

    @Test
    public void assigningAGadgetToACategory() throws URISyntaxException, MalformedURLException {
        ContentRegistry registry = this.portal.getContentRegistry();
        Category category = registry.getOrCreateCategory("category");
        Gadget.Id gadgetId = this.gateIn.gadgetId("gadgetName");
        Gadget gadget = (Gadget)registry.get((Id)gadgetId);
        assert ("gadgetName".equals(gadget.getName()));
        ManagedContent managedContent = category.addContent((Content.Id)gadgetId, gadget.getName());
        assert (managedContent != null);
        assert (gadget.equals(managedContent.getContent()));
        assert (managedContent.equals(category.getManagedContent(managedContent.getName())));
        URI uri = new URI("http://foo.bar.com/gadget.xml");
        gadgetId = this.gateIn.gadgetId(uri);
        gadget = (Gadget)registry.get((Id)gadgetId);
        assert (!gadget.isLocal());
        assert (uri.equals(gadget.getURI()));
        assert (uri.equals(((Gadget.RemoteData)gadget.getData()).getURI()));
        managedContent = category.addContent((Content.Id)gadgetId, gadget.getName());
        assert (managedContent != null);
        assert (gadget.equals(managedContent.getContent()));
        assert (managedContent.equals(category.getManagedContent(managedContent.getName())));
    }

    @Test
    public void creatingAGadgetFromSource() {
        ContentRegistry registry = this.portal.getContentRegistry();
        Gadget gadget = registry.createGadget("gadget", "source");
        assert (this.gateIn.gadgetId("gadget").equals(gadget.getId()));
        assert (gadget.getURI() != null);
        assert (gadget.isLocal());
        assert (gadget.getData() instanceof Gadget.LocalData);
        assert ("source".equals(((Gadget.LocalData)gadget.getData()).getSource()));
        assert (gadget.getReferenceURI() != null);
        assert (gadget.equals(registry.get((Id)gadget.getId())));
    }

    @Test
    public void removeContentFromCategory() {
        ContentRegistry registry = this.portal.getContentRegistry();
        Category category = registry.getOrCreateCategory("category");
        Portlet.Id id = this.gateIn.portletId("application", "portlet");
        Portlet portlet = (Portlet)registry.get((Id)id);
        ManagedContent managed = category.addContent((Content.Id)id, portlet.getName());
        assert (category.contains(managed.getName()));
        category.removeContent(managed.getName());
        assert (!category.contains(managed.getName()));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void addingContentToACategoryWithoutAValidNameShouldFail() {
        ContentRegistry registry = this.portal.getContentRegistry();
        Category category = registry.getOrCreateCategory("category");
        Portlet.Id id = this.gateIn.portletId("application", "portlet");
        category.addContent((Content.Id)id, null);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void addingContentToACategoryWithoutAValidIdShouldFail() {
        ContentRegistry registry = this.portal.getContentRegistry();
        Category category = registry.getOrCreateCategory("category");
        category.addContent(null, null);
    }
}

