/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.api.portal;

import org.gatein.api.GateIn;
import org.gatein.api.id.Id;
import org.gatein.api.portal.Navigation;
import org.gatein.api.portal.Page;
import org.gatein.api.portal.Portal;
import org.gatein.api.portal.Site;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public abstract class NavigationTestCase {
    protected GateIn gateIn;

    @BeforeTest
    public abstract void setUp();

    @Test
    public void creatingASimplePage() {
        Portal portal = this.gateIn.getDefaultPortal();
        String name = "name";
        String title = "title";
        Page page = portal.getPage(name);
        assert (name.equals(page.getId().toString()));
        assert (name.equals(page.getTitle())) : "By default, a Page's title should be the same as its name";
        assert (portal.equals(page.getSite()));
        page.setTitle(title);
        assert (title.equals(page.getTitle()));
    }

    @Test
    public void creatingANavigationShouldLinkNavigationAndNode() {
        Site.Id classic = Site.Id.createPortal((String)"classic");
        Portal portal = (Portal)this.gateIn.get((Id)classic);
        assert (portal.equals(this.gateIn.getPortal(classic)));
        Page page = portal.getPage("page");
        Page.Id pageId = page.getId();
        assert (page.equals(this.gateIn.get((Id)pageId)));
        Navigation nav = portal.getNavigation().getChild("page");
        assert (page.equals(nav.getTargetPage()));
        Page sub = portal.getPage("sub");
        assert (sub.equals(this.gateIn.get((Id)new Page.Id(page.getSite().getId(), "sub"))));
    }
}

