/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.api.support;

import org.gatein.api.GateIn;
import org.gatein.api.content.Content;
import org.gatein.api.portal.Site;
import org.gatein.api.util.Type;

public class TypeResolver {
    public static Type forName(String name, Class originatingClass) {
        if (originatingClass == null) {
            throw new IllegalArgumentException("Must pass a valid class for which a Type needs to be resolved");
        }
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Must pass a valid name for the Type to be resolved");
        }
        if (Site.class.equals((Object)originatingClass)) {
            if ("portal".equalsIgnoreCase(name)) {
                return Site.PORTAL;
            }
            if ("group".equalsIgnoreCase(name)) {
                return Site.GROUP;
            }
            if ("user".equalsIgnoreCase(name)) {
                return Site.DASHBOARD;
            }
        } else if (Content.class.equals((Object)originatingClass)) {
            if ("portlet".equalsIgnoreCase(name)) {
                return Content.PORTLET;
            }
            if ("gadget".equalsIgnoreCase(name)) {
                return Content.GADGET;
            }
            if ("wsrp".equalsIgnoreCase(name)) {
                return Content.WSRP;
            }
        } else if (GateIn.class.equals((Object)originatingClass) && "org.gatein.api.lifecyclemanager".equalsIgnoreCase(name)) {
            return GateIn.LIFECYCLE_MANAGER;
        }
        throw new IllegalArgumentException("Unknown Type '" + name + "' for class " + originatingClass.getName());
    }
}

