/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.api.portal;

import org.gatein.api.id.BaseId;
import org.gatein.api.id.Identifiable;
import org.gatein.api.portal.Navigation;
import org.gatein.api.portal.Page;
import org.gatein.api.util.Type;

public interface Site
extends Identifiable<Site> {
    public static final String PORTAL_TYPE_NAME = "portal";
    public static final String DASHBOARD_TYPE_NAME = "user";
    public static final String GROUP_TYPE_NAME = "group";
    public static final Type<Site> PORTAL = new Type<Site>("portal"){};
    public static final Type<Site> DASHBOARD = new Type<Site>("user"){};
    public static final Type<Site> GROUP = new Type<Site>("group"){};

    public Id getId();

    public Page getPage(String var1);

    public Navigation getNavigation();

    public Type<Site> getType();

    public int getPriority();

    public static final class Id
    extends BaseId<Site> {
        private final Type<Site> type;
        private final String name;

        public static Id create(Type<Site> type, String name) {
            return new Id(type, name);
        }

        public static Id createPortal(String name) {
            return Id.create(PORTAL, name);
        }

        public static Id createGroup(String name) {
            return Id.create(GROUP, name);
        }

        public static Id createDashboard(String name) {
            return Id.create(DASHBOARD, name);
        }

        private Id(Type<Site> type, String name) {
            if (type == null) {
                throw new NullPointerException();
            }
            if (name == null) {
                throw new NullPointerException();
            }
            this.type = type;
            this.name = name;
        }

        public Type<Site> getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Id) {
                Id that = (Id)obj;
                return this.type.equals(that.type) && this.name.equals(that.name);
            }
            return false;
        }

        public int hashCode() {
            return this.type.hashCode() & this.name.hashCode();
        }

        @Override
        public Class<Site> getIdentifiableType() {
            return Site.class;
        }
    }
}

