/*
 * Decompiled with CFR 0.152.
 */
package org.grails.orm.hibernate;

import grails.gorm.MultiTenant;
import java.io.IOException;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.sql.DataSource;
import org.grails.datastore.gorm.events.AutoTimestampEventListener;
import org.grails.datastore.gorm.events.ConfigurableApplicationContextEventPublisher;
import org.grails.datastore.gorm.events.ConfigurableApplicationEventPublisher;
import org.grails.datastore.gorm.events.DefaultApplicationEventPublisher;
import org.grails.datastore.gorm.jdbc.MultiTenantConnection;
import org.grails.datastore.gorm.jdbc.MultiTenantDataSource;
import org.grails.datastore.gorm.jdbc.connections.DataSourceConnectionSource;
import org.grails.datastore.gorm.jdbc.connections.DataSourceConnectionSourceFactory;
import org.grails.datastore.gorm.jdbc.connections.DataSourceSettings;
import org.grails.datastore.gorm.utils.ClasspathEntityScanner;
import org.grails.datastore.gorm.validation.constraints.MappingContextAwareConstraintFactory;
import org.grails.datastore.gorm.validation.constraints.builtin.UniqueConstraint;
import org.grails.datastore.gorm.validation.constraints.factory.ConstraintFactory;
import org.grails.datastore.gorm.validation.constraints.registry.ConstraintRegistry;
import org.grails.datastore.mapping.core.ConnectionNotFoundException;
import org.grails.datastore.mapping.core.Datastore;
import org.grails.datastore.mapping.core.DatastoreUtils;
import org.grails.datastore.mapping.core.Session;
import org.grails.datastore.mapping.core.connections.ConnectionSource;
import org.grails.datastore.mapping.core.connections.ConnectionSourceFactory;
import org.grails.datastore.mapping.core.connections.ConnectionSourceSettings;
import org.grails.datastore.mapping.core.connections.ConnectionSources;
import org.grails.datastore.mapping.core.connections.ConnectionSourcesInitializer;
import org.grails.datastore.mapping.core.connections.DefaultConnectionSource;
import org.grails.datastore.mapping.core.connections.SingletonConnectionSources;
import org.grails.datastore.mapping.core.exceptions.ConfigurationException;
import org.grails.datastore.mapping.engine.event.DatastoreInitializedEvent;
import org.grails.datastore.mapping.model.DatastoreConfigurationException;
import org.grails.datastore.mapping.model.MappingContext;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.multitenancy.AllTenantsResolver;
import org.grails.datastore.mapping.multitenancy.MultiTenancySettings;
import org.grails.datastore.mapping.validation.ValidatorRegistry;
import org.grails.orm.hibernate.AbstractHibernateDatastore;
import org.grails.orm.hibernate.GrailsHibernateTemplate;
import org.grails.orm.hibernate.GrailsHibernateTransactionManager;
import org.grails.orm.hibernate.HibernateGormEnhancer;
import org.grails.orm.hibernate.HibernateSession;
import org.grails.orm.hibernate.IHibernateTemplate;
import org.grails.orm.hibernate.MetadataIntegrator;
import org.grails.orm.hibernate.cfg.GrailsDomainBinder;
import org.grails.orm.hibernate.cfg.HibernateMappingContext;
import org.grails.orm.hibernate.connections.HibernateConnectionSource;
import org.grails.orm.hibernate.connections.HibernateConnectionSourceFactory;
import org.grails.orm.hibernate.connections.HibernateConnectionSourceSettings;
import org.grails.orm.hibernate.event.listener.HibernateEventListener;
import org.grails.orm.hibernate.multitenancy.MultiTenantEventListener;
import org.grails.orm.hibernate.support.ClosureEventTriggeringInterceptor;
import org.hibernate.FlushMode;
import org.hibernate.SessionFactory;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.SchemaAutoTooling;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.integrator.spi.Integrator;
import org.hibernate.integrator.spi.IntegratorService;
import org.hibernate.service.ServiceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.context.support.StaticMessageSource;
import org.springframework.core.env.PropertyResolver;
import org.springframework.jdbc.datasource.ConnectionHolder;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class HibernateDatastore
extends AbstractHibernateDatastore
implements MessageSourceAware {
    private static final Logger LOG = LoggerFactory.getLogger(HibernateDatastore.class);
    protected final GrailsHibernateTransactionManager transactionManager;
    protected ConfigurableApplicationEventPublisher eventPublisher;
    protected final HibernateGormEnhancer gormEnhancer;
    protected final Map<String, HibernateDatastore> datastoresByConnectionSource = new LinkedHashMap<String, HibernateDatastore>();
    protected final Metadata metadata = this.getMetadataInternal();

    public HibernateDatastore(ConnectionSources<SessionFactory, HibernateConnectionSourceSettings> connectionSources, HibernateMappingContext mappingContext, ConfigurableApplicationEventPublisher eventPublisher) {
        super(connectionSources, mappingContext);
        HibernateConnectionSource defaultConnectionSource = (HibernateConnectionSource)connectionSources.getDefaultConnectionSource();
        this.transactionManager = new GrailsHibernateTransactionManager((SessionFactory)defaultConnectionSource.getSource(), defaultConnectionSource.getDataSource(), FlushMode.valueOf((String)this.defaultFlushModeName));
        this.eventPublisher = eventPublisher;
        this.eventTriggeringInterceptor = new HibernateEventListener(this);
        this.autoTimestampEventListener = new AutoTimestampEventListener((Datastore)this);
        HibernateConnectionSourceSettings settings = (HibernateConnectionSourceSettings)defaultConnectionSource.getSettings();
        HibernateConnectionSourceSettings.HibernateSettings hibernateSettings = settings.getHibernate();
        ClosureEventTriggeringInterceptor interceptor = (ClosureEventTriggeringInterceptor)hibernateSettings.getEventTriggeringInterceptor();
        interceptor.setDatastore(this);
        interceptor.setEventPublisher(eventPublisher);
        this.registerEventListeners(this.eventPublisher);
        this.configureValidatorRegistry(settings, mappingContext);
        this.mappingContext.addMappingContextListener(new MappingContext.Listener(){

            public void persistentEntityAdded(PersistentEntity entity) {
                HibernateDatastore.this.gormEnhancer.registerEntity(entity);
            }
        });
        this.initializeConverters(this.mappingContext);
        if (!(connectionSources instanceof SingletonConnectionSources)) {
            HibernateDatastore parent = this;
            Iterable allConnectionSources = connectionSources.getAllConnectionSources();
            for (ConnectionSource connectionSource2 : allConnectionSources) {
                SingletonConnectionSources singletonConnectionSources = new SingletonConnectionSources(connectionSource2, connectionSources.getBaseConfiguration());
                HibernateDatastore childDatastore = "DEFAULT".equals(connectionSource2.getName()) ? this : this.createChildDatastore(mappingContext, eventPublisher, parent, (SingletonConnectionSources<SessionFactory, HibernateConnectionSourceSettings>)singletonConnectionSources);
                this.datastoresByConnectionSource.put(connectionSource2.getName(), childDatastore);
            }
            connectionSources.addListener(connectionSource -> {
                SingletonConnectionSources singletonConnectionSources = new SingletonConnectionSources(connectionSource, connectionSources.getBaseConfiguration());
                HibernateDatastore childDatastore = this.createChildDatastore(mappingContext, eventPublisher, parent, (SingletonConnectionSources<SessionFactory, HibernateConnectionSourceSettings>)singletonConnectionSources);
                this.datastoresByConnectionSource.put(connectionSource.getName(), childDatastore);
                this.registerAllEntitiesWithEnhancer();
            });
            if (this.multiTenantMode == MultiTenancySettings.MultiTenancyMode.SCHEMA) {
                if (this.tenantResolver instanceof AllTenantsResolver) {
                    AllTenantsResolver allTenantsResolver = (AllTenantsResolver)this.tenantResolver;
                    Iterable tenantIds = allTenantsResolver.resolveTenantIds();
                    for (Serializable tenantId : tenantIds) {
                        this.addTenantForSchemaInternal(tenantId.toString());
                    }
                } else {
                    Collection allSchemas = this.schemaHandler.resolveSchemaNames(defaultConnectionSource.getDataSource());
                    for (String schema : allSchemas) {
                        this.addTenantForSchemaInternal(schema);
                    }
                }
            }
        }
        this.gormEnhancer = this.initialize();
    }

    private HibernateDatastore createChildDatastore(HibernateMappingContext mappingContext, ConfigurableApplicationEventPublisher eventPublisher, final HibernateDatastore parent, SingletonConnectionSources<SessionFactory, HibernateConnectionSourceSettings> singletonConnectionSources) {
        return new HibernateDatastore((ConnectionSources)singletonConnectionSources, mappingContext, eventPublisher){

            @Override
            protected HibernateGormEnhancer initialize() {
                return null;
            }

            @Override
            public HibernateDatastore getDatastoreForConnection(String connectionName) {
                if (connectionName.equals("dataSource") || connectionName.equals("DEFAULT")) {
                    return parent;
                }
                HibernateDatastore hibernateDatastore = parent.datastoresByConnectionSource.get(connectionName);
                if (hibernateDatastore == null) {
                    throw new ConfigurationException("DataSource not found for name [" + connectionName + "] in configuration. Please check your multiple data sources configuration and try again.");
                }
                return hibernateDatastore;
            }
        };
    }

    public HibernateDatastore(PropertyResolver configuration, HibernateConnectionSourceFactory connectionSourceFactory, ConfigurableApplicationEventPublisher eventPublisher) {
        this((ConnectionSources<SessionFactory, HibernateConnectionSourceSettings>)ConnectionSourcesInitializer.create((ConnectionSourceFactory)connectionSourceFactory, (PropertyResolver)DatastoreUtils.preparePropertyResolver((PropertyResolver)configuration, (String[])new String[]{"dataSource", "hibernate", "grails"})), connectionSourceFactory.getMappingContext(), eventPublisher);
    }

    public HibernateDatastore(PropertyResolver configuration, HibernateConnectionSourceFactory connectionSourceFactory) {
        this((ConnectionSources<SessionFactory, HibernateConnectionSourceSettings>)ConnectionSourcesInitializer.create((ConnectionSourceFactory)connectionSourceFactory, (PropertyResolver)DatastoreUtils.preparePropertyResolver((PropertyResolver)configuration, (String[])new String[]{"dataSource", "hibernate", "grails"})), connectionSourceFactory.getMappingContext(), (ConfigurableApplicationEventPublisher)new DefaultApplicationEventPublisher());
    }

    public HibernateDatastore(PropertyResolver configuration, ConfigurableApplicationEventPublisher eventPublisher, Class ... classes) {
        this(configuration, new HibernateConnectionSourceFactory(classes), eventPublisher);
    }

    public HibernateDatastore(DataSource dataSource, PropertyResolver configuration, ConfigurableApplicationEventPublisher eventPublisher, Class ... classes) {
        this(configuration, HibernateDatastore.createConnectionFactoryForDataSource(dataSource, classes), eventPublisher);
    }

    public HibernateDatastore(PropertyResolver configuration, ConfigurableApplicationEventPublisher eventPublisher, Package ... packagesToScan) {
        this(configuration, eventPublisher, new ClasspathEntityScanner().scan(packagesToScan));
    }

    public HibernateDatastore(DataSource dataSource, PropertyResolver configuration, ConfigurableApplicationEventPublisher eventPublisher, Package ... packagesToScan) {
        this(dataSource, configuration, eventPublisher, new ClasspathEntityScanner().scan(packagesToScan));
    }

    public HibernateDatastore(PropertyResolver configuration, Class ... classes) {
        this(configuration, new HibernateConnectionSourceFactory(classes));
    }

    public HibernateDatastore(PropertyResolver configuration, Package ... packagesToScan) {
        this(configuration, new ClasspathEntityScanner().scan(packagesToScan));
    }

    public HibernateDatastore(Map<String, Object> configuration, Class ... classes) {
        this(DatastoreUtils.createPropertyResolver(configuration), new HibernateConnectionSourceFactory(classes));
    }

    public HibernateDatastore(Map<String, Object> configuration, Package ... packagesToScan) {
        this(DatastoreUtils.createPropertyResolver(configuration), packagesToScan);
    }

    public HibernateDatastore(Class ... classes) {
        this(DatastoreUtils.createPropertyResolver(Collections.singletonMap("dataSource.dbCreate", "create-drop")), new HibernateConnectionSourceFactory(classes));
    }

    public HibernateDatastore(Package ... packagesToScan) {
        this(new ClasspathEntityScanner().scan(packagesToScan));
    }

    public HibernateDatastore(Package packageToScan) {
        this(new ClasspathEntityScanner().scan(new Package[]{packageToScan}));
    }

    public ApplicationEventPublisher getApplicationEventPublisher() {
        return this.eventPublisher;
    }

    public GrailsHibernateTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    @Override
    public HibernateDatastore getDatastoreForConnection(String connectionName) {
        if (connectionName.equals("dataSource") || connectionName.equals("DEFAULT")) {
            return this;
        }
        HibernateDatastore hibernateDatastore = this.datastoresByConnectionSource.get(connectionName);
        if (hibernateDatastore == null) {
            throw new ConfigurationException("DataSource not found for name [" + connectionName + "] in configuration. Please check your multiple data sources configuration and try again.");
        }
        return hibernateDatastore;
    }

    public String toString() {
        return "HibernateDatastore: " + this.getDataSourceName();
    }

    public HibernateMappingContext getMappingContext() {
        return (HibernateMappingContext)super.getMappingContext();
    }

    @Override
    public void setMessageSource(MessageSource messageSource) {
        HibernateMappingContext mappingContext = this.getMappingContext();
        ValidatorRegistry validatorRegistry = this.createValidatorRegistry(messageSource);
        HibernateConnectionSourceSettings settings = (HibernateConnectionSourceSettings)this.getConnectionSources().getDefaultConnectionSource().getSettings();
        this.configureValidatorRegistry(settings, mappingContext, validatorRegistry, messageSource);
    }

    protected void registerEventListeners(ConfigurableApplicationEventPublisher eventPublisher) {
        eventPublisher.addApplicationListener((ApplicationListener)this.autoTimestampEventListener);
        if (this.multiTenantMode == MultiTenancySettings.MultiTenancyMode.DISCRIMINATOR) {
            eventPublisher.addApplicationListener((ApplicationListener)new MultiTenantEventListener());
        }
        eventPublisher.addApplicationListener((ApplicationListener)this.eventTriggeringInterceptor);
    }

    protected void configureValidatorRegistry(HibernateConnectionSourceSettings settings, HibernateMappingContext mappingContext) {
        StaticMessageSource messageSource = new StaticMessageSource();
        ValidatorRegistry defaultValidatorRegistry = this.createValidatorRegistry((MessageSource)messageSource);
        this.configureValidatorRegistry(settings, mappingContext, defaultValidatorRegistry, (MessageSource)messageSource);
    }

    protected void configureValidatorRegistry(HibernateConnectionSourceSettings settings, HibernateMappingContext mappingContext, ValidatorRegistry validatorRegistry, MessageSource messageSource) {
        if (validatorRegistry instanceof ConstraintRegistry) {
            ((ConstraintRegistry)validatorRegistry).addConstraintFactory((ConstraintFactory)new MappingContextAwareConstraintFactory(UniqueConstraint.class, messageSource, (MappingContext)mappingContext));
        }
        mappingContext.setValidatorRegistry(validatorRegistry);
    }

    protected HibernateGormEnhancer initialize() {
        final HibernateConnectionSource defaultConnectionSource = (HibernateConnectionSource)this.getConnectionSources().getDefaultConnectionSource();
        if (this.multiTenantMode == MultiTenancySettings.MultiTenancyMode.SCHEMA) {
            return new HibernateGormEnhancer((Datastore)this, (PlatformTransactionManager)this.transactionManager, defaultConnectionSource.getSettings()){

                public List<String> allQualifiers(Datastore datastore, PersistentEntity entity) {
                    List allQualifiers;
                    block5: {
                        allQualifiers = super.allQualifiers(datastore, entity);
                        if (!MultiTenant.class.isAssignableFrom(entity.getJavaClass())) break block5;
                        if (HibernateDatastore.this.tenantResolver instanceof AllTenantsResolver) {
                            Iterable tenantIds = ((AllTenantsResolver)HibernateDatastore.this.tenantResolver).resolveTenantIds();
                            for (Serializable id : tenantIds) {
                                allQualifiers.add(id.toString());
                            }
                        } else {
                            Collection schemaNames = HibernateDatastore.this.schemaHandler.resolveSchemaNames(defaultConnectionSource.getDataSource());
                            for (String schemaName : schemaNames) {
                                if (schemaName.equals("INFORMATION_SCHEMA") || schemaName.equals("PUBLIC")) continue;
                                for (String connectionName : HibernateDatastore.this.datastoresByConnectionSource.keySet()) {
                                    if (!schemaName.equalsIgnoreCase(connectionName)) continue;
                                    allQualifiers.add(connectionName);
                                }
                            }
                        }
                    }
                    return allQualifiers;
                }
            };
        }
        return new HibernateGormEnhancer((Datastore)this, (PlatformTransactionManager)this.transactionManager, defaultConnectionSource.getSettings());
    }

    public boolean hasCurrentSession() {
        return TransactionSynchronizationManager.getResource((Object)this.sessionFactory) != null;
    }

    protected Session createSession(PropertyResolver connectionDetails) {
        return new HibernateSession(this, this.sessionFactory);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if (applicationContext instanceof ConfigurableApplicationContext) {
            super.setApplicationContext(applicationContext);
            for (HibernateDatastore hibernateDatastore : this.datastoresByConnectionSource.values()) {
                if (hibernateDatastore == this) continue;
                hibernateDatastore.setApplicationContext(applicationContext);
            }
            this.eventPublisher = new ConfigurableApplicationContextEventPublisher((ConfigurableApplicationContext)applicationContext);
            HibernateConnectionSourceSettings settings = (HibernateConnectionSourceSettings)this.getConnectionSources().getDefaultConnectionSource().getSettings();
            HibernateConnectionSourceSettings.HibernateSettings hibernateSettings = settings.getHibernate();
            ClosureEventTriggeringInterceptor interceptor = (ClosureEventTriggeringInterceptor)hibernateSettings.getEventTriggeringInterceptor();
            interceptor.setDatastore(this);
            interceptor.setEventPublisher(this.eventPublisher);
            HibernateMappingContext mappingContext = this.getMappingContext();
            ValidatorRegistry validatorRegistry = this.createValidatorRegistry((MessageSource)applicationContext);
            this.configureValidatorRegistry(settings, mappingContext, validatorRegistry, (MessageSource)applicationContext);
            mappingContext.setValidatorRegistry(validatorRegistry);
            this.registerEventListeners(this.eventPublisher);
            this.eventPublisher.publishEvent((ApplicationEvent)new DatastoreInitializedEvent((Object)this));
        }
    }

    @Override
    public IHibernateTemplate getHibernateTemplate(int flushMode) {
        return new GrailsHibernateTemplate(this.getSessionFactory(), this, flushMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void withFlushMode(AbstractHibernateDatastore.FlushMode flushMode, Callable<Boolean> callable) {
        org.hibernate.Session session = this.sessionFactory.getCurrentSession();
        FlushMode previousMode = null;
        Boolean reset = true;
        try {
            if (session != null) {
                previousMode = session.getHibernateFlushMode();
                session.setHibernateFlushMode(FlushMode.valueOf((String)flushMode.name()));
            }
            try {
                reset = callable.call();
            }
            catch (Exception e) {
                reset = false;
            }
        }
        finally {
            if (session != null && previousMode != null && reset.booleanValue()) {
                session.setHibernateFlushMode(previousMode);
            }
        }
    }

    @Override
    public org.hibernate.Session openSession() {
        org.hibernate.Session session = this.sessionFactory.openSession();
        session.setHibernateFlushMode(FlushMode.valueOf((String)this.defaultFlushModeName));
        return session;
    }

    public Session getCurrentSession() throws ConnectionNotFoundException {
        return new HibernateSession(this, this.sessionFactory, this.getDefaultFlushMode());
    }

    @Override
    public void destroy() {
        try {
            super.destroy();
        }
        finally {
            GrailsDomainBinder.clearMappingCache();
            try {
                this.gormEnhancer.close();
            }
            catch (IOException e) {
                LOG.error("There was an error shutting down GORM enhancer", (Throwable)e);
            }
        }
    }

    public void addTenantForSchema(String schemaName) {
        Object existing;
        this.addTenantForSchemaInternal(schemaName);
        this.registerAllEntitiesWithEnhancer();
        HibernateConnectionSource defaultConnectionSource = (HibernateConnectionSource)this.connectionSources.getDefaultConnectionSource();
        DataSource dataSource = defaultConnectionSource.getDataSource();
        if (dataSource instanceof TransactionAwareDataSourceProxy) {
            dataSource = ((TransactionAwareDataSourceProxy)dataSource).getTargetDataSource();
        }
        if ((existing = TransactionSynchronizationManager.getResource((Object)dataSource)) instanceof ConnectionHolder) {
            ConnectionHolder connectionHolder = (ConnectionHolder)existing;
            Connection connection = connectionHolder.getConnection();
            try {
                if (!connection.isClosed() && !connection.isReadOnly()) {
                    this.schemaHandler.useDefaultSchema(connection);
                }
            }
            catch (SQLException e) {
                throw new DatastoreConfigurationException("Failed to reset to default schema: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    protected void registerAllEntitiesWithEnhancer() {
        for (PersistentEntity persistentEntity : this.mappingContext.getPersistentEntities()) {
            this.gormEnhancer.registerEntity(persistentEntity);
        }
    }

    private void addTenantForSchemaInternal(final String schemaName) {
        SchemaAutoTooling schemaAutoTooling;
        HibernateConnectionSourceSettings tenantSettings;
        if (this.multiTenantMode != MultiTenancySettings.MultiTenancyMode.SCHEMA) {
            throw new ConfigurationException("The method [addTenantForSchema] can only be called with multi-tenancy mode SCHEMA. Current mode is: " + this.multiTenantMode);
        }
        HibernateConnectionSourceFactory factory = (HibernateConnectionSourceFactory)this.connectionSources.getFactory();
        HibernateConnectionSource defaultConnectionSource = (HibernateConnectionSource)this.connectionSources.getDefaultConnectionSource();
        try {
            tenantSettings = (HibernateConnectionSourceSettings)((HibernateConnectionSourceSettings)this.connectionSources.getDefaultConnectionSource().getSettings()).clone();
        }
        catch (CloneNotSupportedException e) {
            throw new ConfigurationException("Couldn't clone default Hibernate settings! " + e.getMessage(), (Throwable)e);
        }
        tenantSettings.getHibernate().put("hibernate.default_schema", schemaName);
        String dbCreate = tenantSettings.getDataSource().getDbCreate();
        SchemaAutoTooling schemaAutoTooling2 = schemaAutoTooling = dbCreate != null ? SchemaAutoTooling.interpret((String)dbCreate) : null;
        if (schemaAutoTooling != null && schemaAutoTooling != SchemaAutoTooling.VALIDATE && schemaAutoTooling != SchemaAutoTooling.NONE) {
            Connection connection = null;
            try {
                connection = defaultConnectionSource.getDataSource().getConnection();
                try {
                    this.schemaHandler.useSchema(connection, schemaName);
                }
                catch (Exception e) {
                    this.schemaHandler.createSchema(connection, schemaName);
                }
            }
            catch (SQLException e) {
                throw new DatastoreConfigurationException(String.format("Failed to create schema for name [%s]", schemaName));
            }
            finally {
                if (connection != null) {
                    try {
                        this.schemaHandler.useDefaultSchema(connection);
                        connection.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
        DataSource dataSource = defaultConnectionSource.getDataSource();
        dataSource = new MultiTenantDataSource(dataSource, schemaName){

            public Connection getConnection() throws SQLException {
                Connection connection = super.getConnection();
                HibernateDatastore.this.schemaHandler.useSchema(connection, schemaName);
                return new MultiTenantConnection(connection, HibernateDatastore.this.schemaHandler);
            }

            public Connection getConnection(String username, String password) throws SQLException {
                Connection connection = super.getConnection(username, password);
                HibernateDatastore.this.schemaHandler.useSchema(connection, schemaName);
                return new MultiTenantConnection(connection, HibernateDatastore.this.schemaHandler);
            }
        };
        DefaultConnectionSource dataSourceConnectionSource = new DefaultConnectionSource(schemaName, (Object)dataSource, (ConnectionSourceSettings)tenantSettings.getDataSource());
        ConnectionSource<SessionFactory, HibernateConnectionSourceSettings> connectionSource = factory.create(schemaName, (ConnectionSource<DataSource, DataSourceSettings>)dataSourceConnectionSource, tenantSettings);
        SingletonConnectionSources singletonConnectionSources = new SingletonConnectionSources(connectionSource, this.connectionSources.getBaseConfiguration());
        HibernateDatastore childDatastore = new HibernateDatastore((ConnectionSources)singletonConnectionSources, (HibernateMappingContext)this.mappingContext, this.eventPublisher){

            @Override
            protected HibernateGormEnhancer initialize() {
                return null;
            }
        };
        this.datastoresByConnectionSource.put(connectionSource.getName(), childDatastore);
    }

    private Metadata getMetadataInternal() {
        Metadata metadata = null;
        ServiceRegistry bootstrapServiceRegistry = ((SessionFactoryImplementor)this.sessionFactory).getServiceRegistry().getParentServiceRegistry();
        Iterable integrators = ((IntegratorService)bootstrapServiceRegistry.getService(IntegratorService.class)).getIntegrators();
        for (Integrator integrator : integrators) {
            if (!(integrator instanceof MetadataIntegrator)) continue;
            metadata = ((MetadataIntegrator)integrator).getMetadata();
        }
        return metadata;
    }

    private static HibernateConnectionSourceFactory createConnectionFactoryForDataSource(final DataSource dataSource, Class ... classes) {
        HibernateConnectionSourceFactory hibernateConnectionSourceFactory = new HibernateConnectionSourceFactory(classes);
        hibernateConnectionSourceFactory.setDataSourceConnectionSourceFactory(new DataSourceConnectionSourceFactory(){

            public ConnectionSource<DataSource, DataSourceSettings> create(String name, DataSourceSettings settings) {
                if ("DEFAULT".equals(name)) {
                    return new DataSourceConnectionSource("DEFAULT", dataSource, settings);
                }
                return super.create(name, settings);
            }
        });
        return hibernateConnectionSourceFactory;
    }
}

