/*
 * Decompiled with CFR 0.152.
 */
package org.grails.orm.hibernate;

import java.io.File;
import java.util.Map;
import java.util.Properties;
import javax.naming.NameNotFoundException;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.grails.orm.hibernate.HibernateEventListeners;
import org.grails.orm.hibernate.cfg.HibernateMappingContext;
import org.grails.orm.hibernate.cfg.HibernateMappingContextConfiguration;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.NamingStrategy;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternUtils;
import org.springframework.orm.hibernate5.HibernateExceptionTranslator;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.util.Assert;

public class HibernateMappingContextSessionFactoryBean
extends HibernateExceptionTranslator
implements FactoryBean<SessionFactory>,
ResourceLoaderAware,
DisposableBean,
ApplicationContextAware,
InitializingBean,
BeanClassLoaderAware {
    protected Class<? extends HibernateMappingContextConfiguration> configClass = HibernateMappingContextConfiguration.class;
    protected HibernateMappingContext hibernateMappingContext;
    protected PlatformTransactionManager transactionManager;
    private DataSource dataSource;
    private Resource[] configLocations;
    private String[] mappingResources;
    private Resource[] mappingLocations;
    private Resource[] cacheableMappingLocations;
    private Resource[] mappingJarLocations;
    private Resource[] mappingDirectoryLocations;
    private Interceptor entityInterceptor;
    private NamingStrategy namingStrategy;
    private Properties hibernateProperties;
    private Class<?>[] annotatedClasses;
    private String[] annotatedPackages;
    private String[] packagesToScan;
    private ResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();
    private HibernateMappingContextConfiguration configuration;
    private SessionFactory sessionFactory;
    private static final Log LOG = LogFactory.getLog(HibernateMappingContextSessionFactoryBean.class);
    protected Class<?> currentSessionContextClass;
    protected Map<String, Object> eventListeners;
    protected HibernateEventListeners hibernateEventListeners;
    protected ApplicationContext applicationContext;
    protected boolean proxyIfReloadEnabled = false;
    protected String sessionFactoryBeanName = "sessionFactory";
    protected String dataSourceName = "DEFAULT";
    protected ClassLoader classLoader;

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void afterPropertiesSet() throws Exception {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this.classLoader);
            this.buildSessionFactory();
        }
        finally {
            thread.setContextClassLoader(cl);
        }
    }

    public PlatformTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public void setHibernateMappingContext(HibernateMappingContext hibernateMappingContext) {
        this.hibernateMappingContext = hibernateMappingContext;
    }

    public void setConfigClass(Class<? extends HibernateMappingContextConfiguration> configClass) {
        this.configClass = configClass;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setConfigLocation(Resource configLocation) {
        this.configLocations = new Resource[]{configLocation};
    }

    public void setConfigLocations(Resource[] configLocations) {
        this.configLocations = configLocations;
    }

    public Resource[] getConfigLocations() {
        return this.configLocations;
    }

    public void setMappingResources(String[] mappingResources) {
        this.mappingResources = mappingResources;
    }

    public String[] getMappingResources() {
        return this.mappingResources;
    }

    public void setMappingLocations(Resource[] mappingLocations) {
        this.mappingLocations = mappingLocations;
    }

    public Resource[] getMappingLocations() {
        return this.mappingLocations;
    }

    public void setCacheableMappingLocations(Resource[] cacheableMappingLocations) {
        this.cacheableMappingLocations = cacheableMappingLocations;
    }

    public Resource[] getCacheableMappingLocations() {
        return this.cacheableMappingLocations;
    }

    public void setMappingJarLocations(Resource[] mappingJarLocations) {
        this.mappingJarLocations = mappingJarLocations;
    }

    public Resource[] getMappingJarLocations() {
        return this.mappingJarLocations;
    }

    public void setMappingDirectoryLocations(Resource[] mappingDirectoryLocations) {
        this.mappingDirectoryLocations = mappingDirectoryLocations;
    }

    public Resource[] getMappingDirectoryLocations() {
        return this.mappingDirectoryLocations;
    }

    public void setEntityInterceptor(Interceptor entityInterceptor) {
        this.entityInterceptor = entityInterceptor;
    }

    public Interceptor getEntityInterceptor() {
        return this.entityInterceptor;
    }

    public void setNamingStrategy(NamingStrategy namingStrategy) {
        this.namingStrategy = namingStrategy;
    }

    public NamingStrategy getNamingStrategy() {
        return this.namingStrategy;
    }

    public void setHibernateProperties(Properties hibernateProperties) {
        this.hibernateProperties = hibernateProperties;
    }

    public Properties getHibernateProperties() {
        if (this.hibernateProperties == null) {
            this.hibernateProperties = new Properties();
        }
        return this.hibernateProperties;
    }

    public void setAnnotatedClasses(Class<?>[] annotatedClasses) {
        this.annotatedClasses = annotatedClasses;
    }

    public Class<?>[] getAnnotatedClasses() {
        return this.annotatedClasses;
    }

    public void setAnnotatedPackages(String[] annotatedPackages) {
        this.annotatedPackages = annotatedPackages;
    }

    public String[] getAnnotatedPackages() {
        return this.annotatedPackages;
    }

    public void setPackagesToScan(String ... packagesToScan) {
        this.packagesToScan = packagesToScan;
    }

    public String[] getPackagesToScan() {
        return this.packagesToScan;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourcePatternResolver = ResourcePatternUtils.getResourcePatternResolver((ResourceLoader)resourceLoader);
    }

    public void setProxyIfReloadEnabled(boolean proxyIfReloadEnabled) {
        this.proxyIfReloadEnabled = proxyIfReloadEnabled;
    }

    public boolean isProxyIfReloadEnabled() {
        return this.proxyIfReloadEnabled;
    }

    public void setCurrentSessionContextClass(Class<?> currentSessionContextClass) {
        this.currentSessionContextClass = currentSessionContextClass;
    }

    public Class<?> getCurrentSessionContextClass() {
        return this.currentSessionContextClass;
    }

    public Class<? extends HibernateMappingContextConfiguration> getConfigClass() {
        return this.configClass;
    }

    public void setHibernateEventListeners(HibernateEventListeners listeners) {
        this.hibernateEventListeners = listeners;
    }

    public HibernateEventListeners getHibernateEventListeners() {
        return this.hibernateEventListeners;
    }

    public void setSessionFactoryBeanName(String name) {
        this.sessionFactoryBeanName = name;
    }

    public String getSessionFactoryBeanName() {
        return this.sessionFactoryBeanName;
    }

    public void setDataSourceName(String name) {
        this.dataSourceName = name;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setEventListeners(Map<String, Object> eventListeners) {
        this.eventListeners = eventListeners;
    }

    public Map<String, Object> getEventListeners() {
        return this.eventListeners;
    }

    protected void buildSessionFactory() throws Exception {
        this.configuration = this.newConfiguration();
        if (this.hibernateMappingContext == null) {
            throw new IllegalArgumentException("HibernateMappingContext is required.");
        }
        this.configuration.setHibernateMappingContext(this.hibernateMappingContext);
        if (this.configLocations != null) {
            for (Resource resource : this.configLocations) {
                this.configuration.configure(resource.getURL());
            }
        }
        if (this.mappingResources != null) {
            for (String string : this.mappingResources) {
                ClassPathResource mr = new ClassPathResource(string.trim(), this.resourcePatternResolver.getClassLoader());
                this.configuration.addInputStream(mr.getInputStream());
            }
        }
        if (this.mappingLocations != null) {
            for (Resource resource : this.mappingLocations) {
                this.configuration.addInputStream(resource.getInputStream());
            }
        }
        if (this.cacheableMappingLocations != null) {
            for (Resource resource : this.cacheableMappingLocations) {
                this.configuration.addCacheableFile(resource.getFile());
            }
        }
        if (this.mappingJarLocations != null) {
            for (Resource resource : this.mappingJarLocations) {
                this.configuration.addJar(resource.getFile());
            }
        }
        if (this.mappingDirectoryLocations != null) {
            for (Resource resource : this.mappingDirectoryLocations) {
                File file = resource.getFile();
                if (!file.isDirectory()) {
                    throw new IllegalArgumentException("Mapping directory location [" + resource + "] does not denote a directory");
                }
                this.configuration.addDirectory(file);
            }
        }
        if (this.entityInterceptor != null) {
            this.configuration.setInterceptor(this.entityInterceptor);
        }
        if (this.namingStrategy != null) {
            // empty if block
        }
        if (this.hibernateProperties != null) {
            this.configuration.addProperties(this.hibernateProperties);
        }
        if (this.annotatedClasses != null) {
            this.configuration.addAnnotatedClasses(this.annotatedClasses);
        }
        if (this.annotatedPackages != null) {
            this.configuration.addPackages(this.annotatedPackages);
        }
        if (this.packagesToScan != null) {
            this.configuration.scanPackages(this.packagesToScan);
        }
        if (this.eventListeners != null) {
            this.configuration.setEventListeners(this.eventListeners);
        }
        this.sessionFactory = this.doBuildSessionFactory();
    }

    protected SessionFactory doBuildSessionFactory() {
        return this.configuration.buildSessionFactory();
    }

    public final Configuration getConfiguration() {
        Assert.state((this.configuration != null ? 1 : 0) != 0, (String)"Configuration not initialized yet");
        return this.configuration;
    }

    public SessionFactory getObject() {
        return this.sessionFactory;
    }

    public Class<?> getObjectType() {
        return this.sessionFactory == null ? SessionFactory.class : this.sessionFactory.getClass();
    }

    public boolean isSingleton() {
        return true;
    }

    public void destroy() {
        try {
            this.sessionFactory.close();
        }
        catch (HibernateException e) {
            if (e.getCause() instanceof NameNotFoundException) {
                LOG.debug((Object)e.getCause().getMessage(), (Throwable)e);
            }
            throw e;
        }
    }

    protected HibernateMappingContextConfiguration newConfiguration() throws Exception {
        if (this.configClass == null) {
            this.configClass = HibernateMappingContextConfiguration.class;
        }
        HibernateMappingContextConfiguration config = (HibernateMappingContextConfiguration)((Object)BeanUtils.instantiateClass(this.configClass));
        config.setDataSourceName(this.dataSourceName);
        config.setApplicationContext(this.applicationContext);
        config.setSessionFactoryBeanName(this.sessionFactoryBeanName);
        config.setHibernateEventListeners(this.hibernateEventListeners);
        if (this.currentSessionContextClass != null) {
            config.setProperty("hibernate.current_session_context_class", this.currentSessionContextClass.getName());
        }
        return config;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

