/*
 * Decompiled with CFR 0.152.
 */
package org.grails.orm.hibernate;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.persistence.FlushModeType;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import org.grails.datastore.gorm.timestamp.DefaultTimestampProvider;
import org.grails.datastore.mapping.core.Session;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.PersistentProperty;
import org.grails.datastore.mapping.proxy.ProxyHandler;
import org.grails.datastore.mapping.query.Query;
import org.grails.datastore.mapping.query.api.QueryableCriteria;
import org.grails.datastore.mapping.query.event.PostQueryEvent;
import org.grails.datastore.mapping.query.event.PreQueryEvent;
import org.grails.datastore.mapping.query.jpa.JpaQueryBuilder;
import org.grails.datastore.mapping.query.jpa.JpaQueryInfo;
import org.grails.datastore.mapping.reflect.ClassPropertyFetcher;
import org.grails.orm.hibernate.AbstractHibernateSession;
import org.grails.orm.hibernate.GrailsHibernateTemplate;
import org.grails.orm.hibernate.HibernateDatastore;
import org.grails.orm.hibernate.proxy.HibernateProxyHandler;
import org.grails.orm.hibernate.query.HibernateHqlQuery;
import org.grails.orm.hibernate.query.HibernateQuery;
import org.hibernate.Criteria;
import org.hibernate.SessionFactory;
import org.hibernate.proxy.HibernateProxy;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;

public class HibernateSession
extends AbstractHibernateSession {
    ProxyHandler proxyHandler = new HibernateProxyHandler();
    DefaultTimestampProvider timestampProvider;

    public HibernateSession(HibernateDatastore hibernateDatastore, SessionFactory sessionFactory, int defaultFlushMode) {
        super(hibernateDatastore, sessionFactory);
        this.hibernateTemplate = new GrailsHibernateTemplate(sessionFactory, (HibernateDatastore)this.getDatastore());
    }

    public HibernateSession(HibernateDatastore hibernateDatastore, SessionFactory sessionFactory) {
        this(hibernateDatastore, sessionFactory, hibernateDatastore.getDefaultFlushMode());
    }

    public Serializable getObjectIdentifier(Object instance) {
        if (instance == null) {
            return null;
        }
        if (this.proxyHandler.isProxy(instance)) {
            return ((HibernateProxy)instance).getHibernateLazyInitializer().getIdentifier();
        }
        Class<?> type = instance.getClass();
        ClassPropertyFetcher cpf = ClassPropertyFetcher.forClass(type);
        PersistentEntity persistentEntity = this.getMappingContext().getPersistentEntity(type.getName());
        if (persistentEntity != null) {
            return (Serializable)cpf.getPropertyValue(instance, persistentEntity.getIdentity().getName());
        }
        return null;
    }

    public long deleteAll(QueryableCriteria criteria) {
        return this.getHibernateTemplate().execute(session -> {
            JpaQueryBuilder builder = new JpaQueryBuilder(criteria);
            builder.setConversionService(this.getMappingContext().getConversionService());
            builder.setHibernateCompatible(true);
            JpaQueryInfo jpaQueryInfo = builder.buildDelete();
            org.hibernate.query.Query query = session.createQuery(jpaQueryInfo.getQuery());
            this.getHibernateTemplate().applySettings(query);
            List parameters = jpaQueryInfo.getParameters();
            if (parameters != null) {
                int count = parameters.size();
                for (int i = 0; i < count; ++i) {
                    query.setParameter("p" + (i + 1), parameters.get(i));
                }
            }
            HibernateHqlQuery hqlQuery = new HibernateHqlQuery((Session)this, criteria.getPersistentEntity(), query);
            ApplicationEventPublisher applicationEventPublisher = this.datastore.getApplicationEventPublisher();
            applicationEventPublisher.publishEvent((ApplicationEvent)new PreQueryEvent((Object)this.datastore, (Query)hqlQuery));
            int result = query.executeUpdate();
            applicationEventPublisher.publishEvent((ApplicationEvent)new PostQueryEvent((Object)this.datastore, (Query)hqlQuery, Collections.singletonList(result)));
            return result;
        }).intValue();
    }

    public long updateAll(QueryableCriteria criteria, Map<String, Object> properties) {
        return this.getHibernateTemplate().execute(session -> {
            JpaQueryBuilder builder = new JpaQueryBuilder(criteria);
            builder.setConversionService(this.getMappingContext().getConversionService());
            builder.setHibernateCompatible(true);
            PersistentEntity targetEntity = criteria.getPersistentEntity();
            PersistentProperty lastUpdated = targetEntity.getPropertyByName("lastUpdated");
            if (lastUpdated != null && targetEntity.getMapping().getMappedForm().isAutoTimestamp()) {
                if (this.timestampProvider == null) {
                    this.timestampProvider = new DefaultTimestampProvider();
                }
                properties.put("lastUpdated", this.timestampProvider.createTimestamp(lastUpdated.getType()));
            }
            JpaQueryInfo jpaQueryInfo = builder.buildUpdate(properties);
            org.hibernate.query.Query query = session.createQuery(jpaQueryInfo.getQuery());
            this.getHibernateTemplate().applySettings(query);
            List parameters = jpaQueryInfo.getParameters();
            if (parameters != null) {
                int count = parameters.size();
                for (int i = 0; i < count; ++i) {
                    query.setParameter("p" + (i + 1), parameters.get(i));
                }
            }
            HibernateHqlQuery hqlQuery = new HibernateHqlQuery((Session)this, targetEntity, query);
            ApplicationEventPublisher applicationEventPublisher = this.datastore.getApplicationEventPublisher();
            applicationEventPublisher.publishEvent((ApplicationEvent)new PreQueryEvent((Object)this.datastore, (Query)hqlQuery));
            int result = query.executeUpdate();
            applicationEventPublisher.publishEvent((ApplicationEvent)new PostQueryEvent((Object)this.datastore, (Query)hqlQuery, Collections.singletonList(result)));
            return result;
        }).intValue();
    }

    public List retrieveAll(Class type, Iterable keys) {
        PersistentEntity persistentEntity = this.getMappingContext().getPersistentEntity(type.getName());
        return this.getHibernateTemplate().execute(session -> {
            CriteriaBuilder criteriaBuilder = session.getCriteriaBuilder();
            CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(type);
            Root root = criteriaQuery.from(type);
            String id = persistentEntity.getIdentity().getName();
            criteriaQuery = criteriaQuery.where((Expression)criteriaBuilder.in((Expression)root.get(id).in(this.getIterableAsCollection(keys))));
            org.hibernate.query.Query jpaQuery = session.createQuery(criteriaQuery);
            this.getHibernateTemplate().applySettings(jpaQuery);
            return new HibernateHqlQuery((Session)this, persistentEntity, jpaQuery).list();
        });
    }

    public Query createQuery(Class type) {
        return this.createQuery(type, null);
    }

    public Query createQuery(Class type, String alias) {
        PersistentEntity persistentEntity = this.getMappingContext().getPersistentEntity(type.getName());
        GrailsHibernateTemplate hibernateTemplate = this.getHibernateTemplate();
        org.hibernate.Session currentSession = hibernateTemplate.getSessionFactory().getCurrentSession();
        Criteria criteria = alias != null ? currentSession.createCriteria(type, alias) : currentSession.createCriteria(type);
        hibernateTemplate.applySettings(criteria);
        return new HibernateQuery(criteria, this, persistentEntity);
    }

    protected GrailsHibernateTemplate getHibernateTemplate() {
        return (GrailsHibernateTemplate)this.getNativeInterface();
    }

    public void setFlushMode(FlushModeType flushMode) {
        if (flushMode == FlushModeType.AUTO) {
            this.hibernateTemplate.setFlushMode(1);
        } else if (flushMode == FlushModeType.COMMIT) {
            this.hibernateTemplate.setFlushMode(3);
        }
    }

    public FlushModeType getFlushMode() {
        switch (this.hibernateTemplate.getFlushMode()) {
            case 1: {
                return FlushModeType.AUTO;
            }
            case 3: {
                return FlushModeType.COMMIT;
            }
            case 4: {
                return FlushModeType.AUTO;
            }
        }
        return FlushModeType.AUTO;
    }
}

