/*
 * Decompiled with CFR 0.152.
 */
package org.grails.orm.hibernate.connections;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import javax.sql.DataSource;
import org.grails.datastore.gorm.jdbc.connections.DataSourceSettings;
import org.grails.datastore.gorm.jdbc.connections.SpringDataSourceConnectionSourceFactory;
import org.grails.datastore.gorm.validation.javax.JavaxValidatorRegistry;
import org.grails.datastore.mapping.core.connections.ConnectionSource;
import org.grails.datastore.mapping.core.exceptions.ConfigurationException;
import org.grails.datastore.mapping.core.grailsversion.GrailsVersion;
import org.grails.datastore.mapping.model.MappingContext;
import org.grails.datastore.mapping.validation.ValidatorRegistry;
import org.grails.orm.hibernate.HibernateEventListeners;
import org.grails.orm.hibernate.cfg.GrailsDomainBinder;
import org.grails.orm.hibernate.cfg.HibernateMappingContext;
import org.grails.orm.hibernate.cfg.HibernateMappingContextConfiguration;
import org.grails.orm.hibernate.connections.AbstractHibernateConnectionSourceFactory;
import org.grails.orm.hibernate.connections.HibernateConnectionSource;
import org.grails.orm.hibernate.connections.HibernateConnectionSourceSettings;
import org.grails.orm.hibernate.support.AbstractClosureEventTriggeringInterceptor;
import org.grails.orm.hibernate.support.ClosureEventTriggeringInterceptor;
import org.hibernate.Interceptor;
import org.hibernate.SessionFactory;
import org.hibernate.boot.spi.MetadataContributor;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.NamingStrategy;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.context.support.StaticMessageSource;
import org.springframework.core.io.Resource;

public class HibernateConnectionSourceFactory
extends AbstractHibernateConnectionSourceFactory
implements ApplicationContextAware,
MessageSourceAware {
    protected HibernateMappingContext mappingContext;
    protected Class[] persistentClasses = new Class[0];
    private ApplicationContext applicationContext;
    protected HibernateEventListeners hibernateEventListeners;
    protected Interceptor interceptor;
    protected MetadataContributor metadataContributor;
    protected MessageSource messageSource = new StaticMessageSource();

    public HibernateConnectionSourceFactory(Class ... classes) {
        this.persistentClasses = classes;
    }

    public Class[] getPersistentClasses() {
        return this.persistentClasses;
    }

    @Autowired(required=false)
    public void setHibernateEventListeners(HibernateEventListeners hibernateEventListeners) {
        this.hibernateEventListeners = hibernateEventListeners;
    }

    @Autowired(required=false)
    public void setInterceptor(Interceptor interceptor) {
        this.interceptor = interceptor;
    }

    @Autowired(required=false)
    public void setMetadataContributor(MetadataContributor metadataContributor) {
        this.metadataContributor = metadataContributor;
    }

    public HibernateMappingContext getMappingContext() {
        return this.mappingContext;
    }

    @Override
    public ConnectionSource<SessionFactory, HibernateConnectionSourceSettings> create(String name, ConnectionSource<DataSource, DataSourceSettings> dataSourceConnectionSource, HibernateConnectionSourceSettings settings) {
        HibernateMappingContextConfiguration configuration = this.buildConfiguration(name, dataSourceConnectionSource, settings);
        SessionFactory sessionFactory = configuration.buildSessionFactory();
        return new HibernateConnectionSource(name, sessionFactory, dataSourceConnectionSource, settings);
    }

    public HibernateMappingContextConfiguration buildConfiguration(String name, ConnectionSource<DataSource, DataSourceSettings> dataSourceConnectionSource, HibernateConnectionSourceSettings settings) {
        Class<? extends AbstractClosureEventTriggeringInterceptor> closureEventTriggeringInterceptorClass;
        String[] packagesToScan;
        String[] annotatedPackages;
        Class<?>[] annotatedClasses;
        Resource[] mappingDirectoryLocations;
        Resource[] mappingJarLocations;
        Resource[] cacheableMappingLocations;
        Resource[] mappingLocations;
        HibernateMappingContextConfiguration configuration;
        HibernateConnectionSourceSettings.HibernateSettings hibernateSettings;
        Class<? extends Configuration> configClass;
        boolean isDefault = "DEFAULT".equals(name);
        if (this.mappingContext == null) {
            this.mappingContext = new HibernateMappingContext(settings, this.applicationContext, this.persistentClasses);
        }
        if ((configClass = (hibernateSettings = settings.getHibernate()).getConfigClass()) != null) {
            if (!HibernateMappingContextConfiguration.class.isAssignableFrom(configClass)) {
                throw new ConfigurationException("The configClass setting must be a subclass for [HibernateMappingContextConfiguration]");
            }
            configuration = (HibernateMappingContextConfiguration)((Object)BeanUtils.instantiateClass(configClass));
        } else {
            configuration = new HibernateMappingContextConfiguration();
        }
        if (JavaxValidatorRegistry.isAvailable() && this.messageSource != null) {
            JavaxValidatorRegistry registry = new JavaxValidatorRegistry((MappingContext)this.mappingContext, dataSourceConnectionSource.getSettings(), this.messageSource);
            this.mappingContext.setValidatorRegistry((ValidatorRegistry)registry);
            configuration.getProperties().put("javax.persistence.validation.factory", registry);
        }
        if (this.applicationContext != null && this.applicationContext.containsBean(dataSourceConnectionSource.getName())) {
            configuration.setApplicationContext(this.applicationContext);
        } else {
            configuration.setDataSourceConnectionSource(dataSourceConnectionSource);
        }
        Resource[] configLocations = hibernateSettings.getConfigLocations();
        if (configLocations != null) {
            for (Resource resource : configLocations) {
                try {
                    configuration.configure(resource.getURL());
                }
                catch (IOException e) {
                    throw new ConfigurationException("Cannot configure Hibernate config for location: " + resource.getFilename(), (Throwable)e);
                }
            }
        }
        if ((mappingLocations = hibernateSettings.getMappingLocations()) != null) {
            for (Resource resource : mappingLocations) {
                try {
                    configuration.addInputStream(resource.getInputStream());
                }
                catch (IOException e) {
                    throw new ConfigurationException("Cannot configure Hibernate config for location: " + resource.getFilename(), (Throwable)e);
                }
            }
        }
        if ((cacheableMappingLocations = hibernateSettings.getCacheableMappingLocations()) != null) {
            for (Resource resource : cacheableMappingLocations) {
                try {
                    configuration.addCacheableFile(resource.getFile());
                }
                catch (IOException e) {
                    throw new ConfigurationException("Cannot configure Hibernate config for location: " + resource.getFilename(), (Throwable)e);
                }
            }
        }
        if ((mappingJarLocations = hibernateSettings.getMappingJarLocations()) != null) {
            for (Resource resource : mappingJarLocations) {
                try {
                    configuration.addJar(resource.getFile());
                }
                catch (IOException e) {
                    throw new ConfigurationException("Cannot configure Hibernate config for location: " + resource.getFilename(), (Throwable)e);
                }
            }
        }
        if ((mappingDirectoryLocations = hibernateSettings.getMappingDirectoryLocations()) != null) {
            for (Resource resource : mappingDirectoryLocations) {
                File file;
                try {
                    file = resource.getFile();
                }
                catch (IOException e) {
                    throw new ConfigurationException("Cannot configure Hibernate config for location: " + resource.getFilename(), (Throwable)e);
                }
                if (!file.isDirectory()) {
                    throw new IllegalArgumentException("Mapping directory location [" + resource + "] does not denote a directory");
                }
                configuration.addDirectory(file);
            }
        }
        if (this.interceptor != null) {
            configuration.setInterceptor(this.interceptor);
        }
        if (this.metadataContributor != null) {
            configuration.setMetadataContributor(this.metadataContributor);
        }
        if ((annotatedClasses = hibernateSettings.getAnnotatedClasses()) != null) {
            configuration.addAnnotatedClasses(annotatedClasses);
        }
        if ((annotatedPackages = hibernateSettings.getAnnotatedPackages()) != null) {
            configuration.addPackages(annotatedPackages);
        }
        if ((packagesToScan = hibernateSettings.getPackagesToScan()) != null) {
            configuration.scanPackages(packagesToScan);
        }
        AbstractClosureEventTriggeringInterceptor eventTriggeringInterceptor = (closureEventTriggeringInterceptorClass = hibernateSettings.getClosureEventTriggeringInterceptorClass()) == null ? new ClosureEventTriggeringInterceptor() : (AbstractClosureEventTriggeringInterceptor)((Object)BeanUtils.instantiateClass(closureEventTriggeringInterceptorClass));
        hibernateSettings.setEventTriggeringInterceptor(eventTriggeringInterceptor);
        try {
            Class<? extends NamingStrategy> namingStrategy = hibernateSettings.getNaming_strategy();
            if (namingStrategy != null) {
                GrailsDomainBinder.configureNamingStrategy(name, namingStrategy);
            }
        }
        catch (Throwable e) {
            throw new ConfigurationException("Error configuring naming strategy: " + e.getMessage(), e);
        }
        configuration.setEventListeners(hibernateSettings.toHibernateEventListeners(eventTriggeringInterceptor));
        HibernateEventListeners hibernateEventListeners = hibernateSettings.getHibernateEventListeners();
        configuration.setHibernateEventListeners(this.hibernateEventListeners != null ? this.hibernateEventListeners : hibernateEventListeners);
        configuration.setHibernateMappingContext(this.mappingContext);
        configuration.setDataSourceName(name);
        configuration.setSessionFactoryBeanName((String)(isDefault ? "sessionFactory" : "sessionFactory_" + name));
        Properties hibernateProperties = settings.toProperties();
        configuration.addProperties(hibernateProperties);
        return configuration;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if (applicationContext != null) {
            this.applicationContext = applicationContext;
            this.messageSource = applicationContext;
            if (!GrailsVersion.isAtLeastMajorMinor((int)3, (int)3)) {
                SpringDataSourceConnectionSourceFactory springDataSourceConnectionSourceFactory = new SpringDataSourceConnectionSourceFactory();
                springDataSourceConnectionSourceFactory.setApplicationContext(applicationContext);
                this.dataSourceConnectionSourceFactory = springDataSourceConnectionSourceFactory;
            }
        }
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    static {
        System.setProperty("org.jboss.logging.provider", "slf4j");
    }
}

