/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.cmdgw.command.bus;

import java.util.function.BiFunction;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Destroyed;
import javax.enterprise.context.Initialized;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.websocket.Session;
import org.hawkular.cmdgw.command.bus.BusCommandContextFactory;
import org.hawkular.cmdgw.command.bus.BusCommands;
import org.hawkular.cmdgw.command.bus.BusConnectionFactoryProvider;
import org.hawkular.cmdgw.command.ws.WsEndpoints;
import org.hawkular.cmdgw.command.ws.WsSessionListener;
import org.hawkular.cmdgw.log.GatewayLoggers;
import org.hawkular.cmdgw.log.MsgLogger;

@ApplicationScoped
public class BusEndpointProcessors {
    private static final MsgLogger log = GatewayLoggers.getLogger(BusEndpointProcessors.class);
    @Inject
    private BusCommands busCommands;
    @Inject
    private BusCommandContextFactory commandContextFactory;
    @Inject
    private BusConnectionFactoryProvider connectionFactoryProvider;
    private BiFunction<String, Session, WsSessionListener> feedSessionListenerProducer;
    private BiFunction<String, Session, WsSessionListener> uiClientSessionListenerProducer;
    @Inject
    private WsEndpoints wsEndpoints;

    public void destroy(@Observes @Destroyed(value=ApplicationScoped.class) Object ignore) {
        log.debugf("Destroying [%s]", (Object)this.getClass().getName());
        if (this.feedSessionListenerProducer != null) {
            this.wsEndpoints.getFeedSessions().removeWsSessionListenerProducer(this.feedSessionListenerProducer);
        }
        if (this.uiClientSessionListenerProducer != null) {
            this.wsEndpoints.getUiClientSessions().removeWsSessionListenerProducer(this.uiClientSessionListenerProducer);
        }
    }

    public void initialize(@Observes @Initialized(value=ApplicationScoped.class) Object ignore) {
        log.debugf("Initializing [%s]", (Object)this.getClass().getName());
        try {
            this.feedSessionListenerProducer = new /* Unavailable Anonymous Inner Class!! */;
            this.wsEndpoints.getFeedSessions().addWsSessionListenerProducer(this.feedSessionListenerProducer);
            this.uiClientSessionListenerProducer = new /* Unavailable Anonymous Inner Class!! */;
            this.wsEndpoints.getUiClientSessions().addWsSessionListenerProducer(this.uiClientSessionListenerProducer);
        }
        catch (Exception e) {
            log.errorCouldNotInitialize((Throwable)e, this.getClass().getName());
        }
    }

    static /* synthetic */ MsgLogger access$000() {
        return log;
    }

    static /* synthetic */ BusConnectionFactoryProvider access$100(BusEndpointProcessors x0) {
        return x0.connectionFactoryProvider;
    }

    static /* synthetic */ BusCommandContextFactory access$200(BusEndpointProcessors x0) {
        return x0.commandContextFactory;
    }

    static /* synthetic */ BusCommands access$300(BusEndpointProcessors x0) {
        return x0.busCommands;
    }
}

