/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.cmdgw.command.ws.server;

import java.io.IOException;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.websocket.CloseReason;
import javax.websocket.OnClose;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;
import org.hawkular.bus.common.BasicMessage;
import org.hawkular.cmdgw.api.WelcomeResponse;
import org.hawkular.cmdgw.command.ws.server.AbstractGatewayWebSocket;
import org.hawkular.cmdgw.command.ws.server.WebSocketHelper;
import org.hawkular.cmdgw.log.GatewayLoggers;
import org.hawkular.cmdgw.log.MsgLogger;

@ServerEndpoint(value="/ui/ws")
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class UIClientWebSocket
extends AbstractGatewayWebSocket {
    public static final String ENDPOINT = "/ui/ws";
    static final MsgLogger log = GatewayLoggers.getLogger(UIClientWebSocket.class);

    public UIClientWebSocket() {
        super(ENDPOINT);
    }

    @OnOpen
    public void uiClientSessionOpen(Session session) {
        log.infoWsSessionOpened(session.getId(), this.endpoint);
        this.wsEndpoints.getUiClientSessions().addSession(session.getId(), session);
        WelcomeResponse welcomeResponse = new WelcomeResponse();
        welcomeResponse.setSessionId(session.getId());
        try {
            new WebSocketHelper().sendBasicMessageSync(session, (BasicMessage)welcomeResponse);
        }
        catch (IOException e) {
            log.warnf((Throwable)e, "Could not send [%s] to UI client session [%s].", (Object)WelcomeResponse.class.getName(), (Object)session.getId());
        }
    }

    @OnClose
    public void uiClientSessionClose(Session session, CloseReason reason) {
        log.infoWsSessionClosed(session.getId(), this.endpoint, reason);
        this.wsEndpoints.getUiClientSessions().removeSession(session.getId(), session);
    }
}

