/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.datamining.api.base;

import java.util.HashSet;
import java.util.Set;
import org.hawkular.datamining.api.Subscription;
import org.hawkular.datamining.api.base.DataMiningForecaster;
import org.hawkular.datamining.forecast.MetricContext;

public class DataMiningSubscription
implements Subscription {
    private final Set<Subscription.SubscriptionOwner> subscriptionOwners = new HashSet<Subscription.SubscriptionOwner>();
    private final DataMiningForecaster forecaster;

    public DataMiningSubscription(DataMiningForecaster forecaster, Set<Subscription.SubscriptionOwner> subscriptionOwner) {
        if (subscriptionOwner == null || subscriptionOwner.isEmpty()) {
            throw new IllegalArgumentException("Forecaster should have at least one owner");
        }
        this.forecaster = forecaster;
        this.subscriptionOwners.addAll(subscriptionOwner);
    }

    @Override
    public MetricContext getMetric() {
        return this.forecaster.context();
    }

    @Override
    public DataMiningForecaster forecaster() {
        return this.forecaster;
    }

    @Override
    public Set<Subscription.SubscriptionOwner> getSubscriptionOwners() {
        return new HashSet<Subscription.SubscriptionOwner>(this.subscriptionOwners);
    }

    @Override
    public void addSubscriptionOwner(Subscription.SubscriptionOwner subscriptionOwner) {
        this.subscriptionOwners.add(subscriptionOwner);
    }

    @Override
    public void addSubscriptionOwners(Set<Subscription.SubscriptionOwner> owners) {
        this.subscriptionOwners.addAll(owners);
    }

    @Override
    public void removeSubscriptionOwner(Subscription.SubscriptionOwner subscriptionOwner) {
        this.subscriptionOwners.remove((Object)subscriptionOwner);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DataMiningSubscription)) {
            return false;
        }
        DataMiningSubscription that = (DataMiningSubscription)o;
        return !(this.forecaster().context() == null ? that.forecaster().context().getMetricId() != null : !this.forecaster().context().getMetricId().equals(that.forecaster().context().getMetricId()));
    }

    public int hashCode() {
        return this.forecaster().context().getMetricId() != null ? this.forecaster().context().getMetricId().hashCode() : 0;
    }
}

