/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.component.availcreator;

import com.google.gson.Gson;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.hawkular.bus.common.BasicMessage;
import org.hawkular.bus.common.ConnectionContextFactory;
import org.hawkular.bus.common.Endpoint;
import org.hawkular.bus.common.MessageProcessor;
import org.hawkular.bus.common.ObjectMessage;
import org.hawkular.bus.common.producer.ProducerConnectionContext;
import org.hawkular.component.availcreator.Availability;
import org.hawkular.component.availcreator.Log;
import org.hawkular.component.availcreator.MetricReceiver;
import org.hawkular.component.availcreator.SingleAvail;

@Stateless
public class AvailPublisher {
    private static final String METRICS_BASE_URI;

    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public void sendToMetricsViaRest(List<SingleAvail> availabilities) {
        CloseableHttpClient client = HttpClientBuilder.create().build();
        for (SingleAvail avr : availabilities) {
            String rid = avr.id;
            String tenantId = avr.tenantId;
            HttpPost request = new HttpPost(METRICS_BASE_URI + "/" + tenantId + "/metrics/availability/" + rid + "/data");
            Availability availability = new Availability(avr.timestamp, avr.avail.toLowerCase());
            ArrayList<Availability> list = new ArrayList<Availability>(1);
            list.add(availability);
            String payload = new Gson().toJson(list);
            request.setEntity((HttpEntity)new StringEntity(payload, ContentType.APPLICATION_JSON));
            try {
                HttpResponse response = client.execute((HttpUriRequest)request);
                if (response.getStatusLine().getStatusCode() <= 399) continue;
                Log.LOG.availPostStatus(response.getStatusLine().toString());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void publishToTopic(List<SingleAvail> availRecordList, MetricReceiver metricReceiver) {
        if (metricReceiver.topic != null) {
            HashMap outer = new HashMap(1);
            HashMap<String, List<SingleAvail>> data = new HashMap<String, List<SingleAvail>>(2);
            data.put("data", availRecordList);
            outer.put("availData", data);
            try (ConnectionContextFactory factory = new ConnectionContextFactory(metricReceiver.connectionFactory);){
                Endpoint endpoint = new Endpoint(Endpoint.Type.TOPIC, metricReceiver.topic.getTopicName());
                ProducerConnectionContext pc = factory.createProducerConnectionContext(endpoint);
                ObjectMessage msg = new ObjectMessage(outer);
                MessageProcessor processor = new MessageProcessor();
                processor.send(pc, (BasicMessage)msg);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            Log.LOG.wNoTopicConnection("HawkularAvailData");
        }
    }

    static {
        String host = System.getProperty("jboss.bind.address", "localhost");
        String port = System.getProperty("jboss.http.port", "8080");
        METRICS_BASE_URI = "http://" + host + ":" + port + "/hawkular-metrics";
    }
}

