/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.component.availcreator;

import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.EJB;
import javax.ejb.MessageDriven;
import javax.jms.ConnectionFactory;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import javax.jms.Topic;
import org.hawkular.component.availcreator.AvailPublisher;
import org.hawkular.component.availcreator.Log;
import org.hawkular.component.availcreator.SingleAvail;

@MessageDriven(activationConfig={@ActivationConfigProperty(propertyName="destinationType", propertyValue="javax.jms.Topic"), @ActivationConfigProperty(propertyName="destination", propertyValue="HawkularMetricData")})
public class MetricReceiver
implements MessageListener {
    @Resource(lookup="java:/topic/HawkularAvailData")
    Topic topic;
    @Resource(lookup="java:/HawkularBusConnectionFactory")
    ConnectionFactory connectionFactory;
    @EJB
    AvailPublisher availPublisher;

    public void onMessage(Message message) {
        try {
            String payload = ((TextMessage)message).getText();
            Map map = (Map)new GsonBuilder().create().fromJson(payload, Map.class);
            Map metricDataMap = (Map)map.get("metricData");
            String tenant = (String)metricDataMap.get("tenantId");
            List inputList = (List)metricDataMap.get("data");
            ArrayList<SingleAvail> outer = new ArrayList<SingleAvail>();
            ArrayList availabilityList = new ArrayList();
            for (Map item : inputList) {
                String source = (String)item.get("source");
                if (!source.endsWith(".status.code")) continue;
                double codeD = (Double)item.get("value");
                int code = (int)codeD;
                String id = source.substring(0, source.indexOf("."));
                double timestampD = (Double)item.get("timestamp");
                long timestamp = (long)timestampD;
                String avail = this.computeAvail(code);
                SingleAvail ar = new SingleAvail(tenant, id, timestamp, avail);
                outer.add(ar);
            }
            this.availPublisher.sendToMetricsViaRest(outer);
            this.availPublisher.publishToTopic(outer, this);
        }
        catch (Exception e) {
            Log.LOG.eCouldNotHandleBusMessage(e);
        }
    }

    private String computeAvail(int code) {
        if (code <= 399) {
            return "UP";
        }
        return "DOWN";
    }
}

