/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.component.availcreator;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.ejb.Asynchronous;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.hawkular.component.availcreator.Availability;
import org.hawkular.component.availcreator.Log;
import org.hawkular.component.availcreator.SingleAvail;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class AvailPublisher {
    private static final String METRICS_BASE_URI;

    @Asynchronous
    public void sendToMetricsViaRest(List<SingleAvail> availabilities) {
        CloseableHttpClient client = HttpClientBuilder.create().build();
        for (SingleAvail avr : availabilities) {
            String payload;
            String rid = avr.id;
            String tenantId = avr.tenantId;
            HttpPost request = new HttpPost(METRICS_BASE_URI + "/availability/" + rid + "/data");
            request.addHeader("Hawkular-Tenant", tenantId);
            Availability availability = new Availability(avr.timestamp, avr.avail.toLowerCase());
            ArrayList<Availability> list = new ArrayList<Availability>(1);
            list.add(availability);
            try {
                payload = new ObjectMapper().writeValueAsString(list);
            }
            catch (JsonProcessingException e) {
                Log.LOG.eCouldNotParseMessage((Throwable)e);
                return;
            }
            request.setEntity((HttpEntity)new StringEntity(payload, ContentType.APPLICATION_JSON));
            try {
                HttpResponse response = client.execute((HttpUriRequest)request);
                if (response.getStatusLine().getStatusCode() <= 399) continue;
                Log.LOG.wAvailPostStatus(response.getStatusLine().toString());
            }
            catch (IOException e) {
                Log.LOG.wAvailPostStatus(e.getMessage());
            }
        }
    }

    static {
        String host = System.getProperty("jboss.bind.address", "localhost");
        String port = System.getProperty("jboss.http.port", "8080");
        METRICS_BASE_URI = "http://" + host + ":" + port + "/hawkular/metrics";
    }
}

