/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.component.availcreator;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Iterator;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.EJB;
import javax.ejb.MessageDriven;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import org.hawkular.component.availcreator.AvailPublisher;
import org.hawkular.component.availcreator.Log;
import org.hawkular.component.availcreator.SingleAvail;

@MessageDriven(activationConfig={@ActivationConfigProperty(propertyName="destinationType", propertyValue="javax.jms.Topic"), @ActivationConfigProperty(propertyName="destination", propertyValue="HawkularMetricData")})
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class MetricReceiver
implements MessageListener {
    private final ObjectMapper objectMapper = new ObjectMapper();
    @EJB
    AvailPublisher availPublisher;

    public void onMessage(Message message) {
        try {
            String payload = ((TextMessage)message).getText();
            JsonNode rootNode = this.objectMapper.readTree(payload);
            JsonNode metricData = rootNode.get("metricData");
            String tenant = metricData.get("tenantId").textValue();
            JsonNode data = metricData.get("data");
            ArrayList<SingleAvail> outer = new ArrayList<SingleAvail>();
            Iterator items = data.elements();
            while (items.hasNext()) {
                JsonNode item = (JsonNode)items.next();
                String source = item.get("source").textValue();
                if (!source.endsWith(".status.code")) continue;
                int code = item.get("value").intValue();
                String id = source.substring(0, source.indexOf("."));
                long timestamp = item.get("timestamp").longValue();
                String avail = this.computeAvail(code);
                SingleAvail ar = new SingleAvail(tenant, id, timestamp, avail);
                outer.add(ar);
            }
            if (!outer.isEmpty()) {
                this.availPublisher.sendToMetricsViaRest(outer);
            }
        }
        catch (Exception e) {
            Log.LOG.eCouldNotHandleBusMessage(e);
        }
    }

    private String computeAvail(int code) {
        if (code <= 399) {
            return "UP";
        }
        return "DOWN";
    }
}

