///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
// Console code placeholder

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// <reference path="../../../libs/hawtio-utilities/defs.d.ts"/>
/// <reference path="../../../libs/hawtio-oauth/defs.d.ts"/>

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// <reference path="../../../libs/hawtio-utilities/defs.d.ts"/>

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// <reference path="../../../libs/hawtio-utilities/defs.d.ts"/>
/// <reference path="../vendor/moment/moment.d.ts"/>

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// <reference path="../../../libs/hawtio-utilities/defs.d.ts"/>

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// <reference path="../../../libs/hawtio-utilities/defs.d.ts"/>
/// <reference path="../../../libs/hawtio-core-dts/defs.d.ts"/>
/// <reference path="../../directives/vendor/moment/moment.d.ts"/>

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// <reference path="../../includes.ts"/>
var HawkularAccounts;
(function (HawkularAccounts) {
    HawkularAccounts.pluginName = "hawkular-accounts";
    HawkularAccounts.log = Logger.get(HawkularAccounts.pluginName);
    HawkularAccounts.templatePath = "plugins/accounts/html";
})(HawkularAccounts || (HawkularAccounts = {}));

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// <reference path="../../includes.ts"/>
/// <reference path="accountsGlobals.ts"/>
var HawkularAccounts;
(function (HawkularAccounts) {
    HawkularAccounts._module = angular.module(HawkularAccounts.pluginName, ['ui.bootstrap']);
    var accountsTab = undefined;
    var currentPersona = undefined;
    HawkularAccounts._module.config(['$locationProvider', '$routeProvider', '$httpProvider', 'HawtioNavBuilderProvider', function ($locationProvider, $routeProvider, $httpProvider, builder) {
        accountsTab = builder.create().id(HawkularAccounts.pluginName).title(function () { return "Accounts"; }).href(function () { return "/accounts"; }).subPath("My account", "accounts", builder.join(HawkularAccounts.templatePath, 'accounts.html')).subPath("Organizations", "organizations", builder.join(HawkularAccounts.templatePath, 'organizations.html')).build();
        builder.configureRouting($routeProvider, accountsTab);
        $routeProvider.when('/accounts/organizations/new', { templateUrl: builder.join(HawkularAccounts.templatePath, 'organization_new.html') });
        $locationProvider.html5Mode(true);
        $httpProvider.interceptors.push(PersonaInterceptorService.Factory);
    }]);
    HawkularAccounts._module.run(['$rootScope', '$log', '$modal', '$document', 'userDetails', 'HawtioNav', function ($rootScope, $log, $modal, $document, userDetails, HawtioNav) {
        HawtioNav.add(accountsTab);
        $rootScope.userDetails = userDetails;
        $rootScope.$on('IdleStart', function () {
            $('#idle').slideDown();
        });
        $rootScope.$on('IdleEnd', function () {
            $("#idle").slideUp();
        });
        $rootScope.$on('IdleTimeout', function () {
            $log.debug('Idle timeout');
            $document.find('body').eq(0).addClass('inactivity-modal-open');
            $modal.open({
                templateUrl: 'plugins/accounts/html/inactivityModal.html',
                backdrop: 'static'
            });
        });
        $rootScope.$on('CurrentPersonaLoaded', function (e, persona) {
            currentPersona = persona;
            $rootScope.currentPersona = currentPersona;
        });
        $rootScope.$on('SwitchedPersona', function (e, persona) {
            currentPersona = persona;
            $rootScope.currentPersona = currentPersona;
        });
    }]);
    hawtioPluginLoader.registerPreBootstrapTask(function (next) {
        window['KeycloakConfig'] = "/keycloak.json";
        next();
    }, true);
    var PersonaInterceptorService = (function () {
        function PersonaInterceptorService($q) {
            this.$q = $q;
            this.request = function (request) {
                if (currentPersona) {
                    request.headers['Hawkular-Persona'] = currentPersona.id;
                }
                return request;
            };
        }
        PersonaInterceptorService.Factory = function ($q) {
            return new PersonaInterceptorService($q);
        };
        PersonaInterceptorService.$inject = ['$q'];
        return PersonaInterceptorService;
    })();
    hawtioPluginLoader.addModule(HawkularAccounts.pluginName);
})(HawkularAccounts || (HawkularAccounts = {}));

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// <reference path="accountsPlugin.ts"/>
var HawkularAccounts;
(function (HawkularAccounts) {
    HawkularAccounts.OrganizationsController = HawkularAccounts._module.controller("HawkularAccounts.OrganizationsController", [
        '$rootScope',
        '$scope',
        '$log',
        '$location',
        'HawkularAccount',
        function ($rootScope, $scope, $log, $location, HawkularAccount) {
            $scope.organizations = [];
            $scope.loading = true;
            $scope.load = function () {
                $scope.loadOrganizations();
            };
            $scope.loadOrganizations = function () {
                $scope.organizations = [];
                $scope.loading = true;
                $scope.organizations = HawkularAccount.Organization.query({}, function () {
                    $scope.loading = false;
                }, function () {
                    $log.warn("List of organizations could NOT be retrieved.");
                    $scope.loading = false;
                });
            };
            $scope.showCreateForm = function () {
                $location.path('/accounts/organizations/new');
            };
            $scope.remove = function (organization) {
                organization.$remove().then(function () {
                    $scope.$emit('OrganizationRemoved');
                    $scope.organizations.splice($scope.organizations.indexOf(organization), 1);
                });
            };
            $scope.load();
            $rootScope.$on('SwitchedPersona', function () {
                $scope.loadOrganizations();
            });
        }
    ]);
    HawkularAccounts.OrganizationNewController = HawkularAccounts._module.controller("HawkularAccounts.OrganizationNewController", [
        '$scope',
        '$log',
        '$location',
        'HawkularAccount',
        function ($scope, $log, $location, HawkularAccount) {
            $scope.organizationNew = new HawkularAccount.Organization({});
            $scope.persist = function () {
                $scope.organizationNew.$save({}, function () {
                    $scope.$emit('OrganizationCreated');
                    $location.path('/accounts/organizations');
                }, function () {
                    // error
                    $log.debug("Organization could NOT be added.");
                });
                $log.debug("Trying to persist the organization");
            };
        }
    ]);
})(HawkularAccounts || (HawkularAccounts = {}));

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// <reference path="accountsPlugin.ts"/>
var HawkularAccounts;
(function (HawkularAccounts) {
    HawkularAccounts.PersonaController = HawkularAccounts._module.controller("HawkularAccounts.PersonaController", [
        '$rootScope',
        '$scope',
        '$log',
        'HawkularAccount',
        function ($rootScope, $scope, $log, HawkularAccount) {
            $scope.personas = [];
            $scope.currentPersona = null;
            $scope.load = function () {
                $scope.loadCurrentPersona();
            };
            $scope.loadCurrentPersona = function () {
                $scope.currentPersona = HawkularAccount.Persona.get({ id: "current" }, function () {
                    $scope.$emit("CurrentPersonaLoaded", $scope.currentPersona);
                }, function () {
                    $log.warn("Failed in retrieving the current persona");
                });
            };
            $scope.loadPersonas = function () {
                $scope.personas = HawkularAccount.Persona.query({}, function () {
                    $scope.personas = $scope.personas.filter(function (persona) {
                        return persona.id !== $scope.currentPersona.id;
                    });
                    $scope.loading = false;
                }, function () {
                    $log.warn("List of personas could NOT be retrieved.");
                    $scope.loading = false;
                });
            };
            $scope.switchPersona = function (persona) {
                $scope.personas.push($scope.currentPersona);
                $scope.currentPersona = persona;
                $scope.personas = $scope.personas.filter(function (persona) {
                    return persona.id !== $scope.currentPersona.id;
                });
                $scope.$emit("SwitchedPersona", persona);
            };
            $rootScope.$on('CurrentPersonaLoaded', function () {
                $scope.loadPersonas();
            });
            $rootScope.$on('OrganizationCreated', function () {
                $scope.loadPersonas();
            });
            $rootScope.$on('OrganizationRemoved', function () {
                $scope.loadPersonas();
            });
            $scope.load();
        }
    ]);
})(HawkularAccounts || (HawkularAccounts = {}));

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// <reference path="../../includes.ts"/>
var HawkularAlerts;
(function (HawkularAlerts) {
    HawkularAlerts.pluginName = "hawkular-alerts";
    HawkularAlerts.log = Logger.get(HawkularAlerts.pluginName);
    HawkularAlerts.templatePath = "plugins/alerts/html";
})(HawkularAlerts || (HawkularAlerts = {}));

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// <reference path="../../includes.ts"/>
/// <reference path="alertsGlobals.ts"/>
var HawkularAlerts;
(function (HawkularAlerts) {
    HawkularAlerts._module = angular.module(HawkularAlerts.pluginName, ['ui.bootstrap', 'ui.select', 'hawkular.services']);
    var tab = undefined;
    HawkularAlerts._module.config(['$locationProvider', '$routeProvider', 'HawtioNavBuilderProvider', function ($locationProvider, $routeProvider, builder) {
        tab = builder.create().id(HawkularAlerts.pluginName).title(function () { return "Alerts"; }).href(function () { return "/alerts"; }).subPath("Dashboard", "dashboard", builder.join(HawkularAlerts.templatePath, 'dashboard.html')).subPath("Definitions", "definitions", builder.join(HawkularAlerts.templatePath, 'definitions.html')).subPath("Actions", "actions", builder.join(HawkularAlerts.templatePath, 'actions.html')).build();
        builder.configureRouting($routeProvider, tab);
        $locationProvider.html5Mode(true);
    }]);
    HawkularAlerts._module.run(['HawtioNav', function (HawtioNav) {
        HawtioNav.add(tab);
    }]);
    hawtioPluginLoader.addModule(HawkularAlerts.pluginName);
})(HawkularAlerts || (HawkularAlerts = {}));

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// <reference path="alertsPlugin.ts"/>
var HawkularAlerts;
(function (HawkularAlerts) {
    var ActionsController = (function () {
        function ActionsController($scope, $window, $interval, $log, HawkularAlert) {
            this.$scope = $scope;
            this.$window = $window;
            this.$interval = $interval;
            this.$log = $log;
            this.HawkularAlert = HawkularAlert;
            $scope.status = 'all';
            $scope.msgs = [];
            $scope.actions = [];
            $scope.actionsPlugins = [];
            this.allActions();
        }
        ActionsController.prototype.allActions = function () {
            var _this = this;
            this.$scope.status = 'all';
            this.$scope.actions = [];
            this.HawkularAlert.Action.query(function (actions) {
                for (var i = 0; i < actions.length; i++) {
                    _this.HawkularAlert.Action.get({ actionId: actions[i] }, function (action) {
                        _this.$scope.actions.push(action);
                    }, function (reasonAction) {
                        _this.addAlertMsg(reasonAction);
                    });
                }
            }, function (reason) {
                _this.addAlertMsg(reason);
            });
        };
        ActionsController.prototype.newAction = function () {
            var _this = this;
            this.$scope.status = 'new';
            this.$scope.action = {};
            this.$scope.actionPlugins = [];
            this.$scope.pluginProperties = [];
            this.HawkularAlert.ActionPlugin.query(function (actionPlugins) {
                for (var i = 0; i < actionPlugins.length; i++) {
                    if (i === 0) {
                        _this.$scope.action.actionPlugin = actionPlugins[0];
                        _this.HawkularAlert.ActionPlugin.get({ actionPlugin: actionPlugins[0] }, function (properties) {
                            _this.$scope.pluginProperties = properties;
                        });
                    }
                    _this.$scope.actionPlugins.push(actionPlugins[i]);
                }
            });
        };
        ActionsController.prototype.changePlugin = function () {
            var _this = this;
            this.HawkularAlert.ActionPlugin.get({ actionPlugin: this.$scope.action.actionPlugin.trim() }, function (properties) {
                _this.$scope.pluginProperties = properties;
            });
        };
        ActionsController.prototype.viewAction = function (actionId) {
            var _this = this;
            this.$scope.status = 'edit';
            this.$scope.action = {};
            this.$scope.actionPlugins = [];
            this.HawkularAlert.Action.get({ actionId: actionId }, function (action) {
                _this.$scope.action = action;
            }, function (reason) {
                _this.addAlertMsg(reason);
            });
            this.HawkularAlert.ActionPlugin.query(function (actionPlugins) {
                for (var i = 0; i < actionPlugins.length; i++) {
                    _this.$scope.actionPlugins.push(actionPlugins[i]);
                }
            });
        };
        ActionsController.prototype.saveAction = function () {
            var _this = this;
            if (this.$scope.status === 'new') {
                this.HawkularAlert.Action.save(this.$scope.action, function () {
                    _this.allActions();
                }, function (reason) {
                    _this.addAlertMsg(reason);
                });
            }
            else {
                this.HawkularAlert.Action.put({ actionId: this.$scope.action.actionId }, this.$scope.action, function () {
                    _this.allActions();
                }, function (reason) {
                    _this.addAlertMsg(reason);
                });
            }
        };
        ActionsController.prototype.deleteAction = function (actionId) {
            var _this = this;
            if (this.$window.confirm('Do you want to delete ' + actionId + ' ?')) {
                this.HawkularAlert.Action.delete({ actionId: actionId }, function () {
                    _this.allActions();
                }, function (reason) {
                    _this.addAlertMsg(reason);
                });
            }
        };
        ActionsController.prototype.addAlertMsg = function (reason) {
            var newAlert = { type: 'danger', msg: '' };
            if (reason.data.errorMsg) {
                newAlert.msg = reason.data.errorMsg;
            }
            else {
                newAlert.msg = reason.statusText;
            }
            this.$scope.msgs.push(newAlert);
        };
        ActionsController.prototype.closeAlertMsg = function (index) {
            this.$scope.msgs.splice(index, 1);
        };
        ActionsController.$inject = ['$scope', '$window', '$interval', '$log', 'HawkularAlert'];
        return ActionsController;
    })();
    HawkularAlerts.ActionsController = ActionsController;
    HawkularAlerts._module.controller('HawkularAlerts.ActionsController', ActionsController);
})(HawkularAlerts || (HawkularAlerts = {}));

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// <reference path="alertsPlugin.ts"/>
var HawkularAlerts;
(function (HawkularAlerts) {
    var DashboardController = (function () {
        function DashboardController($scope, $interval, $log, HawkularAlert) {
            var _this = this;
            this.$scope = $scope;
            this.$interval = $interval;
            this.$log = $log;
            this.HawkularAlert = HawkularAlert;
            $scope.msgs = [];
            $scope.refresh = {
                interval: 2000
            };
            $scope.showRefresh = false;
            var oneHour = 1 * 60 * 60 * 1000;
            var endTime = Date.now() + oneHour;
            var startTime = endTime - (1.5 * oneHour);
            this.g = Graph.getInstance();
            this.g.init('alertsDashboard', 900, { top: 100, left: 125, bottom: 0, right: 0 }, startTime, endTime, function (series, timestamp) {
                /*
                 "series" var will store whole text with (<number>) counter representation
                 */
                var sanitizedSeries = series.substring(0, series.lastIndexOf('(')).trim();
                $scope.$apply(function () {
                    $scope.legend = _this.g.getEvent(sanitizedSeries, timestamp);
                });
            });
            this.getAlerts();
            this.stopInterval = $interval(function () {
                _this.getAlerts();
            }, $scope.refresh.interval);
            $scope.$on('$destroy', function () {
                _this.cancelRefresh();
            });
        }
        DashboardController.prototype.showRefreshForm = function () {
            this.$scope.showRefresh = true;
        };
        DashboardController.prototype.hideRefreshForm = function () {
            this.$scope.showRefresh = false;
        };
        DashboardController.prototype.updateRefresh = function () {
            var _this = this;
            this.$scope.showRefresh = false;
            this.cancelRefresh();
            this.stopInterval = this.$interval(function () {
                _this.getAlerts();
            }, this.$scope.refresh.interval);
        };
        DashboardController.prototype.closeAlertMsg = function (index) {
            this.$scope.msgs.splice(index, 1);
        };
        DashboardController.prototype.getAlerts = function () {
            var _this = this;
            this.HawkularAlert.Alert.query(function (alerts) {
                var alertsLength = alerts.length;
                for (var i = 0; i < alertsLength; i++) {
                    var alert = alerts[i];
                    alert.name = alert.triggerId;
                    alert.date = new Date(alert.time);
                    // Create a description
                    alert.description = alert.evalSets.toString();
                    _this.g.addEvent(alert);
                }
            }, function (reason) {
                _this.addAlertMsg(reason);
            });
        };
        DashboardController.prototype.cancelRefresh = function () {
            this.$interval.cancel(this.stopInterval);
        };
        DashboardController.prototype.addAlertMsg = function (reason) {
            var newAlert = { type: 'danger', msg: '' };
            if (reason.data && reason.data.errorMsg) {
                newAlert.msg = reason.data.errorMsg;
            }
            else {
                newAlert.msg = reason.statusText;
            }
            this.$scope.msgs.push(newAlert);
        };
        DashboardController.$inject = ['$scope', '$interval', '$log', 'HawkularAlert'];
        return DashboardController;
    })();
    HawkularAlerts.DashboardController = DashboardController;
    HawkularAlerts._module.controller('HawkularAlerts.DashboardController', DashboardController);
    var Graph = (function () {
        function Graph() {
            this._initialized = false;
            /*
                 Global data of the graph:
                 - It is a list of arrays.
                 - Each array has:
                 a) first element: a text containing name of the series.
                 b) other elements: date objects representing events.
                 - This array is passed to d3 object as input for raw data.
             */
            this._data = [];
            /*
                 Aux associative array to map a name of series with the index on _data[] array.
                 If we have a series name, we can acces to its series data using:
    
                 _data[_seriesIndexes['MySeries']]
             */
            this._seriesIndexes = [];
            /*
                 Associative array to store "events".
                 - First level is an associative array based on event.name.
                 - Second level is an associative array based on event.date.
    
                 _storage[event.name][event.date] = event
             */
            this._storage = [];
            if (Graph._instance) {
                throw new Error("Something error in Graph singleton initialization");
            }
            Graph._instance = this;
        }
        Graph.getInstance = function () {
            if (Graph._instance === null) {
                Graph._instance = new Graph();
            }
            return Graph._instance;
        };
        Graph.prototype.init = function (dashboardId, width, margin, startTime, endTime, hoverCallBack) {
            var _this = this;
            this._initialized = true;
            this._chartPlaceholder = document.getElementById(dashboardId);
            this._width = width;
            this._margin = margin;
            this._startTime = startTime;
            this._endTime = endTime;
            if (this._scaleDomain) {
                this._startTime = this._scaleDomain[0];
                this._endTime = this._scaleDomain[1];
            }
            this._color = d3.scale.category10();
            this._graph = d3.chart.eventDrops().start(new Date(this._startTime)).end(new Date(this._endTime)).eventColor(function (datum, index) {
                return _this._color(index);
            }).width(this._width).margin(this._margin).axisFormat(function (xAxis) {
                xAxis.ticks(5);
            }).eventHover(function (el) {
                var series = el.parentNode.firstChild.innerHTML;
                var timestamp = d3.select(el).data()[0];
                hoverCallBack(series, timestamp);
            }).eventZoom(function (scale) {
                _this._scaleDomain = scale.domain();
            });
            this._element = d3.select(this._chartPlaceholder).append('div').datum(this._data);
            this._data = this._element.datum();
            this._graph(this._element);
        };
        Graph.prototype.addEvent = function (event) {
            if (this._initialized) {
                if (this._storage[event.name] === undefined) {
                    // Update _storage
                    var newSeries = [];
                    newSeries[event.date] = event;
                    this._storage[event.name] = newSeries;
                    // Update _data
                    this._seriesIndexes.push(event.name);
                    var newLine = {
                        name: event.name,
                        dates: [event.date]
                    };
                    this._data.push(newLine);
                    // Redraw
                    if (this._scaleDomain) {
                        this._graph.start(this._scaleDomain[0]);
                        this._graph.end(this._scaleDomain[1]);
                    }
                    this._graph(this._element);
                }
                else {
                    if (this._storage[event.name][event.date] === undefined) {
                        // Update _storage
                        this._storage[event.name][event.date] = event;
                        // Update _data
                        var i = this._seriesIndexes.indexOf(event.name);
                        this._data[i].dates.push(event.date);
                        // Redraw
                        if (this._scaleDomain) {
                            this._graph.start(this._scaleDomain[0]);
                            this._graph.end(this._scaleDomain[1]);
                        }
                        this._graph(this._element);
                    }
                }
            }
        };
        Graph.prototype.getEvent = function (name, date) {
            if (this._initialized) {
                if (this._storage[name] !== undefined && this._storage[name][date] !== undefined) {
                    return this._storage[name][date];
                }
            }
        };
        Graph._instance = null;
        return Graph;
    })();
    HawkularAlerts.Graph = Graph;
})(HawkularAlerts || (HawkularAlerts = {}));

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// <reference path="alertsPlugin.ts"/>
var HawkularAlerts;
(function (HawkularAlerts) {
    var DefinitionsController = (function () {
        function DefinitionsController($scope, $window, $log, HawkularAlert) {
            this.$scope = $scope;
            this.$window = $window;
            this.$log = $log;
            this.HawkularAlert = HawkularAlert;
            $scope.status = 'all';
            $scope.msgs = [];
            this.allDefinitions();
            this.allActions();
        }
        DefinitionsController.prototype.allDefinitions = function () {
            this.$scope.status = 'all';
            this.$scope.triggers = this.HawkularAlert.Trigger.query();
        };
        DefinitionsController.prototype.newDefinition = function () {
            this.$scope.status = 'new';
            this.$scope.trigger = {
                enabled: true,
                safetyEnabled: false,
                firingMatch: 'ALL',
                safetyMatch: 'ALL'
            };
            this.$scope.dampeningFire = { triggerMode: 'FIRE', type: 'RELAXED_COUNT', evalTrueSetting: 1, evalTotalSetting: 1, evalTimeSetting: 0 };
            this.$scope.dampeningSafety = { triggerMode: 'SAFETY', type: 'RELAXED_COUNT', evalTrueSetting: 1, evalTotalSetting: 1, evalTimeSetting: 0 };
            this.$scope.statusDampening = { status: 'new' };
            this.allActions();
        };
        DefinitionsController.prototype.saveDefinition = function () {
            var _this = this;
            this.$scope.msgs = [];
            if (this.$scope.status === 'new') {
                this.HawkularAlert.Trigger.save(this.$scope.trigger, function (trigger) {
                    _this.$scope.dampeningFire.triggerId = trigger.id;
                    _this.$scope.dampeningSafety.triggerId = trigger.id;
                    _this.HawkularAlert.Dampening.save({ triggerId: _this.$scope.dampeningFire.triggerId }, _this.$scope.dampeningFire, function (dampening) {
                        _this.HawkularAlert.Dampening.save({ triggerId: _this.$scope.dampeningSafety.triggerId }, _this.$scope.dampeningSafety, function (safety) {
                            _this.viewDefinition(dampening.triggerId);
                        }, function (reasonSafety) {
                            _this.addAlertMsg(reasonSafety);
                        });
                    }, function (reasonDampening) {
                        _this.addAlertMsg(reasonDampening);
                    });
                }, function (reason) {
                    _this.addAlertMsg(reason);
                });
            }
            if (this.$scope.status === 'edit') {
                this.HawkularAlert.Trigger.put({ triggerId: this.$scope.trigger.id }, this.$scope.trigger, function () {
                    _this.allDefinitions();
                }, function (reason) {
                    _this.addAlertMsg(reason);
                });
            }
        };
        DefinitionsController.prototype.viewDefinition = function (id) {
            var _this = this;
            this.$scope.status = 'edit';
            this.$scope.trigger = {};
            this.HawkularAlert.Trigger.get({ triggerId: id }, function (response) {
                _this.$scope.trigger = response;
            }, function (reason) {
                _this.addAlertMsg(reason);
            });
            this.allConditions(id);
            this.getDampenings(id);
        };
        DefinitionsController.prototype.deleteDefinition = function (id, name) {
            var _this = this;
            if (this.$window.confirm('Do you want to delete ' + name + ' ?')) {
                this.$scope.msgs = [];
                this.HawkularAlert.Trigger.delete({ triggerId: id }, function () {
                    _this.allDefinitions();
                }, function (reason) {
                    _this.addAlertMsg(reason);
                });
            }
        };
        DefinitionsController.prototype.closeAlertMsg = function (index) {
            this.$scope.msgs.splice(index, 1);
        };
        DefinitionsController.prototype.addAlertMsg = function (reason) {
            console.log('reason', reason);
            var newAlert = { type: 'danger', msg: '' };
            if (reason.message) {
                newAlert.msg = reason.message;
            }
            else {
                newAlert.msg = reason.statusText;
            }
            this.$scope.msgs.push(newAlert);
        };
        DefinitionsController.prototype.allActions = function () {
            var _this = this;
            this.$scope.actions = [];
            this.HawkularAlert.Action.query(function (result) {
                _this.$scope.actions = result;
            }, function (reason) {
                _this.addAlertMsg(reason);
            });
        };
        DefinitionsController.prototype.allConditions = function (triggerId) {
            var _this = this;
            this.$scope.conditions = [];
            this.$scope.statusCondition = { status: '', conditionId: '' };
            this.HawkularAlert.Condition.query({ triggerId: triggerId }, function (conditions) {
                _this.$scope.conditions = conditions;
                for (var i = 0; i < _this.$scope.conditions.length; i++) {
                    _this.$scope.conditions[i].description = _this.getDescription(_this.$scope.conditions[i].type, _this.$scope.conditions[i]);
                }
            }, function (reasonList) {
                _this.addAlertMsg(reasonList);
            });
        };
        DefinitionsController.prototype.getDampenings = function (triggerId) {
            var _this = this;
            this.$scope.dampeningFire = { triggerMode: 'FIRE', type: 'RELAXED_COUNT', evalTrueSetting: 1, evalTotalSetting: 1, evalTimeSetting: 0 };
            this.$scope.dampeningSafety = { triggerMode: 'SAFETY', type: 'RELAXED_COUNT', evalTrueSetting: 1, evalTotalSetting: 1, evalTimeSetting: 0 };
            this.$scope.statusDampening = { status: 'view' };
            this.HawkularAlert.Dampening.query({ triggerId: triggerId }, function (dampenings) {
                for (var i = 0; i < dampenings.length; i++) {
                    if (dampenings[i].triggerMode === 'FIRE') {
                        _this.$scope.dampeningFire = dampenings[i];
                    }
                    else if (dampenings[i].triggerMode === 'SAFETY') {
                        _this.$scope.dampeningSafety = dampenings[i];
                    }
                }
                /*
                  This case is just if we have a trigger definition without dampenings.
                 */
                if (dampenings.length < 2) {
                    _this.initDampenings(triggerId);
                }
            }, function (reason) {
                _this.addAlertMsg(reason);
            });
        };
        DefinitionsController.prototype.initDampenings = function (triggerId) {
            this.$scope.dampeningFire.triggerId = triggerId;
            this.$scope.dampeningSafety.triggerId = triggerId;
            this.HawkularAlert.Dampening.save({ triggerId: this.$scope.dampeningFire.triggerId }, this.$scope.dampeningFire);
            this.HawkularAlert.Dampening.save({ triggerId: this.$scope.dampeningSafety.triggerId }, this.$scope.dampeningSafety);
        };
        DefinitionsController.prototype.saveDampening = function () {
            var _this = this;
            this.HawkularAlert.Dampening.put({ triggerId: this.$scope.editDampening.triggerId, dampeningId: this.$scope.editDampening.dampeningId }, this.$scope.editDampening, function () {
                _this.$scope.statusDampening.status = 'view';
            }, function (reason) {
                _this.addAlertMsg(reason);
            });
        };
        DefinitionsController.prototype.viewDampening = function (dampening) {
            this.$scope.statusDampening = { status: 'edit' };
            this.$scope.editDampening = dampening;
        };
        DefinitionsController.prototype.getDescription = function (type, condition) {
            var description = "";
            var op = "";
            if (type === 'AVAILABILITY') {
                description = condition.dataId + " is " + condition.operator;
            }
            else if (type === 'COMPARE') {
                op = this.getOperator(condition.operator);
                description = condition.dataId + " " + op + " " + "(" + condition.data2Multiplier + " * " + condition.data2Id + ")";
            }
            else if (type === 'STRING') {
                description = condition.dataId + " " + condition.operator + " '" + condition.pattern + "' (A/a " + condition.ignoreCase + ")";
            }
            else if (type === 'THRESHOLD') {
                op = this.getOperator(condition.operator);
                description = condition.dataId + " " + op + " " + condition.threshold;
            }
            else if (type === 'RANGE') {
                var low = "[";
                var high = "]";
                if (condition.operatorLow !== 'INCLUSIVE') {
                    low = "(";
                }
                if (condition.operatorHigh !== 'INCLUSIVE') {
                    high = ")";
                }
                var inout = " in ";
                if (!condition.inRange) {
                    inout = " out ";
                }
                description = condition.dataId + inout + low + condition.thresholdLow + ", " + condition.thresholdHigh + high;
            }
            return description;
        };
        DefinitionsController.prototype.getOperator = function (opCode) {
            var op = "";
            if (opCode === 'GT') {
                op = ">";
            }
            else if (opCode === 'GTE') {
                op = ">=";
            }
            else if (opCode === 'LT') {
                op = "<";
            }
            else if (opCode === 'LTE') {
                op = "<=";
            }
            return op;
        };
        DefinitionsController.prototype.newCondition = function () {
            this.$scope.statusCondition = { status: 'new' };
            this.$scope.editCondition = { type: 'AVAILABILITY', triggerId: this.$scope.trigger.id };
            this.$scope.conditionTypes = ['AVAILABILITY', 'COMPARE', 'STRING', 'THRESHOLD', 'RANGE'];
            this.changeConditionType();
        };
        DefinitionsController.prototype.changeConditionType = function () {
            if (this.$scope.editCondition.type === 'AVAILABILITY') {
                this.$scope.editCondition.dataId = '';
                this.$scope.editCondition.operator = 'DOWN';
            }
            else if (this.$scope.editCondition.type === 'COMPARE') {
                this.$scope.editCondition.dataId = '';
                this.$scope.editCondition.operator = 'LT';
                this.$scope.editCondition.data2Multiplier = 1.0;
                this.$scope.editCondition.data2Id = '';
            }
            else if (this.$scope.editCondition.type === 'STRING') {
                this.$scope.editCondition.dataId = '';
                this.$scope.editCondition.operator = 'EQUAL';
                this.$scope.editCondition.pattern = '';
                this.$scope.editCondition.ignoreCase = false;
            }
            else if (this.$scope.editCondition.type === 'THRESHOLD') {
                this.$scope.editCondition.dataId = '';
                this.$scope.editCondition.operator = 'LT';
                this.$scope.editCondition.threshold = 0.0;
            }
            else if (this.$scope.editCondition.type === 'RANGE') {
                this.$scope.editCondition.dataId = '';
                this.$scope.editCondition.operatorLow = 'INCLUSIVE';
                this.$scope.editCondition.operatorHigh = 'INCLUSIVE';
                this.$scope.editCondition.thresholdLow = 0.0;
                this.$scope.editCondition.thresholdHigh = 0.0;
                this.$scope.editCondition.inRange = true;
            }
        };
        DefinitionsController.prototype.viewCondition = function (condition) {
            this.$scope.statusCondition = { status: 'edit', conditionId: condition.conditionId, type: condition.type };
            this.$scope.editCondition = condition;
        };
        DefinitionsController.prototype.saveCondition = function () {
            var _this = this;
            if (this.$scope.statusCondition.status === 'new') {
                this.HawkularAlert.Condition.save({ triggerId: this.$scope.editCondition.triggerId }, this.$scope.editCondition, function () {
                    _this.$scope.statusCondition = { status: '' };
                    _this.viewDefinition(_this.$scope.trigger.id);
                }, function (reason) {
                    _this.addAlertMsg(reason);
                });
            }
            else {
                /*
                  "description" is a helper field on the javascript object
                 */
                delete this.$scope.editCondition.description;
                this.HawkularAlert.Condition.put({ triggerId: this.$scope.editCondition.triggerId, conditionId: this.$scope.editCondition.conditionId }, this.$scope.editCondition, function () {
                    _this.$scope.statusCondition = { status: '' };
                    _this.viewDefinition(_this.$scope.trigger.id);
                }, function (reason) {
                    _this.addAlertMsg(reason);
                });
            }
        };
        DefinitionsController.prototype.deleteCondition = function (conditionId, description) {
            var _this = this;
            if (this.$window.confirm('Do you want to delete ' + description + ' ?')) {
                this.$scope.msgs = [];
                this.HawkularAlert.Condition.delete({ triggerId: this.$scope.trigger.id, conditionId: conditionId }, function () {
                    _this.$scope.statusCondition = { status: '' };
                    _this.viewDefinition(_this.$scope.trigger.id);
                }, function (reasonDelete) {
                    _this.addAlertMsg(reasonDelete);
                });
            }
        };
        DefinitionsController.prototype.cancelCondition = function () {
            this.$scope.statusCondition = { status: '' };
        };
        DefinitionsController.$inject = ['$scope', '$window', '$log', 'HawkularAlert'];
        return DefinitionsController;
    })();
    HawkularAlerts.DefinitionsController = DefinitionsController;
    HawkularAlerts._module.controller('HawkularAlerts.DefinitionsController', DefinitionsController);
})(HawkularAlerts || (HawkularAlerts = {}));

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// <reference path="../../includes.ts"/>
var Sidebar;
(function (Sidebar) {
    Sidebar.pluginName = "sidebar";
    Sidebar.log = Logger.get(Sidebar.pluginName);
    Sidebar.templatePath = "plugins/sidebar/html/sidebar.html";
    Sidebar.globalEnvironmentId = "test";
})(Sidebar || (Sidebar = {}));

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// <reference path="../../includes.ts"/>
/// <reference path="sidebarGlobals.ts"/>
/// <reference path="sidebarDirective.ts"/>
var Sidebar;
(function (Sidebar) {
    Sidebar._module = angular.module(Sidebar.pluginName, ['duScroll']);
    Sidebar._module.directive('hawkularSidebar', function () {
        return new Sidebar.SidebarDirective();
    });
    hawtioPluginLoader.addModule(Sidebar.pluginName);
})(Sidebar || (Sidebar = {}));

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// <reference path="sidebarPlugin.ts"/>
var Sidebar;
(function (Sidebar) {
    var log = Logger.get("Sidebar");
    var SidebarDirective = (function () {
        function SidebarDirective() {
            this.restrict = 'E';
            this.transclude = true;
            this.replace = false;
            this.templateUrl = Sidebar.templatePath;
        }
        return SidebarDirective;
    })();
    Sidebar.SidebarDirective = SidebarDirective;
    /*
    export var SidebarController = _module.controller("Sidebar.SidebarController",
      ['$scope', '$rootScope', '$location', ($scope, $rootScope, $location) => {
  
        $scope.isSinglePage = function() {
          return $location.path().indexOf('/metrics') !== 0;
        };
  
        $scope.getClass = function (path) {
          return $location.path().indexOf(path) === 0 ? 'active' : '';
        };
      }]);
    */
    Sidebar.SidebarController = Sidebar._module.controller("Sidebar.SidebarController", ['$scope', '$rootScope', '$location', 'HawkularNav', 'HawkularInventory', function ($scope, $rootScope, $location, HawkularNav, HawkularInventory) {
        $scope.isSinglePage = function () {
            return $location.path().indexOf('/metrics') !== 0;
        };
        $scope.isAppServerPage = function () {
            return $location.path().indexOf('/hawkular-ui/app/') === 0;
        };
        $scope.getClass = function (path) {
            return $location.path().indexOf(path) === 0 ? 'active' : '';
        };
        $scope.rangeNames = {
            '3600000': 'Last Hour',
            '43200000': 'Last 12 Hours',
            '86400000': 'Last Day',
            '604800000': 'Last Week',
            '2592000000': 'Last Month',
            '31536000000': 'Last Year'
        };
        $scope.getFormattedDate = function () {
            var diff = $scope.hkParams.timeOffset;
            // FIXME: Use moment ?
            $scope.offsetName = $scope.rangeNames[$scope.hkParams.timeOffset] || 'Custom';
            // TODO: Use this for custom
            // var momStart = moment($scope.hkStartTimestamp);
            // var momEnd = moment($scope.hkEndTimestamp);
            var momStart = moment().subtract($scope.hkParams.timeOffset, 'milliseconds');
            var momEnd = moment();
            if (diff < 24 * 60 * 60 * 1000) {
                return momStart.format('D MMM YYYY') + ' ' + momStart.format('HH:mm') + ' - ' + (momStart.day() !== momEnd.day() ? momEnd.format('D MMM YYYY ') : '') + momEnd.format('HH:mm');
            }
            else {
                return momStart.format('D MMM YYYY') + ' - ' + momEnd.format('D MMM YYYY');
            }
        };
        $scope.setRange = function (range) {
            HawkularNav.setTimestamp(moment.duration(range).valueOf());
        };
        $scope.getUrlFromId = function (id) {
            if (!$scope.resource) {
                $scope.resource = HawkularInventory.Resource.get({ tenantId: $rootScope.currentPersona.id, environmentId: Sidebar.globalEnvironmentId, resourceId: id }, function (data) {
                    $scope.resourceName = data.properties.url;
                });
            }
            return $scope.resource;
        };
        // FIXME: Mock data.. remove when we have real app servers
        $scope.getAppServerFromId = function (id) {
            switch (id) {
                case "f5087d5d26aeff90cc92c738a10d8bba":
                    $scope.resourceName = 'Eavy Machine';
                    break;
                case "5c4785a7a304d32e5f404242666895f5":
                    $scope.resourceName = 'Tori Machine';
                    break;
                case "21193e7941642baa1285cd7edd8af62e":
                    $scope.resourceName = 'Wiko Machine';
                    break;
                case "20a0e9f5d777a16ad40928dd3ba1bef9":
                    $scope.resourceName = 'Tomy Machine';
                    break;
            }
        };
    }]);
})(Sidebar || (Sidebar = {}));

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// <reference path="../../includes.ts"/>
var Topbar;
(function (Topbar) {
    Topbar.pluginName = "topbar";
    Topbar.log = Logger.get(Topbar.pluginName);
    Topbar.templatePath = "plugins/topbar/html/topbar.html";
    Topbar.globalEnvironmentId = "test";
})(Topbar || (Topbar = {}));

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// <reference path="../../includes.ts"/>
/// <reference path="topbarGlobals.ts"/>
/// <reference path="topbarDirective.ts"/>
var Topbar;
(function (Topbar) {
    Topbar._module = angular.module(Topbar.pluginName, ['ngResource', 'hawkular.services', 'ui.bootstrap']);
    Topbar._module.directive('hawkularTopbar', function () {
        return new Topbar.TopbarDirective();
    });
    hawtioPluginLoader.addModule(Topbar.pluginName);
})(Topbar || (Topbar = {}));

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// <reference path="topbarPlugin.ts"/>
var Topbar;
(function (Topbar) {
    var log = Logger.get("Topbar");
    var TopbarDirective = (function () {
        function TopbarDirective() {
            this.restrict = 'E';
            this.transclude = false;
            this.replace = false;
            this.templateUrl = Topbar.templatePath;
        }
        return TopbarDirective;
    })();
    Topbar.TopbarDirective = TopbarDirective;
    Topbar.TopbarController = Topbar._module.controller("Topbar.TopbarController", ['$scope', '$rootScope', '$location', '$route', '$routeParams', 'HawkularNav', 'HawkularInventory', function ($scope, $rootScope, $location, $route, $routeParams, HawkularNav, HawkularInventory) {
        $scope.getClass = function (path) {
            return $location.path().indexOf(path) === 0 ? 'active' : '';
        };
    }]);
})(Topbar || (Topbar = {}));

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// <reference path="../../includes.ts"/>
/// <reference path="topbarGlobals.ts"/>
/// <reference path="topbarPlugin.ts"/>
var Topbar;
(function (Topbar) {
    var HawkularNav = (function () {
        function HawkularNav($rootScope, $route, $routeParams, HawkularInventory) {
            var _this = this;
            this.$rootScope = $rootScope;
            this.$route = $route;
            this.$routeParams = $routeParams;
            this.HawkularInventory = HawkularInventory;
            $rootScope.hkParams = $routeParams || [];
            // default time period set to 24 hours
            var defaultOffset = 1 * 60 * 60 * 1000;
            var init = function (tenantId) {
                HawkularInventory.Resource.query({ tenantId: tenantId, environmentId: Topbar.globalEnvironmentId }, function (resourceList) {
                    $rootScope.hkResources = resourceList;
                    for (var i = 0; i < resourceList.length; i++) {
                        if (resourceList[i].id === $rootScope.hkParams.resourceId) {
                            $rootScope.selectedResource = resourceList[i];
                        }
                    }
                });
                $rootScope.hkParams.timeOffset = $routeParams.timeOffset || defaultOffset;
                $rootScope.hkEndTimestamp = $routeParams.endTimestamp || moment().valueOf();
                $rootScope.hkStartTimestamp = moment().subtract($rootScope.hkParams.timeOffset, 'milliseconds').valueOf();
                $rootScope.$on('$routeChangeSuccess', function (event, current, previous) {
                    $rootScope.hkParams = current.params;
                    $rootScope.hkParams.timeOffset = $routeParams.timeOffset || defaultOffset;
                    $rootScope.hkEndTimestamp = $routeParams.endTimestamp || moment().valueOf();
                    $rootScope.hkStartTimestamp = moment().subtract($rootScope.hkParams.timeOffset, 'milliseconds').valueOf();
                    HawkularInventory.Resource.query({ tenantId: tenantId, environmentId: Topbar.globalEnvironmentId }, function (resourceList) {
                        $rootScope.hkResources = resourceList;
                        for (var i = 0; i < resourceList.length; i++) {
                            if (resourceList[i].id === $rootScope.hkParams.resourceId) {
                                $rootScope.selectedResource = resourceList[i];
                            }
                        }
                    });
                }, _this);
            };
            var tenantId = this.$rootScope.currentPersona && this.$rootScope.currentPersona.id;
            if (tenantId) {
                init(tenantId);
            }
            else {
                // currentPersona hasn't been injected to the rootScope yet, wait for it..
                $rootScope.$watch('currentPersona', function (currentPersona) { return currentPersona && init(currentPersona.id); });
            }
        }
        HawkularNav.prototype.setTimestamp = function (offset, end) {
            this.$route.updateParams({ timeOffset: offset, endTime: end });
        };
        HawkularNav.$inject = ['$rootScope', '$route', '$routeParams', 'HawkularInventory'];
        return HawkularNav;
    })();
    Topbar.HawkularNav = HawkularNav;
    Topbar._module.service('HawkularNav', HawkularNav);
})(Topbar || (Topbar = {}));

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// <reference path="topbarPlugin.ts"/>
/// <reference path="../../includes.ts"/>
var Topbar;
(function (Topbar) {
})(Topbar || (Topbar = {}));

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// <reference path="../../includes.ts"/>
var Inventory;
(function (Inventory) {
    Inventory.pluginName = "inventory";
    Inventory.log = Logger.get(Inventory.pluginName);
    Inventory.templatePath = "plugins/inventory/html";
})(Inventory || (Inventory = {}));

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// <reference path="../../includes.ts"/>
/// <reference path="inventoryGlobals.ts"/>
var Inventory;
(function (Inventory) {
    Inventory._module = angular.module(Inventory.pluginName, ['ngResource', 'hawkular.services', 'hawkular.charts']);
    var tab = undefined;
    Inventory._module.config(['$locationProvider', '$routeProvider', 'HawtioNavBuilderProvider', 'HawkularInventoryProvider', function ($locationProvider, $routeProvider, builder, HawkularInventoryProvider) {
        tab = builder.create().id(Inventory.pluginName).title(function () { return "Inventory"; }).href(function () { return "/inventory"; }).subPath("Inventory List", "Inventory", builder.join(Inventory.templatePath, 'inventory.html')).build();
        builder.configureRouting($routeProvider, tab);
        $locationProvider.html5Mode(true);
    }]);
    Inventory._module.run(['HawtioNav', function (HawtioNav) {
        HawtioNav.add(tab);
    }]);
    hawtioPluginLoader.addModule(Inventory.pluginName);
})(Inventory || (Inventory = {}));

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// <reference path="inventoryPlugin.ts"/>
var Inventory;
(function (Inventory) {
    Inventory.InventoryController = Inventory._module.controller("Inventory.InventoryController", ['$scope', '$rootScope', 'HawkularInventory', 'HawkularMetric', function ($scope, $rootScope, hkInventory, hkMetric) {
        // hard coded for now
        var envId = 'test';
        $scope.queryResources = function () {
            if (this.tenantId) {
                this.resources = hkInventory.ResourceOfType.query({ tenantId: this.tenantId, resourceTypeId: 'URL' }, function (data) {
                    angular.forEach(data, function (value) {
                        value.metrics = hkInventory.ResourceMetric.query({ tenantId: $scope.tenantId, environmentId: envId, resourceId: value.id });
                    });
                });
            }
        };
        $scope.queryMetrics = function () {
            if (this.tenantId && this.resourceId && envId) {
                this.metrics = hkInventory.ResourceMetric.query({ tenantId: this.tenantId, environmentId: envId, resourceId: this.resourceId });
            }
        };
        $scope.showMetric = function (tenantId, resourceId, metricId) {
            var _tenantId = tenantId || this.tenantId;
            var _resourceId = resourceId || this.resourceId;
            var _metricId = metricId || this.metricId;
            if (_tenantId && _resourceId && _metricId) {
                hkMetric.NumericMetricData.get({ tenantId: _tenantId, numericId: _metricId, buckets: 60 }, function (data) {
                    $rootScope.metricData = data;
                });
            }
        };
        $scope.closeChart = function () {
            delete $rootScope.metricData;
        };
    }]);
})(Inventory || (Inventory = {}));

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// <reference path="../../includes.ts"/>
var HawkularMetrics;
(function (HawkularMetrics) {
    /// some config vars
    HawkularMetrics.pluginName = "hawkular-metrics";
    HawkularMetrics.log = Logger.get(HawkularMetrics.pluginName);
    HawkularMetrics.templatePath = "plugins/metrics/html";
    /// These are plugin globals used across several screens (think session vars from server side programming)
    HawkularMetrics.globalEnvironmentId = "test";
})(HawkularMetrics || (HawkularMetrics = {}));

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// <reference path="../../includes.ts"/>
/// <reference path="metricsGlobals.ts"/>
var HawkularMetrics;
(function (HawkularMetrics) {
    HawkularMetrics._module = angular.module(HawkularMetrics.pluginName, ['ngResource', 'ui.select', 'hawkular.charts', 'hawkular.services', 'ui.bootstrap', 'topbar', 'patternfly.select', 'angular-momentjs', 'angular-md5']);
    var metricsTab;
    HawkularMetrics._module.config(['$httpProvider', '$locationProvider', '$routeProvider', 'HawtioNavBuilderProvider', function ($httpProvider, $locationProvider, $routeProvider, navBuilder) {
        metricsTab = navBuilder.create().id(HawkularMetrics.pluginName).title(function () { return 'Metrics'; }).href(function () { return '/metrics'; }).subPath('Add Url', 'add-url', navBuilder.join(HawkularMetrics.templatePath, 'add-url.html')).subPath('Response Time', 'response-time', navBuilder.join(HawkularMetrics.templatePath, 'response-time.html')).subPath('Availability', 'availability', navBuilder.join(HawkularMetrics.templatePath, 'availability.html')).subPath('Alerts', 'alerts', navBuilder.join(HawkularMetrics.templatePath, 'alerts.html')).build();
        navBuilder.configureRouting($routeProvider, metricsTab);
        $locationProvider.html5Mode(true);
    }]);
    HawkularMetrics._module.run(['HawtioNav', function (HawtioNav) {
        HawtioNav.add(metricsTab);
        HawkularMetrics.log.debug('loaded Metrics Plugin');
    }]);
    HawkularMetrics._module.directive('hkEnter', function () {
        return function (scope, element, attrs) {
            element.bind('keydown keypress', function (event) {
                if (event.which === 13) {
                    scope.$apply(function () {
                        scope.$eval(attrs.hkEnter);
                    });
                    event.preventDefault();
                }
            });
        };
    });
    HawkularMetrics._module.filter('firstUpper', function () {
        return function (input, all) {
            return (!!input) ? input.replace(/([^\W_]+[^\s-]*) */g, function (txt) {
                return txt.charAt(0).toUpperCase() + txt.substr(1);
            }) : '';
        };
    });
    /**
     * Replicates AngularJS 1.4 limitTo filter
     */
    HawkularMetrics._module.filter('limitTo14', function () {
        return function (input, limit, begin) {
            if (Math.abs(Number(limit)) === Infinity) {
                limit = Number(limit);
            }
            else {
                limit = parseInt(limit, 10);
            }
            if (isNaN(limit)) {
                return input;
            }
            if (typeof input === 'number') {
                input = input.toString();
            }
            if (!Array.isArray(input) && !(typeof input === 'string')) {
                return input;
            }
            begin = (!begin || isNaN(begin)) ? 0 : parseInt(begin, 10);
            begin = (begin < 0 && begin >= -input.length) ? input.length + begin : begin;
            if (limit >= 0) {
                return input.slice(begin, begin + limit);
            }
            else {
                if (begin === 0) {
                    return input.slice(limit, input.length);
                }
                else {
                    return input.slice(Math.max(0, begin + limit), begin);
                }
            }
        };
    });
    HawkularMetrics._module.filter('urlEncode', function () {
        return window['encodeURIComponent'];
    });
    HawkularMetrics._module.config(["$routeProvider", function ($routeProvider) {
        $routeProvider.when('/hawkular/:resourceId/:timeOffset?/:endTime?', { templateUrl: 'plugins/metrics/html/single-page.html' }).when('/metrics/response-time', {
            templateUrl: 'plugins/metrics/html/response-time.html',
            resolve: {
                hkResourceList: function ($filter, $location, $rootScope, $q, HawkularInventory) {
                    var resPromise = HawkularInventory.Resource.query({
                        tenantId: $rootScope.currentPersona.id,
                        environmentId: HawkularMetrics.globalEnvironmentId
                    }).$promise;
                    resPromise.then(function (hkResourceList) {
                        $location.path('/metrics/response-time/' + hkResourceList[0].id);
                    }, function () {
                        $location.url('/error');
                    });
                    // Returning a promise which would never be resolved, so that the page would not render.
                    // The page will be redirected before rendering based on the resource list loaded above.
                    return $q.defer().promise;
                }
            }
        }).when('/hawkular-ui/url/url-list', { templateUrl: 'plugins/metrics/html/add-url.html' }).when('/hawkular-ui/url/response-time/:resourceId/:timeOffset?/:endTime?', { templateUrl: 'plugins/metrics/html/response-time.html' }).when('/hawkular-ui/url/availability/:resourceId/:timeOffset?/:endTime?', { templateUrl: 'plugins/metrics/html/availability.html' }).when('/hawkular-ui/url/alerts/:resourceId/:timeOffset?/:endTime?', { templateUrl: 'plugins/metrics/html/alerts.html' }).when('/hawkular-ui/app/app-list', { templateUrl: 'plugins/metrics/html/app-server-list.html' }).when('/hawkular-ui/app/app-details/:resourceId/:timeOffset?/:endTime?', {
            templateUrl: 'plugins/metrics/html/app-details/app-server-details.html',
            resolve: {
                hideSubNav: function () {
                    return true;
                }
            }
        }).otherwise({ redirectTo: '/hawkular-ui/url/url-list' });
    }]);
    hawtioPluginLoader.addModule(HawkularMetrics.pluginName);
})(HawkularMetrics || (HawkularMetrics = {}));

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// <reference path="metricsPlugin.ts"/>
/// <reference path="../../includes.ts"/>
var HawkularMetrics;
(function (HawkularMetrics) {
    var HawkularAlertsManager = (function () {
        function HawkularAlertsManager(HawkularAlert, $q, $log, $moment) {
            this.HawkularAlert = HawkularAlert;
            this.$q = $q;
            this.$log = $log;
            this.$moment = $moment;
        }
        HawkularAlertsManager.prototype.createTrigger = function (triggerName, enabled, conditionType, email) {
            var _this = this;
            // Create a trigger
            var triggerId;
            return this.HawkularAlert.Trigger.save({
                name: triggerName,
                id: triggerName,
                description: 'Created on ' + Date(),
                firingMatch: 'ALL',
                autoResolveMatch: 'ALL',
                enabled: enabled,
                autoResolve: false,
                actions: { email: [email] }
            }).$promise.then(function (trigger) {
                triggerId = trigger.id;
                // Parse metrics id from the trigger name
                var dataId = trigger.name.slice(0, -14) + '.status.duration';
                // Create a conditions for that trigger
                if (conditionType === 'THRESHOLD') {
                    return _this.createCondition(triggerId, {
                        type: conditionType,
                        triggerId: triggerId,
                        threshold: 1000,
                        dataId: dataId,
                        operator: 'GT'
                    });
                }
                else if (conditionType === 'AVAILABILITY') {
                    return _this.createCondition(triggerId, {
                        type: conditionType,
                        triggerId: triggerId,
                        dataId: trigger.name.slice(0, -14),
                        operator: 'DOWN'
                    });
                }
            }).then(function () {
                // Create dampening for that trigger
                return _this.createDampening(triggerId, 7 * 60000);
            });
        };
        HawkularAlertsManager.prototype.deleteTrigger = function (triggerId) {
            return this.HawkularAlert.Trigger.delete({ triggerId: triggerId }).$promise;
        };
        HawkularAlertsManager.prototype.updateTrigger = function (triggerId, data) {
            data.id = triggerId;
            return this.HawkularAlert.Trigger.put({ triggerId: triggerId }, data).$promise;
        };
        HawkularAlertsManager.prototype.getAction = function (email) {
            return this.HawkularAlert.Action.get({
                pluginId: 'email',
                actionId: email
            }).$promise;
        };
        HawkularAlertsManager.prototype.createAction = function (email) {
            return this.HawkularAlert.Action.save({
                actionPlugin: 'email',
                actionId: email,
                description: 'Created on ' + Date(),
                to: email
            }).$promise;
        };
        HawkularAlertsManager.prototype.addEmailAction = function (email) {
            var _this = this;
            return this.getAction(email).then(function (promiseValue) {
                return promiseValue;
            }, function (reason) {
                // Create a default email action
                if (reason.status === 404) {
                    _this.$log.debug('Action does not exist, creating one');
                    return _this.createAction(email);
                }
            });
        };
        HawkularAlertsManager.prototype.updateAction = function (email) {
            return this.HawkularAlert.Action.put({
                actionPlugin: 'email',
                actionId: email,
                description: 'Created on ' + Date(),
                to: email
            }).$promise;
        };
        HawkularAlertsManager.prototype.createCondition = function (triggerId, condition) {
            return this.HawkularAlert.Condition.save({ triggerId: triggerId }, condition).$promise;
        };
        HawkularAlertsManager.prototype.updateCondition = function (triggerId, conditionId, condition) {
            return this.HawkularAlert.Condition.put({ triggerId: triggerId, conditionId: conditionId }, condition).$promise;
        };
        HawkularAlertsManager.prototype.createDampening = function (triggerId, duration) {
            return this.HawkularAlert.Dampening.save({ triggerId: triggerId }, {
                triggerId: triggerId,
                evalTimeSetting: duration,
                type: 'STRICT_TIME'
            }).$promise;
        };
        HawkularAlertsManager.prototype.updateDampening = function (triggerId, dampeningId, dampening) {
            dampening.dampeningId = dampeningId;
            return this.HawkularAlert.Dampening.put({ triggerId: triggerId, dampeningId: dampeningId }, dampening).$promise;
        };
        HawkularAlertsManager.prototype.getActions = function (triggerId) {
            return undefined;
        };
        HawkularAlertsManager.prototype.getTrigger = function (triggerId) {
            return this.HawkularAlert.Trigger.get({ triggerId: triggerId }).$promise;
        };
        HawkularAlertsManager.prototype.setEmail = function (triggerId, email) {
            var _this = this;
            var actions = this.getActions(triggerId);
            return actions.then(function (actions) {
                if (!actions) {
                    // If action for this email does not exist, create one
                    return _this.HawkularAlert.Action.save({}).$promise;
                }
                else {
                    // If it exists, just use it
                    return _this.HawkularAlert.Action.put({
                        actionId: ''
                    }, {}).$promise;
                }
            });
        };
        HawkularAlertsManager.prototype.setResponseTime = function (triggerId, treshold, duration, enabled) {
            return undefined;
        };
        HawkularAlertsManager.prototype.setDowntime = function (triggerId, duration, enabled) {
            return undefined;
        };
        HawkularAlertsManager.prototype.queryConsoleAlerts = function (metricId) {
            var _this = this;
            var alertList = [];
            /* Format of Alerts:
      
             alert: {
             type: 'THRESHOLD' or 'AVAILABILITY'
             avg: Average value based on the evalSets 'values'
             start: The time of the first data ('dataTimestamp') in evalSets
             threshold: The threshold taken from condition.threshold
             end: The time when the alert was sent ('ctime')
             }
      
             */
            return this.HawkularAlert.Alert.query({
                triggerIds: metricId + '_trigger_avail,' + metricId + '_trigger_thres',
                statuses: 'OPEN'
            }).$promise.then(function (serverAlerts) {
                var momentNow = _this.$moment();
                for (var i = 0; i < serverAlerts.length; i++) {
                    var consoleAlert = {};
                    var serverAlert = serverAlerts[i];
                    consoleAlert.id = serverAlert.alertId;
                    consoleAlert.end = serverAlert.ctime;
                    var sum = 0.0;
                    var count = 0.0;
                    for (var j = 0; j < serverAlert.evalSets.length; j++) {
                        var eval = serverAlert.evalSets[j][0];
                        if (!consoleAlert.start && eval.dataTimestamp) {
                            consoleAlert.start = eval.dataTimestamp;
                        }
                        if (!consoleAlert.threshold && eval.condition.threshold) {
                            consoleAlert.threshold = eval.condition.threshold;
                        }
                        if (!consoleAlert.type && eval.condition.type) {
                            consoleAlert.type = eval.condition.type;
                        }
                        var momentAlert = _this.$moment(consoleAlert.end);
                        if (momentAlert.year() === momentNow.year()) {
                            consoleAlert.isThisYear = true;
                            if (momentAlert.dayOfYear() === momentNow.dayOfYear()) {
                                consoleAlert.isToday = true;
                            }
                        }
                        sum += eval.value;
                        count++;
                    }
                    consoleAlert.avg = sum / count;
                    alertList.push(consoleAlert);
                }
            }, function (error) {
                _this.$log.debug('querying data error', error);
            }).then(function () {
                return alertList;
            });
        };
        HawkularAlertsManager.$inject = ['HawkularAlert', '$q', '$log', '$moment'];
        return HawkularAlertsManager;
    })();
    HawkularMetrics.HawkularAlertsManager = HawkularAlertsManager;
    HawkularMetrics._module.service('HawkularAlertsManager', HawkularAlertsManager);
})(HawkularMetrics || (HawkularMetrics = {}));

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// <reference path="metricsPlugin.ts"/>
/// <reference path="../../includes.ts"/>
var HawkularMetrics;
(function (HawkularMetrics) {
    var HkHeaderParser = (function () {
        function HkHeaderParser() {
            this.PARAMETER_EXPRESSION = /(rel)="(\w+)"/;
            this.total = 0;
        }
        HkHeaderParser.prototype.parseLinkHeader = function (value) {
            var relationLinks = {};
            if (!value) {
                return relationLinks;
            }
            var links = value.split(', ');
            for (var i = 0; i < links.length; i++) {
                var linkParts = links[i].split('>');
                var linkHref = linkParts[0].substring(1);
                var linkRelationParameterString = linkParts[1];
                var linkRelationParameterParts = this.PARAMETER_EXPRESSION.exec(linkRelationParameterString);
                // Get the relation name for current Link
                if (linkRelationParameterParts && linkRelationParameterParts[1] === 'rel' && linkRelationParameterParts[2]) {
                    //debugger;
                    relationLinks[linkRelationParameterParts[2]] = {
                        href: linkHref
                    };
                    // Get the parameters (page, per_page, ...) of current link
                    relationLinks[linkRelationParameterParts[2]]['params'] = {};
                    var linkHrefParts = linkHref.split('?');
                    var linkHrefParametersString = linkHrefParts[1];
                    var hrefParamsPairStringParts = linkHrefParametersString.split('&');
                    for (var j = 0; j < hrefParamsPairStringParts.length; j++) {
                        var parameterPair = hrefParamsPairStringParts[j];
                        var parameterPairParts = parameterPair.split('=');
                        if (parameterPairParts[0] && parameterPairParts[1]) {
                            relationLinks[linkRelationParameterParts[2]]['params'][parameterPairParts[0]] = parameterPairParts[1];
                        }
                    }
                }
            }
            return relationLinks;
        };
        HkHeaderParser.prototype.parse = function (headers) {
            return {
                total: headers['x-total-count'],
                rel: this.parseLinkHeader(headers.link)
            };
        };
        HkHeaderParser.$inject = [];
        return HkHeaderParser;
    })();
    HawkularMetrics.HkHeaderParser = HkHeaderParser;
    ;
    HawkularMetrics._module.service('HkHeaderParser', HkHeaderParser);
    var paginationController = function ($scope) {
        $scope.currentPageView = $scope.currentPage + 1;
        $scope.pagesNumber = getPagesNumber();
        function getPagesNumber() {
            return Math.ceil(($scope.headers.total || 1) / $scope.perPage);
        }
        $scope.setPage = function (pageNumber) {
            $scope.pagesNumber = getPagesNumber();
            if ($scope.pagesNumber === 1) {
                $scope.currentPageView = 1;
                return;
            }
            if (pageNumber < 1) {
                $scope.pageSetter({ pageNumber: 0 });
                $scope.currentPageView = 1;
            }
            else if (pageNumber >= $scope.pagesNumber) {
                $scope.pageSetter({ pageNumber: $scope.pagesNumber - 1 });
                $scope.currentPageView = pageNumber;
            }
            else {
                $scope.pageSetter({ pageNumber: pageNumber });
            }
        };
        $scope.goToFirst = function () {
            $scope.pageSetter({ pageNumber: 0 });
        };
        $scope.goToLast = function () {
            $scope.pagesNumber = getPagesNumber();
            $scope.pageSetter({ pageNumber: $scope.pagesNumber - 1 });
        };
        $scope.goTos = [0];
        $scope.$watch('currentPage', function (recentCurrentPage) {
            $scope.currentPageView = parseInt(recentCurrentPage, 10) + 1;
        });
        $scope.$watchGroup(['headers', 'perPage'], function () {
            $scope.pagesNumber = getPagesNumber();
            $scope.goTos = new Array($scope.pagesNumber);
        });
    };
    var HkPagination = (function () {
        function HkPagination() {
            this.templateUrl = 'plugins/metrics/html/url-pagination.html';
            this.scope = {
                resourceList: '=',
                currentPage: '=',
                linkHeader: '=',
                pageSetter: '&',
                perPage: '=',
                headers: '='
            };
            this.replace = 'true';
            this.controller = paginationController;
        }
        HkPagination.Factory = function () {
            var directive = function () {
                return new HkPagination();
            };
            directive['$inject'] = [];
            return directive;
        };
        return HkPagination;
    })();
    HawkularMetrics._module.directive('hkPagination', HkPagination.Factory());
    var HkDataPagination = (function () {
        function HkDataPagination() {
            this.templateUrl = 'plugins/metrics/html/data-pagination.html';
            this.scope = {
                resourceList: '=',
                currentPage: '=',
                linkHeader: '=',
                pageSetter: '&',
                perPage: '=',
                headers: '='
            };
            this.replace = 'true';
            this.controller = paginationController;
        }
        HkDataPagination.Factory = function () {
            var directive = function () {
                return new HkDataPagination();
            };
            directive['$inject'] = [];
            return directive;
        };
        return HkDataPagination;
    })();
    HawkularMetrics._module.directive('hkDataPagination', HkDataPagination.Factory());
})(HawkularMetrics || (HawkularMetrics = {}));

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// <reference path="metricsPlugin.ts"/>
/*
 TODO
 Move to shared service location
  */
var HawkularMetrics;
(function (HawkularMetrics) {
    var HawkularErrorManager = (function () {
        function HawkularErrorManager($q, $log) {
            this.$q = $q;
            this.$log = $log;
        }
        HawkularErrorManager.prototype.errorToastr = function (error, errorMsg) {
            var errorMsgComplete;
            if (error.data && error.data.errorMsg) {
                errorMsgComplete = error.data.errorMsg;
            }
            else {
                errorMsgComplete = errorMsg + ' ' + error;
            }
            this.$log.error(errorMsgComplete);
            toastr.error(errorMsgComplete);
        };
        HawkularErrorManager.prototype.errorHandler = function (error, msg, cb) {
            if (error) {
                this.errorToastr(error, msg);
                if (cb) {
                    cb(error, msg);
                }
            }
            return this.$q.reject(null);
        };
        HawkularErrorManager.$inject = ['$q', '$log'];
        return HawkularErrorManager;
    })();
    HawkularMetrics.HawkularErrorManager = HawkularErrorManager;
    HawkularMetrics._module.service('HawkularErrorManager', HawkularErrorManager);
})(HawkularMetrics || (HawkularMetrics = {}));

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// <reference path="metricsPlugin.ts"/>
/// <reference path="alertsManager.ts"/>
/// <reference path="pagination.ts"/>
/// <reference path="errorManager.ts"/>
var HawkularMetrics;
(function (HawkularMetrics) {
    var AddUrlController = (function () {
        function AddUrlController($location, $scope, $rootScope, $interval, $log, $filter, $modal, HawkularInventory, HawkularMetric, HawkularAlert, HawkularAlertsManager, HawkularErrorManager, $q, md5, HkHeaderParser, resourceUrl) {
            var _this = this;
            this.$location = $location;
            this.$scope = $scope;
            this.$rootScope = $rootScope;
            this.$interval = $interval;
            this.$log = $log;
            this.$filter = $filter;
            this.$modal = $modal;
            this.HawkularInventory = HawkularInventory;
            this.HawkularMetric = HawkularMetric;
            this.HawkularAlert = HawkularAlert;
            this.HawkularAlertsManager = HawkularAlertsManager;
            this.HawkularErrorManager = HawkularErrorManager;
            this.$q = $q;
            this.md5 = md5;
            this.HkHeaderParser = HkHeaderParser;
            this.resourceUrl = resourceUrl;
            this.httpUriPart = 'http://';
            this.addProgress = false;
            this.lastUpdateTimestamp = new Date();
            this.resPerPage = 5;
            this.resCurPage = 0;
            this.headerLinks = {};
            $scope.vm = this;
            this.resourceUrl = this.httpUriPart;
            if ($rootScope.currentPersona) {
                this.getResourceList(this.$rootScope.currentPersona.id);
            }
            else {
                // currentPersona hasn't been injected to the rootScope yet, wait for it..
                $rootScope.$watch('currentPersona', function (currentPersona) { return currentPersona && _this.getResourceList(currentPersona.id); });
            }
            this.autoRefresh(20);
        }
        AddUrlController.prototype.cancelAutoRefresh = function () {
            this.$interval.cancel(this.autoRefreshPromise);
            toastr.info('Canceling Auto Refresh');
        };
        AddUrlController.prototype.autoRefresh = function (intervalInSeconds) {
            var _this = this;
            this.autoRefreshPromise = this.$interval(function () {
                _this.getResourceList();
            }, intervalInSeconds * 1000);
            this.$scope.$on('$destroy', function () {
                _this.$interval.cancel(_this.autoRefreshPromise);
            });
        };
        AddUrlController.prototype.addUrl = function (url) {
            var _this = this;
            this.addProgress = true;
            var resourceId = this.md5.createHash(url || '');
            var resource = {
                resourceTypeId: 'URL',
                id: resourceId,
                properties: {
                    url: url
                }
            };
            this.$log.info('Adding new Resource Url to Hawkular-inventory: ' + url);
            var metricId;
            var defaultEmail = this.$rootScope.userDetails.email || 'myemail@company.com';
            var err = function (error, msg) { return _this.HawkularErrorManager.errorHandler(error, msg); };
            var currentTenantId = this.$rootScope.currentPersona.id;
            /// Add the Resource and its metrics
            this.HawkularInventory.Resource.save({ tenantId: currentTenantId, environmentId: HawkularMetrics.globalEnvironmentId }, resource).$promise.then(function (newResource) {
                _this.getResourceList(currentTenantId);
                metricId = resourceId;
                console.dir(newResource);
                _this.$log.info('New Resource ID: ' + metricId + ' created.');
                var metricsIds = [metricId + '.status.duration', metricId + '.status.code'];
                var metrics = [{
                    id: metricsIds[0],
                    metricTypeId: 'status.duration.type',
                    properties: {
                        description: 'Response Time in ms.'
                    }
                }, {
                    id: metricsIds[1],
                    metricTypeId: 'status.code.type',
                    properties: {
                        description: 'Status Code'
                    }
                }];
                var errMetric = function (error) { return err(error, 'Error saving metric.'); };
                var createMetric = function (metric) { return _this.HawkularInventory.Metric.save({
                    tenantId: currentTenantId,
                    environmentId: HawkularMetrics.globalEnvironmentId
                }, metric).$promise; };
                var associateResourceWithMetrics = function () { return _this.HawkularInventory.ResourceMetric.save({
                    tenantId: currentTenantId,
                    environmentId: HawkularMetrics.globalEnvironmentId,
                    resourceId: resourceId
                }, metricsIds).$promise; };
                /// For right now we will just Register a couple of metrics automatically
                return _this.$q.all([createMetric(metrics[0]), createMetric(metrics[1])]).then(associateResourceWithMetrics, errMetric).catch(function (e) { return err(e, 'Error associating metrics with resource.'); });
            }).then(function () { return _this.HawkularAlertsManager.addEmailAction(defaultEmail); }, function (e) { return err(e, 'Error during saving metrics.'); }).then(function () { return _this.HawkularAlertsManager.createTrigger(metricId + '_trigger_thres', true, 'THRESHOLD', defaultEmail); }, function (e) { return err(e, 'Error saving email action.'); }).then(function (alert) { return _this.HawkularAlertsManager.createTrigger(metricId + '_trigger_avail', false, 'AVAILABILITY', defaultEmail); }, function (e) { return err(e, 'Error saving threshold trigger.'); }).then(function () { return toastr.info('Your data is being collected. Please be patient (should be about another minute).'); }, function (e) { return err(e, 'Error saving availability trigger.'); }).finally(function () {
                _this.resourceUrl = _this.httpUriPart;
                _this.$scope.addUrlForm.$setPristine();
                _this.addProgress = false;
            });
        };
        AddUrlController.prototype.getResourceList = function (currentTenantId) {
            var _this = this;
            var tenantId = currentTenantId || this.$rootScope.currentPersona.id;
            this.HawkularInventory.ResourceOfType.query({ tenantId: tenantId, resourceTypeId: 'URL', per_page: this.resPerPage, page: this.resCurPage }, function (aResourceList, getResponseHeaders) {
                // FIXME: hack.. make expanded out of list
                _this.headerLinks = _this.HkHeaderParser.parse(getResponseHeaders());
                var pages = getResponseHeaders().link ? getResponseHeaders().link.split(', ') : [];
                for (var p = 0; p < pages.length; p++) {
                    if (pages[p].indexOf('')) {
                    }
                }
                var expanded = _this.resourceList ? _this.resourceList.expanded : [];
                aResourceList.expanded = expanded;
                _this.HawkularAlert.Alert.query({ statuses: 'OPEN' }, function (anAlertList) {
                    _this.alertList = anAlertList;
                }, _this);
                var promises = [];
                angular.forEach(aResourceList, function (res, idx) {
                    promises.push(this.HawkularMetric.NumericMetricData.queryMetrics({
                        tenantId: tenantId,
                        resourceId: res.id,
                        numericId: (res.id + '.status.duration'),
                        start: moment().subtract(1, 'hours').valueOf(),
                        end: moment().valueOf()
                    }, function (resource) {
                        // FIXME: Work data so it works for chart ?
                        res['responseTime'] = resource;
                    }).$promise);
                    promises.push(this.HawkularMetric.AvailabilityMetricData.query({
                        tenantId: tenantId,
                        availabilityId: res.id,
                        distinct: true,
                        start: 1,
                        end: moment().valueOf()
                    }, function (resource) {
                        res['isUp'] = (resource[0] && resource[0].value === 'up');
                    }).$promise);
                    promises.push(this.HawkularMetric.AvailabilityMetricData.query({
                        tenantId: tenantId,
                        availabilityId: res.id,
                        start: 1,
                        end: moment().valueOf(),
                        buckets: 1
                    }, function (resource) {
                        res['availability'] = resource[0].uptimeRatio * 100;
                        res['downtimeDuration'] = Math.round(resource[0].downtimeDuration / 1000 / 60);
                        res['lastDowntime'] = resource[0].lastDowntime;
                    }).$promise);
                    this.lastUpdateTimestamp = new Date();
                }, _this);
                _this.$q.all(promises).then(function (result) {
                    _this.resourceList = aResourceList;
                });
            });
        };
        AddUrlController.prototype.getAverage = function (data, field) {
            if (data) {
                var sum = 0;
                for (var i = 0; i < data.length; i++) {
                    sum += parseInt(data[i][field], 10);
                }
                return Math.round(sum / data.length);
            }
        };
        AddUrlController.prototype.deleteResource = function (resource) {
            var _this = this;
            this.$modal.open({
                templateUrl: 'plugins/metrics/html/modals/delete-resource.html',
                controller: DeleteResourceModalController,
                resolve: {
                    resource: function () { return resource; }
                }
            }).result.then(function (result) { return _this.getResourceList(); });
        };
        AddUrlController.prototype.setPage = function (page) {
            this.resCurPage = page;
            this.getResourceList();
        };
        /// this is for minification purposes
        AddUrlController.$inject = ['$location', '$scope', '$rootScope', '$interval', '$log', '$filter', '$modal', 'HawkularInventory', 'HawkularMetric', 'HawkularAlert', 'HawkularAlertsManager', 'HawkularErrorManager', '$q', 'md5', 'HkHeaderParser'];
        return AddUrlController;
    })();
    HawkularMetrics.AddUrlController = AddUrlController;
    var DeleteResourceModalController = (function () {
        function DeleteResourceModalController($scope, $rootScope, $modalInstance, $q, HawkularInventory, HawkularAlertsManager, resource) {
            this.$scope = $scope;
            this.$rootScope = $rootScope;
            this.$modalInstance = $modalInstance;
            this.$q = $q;
            this.HawkularInventory = HawkularInventory;
            this.HawkularAlertsManager = HawkularAlertsManager;
            this.resource = resource;
            $scope.vm = this;
        }
        DeleteResourceModalController.prototype.deleteResource = function () {
            var _this = this;
            var metricsIds = [this.resource.id + '.status.duration', this.resource.id + '.status.code'];
            var triggerIds = [this.resource.id + '_trigger_thres', this.resource.id + '_trigger_avail'];
            var deleteMetric = function (metricId) { return _this.HawkularInventory.Metric.delete({
                tenantId: _this.$rootScope.currentPersona.id,
                environmentId: HawkularMetrics.globalEnvironmentId,
                metricId: metricId
            }).$promise; };
            var removeResource = function () { return _this.HawkularInventory.Resource.delete({
                tenantId: _this.$rootScope.currentPersona.id,
                environmentId: HawkularMetrics.globalEnvironmentId,
                resourceId: _this.resource.id
            }).$promise; };
            this.$q.all([deleteMetric(metricsIds[0]), deleteMetric(metricsIds[1]), this.HawkularAlertsManager.deleteTrigger(triggerIds[0]), this.HawkularAlertsManager.deleteTrigger(triggerIds[1])]).then(removeResource).then(function (res) {
                toastr.success('The site ' + _this.resource.properties.url + ' is no longer being monitored.');
                _this.$modalInstance.close(res);
            });
        };
        DeleteResourceModalController.prototype.cancel = function () {
            this.$modalInstance.dismiss('cancel');
        };
        DeleteResourceModalController.$inject = ['$scope', '$rootScope', '$modalInstance', '$q', 'HawkularInventory', 'HawkularAlertsManager', 'resource'];
        return DeleteResourceModalController;
    })();
    HawkularMetrics._module.controller('HawkularMetrics.AddUrlController', AddUrlController);
})(HawkularMetrics || (HawkularMetrics = {}));

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// <reference path="metricsPlugin.ts"/>
/// <reference path="../../includes.ts"/>
/// <reference path="alertsManager.ts"/>
/// <reference path="errorManager.ts"/>
var HawkularMetrics;
(function (HawkularMetrics) {
    var MetricsAlertController = (function () {
        function MetricsAlertController($scope, HawkularAlert, HawkularAlertsManager, HawkularErrorManager, $log, $q, $rootScope, $routeParams, $modal) {
            var _this = this;
            this.$scope = $scope;
            this.HawkularAlert = HawkularAlert;
            this.HawkularAlertsManager = HawkularAlertsManager;
            this.HawkularErrorManager = HawkularErrorManager;
            this.$log = $log;
            this.$q = $q;
            this.$rootScope = $rootScope;
            this.$routeParams = $routeParams;
            this.$modal = $modal;
            this.alertList = [];
            this.isResolvingAll = false;
            this.$log.debug('querying data');
            this.$log.debug('$routeParams', $routeParams);
            this.openSetup = function () {
                var modalInstance = $modal.open({
                    templateUrl: 'plugins/metrics/html/alerts-setup.html',
                    controller: 'MetricsAlertSetupController as mas'
                });
                modalInstance.result.then(function (selectedItem) {
                    $scope.selected = selectedItem;
                }, function () {
                    $log.info('Modal dismissed at: ' + new Date());
                });
            };
            this.metricId = $routeParams.resourceId;
            $scope.alertsTimeOffset = $routeParams.timeOffset || 3600000;
            // If the end time is not specified in URL use current time as end time
            $scope.alertsTimeEnd = $routeParams.endTime ? $routeParams.endTime : (new Date()).getTime();
            $scope.alertsTimeStart = $scope.alertsTimeEnd - $scope.alertsTimeOffset;
            $scope.timeFilter = function (value) {
                // If no time offset is specified we will return all alerts
                if (!$scope.alertsTimeOffset) {
                    return true;
                }
                return !!((value.start > $scope.alertsTimeStart) && (value.start < $scope.alertsTimeEnd));
            };
            HawkularAlertsManager.queryConsoleAlerts(this.metricId).then(function (data) {
                _this.$log.debug('queryConsoleAlerts', data);
                _this.alertList = data;
                _this.alertList.$resolved = true; // FIXME
            }, function (error) {
                return _this.HawkularErrorManager.errorHandler(error, 'Error fetching alerts.');
            });
        }
        MetricsAlertController.prototype.alertResolve = function (alert, index) {
            var _this = this;
            for (var i = 0; i < this.alertList.length; i++) {
                if (this.alertList[i].$$hashKey === alert.$$hashKey) {
                    console.log(this.alertList[i]);
                    this.HawkularAlert.Alert.resolve({ alertIds: alert.id }, {}).$promise.then(function () {
                        _this.alertList.splice(i, 1);
                    });
                    break;
                }
            }
        };
        MetricsAlertController.prototype.resolveAll = function () {
            var _this = this;
            this.isResolvingAll = true;
            var alertIdList = '';
            for (var i = 0; i < this.alertList.length; i++) {
                alertIdList = alertIdList + this.alertList[i].id + ',';
            }
            alertIdList = alertIdList.slice(0, -1);
            this.HawkularAlert.Alert.resolve({ alertIds: alertIdList }, {}).$promise.then(function () {
                _this.alertList.length = 0;
                _this.isResolvingAll = false;
            });
        };
        MetricsAlertController.$inject = ['$scope', 'HawkularAlert', 'HawkularAlertsManager', 'HawkularErrorManager', '$log', '$q', '$rootScope', '$routeParams', '$modal'];
        return MetricsAlertController;
    })();
    HawkularMetrics.MetricsAlertController = MetricsAlertController;
    HawkularMetrics._module.controller('MetricsAlertController', MetricsAlertController);
    var MetricsAlertSetupController = (function () {
        function MetricsAlertSetupController($scope, HawkularAlert, HawkularAlertsManager, HawkularErrorManager, $log, $q, $rootScope, $routeParams, $modalInstance) {
            var _this = this;
            this.$scope = $scope;
            this.HawkularAlert = HawkularAlert;
            this.HawkularAlertsManager = HawkularAlertsManager;
            this.HawkularErrorManager = HawkularErrorManager;
            this.$log = $log;
            this.$q = $q;
            this.$rootScope = $rootScope;
            this.$routeParams = $routeParams;
            this.$modalInstance = $modalInstance;
            this.alertSetupBackup = {};
            this.saveProgress = false;
            this.responseUnit = 60000;
            this.downtimeUnit = 1;
            this.thresDampDurationEnabled = false;
            this.isSettingChange = false;
            this.timeUnits = [
                { value: 1, label: 'miliseconds' },
                { value: 1000, label: 'seconds' },
                { value: 60000, label: 'minutes' },
                { value: 360000, label: 'hours' }
            ];
            this.timeUnitsDict = {
                '1': 'miliseconds',
                '1000': 'seconds',
                '60000': 'minutes',
                '360000': 'hours'
            };
            this.$log.debug('querying data');
            this.$log.debug('$routeParams', $routeParams.resourceId);
            // TODO - update the pfly notification service to support more and category based notifications containers.
            this.$rootScope.hkNotifications = { alerts: [] };
            // Get the data about Threshold Trigger
            HawkularAlertsManager.getTrigger($routeParams.resourceId + '_trigger_thres').then(function (data) {
                _this.trigger_thres = data;
                _this.alertSetupBackup.trigger_thres = angular.copy(_this.trigger_thres);
                _this.$log.debug('this.trigger_thres', _this.trigger_thres);
                return HawkularAlert.Dampening.query({ triggerId: $routeParams.resourceId + '_trigger_thres' }).$promise;
            }, function (error) {
                return _this.HawkularErrorManager.errorHandler(error, 'Error fetching threshold trigger.');
            }).then(function (data) {
                _this.trigger_thres_damp = data;
                _this.alertSetupBackup.trigger_thres_damp = angular.copy(_this.trigger_thres_damp);
                _this.responseDuration = data[0].evalTimeSetting / _this.responseUnit;
                _this.alertSetupBackup.responseDuration = angular.copy(_this.responseDuration);
                _this.thresDampDurationEnabled = data[0].evalTimeSetting !== 0;
                _this.alertSetupBackup.thresDampDurationEnabled = angular.copy(_this.thresDampDurationEnabled);
                _this.$log.debug('this.trigger_thres_damp', _this.trigger_thres_damp);
                return HawkularAlert.Condition.query({ triggerId: $routeParams.resourceId + '_trigger_thres' }).$promise;
            }, function (error) {
                return _this.HawkularErrorManager.errorHandler(error, 'Error fetching threshold trigger dampening.');
            }).then(function (data) {
                _this.trigger_thres_cond = data;
                _this.alertSetupBackup.trigger_thres_cond = angular.copy(_this.trigger_thres_cond);
                _this.$log.debug('this.trigger_thres_cond', _this.trigger_thres_cond);
            }, function (error) {
                return _this.HawkularErrorManager.errorHandler(error, 'Error fetching threshold trigger condition.');
            });
            // Get the data about Availability Trigger
            HawkularAlertsManager.getTrigger($routeParams.resourceId + '_trigger_avail').then(function (data) {
                _this.trigger_avail = data;
                _this.alertSetupBackup.trigger_avail = angular.copy(_this.trigger_avail);
                _this.$log.debug('this.trigger_avail', _this.trigger_avail);
                return HawkularAlert.Dampening.query({ triggerId: $routeParams.resourceId + '_trigger_avail' }).$promise;
            }, function (error) {
                return _this.HawkularErrorManager.errorHandler(error, 'Error fetching availability trigger.');
            }).then(function (data) {
                _this.trigger_avail_damp = data;
                _this.alertSetupBackup.trigger_avail_damp = angular.copy(_this.trigger_avail_damp);
                _this.downtimeDuration = data[0].evalTimeSetting;
                _this.$log.debug('this.trigger_avail_damp', _this.trigger_avail_damp);
            }, function (error) {
                return _this.HawkularErrorManager.errorHandler(error, 'Error fetching availability trigger dampening.');
            });
            this.metricId = $routeParams.resourceId;
            this.$log.debug('this.metricId', this.metricId);
        }
        MetricsAlertSetupController.prototype.changeResponseTimeUnits = function () {
            this.trigger_thres_damp[0].evalTimeSetting = this.responseDuration * this.responseUnit;
            this.alertSettingTouch();
        };
        MetricsAlertSetupController.prototype.changeDowntimeTimeUnits = function () {
            this.trigger_avail_damp[0].evalTimeSetting = this.downtimeDuration * this.downtimeUnit;
            this.alertSettingTouch();
        };
        MetricsAlertSetupController.prototype.cancel = function () {
            this.$modalInstance.dismiss('cancel');
        };
        MetricsAlertSetupController.prototype.save = function () {
            var _this = this;
            this.$log.debug('Saving Alert Settings');
            // Clear alerts notifications on save (discard previous success/error list)
            this.$rootScope.hkNotifications.alerts = [];
            // Error notification done with callback function on error
            var errorCallback = function (error, msg) {
                _this.$rootScope.hkNotifications.alerts.push({
                    type: 'error',
                    message: msg
                });
            };
            this.saveProgress = true;
            var isError = false;
            // Check if email action exists
            this.HawkularAlertsManager.addEmailAction(this.trigger_thres.actions.email[0]).then(function () {
                if (!angular.equals(_this.alertSetupBackup.trigger_thres, _this.trigger_thres)) {
                    return _this.HawkularAlertsManager.updateTrigger(_this.trigger_thres.id, _this.trigger_thres);
                }
            }, function (error) {
                return _this.HawkularErrorManager.errorHandler(error, 'Error saving email action.', errorCallback);
            }).then(function () {
                _this.trigger_avail.actions = _this.trigger_thres.actions;
                if (!angular.equals(_this.alertSetupBackup.trigger_avail, _this.trigger_avail)) {
                    return _this.HawkularAlertsManager.updateTrigger(_this.trigger_avail.id, _this.trigger_avail);
                }
            }, function (error) {
                return _this.HawkularErrorManager.errorHandler(error, 'Error updating threshold trigger.', errorCallback);
            }).then(function () {
                _this.changeResponseTimeUnits();
                if (!_this.thresDampDurationEnabled) {
                    _this.trigger_thres_damp[0].evalTimeSetting = 0;
                }
                if (!angular.equals(_this.alertSetupBackup.trigger_thres_damp[0], _this.trigger_thres_damp[0])) {
                    return _this.HawkularAlertsManager.updateDampening(_this.trigger_thres.id, _this.trigger_thres_damp[0].dampeningId, _this.trigger_thres_damp[0]);
                }
            }, function (error) {
                return _this.HawkularErrorManager.errorHandler(error, 'Error updating availability trigger.', errorCallback);
            }).then(function () {
                if (!angular.equals(_this.alertSetupBackup.trigger_avail_damp[0], _this.trigger_avail_damp[0])) {
                    _this.HawkularAlertsManager.updateDampening(_this.trigger_avail.id, _this.trigger_avail_damp[0].dampeningId, _this.trigger_avail_damp[0]);
                }
            }, function (error) {
                return _this.HawkularErrorManager.errorHandler(error, 'Error updating threshold trigger dampening.', errorCallback);
            }).then(function () {
                if (!angular.equals(_this.alertSetupBackup.trigger_thres_cond[0], _this.trigger_thres_cond[0])) {
                    return _this.HawkularAlertsManager.updateCondition(_this.trigger_thres.id, _this.trigger_thres_cond[0].conditionId, _this.trigger_thres_cond[0]);
                }
            }, function (error) {
                return _this.HawkularErrorManager.errorHandler(error, 'Error updating availability dampening.', errorCallback);
            }).then(angular.noop, function (error) {
                isError = true;
                return _this.HawkularErrorManager.errorHandler(error, 'Error updating availability condition.', errorCallback);
            }).finally(function () {
                _this.saveProgress = false;
                if (!isError) {
                    // notify success
                    _this.$rootScope.hkNotifications.alerts.push({
                        type: 'success',
                        message: 'Changes saved successfully.'
                    });
                }
                _this.cancel();
            });
        };
        MetricsAlertSetupController.prototype.alertSettingTouch = function () {
            if (!angular.equals(!!this.alertSetupBackup.thresDampDurationEnabled, !!this.thresDampDurationEnabled) || !angular.equals(this.alertSetupBackup.responseDuration, this.responseDuration) || !angular.equals(this.alertSetupBackup.trigger_thres, this.trigger_thres) || !angular.equals(this.alertSetupBackup.trigger_avail, this.trigger_avail) || !angular.equals(this.alertSetupBackup.trigger_thres_damp[0], this.trigger_thres_damp[0]) || !angular.equals(this.alertSetupBackup.trigger_avail_damp[0], this.trigger_avail_damp[0]) || !angular.equals(this.alertSetupBackup.trigger_thres_cond[0], this.trigger_thres_cond[0])) {
                this.isSettingChange = true;
            }
            else {
                this.isSettingChange = false;
            }
        };
        MetricsAlertSetupController.$inject = ['$scope', 'HawkularAlert', 'HawkularAlertsManager', 'HawkularErrorManager', '$log', '$q', '$rootScope', '$routeParams', '$modalInstance'];
        return MetricsAlertSetupController;
    })();
    HawkularMetrics.MetricsAlertSetupController = MetricsAlertSetupController;
    HawkularMetrics._module.controller('MetricsAlertSetupController', MetricsAlertSetupController);
    var HkClearNotifications = (function () {
        function HkClearNotifications() {
            this.scope = {
                hkClearNotifications: '='
            };
            this.link = function (scope, element, attrs) {
                angular.element('html').on('click', function () {
                    if (scope.hkClearNotifications && scope.hkClearNotifications.length && scope.hkClearNotifications.length > 0) {
                        scope.$apply(function () {
                            scope.hkClearNotifications = [];
                        });
                    }
                });
            };
        }
        HkClearNotifications.Factory = function () {
            var directive = function () {
                return new HkClearNotifications();
            };
            directive['$inject'] = [];
            return directive;
        };
        return HkClearNotifications;
    })();
    HawkularMetrics.HkClearNotifications = HkClearNotifications;
    HawkularMetrics._module.directive('hkClearNotifications', HkClearNotifications.Factory());
})(HawkularMetrics || (HawkularMetrics = {}));

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// <reference path="metricsPlugin.ts"/>
/// <reference path="alertsManager.ts"/>
/// <reference path="errorManager.ts"/>
var HawkularMetrics;
(function (HawkularMetrics) {
    var AppServerDetailsController = (function () {
        function AppServerDetailsController($location, $scope, $rootScope, $interval, $log, $filter, $modal, HawkularInventory, HawkularMetric, HawkularAlert, HawkularAlertsManager, HawkularErrorManager, $q, md5, startTimeStamp, endTimeStamp, resourceUrl) {
            this.$location = $location;
            this.$scope = $scope;
            this.$rootScope = $rootScope;
            this.$interval = $interval;
            this.$log = $log;
            this.$filter = $filter;
            this.$modal = $modal;
            this.HawkularInventory = HawkularInventory;
            this.HawkularMetric = HawkularMetric;
            this.HawkularAlert = HawkularAlert;
            this.HawkularAlertsManager = HawkularAlertsManager;
            this.HawkularErrorManager = HawkularErrorManager;
            this.$q = $q;
            this.md5 = md5;
            this.startTimeStamp = startTimeStamp;
            this.endTimeStamp = endTimeStamp;
            this.resourceUrl = resourceUrl;
            this.httpUriPart = 'http://';
            this.addProgress = false;
            this.resPerPage = 5;
            this.resCurPage = 0;
            $scope.vm = this;
            this.startTimeStamp = +moment().subtract(1, 'hours');
            this.endTimeStamp = +moment();
            this.resourceUrl = this.httpUriPart;
            this.getResourceList();
            this.autoRefresh(20);
        }
        AppServerDetailsController.prototype.cancelAutoRefresh = function () {
            this.$interval.cancel(this.autoRefreshPromise);
            toastr.info('Canceling Auto Refresh');
        };
        AppServerDetailsController.prototype.autoRefresh = function (intervalInSeconds) {
            var _this = this;
            this.autoRefreshPromise = this.$interval(function () {
                _this.getResourceList();
            }, intervalInSeconds * 1000);
            this.$scope.$on('$destroy', function () {
                _this.$interval.cancel(_this.autoRefreshPromise);
            });
        };
        AppServerDetailsController.prototype.getResourceList = function () {
            this.resourceList = [
                {
                    tenant: 'test',
                    environment: 'test',
                    feed: null,
                    id: 'f5087d5d26aeff90cc92c738a10d8bba',
                    properties: { name: 'Eavy Machine', url: 'eavy.corp.redhat.com' },
                    type: { tenant: 'test', id: 'EAP', version: '1.0', properties: {} },
                    state: 'Running',
                    alerts: ['SLOW'],
                    tags: ['Production']
                },
                {
                    tenant: 'test',
                    environment: 'test',
                    feed: null,
                    id: '5c4785a7a304d32e5f404242666895f5',
                    properties: { name: 'Tori Machine', url: 'tori.corp.redhat.com' },
                    type: { tenant: 'test', id: 'Tomcat', version: '1.0', properties: {} },
                    state: 'Running',
                    alerts: [],
                    tags: ['Development']
                },
                {
                    tenant: 'test',
                    environment: 'test',
                    feed: null,
                    id: '21193e7941642baa1285cd7edd8af62e',
                    properties: { name: 'Wiko Machine', url: 'wiko.corp.redhat.com' },
                    type: { tenant: 'test', id: 'Wildfly', version: '1.0', properties: {} },
                    state: 'Failed',
                    alerts: ['DOWN'],
                    tags: []
                },
                {
                    tenant: 'test',
                    environment: 'test',
                    feed: null,
                    id: '20a0e9f5d777a16ad40928dd3ba1bef9',
                    properties: { name: 'Tomy Machine', url: 'tomy.corp.redhat.com' },
                    type: { tenant: 'test', id: 'Tomcat', version: '1.0', properties: {} },
                    state: 'Stopped',
                    alerts: [],
                    tags: ['QE']
                }
            ];
        };
        /// this is for minification purposes
        AppServerDetailsController.$inject = ['$location', '$scope', '$rootScope', '$interval', '$log', '$filter', '$modal', 'HawkularInventory', 'HawkularMetric', 'HawkularAlert', 'HawkularAlertsManager', 'HawkularErrorManager', '$q', 'md5'];
        return AppServerDetailsController;
    })();
    HawkularMetrics.AppServerDetailsController = AppServerDetailsController;
    HawkularMetrics._module.controller('HawkularMetrics.AppServerDetailsController', AppServerDetailsController);
})(HawkularMetrics || (HawkularMetrics = {}));

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// <reference path="metricsPlugin.ts"/>
/// <reference path="alertsManager.ts"/>
/// <reference path="errorManager.ts"/>
var HawkularMetrics;
(function (HawkularMetrics) {
    var AppServerListController = (function () {
        function AppServerListController($location, $scope, $rootScope, $interval, $log, $filter, $modal, HawkularInventory, HawkularMetric, HawkularAlert, HawkularAlertsManager, HawkularErrorManager, $q, md5, HkHeaderParser, startTimeStamp, endTimeStamp, resourceUrl) {
            var _this = this;
            this.$location = $location;
            this.$scope = $scope;
            this.$rootScope = $rootScope;
            this.$interval = $interval;
            this.$log = $log;
            this.$filter = $filter;
            this.$modal = $modal;
            this.HawkularInventory = HawkularInventory;
            this.HawkularMetric = HawkularMetric;
            this.HawkularAlert = HawkularAlert;
            this.HawkularAlertsManager = HawkularAlertsManager;
            this.HawkularErrorManager = HawkularErrorManager;
            this.$q = $q;
            this.md5 = md5;
            this.HkHeaderParser = HkHeaderParser;
            this.startTimeStamp = startTimeStamp;
            this.endTimeStamp = endTimeStamp;
            this.resourceUrl = resourceUrl;
            this.httpUriPart = 'http://';
            this.addProgress = false;
            this.resPerPage = 10;
            this.resCurPage = 0;
            this.headerLinks = {};
            $scope.vm = this;
            if ($rootScope.currentPersona) {
                this.getResourceList(this.$rootScope.currentPersona.id);
            }
            else {
                // currentPersona hasn't been injected to the rootScope yet, wait for it..
                $rootScope.$watch('currentPersona', function (currentPersona) { return currentPersona && _this.getResourceList(currentPersona.id); });
            }
            this.autoRefresh(20);
        }
        AppServerListController.prototype.setPage = function (page) {
            this.resCurPage = page;
            this.getResourceList();
        };
        AppServerListController.prototype.cancelAutoRefresh = function () {
            this.$interval.cancel(this.autoRefreshPromise);
            toastr.info('Canceling Auto Refresh');
        };
        AppServerListController.prototype.autoRefresh = function (intervalInSeconds) {
            var _this = this;
            this.autoRefreshPromise = this.$interval(function () {
                _this.getResourceList();
            }, intervalInSeconds * 1000);
            this.$scope.$on('$destroy', function () {
                _this.$interval.cancel(_this.autoRefreshPromise);
            });
        };
        AppServerListController.prototype.getResourceList = function (currentTenantId) {
            var _this = this;
            var tenantId = currentTenantId || this.$rootScope.currentPersona.id;
            this.HawkularInventory.ResourceOfType.query({ tenantId: tenantId, resourceTypeId: 'WildFly Server', per_page: this.resPerPage, page: this.resCurPage }, function (aResourceList, getResponseHeaders) {
                _this.headerLinks = _this.HkHeaderParser.parse(getResponseHeaders());
                var promises = [];
                angular.forEach(aResourceList, function (res, idx) {
                    promises.push(this.HawkularMetric.AvailabilityMetricData.query({
                        tenantId: tenantId,
                        availabilityId: 'AI~R~' + res.id + '~AT~App Server',
                        distinct: true
                    }, function (resource) {
                        var latestData = resource[resource.length - 1];
                        if (latestData) {
                            res['state'] = latestData['value'];
                            res['updateTimestamp'] = latestData['timestamp'];
                        }
                    }).$promise);
                    this.lastUpdateTimestamp = new Date();
                }, _this);
                _this.$q.all(promises).then(function (result) {
                    _this.resourceList = aResourceList;
                });
            }, function () {
                if (!_this.resourceList) {
                    _this.resourceList = [];
                    _this.resourceList.$resolved = true;
                    _this['lastUpdateTimestamp'] = new Date();
                }
            });
        };
        /// this is for minification purposes
        AppServerListController.$inject = ['$location', '$scope', '$rootScope', '$interval', '$log', '$filter', '$modal', 'HawkularInventory', 'HawkularMetric', 'HawkularAlert', 'HawkularAlertsManager', 'HawkularErrorManager', '$q', 'md5', 'HkHeaderParser'];
        return AppServerListController;
    })();
    HawkularMetrics.AppServerListController = AppServerListController;
    HawkularMetrics._module.controller('HawkularMetrics.AppServerListController', AppServerListController);
})(HawkularMetrics || (HawkularMetrics = {}));

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// <reference path="metricsPlugin.ts"/>
/// <reference path="../../includes.ts"/>
/// <reference path="errorManager.ts"/>
var HawkularMetrics;
(function (HawkularMetrics) {
})(HawkularMetrics || (HawkularMetrics = {}));

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// <reference path="metricsTypes.ts"/>
/// <reference path="metricsPlugin.ts"/>
/// <reference path="../../includes.ts"/>
var HawkularMetrics;
(function (HawkularMetrics) {
    var MetricsAvailabilityController = (function () {
        function MetricsAvailabilityController($scope, $rootScope, $interval, $log, HawkularMetric, HawkularAlert, $routeParams, alertList, startTimeStamp, endTimeStamp) {
            var _this = this;
            this.$scope = $scope;
            this.$rootScope = $rootScope;
            this.$interval = $interval;
            this.$log = $log;
            this.HawkularMetric = HawkularMetric;
            this.HawkularAlert = HawkularAlert;
            this.$routeParams = $routeParams;
            this.alertList = alertList;
            this.startTimeStamp = startTimeStamp;
            this.endTimeStamp = endTimeStamp;
            this.availabilityDataPoints = [];
            this.uptimeRatio = 0;
            this.downtimeDuration = 0;
            this.downtimeCount = 0;
            this.empty = true;
            $scope.vm = this;
            this.math = window.Math;
            this.startTimeStamp = +moment().subtract(1, 'hours');
            this.endTimeStamp = +moment();
            this.resourceId = $scope.hkParams.resourceId;
            var waitForResourceId = function () { return $scope.$watch('hkParams.resourceId', function (resourceId) {
                /// made a selection from url switcher
                if (resourceId) {
                    _this.resourceId = resourceId;
                    _this.refreshAvailPageNow(_this.getResourceId());
                }
            }); };
            if ($rootScope.currentPersona) {
                waitForResourceId();
            }
            else {
                $rootScope.$watch('currentPersona', function (currentPersona) {
                    if (currentPersona) {
                        waitForResourceId();
                    }
                });
            }
            this.autoRefreshAvailability(20);
            $scope.$on('RefreshAvailabilityChart', function (event) {
                _this.refreshAvailPageNow(_this.getResourceId());
            });
        }
        MetricsAvailabilityController.prototype.refreshAvailPageNow = function (resourceId, startTime) {
            this.$scope.hkEndTimestamp = +moment();
            var adjStartTimeStamp = +moment().subtract(this.$scope.hkParams.timeOffset, 'milliseconds');
            this.endTimeStamp = this.$scope.hkEndTimestamp;
            if (resourceId) {
                console.log('*** Updating Availability Page');
                this.refreshSummaryAvailabilityData(resourceId, startTime ? startTime : adjStartTimeStamp, this.endTimeStamp);
                this.refreshAvailChartData(resourceId, startTime ? startTime : adjStartTimeStamp, this.endTimeStamp);
                this.refreshAlerts(resourceId, startTime ? startTime : adjStartTimeStamp, this.endTimeStamp);
            }
        };
        MetricsAvailabilityController.prototype.cancelAutoRefresh = function () {
            this.$interval.cancel(this.autoRefreshPromise);
            toastr.info('Canceling Auto Refresh Availability');
        };
        MetricsAvailabilityController.prototype.autoRefreshAvailability = function (intervalInSeconds) {
            var _this = this;
            this.endTimeStamp = this.$scope.hkEndTimestamp;
            this.startTimeStamp = this.$scope.hkStartTimestamp;
            this.autoRefreshPromise = this.$interval(function () {
                console.info('Autorefresh Availabilty for: ' + _this.getResourceId());
                _this.$scope.hkEndTimestamp = +moment();
                _this.endTimeStamp = _this.$scope.hkEndTimestamp;
                _this.$scope.hkStartTimestamp = +moment().subtract(_this.$scope.hkParams.timeOffset, 'milliseconds');
                _this.startTimeStamp = _this.$scope.hkStartTimestamp;
                _this.refreshAvailPageNow(_this.getResourceId());
            }, intervalInSeconds * 1000);
            this.$scope.$on('$destroy', function () {
                _this.$interval.cancel(_this.autoRefreshPromise);
            });
        };
        MetricsAvailabilityController.prototype.noDataFoundForId = function (id) {
            this.$log.warn('No Data found for id: ' + id);
            ///toastr.warning('No Data found for id: ' + id);
        };
        MetricsAvailabilityController.prototype.refreshSummaryAvailabilityData = function (metricId, startTime, endTime) {
            var _this = this;
            if (metricId) {
                this.HawkularMetric.AvailabilityMetricData.query({
                    tenantId: this.$rootScope.currentPersona.id,
                    availabilityId: metricId,
                    start: startTime,
                    end: endTime,
                    buckets: 1
                }).$promise.then(function (availResponse) {
                    console.info("Avail Summary:");
                    console.dir(availResponse);
                    if (availResponse && !_.last(availResponse).empty) {
                        _this.uptimeRatio = _.last(availResponse).uptimeRatio;
                        _this.downtimeDuration = Math.round(_.last(availResponse).downtimeDuration);
                        _this.lastDowntime = new Date(_.last(availResponse).lastDowntime);
                        _this.downtimeCount = _.last(availResponse).downtimeCount;
                        _this.empty = _.last(availResponse).empty;
                    }
                }, function (error) {
                    _this.$log.error('Error Loading Avail Summary data');
                    toastr.error('Error Loading Avail Summary Data: ' + error);
                });
            }
        };
        MetricsAvailabilityController.prototype.getResourceId = function () {
            return this.resourceId;
        };
        MetricsAvailabilityController.prototype.refreshAvailChartData = function (metricId, startTime, endTime) {
            var _this = this;
            if (metricId) {
                this.HawkularMetric.AvailabilityMetricData.query({
                    tenantId: this.$rootScope.currentPersona.id,
                    availabilityId: metricId,
                    start: startTime,
                    end: endTime,
                    distinct: true
                }).$promise.then(function (response) {
                    console.log("Availability Data: ");
                    console.dir(response);
                    _this.availabilityDataPoints = response;
                }, function (error) {
                    _this.$log.error('Error Loading Avail data');
                    toastr.error('Error Loading Avail Data: ' + error);
                });
            }
        };
        MetricsAvailabilityController.prototype.refreshAlerts = function (metricId, startTime, endTime) {
            var _this = this;
            var alertType = this.$routeParams.resourceId + '_trigger_avail';
            this.HawkularAlert.Alert.query({}, function (anAlertList) {
                var filteredAlerts = [];
                for (var i = 0; i < anAlertList.length; i++) {
                    if ((anAlertList[i].triggerId === alertType) && (anAlertList[i].ctime >= (+moment() - _this.$scope.hkParams.timeOffset))) {
                        // cleaning a lot of data, we dont need at the template
                        anAlertList[i].evalSets.splice(1);
                        filteredAlerts.push(anAlertList[i]);
                    }
                }
                _this.alertList = filteredAlerts.reverse();
            }, this);
        };
        /// for minification only
        MetricsAvailabilityController.$inject = ['$scope', '$rootScope', '$interval', '$log', 'HawkularMetric', 'HawkularAlert', '$routeParams'];
        return MetricsAvailabilityController;
    })();
    HawkularMetrics.MetricsAvailabilityController = MetricsAvailabilityController;
    HawkularMetrics._module.controller('MetricsAvailabilityController', MetricsAvailabilityController);
})(HawkularMetrics || (HawkularMetrics = {}));

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// <reference path="metricsPlugin.ts"/>
/// <reference path="../../includes.ts"/>
var HawkularMetrics;
(function (HawkularMetrics) {
    var QuickAlertController = (function () {
        function QuickAlertController($scope, HawkularAlert, $log, $q) {
            var _this = this;
            this.$scope = $scope;
            this.HawkularAlert = HawkularAlert;
            this.$log = $log;
            this.$q = $q;
            this.PROMISE_BREAK = 'magicValue1234';
            this.$scope.showQuickAlert = false;
            this.$scope.quickTrigger = {
                operator: 'LT',
                threshold: 0
            };
            this.$scope.$watch('hkParams.resourceId', function (resourceId) {
                /// made a selection from url switcher
                if (resourceId) {
                    _this.metricId = resourceId;
                }
            });
            this.allActions();
        }
        QuickAlertController.prototype.toggleQuickAlert = function () {
            this.$scope.showQuickAlert = !this.$scope.showQuickAlert;
        };
        QuickAlertController.prototype.allActions = function () {
            var _this = this;
            this.$scope.actions = [];
            this.HawkularAlert.Action.query(function (result) {
                _this.$scope.actions = result;
            }, function (error) {
                _this.errorToastr(error, 'Error loading Alerts Notifiers:');
            });
        };
        QuickAlertController.prototype.errorToastr = function (error, errorMsg) {
            var errorMsgComplete;
            if (error.data && error.data.errorMsg) {
                errorMsgComplete = error.data.errorMsg;
            }
            else {
                errorMsgComplete = errorMsg + ' ' + error;
            }
            this.$log.error(errorMsgComplete);
            toastr.error(errorMsgComplete);
        };
        QuickAlertController.prototype.errorHandler = function (error, msg) {
            if (error !== this.PROMISE_BREAK) {
                this.errorToastr(error, msg);
            }
            return this.$q.reject(this.PROMISE_BREAK);
        };
        QuickAlertController.prototype.saveQuickAlert = function () {
            var _this = this;
            //if (globalMetricId !== '.status.duration' && globalMetricId !== '.status.code') {
            if (this.metricId !== '.status.duration' && this.metricId !== '.status.code') {
                var newTrigger = {};
                newTrigger.name = this.metricId + 'ResponseTime' + '-' + this.$scope.quickTrigger.operator + '-' + this.$scope.quickTrigger.threshold;
                newTrigger.description = 'Created on ' + new Date();
                newTrigger.firingMatch = 'ALL';
                newTrigger.safetyMatch = 'ALL';
                newTrigger.enabled = true;
                newTrigger.safetyEnabled = false;
                newTrigger.actions = this.$scope.quickTrigger.actions;
                var newDampening = {
                    triggerId: '',
                    type: 'RELAXED_COUNT',
                    evalTrueSetting: 1,
                    evalTotalSetting: 1,
                    evalTimeSetting: 0
                };
                this.HawkularAlert.Trigger.save(newTrigger).$promise.then(
                // Success Trigger save
                function (trigger) {
                    _this.$log.debug('Success Trigger save');
                    newDampening.triggerId = trigger.id;
                    return _this.HawkularAlert.Dampening.save({ triggerId: newDampening.triggerId }, newDampening).$promise;
                }, 
                // Error Trigger save
                function (error) {
                    return _this.errorHandler(error, 'Error saving Trigger');
                }).then(
                // Success Dampening save
                function (dampening) {
                    _this.$log.debug('Success Dampening save', dampening);
                    var newThresholdCondition = {
                        triggerId: dampening.triggerId,
                        type: 'THRESHOLD',
                        dataId: _this.metricId,
                        operator: _this.$scope.quickTrigger.operator,
                        threshold: _this.$scope.quickTrigger.threshold
                    };
                    return _this.HawkularAlert.Condition.save({ triggerId: newThresholdCondition.triggerId }, newThresholdCondition).$promise;
                }, 
                // Error Dampening save
                function (errorDampening) {
                    return _this.errorHandler(errorDampening, 'Error saving Trigger');
                }).then(
                // Success ThresholdCondition save
                function () {
                    _this.$log.debug('Success ThresholdCondition save');
                    _this.$log.debug('Alert Created!');
                    toastr.success('Alert Created!');
                    _this.toggleQuickAlert();
                    return _this.HawkularAlert.Alert.reload().$promise;
                }, 
                // Error ThresholdCondition save
                function (errorCondition) {
                    return _this.errorHandler(errorCondition, 'Error saving Trigger Condition');
                }).then(angular.noop, 
                // Error Reload
                function (errorReload) {
                    return _this.errorHandler(errorReload, 'Error reloading Alerts');
                }).catch(function (error) {
                    _this.errorHandler(error, 'Error:');
                });
            }
            else {
                this.$log.debug('No metric selected');
                toastr.warning('No metric selected');
            }
        };
        QuickAlertController.$inject = ['$scope', 'HawkularAlert', '$log', '$q'];
        return QuickAlertController;
    })();
    HawkularMetrics.QuickAlertController = QuickAlertController;
    HawkularMetrics._module.controller('QuickAlertController', QuickAlertController);
})(HawkularMetrics || (HawkularMetrics = {}));

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// <reference path="metricsTypes.ts"/>
/// <reference path="metricsPlugin.ts"/>
/// <reference path="../../includes.ts"/>
var HawkularMetrics;
(function (HawkularMetrics) {
    /**
     * @ngdoc controller
     * @name ChartController
     * @description This controller is responsible for handling activity related to the Chart tab.
     * @param $scope
     * @param $rootScope for publishing $broadcast events only
     * @param $interval
     * @param $log
     * @param HawkularMetric
     * @param HawkularAlert
     * @param $routeParams
     */
    var MetricsViewController = (function () {
        function MetricsViewController($scope, $rootScope, $interval, $log, HawkularMetric, HawkularAlert, $routeParams, alertList, startTimeStamp, endTimeStamp) {
            var _this = this;
            this.$scope = $scope;
            this.$rootScope = $rootScope;
            this.$interval = $interval;
            this.$log = $log;
            this.HawkularMetric = HawkularMetric;
            this.HawkularAlert = HawkularAlert;
            this.$routeParams = $routeParams;
            this.alertList = alertList;
            this.startTimeStamp = startTimeStamp;
            this.endTimeStamp = endTimeStamp;
            this.bucketedDataPoints = [];
            this.contextDataPoints = [];
            this.threshold = 5000; // default to 5 seconds some high number
            this.median = 0;
            this.percentile95th = 0;
            this.average = 0;
            $scope.vm = this;
            this.math = window.Math;
            this.startTimeStamp = moment().subtract(1, 'hours').valueOf();
            this.endTimeStamp = +moment();
            this.resourceId = $scope.hkParams.resourceId;
            $scope.$on('RefreshChart', function (event) {
                _this.refreshChartDataNow(_this.getMetricId());
            });
            var waitForResourceId = function () { return $scope.$watch('hkParams.resourceId', function (resourceId) {
                /// made a selection from url switcher
                if (resourceId) {
                    _this.resourceId = resourceId;
                    _this.refreshChartDataNow(_this.getMetricId());
                }
            }); };
            if ($rootScope.currentPersona) {
                waitForResourceId();
            }
            else {
                $rootScope.$watch('currentPersona', function (currentPersona) {
                    if (currentPersona) {
                        waitForResourceId();
                    }
                });
            }
            this.autoRefresh(20);
        }
        MetricsViewController.prototype.cancelAutoRefresh = function () {
            this.$interval.cancel(this.autoRefreshPromise);
            toastr.info('Canceling Auto Refresh');
        };
        MetricsViewController.prototype.autoRefresh = function (intervalInSeconds) {
            var _this = this;
            this.autoRefreshPromise = this.$interval(function () {
                _this.$scope.hkEndTimestamp = +moment();
                _this.endTimeStamp = _this.$scope.hkEndTimestamp;
                _this.$scope.hkStartTimestamp = moment().subtract(_this.$scope.hkParams.timeOffset, 'milliseconds').valueOf();
                _this.startTimeStamp = _this.$scope.hkStartTimestamp;
                _this.refreshSummaryData(_this.getMetricId());
                _this.refreshHistoricalChartDataForTimestamp(_this.getMetricId());
                _this.retrieveThreshold();
            }, intervalInSeconds * 1000);
            this.$scope.$on('$destroy', function () {
                _this.$interval.cancel(_this.autoRefreshPromise);
            });
        };
        MetricsViewController.prototype.noDataFoundForId = function (resourceId) {
            this.$log.warn('No Data found for id: ' + resourceId);
            ///toastr.warning('No Data found for id: ' + id);
        };
        MetricsViewController.prototype.refreshChartDataNow = function (metricId, startTime) {
            this.$scope.hkEndTimestamp = +moment();
            var adjStartTimeStamp = moment().subtract(this.$scope.hkParams.timeOffset, 'milliseconds').valueOf();
            this.endTimeStamp = this.$scope.hkEndTimestamp;
            this.refreshSummaryData(metricId, startTime ? startTime : adjStartTimeStamp, this.endTimeStamp);
            this.refreshHistoricalChartDataForTimestamp(metricId, !startTime ? adjStartTimeStamp : startTime, this.endTimeStamp);
            this.refreshAlerts(metricId, startTime ? startTime : adjStartTimeStamp, this.endTimeStamp);
            this.retrieveThreshold();
        };
        MetricsViewController.prototype.getMetricId = function () {
            return this.resourceId + '.status.duration';
        };
        MetricsViewController.prototype.retrieveThreshold = function () {
            var _this = this;
            this.HawkularAlert.Condition.query({ triggerId: this.$routeParams.resourceId + '_trigger_thres' }).$promise.then(function (response) {
                if (response[0]) {
                    _this.threshold = response[0].threshold;
                }
            }, function (error) {
                _this.$log.error('Error Loading Threshold data');
                toastr.error('Error Loading Threshold Data: ' + error);
            });
        };
        MetricsViewController.prototype.refreshAlerts = function (metricId, startTime, endTime) {
            var _this = this;
            var alertType = this.$routeParams.resourceId + '_trigger_thres';
            this.HawkularAlert.Alert.query({}, function (anAlertList) {
                var filteredAlerts = [];
                for (var i = 0; i < anAlertList.length; i++) {
                    if ((anAlertList[i].triggerId === alertType) && (anAlertList[i].ctime >= (+moment() - _this.$scope.hkParams.timeOffset))) {
                        // cleaning a lot of data, we dont need at the template
                        anAlertList[i].evalSets.splice(1);
                        filteredAlerts.push(anAlertList[i]);
                    }
                }
                _this.alertList = filteredAlerts.reverse();
            }, this);
        };
        MetricsViewController.prototype.refreshSummaryData = function (metricId, startTime, endTime) {
            var _this = this;
            var dataPoints;
            // calling refreshChartData without params use the model values
            if (!endTime) {
                endTime = this.endTimeStamp;
            }
            if (!startTime) {
                startTime = this.startTimeStamp;
            }
            if (metricId) {
                this.HawkularMetric.NumericMetricData.queryMetrics({
                    tenantId: this.$rootScope.currentPersona.id,
                    numericId: metricId,
                    start: startTime,
                    end: endTime,
                    buckets: 1
                }).$promise.then(function (response) {
                    dataPoints = _this.formatBucketedChartOutput(response);
                    console.dir(dataPoints);
                    _this.median = Math.round(_.last(dataPoints).median);
                    _this.percentile95th = Math.round(_.last(dataPoints).percentile95th);
                    _this.average = Math.round(_.last(dataPoints).avg);
                }, function (error) {
                    _this.$log.error('Error Loading Chart data');
                    toastr.error('Error Loading Chart Data: ' + error);
                });
            }
        };
        MetricsViewController.prototype.refreshHistoricalChartDataForTimestamp = function (metricId, startTime, endTime) {
            var _this = this;
            // calling refreshChartData without params use the model values
            if (!endTime) {
                endTime = this.endTimeStamp;
            }
            if (!startTime) {
                startTime = this.startTimeStamp;
            }
            if (metricId) {
                this.HawkularMetric.NumericMetricData.queryMetrics({
                    tenantId: this.$rootScope.currentPersona.id,
                    numericId: metricId,
                    start: startTime,
                    end: endTime,
                    buckets: 120
                }).$promise.then(function (response) {
                    // we want to isolate the response from the data we are feeding to the chart
                    _this.bucketedDataPoints = _this.formatBucketedChartOutput(response);
                    console.dir(_this.bucketedDataPoints);
                    if (_this.bucketedDataPoints.length) {
                        // this is basically the DTO for the chart
                        _this.chartData = {
                            id: metricId,
                            startTimeStamp: startTime,
                            endTimeStamp: endTime,
                            dataPoints: _this.bucketedDataPoints,
                            contextDataPoints: _this.contextDataPoints,
                            annotationDataPoints: []
                        };
                    }
                    else {
                        _this.noDataFoundForId(metricId);
                    }
                }, function (error) {
                    _this.$log.error('Error Loading Chart data');
                    toastr.error('Error Loading Chart Data: ' + error);
                });
            }
        };
        MetricsViewController.prototype.formatBucketedChartOutput = function (response) {
            //  The schema is different for bucketed output
            return _.map(response, function (point) {
                return {
                    timestamp: point.start,
                    date: new Date(point.start),
                    value: !angular.isNumber(point.value) ? 0 : point.value,
                    avg: (point.empty) ? 0 : point.avg,
                    min: !angular.isNumber(point.min) ? 0 : point.min,
                    max: !angular.isNumber(point.max) ? 0 : point.max,
                    percentile95th: !angular.isNumber(point.percentile95th) ? 0 : point.percentile95th,
                    median: !angular.isNumber(point.median) ? 0 : point.median,
                    empty: point.empty
                };
            });
        };
        /// for minification only
        MetricsViewController.$inject = ['$scope', '$rootScope', '$interval', '$log', 'HawkularMetric', 'HawkularAlert', '$routeParams'];
        return MetricsViewController;
    })();
    HawkularMetrics.MetricsViewController = MetricsViewController;
    HawkularMetrics._module.controller('MetricsViewController', MetricsViewController);
})(HawkularMetrics || (HawkularMetrics = {}));

angular.module("hawkular-console-templates", []).run(["$templateCache", function($templateCache) {$templateCache.put("index.html","<!DOCTYPE html>\n<html>\n\n<head>\n    <title>hawkular-accounts</title>\n    <base href=\'/\'>\n    <meta charset=\"UTF8\">\n\n    <link rel=\"stylesheet\" href=\"libs/patternfly/dist/css/patternfly.css\" />\n    <link rel=\"stylesheet\" href=\"../../dist/hawkular-ui-components-accounts.css\"/>\n\n    <!-- bower:css -->\n    <!-- endbower -->\n\n    <!-- ES6/ES6 shim -->\n    <!--[if IE 8]>\n    <script src=\"libs/es5-dom-shim/__COMIPLE/a.ie8.js\"></script>\n    <![endif]-->\n    <script src=\"libs/es5-dom-shim/__COMPILE/a.js\"></script>\n\n    <!-- bower:js -->\n    <!-- endbower -->\n\n    <script src=\"libs/patternfly/dist/js/patternfly.js\"></script>\n    <script src=\"libs/patternfly/components/jquery/jquery.js\"></script>\n    <script src=\"libs/patternfly/components/bootstrap/dist/js/bootstrap.js\"></script>\n\n</head>\n\n<body>\n<div data-idle-countdown=\"countdown\" data-ng-init=\"countdown=30\" id=\"idle\">\n    <strong>You\'ll be logged out in {{countdown}} second(s).</strong>.\n</div>\n\n<nav class=\"navbar navbar-default navbar-pf\" role=\"navigation\">\n    <ul class=\"nav navbar-nav navbar-primary\" hawtio-main-nav></ul>\n    <ul class=\"nav navbar-nav\" hawtio-sub-tabs></ul>\n    <ul class=\"nav navbar-nav navbar-utility pull-right\">\n        <li class=\"dropdown\" data-ng-controller=\"HawkularAccounts.PersonaController\">\n            <a href=\"#\" class=\"dropdown-toggle\" data-toggle=\"dropdown\">\n                <span class=\"pficon pficon-user\"></span>\n                {{currentPersona.name}} <b class=\"caret\"></b>\n            </a>\n            <ul class=\"dropdown-menu\" id=\"personaSwitcher\">\n                <li data-ng-repeat=\"persona in personas\">\n                    <a href=\"#\" data-ng-click=\"switchPersona(persona)\">{{persona.name}}</a>\n                </li>\n                <li class=\"divider\" data-ng-show=\"personas.length\"></li>\n                <li>\n                    <a id=\"logout\" href=\"#\" data-ng-click=\"userDetails.logout()\">Log Out</a>\n                </li>\n            </ul>\n        </li>\n    </ul>\n</nav>\n\n<div id=\"main\" class=\"container-fluid ng-cloak\" ng-controller=\"HawtioNav.ViewController\">\n    <div ng-include src=\"viewPartial\"></div>\n</div>\n\n<!-- add any scripts under dist/ here -->\n<script src=\"dist/hawkular-ui-components-accounts.js\"></script>\n</body>\n</html>\n");
$templateCache.put("index.html","<!DOCTYPE html>\n<html>\n\n  <head>\n    <title>hawkular-alerts</title>\n    <base href=\'/\'>\n    <meta charset=\"UTF8\">\n\n    <link rel=\"stylesheet\" href=\"libs/bootstrap/dist/css/bootstrap.css\" />\n    <link rel=\"stylesheet\" href=\"libs/patternfly/dist/css/patternfly.css\" />\n    <link rel=\"stylesheet\" href=\"dist/hawkular-ui-components-alerts.css\" />\n\n    <!-- bower:css -->\n    <!-- endbower -->\n\n    <!-- ES6/ES6 shim -->\n    <!--[if IE 8]>\n    <script src=\"libs/es5-dom-shim/__COMIPLE/a.ie8.js\"></script>\n    <![endif]-->\n    <script src=\"libs/es5-dom-shim/__COMPILE/a.js\"></script>\n\n    <!-- bower:js -->\n    <!-- endbower -->\n\n    <script src=\"libs/patternfly/components/bootstrap/dist/js/bootstrap.js\"></script>\n    <script src=\"libs/patternfly/dist/js/patternfly.js\"></script>\n    <script src=\"libs/event-drops/src/eventDrops.js\"></script>\n\n  </head>\n\n  <body>\n    <nav class=\"navbar navbar-default navbar-pf\" role=\"navigation\">\n      <ul class=\"nav navbar-nav navbar-primary\" hawtio-main-nav></ul>\n      <ul class=\"nav navbar-nav\" hawtio-sub-tabs></ul>\n    </nav>\n\n    <div id=\"main\" class=\"container-fluid ng-cloak\" ng-controller=\"HawtioNav.ViewController\">\n      <div ng-include src=\"viewPartial\"></div>\n    </div>\n\n    <!-- add any scripts under dist/ here -->\n    <script src=\"dist/hawkular-ui-components-alerts.js\"></script>\n    <script>\n      angular.module(\'hawkular-alerts\').config([\"HawkularAlertProvider\", function(HawkularAlertProvider) {\n        HawkularAlertProvider.setPort(8080);\n      }]);\n    </script>\n\n  </body>\n</html>\n");
$templateCache.put("index.html","<!DOCTYPE html>\n<html>\n\n  <head>\n    <title>hawkular-directives</title>\n    <base href=\'/\'>\n    <meta charset=\"UTF8\">\n\n    <!-- bower:css -->\n    <!-- endbower -->\n\n    <!-- ES6/ES6 shim -->\n    <!--[if IE 8]>\n    <script src=\"libs/es5-dom-shim/__COMIPLE/a.ie8.js\"></script>\n    <![endif]-->\n    <script src=\"libs/es5-dom-shim/__COMPILE/a.js\"></script>\n\n    <!-- bower:js -->\n    <!-- endbower -->\n  </head>\n\n  <body>\n\n    <nav class=\"navbar navbar-default navbar-fixed-top navbar-pf\" role=\"navigation\">\n      <div class=\"navbar-header\">\n        <button type=\"button\" class=\"navbar-toggle\" data-toggle=\"collapse\" data-target=\".navbar-collapse-1\">\n          <span class=\"sr-only\">Toggle navigation</span>\n          <span class=\"icon-bar\"></span>\n          <span class=\"icon-bar\"></span>\n          <span class=\"icon-bar\"></span>\n        </button>\n        <a class=\"navbar-brand\" href=\"/\">\n          <img src=\"img/brand.svg\" height=\"10px\" alt=\"Hawkular\" />\n        </a>\n      </div>\n      <div class=\"collapse navbar-collapse navbar-collapse-1\">\n        <ul class=\"nav navbar-nav navbar-utility\">\n          <li class=\"dropdown\">\n            <a href=\"#\" class=\"dropdown-toggle\" data-toggle=\"dropdown\">\n              <span class=\"pficon pficon-user\"></span>\n              Brian Johnson <b class=\"caret\"></b>\n            </a>\n            <ul class=\"dropdown-menu\">\n              <li>\n                <a href=\"#\">Log Out</a>\n              </li>\n            </ul>\n          </li>\n        </ul>\n        <hawkular-topbar ng-controller=\"Topbar.TopbarController\"></hawkular-topbar>\n      </div>\n    </nav>\n\n    <div id=\"main\" class=\"row below-topbar\" ng-controller=\"HawtioNav.ViewController\">\n      <!-- Sidebar -->\n        <hawkular-sidebar ng-controller=\"Sidebar.SidebarController\"></hawkular-sidebar>\n        <div class=\"col-sm-9 col-md-10 content\" ng-include src=\"viewPartial\"></div>\n    </div>\n\n    <!-- add any scripts under dist/ here -->\n    <script src=\"dist/hawkular-ui-components-directives.js\"></script>\n    <link rel=\"stylesheet\" href=\"dist/hawkular-ui-components-directives.css\" />\n\n    <script>\n      angular.module(\'topbar\').config([\"HawkularInventoryProvider\",\n        function(HawkularInventoryProvider) {\n          HawkularInventoryProvider.setPort(8080);\n        }]);\n    </script>\n\n  </body>\n</html>\n");
$templateCache.put("index.html","<!DOCTYPE html>\n<html>\n\n  <head>\n    <title>hawkular-inventory</title>\n    <base href=\'/\'>\n    <meta charset=\"UTF8\">\n\n\n    <link rel=\"stylesheet\" href=\"libs/bootstrap/dist/css/bootstrap.css\" />\n    <link rel=\"stylesheet\" href=\"libs/patternfly/dist/css/patternfly.css\" />\n    <link rel=\"stylesheet\" href=\"libs/hawkular-charts/css/hawkular-chart.css\" />\n\n    <!-- bower:css -->\n    <!-- endbower -->\n\n    <!-- ES6/ES6 shim -->\n    <!--[if IE 8]>\n    <script src=\"libs/es5-dom-shim/__COMIPLE/a.ie8.js\"></script>\n    <![endif]-->\n    <script src=\"libs/es5-dom-shim/__COMPILE/a.js\"></script>\n\n    <!-- bower:js -->\n    <!-- endbower -->\n\n    <script src=\"libs/bootstrap/dist/js/bootstrap.js\"></script>\n    <script src=\"libs/patternfly/dist/js/patternfly.js\"></script>\n    <script src=\"libs/angular-resource/angular-resource.js\"></script>\n    <script src=\"libs/hawkular-ui-services/dist/hawkular-ui-service.js\"></script>\n\n    <script src=\"libs/numeral/numeral.js\"></script>\n    <script src=\"libs/moment/moment.js\"></script>\n    <script src=\"libs/d3/d3.js\"></script>\n    <script src=\"libs/d3-tip/index.js\"></script>\n    <script src=\"libs/hawkular-charts/hawkular-charts.js\"></script>\n\n  </head>\n\n  <body>\n    <nav class=\"navbar navbar-default navbar-pf\" role=\"navigation\">\n      <ul class=\"nav navbar-nav navbar-primary\" hawtio-main-nav></ul>\n      <ul class=\"nav navbar-nav\" hawtio-sub-tabs></ul>\n    </nav>\n\n    <div id=\"main\" class=\"container-fluid ng-cloak\" ng-controller=\"HawtioNav.ViewController\">\n      <div ng-include src=\"viewPartial\"></div>\n    </div>\n\n    <!-- add any scripts under dist/ here -->\n    <script src=\"dist/hawkular-ui-components-inventory.js\"></script>\n    <script>\n      angular.module(\'inventory\').config([\"HawkularInventoryProvider\", function(HawkularInventoryProvider) {\n        HawkularInventoryProvider.setPort(8080);\n      }]);\n    </script>\n\n  </body>\n</html>\n");
$templateCache.put("index.html","<!DOCTYPE html>\n<html>\n\n<head>\n  <title>hawkular-metrics</title>\n  <base href=\'/\'>\n  <meta charset=\"UTF8\">\n\n  <!-- bower:css -->\n  <link rel=\"stylesheet\" href=\"libs/toastr/toastr.css\"/>\n  <!-- endbower -->\n\n  <link rel=\"stylesheet\" href=\"../../libs/hawkular-charts/css/hawkular-chart.css\"/>\n  <link rel=\"stylesheet\" href=\"../../dist/hawkular-ui-components-metrics.css\"/>\n\n  <!-- ES6/ES6 shim -->\n  <!--[if IE 8]>\n  <script src=\"../../libs/es5-dom-shim/__COMIPLE/a.ie8.js\"></script>\n  <![endif]-->\n  <script src=\"../../libs/es5-dom-shim/__COMPILE/a.js\"></script>\n  <script src=\"../../libs/patternfly/components/jquery/jquery.js\"></script>\n  <script src=\"../../libs/patternfly/components/bootstrap/dist/js/bootstrap.js\"></script>\n\n  <!-- bower:js -->\n  <!-- endbower -->\n</head>\n\n<body data-ng-strict-di>\n<nav class=\"navbar navbar-default navbar-pf\" role=\"navigation\">\n  <ul class=\"nav navbar-nav navbar-primary\" hawtio-main-nav></ul>\n  <ul class=\"nav navbar-nav\" hawtio-sub-tabs></ul>\n</nav>\n\n<hawkular-topbar ng-controller=\"Topbar.TopbarController\" ng-show=\"!hideSidebar\"></hawkular-topbar>\n\n<div id=\"main\" class=\"container-fluid ng-cloak\" ng-controller=\"HawtioNav.ViewController\">\n  <div ng-include src=\"viewPartial\"></div>\n</div>\n\n<!-- add any scripts under dist/ here -->\n<script src=\"dist/hawkular-ui-components-metrics.js\"></script>\n<script src=\"dist/hawkular-ui-components-directives.js\"></script>\n<script>\n  angular.module(\'hawkular-metrics\').config([\"HawkularMetricProvider\", \"HawkularInventoryProvider\", \"HawkularAlertProvider\",\n    function(HawkularMetricProvider, HawkularInventoryProvider, HawkularAlertProvider) {\n      HawkularMetricProvider.setPort(8080);\n      HawkularInventoryProvider.setPort(8080);\n      HawkularAlertProvider.setPort(8080);\n    }]);\n</script>\n\n</body>\n</html>\n");
$templateCache.put("plugins/accounts/html/accounts.html","<div class=\"row\">\n    <div class=\"col-md-12\">\n        <h1>Accounts</h1>\n        Your account can be managed directly at <a href=\"http://localhost:8080/auth/realms/hawkular/account\">Keycloak</a>.\n    </div>\n</div>\n");
$templateCache.put("plugins/accounts/html/inactivityModal.html","<div class=\"modal-header\">\n    <h3 class=\"modal-title\">Session expired</h3>\n</div>\n<div class=\"modal-body\">\n    Due to inactivity, we had to close your session.\n</div>\n<div class=\"modal-footer\">\n    <button id=\"logoutBtn\" class=\"btn btn-primary\" data-ng-click=\"userDetails.logout()\">OK</button>\n</div>\n");
$templateCache.put("plugins/accounts/html/organization_new.html","<div class=\"row\">\n    <div class=\"col-md-12\" data-ng-controller=\"HawkularAccounts.OrganizationNewController\">\n        <ol class=\"breadcrumb\">\n            <li><a data-ng-href=\"/\">Hawkular</a></li>\n            <li><a data-ng-href=\"/\">Accounts</a></li>\n            <li><a data-ng-href=\"/accounts/organizations\">Organizations</a></li>\n        </ol>\n        <h1>\n            Add Organization\n        </h1>\n\n        <form role=\"form\" class=\"form-horizontal\">\n            <div class=\"form-group\">\n                <label for=\"name\" class=\"col-md-2 control-label\">Name <span class=\"required\">*</span> </label>\n                <div class=\"col-md-6\">\n                    <input type=\"text\" class=\"form-control\" id=\"name\" placeholder=\"Name\"\n                           data-ng-model=\"organizationNew.name\">\n                </div>\n            </div>\n\n            <div class=\"form-group\">\n                <label for=\"description\" class=\"col-md-2 control-label\">Description</label>\n                <div class=\"col-md-6\">\n                    <input type=\"text\" class=\"form-control\" id=\"description\" placeholder=\"Description\"\n                           data-ng-model=\"organizationNew.description\">\n                </div>\n            </div>\n            <div class=\"col-md-8\">\n                <div class=\"pull-right\">\n                    <a data-ng-href=\"/accounts/organizations\" class=\"btn btn-default btn-lg\">Cancel</a>\n                    <button data-ng-click=\"persist()\" type=\"submit\" class=\"btn btn-primary btn-lg\">Save</button>\n                </div>\n            </div>\n\n        </form>\n    </div><!-- /col -->\n</div><!-- /row -->\n");
$templateCache.put("plugins/accounts/html/organizations.html","<div class=\"row\">\n    <div class=\"col-md-12\" data-ng-controller=\"HawkularAccounts.OrganizationsController\">\n        <ol class=\"breadcrumb\">\n            <li><a data-ng-href=\"/\">Hawkular</a></li>\n            <li><a data-ng-href=\"/\">Accounts</a></li>\n            <li><a data-ng-href=\"/accounts/organizations\">Organizations</a></li>\n        </ol>\n        <div class=\"pull-right\">\n            <button class=\"btn btn-primary\" type=\"button\" role=\"button\" data-ng-click=\"showCreateForm()\">Create</button>\n        </div>\n\n        <h1>Organizations</h1>\n        <div class=\"progress-description\" data-ng-show=\"loading\">\n            <div class=\"spinner spinner-xs spinner-inline\"></div> <strong>Loading:</strong> Organizations\n        </div>\n        <div class=\"row\" data-ng-show=\"!organizations.length && !loading\">\n            <div class=\"col-sm-6\">\n                No organizations yet. How about creating one?\n            </div>\n        </div>\n\n        <div data-ng-show=\"organizations.length && !loading\">\n            <table class=\"table table-striped table-bordered\">\n                <thead>\n                    <tr>\n                        <th>Name</th>\n                        <th>Description</th>\n                        <th>&nbsp;</th>\n                    </tr>\n                </thead>\n                <tbody>\n                    <tr data-ng-repeat=\"organization in organizations\">\n                        <td>{{organization.name}}</td>\n                        <td>{{organization.description}}</td>\n                        <td>\n                            <button type=\"button\" class=\"btn btn-default\" aria-label=\"Remove\" data-ng-click=\"remove(organization)\">\n                                <span class=\"pficon pficon-delete\" aria-hidden=\"true\"></span>\n                            </button>\n                        </td>\n                    </tr>\n                </tbody>\n            </table>\n        </div>\n    </div><!-- /col -->\n\n</div>\n</div>\n");
$templateCache.put("plugins/alerts/html/actions.html","<div class=\"row\">\n  <div class=\"col-md-12\" ng-controller=\"HawkularAlerts.ActionsController as ac\">\n\n    <div ng-if=\"status == \'all\'\" ng-include=\"\'plugins/alerts/html/actionsAll.html\'\"></div>\n\n    <div ng-if=\"status == \'new\'\" ng-include=\"\'plugins/alerts/html/actionsNew.html\'\"></div>\n\n    <div ng-if=\"status == \'edit\'\" ng-include=\"\'plugins/alerts/html/actionsEdit.html\'\"></div>\n\n  </div>\n</div>\n");
$templateCache.put("plugins/alerts/html/actionsAll.html","<h1>Actions</h1>\n<div class=\"dataTables_wrapper no-footer\">\n  <div class=\"dataTables_header\">\n    <div class=\"text-right\">\n      <button ng-click=\"ac.newAction()\" type=\"button\" class=\"btn btn-primary\">New Action</button>\n      <button ng-click=\"ac.allActions()\" type=\"button\" class=\"btn btn-info\">Refresh</button>\n    </div>\n  </div>\n  <table class=\"datatable table table-striped table-bordered dataTable no-footer\" role=\"grid\">\n    <thead>\n    <tr role=\"row\">\n      <th class=\"vert-align\">Action</th>\n      <th class=\"vert-align\">Plugin</th>\n      <th class=\"vert-align\">Description</th>\n      <th></th>\n    </tr>\n    </thead>\n    <tbody>\n    <tr ng-repeat=\"action in actions | orderBy:[\'actionId\', \'actionPlugin\']:false\" ng-class-odd=\"\'gradeA odd\'\" ng-class-even=\"\'gradeA even\'\" >\n      <td class=\"vert-align\">{{ action.actionId }}</td>\n      <td class=\"vert-align\">{{ action.actionPlugin }}</td>\n      <td class=\"vert-align\">{{ action.description }}</td>\n      <td style=\"vertical-align: middle;\">\n        <div class=\"text-right\">\n          <a ng-click=\"ac.viewAction(action.actionId)\" class=\"btn btn-primary\">View</a>\n          <a class=\"btn btn-danger\" ng-click=\"ac.deleteAction(action.actionId)\">Delete</a>\n        </div>\n      </td>\n    </tr>\n    </tbody>\n  </table>\n</div>\n\n");
$templateCache.put("plugins/alerts/html/actionsEdit.html","<h1>{{ action.actionId }}</h1>\n<div class=\"col-md-12\">\n  <form class=\"form-horizontal\" name=\"editActionForm\" ng-submit=\"ac.saveAction()\">\n    <div class=\"form-group\">\n      <label class=\"col-md-2 control-label\" for=\"actionId\">\n        Action\n      </label>\n      <div class=\"col-md-6\">\n        <input type=\"text\" id=\"actionId\" ng-model=\"action.actionId\" class=\"form-control\" ng-minlength=\"1\" disabled>\n      </div>\n    </div>\n    <div class=\"form-group\">\n      <label class=\"col-md-2 control-label\" for=\"actionPlugin\">\n        Plugin\n      </label>\n      <div class=\"col-md-6\">\n        <input type=\"text\" id=\"actionPlugin\" ng-model=\"action.actionPlugin\" class=\"form-control\" ng-minlength=\"1\" disabled>\n      </div>\n    </div>\n    <div class=\"form-group\">\n      <label class=\"col-md-2 control-label\" for=\"actionDescription\">\n        Description\n      </label>\n      <div class=\"col-md-6\">\n        <input type=\"text\" id=\"actionDescription\" ng-model=\"action.description\" class=\"form-control\" ng-minlength=\"1\" required>\n      </div>\n    </div>\n    <div ng-repeat=\"(key, value) in action\">\n      <div class=\"form-group\" ng-if=\"key != \'actionId\' && key != \'actionPlugin\' && key != \'description\'\">\n        <label class=\"col-md-2 control-label\">\n          {{ key }}\n        </label>\n        <div class=\"col-md-6\">\n          <input type=\"text\" ng-model=\"action[key]\" class=\"form-control\" ng-minlength=\"1\" required>\n        </div>\n      </div>\n    </div>\n    <div class=\"form-group\">\n      <div class=\"col-md-offset-2 col-md-6\">\n        <button type=\"submit\" class=\"btn btn-primary\">Update Action</button>\n        <button type=\"button\" ng-click=\"ac.allActions()\" class=\"btn btn-default\">Cancel</button>\n      </div>\n    </div>\n    <div class=\"form-group\">\n      <div class=\"col-md-offset-2 col-md-6\">\n        <alert ng-repeat=\"alertMsg in msgs\" type=\"{{alertMsg.type}}\" close=\"nc.closeAlertMsg($index)\">{{alertMsg.msg}}</alert>\n      </div>\n    </div>\n  </form>\n</div>\n");
$templateCache.put("plugins/alerts/html/actionsNew.html","<h1>New Action</h1>\n<div class=\"col-md-12\">\n  <form class=\"form-horizontal\" name=\"newActionForm\" ng-submit=\"ac.saveAction()\">\n    <div class=\"form-group\">\n      <label class=\"col-md-2 control-label\" for=\"actionId\">\n        Action\n      </label>\n      <div class=\"col-md-6\">\n        <input type=\"text\" id=\"actionId\" ng-model=\"action.actionId\" class=\"form-control\" ng-minlength=\"1\" required>\n      </div>\n    </div>\n    <div class=\"form-group\">\n      <label class=\"col-md-2 control-label\">\n        Plugin\n      </label>\n      <div class=\"col-md-6\">\n        <select ng-model=\"action.actionPlugin\" ng-change=\"ac.changePlugin()\">\n          <option ng-repeat=\"actionPlugin in actionPlugins\" ng-selected=\"actionPlugin == \'email\'\"> {{ actionPlugin }}</option>\n        </select>\n      </div>\n    </div>\n    <div class=\"form-group\">\n      <label class=\"col-md-2 control-label\">\n        Description\n      </label>\n      <div class=\"col-md-6\">\n        <input type=\"text\" ng-model=\"action.description\" class=\"form-control\" ng-minlength=\"1\" required>\n      </div>\n    </div>\n    <div ng-repeat=\"property in pluginProperties\">\n      <div class=\"form-group\" ng-if=\"property != \'description\' && property != \'actionId\' && property != \'actionPlugin\'\">\n        <label class=\"col-md-2 control-label\">\n          {{ property }}\n        </label>\n        <div class=\"col-md-6\">\n          <input type=\"text\" ng-model=\"action[property]\" class=\"form-control\" ng-minlength=\"1\" required>\n        </div>\n      </div>\n    </div>\n    <div class=\"form-group\">\n      <div class=\"col-md-offset-2 col-md-6\">\n        <button type=\"submit\" class=\"btn btn-primary\">Create Action</button>\n        <button type=\"button\" ng-click=\"ac.allActions()\" class=\"btn btn-default\">Cancel</button>\n      </div>\n    </div>\n    <div class=\"form-group\">\n      <div class=\"col-md-offset-2 col-md-6\">\n        <alert ng-repeat=\"alertMsg in msgs\" type=\"{{alertMsg.type}}\" close=\"nc.closeAlertMsg($index)\">{{alertMsg.msg}}</alert>\n      </div>\n    </div>\n  </form>\n</div>\n");
$templateCache.put("plugins/alerts/html/dashboard.html","<div class=\"row\">\n  <div class=\"col-md-12\" ng-controller=\"HawkularAlerts.DashboardController as dsc\">\n    <h1>Alerts Dashboard</h1>\n    <div id=\"alertsDashboard\"></div>\n    <div class=\"col-md-8 col-md-offset-2\" ng-show=\"legend != null\">\n      <div class=\"dataTables_wrapper no-footer\">\n        <div class=\"dataTables_header\">\n          <div class=\"dataTables_info\">Alert at <b>{{ legend.date | date:\'d MMM, y hh:mm:ss a\' }}</b></div>\n        </div>\n        <table class=\"datatable table table-striped table-bordered dataTable no-footer\" role=\"grid\">\n          <thead>\n          <tr role=\"row\">\n            <th> EvalSet</th>\n            <th> Conditions</th>\n          </tr>\n          </thead>\n          <tbody>\n          <tr ng-repeat=\"evalSet in legend.evalSets\" ng-class-odd=\"\'gradeA odd\'\" ng-class-even=\"\'gradeA even\'\" >\n            <td></td>\n            <td>\n              <ul class=\"list-unstyled\">\n                <li ng-repeat=\"condition in evalSet\">\n                  <b>{{ condition.log }}</b> at <i>{{ condition.evalTimestamp | date:\'d MMM, y hh:mm:ss a\'}}</i>\n                </li>\n              </ul>\n              {{ match.time | date:\'d MMM, y hh:mm:ss a\'}}\n            </td>\n          </tr>\n          </tbody>\n        </table>\n      </div>\n    </div>\n    <div class=\"col-md-6\">\n      <p>\n        <a href ng-click=\"dsc.showRefreshForm()\"><span class=\"pficon pficon-refresh\"></span> Refresh Config</a>\n      </p>\n      <form ng-if=\"showRefresh\" class=\"form-horizontal\" ng-submit=\"dsc.updateRefresh()\">\n        <div class=\"form-group\">\n          <label class=\"col-md-4 control-label\" for=\"refreshInput\">\n            Refresh (ms):\n          </label>\n          <div class=\"col-md-3\">\n            <input type=\"number\" id=\"refreshInput\" ng-model=\"refresh.interval\" class=\"form-control\" ng-minlength=\"1\" required>\n          </div>\n        </div>\n        <div class=\"form-group\">\n          <div class=\"col-md-6 col-md-offset-4\">\n            <button type=\"submit\" class=\"btn btn-primary\">Change</button>\n            <button type=\"button\" class=\"btn btn-default\" ng-click=\"dsc.hideRefreshForm()\">Cancel</button>\n          </div>\n        </div>\n      </form>\n      <alert ng-repeat=\"alertMsg in msgs\" type=\"{{alertMsg.type}}\" close=\"dsc.closeAlertMsg($index)\">{{alertMsg.msg}}</alert>\n    </div>\n  </div>\n</div>\n");
$templateCache.put("plugins/alerts/html/definitions.html","<div class=\"row\">\n  <div class=\"col-md-12\" ng-controller=\"HawkularAlerts.DefinitionsController as dc\">\n\n    <div ng-if=\"status == \'all\'\" ng-include=\"\'plugins/alerts/html/definitionsAll.html\'\"></div>\n\n    <div ng-if=\"status == \'new\'\" ng-include=\"\'plugins/alerts/html/definitionsNew.html\'\"></div>\n\n    <div ng-if=\"status == \'edit\'\" ng-include=\"\'plugins/alerts/html/definitionsEdit.html\'\"></div>\n\n  </div>\n</div>\n");
$templateCache.put("plugins/alerts/html/definitionsAll.html","<h1>Trigger Definitions</h1>\n<div class=\"dataTables_wrapper no-footer\">\n  <div class=\"dataTables_header\">\n    <div class=\"text-right\">\n      <button ng-click=\"dc.newDefinition()\" type=\"button\" class=\"btn btn-primary\">New Trigger</button>\n      <button ng-click=\"dc.allDefinitions()\" type=\"button\" class=\"btn btn-info\">Refresh</button>\n    </div>\n  </div>\n  <table class=\"datatable table table-striped table-bordered dataTable no-footer\" role=\"grid\">\n    <thead>\n    <tr role=\"row\">\n      <th class=\"vert-align\">Name</th>\n      <th class=\"vert-align\">Enabled</th>\n      <th class=\"vert-align\">Description</th>\n      <th class=\"vert-align\">Action</th>\n      <th></th>\n    </tr>\n    </thead>\n    <tbody>\n    <tr ng-repeat=\"trigger in triggers | orderBy:[\'id\', \'name\']:false\" ng-class-odd=\"\'gradeA odd\'\" ng-class-even=\"\'gradeA even\'\" >\n      <td class=\"vert-align\">{{ trigger.name }}</td>\n      <td class=\"vert-align\">{{ trigger.enabled }}</td>\n      <td class=\"vert-align\">{{ trigger.description }}</td>\n      <td class=\"vert-align\">\n        <ul class=\"list-unstyled\">\n          <li ng-repeat=\"action in trigger.actions\">{{ action }}</li>\n        </ul>\n      </td>\n      <td style=\"vertical-align: middle;\">\n        <div class=\"text-right\">\n          <a ng-click=\"dc.viewDefinition(trigger.id)\" class=\"btn btn-primary\">View</a>\n          <a class=\"btn btn-danger\" ng-click=\"dc.deleteDefinition(trigger.id, trigger.name)\">Delete</a>\n        </div>\n      </td>\n    </tr>\n    </tbody>\n  </table>\n</div>\n\n");
$templateCache.put("plugins/alerts/html/definitionsConditions.html","<div class=\"dataTables_wrapper no-footer\">\n  <div class=\"dataTables_header\" ng-if=\"statusCondition.status != \'new\'\">\n    <div class=\"text-right\">\n      <button  type=\"button\" class=\"btn btn-primary\"\n          ng-click=\"dc.newCondition()\">New Condition</button>\n    </div>\n  </div>\n  <div ng-if=\"statusCondition.status == \'new\'\" class=\"col-md-12\"\n       ng-include=\"\'plugins/alerts/html/definitionsConditionsEdit.html\'\">\n  </div>\n  <table class=\"datatable table table-striped table-bordered dataTable no-footer\" role=\"grid\">\n    <thead>\n    <tr role=\"row\">\n      <th class=\"vert-align\">Condition</th>\n      <th class=\"vert-align\">Description</th>\n      <th></th>\n    </tr>\n    </thead>\n    <tbody>\n    <tr ng-repeat-start=\"condition in conditions | orderBy:[\'conditionId\', \'description\']:false\" ng-class-odd=\"\'gradeA odd\'\" ng-class-even=\"\'gradeA even\'\" >\n      <td class=\"vert-align\">{{ condition.triggerMode }}</td>\n      <td class=\"vert-align\">{{ condition.description }}</td>\n      <td style=\"vertical-align: middle;\">\n        <div class=\"text-right\">\n          <a ng-if=\"!(statusCondition.status == \'edit\' && statusCondition.conditionId == condition.conditionId)\"\n             ng-click=\"dc.viewCondition(condition)\" class=\"btn btn-primary\">View</a>\n          <a ng-if=\"!(statusCondition.status == \'edit\' && statusCondition.conditionId == condition.conditionId)\"\n             class=\"btn btn-danger\" ng-click=\"dc.deleteCondition(condition.conditionId, condition.description)\">Delete</a>\n        </div>\n      </td>\n    </tr>\n    <tr ng-if=\"statusCondition.status == \'edit\' && statusCondition.conditionId == condition.conditionId\" ng-repeat-end=\"\">\n      <td colspan=\"3\">\n        <div class=\"col-md-12\" ng-include=\"\'plugins/alerts/html/definitionsConditionsEdit.html\'\">\n        </div>\n      </td>\n    </tr>\n    </tbody>\n  </table>\n</div>\n");
$templateCache.put("plugins/alerts/html/definitionsConditionsEdit.html","<form class=\"form-horizontal\" name=\"editConditionForm\">\n  <div ng-if=\"statusCondition.status == \'new\'\" class=\"form-group\">\n    <label class=\"col-md-4 control-label\" for=\"newConditionType\">\n      Condition Type\n    </label>\n    <div class=\"col-md-6\">\n      <ui-select ng-if=\"statusCondition.status == \'new\'\" id=\"newConditionType\"\n                 ng-model=\"editCondition.type\" theme=\"bootstrap\"\n                 ng-change=\"dc.changeConditionType()\">\n        <ui-select-match placeholder=\"Select condition type...\">{{$select.selected}}</ui-select-match>\n        <ui-select-choices repeat=\"conditionType in conditionTypes | filter:$select.search\">\n          {{ conditionType }}\n        </ui-select-choices>\n      </ui-select>\n    </div>\n  </div>\n  <div ng-if=\"editCondition.type == \'AVAILABILITY\'\">\n    <div class=\"form-group\">\n      <label class=\"col-md-4 control-label\" for=\"availabilityDataId\">\n        Data Id\n      </label>\n      <div class=\"col-md-6\">\n        <input type=\"text\" id=\"availabilityDataId\" ng-model=\"editCondition.dataId\" class=\"form-control\" ng-minlength=\"1\" required>\n      </div>\n    </div>\n    <div class=\"form-group\">\n      <label class=\"col-md-4 control-label\">\n        Operator\n      </label>\n      <div class=\"col-md-6\">\n        <label class=\"radio-inline\">\n          <input type=\"radio\" ng-model=\"editCondition.operator\" class=\"radio\" value=\"UP\"> UP\n        </label>\n        <label class=\"radio-inline\">\n          <input type=\"radio\" ng-model=\"editCondition.operator\" class=\"radio\" value=\"NOT_UP\"> NOT_UP\n        </label>\n        <label class=\"radio-inline\">\n          <input type=\"radio\" ng-model=\"editCondition.operator\" class=\"radio\" value=\"DOWN\"> DOWN\n        </label>\n      </div>\n    </div>\n  </div>\n\n  <div ng-if=\"editCondition.type == \'COMPARE\'\">\n    <div class=\"form-group\">\n      <label class=\"col-md-4 control-label\" for=\"compareData1Id\">\n        Data Id\n      </label>\n      <div class=\"col-md-6\">\n        <input type=\"text\" id=\"compareData1Id\" ng-model=\"editCondition.dataId\" class=\"form-control\" ng-minlength=\"1\" required>\n      </div>\n    </div>\n    <div class=\"form-group\">\n      <label class=\"col-md-4 control-label\">\n        Operator\n      </label>\n      <div class=\"col-md-6\">\n        <label class=\"radio-inline\">\n          <input type=\"radio\" ng-model=\"editCondition.operator\" class=\"radio\" value=\"LT\"> <\n        </label>\n        <label class=\"radio-inline\">\n          <input type=\"radio\" ng-model=\"editCondition.operator\" class=\"radio\" value=\"GT\"> >\n        </label>\n        <label class=\"radio-inline\">\n          <input type=\"radio\" ng-model=\"editCondition.operator\" class=\"radio\" value=\"LTE\"> <=\n        </label>\n        <label class=\"radio-inline\">\n          <input type=\"radio\" ng-model=\"editCondition.operator\" class=\"radio\" value=\"GTE\"> >=\n        </label>\n      </div>\n    </div>\n    <div class=\"form-group\">\n      <label class=\"col-md-4 control-label\" for=\"compareData2Id\">\n        Data 2 Id\n      </label>\n      <div class=\"col-md-6\">\n        <input type=\"text\" id=\"compareData2Id\" ng-model=\"editCondition.data2Id\" class=\"form-control\" ng-minlength=\"1\" required>\n      </div>\n    </div>\n    <div class=\"form-group\">\n      <label class=\"col-md-4 control-label\" for=\"compareData2Multiplier\">\n        Data 2 Multiplier\n      </label>\n      <div class=\"col-md-6\">\n        <input type=\"number\" id=\"compareData2Multiplier\" ng-model=\"editCondition.data2Multiplier\" class=\"form-control\" ng-minlength=\"1\" required>\n      </div>\n    </div>\n  </div>\n\n  <div ng-if=\"editCondition.type == \'STRING\'\">\n    <div class=\"form-group\">\n      <label class=\"col-md-4 control-label\" for=\"stringDataId\">\n        Data Id\n      </label>\n      <div class=\"col-md-6\">\n        <input type=\"text\" id=\"stringDataId\" ng-model=\"editCondition.dataId\" class=\"form-control\" ng-minlength=\"1\" required>\n      </div>\n    </div>\n    <div class=\"form-group\">\n      <label class=\"col-md-4 control-label\">\n        Operator\n      </label>\n      <div class=\"col-md-6\">\n        <label class=\"radio\">\n          <input type=\"radio\" ng-model=\"editCondition.operator\" class=\"radio\" value=\"EQUAL\"> EQUAL\n        </label>\n        <label class=\"radio\">\n          <input type=\"radio\" ng-model=\"editCondition.operator\" class=\"radio\" value=\"NOT_EQUAL\"> NOT_EQUAL\n        </label>\n        <label class=\"radio\">\n          <input type=\"radio\" ng-model=\"editCondition.operator\" class=\"radio\" value=\"STARTS_WITH\"> START_WITH\n        </label>\n        <label class=\"radio\">\n          <input type=\"radio\" ng-model=\"editCondition.operator\" class=\"radio\" value=\"ENDS_WITH\"> ENDS_WITH\n        </label>\n        <label class=\"radio\">\n          <input type=\"radio\" ng-model=\"editCondition.operator\" class=\"radio\" value=\"CONTAINS\"> CONTAINS\n        </label>\n        <label class=\"radio\">\n          <input type=\"radio\" ng-model=\"editCondition.operator\" class=\"radio\" value=\"MATCH\"> MATCH\n        </label>\n      </div>\n    </div>\n    <div class=\"form-group\">\n      <label class=\"col-md-4 control-label\" for=\"pattern\">\n        Pattern\n      </label>\n      <div class=\"col-md-6\">\n        <input type=\"text\" id=\"pattern\" ng-model=\"editCondition.pattern\" class=\"form-control\" ng-minlength=\"1\" required>\n      </div>\n    </div>\n    <div class=\"form-group\">\n      <label class=\"col-md-4 control-label\" for=\"ignoredCase\">\n        Ignore Case\n      </label>\n      <div class=\"col-md-6\">\n        <input type=\"checkbox\" id=\"ignoredCase\" ng-model=\"editCondition.ignoreCase\" class=\"checkbox\" >\n      </div>\n    </div>\n  </div>\n\n  <div ng-if=\"editCondition.type == \'THRESHOLD\'\">\n    <div class=\"form-group\">\n      <label class=\"col-md-4 control-label\" for=\"thresholdDataId\">\n        Data Id\n      </label>\n      <div class=\"col-md-6\">\n        <input type=\"text\" id=\"thresholdDataId\" ng-model=\"editCondition.dataId\" class=\"form-control\" ng-minlength=\"1\" required>\n      </div>\n    </div>\n    <div class=\"form-group\">\n      <label class=\"col-md-4 control-label\">\n        Operator\n      </label>\n      <div class=\"col-md-6\">\n        <label class=\"radio-inline\">\n          <input type=\"radio\" ng-model=\"editCondition.operator\" class=\"radio\" value=\"LT\"> <\n        </label>\n        <label class=\"radio-inline\">\n          <input type=\"radio\" ng-model=\"editCondition.operator\" class=\"radio\" value=\"GT\"> >\n        </label>\n        <label class=\"radio-inline\">\n          <input type=\"radio\" ng-model=\"editCondition.operator\" class=\"radio\" value=\"LTE\"> <=\n        </label>\n        <label class=\"radio-inline\">\n          <input type=\"radio\" ng-model=\"editCondition.operator\" class=\"radio\" value=\"GTE\"> >=\n        </label>\n      </div>\n    </div>\n    <div class=\"form-group\">\n      <label class=\"col-md-4 control-label\" for=\"threshold\">\n        Threshold\n      </label>\n      <div class=\"col-md-6\">\n        <input type=\"number\" id=\"threshold\" ng-model=\"editCondition.threshold\" class=\"form-control\" ng-minlength=\"1\" required>\n      </div>\n    </div>\n  </div>\n\n  <div ng-if=\"editCondition.type == \'RANGE\'\">\n    <div class=\"form-group\">\n      <label class=\"col-md-4 control-label\" for=\"thresholdRangeDataId\">\n        Data Id\n      </label>\n      <div class=\"col-md-6\">\n        <input type=\"text\" id=\"thresholdRangeDataId\" ng-model=\"editCondition.dataId\" class=\"form-control\" ng-minlength=\"1\" required>\n      </div>\n    </div>\n    <div class=\"form-group\">\n      <label class=\"col-md-4 control-label\">\n        In Range:\n      </label>\n      <div class=\"col-md-6\">\n        <input type=\"checkbox\" ng-model=\"editCondition.inRange\" class=\"checkbox\" >\n      </div>\n    </div>\n    <div class=\"form-group\">\n      <label class=\"col-md-4 control-label\">\n        Operator Low\n      </label>\n      <div class=\"col-md-6\">\n        <label class=\"radio-inline\">\n          <input type=\"radio\" ng-model=\"editCondition.operatorLow\" class=\"radio\" value=\"INCLUSIVE\"> [\n        </label>\n        <label class=\"radio-inline\">\n          <input type=\"radio\" ng-model=\"editCondition.operatorLow\" class=\"radio\" value=\"EXCLUSIVE\"> (\n        </label>\n      </div>\n    </div>\n    <div class=\"form-group\">\n      <label class=\"col-md-4 control-label\" for=\"thresholdLow\">\n        Threshold Low\n      </label>\n      <div class=\"col-md-6\">\n        <input type=\"number\" id=\"thresholdLow\" ng-model=\"editCondition.thresholdLow\" class=\"form-control\" ng-minlength=\"1\" required>\n      </div>\n    </div>\n    <div class=\"form-group\">\n      <label class=\"col-md-4 control-label\" for=\"thresholdHigh\">\n        Threshold High\n      </label>\n      <div class=\"col-md-6\">\n        <input type=\"number\" id=\"thresholdHigh\" ng-model=\"editCondition.thresholdHigh\" class=\"form-control\" ng-minlength=\"1\" required>\n      </div>\n    </div>\n    <div class=\"form-group\">\n      <label class=\"col-md-4 control-label\">\n        Operator High\n      </label>\n      <div class=\"col-md-6\">\n        <label class=\"radio-inline\">\n          <input type=\"radio\" ng-model=\"editCondition.operatorHigh\" class=\"radio\" value=\"INCLUSIVE\"> ]\n        </label>\n        <label class=\"radio-inline\">\n          <input type=\"radio\" ng-model=\"editCondition.operatorHigh\" class=\"radio\" value=\"EXCLUSIVE\"> )\n        </label>\n      </div>\n    </div>\n  </div>\n\n  <div class=\"form-group\">\n    <div class=\"col-md-offset-4 col-md-6\">\n      <button ng-click=\"dc.saveCondition()\" class=\"btn btn-primary\">Update Condition</button>\n      <a ng-if=\"statusCondition.status != \'new\'\" class=\"btn btn-danger\"\n         ng-click=\"dc.deleteCondition(editCondition.conditionId, editCondition.description)\">Delete</a>\n      <button type=\"button\" ng-click=\"dc.cancelCondition()\" class=\"btn btn-default\">Cancel</button>\n    </div>\n  </div>\n</form>\n");
$templateCache.put("plugins/alerts/html/definitionsDampening.html","<div class=\"dataTables_wrapper no-footer\">\n  <table ng-if=\"statusDampening.status == \'view\'\" class=\"datatable table table-striped table-bordered dataTable no-footer\" role=\"grid\">\n    <thead>\n    <tr role=\"row\">\n      <th class=\"vert-align\">Mode</th>\n      <th class=\"vert-align\">Type</th>\n      <th class=\"vert-align\">True Evals</th>\n      <th class=\"vert-align\">Total Evals</th>\n      <th class=\"vert-align\">Eval Period</th>\n      <th></th>\n    </tr>\n    </thead>\n    <tbody>\n    <tr class=\"gradeA odd\">\n      <td class=\"vert-align\">{{ dampeningFire.triggerMode }}</td>\n      <td class=\"vert-align\">{{ dampeningFire.type }}</td>\n      <td class=\"vert-align\">{{ dampeningFire.evalTrueSetting }}</td>\n      <td class=\"vert-align\">{{ dampeningFire.evalTotalSetting }}</td>\n      <td class=\"vert-align\">{{ dampeningFire.evalTimeSetting }}</td>\n      <td style=\"vertical-align: middle;\">\n        <div class=\"text-right\">\n          <a ng-click=\"dc.viewDampening(dampeningFire)\" class=\"btn btn-primary\">View</a>\n        </div>\n      </td>\n    </tr>\n    <tr class=\"gradeA odd\">\n      <td class=\"vert-align\">{{ dampeningSafety.triggerMode }}</td>\n      <td class=\"vert-align\">{{ dampeningSafety.type }}</td>\n      <td class=\"vert-align\">{{ dampeningSafety.evalTrueSetting }}</td>\n      <td class=\"vert-align\">{{ dampeningSafety.evalTotalSetting }}</td>\n      <td class=\"vert-align\">{{ dampeningSafety.evalTimeSetting }}</td>\n      <td style=\"vertical-align: middle;\">\n        <div class=\"text-right\">\n          <a ng-click=\"dc.viewDampening(dampeningSafety)\" class=\"btn btn-primary\">View</a>\n        </div>\n      </td>\n    </tr>\n    </tbody>\n  </table>\n</div>\n<div ng-if=\"statusDampening.status == \'edit\' || statusDampening.status == \'new\'\" class=\"col-md-12\">\n  <div class=\"form-group\">\n    <label class=\"col-md-4 control-label\">\n      Type\n    </label>\n    <div class=\"col-md-6\">\n      <label class=\"radio\">\n        <input type=\"radio\" ng-model=\"editDampening.type\" class=\"radio\" value=\"STRICT\"> STRICT\n      </label>\n      <label class=\"radio\">\n        <input type=\"radio\" ng-model=\"editDampening.type\" class=\"radio\" value=\"RELAXED_COUNT\"> RELAXED_COUNT\n      </label>\n      <label class=\"radio\">\n        <input type=\"radio\" ng-model=\"editDampening.type\" class=\"radio\" value=\"RELAXED_TIME\"> RELAXED_TIME\n      </label>\n      <label class=\"radio\">\n        <input type=\"radio\" ng-model=\"editDampening.type\" class=\"radio\" value=\"STRICT_TIME\"> STRICT_TIME\n      </label>\n    </div>\n  </div>\n  <div class=\"form-group\">\n    <label class=\"col-md-4 control-label\" for=\"trueEvals\">\n      True Evals\n    </label>\n    <div class=\"col-md-6\">\n      <input type=\"number\" id=\"trueEvals\" ng-model=\"editDampening.evalTrueSetting\" class=\"form-control\" ng-minlength=\"1\" required>\n    </div>\n  </div>\n  <div class=\"form-group\">\n    <label class=\"col-md-4 control-label\" for=\"totalEvals\">\n      Total Evals\n    </label>\n    <div class=\"col-md-6\">\n      <input type=\"number\" id=\"totalEvals\" ng-model=\"editDampening.evalTotalSetting\" class=\"form-control\" ng-minlength=\"1\" required>\n    </div>\n  </div>\n  <div class=\"form-group\">\n    <label class=\"col-md-4 control-label\" for=\"evalPeriod\">\n      Eval Period\n    </label>\n    <div class=\"col-md-6\">\n      <input type=\"number\" id=\"evalPeriod\" ng-model=\"editDampening.evalTimeSetting\" class=\"form-control\" ng-minlength=\"1\" required>\n    </div>\n  </div>\n  <div class=\"form-group\">\n    <div class=\"col-md-offset-4 col-md-6\">\n      <button ng-click=\"dc.saveDampening()\" class=\"btn btn-primary\">Update {{ editDampening.triggerMode }}</button>\n      <button type=\"button\" ng-click=\"dc.getDampenings(trigger.id)\" class=\"btn btn-default\">Cancel</button>\n    </div>\n  </div>\n</div>\n");
$templateCache.put("plugins/alerts/html/definitionsEdit.html","<h1>{{ trigger.name }}</h1>\n<div class=\"col-md-12\">\n  <form class=\"form-horizontal\" name=\"editTriggerForm\">\n    <div class=\"form-group\">\n      <label class=\"col-md-2 control-label\" for=\"triggerName\">\n        Name\n      </label>\n      <div class=\"col-md-6\">\n        <input type=\"text\" id=\"triggerName\" ng-model=\"trigger.name\" ng-minlength=\"1\" class=\"form-control\" required>\n      </div>\n    </div>\n    <div class=\"form-group\">\n      <label class=\"col-md-2 control-label\" for=\"triggerEnabled\">\n        Enabled\n      </label>\n      <div class=\"col-md-6\">\n        <input type=\"checkbox\" id=\"triggerEnabled\" ng-model=\"trigger.enabled\" class=\"checkbox\" >\n      </div>\n    </div>\n    <div class=\"form-group\">\n      <label class=\"col-md-2 control-label\" for=\"triggerDescription\">\n        Description\n      </label>\n      <div class=\"col-md-6\">\n        <input type=\"text\" id=\"triggerDescription\" ng-model=\"trigger.description\" class=\"form-control\">\n      </div>\n    </div>\n    <div class=\"form-group\">\n      <label class=\"col-md-2 control-label\" for=\"triggerActions\">\n        Actions\n      </label>\n      <div class=\"col-md-6\">\n        <ui-select id=\"triggerActions\" multiple ng-model=\"trigger.actions\" theme=\"bootstrap\" ng-disabled=\"disabled\" close-on-select=\"false\">\n          <ui-select-match placeholder=\"Select action...\">{{$item}}</ui-select-match>\n          <ui-select-choices repeat=\"action in actions | filter:$select.search\">\n            {{ action }}\n          </ui-select-choices>\n        </ui-select>\n      </div>\n    </div>\n\n    <div class=\"form-group\">\n      <label class=\"col-md-2 control-label\" for=\"safetyEnabled\">\n        Safety Enabled\n      </label>\n      <div class=\"col-md-6\">\n        <input type=\"checkbox\" id=\"safetyEnabled\" ng-model=\"trigger.safetyEnabled\" class=\"checkbox\" >\n      </div>\n    </div>\n    <div class=\"form-group\">\n      <label class=\"col-md-2 control-label\">\n        Firing Match\n      </label>\n      <div class=\"col-md-6\">\n        <label class=\"radio-inline\">\n          <input type=\"radio\" ng-model=\"trigger.firingMatch\" class=\"radio\" value=\"ALL\"> ALL\n        </label>\n        <label class=\"radio-inline\">\n          <input type=\"radio\" ng-model=\"trigger.firingMatch\" class=\"radio\" value=\"ANY\"> ANY\n        </label>\n      </div>\n    </div>\n    <div class=\"form-group\">\n      <label class=\"col-md-2 control-label\">\n        Safety Match\n      </label>\n      <div class=\"col-md-6\">\n        <label class=\"radio-inline\">\n          <input type=\"radio\" ng-model=\"trigger.safetyMatch\" class=\"radio\" value=\"ALL\"> ALL\n        </label>\n        <label class=\"radio-inline\">\n          <input type=\"radio\" ng-model=\"trigger.safetyMatch\" class=\"radio\" value=\"ANY\"> ANY\n        </label>\n      </div>\n    </div>\n    <div class=\"form-group\">\n      <label class=\"col-md-2 control-label\">\n        <h2 class=\"h4\">Dampenings</h2>\n      </label>\n      <div class=\"col-md-6\" ng-include=\"\'plugins/alerts/html/definitionsDampening.html\'\">\n\n      </div>\n    </div>\n    <div class=\"form-group\">\n      <label class=\"col-md-2 control-label\">\n        <h2 class=\"h4\">Conditions</h2>\n      </label>\n      <div class=\"col-md-6\" ng-include=\"\'plugins/alerts/html/definitionsConditions.html\'\">\n\n      </div>\n    </div>\n    <div class=\"form-group\">\n      <div class=\"col-md-offset-2 col-md-6\">\n        <button class=\"btn btn-primary\" ng-click=\"dc.saveDefinition()\">Update Trigger</button>\n        <a class=\"btn btn-danger\" ng-click=\"dc.deleteDefinition(trigger.id, trigger.name)\">Delete</a>\n        <button type=\"button\" ng-click=\"dc.allDefinitions()\" class=\"btn btn-default\">Cancel</button>\n      </div>\n    </div>\n    <div class=\"form-group\">\n      <div class=\"col-md-offset-2 col-md-6\">\n        <alert ng-repeat=\"alertMsg in msgs\" type=\"{{alertMsg.type}}\" close=\"dc.closeAlertMsg($index)\">{{alertMsg.msg}}</alert>\n      </div>\n    </div>\n  </form>\n</div>\n\n\n");
$templateCache.put("plugins/alerts/html/definitionsNew.html","<h1>New Trigger Definition</h1>\n<div class=\"col-md-12\">\n  <form class=\"form-horizontal\" name=\"newTriggerForm\" ng-submit=\"dc.saveDefinition()\">\n    <div class=\"form-group\">\n      <label class=\"col-md-2 control-label\" for=\"triggerName\">\n        Name\n      </label>\n      <div class=\"col-md-6\">\n        <input type=\"text\" id=\"triggerName\" ng-model=\"trigger.name\" ng-minlength=\"1\" class=\"form-control\" required>\n      </div>\n    </div>\n    <div class=\"form-group\">\n      <label class=\"col-md-2 control-label\" for=\"triggerEnabled\">\n        Enabled\n      </label>\n      <div class=\"col-md-6\">\n        <input type=\"checkbox\" id=\"triggerEnabled\" ng-model=\"trigger.enabled\" class=\"checkbox\" >\n      </div>\n    </div>\n    <div class=\"form-group\">\n      <label class=\"col-md-2 control-label\" for=\"triggerDescription\">\n        Description\n      </label>\n      <div class=\"col-md-6\">\n        <input type=\"text\" id=\"triggerDescription\" ng-model=\"trigger.description\" class=\"form-control\">\n      </div>\n    </div>\n    <div class=\"form-group\">\n      <label class=\"col-md-2 control-label\" for=\"triggerActions\">\n        Actions\n      </label>\n      <div class=\"col-md-6\">\n        <ui-select id=\"triggerActions\" multiple ng-model=\"trigger.actions\" theme=\"bootstrap\" ng-disabled=\"disabled\" close-on-select=\"false\">\n          <ui-select-match placeholder=\"Select action...\">{{$item}}</ui-select-match>\n          <ui-select-choices repeat=\"action in actions | filter:$select.search\">\n            {{ action }}\n          </ui-select-choices>\n        </ui-select>\n      </div>\n    </div>\n    <div class=\"form-group\">\n      <div class=\"col-md-offset-2 col-md-6\">\n        <button type=\"submit\" class=\"btn btn-primary\">Create Trigger</button>\n        <button type=\"button\" ng-click=\"dc.allDefinitions()\" class=\"btn btn-default\">Cancel</button>\n      </div>\n    </div>\n    <div class=\"form-group\">\n      <div class=\"col-md-offset-2 col-md-6\">\n        <alert ng-repeat=\"alertMsg in msgs\" type=\"{{alertMsg.type}}\" close=\"dc.closeAlertMsg($index)\">{{alertMsg.msg}}</alert>\n      </div>\n    </div>\n  </form>\n</div>\n");
$templateCache.put("plugins/sidebar/html/sidebar.html","<!-- <div class=\"col-sm-3 col-md-2 sidebar-pf sidebar-pf-left sidebar-pf-dark sidebar-pf-big-icons sidebar-pf-fixed\">\n  <nav>\n    <ul class=\"nav nav-pills nav-stacked nav-dark nav-big-icons\" ng-hide=\"isSinglePage()\">\n      <li ng-class=\"getClass(\'/metrics/availability\')\"><a ng-href=\"/metrics/availability/{{hkParams.resourceId}}/{{hkParams.timeOffset}}/{{hkEndTimestamp}}\"><i class=\"fa fa-arrow-up\"></i>Availability</a></li>\n      <li ng-class=\"getClass(\'/metrics/response-time\')\"><a ng-href=\"/metrics/response-time/{{hkParams.resourceId}}/{{hkParams.timeOffset}}/{{hkEndTimestamp}}\"><i class=\"fa fa-line-chart\"></i>Response Time</a></li>\n      <li ng-class=\"getClass(\'/metrics/alerts\')\"><a ng-href=\"/metrics/alerts/{{hkParams.resourceId}}/{{hkParams.timeOffset}}/{{hkEndTimestamp}}\"><i class=\"fa fa-flag\"></i>Alerts</a></li>\n    </ul>\n    <ul class=\"nav nav-pills nav-stacked nav-dark nav-big-icons\" du-spy-context  ng-show=\"isSinglePage()\">\n      <li du-scrollspy=\"secav\" offset=\"135\" class=\"active\"><a href=\"#secav\" du-smooth-scroll offset=\"135\"><i class=\"fa fa-arrow-up\"></i>Availability</a></li>\n      <li du-scrollspy=\"secrt\" offset=\"125\"><a href=\"#secrt\" du-smooth-scroll offset=\"125\"><i class=\"fa fa-line-chart\"></i>Response Time</a></li>\n      <li du-scrollspy=\"secal\" offset=\"125\"><a href=\"#secal\" du-smooth-scroll offset=\"125\"><i class=\"fa fa-flag\"></i>Alerts</a></li>\n    </ul>\n  </nav>\n</div> -->\n\n<div class=\"hk-screen-top-nav\">\n  <div>\n    <div class=\"row hk-top-row\">\n      <div class=\"col-xs-6\">\n        <a ng-show=\"isAppServerPage()\" href=\"/hawkular-ui/app/app-list\" class=\"back\">« All Application Servers</a>\n        <a ng-hide=\"isAppServerPage()\" href=\"/hawkular-ui/url/url-list\" class=\"back\">« All URLs</a>\n      </div>\n      <div class=\"col-xs-6\">\n        <div class=\"hk-date-range dropdown\">\n          <i class=\"fa fa-calendar\"></i>\n          <div class=\"hk-input\" dropdown-toggle>\n            {{offsetName}} <span class=\"additional-info\">({{getFormattedDate()}})</span>\n          </div>\n          <div class=\"dropdown-menu infotip bottom-right\">\n            <div class=\"arrow\"></div>\n            <div class=\"dropdown-menu-content\">\n              <span class=\"hk-label\">Last</span>\n              <div class=\"btn-group\">\n                <button type=\"button\" class=\"btn btn-default\" ng-class=\"{\'active\': offsetName === \'Last Hour\'}\" ng-click=\"setRange({hour: 1})\">1h</button>\n                <button type=\"button\" class=\"btn btn-default\" ng-class=\"{\'active\': offsetName === \'Last 12 Hours\'}\" ng-click=\"setRange({hours: 12})\">12h</button>\n                <button type=\"button\" class=\"btn btn-default\" ng-class=\"{\'active\': offsetName === \'Last Day\'}\" ng-click=\"setRange({day: 1})\">Day</button>\n                <button type=\"button\" class=\"btn btn-default\" ng-class=\"{\'active\': offsetName === \'Last Week\'}\" ng-click=\"setRange({week: 1})\">Week</button>\n                <button type=\"button\" class=\"btn btn-default\" ng-class=\"{\'active\': offsetName === \'Last Month\'}\" ng-click=\"setRange({month: 1})\">Month</button>\n                <button type=\"button\" class=\"btn btn-default\" ng-class=\"{\'active\': offsetName === \'Last Year\'}\" ng-click=\"setRange({year: 1})\">Year</button>\n              </div>\n            </div>\n          </div>\n        </div>\n      </div>\n    </div>\n    <div class=\"hk-heading\">\n      <h1 ng-init=\"isAppServerPage() ? getAppServerFromId(hkParams.resourceId) : getUrlFromId(hkParams.resourceId)\">{{resourceName}}</h1>\n    </div>\n    <div ng-transclude></div>\n  </div>\n</div>\n\n");
$templateCache.put("plugins/topbar/html/topbar.html","<ul class=\"nav navbar-nav navbar-primary\">\n  <li ng-class=\"getClass(\'/hawkular-ui/url/\')\">\n    <a href=\"/hawkular-ui/url/url-list\">URLs</a>\n  </li>\n  <li ng-class=\"getClass(\'/hawkular-ui/app/\')\">\n    <a href=\"/hawkular-ui/app/app-list\">Application Servers</a>\n  </li>\n</ul>\n");
$templateCache.put("plugins/inventory/html/inventory.html","<div ng-controller=\"Inventory.InventoryController\">\n\n    <hr>\n\n    <!-- Dropdown View -->\n    <div class=\"row\">\n        <div class=\" col-md-4\">\n            <div class=\"panel panel-default\">\n                <div class=\"panel-heading\">\n                    <h3 class=\"panel-title\"><i class=\"fa fa-user\"></i> Tenant</h3>\n                </div>\n                <div class=\"panel-body\">\n                    <form role=\"form\" class=\"search-pf has-button\">\n                        <div class=\"form-group has-clear\">\n                            <div class=\"search-pf-input-group\">\n                                <label for=\"tenantId\" class=\"sr-only\">Tenant</label>\n                                <input id=\"tenantId\" type=\"search\" class=\"form-control\" placeholder=\"Tenant ID\" ng-model=\"tenantId\" autofocus>\n                                <button type=\"button\" class=\"clear\" aria-hidden=\"true\" ng-click=\"tenantId = \'\'\"><span class=\"pficon pficon-close\"></span></button>\n                            </div>\n                        </div>\n                        <div class=\"form-group\">\n                            <button class=\"btn btn-default\" type=\"button\" ng-click=\"queryResources()\"><span class=\"fa fa-search\"></span></button>\n                        </div>\n                    </form>\n                </div>\n            </div>\n        </div>\n        <div class=\" col-md-4\">\n            <div class=\"panel panel-default\">\n                <div class=\"panel-heading\">\n                    <h3 class=\"panel-title\"><i class=\"fa fa-cube\"></i> Resource <span class=\"pull-right\" ng-show=\"tenantId && resources\"><a href=\"#\" ng-click=\"showTable = !showTable\"><span ng-hide=\"showTable\">Show</span><span ng-show=\"showTable\">Hide</span> all</a></span></h3>\n                </div>\n                <div class=\"panel-body\">\n                    <select class=\"form-control\" ng-options=\"resource.id as resource.properties.url + \' (\' +resource.id + \')\' for resource in resources\" ng-model=\"resourceId\" ng-disabled=\"!tenantId || !resources\" ng-hide=\"resources.length === 0\" ng-change=\"queryMetrics()\"></select>\n                    <span ng-show=\"resources.length === 0\"><i class=\"fa fa-warning\"></i> No Resources Available</span>\n                </div>\n            </div>\n        </div>\n        <div class=\" col-md-4\">\n            <div class=\"panel panel-default\">\n                <div class=\"panel-heading\">\n                    <h3 class=\"panel-title\"><i class=\"fa fa-line-chart\"></i> Metric</h3>\n                </div>\n                <div class=\"panel-body\">\n                    <select class=\"form-control\" ng-options=\"metric.id as metric.id for metric in metrics\" ng-model=\"metricId\" ng-disabled=\"!tenantId || !resourceId\" ng-hide=\"metrics.length === 0\"></select>\n                    <span ng-show=\"metrics.length === 0\"><i class=\"fa fa-warning\"></i> No Metrics Available</span>\n                </div>\n            </div>\n        </div>\n    </div>\n    <div class=\"row\">\n        <div class=\"col-md-offset-10\">\n            <a href=\"\" class=\"btn btn-primary btn-lg\" ng-click=\"showMetric()\"><i class=\"fa fa-line-chart\" ng-disabled=\"!metricId\"></i> Show Metric</a>\n        </div>\n    </div>\n\n    <!-- Table View -->\n    <div class=\"row\" ng-show=\"tenantId && showTable\">\n        <div class=\"col-md-12\">\n            <h1>Resources</h1>\n            <table class=\"table table-condensed\">\n                <thead>\n                    <th>Resource ID</th>\n                    <th>Resource Type</th>\n                    <th>Properties</th>\n                    <th>Metrics</th>\n                </thead>\n                <tr ng-repeat=\"resource in resources\">\n                    <td>{{resource.id}}</td>\n                    <td>{{resource.resourceTypeId}}</td>\n                    <td>\n                        <dl class=\"dl-horizontal\" ng-repeat=\"(name, value) in resource.properties\">\n                          <dt>{{name}}</dt>\n                          <dd>{{value}}</dd>\n                        </dl>\n                    </td>\n                    <td >\n                        <table>\n                            <tr ng-repeat=\"metric in resource.metrics\">\n                                <td>{{metric.id}} <button class=\"btn btn-primary btn-xs\" ng-click=\"showMetric(tenantId, resource.id, metric.id)\"> <i class=\"fa fa-area-chart\"></i> </button></td>\n                            </tr>\n                        </table>\n                    </td>\n                </tr>\n            </table>\n        </div>\n    </div>\n\n    <!-- Chart View -->\n    <div class=\"row\" ng-show=\"metricData\">\n        <hr>\n        <div class=\"col-md-12\">\n            <div class=\"panel panel-default\">\n                <div class=\"panel-heading\">\n                    <h3 class=\"panel-title\">{{metricData.tenantId}} / {{metricData.name}} <span class=\"pull-right\" ng-click=\"closeChart()\"><i class=\"pficon pficon-close\"></i></span></h3>\n                </div>\n                <div class=\"panel-body\" style=\"height: 280px;\">\n                  <hawkular-chart data=\"{{metricData.data}}\" chart-type=\"bar\" chart-height=\"250\" chart-width=\"1000px\"></hawkular-chart>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n");
$templateCache.put("plugins/metrics/html/add-url.html","<div ng-controller=\"HawkularMetrics.AddUrlController as vm\">\n  <div class=\"hk-fade-in\" ng-class=\"{\'hk-urls-list text-center\': vm.resourceList.length === 0}\">\n    <h1 class=\"text-center\">Hello {{userDetails.firstName}}!</h1>\n    <i class=\"fa fa-line-chart\" ng-show=\"vm.resourceList.length === 0\"></i>\n    <h2 ng-show=\"vm.resourceList.length === 0\">Collect metrics from a website that you want to monitor.</h2>\n    <form class=\"form-horizontal hk-add-url\" name=\"addUrlForm\" role=\"form\" novalidate ng-submit=\"vm.addUrl(vm.resourceUrl)\">\n      <div class=\"form-group input\">\n        <div class=\"col-lg-6 col-sm-8 col-xs-12 hk-align-center\">\n          <div class=\"input-group input-group-lg\">\n            <input type=\"url\" class=\"form-control\" name=\"resourceUrl\" ng-model=\"vm.resourceUrl\"\n                   ng-model-options=\"{ updateOn: \'default blur\'}\"\n                   placeholder=\"Enter a website URL (e.g.: http://www.website.com)\" required>\n            <span class=\"input-group-btn\">\n              <button class=\"btn btn-primary\" type=\"submit\" ng-disabled=\"addUrlForm.$invalid || vm.addProgress\">\n               <div ng-show=\"vm.addProgress\" class=\"spinner spinner-sm\"></div>\n              Add URL\n              </button>\n            </span>\n          </div>\n          <span class=\"help-block\"\n                  ng-show=\"addUrlForm.resourceUrl.$dirty && addUrlForm.resourceUrl.$invalid\">The URL you entered is not valid. Please enter a valid URL.</span>\n\n        </div>\n      </div>\n    </form>\n  </div>\n\n  <h2 ng-show=\"vm.resourceList.length > 0\" class=\"text-center hk-fade-in\">Current status of your websites</h2>\n\n  <div class=\"row hk-urls-list-labels hk-fade-in\" ng-show=\"vm.resourceList.length > 0\">\n    <div class=\"col-sm-6 text-left\">\n      <button class=\"btn btn-link\" tooltip=\"Sort\" tooltip-trigger tooltip-placement=\"top\" ng-click=\"vm.reverse = !vm.reverse\">\n        URL (A-Z) <i class=\"fa\" ng-class=\"vm.reverse ? \'fa-angle-up\' : \'fa-angle-down\'\"></i>\n      </button>\n    </div>\n    <div class=\"col-sm-6\">\n      <span class=\"hk-update pull-right\" tooltip-trigger tooltip-placement=\"top\" tooltip=\"Last update\"><i class=\"fa fa-clock-o\"></i>{{vm.lastUpdateTimestamp | date:\'mediumTime\'}}</span>\n    </div>\n  </div>\n\n  <div class=\"hk-fade-in\">\n    <div class=\"hk-url-item\" ng-repeat=\"res in vm.resourceList | orderBy:\'properties.url\':vm.reverse\">\n      <div class=\"hk-url-heading\">\n        <a href=\"/hawkular-ui/url/availability/{{res.id}}\">{{res.properties.url}}</a>\n      </div>\n      <div class=\"panel panel-default hk-summary\">\n        <div class=\"row\">\n          <div class=\"col-sm-3 hk-summary-item\">\n            <a href=\"/hawkular-ui/url/alerts/{{res.id}}\">\n              <span class=\"hk-data\">{{(vm.alertList|filter:{triggerId: (res.id + \'_trigger\')}).length || 0}} <i class=\"fa fa-flag\" ng-show=\"(vm.alertList|filter:{triggerId: (res.id + \'_trigger\')}).length > 0\"></i></span>\n              <span class=\"hk-item\">Unresolved Alerts</span>\n            </a>\n          </div>\n          <div class=\"col-sm-3 hk-summary-item\">\n            <a href=\"/hawkular-ui/url/availability/{{res.id}}\">\n              <span class=\"hk-data\" ng-show=\"res.responseTime.length > 0\"><i class=\"fa \" ng-class=\"res.isUp ? \'fa-arrow-up\' : \'fa-arrow-down\'\"></i>{{res.isUp ? \'Up\' : \'Down\'}}</span>\n              <span class=\"hk-data spinner\" ng-hide=\"res.responseTime.length > 0\" popover=\"Your data is being collected. You should see something in a few seconds.\" popover-trigger=\"mouseenter\" popover-placement=\"bottom\"></span>\n              <span class=\"hk-item\">Current Availability</span>\n            </a>\n          </div>\n          <div class=\"col-sm-3 hk-summary-item\">\n            <a href=\"/hawkular-ui/url/availability/{{res.id}}\">\n              <span class=\"hk-data\" ng-show=\"res.lastDowntime > 0\" am-time-ago=\"res.lastDowntime\"></span>\n              <span class=\"hk-data\" ng-show=\"res.lastDowntime <= 0\">n/a</span>\n              <span class=\"hk-item\">Last Downtime</span>\n            </a>\n          </div>\n          <div class=\"col-sm-3 hk-summary-item\">\n            <a href=\"/hawkular-ui/url/response-time/{{res.id}}\">\n              <span class=\"hk-data\" ng-show=\"res.responseTime.length > 0 && res.responseTime[0].value >= 0\">{{res.responseTime[0].value}} <span>ms</span></span>\n              <span class=\"hk-data\" ng-show=\"res.responseTime.length > 0 && res.responseTime[0].value < 0\">n/a</span>\n              <span class=\"hk-data spinner\" ng-hide=\"res.responseTime.length > 0\" popover=\"Your data is being collected. You should see something in a few seconds.\" popover-trigger=\"mouseenter\" popover-placement=\"bottom\"></span>\n              <span class=\"hk-item\">Current Response Time</span>\n            </a>\n          </div>\n        </div>\n        <button class=\"btn btn-link hk-delete\" tooltip=\"Remove\" tooltip-trigger tooltip-placement=\"top\" ng-click=\"vm.deleteResource(res)\"><i class=\"fa fa-trash-o\"></i></button>\n      </div>\n    </div>\n  </div>\n\n  <hk-pagination resource-list=\"vm.resourceList\" current-page=\"vm.resCurPage\" page-setter=\"vm.setPage(pageNumber)\"\n      per-page=\"vm.resPerPage\" headers=\"vm.headerLinks\"></hk-pagination>\n\n</div>\n");
$templateCache.put("plugins/metrics/html/alerts-setup.html","<div class=\"modal-header\">\n  <button type=\"button\" class=\"close\" ng-click=\"mas.cancel()\">\n    <span class=\"pficon pficon-close\"></span>\n  </button>\n  <h4 class=\"modal-title\">Alert Settings</h4>\n</div>\n<div class=\"modal-body alert-settings\">\n  <form class=\"form-horizontal\" name=\"mas.alertsSetup\">\n    <fieldset>\n      <legend>Contact</legend>\n      <p>Receive email notifications in the following address when the alert conditions are met.</p>\n      <div class=\"form-group\">\n        <label class=\"col-md-3 control-label\" for=\"email\">Email</label>\n        <div class=\"col-md-6\">\n          <input type=\"text\" id=\"email\" class=\"form-control\"  ng-model=\"mas.trigger_thres.actions.email[0]\"\n                 ng-change=\"mas.alertSettingTouch()\">\n          <span class=\"help-block\">Send alerts to this email address.</span>\n        </div>\n      </div>\n    </fieldset>\n    <fieldset>\n      <legend>Response Time</legend>\n      <div class=\"form-group onffswitch-form-group\">\n        <label class=\"col-md-3 control-label\" for=\"trigger_thres.enabled\">Status</label>\n        <div class=\"onoffswitch-container\">\n          <div class=\"onoffswitch\">\n            <input type=\"checkbox\" id=\"trigger_thres.enabled\" class=\"onoffswitch-checkbox\"\n                   ng-model=\"mas.trigger_thres.enabled\" ng-change=\"mas.alertSettingTouch()\">\n            <label class=\"onoffswitch-label\" for=\"trigger_thres.enabled\">\n              <span class=\"onoffswitch-inner\">\n                <span class=\"onoffswitch-active ng-binding\">ON</span>\n                <span class=\"onoffswitch-inactive ng-binding\">OFF</span>\n              </span>\n              <span class=\"onoffswitch-switch\"></span>\n            </label>\n          </div>\n        </div>\n      </div>\n      <div ng-show=\"mas.trigger_thres.enabled\">\n        <div class=\"form-group\">\n          <label class=\"col-md-3 control-label\" for=\"time\">Time (maximum)</label>\n          <div class=\"col-md-9 inline-row\">\n            <div class=\"input-group input-addon\">\n              <input type=\"number\" class=\"form-control\" placeholder=\"Time\" id=\"time\"\n                     ng-model=\"mas.trigger_thres_cond[0].threshold\" ng-change=\"mas.alertSettingTouch()\">\n              <span class=\"input-group-addon\">miliseconds</span>\n            </div>\n          </div>\n        </div>\n        <div class=\"form-group\">\n          <label class=\"col-md-3 control-label\">Notification Rate</label>\n          <div class=\"col-md-9\">\n            <div class=\"radio\">\n              <label>\n                <input type=\"radio\" name=\"notification\" id=\"every-time\" ng-value=\"false\"\n                       ng-change=\"mas.alertSettingTouch()\"\n                       ng-model=\"mas.thresDampDurationEnabled\" ng-click=\"mas.disableDuration()\" checked=\"\">\n                Every time the maximum time is exceeded.\n              </label>\n            </div>\n            <div class=\"radio\">\n              <label>\n                <input type=\"radio\" name=\"notification\" id=\"greater-time\" ng-value=\"true\"\n                       ng-change=\"mas.alertSettingTouch()\"\n                       ng-model=\"mas.thresDampDurationEnabled\" ng-click=\"mas.enableDuration()\" >\n                Only when exceeded for greater than\n              </label>\n            </div>\n            <div class=\"input-group input-select indented\">\n              <input type=\"number\" class=\"form-control\" placeholder=\"Duration\" ng-model=\"mas.responseDuration\"\n                     ng-disabled=\"!mas.thresDampDurationEnabled\" ng-change=\"mas.alertSettingTouch()\">\n              <select pf-select ng-model=\"mas.responseUnit\" id=\"responseUnit\"\n                      ng-disabled=\"!mas.thresDampDurationEnabled\"\n                      ng-options=\"item.value as item.label for item in mas.timeUnits\"\n                      ng-change=\"mas.changeResponseTimeUnits()\"></select>\n            </div>\n          </div>\n        </div>\n      </div>\n    </fieldset>\n    <fieldset>\n      <legend>Downtime</legend>\n      <div class=\"form-group onffswitch-form-group\">\n        <label class=\"col-md-3 control-label\" for=\"trigger_avail.enabled\">Status</label>\n        <div class=\"onoffswitch-container\">\n          <div class=\"onoffswitch\">\n            <input type=\"checkbox\" id=\"trigger_avail.enabled\" name=\"trigger_avail.enabled\" class=\"onoffswitch-checkbox\"\n                   ng-model=\"mas.trigger_avail.enabled\" ng-change=\"mas.alertSettingTouch()\">\n            <label class=\"onoffswitch-label\" for=\"trigger_avail.enabled\">\n              <span class=\"onoffswitch-inner\">\n                <span class=\"onoffswitch-active ng-binding\">ON</span>\n                <span class=\"onoffswitch-inactive ng-binding\">OFF</span>\n              </span>\n              <span class=\"onoffswitch-switch\"></span>\n            </label>\n          </div>\n        </div>\n      </div>\n      <div ng-show=\"mas.trigger_avail.enabled\">\n        <div class=\"form-group\">\n          <label class=\"col-md-3 control-label\" for=\"downtimeDuration\">Duration (maximum)</label>\n          <div class=\"col-md-6 inline-row\">\n            <div class=\"input-group duration\">\n              <input type=\"number\" class=\"form-control\" placeholder=\"Duration\" ng-model=\"mas.downtimeDuration\"\n                     ng-change=\"mas.changeDowntimeTimeUnits()\" id=\"downtimeDuration\"\n                     ng-change=\"mas.alertSettingTouch()\">\n              <select pf-select ng-model=\"mas.downtimeUnit\" id=\"downtimeUnit\"\n                      ng-options=\"item.value as item.label for item in mas.timeUnits\"\n                      ng-change=\"mas.changeDowntimeTimeUnits()\"></select>\n            </div>\n          <span class=\"help-block\">Send alerts when the downtime lasts\n            more than {{mas.downtimeDuration}} {{mas.timeUnitsDict[mas.downtimeUnit]}}.</span>\n          </div>\n        </div>\n      </div>\n    </fieldset>\n  </form>\n</div>\n<div class=\"modal-footer\">\n  <button type=\"button\" class=\"btn btn-primary\" ng-click=\"mas.save()\"\n          ng-disabled=\"!mas.alertsSetup.$valid || !mas.isSettingChange || mas.saveProgress\">\n    <div ng-show=\"mas.saveProgress\" class=\"spinner spinner-xs hk-modal-spinner\"></div>Save</button>\n  <button type=\"button\" class=\"btn btn-default\" ng-click=\"mas.cancel()\">Cancel</button>\n</div>\n");
$templateCache.put("plugins/metrics/html/alerts-view.html","<div class=\"blank-slate-pf\" ng-show=\"mac.alertList.$resolved && mac.alertList.length === 0\">\n  <div class=\"blank-slate-pf-icon\">\n    <i class=\"fa fa-flag\"></i>\n  </div>\n  <h1>No alerts.</h1>\n</div>\n<div class=\"hk-alerts-feedback\" hk-clear-notifications=\"hkNotifications.alerts\">\n  <div ng-repeat=\"notification in hkNotifications.alerts\">\n    <div ng-switch=\"notification.type\">\n      <div class=\"alert alert-success\" ng-switch-when=\"success\">\n        <span class=\"pficon pficon-ok\"></span>\n        <strong>{{notification.message}}</strong>\n      </div>\n\n      <div class=\"alert alert-danger\" ng-switch-when=\"error\">\n        <span class=\"pficon-layered\">\n          <span class=\"pficon pficon-error-octagon\"></span>\n          <span class=\"pficon pficon-error-exclamation\"></span>\n        </span>\n        <strong>Error:</strong> {{notification.message}}</a>\n      </div>\n    </div>\n  </div>\n</div>\n\n<!--\n<div class=\"info-top clearfix\">\n  <p class=\"settings pull-left\"><a href=\"#\" ng-click=\"mac.openSetup()\"><i class=\"fa fa-cog\"></i>Alert Settings</a></p>\n  <p class=\"pull-right\"><strong>{{(mac.alertList | filter:timeFilter).length}} alerts</strong> last week.</p>\n</div>\n-->\n<div class=\"clearfix\">\n  <div ng-repeat=\"alert in mac.alertList | filter:timeFilter | orderBy: \'-start\'\">\n\n    <div class=\"panel panel-default alert alert-danger\" ng-if=\"alert.type==\'AVAILABILITY\'\">\n      <div class=\"hk-alert-icon\">\n        <i class=\"fa fa-flag\"></i>\n      </div>\n      <div class=\"hk-date\">\n        {{alert.start | date:\'medium\' }}\n      </div>\n      <div class=\"hk-event\">\n        Server <strong>down</strong> for {{(alert.end - alert.start)/1000 | number: 0}} seconds (until\n        <span ng-if=\"alert.isThisYear && alert.isToday\">{{alert.end | date:\'shortTime\' }}).</span>\n        <span ng-if=\"alert.isThisYear && !alert.isToday\">{{alert.end | date:\'MMM d, h:mm:ss a\' }}).</span>\n        <span ng-if=\"!alert.isThisYear\">{{alert.end | date:\'medium\' }}).</span>\n      </div>\n    </div>\n\n    <div class=\"panel panel-default alert alert-danger\" ng-if=\"alert.type==\'THRESHOLD\'\">\n      <div class=\"hk-alert-icon\">\n        <i class=\"fa fa-flag\"></i>\n      </div>\n      <div class=\"hk-date\">\n        {{alert.start | date:\'medium\' }}\n      </div>\n      <div class=\"hk-event\">\n        <strong>Response time</strong> was above the threshold ({{alert.threshold | number: 0}} ms) for {{(alert.end - alert.start) / 1000.0 | number: 0}} seconds (until\n        <span ng-if=\"alert.isThisYear && alert.isToday\">{{alert.end | date:\'shortTime\' }}).</span>\n        <span ng-if=\"alert.isThisYear && !alert.isToday\">{{alert.end | date:\'MMM d, h:mm:ss a\' }}).</span>\n        <span ng-if=\"!alert.isThisYear\">{{alert.end | date:\'medium\' }}).</span>\n        The average response time was {{alert.avg  | number: 0}} ms.\n      </div>\n\n      <div class=\"alert-resolver\">\n        <a ng-click=\"mac.alertResolve(alert, $index)\" tooltip=\"Mark as resolved\"\n           tooltip-placement=\"top\"\n           tooltip-trigger=\"mouseenter\"\n           tooltip-popup-delay=\"500\">\n          <i class=\"fa\" ng-class=\"{\'fa-check-square-o\': hover, \'fa-square-o\': !hover}\"\n             ng-mouseenter=\"hover = true\"\n             ng-mouseleave=\"hover = false\">\n          </i>\n        </a>\n      </div>\n    </div>\n  </div>\n</div>\n<div class=\"clearfix\" ng-show=\"mac.alertList.length > 0\">\n  <button class=\"btn btn-danger pull-right\" ng-click=\"mac.resolveAll()\" ng-disabled=\"mac.isResolvingAll\">\n    <span class=\"fa fa-check-square-o\" style=\"color:white\"></span>\n    Resolve all</button>\n</div>");
$templateCache.put("plugins/metrics/html/alerts.html","<div class=\"hk-screen-content\" ng-controller=\"MetricsAlertController as mac\">\n  <hawkular-sidebar ng-controller=\"Sidebar.SidebarController\">\n    <div class=\"hk-nav-tabs-container\">\n      <ul class=\"nav nav-tabs nav-tabs-pf\">\n        <li class=\"active\"><a href=\"/hawkular-ui/url/alerts/{{mac.$routeParams.resourceId}}/{{mac.$routeParams.timeOffset}}\" class=\"hk-alerts\">All Alerts</a></li>\n        <li><a href=\"/hawkular-ui/url/availability/{{mac.$routeParams.resourceId}}/{{mac.$routeParams.timeOffset}}\" class=\"hk-availability\">Availability</a></li>\n        <li><a href=\"/hawkular-ui/url/response-time/{{mac.$routeParams.resourceId}}/{{mac.$routeParams.timeOffset}}\" class=\"hk-response-time\">Response Time</a></li>\n      </ul>\n    </div>\n  </hawkular-sidebar>\n\n  <section id=\"hk-alerts\" class=\"hk-tab-content\">\n    <div class=\"hk-info-top clearfix\">\n      <h3 class=\"pull-left\">Alerts <span>({{(mac.alertList | filter:timeFilter).length}})</span></h3>\n      <span class=\"hk-settings pull-right\"><a href=\"#\" ng-click=\"mac.openSetup()\"><i class=\"fa fa-cog\"></i>Alert Settings</a></span>\n    </div>\n    <div ng-include=\"\'plugins/metrics/html/alerts-view.html\'\"></div>\n  </section>\n</div>\n");
$templateCache.put("plugins/metrics/html/app-server-list.html","<div class=\"hk-application-servers\" ng-controller=\"HawkularMetrics.AppServerListController as vm\">\n\n  <h1 class=\"text-center\">{{userDetails.firstName}}\'s application servers</h1>\n\n  <h3 class=\"pull-left\">Current Status</h3>\n  <span class=\"hk-update pull-right\" tooltip-trigger tooltip-placement=\"top\" tooltip=\"Last update\"><i class=\"fa fa-clock-o\"></i>{{vm.lastUpdateTimestamp | date:\'mediumTime\'}}</span>\n\n  <div class=\"panel panel-default hk-summary\">\n    <div class=\"row\">\n      <!--\n      <div class=\"col-sm-2 hk-summary-item\">\n        <span class=\"hk-data\">0 <i class=\"fa fa-flag\" ng-show=\"alertsNumTBD > 0\"></i></span>\n        <span class=\"hk-item\">Alerts</span>\n      </div>\n      -->\n      <div class=\"col-sm-2 hk-summary-item\">\n        <span class=\"hk-data\">{{vm.resourceList.length}}</span>\n        <span class=\"hk-item\">Servers</span>\n      </div>\n      <div class=\"col-sm-2 hk-summary-item\">\n        <a href=\"#\">\n          <span class=\"hk-data\">{{(vm.resourceList|filter:{state: \'up\'}:true).length}} <i class=\"fa fa-arrow-up\"></i></span>\n          <span class=\"hk-item\">Up</span>\n        </a>\n      </div>\n      <div class=\"col-sm-2 hk-summary-item\">\n        <a href=\"#\">\n          <span class=\"hk-data\">{{(vm.resourceList|filter:{state: \'down\'}:true).length}} <i class=\"fa fa-arrow-down\"></i></span>\n          <span class=\"hk-item\">Down</span>\n        </a>\n      </div>\n      <div class=\"col-sm-2 hk-summary-item\">\n        <a href=\"#\">\n          <span class=\"hk-data\">{{(vm.resourceList|filter:{state: \'unknown\'}:true).length}} <i class=\"fa fa-chain-broken\"></i></span>\n          <span class=\"hk-item\">Unknown</span>\n        </a>\n      </div>\n      <div class=\"col-sm-2 hk-summary-item\">\n        <a href=\"#\">\n          <span class=\"hk-data\">{{(vm.resourceList|filter:{state: \'starting\'}:true).length}} <i class=\"fa fa-spinner\"></i></span>\n          <span class=\"hk-item\">Starting</span>\n        </a>\n      </div>\n      <div class=\"col-sm-2 hk-summary-item\">\n        <a href=\"#\">\n          <span class=\"hk-data\">{{(vm.resourceList|filter:{state: \'restart required\'}:true).length}} <i class=\"fa fa-repeat\"></i></span>\n          <span class=\"hk-item\">Restart Required</span>\n        </a>\n      </div>\n    </div>\n  </div>\n\n  <h3>Application Servers ({{vm.resourceList.length}})</h3>\n\n  <div class=\"blank-slate-pf\" ng-show=\"vm.resourceList.$resolved && vm.resourceList.length === 0\">\n    <div class=\"blank-slate-pf-icon\">\n      <i class=\"fa fa-server\"></i>\n    </div>\n    <h1>No application servers set up.</h1>\n  </div>\n\n  <div ng-show=\"vm.resourceList.length > 0\">\n    <div class=\"dataTables_header\"><div id=\"DataTables_Table_0_filter\" class=\"dataTables_filter\"><label><input type=\"search\" ng-model=\"vm.search\" aria-controls=\"DataTables_Table_0\"></label></div>\n\n    <div class=\"dataTables_info\" id=\"DataTables_Table_0_info\" role=\"status\" aria-live=\"polite\">Showing <b>1</b> to <b>{{(vm.resourceList | filter:vm.search).length}}</b> of <b>{{vm.resourceList.length}}</b> Items</div></div>\n    <table class=\"datatable table table-striped table-bordered table-checkbox\" ng-show=\"vm.resourceList.length > 0\">\n      <thead>\n        <tr>\n          <th>State</th>\n          <th>Application Server Name <span class=\"label label-default label-alert pull-right\" ng-show=\"alertsNumTBD > 0\" tooltip-trigger tooltip-placement=\"top\" tooltip=\"Total alerts\">{{alertsNumTBD}}</span></th>\n          <th>Type</th>\n          <th>Host</th>\n          <!-- <th>Custom Tags</th> -->\n        </tr>\n      </thead>\n      <tbody>\n        <tr class=\"odd\"><td valign=\"top\" colspan=\"5\" class=\"dataTables_empty\" ng-show=\"vm.search && (vm.resourceList | filter:vm.search).length === 0\"><p>Suggestions</p><ul><li>Check the syntax of the search term.</li><li>Check that the correct menu option is chosen (token ID vs. user ID).</li><li>Use wildcards (* to match zero or more characters or ? to match a single character).</li><li>Clear the search field, then click Search to return to the 20 most recent records.</li></ul></td></tr>\n        <tr ng-repeat=\"res in vm.resourceList | filter:vm.search | orderBy:\'properties.url\':vm.reverse\">\n          <td class=\"state\">\n            <i class=\"fa fa-arrow-up\" ng-show=\"res.state === \'up\'\"></i>\n            <i class=\"fa fa-arrow-down\" ng-show=\"res.state === \'down\'\"></i>\n            <i class=\"fa fa-chain-broken\" ng-show=\"res.state === \'unknown\'\"></i>\n            <i class=\"fa fa-spinner fa-spin\" ng-show=\"res.state === \'starting\'\"></i>\n            <i class=\"fa fa-repeat\" ng-show=\"res.state === \'restart required\'\"></i>\n            <p ng-hide=\"res.state\"><span class=\"spinner spinner-sm spinner-inline\"></span> <span class=\"fetching\">Fetching state...</span></p>\n            {{res.state | firstUpper}}\n          </td>\n          <!--<td><a href=\"/hawkular-ui/app/app-details/{{res.id | urlEncode}}\">{{res.id | limitTo14 : res.id.length-4 : 1}}</a> <a href=\"/hawkular-ui/app/app-details/{{res.id | urlEncode}}\" class=\"pull-right\"><span class=\"label label-danger label-alert\" tooltip-trigger tooltip-placement=\"top\" tooltip=\"Server alerts\" ng-show=\"res.alerts.length > 0\">{{res.alerts.length}}</span></a></td>-->\n          <td>{{res.id | limitTo14 : res.id.length-4 : 1}}<span class=\"label label-danger label-alert\" tooltip-trigger tooltip-placement=\"top\" tooltip=\"Server alerts\" ng-show=\"res.alerts.length > 0\">{{res.alerts.length}}</span></td>\n          <td>{{res.type.id}}</td>\n          <td>{{res.properties.name | limitTo14 : res.properties.name.length-17 : 16}}</td>\n          <!-- <td class=\"center\"><span class=\"label label-primary\" ng-repeat=\"tag in res.tags\">{{tag}}</span><span ng-hide=\"res.tags.length > 0\">--</span></td> -->\n        </tr>\n      </tbody>\n    </table>\n    <div class=\"dataTables_footer\">\n      <hk-data-pagination resource-list=\"vm.resourceList\" current-page=\"vm.resCurPage\" page-setter=\"vm.setPage(pageNumber)\"\n                     per-page=\"vm.resPerPage\" headers=\"vm.headerLinks\"></hk-data-pagination>\n    </div>\n  </div>\n</div>\n");
$templateCache.put("plugins/metrics/html/availability.html","<div class=\"hk-screen-content\" ng-controller=\"MetricsAvailabilityController as vm\">\n  <hawkular-sidebar ng-controller=\"Sidebar.SidebarController\">\n    <div class=\"hk-nav-tabs-container\">\n      <ul class=\"nav nav-tabs nav-tabs-pf\">\n        <li><a href=\"/hawkular-ui/url/alerts/{{vm.$routeParams.resourceId}}/{{vm.$routeParams.timeOffset}}\" class=\"hk-alerts\">All Alerts</a></li>\n        <li class=\"active\"><a href=\"/hawkular-ui/url/availability/{{vm.$routeParams.resourceId}}/{{vm.$routeParams.timeOffset}}\" class=\"hk-availability\">Availability</a></li>\n        <li><a href=\"/hawkular-ui/url/response-time/{{vm.$routeParams.resourceId}}/{{vm.$routeParams.timeOffset}}\" class=\"hk-response-time\">Response Time</a></li>\n      </ul>\n    </div>\n  </hawkular-sidebar>\n\n  <section id=\"hk-availability\" class=\"hk-tab-content\">\n\n    <!-- Summary -->\n    <h3 class=\"pull-left\">Availability Status</h3>\n    <span class=\"hk-update pull-right\" tooltip-trigger tooltip-placement=\"bottom\" tooltip=\"Last update\"><i class=\"fa fa-clock-o\"></i>{{vm.endTimeStamp | date:\'mediumTime\'}}</span>\n    <div class=\"panel panel-default hk-summary\">\n      <div class=\"row\">\n        <div class=\"col-sm-3 hk-summary-item\">\n          <span class=\"hk-data\" ng-show=\"vm.uptimeRatio < 1\">{{vm.uptimeRatio * 100 | number:3}} %</span>\n          <span class=\"hk-data\" ng-show=\"vm.uptimeRatio === 1\">{{vm.uptimeRatio * 100}} %</span>\n          <span class=\"hk-item\">Availability</span>\n        </div>\n        <div class=\"col-sm-3 hk-summary-item\">\n          <span class=\"hk-data\">{{vm.downtimeDuration / 1000 | number:0}} s</span>\n          <span class=\"hk-item\">Total Downtime Duration</span>\n        </div>\n        <div class=\"col-sm-3 hk-summary-item\">\n          <span class=\"hk-data\" ng-show=\"vm.lastDowntime.valueOf() !== 0\">{{vm.lastDowntime | date:\'mediumDate\'}}</span>\n          <span class=\"hk-data\" ng-show=\"!vm.lastDowntime || vm.lastDowntime.valueOf() === 0\">Always Up</span>\n          <span class=\"hk-item\">Last Downtime</span>\n        </div>\n        <div class=\"col-sm-3 hk-summary-item\">\n          <span class=\"hk-data\">{{vm.downtimeCount}}</span>\n          <span class=\"hk-item\">Downtime Events</span>\n        </div>\n      </div>\n    </div>\n\n    <!-- Alerts -->\n    <div class=\"hk-info-top clearfix\">\n      <h3 class=\"pull-left\" data-toggle=\"tooltip\" data-placement=\"top\" title=\"\" data-original-title=\"Expand/collapse\">\n        <button class=\"btn btn-link hk-trigger\" ng-click=\"showAllAlerts = !showAllAlerts\"><i class=\"fa\" ng-show=\"vm.alertList.length > 0\" ng-class=\"showAllAlerts ? \'fa-minus-square-o\' : \'fa-plus-square-o\'\"></i> Alerts <span ng-show=\"vm.alertList.length > 0\">({{showAllAlerts ? vm.alertList.length : vm.math.min(vm.alertList.length, 3)}} of {{vm.alertList.length}})</span></button>\n      </h3>\n      <span class=\"hk-settings pull-right\"><a href=\"#\" ng-controller=\"MetricsAlertController as mac\" ng-click=\"mac.openSetup()\"><i class=\"fa fa-cog\"></i>Alert Settings</a></span>\n    </div>\n\n    <div class=\"clearfix\">\n      <!-- No Alerts -->\n      <div class=\"panel panel-default alert alert-info\" ng-show=\"vm.alertList.length === 0\">\n        <div class=\"hk-alert-icon\"><i class=\"fa fa-flag-o\"></i></div>\n        <div class=\"hk-event\">No Alerts have been fired in this category and time range.</div>\n      </div>\n      <!-- Alerts exist -->\n      <div class=\"panel panel-default alert alert-danger\" ng-repeat=\"alert in vm.alertList | limitTo: (showAllAlerts ? 100000 : 3) track by $index\">\n        <div class=\"hk-alert-icon\"><i class=\"fa fa-flag\"></i></div>\n        <div class=\"hk-date\">{{alert.evalSets[0][0].evalTimestamp | date:\'medium\' }}</div>\n        <div>Server <strong>down</strong> for {{(alert.ctime - alert.evalSets[0][0].evalTimestamp) / 1000 | number:0}} seconds (until {{alert.ctime | date:\'mediumTime\'}}).</div>\n      </div>\n    </div>\n\n    <!-- Availability Chart -->\n    <div class=\"hk-info-top clearfix\">\n      <h3 class=\"pull-left\">Metrics</h3>\n      <div class=\"hk-update pull-right\">\n        <button ng-click=\"vm.refreshAvailPageNow(vm.getResourceId())\" class=\"btn btn-link hk-chart-update\" tooltip-trigger tooltip-placement=\"top\" tooltip=\"Update chart\"><i class=\"fa fa-refresh\"></i></button>\n      </div>\n    </div>\n\n    <div class=\"panel panel-default hk-graph\">\n      <h2>Availability</h2>\n      <availability-chart\n              data=\"{{vm.availabilityDataPoints}}\"\n              chart-type=\"availability\">\n      </availability-chart>\n\n    </div>\n\n\n  </section>\n</div>");
$templateCache.put("plugins/metrics/html/create-alert-form.html","<div ng-controller=\"QuickAlertController as qac\" ng-show=\"vm.chartData.dataPoints.length > 1\">\n  <div ng-show=\"!showQuickAlert\" class=\"col-sm-9 col-md-10 content\">\n    <button class=\"btn btn-primary pull-left\" ng-click=\"qac.toggleQuickAlert()\">Add an Alert</button>\n  </div>\n  <div ng-show=\"showQuickAlert\" class=\"col-sm-9 col-md-10 content\">\n    <h1>Add an Alert</h1>\n\n    <form class=\"form-horizontal\" name=\"addQuickAlertForm\" role=\"form\">\n      <div class=\"form-group\">\n        <label class=\"col-md-4 control-label\">\n          Fire when metric is\n        </label>\n\n        <div id=\"alert-radio-container\" class=\"col-md-4\">\n          <label class=\"radio-inline\">\n            <input type=\"radio\" ng-model=\"quickTrigger.operator\" class=\"radio\" value=\"LT\"> <\n          </label>\n          <label class=\"radio-inline\">\n            <input type=\"radio\" ng-model=\"quickTrigger.operator\" class=\"radio\" value=\"GT\"> >\n          </label>\n          <label class=\"radio-inline\">\n            <input type=\"radio\" ng-model=\"quickTrigger.operator\" class=\"radio\" value=\"LTE\"> <=\n          </label>\n          <label class=\"radio-inline\">\n            <input type=\"radio\" ng-model=\"quickTrigger.operator\" class=\"radio\" value=\"GTE\"> >=\n          </label>\n        </div>\n      </div>\n      <div class=\"form-group\">\n        <label class=\"col-md-4 control-label\" for=\"threshold\">\n          Of threshold\n        </label>\n\n        <div class=\"col-md-2\">\n          <input type=\"number\" id=\"threshold\" ng-model=\"quickTrigger.threshold\" class=\"form-control\"\n                 ng-minlength=\"1\" required>\n        </div>\n      </div>\n      <div class=\"form-group\">\n        <label class=\"col-md-4 control-label\" for=\"actions\">\n          Notify to:\n        </label>\n\n        <div class=\"col-md-3\">\n          <ui-select id=\"actions\" multiple ng-model=\"quickTrigger.actions\" theme=\"bootstrap\"\n                     ng-disabled=\"disabled\" close-on-select=\"false\">\n            <ui-select-match placeholder=\"Select action...\">{{$item}}</ui-select-match>\n            <ui-select-choices repeat=\"action in actions | filter:$select.search\">\n              {{ action }}\n            </ui-select-choices>\n          </ui-select>\n        </div>\n      </div>\n      <div class=\"form-group\">\n        <div class=\"col-md-offset-4 col-md-6\">\n          <button class=\"btn btn-primary\" ng-click=\"qac.saveQuickAlert()\">Create Alert</button>\n          <button type=\"button\" class=\"btn btn-default\" ng-click=\"qac.toggleQuickAlert()\">Cancel</button>\n        </div>\n      </div>\n    </form>\n  </div>\n</div>\n");
$templateCache.put("plugins/metrics/html/data-pagination.html","<div class=\"dataTables_paginate paging_bootstrap_input\" id=\"DataTables_Table_0_paginate\">\n  <ul class=\"pagination\">\n    <li ng-class=\"{disabled: pagesNumber === 1}\" class=\"first\" ng-click=\"goToFirst()\"><span class=\"i fa fa-angle-double-left\"></span></li>\n    <li ng-class=\"{disabled: pagesNumber === 1}\" class=\"prev\" ng-click=\"setPage(currentPage - 1)\"><span class=\"i fa fa-angle-left\"></span></li>\n  </ul>\n  <div class=\"pagination-input\">\n    <form ng-submit=\"setPage(currentPageView - 1)\">\n      <input type=\"text\" class=\"paginate_input\" ng-model=\"currentPageView\">\n    <span class=\"paginate_of\">of <b>{{goTos.length}}</b></span>\n    </form>\n  </div>\n  <ul class=\"pagination\">\n    <li ng-class=\"{disabled: pagesNumber === 1}\" class=\"next\" ng-click=\"setPage(currentPage + 1)\"><span class=\"i fa fa-angle-right\"></span></li>\n    <li ng-class=\"{disabled: pagesNumber === 1}\" class=\"last\" ng-click=\"goToLast()\"><span class=\"i fa fa-angle-double-right\"></span></li>\n  </ul>\n</div>");
$templateCache.put("plugins/metrics/html/response-time.html","<div class=\"hk-screen-content\" ng-controller=\"MetricsViewController as vm\">\n\n  <hawkular-sidebar ng-controller=\"Sidebar.SidebarController\">\n    <div class=\"hk-nav-tabs-container\">\n      <ul class=\"nav nav-tabs nav-tabs-pf\">\n        <li><a href=\"/hawkular-ui/url/alerts/{{vm.$routeParams.resourceId}}/{{vm.$routeParams.timeOffset}}\" class=\"hk-alerts\">All Alerts</a></li>\n        <li><a href=\"/hawkular-ui/url/availability/{{vm.$routeParams.resourceId}}/{{vm.$routeParams.timeOffset}}\" class=\"hk-availability\">Availability</a></li>\n        <li class=\"active\"><a href=\"/hawkular-ui/url/response-time/{{vm.$routeParams.resourceId}}/{{vm.$routeParams.timeOffset}}\" class=\"hk-response-time\">Response Time</a></li>\n      </ul>\n    </div>\n  </hawkular-sidebar>\n\n  <section class=\"hk-tab-content\" id=\"hk-response-time\">\n\n    <!-- Summary -->\n    <h3 class=\"pull-left\">Response Time Status</h3>\n    <span class=\"update pull-right\" tooltip-trigger tooltip-placement=\"bottom\" tooltip=\"Last update\"><i class=\"fa fa-clock-o\"></i>{{vm.endTimeStamp | date:\'mediumTime\'}}</span>\n    <div class=\"panel panel-default hk-summary\">\n      <div class=\"row\">\n        <div class=\"col-sm-4 hk-summary-item\">\n          <span class=\"hk-data\">{{vm.average}} <span>ms</span></span>\n          <span class=\"hk-item\">Average</span>\n        </div>\n        <div class=\"col-sm-4 hk-summary-item\">\n          <span class=\"hk-data\">{{vm.median}} <span>ms</span></span>\n          <span class=\"hk-item\">Median</span>\n        </div>\n        <div class=\"col-sm-4 hk-summary-item\">\n          <span class=\"hk-data\">{{vm.percentile95th}} <span>ms</span></span>\n          <span class=\"hk-item\">95th percentile</span>\n        </div>\n      </div>\n    </div>\n\n    <!-- Alerts -->\n    <div class=\"hk-info-top clearfix\">\n      <h3 class=\"pull-left\" data-toggle=\"tooltip\" data-placement=\"top\" title=\"\" data-original-title=\"Expand/collapse\">\n        <button class=\"btn btn-link hk-trigger\" ng-click=\"showAllAlerts = !showAllAlerts\"><i class=\"fa\" ng-show=\"vm.alertList.length > 0\" ng-class=\"showAllAlerts ? \'fa-minus-square-o\' : \'fa-plus-square-o\'\"></i> Alerts <span ng-show=\"vm.alertList.length > 0\">({{showAllAlerts ? vm.alertList.length : vm.math.min(vm.alertList.length, 3)}} of {{vm.alertList.length}})</span></button>\n      </h3>\n      <span class=\"hk-settings pull-right\"><a href=\"#\" ng-controller=\"MetricsAlertController as mac\" ng-click=\"mac.openSetup()\"><i class=\"fa fa-cog\"></i>Alert Settings</a></span>\n    </div>\n    <div class=\"clearfix\">\n      <!-- No Alerts -->\n      <div class=\"panel panel-default alert alert-info\" ng-show=\"vm.alertList.length === 0\">\n        <div class=\"hk-alert-icon\"><i class=\"fa fa-flag-o\"></i></div>\n        <div>No Alerts have been fired in this category and time range.</div>\n      </div>\n      <!-- Alerts exist -->\n      <div class=\"panel panel-default alert alert-danger\" ng-repeat=\"alert in vm.alertList | limitTo: (showAllAlerts ? 100000 : 3) track by $index\">\n        <div class=\"hk-alert-icon\"><i class=\"fa fa-flag\"></i></div>\n        <div class=\"hk-date\">{{alert.evalSets[0][0].evalTimestamp | date:\'medium\' }}</div>\n        <div class=\"hk-event\"><strong>Response time</strong> was above the threshold ({{alert.evalSets[0][0].condition.threshold}}ms) for {{(alert.ctime - alert.evalSets[0][0].evalTimestamp) / 1000 | number:0}} seconds (until {{alert.ctime | date:\'mediumTime\'}}).</div>\n      </div>\n    </div>\n\n    <!-- Response Time Graph -->\n    <div class=\"hk-info-top clearfix\">\n      <h3 class=\"pull-left\">Metrics</h3>\n      <div class=\"hk-update pull-right\">\n        <button class=\"btn btn-link hk-chart-update\" tooltip-trigger tooltip-placement=\"top\" tooltip=\"Update chart\" ng-click=\"vm.refreshChartDataNow(vm.getMetricId())\"><i class=\"fa fa-refresh\"></i></button>\n      </div>\n    </div>\n\n    <div class=\"panel panel-default hk-graph\">\n      <h2>Response Time</h2>\n      <div class=\"hk-legend center-block\" ng-show=\"vm.chartData.dataPoints.length > 0\">\n        <span><i class=\"fa fa-circle hk-blue\"></i>Response Time</span>\n        <span><i class=\"fa fa-circle hk-red\"></i>Response Time (above the threshold)</span>\n      </div>\n\n      <p class=\"label label-info waiting-label\" ng-hide=\"vm.chartData.dataPoints.length > 0\" >We are\n        collecting your initial data. Please be patient(could be up to a minute)...</p>\n\n      <div id=\"metrics-chart\">\n        <!-- HINT: colors for the chart can be changed in the hawkular-charts.css -->\n        <hawkular-chart\n          data=\"{{vm.chartData.dataPoints}}\"\n          chart-type=\"hawkularmetric\"\n          alert-value=\"{{vm.threshold}}\"\n          y-axis-units=\"Response Time (ms)\"\n          chart-height=\"250\">\n        </hawkular-chart>\n      </div>\n    </div>\n\n  </section>\n</div>");
$templateCache.put("plugins/metrics/html/single-page.html","<div id=\"spcontainer\" du-scroll-container>\n  <section id=\"secav\">\n    <div ng-include=\"\'plugins/metrics/html/availability.html\'\"></div>\n    <p><h1>&nbsp;</h1></p>\n  </section>\n  <section id=\"secrt\">\n    <div ng-include=\"\'plugins/metrics/html/response-time.html\'\"></div>\n    <p><h1>&nbsp;</h1></p>\n  </section>\n  <section id=\"secal\">\n    <div ng-include=\"\'plugins/metrics/html/alerts.html\'\"></div>\n  </section>\n</div>\n");
$templateCache.put("plugins/metrics/html/url-pagination.html","<div class=\"text-center hk-fade-in\">\n  <ul class=\"pagination\" ng-show=\"goTos.length > 1\">\n    <li>\n      <a href=\"#\" ng-click=\"setPage(currentPage - 1)\">\n        <span class=\"i fa fa-angle-left\"></span>\n      </a>\n    </li>\n    <li ng-repeat=\"i in goTos track by $index\"\n        ng-class=\"{\'active\' : currentPage === {{$index}}}\">\n      <a href=\"#\" ng-click=\"setPage($index)\">{{$index+1}}</a>\n    </li>\n    <li>\n      <a href=\"#\" ng-click=\"setPage(currentPage + 1)\">\n        <span class=\"i fa fa-angle-right\"></span>\n      </a>\n    </li>\n  </ul>\n</div>");
$templateCache.put("plugins/metrics/html/app-details/app-server-details.html","<div class=\"hk-screen-content\" ng-controller=\"HawkularMetrics.AppServerDetailsController as vm\">\n\n  <hawkular-sidebar ng-controller=\"Sidebar.SidebarController\">\n    <div class=\"hk-nav-tabs-container\">\n      <ul class=\"nav nav-tabs nav-tabs-pf\" ng-init=\"vm.activeTab = vm.activeTab || \'jvm-metrics\'\">\n        <!--\n        <li ng-class=\"vm.activeTab === \'alerts\' ? \'active\' : \'\'\"><a href=\"#\" ng-click=\"vm.activeTab = \'alerts\'\" class=\"hk-alerts\">All Alerts</a></li>\n        <li ng-class=\"vm.activeTab === \'jvm-metrics\' ? \'active\' : \'\'\"><a href=\"#\" ng-click=\"vm.activeTab = \'jvm-metrics\'\" class=\"hk-jvm-metrics\">JVM <span class=\"label label-danger label-alert pull-right\">3</span></a></li>\n        -->\n        <li ng-class=\"vm.activeTab === \'jvm-metrics\' ? \'active\' : \'\'\"><a href=\"#\" ng-click=\"vm.activeTab = \'jvm-metrics\'\" class=\"hk-jvm-metrics\">JVM</a></li>\n        <li ng-class=\"vm.activeTab === \'web\' ? \'active\' : \'\'\"><a href=\"#\" ng-click=\"vm.activeTab = \'web\'\" class=\"hk-web\">Web</a></li>\n\n        <!--\n        <li ng-class=\"vm.activeTab === \'jms\' ? \'active\' : \'\'\"><a href=\"#\" ng-click=\"vm.activeTab = \'jms\'\" class=\"hk-jms\">JMS</a></li>\n        <li ng-class=\"vm.activeTab === \'transactions\' ? \'active\' : \'\'\"><a href=\"#\" ng-click=\"vm.activeTab = \'transactions\'\" class=\"hk-transactions\">Transactions</a></li>\n        <li ng-class=\"vm.activeTab === \'datasources\' ? \'active\' : \'\'\"><a href=\"#\" ng-click=\"vm.activeTab = \'datasources\'\" class=\"hk-datasources\">Datasources</a></li>\n        -->\n      </ul>\n    </div>\n  </hawkular-sidebar>\n\n\n  <ng-include src=\"\'plugins/metrics/html/app-details/detail-alerts.html\'\"></ng-include>\n  <ng-include src=\"\'plugins/metrics/html/app-details/detail-jvm.html\'\"></ng-include>\n  <ng-include src=\"\'plugins/metrics/html/app-details/detail-web.html\'\"></ng-include>\n  <ng-include src=\"\'plugins/metrics/html/app-details/detail-jms.html\'\"></ng-include>\n  <ng-include src=\"\'plugins/metrics/html/app-details/detail-transactions.html\'\"></ng-include>\n  <ng-include src=\"\'plugins/metrics/html/app-details/detail-deployments.html\'\"></ng-include>\n  <ng-include src=\"\'plugins/metrics/html/app-details/detail-datasources.html\'\"></ng-include>\n\n\n</div>");
$templateCache.put("plugins/metrics/html/app-details/detail-alerts.html","\n<section id=\"hk-alerts\" class=\"hk-tab-content\" ng-if=\"vm.activeTab === \'alerts\'\">\n\n    <div class=\"hk-info-top clearfix\">\n        <h3 class=\"pull-left\" tooltip-trigger tooltip-placement=\"top\" tooltip=\"Expand/collapse\">Alerts <span>(29)</span></h3>\n        <span class=\"hk-settings pull-right\"><a href=\"#\" ng-controller=\"MetricsAlertController as mac\" ng-click=\"mac.openSetup()\"><i class=\"fa fa-cog\"></i>Alert Settings</a></span>\n    </div>\n    <div class=\"clearfix\">\n        <div class=\"panel panel-default alert alert-danger\">\n            <div class=\"hk-alert-icon\">\n                <i class=\"fa fa-flag\"></i>\n            </div>\n            <div class=\"hk-date\">\n                12 Feb, 5:35 PM\n            </div>\n            <div class=\"hk-event\">\n                Server <strong>down</strong> for 4 minutes (until 5:39 PM).\n            </div>\n        </div>\n        <div class=\"panel panel-default alert alert-danger\">\n            <div class=\"hk-alert-icon\">\n                <i class=\"fa fa-flag\"></i>\n            </div>\n            <div class=\"hk-date\">\n                11 Feb, 3:53 PM\n            </div>\n            <div class=\"hk-event\">\n                <strong>Response time</strong> was above the threshold for 7 minutes (until 4:00 PM).\n            </div>\n        </div>\n    </div>\n\n</section>");
$templateCache.put("plugins/metrics/html/app-details/detail-datasources.html","\n<section id=\"hk-datasources\" class=\"hk-tab-content\"  ng-if=\"vm.activeTab === \'datasources\'\">\n\n    <h3 class=\"pull-left\">Datasources</h3>\n    <span class=\"hk-update pull-right\" tooltip-trigger tooltip-placement=\"bottom\" tooltip=\"Last update\"><i class=\"fa fa-clock-o\"></i>{{vm.endTimeStamp | date:\'mediumTime\'}}</span>\n    <div class=\"panel panel-default hk-summary\">\n        <div class=\"row\">\n            <div class=\"col-sm-3 hk-summary-item\">\n                <span class=\"hk-data\">2 <i class=\"fa fa-flag\"></i></span>\n                <span class=\"hk-item\">Alerts</span>\n            </div>\n            <div class=\"col-sm-3 hk-summary-item\">\n                <span class=\"hk-data\">1270 MB</span>\n                <span class=\"hk-item\">Average Heap Usage</span>\n            </div>\n            <div class=\"col-sm-3 hk-summary-item\">\n                <span class=\"hk-data\">5 s</span>\n                <span class=\"hk-item\">Last Garbage Collection (Duration)</span>\n            </div>\n            <div class=\"col-sm-3 hk-summary-item\">\n                <span class=\"hk-data\">2000 MB</span>\n                <span class=\"hk-item\">Maximum Heap</span>\n            </div>\n        </div>\n    </div>\n\n    <div class=\"hk-info-top clearfix\">\n        <h3 class=\"pull-left\" tooltip-trigger tooltip-placement=\"top\" tooltip=\"Expand/collapse\"><button class=\"btn btn-link hk-trigger\"><i class=\"fa fa-plus-square-o\"></i> Alerts <span>(0)</span></button></h3>\n        <span class=\"hk-settings pull-right\"><a href=\"#\" ng-controller=\"MetricsAlertController as mac\" ng-click=\"mac.openSetup()\"><i class=\"fa fa-cog\"></i>Alert Settings</a></span>\n    </div>\n    <div class=\"clearfix\">\n        <p>No alerts.</p>\n    </div>\n\n</section>");
$templateCache.put("plugins/metrics/html/app-details/detail-deployments.html","\n<section id=\"hk-deployments\" class=\"hk-tab-content\" ng-if=\"vm.activeTab === \'deployments\'\">\n\n    <h3 class=\"pull-left\">Deployments</h3>\n    <span class=\"hk-update pull-right\" tooltip-trigger tooltip-placement=\"bottom\" tooltip=\"Last update\"><i class=\"fa fa-clock-o\"></i>{{vm.endTimeStamp | date:\'mediumTime\'}}</span>\n    <div class=\"panel panel-default hk-summary\">\n        <div class=\"row\">\n            <div class=\"col-sm-3 hk-summary-item\">\n                <span class=\"hk-data\">-Xmx</span>\n                <span class=\"hk-item\">Max. Heap</span>\n            </div>\n            <div class=\"col-sm-3 hk-summary-item\">\n                <span class=\"hk-data\">20 GB</span>\n                <span class=\"hk-item\">Avg. Heap Usage</span>\n            </div>\n            <div class=\"col-sm-3 hk-summary-item\">\n                <span class=\"hk-data\">22:00</span>\n                <span class=\"hk-item\">Last Garbage Collection</span>\n            </div>\n            <div class=\"col-sm-3 hk-summary-item\">\n                <span class=\"hk-data\">3</span>\n                <span class=\"hk-item\">Alerts</span>\n            </div>\n        </div>\n    </div>\n\n    <div class=\"hk-info-top clearfix\">\n        <h3 class=\"pull-left\" tooltip-trigger tooltip-placement=\"top\" tooltip=\"Expand/collapse\"><button class=\"btn btn-link hk-trigger\"><i class=\"fa fa-plus-square-o\"></i> Alerts <span>(1)</span></button></h3>\n        <span class=\"hk-settings pull-right\"><a href=\"#\" ng-controller=\"MetricsAlertController as mac\" ng-click=\"mac.openSetup()\"><i class=\"fa fa-cog\"></i>Alert Settings</a></span>\n    </div>\n    <div class=\"alerts-activity clearfix\">\n        <div class=\"panel panel-default alert alert-danger\">\n            <div class=\"hk-alert-icon\">\n                <i class=\"fa fa-flag\"></i>\n            </div>\n            <div class=\"hk-date\">\n                12 Feb, 5:35 PM\n            </div>\n            <div class=\"hk-event\">\n                Server <strong>down</strong> for 4 minutes (until 5:39 PM).\n            </div>\n        </div>\n    </div>\n\n</section>");
$templateCache.put("plugins/metrics/html/app-details/detail-jms.html","\n\n<section id=\"hk-jms\" class=\"hk-tab-content\"  ng-if=\"vm.activeTab === \'jms\'\">\n\n    <h3 class=\"pull-left\">JMS</h3>\n    <span class=\"hk-update pull-right\" tooltip-trigger tooltip-placement=\"bottom\" tooltip=\"Last update\"><i class=\"fa fa-clock-o\"></i>{{vm.endTimeStamp | date:\'mediumTime\'}}</span>\n    <div class=\"panel panel-default hk-summary\">\n        <div class=\"row\">\n            <div class=\"col-sm-3 hk-summary-item\">\n                <span class=\"hk-data\">2 <i class=\"fa fa-flag\"></i></span>\n                <span class=\"hk-item\">Alerts</span>\n            </div>\n            <div class=\"col-sm-3 hk-summary-item\">\n                <span class=\"hk-data\">1270 MB</span>\n                <span class=\"hk-item\">Average Heap Usage</span>\n            </div>\n            <div class=\"col-sm-3 hk-summary-item\">\n                <span class=\"hk-data\">5 s</span>\n                <span class=\"hk-item\">Last Garbage Collection (Duration)</span>\n            </div>\n            <div class=\"col-sm-3 hk-summary-item\">\n                <span class=\"hk-data\">2000 MB</span>\n                <span class=\"hk-item\">Maximum Heap</span>\n            </div>\n        </div>\n    </div>\n\n    <div class=\"hk-info-top clearfix\">\n        <h3 class=\"pull-left\" tooltip-trigger tooltip-placement=\"top\" tooltip=\"Expand/collapse\"><button class=\"btn btn-link hk-trigger\"><i class=\"fa fa-plus-square-o\"></i> Alerts <span>(0)</span></button></h3>\n        <span class=\"hk-settings pull-right\"><a href=\"#\" ng-controller=\"MetricsAlertController as mac\" ng-click=\"mac.openSetup()\"><i class=\"fa fa-cog\"></i>Alert Settings</a></span>\n    </div>\n    <div class=\"clearfix\">\n        <p>No alerts.</p>\n    </div>\n\n</section>");
$templateCache.put("plugins/metrics/html/app-details/detail-jvm.html","<section id=\"hk-jvm-metrics\" class=\"hk-tab-content\" ng-if=\"vm.activeTab === \'jvm-metrics\'\">\n\n    <h3 class=\"pull-left\">JVM Status</h3>\n    <span class=\"hk-update pull-right\" tooltip-trigger tooltip-placement=\"bottom\" tooltip=\"Last update\"><i class=\"fa fa-clock-o\"></i>{{vm.endTimeStamp | date:\'mediumTime\'}}</span>\n    <div class=\"panel panel-default hk-summary\">\n        <div class=\"row\">\n            <div class=\"col-sm-3 hk-summary-item\">\n                <span class=\"hk-data\">10 <i class=\"fa fa-flag\"></i></span>\n                <span class=\"hk-item\">JVM Alerts</span>\n            </div>\n            <div class=\"col-sm-3 hk-summary-item\">\n                <span class=\"hk-data\">1270 MB</span>\n                <span class=\"hk-item\">Average Heap Usage</span>\n            </div>\n            <div class=\"col-sm-3 hk-summary-item\">\n                <span class=\"hk-data\">5 s</span>\n                <span class=\"hk-item\">Last Garbage Collection (Duration)</span>\n            </div>\n            <div class=\"col-sm-3 hk-summary-item\">\n                <span class=\"hk-data\">2000 MB</span>\n                <span class=\"hk-item\">Maximum Heap</span>\n            </div>\n        </div>\n    </div>\n\n    <div class=\"hk-info-top clearfix\">\n        <h3 class=\"pull-left\" tooltip-trigger tooltip-placement=\"top\" tooltip=\"Expand/collapse\"><button class=\"btn btn-link hk-trigger\"><i class=\"fa fa-plus-square-o\"></i> JVM Alerts <span>(2 of 10)</span></button></h3>\n        <span class=\"hk-settings pull-right\"><a href=\"#\" ng-controller=\"MetricsAlertController as mac\" ng-click=\"mac.openSetup()\"><i class=\"fa fa-cog\"></i>Alert Settings</a></span>\n    </div>\n    <div class=\"alerts-activity clearfix\">\n        <div class=\"panel panel-default alert alert-danger\">\n            <div class=\"hk-alert-icon\"><i class=\"fa fa-flag\"></i></div>\n            <div class=\"hk-date\">12 Feb, 5:35 PM</div>\n            <div class=\"hk-event\">Server <strong>down</strong> for 4 minutes (until 5:39 PM).</div>\n        </div>\n        <div class=\"panel panel-default alert alert-danger\">\n            <div class=\"hk-alert-icon\"><i class=\"fa fa-flag\"></i></div>\n            <div class=\"hk-date\">11 Feb, 3:53 PM</div>\n            <div class=\"hk-event\"><strong>Response time</strong> was above the threshold for 7 minutes (until 4:00 PM).</div>\n        </div>\n    </div>\n\n    <div class=\"hk-info-top clearfix\">\n        <h3 class=\"pull-left\">Metrics</h3>\n        <div class=\"hk-update pull-right\">\n            <button class=\"btn btn-link hk-chart-update\" data-toggle=\"tooltip\" data-placement=\"top\" title=\"\" data-original-title=\"Update chart\"><i class=\"fa fa-refresh\"></i></button>\n        </div>\n    </div>\n\n    <div class=\"panel panel-default hk-graph\">\n        <h2>JVM Heap Usage</h2>\n        <div class=\"hk-legend pull-left\">\n            <span><i class=\"fa fa-circle hk-primary\"></i>Used</span>\n            <span><i class=\"fa fa-circle hk-orange\"></i>Maximum</span>\n            <span><i class=\"fa fa-circle hk-gray\"></i>Commited</span>\n        </div>\n    </div>\n\n</section>");
$templateCache.put("plugins/metrics/html/app-details/detail-transactions.html","\n\n<section id=\"hk-transactions\" class=\"hk-tab-content\"  ng-if=\"vm.activeTab === \'transactions\'\">\n\n    <h3 class=\"pull-left\">Transactions</h3>\n    <span class=\"hk-update pull-right\" tooltip-trigger tooltip-placement=\"bottom\" tooltip=\"Last update\"><i class=\"fa fa-clock-o\"></i>{{vm.endTimeStamp | date:\'mediumTime\'}}</span>\n    <div class=\"panel panel-default hk-summary\">\n        <div class=\"row\">\n            <div class=\"col-sm-3 hk-summary-item\">\n                <span class=\"hk-data\">2 <i class=\"fa fa-flag\"></i></span>\n                <span class=\"hk-item\">Alerts</span>\n            </div>\n            <div class=\"col-sm-3 hk-summary-item\">\n                <span class=\"hk-data\">1270 MB</span>\n                <span class=\"hk-item\">Average Heap Usage</span>\n            </div>\n            <div class=\"col-sm-3 hk-summary-item\">\n                <span class=\"hk-data\">5 s</span>\n                <span class=\"hk-item\">Last Garbage Collection (Duration)</span>\n            </div>\n            <div class=\"col-sm-3 hk-summary-item\">\n                <span class=\"hk-data\">2000 MB</span>\n                <span class=\"hk-item\">Maximum Heap</span>\n            </div>\n        </div>\n    </div>\n\n    <div class=\"hk-info-top clearfix\">\n        <h3 class=\"pull-left\" tooltip-trigger tooltip-placement=\"top\" tooltip=\"Expand/collapse\"><button class=\"btn btn-link hk-trigger\"><i class=\"fa fa-plus-square-o\"></i> Alerts <span>(0)</span></button></h3>\n        <span class=\"hk-settings pull-right\"><a href=\"#\" ng-controller=\"MetricsAlertController as mac\" ng-click=\"mac.openSetup()\"><i class=\"fa fa-cog\"></i>Alert Settings</a></span>\n    </div>\n    <div class=\"clearfix\">\n        <p>No alerts.</p>\n    </div>\n\n</section>");
$templateCache.put("plugins/metrics/html/app-details/detail-web.html","\n\n\n<section id=\"hk-web\" class=\"hk-tab-content\"  ng-if=\"vm.activeTab === \'web\'\">\n\n    <h3 class=\"pull-left\">Web</h3>\n    <span class=\"hk-update pull-right\" tooltip-trigger tooltip-placement=\"bottom\" tooltip=\"Last update\"><i class=\"fa fa-clock-o\"></i>{{vm.endTimeStamp | date:\'mediumTime\'}}</span>\n    <div class=\"panel panel-default hk-summary\">\n        <div class=\"row\">\n            <div class=\"col-sm-3 hk-summary-item\">\n                <span class=\"hk-data\">2 <i class=\"fa fa-flag\"></i></span>\n                <span class=\"hk-item\">Alerts</span>\n            </div>\n            <div class=\"col-sm-3 hk-summary-item\">\n                <span class=\"hk-data\">1270 MB</span>\n                <span class=\"hk-item\">Average Heap Usage</span>\n            </div>\n            <div class=\"col-sm-3 hk-summary-item\">\n                <span class=\"hk-data\">5 s</span>\n                <span class=\"hk-item\">Last Garbage Collection (Duration)</span>\n            </div>\n            <div class=\"col-sm-3 hk-summary-item\">\n                <span class=\"hk-data\">2000 MB</span>\n                <span class=\"hk-item\">Maximum Heap</span>\n            </div>\n        </div>\n    </div>\n\n    <div class=\"hk-info-top clearfix\">\n        <h3 class=\"pull-left\" tooltip-trigger tooltip-placement=\"top\" tooltip=\"Expand/collapse\"><button class=\"btn btn-link hk-trigger\"><i class=\"fa fa-plus-square-o\"></i> Alerts <span>(0)</span></button></h3>\n        <span class=\"hk-settings pull-right\"><a href=\"#\" ng-controller=\"MetricsAlertController as mac\" ng-click=\"mac.openSetup()\"><i class=\"fa fa-cog\"></i>Alert Settings</a></span>\n    </div>\n    <div class=\"clearfix\">\n        <p>No alerts.</p>\n    </div>\n\n</section>");
$templateCache.put("plugins/metrics/html/modals/delete-resource.html","<div class=\"modal-header\">\n  <button type=\"button\" class=\"close\" ng-click=\"vm.cancel()\">\n    <span class=\"pficon pficon-close\"></span>\n  </button>\n  <h4 class=\"modal-title\">Delete Resource</h4>\n</div>\n<div class=\"modal-body\">\n  <div class=\"form-group\">\n    <p class=\"primary-message\">Are you sure you want to stop monitoring and delete the data for the site <strong>{{ vm.resource.properties.url }}</strong> (Resource ID: {{ vm.resource.id }}) ?</p>\n    <p>This action can\'t be undone.</p>\n  </div>\n</div>\n<div class=\"modal-footer\">\n  <button type=\"button\" class=\"btn btn-default\" ng-click=\"vm.cancel()\">Cancel</button>\n  <button type=\"button\" class=\"btn btn-danger\" ng-click=\"vm.deleteResource()\">Delete</button>\n</div>\n");}]); hawtioPluginLoader.addModule("hawkular-console-templates");
var HawkularVersion = 'ea7690e';
//# sourceMappingURL=data:application/json;base64,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