NG_DOCS={
  "sections": {
    "api": "API Documentation"
  },
  "pages": [
    {
      "section": "api",
      "id": "patternfly.autofocus:pfFocused",
      "shortName": "pfFocused",
      "type": "directive",
      "moduleName": "patternfly",
      "shortDescription": "The focus on element is evaluated from given expression. If the expression provided as an attribute to this directive",
      "keywords": "api attribute autofocus box checkbox checking class col-sm-10 col-sm-2 control-label directive element evaluated expression focus focused form-control form-group form-horizontal html i1 i2 input isfocus module ng-model patternfly pf-focused pffocused placeholder provided selected true type"
    },
    {
      "section": "api",
      "id": "patternfly.card.directive:pfAggregateStatusCard",
      "shortName": "pfAggregateStatusCard",
      "type": "directive",
      "moduleName": "patternfly.card",
      "shortDescription": "Directive for easily displaying status information",
      "keywords": "$scope adipiscing aggregate aggstatusalt alt-layout alternate alternative angular api array border card carddemoctrl class clicks col-md-10 configuration controller count counts depreciated directive display displaying displays easily equals fa fa-shield false function hides href html icon iconclass icons js layout layouts left list-style-type main mini miniaggstatus miniaggstatus2 module navigate ng-controller nodes normal note notification notifications number object param patternfly pf-aggregate-status-card pficon pficon-cluster pficon-container-node pficon-error-circle-o pficon-kubernetes pficon-ok pficon-openshift pficon-warning-triangle-o providers script show-top-border single status statuses style tall title top true"
    },
    {
      "section": "api",
      "id": "patternfly.card.directive:pfCard",
      "shortName": "pfCard",
      "type": "directive",
      "moduleName": "patternfly.card",
      "shortDescription": "Directive for easily displaying a card with html content",
      "keywords": "$scope actionbarconfig actual add alert angular api array bars based blue border bottom call callback callbackfn called capacity card chart chart-data chart-title chartctrl chartid charts class clicked cluster compact config configmemory configphysical configsingle configuration configvirtual content contents controller cpu d-- data2 data3 data4 data5 datamemory dataphysical datasingle datavirtual dates days defaultfilter defined demo directive disk displaying drop easily events example2trendschart fa fa-flag fa-plus-circle false filter filterconfig filterconfigheader filters fn footer footerconfig function gb gettime grey head-title header headtitle hides href html icon iconclass inline integer items js label label-title layout layoutinline left link list-style-type memory memorytrendschart mhz module multiple navigate ng-controller panel patternfly percentage performance pf-card pf-trends-chart pf-utilization-bar-chart physical physicaltrendschart position properties push resources script selected show-titles-separator show-top-border showtitlesseparator showtopborder single storage style sub-title subtitle system tb text threshold-error threshold-warning timeframe title title2 title3 title4 title5 today tooltiptype top total trend trendlabel trends true type units units2 units3 units4 units5 usage user utilization valuetype var view virtual virtualtrendschart width xdata ydata"
    },
    {
      "section": "api",
      "id": "patternfly.charts.directive:pfC3Chart",
      "shortName": "pfC3Chart",
      "type": "directive",
      "moduleName": "patternfly.charts",
      "shortDescription": "Directive for wrapping c3 library",
      "keywords": "$scope add angular api application bind button c3 c3chartdefaults chart chartconfig chartctrl chartid charts class columns config configuration container controller data default dependency directive donut form form-control form-group function getdefaultdonutconfig groups html js library mhz module newused ng-click ng-controller ng-model note null options order patternfly pf-c3-chart role script style submitform text total type updateavailable val width wrapping"
    },
    {
      "section": "api",
      "id": "patternfly.charts.directive:pfDonutPctChart",
      "shortName": "pfDonutPctChart",
      "type": "directive",
      "moduleName": "patternfly.charts",
      "shortDescription": "Directive for rendering a percentage used donut/radial chart.  The Used Percentage fill starts at 12 o’clock and",
      "keywords": "$scope alert amount angular api arc availchart availconfig availdata availlabel blue c3 calculate calculated center center-label centerlabelfn chart chartctrl charterr chartid chartnothresh chartok charts chartwarn class click clicked clockwise col-md-12 col-md-3 color colors config configerr confignothresh configok configuration configwarn container-fluid contents controller custchart custconfig custdata customize data dataerr datanothresh dataok datawarn defined dependent determine directive display displays donut donut-tooltip-pf error exist fill full function gb gray grey handle handling html http indicator js label legend list list-style-type mhz module moves ng-controller nolabel nonechart noneconfig nonedata nowrap number onclickfn options orange org patternfly pctchart pctconfig pctdata pctlabel percent percentage pf-donut-pct-chart portion properties radial red rendered rendering represented representing return row script specifies starts style surpassed text text-center three threshold thresholds tool tooltip tooltipfn total unique unit units usage usedchart usedconfig useddata usedlabel user values warning white-space"
    },
    {
      "section": "api",
      "id": "patternfly.charts.directive:pfHeatMap",
      "shortName": "pfHeatMap",
      "type": "directive",
      "moduleName": "patternfly.charts",
      "shortDescription": "Directive for rendering a heatmap chart.",
      "keywords": "$scope angular api block call ce0000 chart chart-data-available chart-title chartctrl chartdataavailable charts charttitle checkbox checkbox-inline class click-action clickaction clicked col-md-12 col-md-5 colors console controller correspond d4f0fa data dataavailable default defaults directive displayed ec7a08 example-heatmap-container f00 f9d67a flag form form-group function heapmap heatmap heatmap-color-pattern heatmapcolorpattern height hightest hover html js kubernetes labels legend legend-labels legendlabels legends list-style-type log m8y measurement message module ng-controller ng-model node openshift overriding patternfly pf-heatmap provider rendering role row script show-legend showlegend showlegends style threshold thresholds title titlealt tooltip total true type units utilization values var"
    },
    {
      "section": "api",
      "id": "patternfly.charts.directive:pfSparklineChart",
      "shortName": "pfSparklineChart",
      "type": "directive",
      "moduleName": "patternfly.charts",
      "shortDescription": "Directive for rendering a sparkline chart.",
      "keywords": "$scope adddatapoint amount angular api area array axis bind c3 chart chart-data chart-height chartctrl chartdata chartheight chartid charts checkbox checkbox-inline class col-md-12 col-md-3 col-md-6 color config configuration container contents controller current custchartheight custshowxaxis custshowyaxis d-- data dates day default determining directive display element examplesparkline false form form-group full function functions gb generation gettime height html http js label legend length list list-style-type markup mhz module ng-click ng-controller ng-model number options org override overrides patternfly percent percentage percentages pf-sparkline-chart point points properties push radio radio-inline random rendering return role round row script set setting settings show-x-axis show-y-axis showing showxaxis showyaxis size sparkline style today tooltip tooltipfn tooltiptype total type unit units usageperday valid valueperday values var width xdata ydata"
    },
    {
      "section": "api",
      "id": "patternfly.charts.directive:pfTrendsChart",
      "shortName": "pfTrendsChart",
      "type": "directive",
      "moduleName": "patternfly.charts",
      "shortDescription": "Directive for rendering a trend chart. The trend chart combines overall data with a",
      "keywords": "$scope $watch actual add adddatapoint alert amount angular api array axis c3 callback callbackfn called card chart chart-data chartctrl chartdata chartheight chartid charts checkbox checkbox-inline class cluster col-md-12 col-md-2 col-md-3 col-md-4 col-md-6 combines compact config configuration controller custshowxaxis custshowyaxis d-- data dataavailable dates days default demo directive disk display element exampletrendschart fa fa-plus-circle false filter filterconfig filters flag fn footer footerconfig form form-group format frame full function gb gettime height html http iconclass inline js label large latest layout length list list-style-type mhz minutes module network newvalue ng-click ng-controller ng-hide ng-model ng-selected number options org override patternfly percentage pf-select pf-select-sm pf-trends-chart pfsparklinechart point points push random rendering representing role round row script selected settings show-x-axis show-y-axis showing showxaxis showyaxis sizes small sparkline style text time timeframe title titles today tooltiptype total trend trendlabel trends true type unique unit units utilization values valuetype var virtual width xdata ydata"
    },
    {
      "section": "api",
      "id": "patternfly.charts.directive:pfUtilizationBarChart",
      "shortName": "pfUtilizationBarChart",
      "type": "directive",
      "moduleName": "patternfly.charts",
      "shortDescription": "Directive for rendering a utilization bar chart",
      "keywords": "$scope actual alternative amount angular api arc auto-format automatic bar blue card chart chart-data chart-footer chart-title chartctrl chartdata charts class colors controller cpu custom data data1 data2 data3 data4 data5 denotes dependent directive disk displayed displays donut error example examples exist fill footer-label-format footer1 footer2 footerlabelwidth function gb html indicator inline js label label-title labels layout layoutinline layouts left-hand list-style-type mb memory mhz module ng-controller number orange patternfly percent percentage pf-utilization-bar-chart ram reached red regular rendering representing right-hand script side smaller standard style surpassed tb three threshold threshold-error threshold-warning thresholds title title1 title2 title3 title4 title5 titlelabelwidth total type units units1 units2 units3 units4 units5 usage utilization valid values warning width"
    },
    {
      "section": "api",
      "id": "patternfly.charts.directive:pfUtilizationChart",
      "shortName": "pfUtilizationChart",
      "type": "directive",
      "moduleName": "patternfly.charts",
      "shortDescription": "Directive for rendering a utilization chart. The utilization chart combines overall data with a pfDonutPctChart and",
      "keywords": "$scope add adddatapoint amount angular api array axis c3 center center-label centerlabel chart chart-data charta chartctrl chartdata chartid charts checkbox checkbox-inline class col-md-12 col-md-3 col-md-6 combines config configuration contents controller custchartheight custshowxaxis custshowyaxis d-- data dataavailable dates day default directive display displays donut donut-config donutcenterlabel donutconfig element error examplesparkline false flag form form-group full function gb gettime height html http js label length list list-style-type math memory mhz module newdata newdate ng-change ng-click ng-controller ng-model number options org override parameter patternfly pct percent percentage pf-utilization-chart pfdonutchart pfdonutpctchart pfsparklinechart point points push radio radio-inline random rendering representing role round row script settings show-sparkline-x-axis show-sparkline-y-axis showing showsparklinexaxis showsparklineyaxis sparkline sparkline-chart-height sparkline-config sparklinechartheight sparklineconfig specifics specifies style thresholds title today tooltip tooltiptype total true type unit units updatedataavailable usage usageperday utilization valueperday values var warning width xdata ydata"
    },
    {
      "section": "api",
      "id": "patternfly.filters.directive:pfSimpleFilter",
      "shortName": "pfSimpleFilter",
      "type": "directive",
      "moduleName": "patternfly.filters",
      "shortDescription": "Directive for a simple filter bar",
      "keywords": "$scope address allitems angular api apple applied appliedfilters applyfilters april august bar bedrock birth birthmonth boulevard box call cfme-row-column changes cincinatti class col-md-12 col-md-2 col-md-3 col-md-7 comparisons config configuration controller current currently december deps dinosaur directive display east elm entered events-label example-container examplesimplefilter false february field fields filter filterable filterchange filterconfig filters filterstext filtertype filtervalues flintstone foreach frank fred function green html input item items january john js judy july june length list list-style-type livingston main march match matches matchesfilter matchesfilters module month ng-controller ng-repeat norfolk november null number october ohio onfilterchange optional pat patternfly pennsylvania pf-simple-filter pittsburgh placeholder push resultscount return returned row rows script second select september settings simple single smith street style text thomas title true type unique valid values var viewctrl virginia washingstone york"
    },
    {
      "section": "api",
      "id": "patternfly.filters.directive:pfSimpleFilterFields",
      "shortName": "pfSimpleFilterFields",
      "type": "directive",
      "moduleName": "patternfly.filters",
      "shortDescription": "Directive for the simple filter bar&#39;s filter entry components",
      "keywords": "api applied appliedfilters bar box comparisons components config configuration currently directive display entered entry field fields filter filterable filters filtertype filtervalues html input list list-style-type optional patternfly placeholder select settings simple style text title type unique valid values"
    },
    {
      "section": "api",
      "id": "patternfly.filters.directive:pfSimpleFilterResults",
      "shortName": "pfSimpleFilterResults",
      "type": "directive",
      "moduleName": "patternfly.filters",
      "shortDescription": "Directive for the simple filter results components",
      "keywords": "api applied appliedfilters box call changes comparisons components config configuration current currently directive display entered field fields filter filterable filters filtertype filtervalues function html input list list-style-type number onfilterchange optional patternfly placeholder resultscount returned select settings simple style text title type unique valid values"
    },
    {
      "section": "api",
      "id": "patternfly.form.directive:pfDatepicker",
      "shortName": "pfDatepicker",
      "type": "directive",
      "moduleName": "patternfly.form",
      "shortDescription": "Angular directive to wrap the bootstrap datepicker http://bootstrap-datepicker.readthedocs.org/en/latest/",
      "keywords": "$scope angular api autoclose bootstrap class configuration controller datepicker directive form form-horizontal formdemoctrl function html http js linked mm model module ng-bind ng-click ng-controller options org patternfly pf-datepicker picker readthedocs script settoday today todaybtn todayhighlight true wrap"
    },
    {
      "section": "api",
      "id": "patternfly.form.directive:pfFormButtons",
      "shortName": "pfFormButtons",
      "type": "directive",
      "moduleName": "patternfly.form",
      "shortDescription": "Encapsulates the standard structure and styling for create and cancel buttons",
      "keywords": "$scope $timeout angular api button buttons call cancel cancelled class clicks col-sm-2 col-sm-5 container control-label controller create creates directive encapsulates false form form-control form-group formbuttonctrl function html input item js model module ng-controller ng-model null patternfly pf-form-buttons pf-on-cancel pf-on-save pf-working pfbuttonclass pfhandlecancel pfhandlesave pfworking save saved scope script standard status store structure styling text true type user working"
    },
    {
      "section": "api",
      "id": "patternfly.form.directive:pfFormGroup",
      "shortName": "pfFormGroup",
      "type": "directive",
      "moduleName": "patternfly.form",
      "shortDescription": "Encapsulates the structure and styling for a label + input used within a",
      "keywords": "$scope angular api based bootstrap3 class col-sm-2 col-sm-5 col-sm-9 controller creates default description directive doh donuts duff element encapsulates field form form-horizontal formdemoctrl function homer html input item js label module ng-controller ng-model patternfly pf-form-group pf-input-class pf-label pffieldid pfinputclass pflabel pflabelclass required scope script simpson structure styling text type"
    },
    {
      "section": "api",
      "id": "patternfly.form.directive:pfRemainingCharsCount",
      "shortName": "pfRemainingCharsCount",
      "type": "directive",
      "moduleName": "patternfly.form",
      "shortDescription": "Directive for showing a characters remaining count and triggering warning and error",
      "keywords": "$on $scope additional additionally allow angular api applied area behavior block block-input-at-max-limit btn btn-default button character characters characters-remaining charremainingcntfld_1 charremainingcntfld_2 charremainingcntfld_3 chars-max-limit chars-remaining-pf chars-warn-remaining chars-warn-remaining-pf charsmaxlimitexceeded class col-md-4 color container controller count count-fld css default democtrl directive disable dispatched dispatching display emptly entered equal error event example falls false field form form-control form-group function greater html initial input input_3 js limit max maximum message messagearea messagearea1text messagearea2text messagearea_1 messagearea_2 messageinput3text model module negative ng-controller ng-disabled ng-model number overcharsmaxlimit padding-left passed passing paste patternfly pf-remaining-chars-count placeholder postbtn_1 postbtn_2 pull-left pull-right reached red remaining removed representing required resize right-click row rows scope script setting showing string style submit text textarea tfid threshold thresholds trigger triggered triggering true turns type undercharsmaxlimit variable warn warning width"
    },
    {
      "section": "api",
      "id": "patternfly.notification.directive:pfNotification",
      "shortName": "pfNotification",
      "type": "directive",
      "moduleName": "patternfly.notification",
      "shortDescription": "The main visual element of the notification message.",
      "keywords": "$scope allowed angular api button checkbox class close closed col-sm-10 col-sm-2 control-label controller danger default delay directive disappear element false form-control form-group form-horizontal function header html info ispersistent js main manually message module ng-controller ng-model ng-options notification notificationdemoctrl notifications patternfly pf-notification-header pf-notification-message pf-notification-persistent pf-notification-type pf-select pfnotificationheader pfnotificationmessage pfnotificationpersistent pfnotificationtype script success text timeout type types visual warning won"
    },
    {
      "section": "api",
      "id": "patternfly.notification.directive:pfNotificationList",
      "shortName": "pfNotificationList",
      "type": "directive",
      "moduleName": "patternfly.notification",
      "shortDescription": "Using this directive automatically creates a list of notifications generated by the notification service.",
      "keywords": "$scope angular api automatically class click col-sm-10 col-sm-12 col-sm-2 control-label controller creates danger default directive error form-control form-group form-horizontal function generated html info js list message module ng-click ng-controller ng-model ng-options notification notificationdemoctrl notifications notify object patternfly pf-select script service success text times type typemap types var warn warning"
    },
    {
      "section": "api",
      "id": "patternfly.notification.Notification",
      "shortName": "patternfly.notification.Notification",
      "type": "service",
      "moduleName": "patternfly.notification",
      "shortDescription": "Notification service used to notify user about important events in the application.",
      "keywords": "$log $rootscope $scope angular api application argument button class close closed col-sm-10 col-sm-12 col-sm-2 config configuration configure configuring console control-label controller danger default delay dismissed error events example expects form-control form-group form-horizontal format function html httperror info input js manually message method miliseconds mode modes module ms myapp ng-click ng-controller ng-model ng-options notification notificationdemoctrl notifications notificationsprovider notify object option patternfly persist persistent persistvalue pf-select printed script service set setdelay setpersist sets setverbose success text true type typemap types user var verbose warn warning won"
    },
    {
      "section": "api",
      "id": "patternfly.select:pfSelect",
      "shortName": "pfSelect",
      "type": "directive",
      "moduleName": "patternfly",
      "shortDescription": "An AngularJS wrapper for the Bootstrap-select jQuery plugin which is used",
      "keywords": "$scope angular angularjs api apple attribute banana binding bootstrap-select cat chicken class coffee col-sm-10 col-sm-2 control-label controller decorator default directive dog drink drinks dynamically element elements form-group form-horizontal fruit function generate github html http https io jquery js list mandatory model module ng-controller ng-model ng-options ng-selected ngmodel ngmodelcontroller ngoptions noneselectedtext orange org patternfly pet pets pf-select plugin preferred script select selectdemoctrl selected tea true water wrapper"
    },
    {
      "section": "api",
      "id": "patternfly.sort.directive:pfSimpleSort",
      "shortName": "pfSimpleSort",
      "type": "directive",
      "moduleName": "patternfly.sort",
      "shortDescription": "Directive for a simple sort component",
      "keywords": "$scope alpha alright angular api ascending beautiful call cfme-row-column change cheap class col-md-12 col-md-3 comparefn component compvalue config configuration controller count current currentfield descending description direction directive display events-label example-container examplesimplesort excellent false fantastic field fields forever function good horrible html isascending item item1 item2 items js lasts list list-style-type localecompare module ng-controller ng-repeat nice numeric onsortchange params patternfly pf-simple-sort return row script settings simple sort sortable sortchange sortconfig sortdirection sortid sorttype stuff style title true type unique var viewctrl"
    },
    {
      "section": "api",
      "id": "patternfly.utils.directive:pfTransclude",
      "shortName": "pfTransclude",
      "type": "directive",
      "moduleName": "patternfly.utils",
      "shortDescription": "Directive for transcluding in directives and setting up scope of children of parent directives. This is a workaround",
      "keywords": "$delegate $id $provide angular api child children class config content contents controller decorator directive directives display element function html https js list-style-type module ng-controller ngtranscludedirective original parent patternfly pf-transclude pf-transclude-example pftransclude remove restrict return row scope script setting shift sibling specifies style template transclude transcludechild transcluded transcludeparent transcludesibling transcluding transclusion true type utilctrl utils width workaround"
    },
    {
      "section": "api",
      "id": "patternfly.validation:pfValidation",
      "shortName": "pfValidation",
      "type": "directive",
      "moduleName": "patternfly",
      "shortDescription": "Directive used for input validation based on custom function.",
      "keywords": "$scope angular api based change checkbox class col-sm-10 col-sm-2 control-label controller custom directive disabled enabled false form-control form-group form-horizontal function help-block html input isnumber isvalidationdisabled js message module myvalue myvaluevalid ng-controller ng-model number patternfly pf-validation pf-validation-disabled pfvalidationdisabled return script text true type typed valid validation validationdemoctrl"
    },
    {
      "section": "api",
      "id": "patternfly.views.directive:pfDataList",
      "shortName": "pfDataList",
      "type": "directive",
      "moduleName": "patternfly.views",
      "shortDescription": "Directive for rendering a data list.",
      "keywords": "$scope action actionfn actions address allow angular api applicable array based beam bedrock boston bourbon box boxes button california call called change changes check checkbox checkbox-inline checkdisabled checkdisableditem checked city class click clicked clicking col-md-12 col-md-3 colorado config configuration controller cross current data dblclick default denver deps determine determining dinosaur directive disable disabled display displayed dlbclick double dropdown east edwards elm event eventtext example-container example-data-list exampledatalist false flintstone font-weight form form-group frank fred function grouped handle handlecheckboxchange handleclick handledblclick handleselect handleselectionchange height holly hollywood html invoke isdisabled isseparator isvisible item items jim john js jump length linda list list-style-type list-view-container livingston main marie massachusetts matching mcgovern menu module multiple multiselect nashville ng-change ng-controller ng-disabled ng-model nichols norfolk notify number oak oncheckboxchange onclick ondblclick onselect onselectionchange optional pat patternfly pennsylvania perform performaction pf-data-list pittsburgh placeholder placement property radio radio-inline remains rendering return role row rowheight rows script second select selected selecteditems selection selectionmatchprop selections selectitems selecttype separator set settings showdisabled showselectbox smith street style tennessee thomas title tooltip true type unavailable update updateactionforitemfn updateselectiontype utils uuid var viewctrl views virginia washingstone width york"
    },
    {
      "section": "api",
      "id": "patternfly.views.directive:pfDataTiles",
      "shortName": "pfDataTiles",
      "type": "directive",
      "moduleName": "patternfly.views",
      "shortDescription": "Directive for rendering data tiles",
      "keywords": "$scope address allow angular api apple applicable bedrock block border border-top boulevard boxes call called change changes checkbox checkbox-inline checkdisabled checkdisableditem checked cincinatti city class click clicked clicking col-md-12 config configuration controller current data dblclick default deps determine determining dinosaur directive disabled display dlbclick double east elm event events-label eventtext exampledatatiles false flintstone form form-group frank fred function green handle handlecheckboxchange handleclick handledblclick handleselect handleselectionchange height hr html item items john js judy length list-style-type livingston main margin matching module multiple multiselect ng-change ng-controller ng-disabled ng-model norfolk notify ohio oncheckboxchange onclick ondblclick onselect onselectionchange padding pat patternfly pennsylvania pf-data-tiles pittsburgh property radio radio-inline remains rendering return role row rows script second select selected selecteditems selection selectionmatchprop selections selectitems selecttype set settings showdisabled showselectbox smith solid street style thomas tile tiles true type updateselectiontype utils uuid var viewctrl views virginia washingstone width york"
    },
    {
      "section": "api",
      "id": "patternfly.views.directive:pfDataToolbar",
      "shortName": "pfDataToolbar",
      "type": "directive",
      "moduleName": "patternfly.views",
      "shortDescription": "Directive for standard data toolbar. Includes filtering and view selection capabilities",
      "keywords": "$scope action actionfn actions actions-label actionsconfig actionstext address age allitems alpha angular api apple appliedfilters applyfilters april august bedrock birth birthmonth boulevard button call capabilities checkdisabled cincinatti class col-md-1 col-md-12 col-md-2 col-md-3 col-md-6 comparefn comparisons compvalue config configuration controller currentfield currently currentview data december deps dinosaur directive disable disabled display displayed east elm events-label example-container exampledatatoolbar false february fields filter filterchange filterconfig filtering filters filterstext filtertype filtervalues flintstone foreach frank fred function getlistview gettilesview green grouped html icon iconclass includes invoke isascending isdisabled isseparator item item1 item2 items january john js judy july june length list list-style-type list-view-container listconfig listview livingston localecompare main march match matches matchesfilter matchesfilters menu module month monthvals moreactions ng-controller ng-if norfolk november null numeric october ohio onfilterchange onsortchange onviewselect optional options pat patternfly pennsylvania perform performaction pf-data-list pf-data-tiles pf-data-toolbar pfsimplefilter pfsimplesort pfviewutils pittsburgh placehodler placeholder primary primaryactions pulldown push resultscount return row rows script second secondary select selected selection selectionmatchprop selector separator september set settings smith sort sortchange sortconfig sorttype standard street style text thing thomas tiles-view-container tilesview title toolbar toolbarconfig tooltip true type unavailable undefined unique var view viewctrl viewid views viewsconfig viewselected viewtype virginia vm washingstone york"
    }
  ],
  "apis": {
    "api": true
  },
  "html5Mode": false,
  "editExample": true,
  "startPage": "/api",
  "scripts": [
    "jquery.js",
    "bootstrap.js",
    "bootstrap-combobox.js",
    "bootstrap-datepicker.js",
    "bootstrap-select.js",
    "bootstrap-treeview.js",
    "c3.js",
    "d3.js",
    "patternfly.js",
    "angular.js",
    "angular-sanitize.js",
    "angular-animate.js",
    "ui-bootstrap-tpls.js",
    "angular-bootstrap-prettify.js",
    "lodash.min.js",
    "angular-patternfly.js"
  ]
};