///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
// Console code placeholder
/// <reference path="../typings/tsd.d.ts"/>

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// <reference path="../includes.ts"/>
/// <reference path="../../libs/hawtio-utilities/defs.d.ts"/>

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// <reference path="../includes.ts"/>
/// <reference path="../../libs/hawtio-utilities/defs.d.ts"/>
/// <reference path="../../libs/hawtio-oauth/defs.d.ts"/>

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// <reference path="../includes.ts"/>

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// <reference path="../includes.ts"/>

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// <reference path="../includes.ts"/>
/// <reference path="../../libs/hawtio-utilities/defs.d.ts"/>
/// <reference path="../../libs/hawtio-core-dts/defs.d.ts"/>

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
var AccessPortal;
(function (AccessPortal) {
    AccessPortal.pluginName = 'RedhatAccessCases';
    AccessPortal.log = Logger.get(AccessPortal.pluginName);
    AccessPortal.templatePath = 'plugins/accessPortal/html';
})(AccessPortal || (AccessPortal = {}));

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// <reference path='accessPortalGlobals.ts'/>
var AccessPortal;
(function (AccessPortal) {
    AccessPortal._module = angular.module(AccessPortal.pluginName, ['ui.bootstrap']);
    AccessPortal._module.config([
        '$routeProvider', 'HawtioNavBuilderProvider',
        function ($routeProvider, builder) {
            $routeProvider
                .when('/hawkular-ui/access/search', { templateUrl: builder.join(AccessPortal.templatePath, 'search.html') })
                .when('/hawkular-ui/access/openCase', { templateUrl: builder.join(AccessPortal.templatePath, 'open_case.html') })
                .when('/hawkular-ui/access/myCases', { templateUrl: builder.join(AccessPortal.templatePath, 'my_cases.html') });
        }]);
    AccessPortal.AccessPortalMainController = AccessPortal._module.controller('AccessPortal.AccessPortalMainController', [
        '$window', function ($window) {
            var iframeHeight = $window.innerHeight * 0.8;
            ['myCasesWindow', 'openCaseWindow', 'searchWindow'].forEach(function (iframeId) {
                var iframeWindow = document.getElementById(iframeId);
                if (iframeWindow) {
                    iframeWindow['height'] = iframeHeight + 'px';
                }
            });
        }]);
    hawtioPluginLoader.addModule(AccessPortal.pluginName);
})(AccessPortal || (AccessPortal = {}));

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// <reference path='../../includes.ts'/>
var HawkularAccounts;
(function (HawkularAccounts) {
    HawkularAccounts.pluginName = 'hawkular-accounts';
    HawkularAccounts.log = Logger.get(HawkularAccounts.pluginName);
    HawkularAccounts.templatePath = 'plugins/accounts/html';
    HawkularAccounts._module = angular.module(HawkularAccounts.pluginName, ['ui.bootstrap']);
    var Invitation = (function () {
        function Invitation(email, role) {
            this.email = email;
            this.role = role;
        }
        return Invitation;
    })();
    HawkularAccounts.Invitation = Invitation;
    var Role = (function () {
        function Role(name) {
            this.name = name;
        }
        return Role;
    })();
    HawkularAccounts.Role = Role;
    (function (PersistenceState) {
        PersistenceState[PersistenceState["PERSISTING"] = 0] = "PERSISTING";
        PersistenceState[PersistenceState["SUCCESS"] = 1] = "SUCCESS";
        PersistenceState[PersistenceState["ERROR"] = 2] = "ERROR";
    })(HawkularAccounts.PersistenceState || (HawkularAccounts.PersistenceState = {}));
    var PersistenceState = HawkularAccounts.PersistenceState;
    ;
})(HawkularAccounts || (HawkularAccounts = {}));

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// <reference path='accountsGlobals.ts'/>
var HawkularAccounts;
(function (HawkularAccounts) {
    var currentPersona = undefined;
    HawkularAccounts._module.config(['$httpProvider', 'HawtioNavBuilderProvider', '$routeProvider',
        function ($httpProvider, builder, $routeProvider) {
            $httpProvider.interceptors.push(PersonaInterceptorService.Factory);
            $routeProvider
                .when('/hawkular-ui/organizations', { templateUrl: builder.join(HawkularAccounts.templatePath, 'organizations.html') })
                .when('/hawkular-ui/organization/:organizationId/memberships', { templateUrl: builder.join(HawkularAccounts.templatePath, 'organization-memberships.html') })
                .when('/hawkular-ui/invitation/accept/:token', { templateUrl: builder.join(HawkularAccounts.templatePath, 'organization-accept-invitation.html') })
                .when('/hawkular-ui/settings', { templateUrl: builder.join(HawkularAccounts.templatePath, 'user-settings.html') });
        }]);
    HawkularAccounts._module.run(['$rootScope', '$log', '$modal', '$document', 'userDetails',
        function ($rootScope, $log, $modal, $document, userDetails) {
            $rootScope.userDetails = userDetails;
            $rootScope.PersistenceState = HawkularAccounts.PersistenceState;
            $rootScope.$on('IdleStart', function () {
                $('#idle').slideDown();
            });
            $rootScope.$on('IdleEnd', function () {
                $('#idle').slideUp();
            });
            $rootScope.$on('IdleTimeout', function () {
                $log.debug('Idle timeout');
                $document.find('body').eq(0).addClass('inactivity-modal-open');
                $modal.open({
                    templateUrl: 'plugins/accounts/html/inactivityModal.html',
                    backdrop: 'static',
                    keyboard: false
                }).opened.then(function () {
                    HawtioKeycloak.keycloak.clearToken();
                });
            });
            $rootScope.$on('CurrentPersonaLoaded', function (e, persona) {
                currentPersona = persona;
                $rootScope.currentPersona = currentPersona;
            });
            $rootScope.$on('SwitchedPersona', function (e, persona) {
                currentPersona = persona;
                $rootScope.currentPersona = currentPersona;
            });
        }]);
    hawtioPluginLoader.registerPreBootstrapTask(function (next) {
        window['KeycloakConfig'] = '/keycloak.json';
        next();
    }, true);
    var PersonaInterceptorService = (function () {
        function PersonaInterceptorService($q) {
            this.$q = $q;
            this.request = function (request) {
                if (currentPersona) {
                    request.headers['Hawkular-Persona'] = currentPersona.id;
                }
                return request;
            };
        }
        PersonaInterceptorService.Factory = function ($q) {
            return new PersonaInterceptorService($q);
        };
        PersonaInterceptorService.$inject = ['$q'];
        return PersonaInterceptorService;
    })();
    hawtioPluginLoader.addModule(HawkularAccounts.pluginName);
})(HawkularAccounts || (HawkularAccounts = {}));

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// <reference path='accountsPlugin.ts'/>
var HawkularAccounts;
(function (HawkularAccounts) {
    var InvitationController = (function () {
        function InvitationController($log, $routeParams, HawkularAccount, NotificationsService) {
            var _this = this;
            this.$log = $log;
            this.$routeParams = $routeParams;
            this.HawkularAccount = HawkularAccount;
            this.NotificationsService = NotificationsService;
            this.loading = true;
            this.success = false;
            HawkularAccount.OrganizationInvitation.update({ token: $routeParams.token }, function (response) {
                _this.invitation = response;
                _this.$log.debug('Invitation object available:');
                _this.$log.debug(_this.invitation);
                _this.success = true;
                _this.loading = false;
            }, function (error) {
                _this.error = error;
                _this.success = false;
                _this.loading = false;
                _this.$log.debug("Error while trying to process the invitation: " + error.data.message);
            });
        }
        InvitationController.$inject = ['$log', '$routeParams', 'HawkularAccount', 'NotificationsService'];
        return InvitationController;
    })();
    HawkularAccounts.InvitationController = InvitationController;
    HawkularAccounts._module.controller('HawkularAccounts.InvitationController', InvitationController);
})(HawkularAccounts || (HawkularAccounts = {}));

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// <reference path='accountsPlugin.ts'/>
var HawkularAccounts;
(function (HawkularAccounts) {
    var OrganizationMembershipController = (function () {
        function OrganizationMembershipController($log, $rootScope, $scope, $routeParams, $modal, HawkularAccount, NotificationsService) {
            this.$log = $log;
            this.$rootScope = $rootScope;
            this.$scope = $scope;
            this.$routeParams = $routeParams;
            this.$modal = $modal;
            this.HawkularAccount = HawkularAccount;
            this.NotificationsService = NotificationsService;
            this.isAllowedToInvite = false;
            this.isAllowedToListPending = false;
            this.isAllowedToTransferOrganization = false;
            this.isAllowedToChangeRoleOfMembers = false;
            this.isOrganization = false;
            this.membershipsToUpdate = {};
            this.foundOrganization = false;
            this.prepareListeners();
            this.loadData();
            if (this.$rootScope.currentPersona) {
                this.isOrganization = this.$rootScope.currentPersona.id !== this.$rootScope.userDetails.id;
            }
        }
        OrganizationMembershipController.prototype.prepareListeners = function () {
            var _this = this;
            var organizationId = this.$routeParams.organizationId;
            this.$scope.$on('OrganizationLoaded', function () {
                _this.loadMemberships(organizationId);
            });
            this.$scope.$on('PermissionToListPendingLoaded', function () {
                if (_this.isAllowedToListPending) {
                    _this.loadPendingInvitations(organizationId);
                }
            });
            this.$scope.$on('PermissionToTransferOrganizationLoaded', function () {
                if (_this.isAllowedToTransferOrganization) {
                    _this.possibleRoles.push(new HawkularAccounts.Role('Owner'));
                }
            });
            this.$scope.$on('OwnershipChanged', function () {
                _this.loadPossibleRoles();
            });
            this.$rootScope.$on('SwitchedPersona', function (event, persona) {
                _this.isOrganization = persona.id !== _this.$rootScope.userDetails.id;
            });
        };
        OrganizationMembershipController.prototype.loadData = function () {
            this.loading = true;
            var organizationId = this.$routeParams.organizationId;
            this.loadOrganization(organizationId);
            this.loadPermissionToInvite(organizationId);
            this.loadPermissionToListPending(organizationId);
            this.loadPermissionToChangeRoleOfMembers(organizationId);
            this.loadPossibleRoles();
        };
        OrganizationMembershipController.prototype.loadPossibleRoles = function () {
            var organizationId = this.$routeParams.organizationId;
            this.possibleRoles = [
                new HawkularAccounts.Role('Monitor'),
                new HawkularAccounts.Role('Operator'),
                new HawkularAccounts.Role('Maintainer'),
                new HawkularAccounts.Role('Deployer'),
                new HawkularAccounts.Role('Administrator'),
                new HawkularAccounts.Role('Auditor'),
                new HawkularAccounts.Role('SuperUser')
            ];
            this.loadPermissionToTransferOrganization(organizationId);
        };
        OrganizationMembershipController.prototype.loadOrganization = function (organizationId) {
            var _this = this;
            this.organization = this.HawkularAccount.Organization.get({ id: organizationId }, function () {
                _this.foundOrganization = true;
                _this.$scope.$broadcast('OrganizationLoaded');
            }, function (error) {
                _this.$log.warn("Error while loading the organization: " + error.data.message);
                _this.loading = false;
            });
        };
        OrganizationMembershipController.prototype.loadMemberships = function (organizationId) {
            var _this = this;
            this.memberships = this.HawkularAccount.OrganizationMembership.query({ organizationId: organizationId }, function () {
                _this.loading = false;
                _this.$log.debug("Finished loading members. Size: " + _this.memberships.length);
            }, function (error) {
                _this.NotificationsService.error('List of memberships could NOT be retrieved.');
                _this.$log.warn("List of memberships could NOT be retrieved: " + error.data.message);
                _this.loading = false;
            });
        };
        OrganizationMembershipController.prototype.loadPendingInvitations = function (organizationId) {
            var _this = this;
            this.pending = this.HawkularAccount.OrganizationInvitation.query({ organizationId: organizationId }, function () {
                _this.$log.debug("Finished loading pending invitations. Size: " + _this.pending.length);
            }, function (error) {
                _this.$log.debug("Error while trying to load the pending invitations: " + error.data.message);
            });
        };
        OrganizationMembershipController.prototype.loadPermissionToInvite = function (organizationId) {
            var _this = this;
            var operationName = 'organization-invite';
            this.loadPermission(organizationId, operationName, function (response) {
                _this.isAllowedToInvite = response.permitted;
                _this.$log.debug("Finished checking if we can invite other users. Response: " + response.permitted);
            }, function (error) {
                _this.$log.debug("Error checking if we can invite other users. Response: " + error.data.message);
            });
        };
        OrganizationMembershipController.prototype.loadPermissionToListPending = function (organizationId) {
            var _this = this;
            var operationName = 'organization-list-invitations';
            this.loadPermission(organizationId, operationName, function (response) {
                _this.isAllowedToListPending = response.permitted;
                _this.$scope.$broadcast('PermissionToListPendingLoaded');
                _this.$log.debug("Finished checking if we can list the pending invitations. Response: " + response.permitted);
            }, function (error) {
                _this.$log.debug("Error checking if we can list the pending invitations. Response: " + error.data.message);
            });
        };
        OrganizationMembershipController.prototype.loadPermissionToTransferOrganization = function (organizationId) {
            var _this = this;
            var operationName = 'organization-transfer';
            this.loadPermission(organizationId, operationName, function (response) {
                _this.isAllowedToTransferOrganization = response.permitted;
                _this.$scope.$broadcast('PermissionToTransferOrganizationLoaded');
                _this.$log.debug("Finished checking if we can transfer this organization. Response: " + response.permitted);
            }, function (error) {
                _this.$log.debug("Error checking if we can transfer this organization. Response: " + error.data.message);
            });
        };
        OrganizationMembershipController.prototype.loadPermissionToChangeRoleOfMembers = function (organizationId) {
            var _this = this;
            var operationName = 'organization-change-role-of-members';
            this.loadPermission(organizationId, operationName, function (response) {
                _this.isAllowedToChangeRoleOfMembers = response.permitted;
                _this.$log.debug("Finished checking if we can change the role of members. Response: " + response.permitted);
            }, function (error) {
                _this.$log.debug("Error checking if we can change the role of members. Response: " + error.data.message);
            });
        };
        OrganizationMembershipController.prototype.loadPermission = function (resourceId, operationName, successCallback, errorCallback) {
            return this.HawkularAccount.Permission.get({ resourceId: resourceId, operation: operationName }, successCallback, errorCallback);
        };
        OrganizationMembershipController.prototype.showInviteModal = function () {
            var _this = this;
            var createFormModal = this.$modal.open({
                controller: 'HawkularAccounts.OrganizationInviteModalController as inviteModal',
                templateUrl: 'plugins/accounts/html/organization-invite.html'
            });
            createFormModal.result.then(function (emails) {
                emails.forEach(function (email) {
                    var invitation = new HawkularAccounts.Invitation(email, new HawkularAccounts.Role('Monitor'));
                    _this.pending.unshift(invitation);
                });
            });
        };
        OrganizationMembershipController.prototype.changeRole = function (membership) {
            var _this = this;
            if (membership.role === null) {
                return;
            }
            if (membership.role.name === 'Owner') {
                this.transferOwnership(membership);
                return;
            }
            this.membershipsToUpdate[membership.id] = HawkularAccounts.PersistenceState.PERSISTING;
            membership.$update(null, function (response) {
                _this.membershipsToUpdate[membership.id] = HawkularAccounts.PersistenceState.SUCCESS;
                // just for a moment, until we re-evaluate if the user still has the permission
                _this.isAllowedToChangeRoleOfMembers = false;
                _this.loadPermissionToChangeRoleOfMembers(_this.organization.id);
            }, function (error) {
                _this.membershipsToUpdate[membership.id] = HawkularAccounts.PersistenceState.ERROR;
                _this.$log.debug("Error changing role for membership. Response: " + error.data.message);
            });
        };
        OrganizationMembershipController.prototype.transferOwnership = function (membership) {
            var _this = this;
            if (!this.isAllowedToTransferOrganization) {
                this.NotificationsService.error('Error: You don\'t have the permissions to transfer this organization.');
                return;
            }
            var transferOrgModal = this.$modal.open({
                controller: 'HawkularAccounts.OrganizationTransferModalController as transferModal',
                templateUrl: 'plugins/accounts/html/organization-transfer-modal.html',
                resolve: {
                    organization: function () { return _this.organization; },
                    transferTo: function () { return membership.member; }
                }
            });
            transferOrgModal.result.then(function () {
                _this.organization.owner = membership.member;
                _this.membershipsToUpdate[membership.id] = HawkularAccounts.PersistenceState.PERSISTING;
                _this.organization.$update(null, function (response) {
                    _this.$scope.$broadcast('OwnershipChanged');
                    _this.membershipsToUpdate[membership.id] = HawkularAccounts.PersistenceState.SUCCESS;
                    _this.organization = response;
                    // now, we refresh the memberships we have, to make sure we have the most up to date IDs
                    _this.memberships = [];
                    _this.loading = true;
                    _this.loadMemberships(_this.organization.id);
                }, function (error) {
                    _this.membershipsToUpdate[membership.id] = HawkularAccounts.PersistenceState.ERROR;
                    _this.$log.debug("Error changing role for membership. Response: " + error.data.message);
                });
            }, function () {
                // the modal was dismissed, get the original data for this membership
                membership.$get();
            });
        };
        OrganizationMembershipController.$inject = ['$log', '$rootScope', '$scope', '$routeParams', '$modal',
            'HawkularAccount', 'NotificationsService'];
        return OrganizationMembershipController;
    })();
    HawkularAccounts.OrganizationMembershipController = OrganizationMembershipController;
    var OrganizationInviteModalController = (function () {
        function OrganizationInviteModalController($log, $routeParams, $modalInstance, HawkularAccount, NotificationsService) {
            this.$log = $log;
            this.$routeParams = $routeParams;
            this.$modalInstance = $modalInstance;
            this.HawkularAccount = HawkularAccount;
            this.NotificationsService = NotificationsService;
            this.invitation = new HawkularAccount.OrganizationInvitation({ organizationId: $routeParams.organizationId });
        }
        OrganizationInviteModalController.prototype.cancel = function () {
            this.$modalInstance.dismiss('cancel');
        };
        OrganizationInviteModalController.prototype.invite = function () {
            var _this = this;
            this.invitation.$save(function () {
                _this.NotificationsService.success('Invitation successfully sent.');
                _this.$modalInstance.close(_this.invitation.emails
                    .split(/[,\s]/)
                    .filter(function (entry) {
                    return entry && entry.length > 0;
                }));
            }, function (error) {
                _this.NotificationsService.error('An error occurred while trying to send the invitations.');
                _this.$log.debug("Error while trying to send invitations: " + error.data.message);
                _this.$modalInstance.close('error');
            });
        };
        OrganizationInviteModalController.$inject = ['$log', '$routeParams', '$modalInstance', 'HawkularAccount', 'NotificationsService'];
        return OrganizationInviteModalController;
    })();
    HawkularAccounts.OrganizationInviteModalController = OrganizationInviteModalController;
    var OrganizationTransferModalController = (function () {
        function OrganizationTransferModalController($log, $routeParams, $modalInstance, organization, transferTo) {
            this.$log = $log;
            this.$routeParams = $routeParams;
            this.$modalInstance = $modalInstance;
            this.organization = organization;
            this.transferTo = transferTo;
            this.$log.debug('Organization received: ');
            this.$log.debug(organization);
        }
        OrganizationTransferModalController.prototype.cancel = function () {
            this.$modalInstance.dismiss('cancel');
        };
        OrganizationTransferModalController.prototype.transfer = function () {
            this.$modalInstance.close('transfer');
        };
        OrganizationTransferModalController.$inject = ['$log', '$routeParams', '$modalInstance', 'organization', 'transferTo'];
        return OrganizationTransferModalController;
    })();
    HawkularAccounts.OrganizationTransferModalController = OrganizationTransferModalController;
    HawkularAccounts._module.controller('HawkularAccounts.OrganizationMembershipController', OrganizationMembershipController);
    HawkularAccounts._module.controller('HawkularAccounts.OrganizationInviteModalController', OrganizationInviteModalController);
    HawkularAccounts._module.controller('HawkularAccounts.OrganizationTransferModalController', OrganizationTransferModalController);
})(HawkularAccounts || (HawkularAccounts = {}));

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// <reference path='accountsPlugin.ts'/>
var HawkularAccounts;
(function (HawkularAccounts) {
    var OrganizationsController = (function () {
        function OrganizationsController($rootScope, $scope, $modal, $log, HawkularAccount, NotificationsService) {
            this.$rootScope = $rootScope;
            this.$scope = $scope;
            this.$modal = $modal;
            this.$log = $log;
            this.HawkularAccount = HawkularAccount;
            this.NotificationsService = NotificationsService;
            this.loading = true;
            this.isOrganization = false;
            this.prepareListeners();
            this.loadData();
            if (this.$rootScope.currentPersona) {
                this.isOrganization = this.$rootScope.currentPersona.id !== this.$rootScope.userDetails.id;
            }
        }
        OrganizationsController.prototype.prepareListeners = function () {
            var _this = this;
            this.$rootScope.$on('SwitchedPersona', function (event, persona) {
                _this.loadData();
                _this.isOrganization = persona.id !== _this.$rootScope.userDetails.id;
            });
        };
        OrganizationsController.prototype.loadData = function () {
            var _this = this;
            this.loading = true;
            this.organizations = this.HawkularAccount.Organization.query({}, function (response) {
                _this.loading = false;
            }, function (error) {
                _this.$log.warn("List of organizations could NOT be retrieved: " + error.data.message);
                _this.NotificationsService.warning("List of organizations could NOT be retrieved: " + error.data.message);
                _this.loading = false;
            });
        };
        OrganizationsController.prototype.showCreateForm = function () {
            var _this = this;
            this.$modal.open({
                controller: 'HawkularAccounts.OrganizationNewController as newModal',
                templateUrl: 'plugins/accounts/html/organization-new.html'
            })
                .result
                .then(function (organization) {
                _this.NotificationsService.success('Organization successfully created.');
                _this.organizations.unshift(organization);
            }, function (type, error) {
                if (type === 'error') {
                    _this.NotificationsService.error("Error while creating organization: " + error.data.message);
                }
            });
        };
        OrganizationsController.prototype.remove = function (organization) {
            var _this = this;
            this.$modal.open({
                controller: 'HawkularAccounts.OrganizationRemoveController as removeModal',
                templateUrl: 'plugins/accounts/html/organization-remove-modal.html',
                resolve: {
                    organization: function () { return organization; }
                }
            })
                .result
                .then(function () {
                organization.$remove({}, function () {
                    _this.NotificationsService.success('Organization successfully deleted.');
                    _this.$rootScope.$broadcast('OrganizationRemoved');
                    _this.organizations.splice(_this.organizations.indexOf(organization), 1);
                }, function (error) {
                    var message = "Failed to remove the organization " + organization.name + ": " + error.data.message;
                    _this.$log.warn(message);
                    _this.NotificationsService.error(message);
                });
            });
        };
        OrganizationsController.$inject = ['$rootScope', '$scope', '$modal', '$log', 'HawkularAccount', 'NotificationsService'];
        return OrganizationsController;
    })();
    HawkularAccounts.OrganizationsController = OrganizationsController;
    var OrganizationNewController = (function () {
        function OrganizationNewController($rootScope, $scope, $modalInstance, $log, HawkularAccount) {
            this.$rootScope = $rootScope;
            this.$scope = $scope;
            this.$modalInstance = $modalInstance;
            this.$log = $log;
            this.HawkularAccount = HawkularAccount;
            this.organizationNew = new HawkularAccount.Organization();
        }
        OrganizationNewController.prototype.cancel = function () {
            this.$modalInstance.dismiss('cancel');
        };
        OrganizationNewController.prototype.persist = function () {
            var _this = this;
            this.organizationNew.$save({}, function (organization) {
                _this.$rootScope.$broadcast('OrganizationCreated');
                _this.$modalInstance.close(organization);
            }, function (error) {
                _this.$log.debug("Organization could NOT be added: " + error.data.message);
                _this.$modalInstance.dismiss('error', error);
            });
        };
        OrganizationNewController.$inject = ['$rootScope', '$scope', '$modalInstance', '$log', 'HawkularAccount'];
        return OrganizationNewController;
    })();
    HawkularAccounts.OrganizationNewController = OrganizationNewController;
    var OrganizationRemoveController = (function () {
        function OrganizationRemoveController($scope, $modalInstance, organization) {
            this.$scope = $scope;
            this.$modalInstance = $modalInstance;
            this.organization = organization;
        }
        OrganizationRemoveController.prototype.cancel = function () {
            this.$modalInstance.dismiss('cancel');
        };
        OrganizationRemoveController.prototype.remove = function () {
            this.$modalInstance.close();
        };
        OrganizationRemoveController.$inject = ['$scope', '$modalInstance', 'organization'];
        return OrganizationRemoveController;
    })();
    HawkularAccounts.OrganizationRemoveController = OrganizationRemoveController;
    HawkularAccounts._module.controller('HawkularAccounts.OrganizationsController', OrganizationsController);
    HawkularAccounts._module.controller('HawkularAccounts.OrganizationNewController', OrganizationNewController);
    HawkularAccounts._module.controller('HawkularAccounts.OrganizationRemoveController', OrganizationRemoveController);
})(HawkularAccounts || (HawkularAccounts = {}));

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// <reference path='accountsPlugin.ts'/>
var HawkularAccounts;
(function (HawkularAccounts) {
    var PersonaController = (function () {
        function PersonaController($rootScope, $scope, $log, HawkularAccount, NotificationsService) {
            this.$rootScope = $rootScope;
            this.$scope = $scope;
            this.$log = $log;
            this.HawkularAccount = HawkularAccount;
            this.NotificationsService = NotificationsService;
            this.loading = true;
            this.prepareListeners();
            this.loadData();
        }
        PersonaController.prototype.prepareListeners = function () {
            var _this = this;
            this.$rootScope.$on('CurrentPersonaLoaded', function () {
                _this.loadPersonas();
            });
            this.$rootScope.$on('OrganizationCreated', function () {
                _this.loadPersonas();
            });
            this.$rootScope.$on('OrganizationRemoved', function () {
                _this.loadPersonas();
            });
        };
        PersonaController.prototype.loadData = function () {
            var _this = this;
            this.loading = true;
            this.currentPersona = this.HawkularAccount.Persona.get({ id: 'current' }, function (response) {
                _this.$rootScope.$broadcast('CurrentPersonaLoaded', response);
            }, function (error) {
                _this.NotificationsService.error("Failed to retrieve the current persona: " + error.data.message);
                _this.$log.warn("Failed to retrieve the current persona: " + error.data.message);
            });
        };
        PersonaController.prototype.loadPersonas = function () {
            var _this = this;
            this.personas = this.HawkularAccount.Persona.query({}, function (response) {
                _this.loading = false;
            }, function (error) {
                _this.NotificationsService.error("Failed to retrieve the list of possible personas: " + error.data.message);
                _this.$log.warn("Failed to retrieve the list of possible personas: " + error.data.message);
                _this.loading = false;
            });
        };
        PersonaController.prototype.switchPersona = function (persona) {
            this.currentPersona = persona;
            this.$rootScope.$broadcast('SwitchedPersona', persona);
        };
        PersonaController.$inject = ['$rootScope', '$scope', '$log', 'HawkularAccount', 'NotificationsService'];
        return PersonaController;
    })();
    HawkularAccounts.PersonaController = PersonaController;
    HawkularAccounts._module.controller('HawkularAccounts.PersonaController', PersonaController);
})(HawkularAccounts || (HawkularAccounts = {}));

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// <reference path='accountsPlugin.ts'/>
var HawkularAccounts;
(function (HawkularAccounts) {
    var UserSettingsController = (function () {
        function UserSettingsController($log, $rootScope, HawkularAccount, NotificationsService) {
            this.$log = $log;
            this.$rootScope = $rootScope;
            this.HawkularAccount = HawkularAccount;
            this.NotificationsService = NotificationsService;
            this.prepareListeners();
            this.loadData();
            if (this.$rootScope.currentPersona) {
                this.isOrganization = this.$rootScope.currentPersona.id !== this.$rootScope.userDetails.id;
            }
        }
        UserSettingsController.prototype.prepareListeners = function () {
            var _this = this;
            this.$rootScope.$on('SwitchedPersona', function (event, persona) {
                _this.isOrganization = persona.id !== _this.$rootScope.userDetails.id;
            });
        };
        UserSettingsController.prototype.loadData = function () {
            this.loading = true;
            this.loadSettings();
        };
        UserSettingsController.prototype.loadSettings = function () {
            var _this = this;
            this.settings = this.HawkularAccount.Settings.get({}, function (settings) {
                _this.loading = false;
            }, function (error) {
                _this.NotificationsService.warning('User settings could not be loaded.');
                _this.$log.warn("Error while loading the organization: " + error.data.message);
                _this.loading = false;
            });
        };
        UserSettingsController.prototype.save = function () {
            var _this = this;
            this.settings.$update({}, function (settings) {
                _this.NotificationsService.success('User settings successfully updated.');
            }, function (error) {
                _this.NotificationsService.error('User settings could not be updated.');
            });
        };
        UserSettingsController.$inject = ['$log', '$rootScope', 'HawkularAccount', 'NotificationsService'];
        return UserSettingsController;
    })();
    HawkularAccounts.UserSettingsController = UserSettingsController;
    HawkularAccounts._module.controller('HawkularAccounts.UserSettingsController', UserSettingsController);
})(HawkularAccounts || (HawkularAccounts = {}));

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
var HawkularMetrics;
(function (HawkularMetrics) {
    /// NOTE: this pattern is used because enums cant be used with strings
    var EventNames = (function () {
        function EventNames(value) {
            this.value = value;
            // empty
        }
        EventNames.prototype.toString = function () {
            return this.value;
        };
        EventNames.TIMERANGE_CHANGED = new EventNames('TimeRangeChanged');
        EventNames.REFRESH_CHART = new EventNames('RefreshChart');
        EventNames.REFRESH_AVAIL_CHART = new EventNames('RefreshAvailabilityChart');
        EventNames.SWITCHED_PERSONA = new EventNames('SwitchedPersona');
        EventNames.CURRENT_PERSONA_LOADED = new EventNames('CurrentPersonaLoaded');
        EventNames.IDLE_TIMEOUT = new EventNames('IdleTimeout');
        EventNames.IDLE_START = new EventNames('IdleStart');
        EventNames.IDLE_END = new EventNames('IdleEnd');
        return EventNames;
    })();
    HawkularMetrics.EventNames = EventNames;
})(HawkularMetrics || (HawkularMetrics = {}));

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// <reference path='../../includes.ts'/>
var HawkularMetrics;
(function (HawkularMetrics) {
    /// some config vars
    HawkularMetrics.pluginName = 'hawkular-metrics';
    HawkularMetrics.templatePath = 'plugins/metrics/html';
    /// These are plugin globals used across several screens (think session vars from server side programming)
    HawkularMetrics.globalEnvironmentId = 'test';
})(HawkularMetrics || (HawkularMetrics = {}));

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// <reference path='../../includes.ts'/>
/// <reference path='metricsGlobals.ts'/>
var HawkularMetrics;
(function (HawkularMetrics) {
    HawkularMetrics._module = angular.module(HawkularMetrics.pluginName, ['ngResource', 'ui.select', 'hawkular.charts',
        'hawkular.services', 'ui.bootstrap', 'topbar', 'patternfly.select', 'angular-momentjs', 'angular-md5', 'toastr',
        'infinite-scroll', 'mgo-angular-wizard', 'truncate', '500tech.smart-truncate']);
    HawkularMetrics._module.config(['$compileProvider', function ($compileProvider) {
            //disable debug info
            //NOTE: tools like Batarang and Protractor may not work properly with this debug info off
            //However, this can be turned back on at runtime in the js console by typing: angular.reloadWithDebugInfo()
            $compileProvider.debugInfoEnabled(false);
        }]);
    HawkularMetrics._module.config(['$httpProvider', '$locationProvider', '$routeProvider',
        function ($httpProvider, $locationProvider) {
            $locationProvider.html5Mode(true);
        }]);
    HawkularMetrics._module.config(['$routeProvider', function ($routeProvider) {
            $routeProvider.
                when('/metrics/response-time', {
                templateUrl: 'plugins/metrics/html/url-response-time.html',
                resolve: {
                    hkResourceList: function ($route, $filter, $location, $rootScope, $q, HawkularInventory) {
                        var idParts = $route.current.params.resourceId.split('~');
                        var feedId = idParts[0];
                        var resPromise = HawkularInventory.ResourceUnderFeed.query({
                            environmentId: HawkularMetrics.globalEnvironmentId,
                            feedId: feedId
                        }).$promise;
                        resPromise.then(function (hkResourceList) {
                            $location.path('/metrics/response-time/' + hkResourceList[0].id);
                        }, function () {
                            $location.url('/error');
                        });
                        // Returning a promise which would never be resolved, so that the page would not render.
                        // The page will be redirected before rendering based on the resource list loaded above.
                        return $q.defer().promise;
                    }
                }
            }).when('/hawkular-ui/url/url-list', { templateUrl: 'plugins/metrics/html/url-list.html' }).
                when('/hawkular-ui/url/response-time/:resourceId/:timeOffset?/:endTime?', {
                templateUrl: 'plugins/metrics/html/url-response-time.html',
                reloadOnSearch: false,
                resolve: {
                    resource: function ($route, $location, HawkularInventory, NotificationsService) {
                        var p = HawkularInventory.Resource.get({
                            environmentId: HawkularMetrics.globalEnvironmentId, resourcePath: $route.current.params.resourceId
                        }).$promise;
                        p.then(function (response) {
                            return response.properties.url;
                        }, function (error) {
                            NotificationsService.info('You were redirected to this page because you requested an invalid URL.');
                            $location.path('/');
                        });
                        return p;
                    }
                }
            }).
                when('/hawkular-ui/url/availability/:resourceId/:timeOffset?/:endTime?', {
                templateUrl: 'plugins/metrics/html/url-availability.html',
                reloadOnSearch: false,
                resolve: {
                    resource: function ($route, $location, HawkularInventory, NotificationsService) {
                        var p = HawkularInventory.Resource.get({
                            environmentId: HawkularMetrics.globalEnvironmentId, resourcePath: $route.current.params.resourceId
                        }).$promise;
                        p.then(function (response) {
                            return response.properties.url;
                        }, function (error) {
                            NotificationsService.info('You were redirected to this page because you requested an invalid URL.');
                            $location.path('/');
                        });
                        return p;
                    }
                }
            }).
                when('/hawkular-ui/url/alerts/:resourceId/:timeOffset?/:endTime?', {
                templateUrl: 'plugins/metrics/html/url-alerts.html',
                reloadOnSearch: false,
                resolve: {
                    resource: function ($route, $location, HawkularInventory, NotificationsService) {
                        var p = HawkularInventory.Resource.get({
                            environmentId: HawkularMetrics.globalEnvironmentId, resourcePath: $route.current.params.resourceId
                        }).$promise;
                        p.then(function (response) {
                            return response.properties.url;
                        }, function (error) {
                            NotificationsService.info('You were redirected to this page because you requested an invalid URL.');
                            $location.path('/');
                        });
                        return p;
                    }
                }
            }).
                when('/hawkular-ui/app/app-list', { templateUrl: 'plugins/metrics/html/app-server-list.html' }).
                when('/hawkular-ui/app/app-details/:resourceId/:tabId/:timeOffset?/:endTime?', {
                templateUrl: 'plugins/metrics/html/app-details/app-server-details.html',
                reloadOnSearch: false,
                resolve: {
                    resource: function ($route, $location, HawkularInventory, NotificationsService) {
                        var redirectMissingAppServer = function () {
                            NotificationsService.info('You were redirected to this page because you requested an invalid ' +
                                'Application Server.');
                            $location.path('/hawkular-ui/app/app-list');
                        };
                        var checkAppServerExists = function () {
                            var idParts = $route.current.params.resourceId.split('~');
                            if (idParts.length !== 2) {
                                redirectMissingAppServer();
                                return;
                            }
                            var p = HawkularInventory.ResourceUnderFeed.get({
                                environmentId: HawkularMetrics.globalEnvironmentId,
                                feedId: idParts[0],
                                resourcePath: $route.current.params.resourceId + '~~'
                            }).$promise;
                            p.then(function (response) {
                                return response;
                            }, function (error) { return redirectMissingAppServer(); });
                            return p;
                        };
                        return checkAppServerExists();
                    }
                }
            }).
                when('/hawkular-ui/alerts-center/:timeOffset?/:endTime?', {
                templateUrl: 'plugins/metrics/html/alerts-center-list.html',
                controller: 'AlertsCenterController',
                controllerAs: 'ac'
            }).
                when('/hawkular-ui/alerts-center-detail/:alertId/:timeOffset?/:endTime?', {
                templateUrl: 'plugins/metrics/html/alerts-center-detail.html',
                controller: 'AlertsCenterDetailsController',
                controllerAs: 'acd'
            }).
                when('/hawkular-ui/alerts-center-triggers', {
                templateUrl: 'plugins/metrics/html/alerts-center-triggers.html',
                controller: 'AlertsCenterTriggerController',
                controllerAs: 'act'
            }).
                otherwise({ redirectTo: '/hawkular-ui/app/app-list' });
        }]);
    // so the same scroll doesn't trigger multiple times
    angular.module('infinite-scroll').value('THROTTLE_MILLISECONDS', 250);
    hawtioPluginLoader.addModule(HawkularMetrics.pluginName);
})(HawkularMetrics || (HawkularMetrics = {}));

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// <reference path="../metricsPlugin.ts"/>
/// <reference path="../../includes.ts"/>
var HawkularMetrics;
(function (HawkularMetrics) {
    (function (AlertType) {
        AlertType[AlertType["AVAILABILITY"] = 0] = "AVAILABILITY";
        AlertType[AlertType["THRESHOLD"] = 1] = "THRESHOLD";
        AlertType[AlertType["RANGE"] = 2] = "RANGE";
    })(HawkularMetrics.AlertType || (HawkularMetrics.AlertType = {}));
    var AlertType = HawkularMetrics.AlertType;
    var HawkularAlertsManager = (function () {
        function HawkularAlertsManager(HawkularAlert, $q, $log, $moment, NotificationsService, ErrorsManager) {
            this.HawkularAlert = HawkularAlert;
            this.$q = $q;
            this.$log = $log;
            this.$moment = $moment;
            this.NotificationsService = NotificationsService;
            this.ErrorsManager = ErrorsManager;
        }
        HawkularAlertsManager.prototype.queryAlerts = function (criteria) {
            var _this = this;
            var alertList = [];
            var headers;
            /* Format of Alerts:
      
             alert: {
              type: 'THRESHOLD' or 'AVAILABILITY',
              avg: Average value based on the evalSets 'values',
              start: The time of the first data ('dataTimestamp') in evalSets,
              threshold: The threshold taken from condition.threshold,
              end: The time when the alert was sent ('ctime')
             }
      
             */
            var queryParams = {};
            if (criteria && criteria.startTime) {
                queryParams['startTime'] = criteria.startTime;
            }
            if (criteria && criteria.endTime) {
                queryParams['endTime'] = criteria.endTime;
            }
            if (criteria && criteria.alertIds) {
                queryParams['alertIds'] = criteria.alertIds;
            }
            if (criteria && criteria.triggerIds) {
                queryParams['triggerIds'] = criteria.triggerIds;
            }
            if (criteria && criteria.statuses) {
                queryParams['statuses'] = criteria.statuses;
            }
            if (criteria && criteria.severities) {
                queryParams['severities'] = criteria.severities;
            }
            if (criteria && criteria.tags) {
                queryParams['tags'] = criteria.tags;
            }
            if (criteria && criteria.thin) {
                queryParams['thin'] = criteria.thin;
            }
            if (criteria && criteria.currentPage && criteria.currentPage !== 0) {
                queryParams['page'] = criteria.currentPage;
            }
            if (criteria && criteria.perPage) {
                queryParams['per_page'] = criteria.perPage;
            }
            if (criteria && criteria.sort) {
                queryParams['sort'] = criteria.sort;
            }
            if (criteria && criteria.order) {
                queryParams['order'] = criteria.order;
            }
            return this.HawkularAlert.Alert.query(queryParams, function (serverAlerts, getHeaders) {
                headers = getHeaders();
                var momentNow = _this.$moment();
                for (var i = 0; i < serverAlerts.length; i++) {
                    var serverAlert = serverAlerts[i];
                    var consoleAlert = serverAlert;
                    consoleAlert.id = serverAlert.alertId;
                    consoleAlert.triggerId = serverAlert.triggerId;
                    if (serverAlert.evalSets && serverAlert.evalSets[0] && serverAlert.evalSets[0][0]) {
                        consoleAlert.dataId = serverAlert.evalSets[0][0].condition.dataId;
                    }
                    consoleAlert.end = serverAlert.ctime;
                    var sum = 0.0;
                    var count = 0.0;
                    if (serverAlert.evalSets) {
                        for (var j = 0; j < serverAlert.evalSets.length; j++) {
                            var evalItem = serverAlert.evalSets[j][0];
                            if (!consoleAlert.start && evalItem.dataTimestamp) {
                                consoleAlert.start = evalItem.dataTimestamp;
                            }
                            if (!consoleAlert.threshold && evalItem.condition.threshold) {
                                consoleAlert.threshold = evalItem.condition.threshold;
                            }
                            if (!consoleAlert.type && evalItem.condition.type) {
                                consoleAlert.type = evalItem.condition.type;
                            }
                            var momentAlert = _this.$moment(consoleAlert.end);
                            if (momentAlert.year() === momentNow.year()) {
                                consoleAlert.isThisYear = true;
                                if (momentAlert.dayOfYear() === momentNow.dayOfYear()) {
                                    consoleAlert.isToday = true;
                                }
                            }
                            sum += evalItem.value;
                            count++;
                        }
                        consoleAlert.avg = sum / count;
                        consoleAlert.durationTime = consoleAlert.end - consoleAlert.start;
                    }
                    alertList.push(consoleAlert);
                }
            }, function (error) {
                _this.$log.debug('querying data error', error);
            }).$promise.then(function () {
                return {
                    alertList: alertList,
                    headers: headers
                };
            });
        };
        HawkularAlertsManager.prototype.getAlert = function (alertId) {
            return this.HawkularAlert.Alert.get({ alertId: alertId }).$promise;
        };
        HawkularAlertsManager.prototype.queryActionsHistory = function (criteria) {
            var _this = this;
            var actionHistoryList = [];
            var headers;
            var queryParams = {};
            if (criteria && criteria.alertIds) {
                queryParams['alertIds'] = criteria.alertIds;
            }
            if (criteria && criteria.actionPlugins) {
                queryParams['actionPlugins'] = criteria.actionPlugins;
            }
            if (criteria && criteria.actionIds) {
                queryParams['actionIds'] = criteria.actionIds;
            }
            if (criteria && criteria.results) {
                queryParams['results'] = criteria.results;
            }
            if (criteria) {
                queryParams['thin'] = criteria.thin;
            }
            else {
                queryParams['thin'] = true;
            }
            if (criteria && criteria.startTime) {
                queryParams['startTime'] = criteria.startTime;
            }
            if (criteria && criteria.endTime) {
                queryParams['endTime'] = criteria.endTime;
            }
            if (criteria && criteria.currentPage && criteria.currentPage !== 0) {
                queryParams['page'] = criteria.currentPage;
            }
            if (criteria && criteria.perPage) {
                queryParams['per_page'] = criteria.perPage;
            }
            if (criteria && criteria.sort) {
                queryParams['sort'] = criteria.sort;
            }
            if (criteria && criteria.order) {
                queryParams['order'] = criteria.order;
            }
            return this.HawkularAlert.Action.queryHistory(queryParams, function (serverActionsHistory, getHeaders) {
                headers = getHeaders();
                actionHistoryList = serverActionsHistory;
            }, function (error) {
                _this.$log.debug('querying data error', error);
            }).$promise.then(function () {
                return {
                    actionsList: actionHistoryList,
                    headers: headers
                };
            });
        };
        HawkularAlertsManager.prototype.resolveAlerts = function (resolvedAlerts) {
            return this.HawkularAlert.Alert.resolvemany(resolvedAlerts, {}).$promise;
        };
        HawkularAlertsManager.prototype.addNote = function (alertNote) {
            return this.HawkularAlert.Alert.note(alertNote).$promise;
        };
        HawkularAlertsManager.prototype.ackAlerts = function (ackAlerts) {
            return this.HawkularAlert.Alert.ackmany(ackAlerts, {}).$promise;
        };
        HawkularAlertsManager.prototype.existTrigger = function (triggerId) {
            return this.HawkularAlert.Trigger.get({ triggerId: triggerId }).$promise;
        };
        HawkularAlertsManager.prototype.getTrigger = function (triggerId) {
            var _this = this;
            var deffered = this.$q.defer();
            var trigger = {};
            this.HawkularAlert.Trigger.get({ triggerId: triggerId }).$promise.then(function (triggerData) {
                trigger['trigger'] = triggerData;
                return _this.HawkularAlert.Dampening.query({ triggerId: triggerId }).$promise;
            }).then(function (dampeningData) {
                trigger['dampenings'] = dampeningData;
                return _this.HawkularAlert.Conditions.query({ triggerId: triggerId }).$promise;
            }).then(function (conditionData) {
                trigger['conditions'] = conditionData;
                deffered.resolve(trigger);
            });
            return deffered.promise;
        };
        HawkularAlertsManager.prototype.getTriggerConditions = function (triggerId) {
            return this.HawkularAlert.Conditions.query({ triggerId: triggerId }).$promise;
        };
        HawkularAlertsManager.prototype.createTrigger = function (fullTrigger, errorCallback) {
            var _this = this;
            var triggerDefaults = {
                description: 'Created on ' + Date(),
                firingMatch: 'ALL',
                autoResolveMatch: 'ALL',
                enabled: true,
                autoResolve: true,
                actions: {}
            };
            var trigger = angular.extend(triggerDefaults, fullTrigger.trigger);
            return this.HawkularAlert.Trigger.save(trigger).$promise.then(function (savedTrigger) {
                var dampeningPromises = [];
                for (var i = 0; fullTrigger.dampenings && i < fullTrigger.dampenings.length; i++) {
                    if (fullTrigger.dampenings[i]) {
                        var dampeningPromise = _this.HawkularAlert.Dampening.save({ triggerId: savedTrigger.id }, fullTrigger.dampenings[i]).$promise.then(null, function (error) {
                            return _this.ErrorsManager.errorHandler(error, 'Error creating dampening.', errorCallback);
                        });
                        dampeningPromises.push(dampeningPromise);
                    }
                }
                var firingConditions = [];
                var autoResolveConditions = [];
                for (var j = 0; fullTrigger.conditions && j < fullTrigger.conditions.length; j++) {
                    if (fullTrigger.conditions[j]) {
                        if (fullTrigger.conditions[j].triggerMode && fullTrigger.conditions[j].triggerMode === 'AUTORESOLVE') {
                            autoResolveConditions.push(fullTrigger.conditions[j]);
                        }
                        else {
                            // A condition without triggerMode is treated as FIRING
                            firingConditions.push(fullTrigger.conditions[j]);
                        }
                    }
                }
                var conditionPromises = [];
                if (firingConditions.length > 0) {
                    var conditionPromise = _this.HawkularAlert.Conditions.save({
                        triggerId: savedTrigger.id,
                        triggerMode: 'FIRING'
                    }, firingConditions).$promise.then(null, function (error) {
                        return _this.ErrorsManager.errorHandler(error, 'Error creating firing conditions.', errorCallback);
                    });
                    conditionPromises.push(conditionPromise);
                }
                if (autoResolveConditions.length > 0) {
                    var conditionPromise = _this.HawkularAlert.Conditions.save({
                        triggerId: savedTrigger.id,
                        triggerMode: 'AUTORESOLVE'
                    }, autoResolveConditions).$promise.then(null, function (error) {
                        return _this.ErrorsManager.errorHandler(error, 'Error creating autoresolve conditions.', errorCallback);
                    });
                    conditionPromises.push(conditionPromise);
                }
                return _this.$q.all(Array.prototype.concat(dampeningPromises, conditionPromises));
            });
        };
        HawkularAlertsManager.prototype.deleteTrigger = function (triggerId) {
            return this.HawkularAlert.Trigger.delete({ triggerId: triggerId }).$promise;
        };
        HawkularAlertsManager.prototype.updateTrigger = function (fullTrigger, errorCallback, backupTrigger) {
            var _this = this;
            var emailPromise = this.addEmailAction(fullTrigger.trigger.actions.email[0]).then(function () {
                if (angular.equals(fullTrigger.trigger, backupTrigger.trigger) || !fullTrigger.trigger) {
                    return;
                }
                return _this.HawkularAlert.Trigger.put({ triggerId: fullTrigger.trigger.id }, fullTrigger.trigger).$promise;
            }, function (error) {
                return _this.ErrorsManager.errorHandler(error, 'Error saving email action.', errorCallback);
            });
            var triggerId = fullTrigger.trigger.id;
            var dampeningPromises = [];
            for (var i = 0; fullTrigger.dampenings && i < fullTrigger.dampenings.length; i++) {
                if (fullTrigger.dampenings[i] && !angular.equals(fullTrigger.dampenings[i], backupTrigger.dampenings[i])) {
                    var dampeningId = fullTrigger.dampenings[i].dampeningId;
                    var dampeningPromise = this.HawkularAlert.Dampening.put({ triggerId: triggerId, dampeningId: dampeningId }, fullTrigger.dampenings[i]).$promise.then(null, function (error) {
                        return _this.ErrorsManager.errorHandler(error, 'Error saving dampening.', errorCallback);
                    });
                    dampeningPromises.push(dampeningPromise);
                }
            }
            var firingConditions = [];
            var autoResolveConditions = [];
            for (var j = 0; fullTrigger.conditions && j < fullTrigger.conditions.length; j++) {
                if (fullTrigger.conditions[j]) {
                    if (fullTrigger.conditions[j].triggerMode && fullTrigger.conditions[j].triggerMode === 'AUTORESOLVE') {
                        autoResolveConditions.push(fullTrigger.conditions[j]);
                    }
                    else {
                        // A condition without triggerMode is treated as FIRING
                        firingConditions.push(fullTrigger.conditions[j]);
                    }
                }
            }
            var conditionPromises = [];
            if (firingConditions.length > 0) {
                var conditionPromise = this.HawkularAlert.Conditions.save({
                    triggerId: triggerId,
                    triggerMode: 'FIRING'
                }, firingConditions).$promise.then(null, function (error) {
                    return _this.ErrorsManager.errorHandler(error, 'Error creating firing conditions.', errorCallback);
                });
                conditionPromises.push(conditionPromise);
            }
            if (autoResolveConditions.length > 0) {
                var conditionPromise = this.HawkularAlert.Conditions.save({
                    triggerId: triggerId,
                    triggerMode: 'AUTORESOLVE'
                }, autoResolveConditions).$promise.then(null, function (error) {
                    return _this.ErrorsManager.errorHandler(error, 'Error creating autoresolve conditions.', errorCallback);
                });
                conditionPromises.push(conditionPromise);
            }
            return this.$q.all(Array.prototype.concat(emailPromise, dampeningPromises, conditionPromises));
        };
        HawkularAlertsManager.prototype.queryTriggers = function (criteria) {
            var _this = this;
            var triggerList = [];
            var headers;
            /* Format of Triggers:
      
             trigger: {
             }
      
             */
            var queryParams = {};
            if (criteria && criteria.triggerIds) {
                queryParams['triggerIds'] = criteria.triggerIds;
            }
            if (criteria && criteria.tags) {
                queryParams['tags'] = criteria.tags;
            }
            if (criteria && criteria.thin) {
                queryParams['thin'] = criteria.thin;
            }
            if (criteria && criteria.currentPage && criteria.currentPage !== 0) {
                queryParams['page'] = criteria.currentPage;
            }
            if (criteria && criteria.perPage) {
                queryParams['per_page'] = criteria.perPage;
            }
            if (criteria && criteria.sort) {
                queryParams['sort'] = criteria.sort;
            }
            if (criteria && criteria.order) {
                queryParams['order'] = criteria.order;
            }
            return this.HawkularAlert.Trigger.query(queryParams, function (serverTriggers, getHeaders) {
                headers = getHeaders();
                var momentNow = _this.$moment();
                for (var i = 0; i < serverTriggers.length; i++) {
                    var serverTrigger = serverTriggers[i];
                    var consoleTrigger = serverTrigger;
                    triggerList.push(consoleTrigger);
                }
            }, function (error) {
                _this.$log.debug('querying data error', error);
            }).$promise.then(function () {
                return {
                    triggerList: triggerList,
                    headers: headers
                };
            });
        };
        HawkularAlertsManager.prototype.getEmailAction = function (email) {
            return this.HawkularAlert.Action.get({
                pluginId: 'email',
                actionId: email
            }).$promise;
        };
        HawkularAlertsManager.prototype.createEmailAction = function (email) {
            return this.HawkularAlert.Action.save({
                actionPlugin: 'email',
                actionId: email,
                description: 'Created on ' + Date(),
                to: email
            }).$promise;
        };
        HawkularAlertsManager.prototype.addEmailAction = function (email) {
            var _this = this;
            return this.getEmailAction(email).then(function (promiseValue) {
                return promiseValue;
            }, function (reason) {
                // Create a default email action
                if (reason.status === 404) {
                    _this.$log.debug('Action does not exist, creating one');
                    return _this.createEmailAction(email);
                }
            });
        };
        HawkularAlertsManager.prototype.updateAction = function (email) {
            return this.HawkularAlert.Action.put({
                actionPlugin: 'email',
                actionId: email,
                description: 'Created on ' + Date(),
                to: email
            }).$promise;
        };
        HawkularAlertsManager.$inject = ['HawkularAlert', '$q', '$log', '$moment', 'NotificationsService', 'ErrorsManager'];
        return HawkularAlertsManager;
    })();
    HawkularMetrics.HawkularAlertsManager = HawkularAlertsManager;
    HawkularMetrics._module.service('HawkularAlertsManager', HawkularAlertsManager);
})(HawkularMetrics || (HawkularMetrics = {}));

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// <reference path="../metricsPlugin.ts"/>
var HawkularMetrics;
(function (HawkularMetrics) {
    var ErrorsManager = (function () {
        function ErrorsManager($q, $log, NotificationsService) {
            this.$q = $q;
            this.$log = $log;
            this.NotificationsService = NotificationsService;
        }
        ErrorsManager.prototype.errorToastr = function (error, errorMsg) {
            var errorMsgComplete;
            if (error.data && error.data.errorMsg) {
                errorMsgComplete = error.data.errorMsg;
            }
            else {
                errorMsgComplete = errorMsg + ' ' + error;
            }
            this.NotificationsService.error(errorMsgComplete);
        };
        ErrorsManager.prototype.errorHandler = function (error, msg, cb) {
            if (error) {
                this.errorToastr(error, msg);
                if (cb) {
                    cb(error, msg);
                }
            }
            return this.$q.reject(null);
        };
        ErrorsManager.$inject = ['$q', '$log', 'NotificationsService'];
        return ErrorsManager;
    })();
    HawkularMetrics.ErrorsManager = ErrorsManager;
    HawkularMetrics._module.service('ErrorsManager', ErrorsManager);
})(HawkularMetrics || (HawkularMetrics = {}));

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// <reference path="metricsPlugin.ts"/>
/// <reference path="../../includes.ts"/>
/// <reference path="services/alertsManager.ts"/>
/// <reference path="services/errorsManager.ts"/>
var HawkularMetrics;
(function (HawkularMetrics) {
    var AlertsCenterDetailsController = (function () {
        function AlertsCenterDetailsController($scope, HawkularAlertsManager, ErrorsManager, $log, $q, $rootScope, $routeParams, $location, MetricsService, NotificationsService) {
            this.$scope = $scope;
            this.HawkularAlertsManager = HawkularAlertsManager;
            this.ErrorsManager = ErrorsManager;
            this.$log = $log;
            this.$q = $q;
            this.$rootScope = $rootScope;
            this.$routeParams = $routeParams;
            this.$location = $location;
            this.MetricsService = MetricsService;
            this.NotificationsService = NotificationsService;
            this.isWorking = false;
            $scope.acd = this;
            this._alertId = $routeParams.alertId;
            this.alertsTimeOffset = $routeParams.timeOffset || 3600000;
            // If the end time is not specified in URL use current time as end time
            this.alertsTimeEnd = $routeParams.endTime ? $routeParams.endTime : Date.now();
            this.alertsTimeStart = this.alertsTimeEnd - this.alertsTimeOffset;
            this.actionsHistory = [];
            this.statuses = [];
            this.getAlert(this._alertId);
            this.getActions(this._alertId);
        }
        AlertsCenterDetailsController.prototype.getAlert = function (alertId) {
            var _this = this;
            return this.HawkularAlertsManager.getAlert(alertId).then(function (alert) {
                _this.detailAlert = alert;
                var descriptionsParts = alert.trigger.description.split('~');
                _this.description = descriptionsParts[0];
                _this.feedId = descriptionsParts[1];
                _this.status = alert.status;
                if (_this.status === 'OPEN') {
                    _this.statuses = ['OPEN', 'ACKNOWLEDGED', 'RESOLVED'];
                }
                else {
                    _this.statuses = ['ACKNOWLEDGED', 'RESOLVED'];
                }
                if (alert.status === 'OPEN' || alert.status === 'ACKNOWLEDGED') {
                    _this.comments = alert.ackNotes;
                }
                else {
                    _this.comments = alert.resolvedNotes;
                }
            });
        };
        AlertsCenterDetailsController.prototype.getActions = function (alertId) {
            var _this = this;
            return this.HawkularAlertsManager.queryActionsHistory({ alertIds: alertId, sort: 'ctime', thin: false })
                .then(function (queriedActions) {
                console.dir(queriedActions);
                _this.actionsHistory = queriedActions.actionsList;
            });
        };
        AlertsCenterDetailsController.prototype.cancel = function () {
            var timeOffset = this.alertsTimeOffset;
            var endTime = this.alertsTimeEnd;
            this.$location.url("/hawkular-ui/alerts-center/" + timeOffset + "/" + endTime);
        };
        AlertsCenterDetailsController.prototype.save = function () {
            console.log('this.status: ' + this.status);
            console.log('this.detailAlert.status: ' + this.detailAlert.status);
            if (this.status === this.detailAlert.status) {
                if (this.comments && this.comments.length > 0) {
                    this.notes();
                }
            }
            else {
                if (this.status === 'ACKNOWLEDGED') {
                    this.acknowledge();
                }
                else {
                    this.resolve();
                }
            }
        };
        AlertsCenterDetailsController.prototype.notes = function () {
            var _this = this;
            this.isWorking = true;
            var newComment = {
                alertId: this._alertId,
                user: this.$rootScope.currentPersona.name,
                text: this.comments
            };
            this.HawkularAlertsManager.addNote(newComment).then(function () {
                _this.isWorking = false;
                _this.getAlert(_this._alertId);
                _this.getActions(_this._alertId);
            });
        };
        AlertsCenterDetailsController.prototype.resolve = function () {
            var _this = this;
            this.$log.log('ResolveDetail: ' + this._alertId);
            this.isWorking = true;
            var resolvedAlerts = {
                alertIds: this._alertId,
                resolvedBy: this.$rootScope.currentPersona.name,
                resolvedNotes: this.comments
            };
            this.HawkularAlertsManager.resolveAlerts(resolvedAlerts).then(function () {
                _this.isWorking = false;
                _this.getAlert(_this._alertId);
                _this.getActions(_this._alertId);
            });
        };
        AlertsCenterDetailsController.prototype.acknowledge = function () {
            var _this = this;
            this.$log.log('Ack Alert Detail: ' + this._alertId);
            this.isWorking = true;
            var ackAlerts = {
                alertIds: this._alertId,
                ackBy: this.$rootScope.currentPersona.name,
                ackNotes: this.comments
            };
            this.HawkularAlertsManager.ackAlerts(ackAlerts).then(function () {
                _this.isWorking = false;
                _this.getAlert(_this._alertId);
                _this.getActions(_this._alertId);
            });
        };
        AlertsCenterDetailsController.$inject = ['$scope', 'HawkularAlertsManager', 'ErrorsManager',
            '$log', '$q', '$rootScope', '$routeParams', '$location', 'MetricsService', 'NotificationsService'];
        return AlertsCenterDetailsController;
    })();
    HawkularMetrics.AlertsCenterDetailsController = AlertsCenterDetailsController;
    HawkularMetrics._module.controller('AlertsCenterDetailsController', AlertsCenterDetailsController);
})(HawkularMetrics || (HawkularMetrics = {}));

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// <reference path="metricsPlugin.ts"/>
/// <reference path="../../includes.ts"/>
/// <reference path="services/alertsManager.ts"/>
/// <reference path="services/errorsManager.ts"/>
var HawkularMetrics;
(function (HawkularMetrics) {
    var AlertsCenterController = (function () {
        function AlertsCenterController($scope, HawkularAlertsManager, ErrorsManager, $log, $q, $rootScope, $interval, $routeParams, HkHeaderParser, $location) {
            var _this = this;
            this.$scope = $scope;
            this.HawkularAlertsManager = HawkularAlertsManager;
            this.ErrorsManager = ErrorsManager;
            this.$log = $log;
            this.$q = $q;
            this.$rootScope = $rootScope;
            this.$interval = $interval;
            this.$routeParams = $routeParams;
            this.HkHeaderParser = HkHeaderParser;
            this.$location = $location;
            this.isWorking = false;
            this.lastUpdateDate = new Date();
            this.alertsPerPage = 10;
            this.alertsCurPage = 0;
            this.headerLinks = {};
            this.selectCount = 0;
            this.hasOpenSelectedItems = false;
            this.hasResolvedAlerts = false;
            this.alertsStatuses = 'OPEN,ACKNOWLEDGED';
            this.sortField = 'ctime';
            this.sortAsc = false;
            this.loadingMoreItems = false;
            this.addProgress = false;
            $scope.ac = this;
            if ($routeParams.timeOffset === undefined) {
                $routeParams.timeOffset = 3600000 * 12;
                $scope.hkParams.timeOffset = $routeParams.timeOffset;
            }
            this.alertsTimeOffset = $routeParams.timeOffset;
            // If the end time is not specified in URL use current time as end time
            this.alertsTimeEnd = $routeParams.endTime ? $routeParams.endTime : Date.now();
            this.alertsTimeStart = this.alertsTimeEnd - this.alertsTimeOffset;
            this.autoRefresh(120);
            if ($rootScope.currentPersona) {
                this.getAlerts();
            }
            else {
                // currentPersona hasn't been injected to the rootScope yet, wait for it..
                $rootScope.$watch('currentPersona', function (currentPersona) {
                    return currentPersona && _this.getAlerts();
                });
            }
        }
        AlertsCenterController.prototype.autoRefresh = function (intervalInSeconds) {
            var _this = this;
            var autoRefreshPromise = this.$interval(function () {
                _this.$log.debug('autoRefresh .... ' + new Date());
                _this.getAlerts();
            }, intervalInSeconds * 1000);
            this.$scope.$on('$destroy', function () {
                _this.$interval.cancel(autoRefreshPromise);
            });
        };
        AlertsCenterController.prototype.getAlerts = function () {
            var _this = this;
            this.alertsTimeEnd = this.$routeParams.endTime ? this.$routeParams.endTime : Date.now();
            this.alertsTimeStart = this.alertsTimeEnd - this.alertsTimeOffset;
            var ordering = 'asc';
            if (!this.sortAsc) {
                ordering = 'desc';
            }
            this.HawkularAlertsManager.queryAlerts({
                statuses: this.alertsStatuses,
                startTime: this.alertsTimeStart,
                endTime: this.alertsTimeEnd,
                currentPage: this.alertsCurPage,
                perPage: this.alertsPerPage,
                sort: this.sortField,
                order: ordering
            })
                .then(function (queriedAlerts) {
                _this.headerLinks = _this.HkHeaderParser.parse(queriedAlerts.headers);
                _this.alertsList = queriedAlerts.alertList;
                _this.lastUpdateDate = new Date();
            }, function (error) {
                _this.$log.warn(error);
            }).catch(function (error) {
                _this.$log.error('Error:' + error);
            }).finally(function () {
                _this.lastUpdateDate = new Date();
            });
        };
        AlertsCenterController.prototype.showDetailPage = function (alertId) {
            var timeOffset = this.alertsTimeOffset;
            var endTime = this.alertsTimeEnd;
            this.$location.url("/hawkular-ui/alerts-center-detail/" + alertId + "/" + timeOffset + "/" + endTime);
        };
        AlertsCenterController.prototype.resolveSelected = function () {
            var _this = this;
            this.$log.log('ResolveSelected: ' + this.selectCount);
            this.isWorking = true;
            var resolveIdList = '';
            this.alertsList.forEach(function (alertItem) {
                if (alertItem.selected) {
                    resolveIdList = resolveIdList + alertItem.alertId + ',';
                }
            });
            resolveIdList = resolveIdList.slice(0, -1);
            if (resolveIdList.length > 0) {
                var resolvedAlerts = {
                    alertIds: resolveIdList,
                    resolvedBy: this.$rootScope.currentPersona.name,
                    resolvedNotes: 'Manually resolved '
                };
                this.HawkularAlertsManager.resolveAlerts(resolvedAlerts).then(function () {
                    _this.isWorking = false;
                    _this.resetAllUnselected();
                    _this.getAlerts();
                });
            }
        };
        AlertsCenterController.prototype.ackSelected = function () {
            var _this = this;
            this.$log.log('Ack Selected: ' + this.selectCount);
            this.isWorking = true;
            var ackIdList = '';
            this.alertsList.forEach(function (alertItem) {
                if (alertItem.selected && (alertItem.status !== 'ACKNOWLEDGED' || alertItem.status !== 'RESOLVED')) {
                    ackIdList = ackIdList + alertItem.alertId + ',';
                }
            });
            ackIdList = ackIdList.slice(0, -1);
            if (ackIdList.length > 0) {
                var ackAlerts = {
                    alertIds: ackIdList,
                    ackBy: this.$rootScope.currentPersona.name,
                    ackNotes: 'Manually acknowledged '
                };
                this.HawkularAlertsManager.ackAlerts(ackAlerts).then(function () {
                    _this.isWorking = false;
                    _this.resetAllUnselected();
                    _this.getAlerts();
                });
            }
        };
        AlertsCenterController.prototype.setPage = function (page) {
            this.alertsCurPage = page;
            this.getAlerts();
        };
        AlertsCenterController.prototype.selectItem = function (item) {
            item.selected = !item.selected;
            this.selectedItems = _.filter(this.alertsList, 'selected');
            this.selectCount = this.selectedItems.length;
            this.hasOpenSelectedItems = _.some(this.selectedItems, { 'status': 'OPEN' });
        };
        AlertsCenterController.prototype.hasResolvedItems = function () {
            return _.some(this.selectedItems, { 'status': 'RESOLVED' });
        };
        AlertsCenterController.prototype.resetAllUnselected = function () {
            this.selectCount = 0;
            this.hasOpenSelectedItems = false;
            this.alertsList.forEach(function (item) {
                item.selected = false;
            });
        };
        AlertsCenterController.prototype.selectAll = function () {
            var toggleTo = this.selectCount !== this.alertsList.length;
            _.forEach(this.alertsList, function (item) {
                item.selected = toggleTo;
            });
            this.selectCount = toggleTo ? this.alertsList.length : 0;
        };
        AlertsCenterController.prototype.changeResolvedFilter = function () {
            if (this.hasResolvedAlerts) {
                this.alertsStatuses = 'OPEN,ACKNOWLEDGED,RESOLVED';
            }
            else {
                this.alertsStatuses = 'OPEN,ACKNOWLEDGED';
            }
            this.getAlerts();
        };
        AlertsCenterController.prototype.sortBy = function (field) {
            this.sortField = field;
            this.sortAsc = !this.sortAsc;
            this.getAlerts();
            this.$log.debug('Sorting by ' + field + ' ascending ' + this.sortAsc + ' ' + new Date());
        };
        AlertsCenterController.$inject = ['$scope', 'HawkularAlertsManager',
            'ErrorsManager', '$log', '$q', '$rootScope', '$interval', '$routeParams',
            'HkHeaderParser', '$location'];
        return AlertsCenterController;
    })();
    HawkularMetrics.AlertsCenterController = AlertsCenterController;
    HawkularMetrics._module.controller('AlertsCenterController', AlertsCenterController);
})(HawkularMetrics || (HawkularMetrics = {}));

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// <reference path="metricsPlugin.ts"/>
/// <reference path="../../includes.ts"/>
/// <reference path="services/alertsManager.ts"/>
/// <reference path="services/errorsManager.ts"/>
var HawkularMetrics;
(function (HawkularMetrics) {
    var AlertsCenterTriggerController = (function () {
        function AlertsCenterTriggerController($scope, HawkularAlertsManager, ErrorsManager, $log, $q, $rootScope, $interval, $routeParams, HkHeaderParser, $location) {
            var _this = this;
            this.$scope = $scope;
            this.HawkularAlertsManager = HawkularAlertsManager;
            this.ErrorsManager = ErrorsManager;
            this.$log = $log;
            this.$q = $q;
            this.$rootScope = $rootScope;
            this.$interval = $interval;
            this.$routeParams = $routeParams;
            this.HkHeaderParser = HkHeaderParser;
            this.$location = $location;
            this.isWorking = false;
            this.lastUpdateDate = new Date();
            this.triggersPerPage = 10;
            this.triggersCurPage = 0;
            this.headerLinks = {};
            this.selectCount = 0;
            this.hasEnabledSelectedItems = false;
            this.hasDisabledSelectedItems = false;
            this.sortField = 'name';
            this.sortAsc = false;
            this.loadingMoreItems = false;
            this.addProgress = false;
            $scope.ac = this;
            this.autoRefresh(120);
            if ($rootScope.currentPersona) {
                this.getTriggers();
            }
            else {
                // currentPersona hasn't been injected to the rootScope yet, wait for it..
                $rootScope.$watch('currentPersona', function (currentPersona) {
                    return currentPersona && _this.getTriggers();
                });
            }
        }
        AlertsCenterTriggerController.prototype.autoRefresh = function (intervalInSeconds) {
            var _this = this;
            var autoRefreshPromise = this.$interval(function () {
                _this.$log.debug('autoRefresh .... ' + new Date());
                _this.getTriggers();
            }, intervalInSeconds * 1000);
            this.$scope.$on('$destroy', function () {
                _this.$interval.cancel(autoRefreshPromise);
            });
        };
        AlertsCenterTriggerController.prototype.getTriggers = function () {
            var _this = this;
            var ordering = 'asc';
            if (!this.sortAsc) {
                ordering = 'desc';
            }
            this.HawkularAlertsManager.queryTriggers({ currentPage: this.triggersCurPage,
                perPage: this.triggersPerPage,
                sort: this.sortField,
                order: ordering
            })
                .then(function (queriedTriggers) {
                _this.headerLinks = _this.HkHeaderParser.parse(queriedTriggers.headers);
                _this.triggersList = queriedTriggers.triggerList;
                _this.lastUpdateDate = new Date();
                console.dir(_this.headerLinks);
            }, function (error) {
                _this.$log.warn(error);
            }).catch(function (error) {
                _this.$log.error('Error:' + error);
            }).finally(function () {
                _this.lastUpdateDate = new Date();
            });
        };
        AlertsCenterTriggerController.prototype.enableSelected = function () {
            var _this = this;
            this.$log.debug('Enable Selected Triggers');
            // Error notification done with callback function on error
            var errorCallback = function (error, msg) {
                _this.$log.error('Error:' + error);
            };
            this.isWorking = true;
            var isError = false;
            // Check if email action exists
            var updateTriggersPromises = this.updateSelected(true, errorCallback);
            this.$q.all(updateTriggersPromises).finally(function () {
                _this.isWorking = false;
                _this.resetAllUnselected();
                _this.getTriggers();
                if (!isError) {
                }
            });
        };
        AlertsCenterTriggerController.prototype.disableSelected = function () {
            var _this = this;
            this.$log.debug('Disable Selected Triggers');
            // Error notification done with callback function on error
            var errorCallback = function (error, msg) {
                _this.$log.error('Error:' + error);
            };
            this.isWorking = true;
            var isError = false;
            // Check if email action exists
            var updateTriggersPromises = this.updateSelected(false, errorCallback);
            this.$q.all(updateTriggersPromises).finally(function () {
                _this.isWorking = false;
                _this.resetAllUnselected();
                _this.getTriggers();
                if (!isError) {
                }
            });
        };
        AlertsCenterTriggerController.prototype.updateSelected = function (enabled, errorCallback) {
            var _this = this;
            var promises = [];
            var triggerDefinition = {};
            var triggerBackup = {};
            this.triggersList.forEach(function (triggerItem) {
                if (triggerItem.selected && (triggerItem.enabled !== enabled)) {
                    triggerDefinition['trigger'] = angular.copy(triggerItem);
                    delete triggerDefinition['trigger'].selected;
                    triggerBackup['trigger'] = angular.copy(triggerDefinition['trigger']);
                    triggerDefinition['trigger'].enabled = enabled;
                    promises.push(_this.HawkularAlertsManager.updateTrigger(triggerDefinition, errorCallback, triggerBackup));
                }
            });
            return promises;
        };
        AlertsCenterTriggerController.prototype.showDetailPage = function (triggerId) {
            this.$location.url("/hawkular-ui/alerts-center-trigger-detail/" + triggerId);
        };
        AlertsCenterTriggerController.prototype.setPage = function (page) {
            this.triggersCurPage = page;
            this.getTriggers();
        };
        AlertsCenterTriggerController.prototype.selectItem = function (item) {
            item.selected = !item.selected;
            this.selectedItems = _.filter(this.triggersList, 'selected');
            this.selectCount = this.selectedItems.length;
            this.hasEnabledSelectedItems = _.some(this.selectedItems, { 'enabled': true });
            this.hasDisabledSelectedItems = _.some(this.selectedItems, { 'enabled': false });
        };
        AlertsCenterTriggerController.prototype.resetAllUnselected = function () {
            this.selectCount = 0;
            this.hasEnabledSelectedItems = false;
            this.hasDisabledSelectedItems = false;
            this.triggersList.forEach(function (item) {
                item.selected = false;
            });
        };
        AlertsCenterTriggerController.prototype.selectAll = function () {
            var toggleTo = this.selectCount !== this.triggersList.length;
            _.forEach(this.triggersList, function (item) {
                item.selected = toggleTo;
            });
            this.selectCount = toggleTo ? this.triggersList.length : 0;
        };
        AlertsCenterTriggerController.prototype.sortBy = function (field) {
            this.sortField = field;
            this.sortAsc = !this.sortAsc;
            this.getTriggers();
            this.$log.debug('Sorting by ' + field + ' ascending ' + this.sortAsc + ' ' + new Date());
        };
        AlertsCenterTriggerController.$inject = ['$scope', 'HawkularAlertsManager',
            'ErrorsManager', '$log', '$q', '$rootScope', '$interval', '$routeParams',
            'HkHeaderParser', '$location'];
        return AlertsCenterTriggerController;
    })();
    HawkularMetrics.AlertsCenterTriggerController = AlertsCenterTriggerController;
    HawkularMetrics._module.controller('AlertsCenterTriggerController', AlertsCenterTriggerController);
})(HawkularMetrics || (HawkularMetrics = {}));

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// <reference path="metricsPlugin.ts"/>
/// <reference path="../../includes.ts"/>
var HawkularMetrics;
(function (HawkularMetrics) {
    var GlobalController = (function () {
        function GlobalController($scope, $log, $rootScope, $routeParams, $location) {
            this.$scope = $scope;
            this.$log = $log;
            this.$rootScope = $rootScope;
            this.$routeParams = $routeParams;
            this.$location = $location;
            /**
             * Enable for experimental features.
             * Should be able to access anywhere by 'global.isExperimental()'
             */
            this.isExperimental = false;
            $scope.global = this;
        }
        GlobalController.prototype.experimentalMode = function () {
            this.$log.info('Starting Experimental Mode');
            this.isExperimental = true;
            this.$rootScope.isExperimental = true;
        };
        GlobalController.$inject = ['$scope', '$log', '$rootScope', '$routeParams', '$location'];
        return GlobalController;
    })();
    HawkularMetrics.GlobalController = GlobalController;
    HawkularMetrics._module.controller('GlobalController', GlobalController);
})(HawkularMetrics || (HawkularMetrics = {}));

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
/// <reference path="metricsPlugin.ts"/>
/// <reference path="../../includes.ts"/>
/// <reference path="services/alertsManager.ts"/>
/// <reference path="services/errorsManager.ts"/>
var HawkularMetrics;
(function (HawkularMetrics) {
    var AlertSetupController = (function () {
        function AlertSetupController($scope, HawkularAlertsManager, ErrorsManager, NotificationsService, $log, $q, $rootScope, $routeParams, $modalInstance, resourceId) {
            var _this = this;
            this.$scope = $scope;
            this.HawkularAlertsManager = HawkularAlertsManager;
            this.ErrorsManager = ErrorsManager;
            this.NotificationsService = NotificationsService;
            this.$log = $log;
            this.$q = $q;
            this.$rootScope = $rootScope;
            this.$routeParams = $routeParams;
            this.$modalInstance = $modalInstance;
            this.resourceId = resourceId;
            this.triggerDefinition = {};
            this.adm = {};
            this.admBak = {};
            this.saveProgress = false;
            this.isSettingChange = false;
            // TODO - update the pfly notification service to support more and category based notifications containers.
            this.$rootScope.hkNotifications = { alerts: [] };
            var triggersPromises = this.loadTriggers();
            this.$q.all(triggersPromises).then(function () {
                _this.admBak = angular.copy(_this.adm);
                _this.isSettingChange = false;
            });
            this.$scope.$watch(angular.bind(this, function () {
                return _this.adm;
            }), function () {
                _this.isSettingChange = !angular.equals(_this.adm, _this.admBak);
            }, true);
        }
        AlertSetupController.prototype.save = function () {
            var _this = this;
            this.$log.debug('Saving Alert Settings');
            // Clear alerts notifications on save (discard previous success/error list)
            this.$rootScope.hkNotifications.alerts = [];
            // Error notification done with callback function on error
            var errorCallback = function (error, msg) {
                _this.$rootScope.hkNotifications.alerts.push({
                    type: 'error',
                    message: msg
                });
            };
            this.saveProgress = true;
            var isError = false;
            // Check if email action exists
            var saveTriggersPromises = this.saveTriggers(errorCallback);
            this.$q.all(saveTriggersPromises).finally(function () {
                _this.saveProgress = false;
                if (!isError) {
                    // notify success
                    _this.NotificationsService.alertSettingsSaved();
                    _this.$rootScope.hkNotifications.alerts.push({
                        type: 'success',
                        message: 'Changes saved successfully.'
                    });
                }
                _this.cancel();
            });
        };
        AlertSetupController.prototype.cancel = function () {
            this.$modalInstance.dismiss('cancel');
        };
        AlertSetupController.prototype.loadTriggers = function () {
            throw new Error('This method is abstract');
        };
        AlertSetupController.prototype.saveTriggers = function (errorCallback) {
            throw new Error('This method is abstract');
        };
        AlertSetupController.$inject = ['$scope', 'HawkularAlertsManager', 'ErrorsManager', 'NotificationsService',
            '$log', '$q', '$rootScope', '$routeParams', '$modalInstance', 'resourceId'];
        return AlertSetupController;
    })();
    HawkularMetrics.AlertSetupController = AlertSetupController;
    var MetricsAlertController = (function () {
        function MetricsAlertController($scope, HawkularAlertsManager, ErrorsManager, NotificationsService, $log, $q, $rootScope, $routeParams, $modal, $interval, HkHeaderParser) {
            this.$scope = $scope;
            this.HawkularAlertsManager = HawkularAlertsManager;
            this.ErrorsManager = ErrorsManager;
            this.NotificationsService = NotificationsService;
            this.$log = $log;
            this.$q = $q;
            this.$rootScope = $rootScope;
            this.$routeParams = $routeParams;
            this.$modal = $modal;
            this.$interval = $interval;
            this.HkHeaderParser = HkHeaderParser;
            this.alertList = [];
            this.isResolvingAll = false;
            this.resCurPage = 0;
            this.resPerPage = 5;
            this.$log.debug('querying data');
            this.$log.debug('$routeParams', $routeParams);
            this.resourceId = $routeParams.resourceId;
            this.alertsTimeOffset = $routeParams.timeOffset || 3600000;
            // If the end time is not specified in URL use current time as end time
            this.alertsTimeEnd = $routeParams.endTime ? $routeParams.endTime : (new Date()).getTime();
            this.alertsTimeStart = this.alertsTimeEnd - this.alertsTimeOffset;
            this.getAlerts();
            this.autoRefresh(20);
        }
        MetricsAlertController.prototype.openResponseSetup = function () {
            var modalInstance = this.$modal.open({
                templateUrl: 'plugins/metrics/html/modals/alerts-url-response-setup.html',
                controller: 'AlertUrlResponseSetupController as mas',
                resolve: {
                    resourceId: function () {
                        return this.resourceId;
                    }
                }
            });
            var logger = this.$log;
            modalInstance.result.then(function (selectedItem) {
                this.selected = selectedItem;
            }, function () {
                logger.info('Modal dismissed at: ' + new Date());
            });
        };
        MetricsAlertController.prototype.autoRefresh = function (intervalInSeconds) {
            var _this = this;
            var autoRefreshPromise = this.$interval(function () {
                _this.getAlerts();
            }, intervalInSeconds * 1000);
            this.$scope.$on('$destroy', function () {
                _this.$interval.cancel(autoRefreshPromise);
            });
        };
        MetricsAlertController.prototype.getAlerts = function () {
            var _this = this;
            this.alertsTimeEnd = this.$routeParams.endTime ? this.$routeParams.endTime : (new Date()).getTime();
            this.alertsTimeStart = this.alertsTimeEnd - this.alertsTimeOffset;
            var triggerIds = this.resourceId + '_trigger_avail,' + this.resourceId + '_trigger_thres';
            this.HawkularAlertsManager.queryAlerts({ statuses: 'OPEN', triggerIds: triggerIds, startTime: this.alertsTimeStart,
                endTime: this.alertsTimeEnd, currentPage: this.resCurPage, perPage: this.resPerPage }).then(function (queriedAlerts) {
                _this.headerLinks = _this.HkHeaderParser.parse(queriedAlerts.headers);
                _.forEach(queriedAlerts.alertList, function (item) {
                    if (item['type'] === 'THRESHOLD') {
                        item['alertType'] = 'PINGRESPONSE';
                    }
                    else if (item['type'] === 'AVAILABILITY') {
                        item['alertType'] = 'PINGAVAIL';
                    }
                });
                _this.alertList = queriedAlerts.alertList;
                _this.alertList.$resolved = true; // FIXME
            }, function (error) { return _this.ErrorsManager.errorHandler(error, 'Error fetching alerts.'); });
        };
        MetricsAlertController.prototype.setPage = function (page) {
            this.resCurPage = page;
            this.getAlerts();
        };
        MetricsAlertController.prototype.resolveAll = function () {
            var _this = this;
            this.isResolvingAll = true;
            var alertIdList = '';
            for (var i = 0; i < this.alertList.length; i++) {
                alertIdList = alertIdList + this.alertList[i].id + ',';
            }
            alertIdList = alertIdList.slice(0, -1);
            var resolvedAlerts = {
                alertIds: alertIdList,
                resolvedBy: this.$rootScope.currentPersona.name,
                resolvedNotes: 'Manually resolved'
            };
            this.HawkularAlertsManager.resolveAlerts(resolvedAlerts).then(function () {
                _this.alertList.length = 0;
                _this.isResolvingAll = false;
            });
        };
        MetricsAlertController.$inject = ['$scope', 'HawkularAlertsManager', 'ErrorsManager', 'NotificationsService', '$log', '$q',
            '$rootScope', '$routeParams', '$modal', '$interval', 'HkHeaderParser'];
        return MetricsAlertController;
    })();
    HawkularMetrics.MetricsAlertController = MetricsAlertController;
    HawkularMetrics._module.controller('MetricsAlertController', MetricsAlertController);
    var AlertUrlAvailabilitySetupController = (function (_super) {
        __extends(AlertUrlAvailabilitySetupController, _super);
        function AlertUrlAvailabilitySetupController() {
            _super.apply(this, arguments);
        }
        AlertUrlAvailabilitySetupController.prototype.loadTriggers = function () {
            var _this = this;
            var availabilityTriggerId = this.$routeParams.resourceId + '_trigger_avail';
            var availabilityTriggerPromise = this.HawkularAlertsManager.getTrigger(availabilityTriggerId)
                .then(function (triggerData) {
                _this.$log.debug('triggerData', triggerData);
                _this.triggerDefinition['avail'] = triggerData;
                _this.adm['avail'] = {};
                _this.adm.avail['email'] = triggerData.trigger.actions.email[0];
                _this.adm.avail['responseDuration'] = triggerData.dampenings[0].evalTimeSetting;
                _this.adm.avail['conditionEnabled'] = triggerData.trigger.enabled;
            });
            return [availabilityTriggerPromise];
        };
        AlertUrlAvailabilitySetupController.prototype.saveTriggers = function (errorCallback) {
            // Set the actual object to save
            var availabilityTrigger = angular.copy(this.triggerDefinition.avail);
            availabilityTrigger.trigger.actions.email[0] = this.adm.avail.email;
            availabilityTrigger.trigger.enabled = this.adm.avail.conditionEnabled;
            availabilityTrigger.dampenings[0].evalTimeSetting = this.adm.avail.responseDuration;
            availabilityTrigger.dampenings[1].evalTimeSetting = this.adm.avail.responseDuration;
            var availabilitySavePromise = this.HawkularAlertsManager.updateTrigger(availabilityTrigger, errorCallback, this.triggerDefinition.avail);
            return [availabilitySavePromise];
        };
        return AlertUrlAvailabilitySetupController;
    })(AlertSetupController);
    HawkularMetrics.AlertUrlAvailabilitySetupController = AlertUrlAvailabilitySetupController;
    HawkularMetrics._module.controller('AlertUrlAvailabilitySetupController', AlertUrlAvailabilitySetupController);
    var AlertUrlResponseSetupController = (function (_super) {
        __extends(AlertUrlResponseSetupController, _super);
        function AlertUrlResponseSetupController() {
            _super.apply(this, arguments);
        }
        AlertUrlResponseSetupController.prototype.loadTriggers = function () {
            var _this = this;
            var responseTriggerId = this.$routeParams.resourceId + '_trigger_thres';
            var responseTriggerPromise = this.HawkularAlertsManager.getTrigger(responseTriggerId).then(function (triggerData) {
                _this.$log.debug('triggerData', triggerData);
                _this.triggerDefinition['thres'] = triggerData;
                _this.adm['thres'] = {};
                _this.adm.thres['email'] = triggerData.trigger.actions.email[0];
                _this.adm.thres['responseDuration'] = triggerData.dampenings[0].evalTimeSetting;
                _this.adm.thres['conditionEnabled'] = triggerData.trigger.enabled;
                _this.adm.thres['conditionThreshold'] = triggerData.conditions[0].threshold;
            });
            return [responseTriggerPromise];
        };
        AlertUrlResponseSetupController.prototype.saveTriggers = function (errorCallback) {
            // Set the actual object to save
            var responseTrigger = angular.copy(this.triggerDefinition.thres);
            responseTrigger.trigger.enabled = this.adm.thres.conditionEnabled;
            if (this.adm.thres.conditionEnabled) {
                responseTrigger.trigger.actions.email[0] = this.adm.thres.email;
                responseTrigger.dampenings[0].evalTimeSetting = this.adm.thres.responseDuration;
                responseTrigger.dampenings[1].evalTimeSetting = this.adm.thres.responseDuration;
                responseTrigger.conditions[0].threshold = this.adm.thres.conditionThreshold;
                responseTrigger.conditions[1].threshold = this.adm.thres.conditionThreshold;
            }
            var responseSavePromise = this.HawkularAlertsManager.updateTrigger(responseTrigger, errorCallback, this.triggerDefinition.thres);
            return [responseSavePromise];
        };
        return AlertUrlResponseSetupController;
    })(AlertSetupController);
    HawkularMetrics.AlertUrlResponseSetupController = AlertUrlResponseSetupController;
    HawkularMetrics._module.controller('AlertUrlResponseSetupController', AlertUrlResponseSetupController);
    var HkClearNotifications = (function () {
        function HkClearNotifications() {
            this.scope = {
                hkClearNotifications: '='
            };
            this.link = function (scope, element, attrs) {
                angular.element('html').on('click', function () {
                    if (scope.hkClearNotifications &&
                        scope.hkClearNotifications.length &&
                        scope.hkClearNotifications.length > 0) {
                        scope.$apply(function () {
                            scope.hkClearNotifications = [];
                        });
                    }
                });
            };
        }
        HkClearNotifications.Factory = function () {
            var directive = function () {
                return new HkClearNotifications();
            };
            directive['$inject'] = [];
            return directive;
        };
        return HkClearNotifications;
    })();
    HawkularMetrics.HkClearNotifications = HkClearNotifications;
    HawkularMetrics._module.directive('hkClearNotifications', HkClearNotifications.Factory());
})(HawkularMetrics || (HawkularMetrics = {}));

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// <reference path="metricsPlugin.ts"/>
/// <reference path="services/alertsManager.ts"/>
/// <reference path="services/errorsManager.ts"/>
var HawkularMetrics;
(function (HawkularMetrics) {
    var AppServerDetailsController = (function () {
        function AppServerDetailsController($rootScope, $scope, $route, $routeParams, HawkularOps, NotificationsService, HawkularInventory, $log, availableTabs, activeTab) {
            var _this = this;
            this.$rootScope = $rootScope;
            this.$scope = $scope;
            this.$route = $route;
            this.$routeParams = $routeParams;
            this.HawkularOps = HawkularOps;
            this.NotificationsService = NotificationsService;
            this.HawkularInventory = HawkularInventory;
            this.$log = $log;
            this.availableTabs = availableTabs;
            this.activeTab = activeTab;
            HawkularOps.init(this.NotificationsService);
            HawkularInventory.ResourceUnderFeed.get({
                environmentId: HawkularMetrics.globalEnvironmentId,
                feedId: this.$routeParams.resourceId.split('~')[0],
                resourcePath: this.$routeParams.resourceId + '~~'
            }, function (resource) {
                _this.resourcePath = resource.path;
                _this.$rootScope.resourcePath = _this.resourcePath;
            });
            $scope.tabs = this;
            this.availableTabs = [
                { id: 'jvm', name: 'JVM', enabled: true,
                    src: 'plugins/metrics/html/app-details/detail-jvm.html',
                    controller: HawkularMetrics.AppServerJvmDetailsController },
                { id: 'platform', name: 'Platform', enabled: this.$rootScope.isExperimental === true,
                    src: 'plugins/metrics/html/app-details/detail-platform.html',
                    controller: HawkularMetrics.AppServerPlatformDetailsController },
                { id: 'deployments', name: 'Deployments', enabled: true,
                    src: 'plugins/metrics/html/app-details/detail-deployments.html',
                    controller: HawkularMetrics.AppServerDeploymentsDetailsController },
                { id: 'jms', name: 'JMS', enabled: false,
                    src: 'plugins/metrics/html/app-details/detail-jms.html',
                    controller: HawkularMetrics.AppServerJmsDetailsController },
                { id: 'transactions', name: 'Transactions', enabled: false,
                    src: 'plugins/metrics/html/app-details/detail-transactions.html',
                    controller: HawkularMetrics.AppServerTransactionsDetailsController },
                { id: 'web', name: 'Web', enabled: true,
                    src: 'plugins/metrics/html/app-details/detail-web.html',
                    controller: HawkularMetrics.AppServerWebDetailsController },
                { id: 'datasources', name: 'Datasources', enabled: true,
                    src: 'plugins/metrics/html/app-details/detail-datasources.html',
                    controller: HawkularMetrics.AppServerDatasourcesDetailsController }
            ];
            this.activeTab = $routeParams.tabId || 'jvm';
            $scope.$on('ExportJDRSuccess', function (event, data) {
                _this.$log.info('JDR generated!');
                _this.jdrGenerating = false;
                _this.hasGeneratedSuccessfully = true;
                _this.hasGeneratedError = false;
            });
            $scope.$on('ExportJDRError', function (event, data) {
                _this.$log.info('JDR generation failed!');
                _this.jdrGenerating = false;
                _this.hasGeneratedSuccessfully = false;
                _this.hasGeneratedError = true;
            });
        }
        AppServerDetailsController.prototype.updateTab = function (newTabId) {
            this.$route.updateParams({ tabId: newTabId });
        };
        AppServerDetailsController.prototype.requestExportJDR = function () {
            this.jdrGenerating = true;
            this.HawkularOps.performExportJDROperation(this.resourcePath, this.$rootScope.userDetails.token, this.$rootScope.currentPersona.id);
        };
        /// for minification only
        AppServerDetailsController.$inject = ['$rootScope', '$scope', '$route', '$routeParams', 'HawkularOps',
            'NotificationsService', 'HawkularInventory', '$log'];
        return AppServerDetailsController;
    })();
    HawkularMetrics.AppServerDetailsController = AppServerDetailsController;
    HawkularMetrics._module.controller('AppServerDetailsController', AppServerDetailsController);
})(HawkularMetrics || (HawkularMetrics = {}));

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// <reference path="metricsPlugin.ts"/>
/// <reference path="services/alertsManager.ts"/>
/// <reference path="services/errorsManager.ts"/>
var HawkularMetrics;
(function (HawkularMetrics) {
    var AppServerListController = (function () {
        function AppServerListController($location, $scope, $rootScope, $interval, $log, $filter, $modal, HawkularInventory, HawkularMetric, HawkularAlertsManager, ErrorsManager, $q, md5, HkHeaderParser, startTimeStamp, endTimeStamp, resourceUrl) {
            var _this = this;
            this.$location = $location;
            this.$scope = $scope;
            this.$rootScope = $rootScope;
            this.$interval = $interval;
            this.$log = $log;
            this.$filter = $filter;
            this.$modal = $modal;
            this.HawkularInventory = HawkularInventory;
            this.HawkularMetric = HawkularMetric;
            this.HawkularAlertsManager = HawkularAlertsManager;
            this.ErrorsManager = ErrorsManager;
            this.$q = $q;
            this.md5 = md5;
            this.HkHeaderParser = HkHeaderParser;
            this.startTimeStamp = startTimeStamp;
            this.endTimeStamp = endTimeStamp;
            this.resourceUrl = resourceUrl;
            this.resPerPage = 10;
            this.resCurPage = 0;
            this.headerLinks = {};
            $scope.vm = this;
            if ($rootScope.currentPersona) {
                this.getResourceList(this.$rootScope.currentPersona.id);
            }
            else {
                // currentPersona hasn't been injected to the rootScope yet, wait for it..
                $rootScope.$watch('currentPersona', function (currentPersona) { return currentPersona &&
                    _this.getResourceList(currentPersona.id); });
            }
            this.autoRefresh(20);
        }
        AppServerListController.prototype.setPage = function (page) {
            this.resCurPage = page;
            this.getResourceList();
        };
        AppServerListController.prototype.autoRefresh = function (intervalInSeconds) {
            var _this = this;
            this.autoRefreshPromise = this.$interval(function () {
                _this.getResourceList();
            }, intervalInSeconds * 1000);
            this.$scope.$on('$destroy', function () {
                _this.$interval.cancel(_this.autoRefreshPromise);
            });
        };
        AppServerListController.prototype.getResourceListForOneFeed = function (feedId, currentTenantId) {
            var _this = this;
            var tenantId = currentTenantId || this.$rootScope.currentPersona.id;
            this.HawkularInventory.ResourceOfTypeUnderFeed.query({
                environmentId: HawkularMetrics.globalEnvironmentId, feedId: feedId,
                resourceTypeId: 'WildFly Server', per_page: this.resPerPage,
                page: this.resCurPage }, function (aResourceList, getResponseHeaders) {
                _this.headerLinks = _this.HkHeaderParser.parse(getResponseHeaders());
                var promises = [];
                angular.forEach(aResourceList, function (res) {
                    promises.push(this.HawkularMetric.AvailabilityMetricData(tenantId).query({
                        availabilityId: 'AI~R~[' + res.id + ']~AT~Server Availability~App Server',
                        distinct: true }, function (resource) {
                        var latestData = resource[resource.length - 1];
                        if (latestData) {
                            res['state'] = latestData['value'];
                            res['updateTimestamp'] = latestData['timestamp'];
                        }
                    }).$promise);
                    promises.push(this.HawkularInventory.ResourceUnderFeed.getData({
                        environmentId: HawkularMetrics.globalEnvironmentId,
                        feedId: feedId,
                        resourcePath: res.id }, function (resource) {
                        res['resourceConfiguration'] = resource;
                    }).$promise);
                    this.lastUpdateTimestamp = new Date();
                }, _this);
                _this.$q.all(promises).then(function (result) {
                    // FIXME this needs to be revisited, this won't work for removed resources
                    _this.resourceList = _.uniq(_.union(_this.resourceList, aResourceList), 'path');
                });
            }, function () {
                if (!_this.resourceList) {
                    _this.resourceList = [];
                    _this.resourceList.$resolved = true;
                    _this['lastUpdateTimestamp'] = new Date();
                }
            });
        };
        AppServerListController.prototype.getResourceList = function (currentTenantId) {
            var _this = this;
            // for each feed get all WF resources
            var tenantId = currentTenantId || this.$rootScope.currentPersona.id;
            this.HawkularInventory.Feed.query({ environmentId: HawkularMetrics.globalEnvironmentId }, function (aFeedList) {
                angular.forEach(aFeedList, function (feed) {
                    _this.getResourceListForOneFeed(feed.id, tenantId);
                });
                if (!aFeedList.length) {
                    // there are no feeds, no app servers
                    _this.resourceList = [];
                    _this.resourceList.$resolved = true;
                    _this['lastUpdateTimestamp'] = new Date();
                }
            });
        };
        /// this is for minification purposes
        AppServerListController.$inject = ['$location', '$scope', '$rootScope', '$interval', '$log', '$filter', '$modal',
            'HawkularInventory', 'HawkularMetric', 'HawkularAlertsManager', 'ErrorsManager', '$q',
            'md5', 'HkHeaderParser'];
        return AppServerListController;
    })();
    HawkularMetrics.AppServerListController = AppServerListController;
    HawkularMetrics._module.controller('AppServerListController', AppServerListController);
})(HawkularMetrics || (HawkularMetrics = {}));

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// <reference path="metricsPlugin.ts"/>
/// <reference path="../../includes.ts"/>
/// <reference path="services/errorsManager.ts"/>
var HawkularMetrics;
(function (HawkularMetrics) {
    (function (PersistenceState) {
        PersistenceState[PersistenceState["PERSISTING"] = 0] = "PERSISTING";
        PersistenceState[PersistenceState["SUCCESS"] = 1] = "SUCCESS";
        PersistenceState[PersistenceState["ERROR"] = 2] = "ERROR";
    })(HawkularMetrics.PersistenceState || (HawkularMetrics.PersistenceState = {}));
    var PersistenceState = HawkularMetrics.PersistenceState;
    ;
})(HawkularMetrics || (HawkularMetrics = {}));

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// <reference path='metricsTypes.ts'/>
/// <reference path='metricsPlugin.ts'/>
/// <reference path='../../includes.ts'/>
var HawkularMetrics;
(function (HawkularMetrics) {
    var MetricsAvailabilityController = (function () {
        function MetricsAvailabilityController($scope, $rootScope, $interval, $window, $log, HawkularMetric, MetricsService, $routeParams, $filter, $moment, HawkularAlertsManager, ErrorsManager, NotificationsService, $modal) {
            var _this = this;
            this.$scope = $scope;
            this.$rootScope = $rootScope;
            this.$interval = $interval;
            this.$window = $window;
            this.$log = $log;
            this.HawkularMetric = HawkularMetric;
            this.MetricsService = MetricsService;
            this.$routeParams = $routeParams;
            this.$filter = $filter;
            this.$moment = $moment;
            this.HawkularAlertsManager = HawkularAlertsManager;
            this.ErrorsManager = ErrorsManager;
            this.NotificationsService = NotificationsService;
            this.$modal = $modal;
            this.availabilityDataPoints = [];
            this.uptimeRatio = 0;
            this.downtimeDuration = 0;
            this.downtimeCount = 0;
            this.empty = true;
            $scope.vm = this;
            this.startTimeStamp = +$moment().subtract(1, 'hours');
            this.endTimeStamp = +$moment();
            this.resourceId = $scope.hkParams.resourceId;
            var waitForResourceId = function () { return $scope.$watch('hkParams.resourceId', function (resourceId) {
                /// made a selection from url switcher
                if (resourceId) {
                    _this.resourceId = resourceId;
                    _this.refreshAvailPageNow(_this.getResourceId());
                }
            }); };
            if ($rootScope.currentPersona) {
                waitForResourceId();
            }
            else {
                $rootScope.$watch('currentPersona', function (currentPersona) {
                    if (currentPersona) {
                        waitForResourceId();
                    }
                });
            }
            this.autoRefreshAvailability(20);
            $scope.$on(HawkularMetrics.EventNames.REFRESH_AVAIL_CHART, function () {
                _this.refreshAvailPageNow(_this.getResourceId());
            });
        }
        MetricsAvailabilityController.prototype.openAvailabilitySetup = function () {
            var _this = this;
            var modalInstance = this.$modal.open({
                templateUrl: 'plugins/metrics/html/modals/alerts-url-availability-setup.html',
                controller: 'AlertUrlAvailabilitySetupController as mas',
                resolve: {
                    resourceId: function () {
                        return _this.resourceId;
                    }
                }
            });
            var logger = this.$log;
            modalInstance.result.then(null, function () {
                logger.debug('Modal dismissed at: ' + new Date());
            });
        };
        MetricsAvailabilityController.prototype.getAlerts = function (metricId, startTime, endTime) {
            var _this = this;
            var triggerIds = metricId + '_trigger_avail';
            this.HawkularAlertsManager.queryAlerts({ statuses: 'OPEN', triggerIds: triggerIds, startTime: startTime,
                endTime: endTime }).then(function (alertAvailData) {
                _.forEach(alertAvailData.alertList, function (item) { item['alertType'] = 'PINGAVAIL'; });
                _this.alertList = alertAvailData.alertList;
            }, function (error) {
                return _this.ErrorsManager.errorHandler(error, 'Error fetching alerts.');
            });
        };
        MetricsAvailabilityController.min = function (a, b) {
            return Math.min(a, b);
        };
        MetricsAvailabilityController.prototype.refreshAvailPageNow = function (resourceId, startTime) {
            this.$scope.hkEndTimestamp = +this.$moment();
            var adjStartTimeStamp = +this.$moment().subtract(this.$scope.hkParams.timeOffset, 'milliseconds');
            this.endTimeStamp = this.$scope.hkEndTimestamp;
            if (resourceId) {
                this.$log.debug('Updating Availability Page');
                this.refreshSummaryAvailabilityData(resourceId, startTime ? startTime : adjStartTimeStamp, this.endTimeStamp);
                this.refreshAvailChartData(resourceId, startTime ? startTime : adjStartTimeStamp, this.endTimeStamp);
                this.getAlerts(resourceId, startTime ? startTime : adjStartTimeStamp, this.endTimeStamp);
            }
        };
        MetricsAvailabilityController.prototype.autoRefreshAvailability = function (intervalInSeconds) {
            var _this = this;
            this.endTimeStamp = this.$scope.hkEndTimestamp;
            this.startTimeStamp = this.$scope.hkStartTimestamp;
            this.autoRefreshPromise = this.$interval(function () {
                _this.$scope.hkEndTimestamp = +_this.$moment();
                _this.endTimeStamp = _this.$scope.hkEndTimestamp;
                _this.$scope.hkStartTimestamp = +_this.$moment().subtract(_this.$scope.hkParams.timeOffset, 'milliseconds');
                _this.startTimeStamp = _this.$scope.hkStartTimestamp;
                _this.refreshAvailPageNow(_this.getResourceId());
            }, intervalInSeconds * 1000);
            this.$scope.$on('$destroy', function () {
                _this.$interval.cancel(_this.autoRefreshPromise);
            });
        };
        MetricsAvailabilityController.prototype.refreshSummaryAvailabilityData = function (metricId, startTime, endTime) {
            var _this = this;
            if (metricId) {
                this.MetricsService.retrieveAvailabilityMetrics(this.$rootScope.currentPersona.id, metricId, startTime, endTime, 1).
                    then(function (availResponse) {
                    if (availResponse && !_.last(availResponse).empty) {
                        // FIXME: HAWKULAR-347 - this.uptimeRatio = _.last(availResponse).uptimeRatio;
                        // FIXME: HAWKULAR-347 - this.downtimeDuration = Math.round(_.last(availResponse).downtimeDuration);
                        _this.lastDowntime = new Date(_.last(availResponse).lastDowntime);
                        // FIXME: HAWKULAR-347 - this.downtimeCount = _.last(availResponse).downtimeCount;
                        _this.empty = _.last(availResponse).empty;
                    }
                }, function (error) {
                    _this.NotificationsService.error('Error Loading Avail Summary Data: ' + error);
                });
            }
        };
        MetricsAvailabilityController.prototype.getResourceId = function () {
            return this.resourceId;
        };
        MetricsAvailabilityController.prototype.refreshAvailChartData = function (metricId, startTime, endTime) {
            var _this = this;
            if (metricId) {
                this.HawkularMetric.AvailabilityMetricData(this.$rootScope.currentPersona.id).query({
                    availabilityId: metricId,
                    start: startTime,
                    end: endTime,
                    distinct: true
                }).$promise
                    .then(function (response) {
                    _this.availabilityDataPoints = response;
                    // FIXME: HAWKULAR-347
                    var downtimeDuration = 0;
                    var lastUptime = +_this.$moment();
                    var lastDowntime = -1;
                    var downtimeCount = 0;
                    _.each(response.slice(0).reverse(), function (status) {
                        if (status.value === 'down') {
                            lastDowntime = status.timestamp;
                            downtimeDuration += (lastUptime - lastDowntime);
                            downtimeCount++;
                        }
                        else {
                            lastUptime = status.timestamp;
                        }
                    });
                    _this.downtimeDuration = downtimeDuration;
                    _this.downtimeDurationJson = _this.getDowntimeDurationAsJson();
                    // FIXME: HAWKULAR-347 - Uptime ratio on metrics side is being calculated base on whole date range, even
                    //                       if there's no data for most of it. so it's inaccurate/incorrect. Only taking the
                    //                       value if it's 0.
                    _this.uptimeRatio = (response.length === 1 && _.last(response).value === 'down') ? 0 :
                        (1 - downtimeDuration / (+_this.$moment() - response[0].timestamp));
                    _this.downtimeCount = downtimeCount;
                }, function (error) {
                    _this.NotificationsService.error('Error Loading Avail Data: ' + error);
                });
            }
        };
        MetricsAvailabilityController.prototype.getDurationAux = function (duration, pattern) {
            var result = [];
            var durations = this.$filter('duration')(duration, pattern).split(' ');
            _.each(pattern.split(' '), function (unit, idx) {
                result.push({ value: durations[idx], unit: MetricsAvailabilityController.durationUnits[unit].unit });
            }, this);
            return angular.fromJson(result);
        };
        MetricsAvailabilityController.prototype.getDowntimeDurationAsJson = function () {
            if (this.downtimeDuration) {
                if (this.downtimeDuration < MetricsAvailabilityController.durationUnits.s.limit) {
                    return this.getDurationAux(this.downtimeDuration, 's');
                }
                else if (this.downtimeDuration < MetricsAvailabilityController.durationUnits.m.limit) {
                    return this.getDurationAux(this.downtimeDuration, 'm s');
                }
                else if (this.downtimeDuration < MetricsAvailabilityController.durationUnits.h.limit) {
                    return this.getDurationAux(this.downtimeDuration, 'h m');
                }
                else {
                    return this.getDurationAux(this.downtimeDuration, 'd h');
                }
            }
        };
        /// for minification only
        MetricsAvailabilityController.$inject = ['$scope', '$rootScope', '$interval', '$window', '$log', 'HawkularMetric',
            'MetricsService', '$routeParams', '$filter', '$moment', 'HawkularAlertsManager',
            'ErrorsManager', 'NotificationsService', '$modal'];
        MetricsAvailabilityController.durationUnits = {
            's': { unit: 'seconds', limit: 60000 },
            'm': { unit: 'minutes', limit: 7200000 },
            'h': { unit: 'hours', limit: 172800000 },
            'd': { unit: 'days', limit: 1209600000 } // days, up to 14 (2 weeks)
        };
        return MetricsAvailabilityController;
    })();
    HawkularMetrics.MetricsAvailabilityController = MetricsAvailabilityController;
    HawkularMetrics._module.controller('MetricsAvailabilityController', MetricsAvailabilityController);
})(HawkularMetrics || (HawkularMetrics = {}));

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// <reference path="../metricsPlugin.ts"/>
var HawkularMetrics;
(function (HawkularMetrics) {
    var MetricsService = (function () {
        function MetricsService($log, HawkularMetric, NotificationsService) {
            this.$log = $log;
            this.HawkularMetric = HawkularMetric;
            this.NotificationsService = NotificationsService;
        }
        /**
         * formatBucketedChartOutput
         * @param response
         * @param multiplier Value to multiply the original value with. Eg. 100 for double -> % or (1/1024) for byte->kb
         * @returns IChartDataPoint[]
         */
        MetricsService.formatBucketedChartOutput = function (response, multiplier) {
            multiplier = multiplier || 1;
            //  The schema is different for bucketed output
            return _.map(response, function (point) {
                return {
                    timestamp: point.start,
                    date: new Date(point.start),
                    value: !angular.isNumber(point.value) ? 0 : point.value * multiplier,
                    avg: (point.empty) ? 0 : point.avg * multiplier,
                    min: !angular.isNumber(point.min) ? 0 : point.min * multiplier,
                    max: !angular.isNumber(point.max) ? 0 : point.max * multiplier,
                    percentile95th: !angular.isNumber(point.percentile95th) ? 0 : point.percentile95th * multiplier,
                    median: !angular.isNumber(point.median) ? 0 : point.median * multiplier,
                    empty: point.empty
                };
            });
        };
        /**
         * RetrieveGaugeMetrics
         * @param personaId
         * @param metricId
         * @param startTime
         * @param endTime
         * @param buckets
         * @returns ng.IPromise<IChartDataPoint[]>
         */
        MetricsService.prototype.retrieveGaugeMetrics = function (personaId, metricId, startTime, endTime, buckets) {
            if (buckets === void 0) { buckets = 120; }
            return this.retrieveMetrics(MetricsService.GAUGE_TYPE, personaId, metricId, startTime, endTime, buckets);
        };
        /**
         * RetrieveCounterMetrics
         * @param personaId
         * @param metricId
         * @param startTime
         * @param endTime
         * @param buckets
         * @returns ng.IPromise<IChartDataPoint[]>
         */
        MetricsService.prototype.retrieveCounterMetrics = function (personaId, metricId, startTime, endTime, buckets) {
            if (buckets === void 0) { buckets = 120; }
            return this.retrieveMetrics(MetricsService.COUNTER_TYPE, personaId, metricId, startTime, endTime, buckets);
        };
        /**
         * RetrieveCounterMetrics
         * @param personaId
         * @param metricId
         * @param startTime
         * @param endTime
         * @param buckets
         * @returns ng.IPromise<IChartDataPoint[]>
         */
        MetricsService.prototype.retrieveCounterRateMetrics = function (personaId, metricId, startTime, endTime, buckets) {
            if (buckets === void 0) { buckets = 120; }
            return this.retrieveMetrics(MetricsService.COUNTER_TYPE, personaId, metricId, startTime, endTime, buckets, true);
        };
        /**
         * RetrieveCounterMetrics
         * @param personaId
         * @param metricId
         * @param startTime
         * @param endTime
         * @param buckets
         * @returns ng.IPromise<IChartDataPoint[]>
         */
        MetricsService.prototype.retrieveAvailabilityMetrics = function (personaId, metricId, startTime, endTime, buckets) {
            if (buckets === void 0) { buckets = 120; }
            return this.retrieveMetrics(MetricsService.AVAILABILITY_TYPE, personaId, metricId, startTime, endTime, buckets);
        };
        MetricsService.prototype.retrieveMetrics = function (metricType, personaId, metricId, startTime, endTime, buckets, isRate) {
            if (buckets === void 0) { buckets = 120; }
            // calling refreshChartData without params use the model values
            if (!endTime) {
                endTime = Date.now();
            }
            if (!startTime) {
                startTime = Date.now() - (8 * 60 * 60 * 1000);
            }
            var querySuffix = metricType === MetricsService.AVAILABILITY_TYPE ? '' : 'Metrics';
            var dataType = isRate ? 'Rate' : 'Data';
            return this.HawkularMetric[(metricType + "Metric" + dataType)](personaId)[("query" + querySuffix)]({
                gaugeId: (metricType === MetricsService.GAUGE_TYPE ? metricId : undefined),
                counterId: (metricType === MetricsService.COUNTER_TYPE ? metricId : undefined),
                availabilityId: (metricType === MetricsService.AVAILABILITY_TYPE ? metricId : undefined),
                start: startTime,
                end: endTime,
                buckets: buckets
            }).$promise;
        };
        MetricsService.AVAILABILITY_TYPE = 'Availability';
        MetricsService.COUNTER_TYPE = 'Counter';
        MetricsService.GAUGE_TYPE = 'Gauge';
        MetricsService.$inject = ['$log', 'HawkularMetric', 'NotificationsService'];
        return MetricsService;
    })();
    HawkularMetrics.MetricsService = MetricsService;
    HawkularMetrics._module.service('MetricsService', MetricsService);
})(HawkularMetrics || (HawkularMetrics = {}));

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// <reference path='metricsTypes.ts'/>
/// <reference path='metricsPlugin.ts'/>
/// <reference path='services/metricsService.ts'/>
/// <reference path='../../includes.ts'/>
var HawkularMetrics;
(function (HawkularMetrics) {
    var MetricsViewController = (function () {
        function MetricsViewController($scope, $rootScope, $interval, $log, $routeParams, HawkularAlertsManager, ErrorsManager, NotificationsService, MetricsService) {
            var _this = this;
            this.$scope = $scope;
            this.$rootScope = $rootScope;
            this.$interval = $interval;
            this.$log = $log;
            this.$routeParams = $routeParams;
            this.HawkularAlertsManager = HawkularAlertsManager;
            this.ErrorsManager = ErrorsManager;
            this.NotificationsService = NotificationsService;
            this.MetricsService = MetricsService;
            this.bucketedDataPoints = [];
            this.contextDataPoints = [];
            this.threshold = 5000; // default to 5 seconds some high number
            this.median = 0;
            this.percentile95th = 0;
            this.average = 0;
            $scope.vm = this;
            this.startTimeStamp = +moment().subtract(1, 'hours');
            this.endTimeStamp = +moment();
            this.resourceId = $scope.hkParams.resourceId;
            $scope.$on(HawkularMetrics.EventNames.REFRESH_CHART, function (event) {
                _this.$log.debug('RefreshChart Event');
                _this.refreshChartDataNow(_this.getMetricId());
            });
            var waitForResourceId = function () { return $scope.$watch('hkParams.resourceId', function (resourceId) {
                /// made a selection from url switcher
                if (resourceId) {
                    _this.resourceId = resourceId;
                    _this.refreshChartDataNow(_this.getMetricId());
                }
            }); };
            if ($rootScope.currentPersona) {
                waitForResourceId();
            }
            else {
                $rootScope.$watch('currentPersona', function (currentPersona) {
                    if (currentPersona) {
                        waitForResourceId();
                    }
                });
            }
            this.autoRefresh(20);
        }
        MetricsViewController.prototype.getAlerts = function (metricId, startTime, endTime) {
            var _this = this;
            var triggerIds = metricId + '_trigger_thres';
            this.HawkularAlertsManager.queryAlerts({ statuses: 'OPEN', triggerIds: triggerIds, startTime: startTime,
                endTime: endTime }).then(function (responseAlertData) {
                _.forEach(responseAlertData.alertList, function (item) { item['alertType'] = 'PINGRESPONSE'; });
                _this.alertList = responseAlertData.alertList;
            }, function (error) {
                return _this.ErrorsManager.errorHandler(error, 'Error fetching alerts.');
            });
        };
        MetricsViewController.prototype.autoRefresh = function (intervalInSeconds) {
            var _this = this;
            this.autoRefreshPromise = this.$interval(function () {
                _this.$scope.hkEndTimestamp = +moment();
                _this.endTimeStamp = _this.$scope.hkEndTimestamp;
                _this.$scope.hkStartTimestamp = +moment().subtract(_this.$scope.hkParams.timeOffset, 'milliseconds');
                _this.startTimeStamp = _this.$scope.hkStartTimestamp;
                _this.refreshSummaryData(_this.getMetricId());
                _this.refreshHistoricalChartDataForTimestamp(_this.getMetricId());
                _this.getAlerts(_this.resourceId, _this.$scope.hkStartTimestamp, _this.endTimeStamp);
                _this.retrieveThreshold();
            }, intervalInSeconds * 1000);
            this.$scope.$on('$destroy', function () {
                _this.$interval.cancel(_this.autoRefreshPromise);
            });
        };
        MetricsViewController.prototype.refreshChartDataNow = function (metricId, startTime) {
            this.$scope.hkEndTimestamp = +moment();
            var adjStartTimeStamp = +moment().subtract(this.$scope.hkParams.timeOffset, 'milliseconds');
            this.endTimeStamp = this.$scope.hkEndTimestamp;
            this.refreshSummaryData(metricId, startTime ? startTime : adjStartTimeStamp, this.endTimeStamp);
            this.refreshHistoricalChartDataForTimestamp(metricId, !startTime ? adjStartTimeStamp : startTime, this.endTimeStamp);
            this.getAlerts(this.resourceId, startTime ? startTime : adjStartTimeStamp, this.endTimeStamp);
            this.retrieveThreshold();
        };
        MetricsViewController.prototype.getMetricId = function () {
            return this.resourceId + '.status.duration';
        };
        MetricsViewController.min = function (a, b) {
            return Math.min(a, b);
        };
        MetricsViewController.prototype.refreshSummaryData = function (metricId, startTime, endTime) {
            var _this = this;
            var dataPoints;
            // calling refreshChartData without params use the model values
            if (!endTime) {
                endTime = this.endTimeStamp;
            }
            if (!startTime) {
                startTime = this.startTimeStamp;
            }
            if (metricId) {
                this.MetricsService.retrieveGaugeMetrics(this.$rootScope.currentPersona.id, metricId, startTime, endTime, 1)
                    .then(function (response) {
                    dataPoints = HawkularMetrics.MetricsService.formatBucketedChartOutput(response);
                    _this.median = Math.round(_.last(dataPoints).median);
                    _this.percentile95th = Math.round(_.last(dataPoints).percentile95th);
                    _this.average = Math.round(_.last(dataPoints).avg);
                }, function (error) {
                    _this.NotificationsService.error('Error Loading Chart Data: ' + error);
                });
            }
        };
        MetricsViewController.prototype.retrieveThreshold = function () {
            var _this = this;
            var triggerId = this.$routeParams.resourceId + '_trigger_thres';
            this.HawkularAlertsManager.getTriggerConditions(triggerId)
                .then(function (conditions) {
                if (conditions[0]) {
                    _this.threshold = conditions[0].threshold;
                }
            }, function (error) {
                _this.$log.error('Error Loading Threshold data');
                toastr.error('Error Loading Threshold Data: ' + error);
            });
        };
        MetricsViewController.prototype.refreshHistoricalChartDataForTimestamp = function (metricId, startTime, endTime) {
            var _this = this;
            /// calling refreshChartData without params use the model values
            if (!endTime) {
                endTime = this.endTimeStamp;
            }
            if (!startTime) {
                startTime = this.startTimeStamp;
            }
            if (metricId) {
                this.MetricsService.retrieveGaugeMetrics(this.$rootScope.currentPersona.id, metricId, startTime, endTime, 120)
                    .then(function (response) {
                    // we want to isolate the response from the data we are feeding to the chart
                    _this.bucketedDataPoints = HawkularMetrics.MetricsService.formatBucketedChartOutput(response);
                    if (_this.bucketedDataPoints.length) {
                        // this is basically the DTO for the chart
                        _this.chartData = {
                            id: metricId,
                            startTimeStamp: startTime,
                            endTimeStamp: endTime,
                            dataPoints: _this.bucketedDataPoints,
                            contextDataPoints: _this.contextDataPoints,
                            annotationDataPoints: null
                        };
                    }
                    else {
                        _this.$log.warn('No Data found for id: ' + metricId);
                    }
                }, function (error) {
                    _this.NotificationsService.error('Error Loading Chart Data: ' + error);
                });
            }
        };
        /// for minification only
        MetricsViewController.$inject = ['$scope', '$rootScope', '$interval', '$log',
            '$routeParams', 'HawkularAlertsManager', 'ErrorsManager', 'NotificationsService', 'MetricsService'];
        return MetricsViewController;
    })();
    HawkularMetrics.MetricsViewController = MetricsViewController;
    HawkularMetrics._module.controller('MetricsViewController', MetricsViewController);
})(HawkularMetrics || (HawkularMetrics = {}));

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// <reference path="../metricsPlugin.ts"/>
/// <reference path="../../../includes.ts"/>
var HawkularMetrics;
(function (HawkularMetrics) {
    var HkHeaderParser = (function () {
        function HkHeaderParser() {
            this.PARAMETER_EXPRESSION = /(rel)="(\w+)"/;
            this.total = 0;
        }
        HkHeaderParser.prototype.parseLinkHeader = function (value) {
            var relationLinks = {};
            if (!value) {
                return relationLinks;
            }
            var links = value.split(', ');
            for (var i = 0; i < links.length; i++) {
                var linkParts = links[i].split('>');
                var linkHref = linkParts[0].substring(1);
                var linkRelationParameterString = linkParts[1];
                var linkRelationParameterParts = this.PARAMETER_EXPRESSION.exec(linkRelationParameterString);
                // Get the relation name for current Link
                if (linkRelationParameterParts && linkRelationParameterParts[1] === 'rel' && linkRelationParameterParts[2]) {
                    //debugger;
                    relationLinks[linkRelationParameterParts[2]] = {
                        href: linkHref
                    };
                    // Get the parameters (page, per_page, ...) of current link
                    relationLinks[linkRelationParameterParts[2]]['params'] = {};
                    var linkHrefParts = linkHref.split('?');
                    var linkHrefParametersString = linkHrefParts[1];
                    var hrefParamsPairStringParts = linkHrefParametersString.split('&');
                    for (var j = 0; j < hrefParamsPairStringParts.length; j++) {
                        var parameterPair = hrefParamsPairStringParts[j];
                        var parameterPairParts = parameterPair.split('=');
                        if (parameterPairParts[0] && parameterPairParts[1]) {
                            relationLinks[linkRelationParameterParts[2]]['params'][parameterPairParts[0]] = parameterPairParts[1];
                        }
                    }
                }
            }
            return relationLinks;
        };
        HkHeaderParser.prototype.parse = function (headers) {
            return {
                total: headers['x-total-count'],
                rel: this.parseLinkHeader(headers.link)
            };
        };
        HkHeaderParser.$inject = [];
        return HkHeaderParser;
    })();
    HawkularMetrics.HkHeaderParser = HkHeaderParser;
    HawkularMetrics._module.service('HkHeaderParser', HkHeaderParser);
})(HawkularMetrics || (HawkularMetrics = {}));

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// <reference path="../metricsPlugin.ts"/>
var HawkularMetrics;
(function (HawkularMetrics) {
    var NotificationsService = (function () {
        function NotificationsService($log, toastr) {
            this.$log = $log;
            this.toastr = toastr;
        }
        NotificationsService.prototype.toastrPop = function (message, type) {
            this.$log.debug(message);
            this.toastr[type](message);
        };
        NotificationsService.prototype.info = function (message) {
            this.toastrPop(message, 'info');
        };
        NotificationsService.prototype.success = function (message) {
            this.toastrPop(message, 'success');
        };
        NotificationsService.prototype.warning = function (message) {
            this.toastrPop(message, 'warning');
        };
        NotificationsService.prototype.error = function (message) {
            this.toastrPop(message, 'error');
        };
        NotificationsService.prototype.alertSettingsSaved = function () {
            //this.toastrPop('Alert settings successfully saved', 'error');
            this.toastr.success('Alert settings successfully saved', '', { timeOut: 5000, closeButton: true,
                showEasing: 'easeOutBounce', hideEasing: 'easeInBack', closeEasing: 'easeInBack' });
        };
        NotificationsService.$inject = ['$log', 'toastr'];
        return NotificationsService;
    })();
    HawkularMetrics.NotificationsService = NotificationsService;
    HawkularMetrics._module.service('NotificationsService', NotificationsService);
})(HawkularMetrics || (HawkularMetrics = {}));

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// <reference path='metricsPlugin.ts'/>
/// <reference path='services/alertsManager.ts'/>
/// <reference path='services/paginationService.ts'/>
/// <reference path='services/errorsManager.ts'/>
/// <reference path='services/notificationsService.ts'/>
var HawkularMetrics;
(function (HawkularMetrics) {
    var UrlListController = (function () {
        function UrlListController($location, $scope, $rootScope, $interval, $log, $filter, $modal, HawkularInventory, HawkularMetric, HawkularAlertsManager, ErrorsManager, $q, MetricsService, md5, HkHeaderParser, NotificationsService, resourceUrl) {
            var _this = this;
            this.$location = $location;
            this.$scope = $scope;
            this.$rootScope = $rootScope;
            this.$interval = $interval;
            this.$log = $log;
            this.$filter = $filter;
            this.$modal = $modal;
            this.HawkularInventory = HawkularInventory;
            this.HawkularMetric = HawkularMetric;
            this.HawkularAlertsManager = HawkularAlertsManager;
            this.ErrorsManager = ErrorsManager;
            this.$q = $q;
            this.MetricsService = MetricsService;
            this.md5 = md5;
            this.HkHeaderParser = HkHeaderParser;
            this.NotificationsService = NotificationsService;
            this.resourceUrl = resourceUrl;
            this.httpUriPart = 'http://';
            this.resPerPage = 5;
            this.resCurPage = 0;
            this.lastUpdateTimestamp = new Date();
            this.headerLinks = {};
            this.updatingList = false;
            this.loadingMoreItems = false;
            this.addProgress = false;
            $scope.vm = this;
            this.resourceUrl = this.httpUriPart;
            if ($rootScope.currentPersona) {
                this.getResourceList(this.$rootScope.currentPersona.id);
            }
            else {
                // currentPersona hasn't been injected to the rootScope yet, wait for it..
                $rootScope.$watch('currentPersona', function (currentPersona) {
                    return currentPersona && _this.getResourceList(currentPersona.id);
                });
            }
            this.autoRefresh(20);
        }
        UrlListController.prototype.autoRefresh = function (intervalInSeconds) {
            var _this = this;
            this.autoRefreshPromise = this.$interval(function () {
                _this.getResourceList();
            }, intervalInSeconds * 1000);
            this.$scope.$on('$destroy', function () {
                _this.$interval.cancel(_this.autoRefreshPromise);
            });
        };
        UrlListController.prototype.addUrl = function (url) {
            var _this = this;
            if (this.$scope.addUrlForm.$invalid) {
                return;
            }
            this.addProgress = true;
            // prepare data for custom sorting of URLs.
            // We sort first by second and first levels and then by the rest of the levels in the order as they
            // lexicographically appear in the URL.
            // E.g. a.b.c.com will become c.com.a.b and we use this to sort the URLs instead of the URL strings
            // themselves.
            // Also, www is translated to a single space, so that it sorts before any other subdomain.
            var parsedUrl = new URL(url);
            var hostname = parsedUrl.hostname;
            var levels = hostname.split('.');
            if (levels.length > 1) {
                //doing this twice on a.b.redhat.com will produce redhat.com.a.b
                levels.unshift(levels.pop());
                levels.unshift(levels.pop());
                //replace all the www's with a space so that they sort before any other name
                levels = levels.map(function (s) {
                    return s === 'www' ? ' ' : s;
                });
            }
            var domainSort = levels.join('.');
            var resourceId = this.md5.createHash(url || '');
            var resource = {
                resourceTypePath: '/URL',
                id: resourceId,
                properties: {
                    url: url,
                    'hwk-gui-domainSort': domainSort
                }
            };
            this.$log.info('Adding new Resource Url to Hawkular-inventory: ' + url);
            var metricId;
            var defaultEmail = this.$rootScope.userDetails.email || 'myemail@company.com';
            var err = function (error, msg) { return _this.ErrorsManager.errorHandler(error, msg); };
            var currentTenantId = this.$rootScope.currentPersona.id;
            var resourcePath;
            /// Add the Resource and its metrics
            this.HawkularInventory.Resource.save({ environmentId: HawkularMetrics.globalEnvironmentId }, resource).$promise
                .then(function (newResource) {
                _this.getResourceList(currentTenantId);
                metricId = resourceId;
                _this.$log.info('New Resource ID: ' + metricId + ' created.');
                var metricsIds = [metricId + '.status.duration', metricId + '.status.code'];
                var metrics = [{
                        id: metricsIds[0],
                        metricTypePath: '/status.duration.type',
                        properties: {
                            description: 'Response Time in ms.'
                        }
                    }, {
                        id: metricsIds[1],
                        metricTypePath: '/status.code.type',
                        properties: {
                            description: 'Status Code'
                        }
                    }];
                var errMetric = function (error) { return err(error, 'Error saving metric.'); };
                var createMetric = function (metric) {
                    return _this.HawkularInventory.Metric.save({
                        environmentId: HawkularMetrics.globalEnvironmentId
                    }, metric).$promise;
                };
                var associateResourceWithMetrics = function () {
                    return _this.HawkularInventory.MetricOfResource.save({
                        environmentId: HawkularMetrics.globalEnvironmentId,
                        resourcePath: resourceId
                    }, ['../' + metricsIds[0], '../' + metricsIds[1]]).$promise;
                };
                /// For right now we will just Register a couple of metrics automatically
                return _this.$q.all([createMetric(metrics[0]), createMetric(metrics[1])])
                    .then(associateResourceWithMetrics, errMetric)
                    .catch(function (e) { return err(e, 'Error associating metrics with resource.'); });
            })
                .then(function () { return _this.HawkularAlertsManager.addEmailAction(defaultEmail); }, function (e) { return err(e, 'Error during saving metrics.'); })
                .then(function () {
                for (var i = 0; i < _this.resourceList.length; i++) {
                    if (metricId === _this.resourceList[i].id) {
                        resourcePath = _this.resourceList[i].path;
                        break;
                    }
                }
                var triggerId = metricId + '_trigger_thres';
                var dataId = triggerId.slice(0, -14) + '.status.duration';
                var fullTrigger = {
                    trigger: {
                        id: triggerId,
                        name: url,
                        description: 'Response Time for URL ' + url,
                        severity: 'HIGH',
                        actions: { email: [defaultEmail] },
                        context: {
                            description: 'Response Time for URL ' + url,
                            resourceType: 'URL',
                            resourceName: url,
                            resourcePath: resourcePath
                        }
                    },
                    dampenings: [
                        {
                            triggerId: triggerId,
                            evalTimeSetting: 7 * 60000,
                            triggerMode: 'FIRING',
                            type: 'STRICT_TIME'
                        },
                        {
                            triggerId: triggerId,
                            evalTimeSetting: 5 * 60000,
                            triggerMode: 'AUTORESOLVE',
                            type: 'STRICT_TIME'
                        }
                    ],
                    conditions: [
                        {
                            triggerId: triggerId,
                            triggerMode: 'FIRING',
                            type: 'THRESHOLD',
                            dataId: dataId,
                            operator: 'GT',
                            threshold: 1000,
                            context: {
                                description: 'Response Time',
                                unit: 'ms'
                            }
                        },
                        {
                            triggerId: triggerId,
                            triggerMode: 'AUTORESOLVE',
                            type: 'THRESHOLD',
                            dataId: dataId,
                            operator: 'LTE',
                            threshold: 1000,
                            context: {
                                description: 'Response Time',
                                unit: 'ms'
                            }
                        }
                    ]
                };
                return _this.HawkularAlertsManager.createTrigger(fullTrigger, function (e) { return err(e, 'Error saving threshold trigger.'); });
            })
                .then(function () {
                var triggerId = metricId + '_trigger_avail';
                var dataId = triggerId.slice(0, -14);
                var fullTrigger = {
                    trigger: {
                        id: triggerId,
                        name: url,
                        description: 'Availability for URL ' + url,
                        severity: 'CRITICAL',
                        actions: { email: [defaultEmail] },
                        context: {
                            description: 'Availability for URL ' + url,
                            resourceType: 'URL',
                            resourceName: url,
                            resourcePath: resourcePath
                        }
                    },
                    dampenings: [
                        {
                            triggerId: triggerId,
                            evalTimeSetting: 7 * 60000,
                            triggerMode: 'FIRING',
                            type: 'STRICT_TIME'
                        },
                        {
                            triggerId: triggerId,
                            evalTimeSetting: 5 * 60000,
                            triggerMode: 'AUTORESOLVE',
                            type: 'STRICT_TIME'
                        }
                    ],
                    conditions: [
                        {
                            triggerId: triggerId,
                            triggerMode: 'FIRING',
                            type: 'AVAILABILITY',
                            dataId: dataId,
                            operator: 'DOWN',
                            context: {
                                description: 'Availability'
                            }
                        },
                        {
                            triggerId: triggerId,
                            triggerMode: 'AUTORESOLVE',
                            type: 'AVAILABILITY',
                            dataId: dataId,
                            operator: 'UP',
                            context: {
                                description: 'Availability'
                            }
                        }
                    ]
                };
                return _this.HawkularAlertsManager.createTrigger(fullTrigger, function (e) { return err(e, 'Error saving availability trigger.'); });
            })
                .then(function () { return _this.$log.log('Your data is being collected.'); }, function (e) { return err(e, 'Error saving availability trigger.'); })
                .finally(function () {
                _this.resourceUrl = _this.httpUriPart;
                _this.$scope.addUrlForm.$setPristine();
                _this.addProgress = false;
            });
        };
        UrlListController.prototype.getResourceList = function (currentTenantId) {
            var _this = this;
            this.updatingList = true;
            var tenantId = currentTenantId || this.$rootScope.currentPersona.id;
            var sort = 'hwk-gui-domainSort';
            var order = 'asc';
            this.HawkularInventory.ResourceOfType.query({ resourceTypeId: 'URL', per_page: this.resPerPage, page: this.resCurPage, sort: sort, order: order }, function (aResourceList, getResponseHeaders) {
                // FIXME: hack.. make expanded out of list
                _this.headerLinks = _this.HkHeaderParser.parse(getResponseHeaders());
                aResourceList.expanded = _this.resourceList ? _this.resourceList.expanded : [];
                _this.HawkularAlertsManager.queryAlerts({ statuses: 'OPEN' }).then(function (queriedAlerts) {
                    _this.alertList = queriedAlerts.alertList;
                });
                var promises = [];
                angular.forEach(aResourceList, function (res) {
                    var traitsArray = [];
                    if (res.properties['trait-remote-address']) {
                        traitsArray.push('IP: ' + res.properties['trait-remote-address']);
                    }
                    if (res.properties['trait-powered-by']) {
                        traitsArray.push('Powered by: ' + res.properties['trait-powered-by']);
                    }
                    res['traits'] = traitsArray.join(' | ');
                    promises.push(this.HawkularMetric.GaugeMetricData(tenantId).queryMetrics({
                        resourcePath: res.id, gaugeId: (res.id + '.status.duration'),
                        start: moment().subtract(1, 'hours').valueOf(), end: moment().valueOf()
                    }, function (resource) {
                        res['responseTime'] = resource;
                    }).$promise);
                    promises.push(this.HawkularMetric.AvailabilityMetricData(tenantId).query({
                        availabilityId: res.id, distinct: true,
                        start: 1, end: moment().valueOf()
                    }, function (resource) {
                        resource.reverse(); // FIXME: HAWKULAR-366
                        res['isUp'] = (resource[0] && resource[0].value === 'up');
                    }).$promise);
                    var availPromise = this.MetricsService.retrieveAvailabilityMetrics(this.$rootScope.currentPersona.id, res.id, 1, moment().valueOf(), 1);
                    promises.push(availPromise);
                    availPromise.then(function (resource) {
                        res['availability'] = resource[0].uptimeRatio * 100;
                        res['downtimeDuration'] = Math.round(resource[0].downtimeDuration / 1000 / 60);
                        res['lastDowntime'] = resource[0].lastDowntime;
                    });
                    this.lastUpdateTimestamp = new Date();
                }, _this);
                _this.$q.all(promises).then(function () {
                    _this.resourceList = aResourceList;
                    _this.updatingList = _this.loadingMoreItems = false;
                    _this.$scope.$emit('list:updated');
                });
            });
        };
        UrlListController.prototype.deleteResource = function (resource) {
            var _this = this;
            this.$modal.open({
                templateUrl: 'plugins/metrics/html/modals/delete-resource.html',
                controller: DeleteResourceModalController,
                resolve: {
                    resource: function () { return resource; }
                }
            }).result.then(function (result) { return _this.getResourceList(); });
        };
        UrlListController.prototype.setPage = function (page) {
            this.resCurPage = page;
            this.getResourceList();
        };
        UrlListController.prototype.loadMoreItems = function () {
            if (!this.updatingList && this.resourceList && this.resourceList.length > 0 &&
                this.resourceList.length < parseInt(this.headerLinks.total, 10)) {
                this.loadingMoreItems = true;
                this.resPerPage += 5;
                this.getResourceList();
            }
        };
        /// this is for minification purposes
        UrlListController.$inject = ['$location', '$scope', '$rootScope', '$interval', '$log', '$filter', '$modal',
            'HawkularInventory', 'HawkularMetric', 'HawkularAlertsManager', 'ErrorsManager', '$q', 'MetricsService',
            'md5', 'HkHeaderParser', 'NotificationsService'];
        return UrlListController;
    })();
    HawkularMetrics.UrlListController = UrlListController;
    var DeleteResourceModalController = (function () {
        function DeleteResourceModalController($scope, $rootScope, $modalInstance, $q, HawkularInventory, HawkularAlertsManager, NotificationsService, resource) {
            this.$scope = $scope;
            this.$rootScope = $rootScope;
            this.$modalInstance = $modalInstance;
            this.$q = $q;
            this.HawkularInventory = HawkularInventory;
            this.HawkularAlertsManager = HawkularAlertsManager;
            this.NotificationsService = NotificationsService;
            this.resource = resource;
            $scope.vm = this;
        }
        DeleteResourceModalController.prototype.deleteResource = function () {
            var _this = this;
            var metricsIds = [this.resource.id + '.status.duration', this.resource.id + '.status.code'];
            var triggerIds = [this.resource.id + '_trigger_thres', this.resource.id + '_trigger_avail'];
            var deleteMetric = function (metricId) {
                return _this.HawkularInventory.Metric.delete({
                    environmentId: HawkularMetrics.globalEnvironmentId,
                    metricId: metricId
                }).$promise;
            };
            var removeResource = function () {
                return _this.HawkularInventory.Resource.delete({
                    environmentId: HawkularMetrics.globalEnvironmentId,
                    resourcePath: _this.resource.id
                }).$promise;
            };
            this.$q.all([deleteMetric(metricsIds[0]),
                deleteMetric(metricsIds[1]),
                this.HawkularAlertsManager.deleteTrigger(triggerIds[0]),
                this.HawkularAlertsManager.deleteTrigger(triggerIds[1])])
                .then(removeResource)
                .then(function (res) {
                _this.NotificationsService.success('The URL ' + _this.resource.properties.url +
                    ' is no longer being monitored.');
                _this.$modalInstance.close(res);
            });
        };
        DeleteResourceModalController.prototype.cancel = function () {
            this.$modalInstance.dismiss('cancel');
        };
        DeleteResourceModalController.$inject = ['$scope', '$rootScope', '$modalInstance', '$q', 'HawkularInventory', 'HawkularAlertsManager',
            'NotificationsService', 'resource'];
        return DeleteResourceModalController;
    })();
    HawkularMetrics._module.controller('UrlListController', UrlListController);
})(HawkularMetrics || (HawkularMetrics = {}));

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// <reference path='../../includes.ts'/>	
var HawkularTopology;
(function (HawkularTopology) {
    /// some config vars
    HawkularTopology.pluginName = 'hawkular-topology';
    HawkularTopology.log = Logger.get(HawkularTopology.pluginName);
    HawkularTopology.templatePath = 'plugins/topology/html';
    HawkularTopology._module = angular.module(HawkularTopology.pluginName, ['ngResource', 'ui.select',
        'hawkular.services', 'ui.bootstrap', 'topbar', 'patternfly.select', 'toastr',
        'infinite-scroll', 'mgo-angular-wizard']);
    HawkularTopology.globalEnvironmentId = 'test';
})(HawkularTopology || (HawkularTopology = {}));

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// <reference path='../../includes.ts'/>
/// <reference path='../ts/topologyGlobals.ts'/>
var HawkularTopology;
(function (HawkularTopology) {
    HawkularTopology._module.directive('hawkularTopologyGraph', function () {
        return {
            restrict: 'E',
            scope: {
                items: '=',
                relations: '=',
                kinds: '=',
                selection: '=',
                force: '='
            },
            link: function ($scope, element, attributes) {
                element.css('display', 'block');
                var graph;
                function notify(item) {
                    var event = $scope.$emit('select', item);
                    if (attributes['selection'] === undefined && !event.defaultPrevented) {
                        graph.select(item);
                    }
                }
                function icon(d) {
                    var text;
                    var kinds = $scope.kinds;
                    if (kinds) {
                        text = kinds[d.item.kind];
                    }
                    return text || '';
                }
                function weak(d) {
                    var status = d.item.status;
                    return status && status.phase && status.phase !== 'Running';
                }
                function title(d) {
                    return d.item.metadata.name;
                }
                function render(args) {
                    var vertices = args[0];
                    var added = args[1];
                    var event = $scope.$emit('render', vertices, added);
                    if (!event.defaultPrevented) {
                        added.attr('class', function (d) { return d.item.kind; });
                        added.append('use').attr('xlink:href', icon);
                        added.append('title');
                        vertices.selectAll('title')
                            .text(function (d) { return d.item.metadata.name; });
                        vertices.classed('weak', weak);
                    }
                }
                graph = HawkularTopology.initGraph(element[0], $scope.force, notify);
                $scope.$watchCollection('kinds', function (value) { return render(graph.kinds(value)); });
                $scope.$watchGroup(['items', 'relations'], function (values) { return render(graph.data(values[0], values[1])); });
                $scope.$watch('selection', function (item) { return graph.select(item); });
                element.on('$destroy', function () { return graph.close(); });
            }
        };
    });
})(HawkularTopology || (HawkularTopology = {}));

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// <reference path='../../includes.ts'/>
/// <reference path='../ts/topologyGlobals.ts'/>
var HawkularTopology;
(function (HawkularTopology) {
    HawkularTopology._module.directive('hawkularTopologyIcon', function () {
        return {
            restrict: 'E',
            transclude: true,
            template: '<ng-transclude></ng-transclude>',
            link: function ($scope, element, attrs) {
                var kind = attrs.kind;
                var value = $scope.vm.kinds[kind];
                $scope.$watchCollection('kinds', function () { return element.toggleClass('active', kind in $scope.vm.kinds); });
                element.on('click', function () {
                    if (kind in $scope.vm.kinds) {
                        value = $scope.vm.kinds[kind];
                        delete $scope.vm.kinds[kind];
                    }
                    else {
                        $scope.vm.kinds[kind] = value;
                    }
                    if ($scope.$parent) {
                        $scope.$parent.$digest();
                    }
                    if ($scope.$root) {
                        $scope.$root.$digest();
                    }
                    $scope.$digest();
                });
            }
        };
    });
})(HawkularTopology || (HawkularTopology = {}));

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// <reference path='../../includes.ts'/>
/// <reference path='topologyGlobals.ts'/>
var HawkularTopology;
(function (HawkularTopology) {
    HawkularTopology._module.run(function ($rootScope, $location) {
        /* A cache to prevent jumping when rapidly toggling views */
        var cache = {};
        var initGraph = function (selector, force, notify) {
            var outer = d3.select(selector);
            /* Kinds of objects to show */
            var kinds = null;
            /* Data we've been fed */
            var items = {};
            var relations = [];
            /* Graph information */
            var width;
            var height;
            var timeout;
            var nodes = [];
            var links = [];
            var lookup = {};
            var selection = null;
            var isDragging = false;
            /* Allow the force to be passed in, default if not */
            if (!force) {
                force = d3.layout.force()
                    .charge(-800)
                    .gravity(0.2)
                    .linkStrength(2)
                    .linkDistance(80);
            }
            var drag = force.drag();
            var svg = outer.append('svg')
                .attr('viewBox', '0 0 1600 1200')
                .attr('preserveAspectRatio', 'xMidYMid meet')
                .attr('class', 'hawkular-topology');
            var vertices = d3.select();
            var edges = d3.select();
            force.on('tick', function () {
                edges.attr('x1', function (d) { return d.source.x; })
                    .attr('y1', function (d) { return d.source.y; })
                    .attr('x2', function (d) { return d.target.x; })
                    .attr('y2', function (d) { return d.target.y; });
                vertices.attr('transform', function (d) { return 'translate(' + d.x + ',' + d.y + ')'; });
            });
            var tip = d3.tip()
                .attr('class', 'd3-tip')
                .offset([-10, 0])
                .html(function (d) {
                return '<table><tr><td><span class="chartHoverLabel">' + d.item.kind +
                    ':</span></td><td><span class="chartHoverValue">' + d.item.metadata.name + '</span></td></tr>' +
                    (d.item.kind === 'Server' ?
                        '<tr><td><span class="chartHoverLabel">IP:</span></td><td><span class="chartHoverValue">' +
                            d.item.metadata.ip +
                            '</span></td></tr><tr><td><span class="chartHoverLabel">Hostname:</span></td><td>' +
                            '<span class="chartHoverValue">' +
                            d.item.metadata.hostname + '</span></td></tr></table>' : '');
            });
            drag
                .on('dragstart', function (d) {
                tip.hide();
                isDragging = true;
                notify(d.item);
                if (d.fixed !== true) {
                    d.floatpoint = [d.x, d.y];
                }
                d.fixed = true;
                // d3.selectAll('g').classed('fixed', true);
            })
                .on('dragend', function (d) {
                var moved = true;
                isDragging = false;
                if (d.floatpoint) {
                    moved = (d.x < d.floatpoint[0] - 5 || d.x > d.floatpoint[0] + 5) ||
                        (d.y < d.floatpoint[1] - 5 || d.y > d.floatpoint[1] + 5);
                    delete d.floatpoint;
                }
                d.fixed = moved && d.x > 3 && d.x < (width - 3) && d.y >= 3 && d.y < (height - 3);
                // d3.selectAll('g').classed('fixed', d.fixed);
            });
            svg
                .on('dblclick', function () {
                if (!d3.select(d3.event.target).datum()) {
                    svg.selectAll('g')
                        .classed('fixed', false)
                        .each(function (d) { return d.fixed = false; });
                    force.start();
                }
            })
                .on('click', function (ev) {
                if (!d3.select(d3.event.target).datum()) {
                    notify(null);
                }
            });
            svg.call(tip);
            function select(item) {
                selection = item;
                svg.selectAll('g')
                    .classed('selected', function (d) { return d.item === item; });
            }
            function adjust() {
                timeout = null;
                width = outer.node().clientWidth;
                height = outer.node().clientHeight;
                force.size([width, height]);
                svg.attr('viewBox', '0 0 ' + width + ' ' + height);
                update();
            }
            function update() {
                edges = svg.selectAll('line')
                    .data(links);
                edges.exit().remove();
                edges.enter().insert('line', ':first-child');
                edges.attr('class', function (d) { return d.kinds; });
                vertices = svg.selectAll('g')
                    .data(nodes, function (d) { return d.id; }).attr('class', 'foo');
                vertices.exit().remove();
                var extractServerId = function (id) { return id.substring(0, id.indexOf('/') - 1); };
                var added = vertices.enter().append('g')
                    .on('mouseover', function (d, i) { return !isDragging && tip.show(d, i); })
                    .on('mouseout', tip.hide)
                    .on('dblclick', function (n) {
                    console.log('redirect');
                    var path;
                    switch (n.item.kind) {
                        case 'Server':
                            var id = n.item.id.substring(0, n.item.id.length - 2);
                            path = '/hawkular-ui/app/app-details/' + id + '/jvm';
                            break;
                        case 'App':
                            path = '/hawkular-ui/app/app-details/' + extractServerId(n.item.id) + '/deployments/';
                            break;
                        case 'DataSource':
                            path = '/hawkular-ui/app/app-details/' + extractServerId(n.item.id) + '/datasources';
                            break;
                        default:
                            return;
                    }
                    $location.path(path);
                    $rootScope.$digest();
                })
                    .call(drag);
                select(selection);
                force
                    .nodes(nodes)
                    .links(links)
                    .start();
                return added;
            }
            function digest() {
                var pnodes = nodes;
                var plookup = lookup;
                /* The actual data for the graph */
                nodes = [];
                links = [];
                lookup = {};
                var item, id, kind, node;
                angular.forEach(items, function (item, id) {
                    kind = item.kind;
                    if (kinds && !kinds[kind]) {
                        return;
                    }
                    /* Prevents flicker */
                    node = pnodes[plookup[id]];
                    if (!node) {
                        node = cache[id];
                        delete cache[id];
                        if (!node) {
                            node = {};
                        }
                    }
                    node.id = id;
                    node.item = item;
                    lookup[id] = nodes.length;
                    nodes.push(node);
                });
                var i, len, relation, s, t;
                for (i = 0, len = relations.length; i < len; i++) {
                    relation = relations[i];
                    s = lookup[relation.source];
                    t = lookup[relation.target];
                    if (s === undefined || t === undefined) {
                        continue;
                    }
                    links.push({ source: s, target: t, kinds: nodes[s].item.kind + nodes[t].item.kind });
                }
                if (width && height) {
                    return update();
                }
                else {
                    return d3.select();
                }
            }
            function resized() {
                window.clearTimeout(timeout);
                timeout = window.setTimeout(adjust, 150);
            }
            window.addEventListener('resize', resized);
            adjust();
            resized();
            return {
                select: select,
                kinds: function (value) {
                    kinds = value;
                    var added = digest();
                    return [vertices, added];
                },
                data: function (new_items, new_relations) {
                    items = new_items || {};
                    relations = new_relations || [];
                    var added = digest();
                    return [vertices, added];
                },
                close: function () {
                    window.removeEventListener('resize', resized);
                    window.clearTimeout(timeout);
                    /*
                     * Keep the positions of these items cached,
                     * in case we are asked to make the same graph again.
                     */
                    var id, node;
                    cache = {};
                    angular.forEach(lookup, function (value, id) {
                        node = nodes[lookup[id]];
                        delete node.item;
                        cache[id] = node;
                    });
                    nodes = [];
                    lookup = {};
                }
            };
        };
        HawkularTopology.initGraph = initGraph;
    });
})(HawkularTopology || (HawkularTopology = {}));

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// <reference path='../../includes.ts'/>
/// <reference path='topologyGlobals.ts'/>
var HawkularTopology;
(function (HawkularTopology) {
    HawkularTopology._module.config([
        '$routeProvider', 'HawtioNavBuilderProvider',
        function ($routeProvider, builder) {
            $routeProvider
                .when('/hawkular-ui/topology/view', { templateUrl: builder.join(HawkularTopology.templatePath, 'index.html') });
        }]);
    var TopologyController = (function () {
        function TopologyController($rootScope, $scope, 
            // private $log:ng.ILogApp,
            $interval, $log, $routeParams, $modal, 
            // private $q: ng.IQApp,
            $q, HawkularAccount, HawkularInventory, 
            // private NotificationsApp:INotificationsApp,
            userDetails) {
            this.$rootScope = $rootScope;
            this.$scope = $scope;
            this.$interval = $interval;
            this.$log = $log;
            this.$routeParams = $routeParams;
            this.$modal = $modal;
            this.$q = $q;
            this.HawkularAccount = HawkularAccount;
            this.HawkularInventory = HawkularInventory;
            this.userDetails = userDetails;
            this.index = 0;
            var datasets = [];
            function sink(dataset) {
                datasets.push(dataset);
            }
            this.kinds = {
                Server: '#vertex-Server',
                DataSource: '#vertex-DataSource',
                Database: '#vertex-Database',
                App: '#vertex-App'
            };
            $rootScope.$on('select', function (ev, item) {
                var text = '';
                if (item) {
                    text = 'Selected: ' + item.metadata.name;
                }
                angular.element(document.getElementById('selected')).text(text);
            });
            // fetch the data from the inventory
            this.getData();
            this.autoRefresh(20);
        }
        TopologyController.prototype.testClick = function () {
            this.index += 1;
            this.data.items[this.index] = {
                kind: 'DataSource'
            };
            this.$rootScope.$digest();
        };
        TopologyController.prototype.autoRefresh = function (intervalInSeconds) {
            var _this = this;
            this.autoRefreshPromise = this.$interval(function () {
                _this.getData();
            }, intervalInSeconds * 1000);
            this.$scope.$on('$destroy', function () {
                _this.$interval.cancel(_this.autoRefreshPromise);
            });
        };
        TopologyController.prototype.getResourcesForResType = function (feedId, resourceType) {
            return this.HawkularInventory.ResourceOfTypeUnderFeed.query({ environmentId: HawkularTopology.globalEnvironmentId,
                feedId: feedId,
                resourceTypeId: resourceType }).$promise;
        };
        TopologyController.prototype.getDataForOneFeed = function (feedId) {
            var promises = [];
            promises.push(this.getResourcesForResType(feedId, 'WildFly Server'));
            promises.push(this.getResourcesForResType(feedId, 'Datasource'));
            promises.push(this.getResourcesForResType(feedId, 'Deployment'));
            return this.$q.all(promises);
        };
        TopologyController.prototype.getServerMetadata = function (feedId, serverId, metadata) {
            this.HawkularInventory.ResourceUnderFeed.getData({ environmentId: HawkularTopology.globalEnvironmentId,
                feedId: feedId,
                resourcePath: serverId }, function (data) {
                metadata.metadata.ip = data.value['Bound Address'];
                metadata.metadata.hostname = data.value.Hostname;
                metadata.metadata.version = data.value.Version;
            });
        };
        TopologyController.prototype.getData = function () {
            var _this = this;
            var typeToKind = {
                'WildFly Server': 'Server',
                'Datasource': 'DataSource',
                'Deployment': 'App'
            };
            var extractServerId = function (id) { return id.substring(0, id.indexOf('/')) + '~'; };
            this.HawkularInventory.Feed.query({ environmentId: HawkularTopology.globalEnvironmentId }, function (aFeedList) {
                if (!aFeedList.length) {
                    return;
                }
                var promises = [];
                angular.forEach(aFeedList, function (feed) {
                    promises.push(_this.getDataForOneFeed(feed.id));
                });
                _this.$q.all(promises).then(function (aResourceList) {
                    var newRelations = [];
                    var newData = {
                        items: {},
                        relations: {}
                    };
                    var flatResources = _.flatten(aResourceList, true);
                    angular.forEach(flatResources, function (res) {
                        var newItem = {
                            kind: typeToKind[res.type.id],
                            id: res.id,
                            metadata: {
                                name: res.name
                            }
                        };
                        if (newItem.kind !== 'Server') {
                            newRelations.push({
                                source: extractServerId(res.id),
                                target: res.id
                            });
                        }
                        else {
                            // todo: feed id
                            _this.getServerMetadata('localhost', res.id, newItem);
                        }
                        newData.items[res.id] = newItem;
                    });
                    newData.relations = newRelations;
                    _this.data = newData;
                });
            });
        };
        TopologyController.$inject = ['$rootScope', '$scope', '$interval', '$log', '$routeParams', '$modal', '$q',
            'HawkularAccount', 'HawkularInventory', 'userDetails'];
        return TopologyController;
    })();
    HawkularTopology.TopologyController = TopologyController;
    HawkularTopology._module.controller('HawkularTopology.TopologyController', TopologyController);
    // so the same scroll doesn't trigger multiple times
    angular.module('infinite-scroll').value('THROTTLE_MILLISECONDS', 250);
    hawtioPluginLoader.addModule(HawkularTopology.pluginName);
})(HawkularTopology || (HawkularTopology = {}));

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// <reference path='../../includes.ts'/>
var Emails;
(function (Emails) {
    Emails.pluginName = 'emails';
    Emails._module = angular.module(Emails.pluginName, ['ui.bootstrap']);
})(Emails || (Emails = {}));

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// <reference path="../../includes.ts"/>
/// <reference path="emailsGlobals.ts"/>
/// <reference path="emailsDirective.ts"/>
var Emails;
(function (Emails) {
    Emails._module.directive('hawkularEmails', function () {
        return new Emails.EmailsDirective();
    });
    hawtioPluginLoader.addModule(Emails.pluginName);
})(Emails || (Emails = {}));

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// <reference path='emailsPlugin.ts'/>
var Emails;
(function (Emails) {
    var EmailsDirective = (function () {
        function EmailsDirective() {
            this.require = 'ngModel';
        }
        EmailsDirective.prototype.link = function (scope, elm, attrs, ctrl) {
            ctrl.$validators.emails = function (modelValue, viewValue) {
                if (ctrl.$isEmpty(modelValue)) {
                    // consider empty models to be valid
                    return true;
                }
                var atLeastOneInvalid = true; // until proven otherwise...
                viewValue
                    .split(/[,\s]/)
                    .filter(function (entry) {
                    return entry && entry.length > 0;
                })
                    .forEach(function (email) {
                    var re = /^([\w-]+(?:\.[\w-]+)*)@((?:[\w-]+\.)*\w[\w-]{0,66})\.([a-z]{2,6}(?:\.[a-z]{2})?)$/i;
                    var valid = re.test(email);
                    if (!valid) {
                        atLeastOneInvalid = false;
                    }
                });
                return atLeastOneInvalid;
            };
        };
        return EmailsDirective;
    })();
    Emails.EmailsDirective = EmailsDirective;
})(Emails || (Emails = {}));

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// <reference path='../../includes.ts'/>
var Subtab;
(function (Subtab) {
    Subtab.pluginName = 'subtab';
    Subtab.log = Logger.get(Subtab.pluginName);
    Subtab.templatePath = 'plugins/directives/subtab/html/subtab.html';
    Subtab.globalEnvironmentId = 'test';
})(Subtab || (Subtab = {}));

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// <reference path="../../includes.ts"/>
/// <reference path="subtabGlobals.ts"/>
/// <reference path="subtabDirective.ts"/>
var Subtab;
(function (Subtab) {
    Subtab._module = angular.module(Subtab.pluginName, ['duScroll']);
    Subtab._module.directive('hawkularSubtab', function () {
        return new Subtab.SubtabDirective();
    });
    hawtioPluginLoader.addModule(Subtab.pluginName);
})(Subtab || (Subtab = {}));

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// <reference path='subtabPlugin.ts'/>
var Subtab;
(function (Subtab) {
    var SubtabDirective = (function () {
        function SubtabDirective() {
            this.restrict = 'E';
            this.transclude = true;
            this.replace = false;
            this.templateUrl = Subtab.templatePath;
        }
        return SubtabDirective;
    })();
    Subtab.SubtabDirective = SubtabDirective;
    //@todo: Change to controller class and controllerAs style
    Subtab.SubtabController = Subtab._module.controller('Subtab.SubtabController', ['$scope', '$rootScope', '$location', 'HawkularNav', 'HawkularInventory', function ($scope, $rootScope, $location, HawkularNav, HawkularInventory) {
            $scope.isAlertsPage = function () {
                return $location.path().indexOf('/hawkular-ui/alerts-center') === 0;
            };
            $scope.isUrlPage = function () {
                return $location.path().indexOf('/hawkular-ui/url/') !== 0;
            };
            $scope.isAppServerPage = function () {
                return $location.path().indexOf('/hawkular-ui/app/') === 0;
            };
            $scope.getClass = function (path) {
                return $location.path().indexOf(path) === 0 ? 'active' : '';
            };
            $scope.rangeNames = {
                '3600000': 'Last Hour',
                '43200000': 'Last 12 Hours',
                '86400000': 'Last Day',
                '604800000': 'Last Week',
                '2592000000': 'Last Month',
                '31536000000': 'Last Year'
            };
            $scope.getFormattedDate = function () {
                var diff = $scope.hkParams.timeOffset;
                var DATE_FORMAT = 'D MMM YYYY';
                var HOUR_FORMAT = 'HH:mm';
                // FIXME: Use moment ?
                $scope.offsetName = $scope.rangeNames[$scope.hkParams.timeOffset] || 'Custom';
                // TODO: Use this for custom
                // let momStart = moment($scope.hkStartTimestamp);
                // let momEnd = moment($scope.hkEndTimestamp);
                var momStart = moment().subtract($scope.hkParams.timeOffset, 'milliseconds');
                var momEnd = moment();
                if (diff < 24 * 60 * 60 * 1000) {
                    return momStart.format(DATE_FORMAT) + ' ' + momStart.format(HOUR_FORMAT) + ' - ' +
                        (momStart.day() !== momEnd.day() ? momEnd.format(DATE_FORMAT) : '') + momEnd.format(HOUR_FORMAT);
                }
                else {
                    return momStart.format(DATE_FORMAT) + ' - ' + momEnd.format(DATE_FORMAT);
                }
            };
            $scope.setRange = function (range) {
                HawkularNav.setTimestamp(moment.duration(range).valueOf());
            };
            $scope.getUrlFromId = function (id) {
                if (!$scope.resource) {
                    $scope.resource = HawkularInventory.Resource.get({ environmentId: Subtab.globalEnvironmentId, resourcePath: id }, function (data) {
                        $scope.resourceName = data.properties.url;
                    });
                }
                return $scope.resource;
            };
            // FIXME: Mock data.. remove when we have real app servers
            $scope.getAppServerFromId = function (id) {
                $scope.resourceName = id;
            };
        }]);
})(Subtab || (Subtab = {}));

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// <reference path='../../includes.ts'/>
var Topbar;
(function (Topbar) {
    Topbar.pluginName = 'topbar';
    Topbar.templatePath = 'plugins/directives/topbar/html/topbar.html';
    Topbar.globalEnvironmentId = 'test';
})(Topbar || (Topbar = {}));

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// <reference path="../../includes.ts"/>
/// <reference path="topbarGlobals.ts"/>
/// <reference path="topbarDirective.ts"/>
var Topbar;
(function (Topbar) {
    Topbar._module = angular.module(Topbar.pluginName, ['ngResource', 'hawkular.services', 'ui.bootstrap']);
    Topbar._module.directive('hawkularTopbar', function () {
        return new Topbar.TopbarDirective();
    });
    hawtioPluginLoader.addModule(Topbar.pluginName);
})(Topbar || (Topbar = {}));

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// <reference path='topbarPlugin.ts'/>
var Topbar;
(function (Topbar) {
    var TopbarDirective = (function () {
        function TopbarDirective() {
            this.restrict = 'E';
            this.transclude = false;
            this.replace = false;
            this.templateUrl = Topbar.templatePath;
        }
        return TopbarDirective;
    })();
    Topbar.TopbarDirective = TopbarDirective;
    Topbar.TopbarController = Topbar._module.controller('Topbar.TopbarController', ['$scope', '$rootScope', '$location', 'HawkularNav',
        function ($scope, $rootScope, $location, HawkularNav /* keep HawkularNav! */) {
            $scope.getClass = function (path) {
                return $location.path().indexOf(path) === 0 ? 'active' : '';
            };
        }]);
})(Topbar || (Topbar = {}));

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// <reference path="../../includes.ts"/>
/// <reference path="topbarGlobals.ts"/>
/// <reference path="topbarPlugin.ts"/>
var Topbar;
(function (Topbar) {
    var HawkularNav = (function () {
        function HawkularNav($rootScope, $route, $routeParams, HawkularInventory) {
            var _this = this;
            this.$rootScope = $rootScope;
            this.$route = $route;
            this.$routeParams = $routeParams;
            this.HawkularInventory = HawkularInventory;
            $rootScope.hkParams = $routeParams || [];
            // default time period set to 24 hours
            var defaultOffset = 1 * 60 * 60 * 1000;
            var init = function (tenantId) {
                HawkularInventory.Resource.query({ environmentId: Topbar.globalEnvironmentId }, function (resourceList) {
                    $rootScope.hkResources = resourceList;
                    for (var i = 0; i < resourceList.length; i++) {
                        if (resourceList[i].id === $rootScope.hkParams.resourceId) {
                            $rootScope.selectedResource = resourceList[i];
                        }
                    }
                });
                $rootScope.hkParams.timeOffset = $routeParams.timeOffset || defaultOffset;
                $rootScope.hkEndTimestamp = $routeParams.endTimestamp || moment().valueOf();
                $rootScope.hkStartTimestamp = moment().subtract($rootScope.hkParams.timeOffset, 'milliseconds').valueOf();
                $rootScope.$on('$routeChangeSuccess', function (event, current, previous) {
                    $rootScope.hkParams = current.params;
                    $rootScope.hkParams.timeOffset = $routeParams.timeOffset || defaultOffset;
                    $rootScope.hkEndTimestamp = $routeParams.endTimestamp || moment().valueOf();
                    $rootScope.hkStartTimestamp = moment().subtract($rootScope.hkParams.timeOffset, 'milliseconds').valueOf();
                }, _this);
            };
            var tenantId = this.$rootScope.currentPersona && this.$rootScope.currentPersona.id;
            if (tenantId) {
                init(tenantId);
            }
            else {
                // currentPersona hasn't been injected to the rootScope yet, wait for it..
                $rootScope.$watch('currentPersona', function (currentPersona) { return currentPersona && init(currentPersona.id); });
            }
        }
        HawkularNav.prototype.setTimestamp = function (offset, end) {
            this.$route.updateParams({ timeOffset: offset, endTime: end });
        };
        HawkularNav.$inject = ['$rootScope', '$route', '$routeParams', 'HawkularInventory'];
        return HawkularNav;
    })();
    Topbar.HawkularNav = HawkularNav;
    Topbar._module.service('HawkularNav', HawkularNav);
})(Topbar || (Topbar = {}));

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// <reference path="../metricsPlugin.ts"/>
/// <reference path="../services/alertsManager.ts"/>
/// <reference path="../services/errorsManager.ts"/>
var HawkularMetrics;
(function (HawkularMetrics) {
    var AppServerAlertsDetailsController = (function () {
        function AppServerAlertsDetailsController() {
        }
        return AppServerAlertsDetailsController;
    })();
    HawkularMetrics.AppServerAlertsDetailsController = AppServerAlertsDetailsController;
    HawkularMetrics._module.controller('AppServerAlertsDetailsController', AppServerAlertsDetailsController);
})(HawkularMetrics || (HawkularMetrics = {}));

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
/// <reference path="../metricsPlugin.ts"/>
/// <reference path="../services/alertsManager.ts"/>
/// <reference path="../services/errorsManager.ts"/>
var HawkularMetrics;
(function (HawkularMetrics) {
    var DatasourcesAlertSetupController = (function (_super) {
        __extends(DatasourcesAlertSetupController, _super);
        function DatasourcesAlertSetupController() {
            _super.apply(this, arguments);
        }
        DatasourcesAlertSetupController.prototype.loadTriggers = function () {
            var _this = this;
            console.log('this.resourceId', this.resourceId);
            var connTriggerId = this.resourceId + '_ds_conn';
            var connTriggerPromise = this.HawkularAlertsManager.getTrigger(connTriggerId)
                .then(function (triggerData) {
                _this.$log.debug('triggerData', 'conn', triggerData);
                _this.triggerDefinition['conn'] = triggerData;
                _this.adm['conn'] = {};
                _this.adm.conn['email'] = triggerData.trigger.actions.email[0];
                _this.adm.conn['responseDuration'] = triggerData.dampenings[0].evalTimeSetting;
                _this.adm.conn['conditionThreshold'] = triggerData.conditions[0].threshold;
                _this.adm.conn['conditionEnabled'] = triggerData.trigger.enabled;
            });
            var respTriggerId = this.resourceId + '_ds_resp';
            var respTriggerPromise = this.HawkularAlertsManager.getTrigger(respTriggerId)
                .then(function (triggerData) {
                _this.$log.debug('triggerData', 'resp', triggerData);
                _this.triggerDefinition['resp'] = triggerData;
                _this.adm['resp'] = {};
                _this.adm.resp['email'] = triggerData.trigger.actions.email[0];
                _this.adm.resp['responseDuration'] = triggerData.dampenings[0].evalTimeSetting;
                if (triggerData.conditions.length > 0) {
                    var idCreation = 0, idWait = 1;
                    if (triggerData.conditions[0].dataId.indexOf('Creation') === -1) {
                        idCreation = 1;
                        idWait = 0;
                    }
                    if (triggerData.conditions[idWait]) {
                        _this.adm.resp['waitTimeThreshold'] = triggerData.conditions[idWait].threshold;
                        _this.adm.resp['waitTimeEnabled'] = !!triggerData.conditions[idWait].threshold;
                    }
                    if (triggerData.conditions[idCreation]) {
                        _this.adm.resp['creationTimeThreshold'] = triggerData.conditions[idCreation].threshold;
                        _this.adm.resp['creationTimeEnabled'] = !!triggerData.conditions[idCreation].threshold;
                    }
                }
                _this.adm.resp['waitTimeThreshold'] = _this.adm.resp['waitTimeThreshold'] ||
                    HawkularMetrics.AppServerDatasourcesDetailsController.DEFAULT_WAIT_THRESHOLD;
                _this.adm.resp['creationTimeThreshold'] = _this.adm.resp['creationTimeThreshold'] ||
                    HawkularMetrics.AppServerDatasourcesDetailsController.DEFAULT_CREA_THRESHOLD;
            });
            return [connTriggerPromise, respTriggerPromise];
        };
        DatasourcesAlertSetupController.prototype.saveTriggers = function (errorCallback) {
            // Connections part
            var connTrigger = angular.copy(this.triggerDefinition.conn);
            connTrigger.trigger.enabled = this.adm.conn.conditionEnabled;
            if (this.adm.conn.conditionEnabled) {
                connTrigger.trigger.actions.email[0] = this.adm.conn.email;
                connTrigger.dampenings[0].evalTimeSetting = this.adm.conn.responseDuration;
                connTrigger.conditions[0].threshold = this.adm.conn.conditionThreshold;
            }
            var connSavePromise = this.HawkularAlertsManager.updateTrigger(connTrigger, errorCallback, this.triggerDefinition.conn);
            // Responsiveness part
            var respTrigger = angular.copy(this.triggerDefinition.resp);
            respTrigger.trigger.actions.email[0] = this.adm.resp.email;
            respTrigger.dampenings[0].evalTimeSetting = this.adm.resp.responseDuration;
            var respTriggerId = respTrigger.trigger.id;
            // Handle changes in conditions
            var resId = respTriggerId.slice(0, -8);
            var dataId1 = 'MI~R~[' + resId + ']~MT~Datasource Pool Metrics~Average Get Time';
            var dataId2 = 'MI~R~[' + resId + ']~MT~Datasource Pool Metrics~Average Creation Time';
            var respUpdateConditions = [];
            if (this.adm.resp.waitTimeEnabled && !this.adm.resp.creationTimeEnabled) {
                respUpdateConditions = [
                    {
                        triggerId: respTriggerId,
                        type: 'THRESHOLD',
                        dataId: dataId1,
                        threshold: this.adm.resp.waitTimeThreshold,
                        operator: 'GT',
                        context: {
                            description: 'Average Get Time',
                            unit: 'ms'
                        }
                    }
                ];
            }
            else if (!this.adm.resp.waitTimeEnabled && this.adm.resp.creationTimeEnabled) {
                respUpdateConditions = [
                    {
                        triggerId: respTriggerId,
                        type: 'THRESHOLD',
                        dataId: dataId2,
                        threshold: this.adm.resp.creationTimeThreshold,
                        operator: 'GT',
                        context: {
                            description: 'Average Creation Time',
                            unit: 'ms'
                        }
                    }
                ];
            }
            else if (this.adm.resp.waitTimeEnabled && this.adm.resp.creationTimeEnabled) {
                respUpdateConditions = [
                    {
                        triggerId: respTriggerId,
                        type: 'THRESHOLD',
                        dataId: dataId1,
                        threshold: this.adm.resp.waitTimeThreshold,
                        operator: 'GT',
                        context: {
                            description: 'Average Get Time',
                            unit: 'ms'
                        }
                    },
                    {
                        triggerId: respTriggerId,
                        type: 'THRESHOLD',
                        dataId: dataId2,
                        threshold: this.adm.resp.creationTimeThreshold,
                        operator: 'GT',
                        context: {
                            description: 'Average Creation Time',
                            unit: 'ms'
                        }
                    }
                ];
            }
            var respSavePromise = this.HawkularAlertsManager.updateTrigger(respTrigger, errorCallback, this.triggerDefinition.resp);
            console.log('@PROMISES', connSavePromise, respSavePromise);
            return [connSavePromise, respSavePromise];
        };
        return DatasourcesAlertSetupController;
    })(HawkularMetrics.AlertSetupController);
    HawkularMetrics.DatasourcesAlertSetupController = DatasourcesAlertSetupController;
    HawkularMetrics._module.controller('DatasourcesAlertSetupController', DatasourcesAlertSetupController);
})(HawkularMetrics || (HawkularMetrics = {}));

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// <reference path="../metricsPlugin.ts"/>
/// <reference path="../services/alertsManager.ts"/>
/// <reference path="../services/errorsManager.ts"/>
var HawkularMetrics;
(function (HawkularMetrics) {
    var AppServerDatasourcesDetailsController = (function () {
        function AppServerDatasourcesDetailsController($scope, $rootScope, $routeParams, $interval, $q, HawkularInventory, HawkularMetric, HawkularAlertsManager, MetricsService, $log, $modal, startTimeStamp, endTimeStamp) {
            var _this = this;
            this.$scope = $scope;
            this.$rootScope = $rootScope;
            this.$routeParams = $routeParams;
            this.$interval = $interval;
            this.$q = $q;
            this.HawkularInventory = HawkularInventory;
            this.HawkularMetric = HawkularMetric;
            this.HawkularAlertsManager = HawkularAlertsManager;
            this.MetricsService = MetricsService;
            this.$log = $log;
            this.$modal = $modal;
            this.startTimeStamp = startTimeStamp;
            this.endTimeStamp = endTimeStamp;
            // will contain in the format: 'metric name' : true | false
            this.skipChartData = {};
            this.resolvedAvailData = {};
            this.resolvedRespData = {};
            $scope.vm = this;
            this.startTimeStamp = +moment().subtract(($routeParams.timeOffset || 3600000), 'milliseconds');
            this.endTimeStamp = +moment();
            this.chartAvailData = {};
            this.chartRespData = {};
            this.defaultEmail = this.$rootScope.userDetails.email || 'myemail@company.com';
            if ($rootScope.currentPersona) {
                this.getDatasources(this.$rootScope.currentPersona.id);
            }
            else {
                /// currentPersona hasn't been injected to the rootScope yet, wait for it..
                $rootScope.$watch('currentPersona', function (currentPersona) { return currentPersona &&
                    _this.getDatasources(currentPersona.id); });
            }
            this.autoRefresh(20);
        }
        AppServerDatasourcesDetailsController.prototype.getAlerts = function (metricIdPrefix, startTime, endTime, res) {
            var connArray, respArray;
            var connPromise = this.HawkularAlertsManager.queryAlerts({ statuses: 'OPEN',
                triggerIds: metricIdPrefix + '_ds_conn', startTime: startTime, endTime: endTime }).then(function (connData) {
                _.forEach(connData.alertList, function (item) {
                    item['alertType'] = 'DSCONN';
                    item['condition'] = item['dataId'].substr(item['dataId'].lastIndexOf('~') + 1);
                });
                connArray = connData.alertList;
            }, function (error) {
                //return this.ErrorsManager.errorHandler(error, 'Error fetching alerts.');
            });
            var respPromise = this.HawkularAlertsManager.queryAlerts({ statuses: 'OPEN',
                triggerIds: metricIdPrefix + '_ds_resp', startTime: startTime, endTime: endTime }).then(function (respData) {
                _.forEach(respData.alertList, function (item) {
                    item['alertType'] = 'DSRESP';
                    item['condition'] = item['dataId'].substr(item['dataId'].lastIndexOf('~') + 1);
                });
                respArray = respData.alertList;
            }, function (error) {
                //return this.ErrorsManager.errorHandler(error, 'Error fetching alerts.');
            });
            this.$q.all([connPromise, respPromise]).finally(function () {
                res.alertList = [].concat(connArray, respArray);
            });
        };
        AppServerDatasourcesDetailsController.prototype.openSetup = function (resId) {
            // Check if trigger exists on alerts setup modal open. If not, create the trigger before opening the modal
            var _this = this;
            var connTriggerPromise = this.HawkularAlertsManager.existTrigger(resId + '_ds_conn').then(function () {
                // Datasource connection trigger exists, nothing to do
                _this.$log.debug('Datasource connection trigger exists, nothing to do');
            }, function () {
                /// Datasource connection trigger doesn't exist, need to create one
                var triggerId = resId + '_ds_conn';
                var dataId = 'MI~R~[' + resId + ']~MT~Datasource Pool Metrics~Available Count';
                var fullTrigger = {
                    trigger: {
                        name: triggerId,
                        id: triggerId,
                        description: 'Available Count for Datasource ' + resId,
                        actions: { email: [_this.defaultEmail] },
                        context: {
                            resourceType: 'DataSource',
                            resourceName: resId,
                            resourcePath: _this.$rootScope.resourcePath
                        }
                    },
                    dampenings: [
                        {
                            triggerId: triggerId,
                            evalTimeSetting: 7 * 60000,
                            triggerMode: 'FIRING',
                            type: 'STRICT_TIME',
                            context: {
                                description: 'Available Count',
                                unit: 'connections'
                            }
                        }
                    ],
                    conditions: [
                        {
                            triggerId: triggerId,
                            type: 'THRESHOLD',
                            dataId: dataId,
                            threshold: AppServerDatasourcesDetailsController.DEFAULT_CONN_THRESHOLD,
                            operator: 'LT',
                            context: {
                                description: 'Available Count',
                                unit: 'connections'
                            }
                        }
                    ]
                };
                return _this.HawkularAlertsManager.createTrigger(fullTrigger, function () {
                    _this.$log.error('Error on Trigger creation for ' + triggerId);
                });
            });
            var respTriggerPromise = this.HawkularAlertsManager.existTrigger(resId + '_ds_resp').then(function () {
                /// Datasource responsiveness trigger exists, nothing to do
                _this.$log.debug('Datasource responsiveness trigger exists, nothing to do');
            }, function () {
                /// Datasource responsiveness trigger doesn't exist, need to create one
                var triggerId = resId + '_ds_resp';
                var dataId1 = 'MI~R~[' + resId + ']~MT~Datasource Pool Metrics~Average Get Time';
                var dataId2 = 'MI~R~[' + resId + ']~MT~Datasource Pool Metrics~Average Creation Time';
                var fullTrigger = {
                    trigger: {
                        name: triggerId,
                        id: triggerId,
                        firingMatch: 'ANY',
                        actions: { email: [_this.defaultEmail] },
                        context: {
                            resourceType: 'DataSource',
                            resourceName: resId
                        }
                    },
                    dampenings: [
                        {
                            triggerId: triggerId,
                            evalTimeSetting: 7 * 60000,
                            triggerMode: 'FIRING',
                            type: 'STRICT_TIME'
                        }
                    ],
                    conditions: [
                        {
                            triggerId: triggerId,
                            type: 'THRESHOLD',
                            dataId: dataId1,
                            threshold: AppServerDatasourcesDetailsController.DEFAULT_WAIT_THRESHOLD,
                            operator: 'GT',
                            context: {
                                description: 'Average Get Time',
                                unit: 'ms'
                            }
                        },
                        {
                            triggerId: triggerId,
                            type: 'THRESHOLD',
                            dataId: dataId2,
                            threshold: AppServerDatasourcesDetailsController.DEFAULT_CREA_THRESHOLD,
                            operator: 'GT',
                            context: {
                                description: 'Average Creation Time',
                                unit: 'ms'
                            }
                        }
                    ]
                };
                return _this.HawkularAlertsManager.createTrigger(fullTrigger, function () {
                    _this.$log.error('Error on Trigger creation for ' + triggerId);
                });
            });
            var log = this.$log;
            this.$q.all([connTriggerPromise, respTriggerPromise]).then(function () {
                var modalInstance = _this.$modal.open({
                    templateUrl: 'plugins/metrics/html/modals/alerts-ds-setup.html',
                    controller: 'DatasourcesAlertSetupController as das',
                    resolve: {
                        resourceId: function () {
                            return resId;
                        }
                    }
                });
                modalInstance.result.then(angular.noop, function () {
                    log.debug('Datasource Alert Setup modal dismissed at: ' + new Date());
                });
            }, function () {
                _this.$log.error('Missing and unable to create new Datasource Alert triggers.');
            });
        };
        AppServerDatasourcesDetailsController.prototype.showDriverAddDialog = function () {
            /// create a new isolate scope for dialog inherited from current scope instead of default $rootScope
            var driverAddDialog = this.$modal.open({
                templateUrl: 'plugins/metrics/html/app-details/modals/detail-datasources-driver-add.html',
                controller: 'AppServerDatasourcesDriverAddDialogController as dac',
                scope: this.$scope.$new()
            });
            driverAddDialog.result.then(function (modalValue) {
                // handle any returned modalValue if required
            }, function (reason) {
                // handle any returned cancel reason if required
            });
        };
        AppServerDatasourcesDetailsController.prototype.showDatasourceAddDialog = function () {
            /// create a new isolate scope for dialog inherited from current scope instead of default $rootScope
            var datasourceAddDialog = this.$modal.open({
                templateUrl: 'plugins/metrics/html/app-details/modals/detail-datasources-add.html',
                controller: 'AppServerDatasourcesAddDialogController as dac',
                scope: this.$scope.$new()
            });
            datasourceAddDialog.result.then(function (modalValue) {
                // handle any returned modalValue if required
            }, function (reason) {
                // handle any returned cancel reason if required
            });
        };
        AppServerDatasourcesDetailsController.prototype.deleteDatasource = function (datasource) {
            /// create a new isolate scope for dialog inherited from current scope instead of default $rootScope
            var datasourceDeleteDialog = this.$modal.open({
                templateUrl: 'plugins/metrics/html/app-details/modals/detail-datasources-delete.html',
                controller: 'AppServerDatasourcesDeleteDialogController as mvm',
                resolve: {
                    datasource: function () { return datasource; }
                }
            });
            datasourceDeleteDialog.result.then(function (modalValue) {
                // handle any returned modalValue if required
            }, function (reason) {
                // handle any returned cancel reason if required
            });
        };
        AppServerDatasourcesDetailsController.prototype.autoRefresh = function (intervalInSeconds) {
            var _this = this;
            this.autoRefreshPromise = this.$interval(function () {
                _this.getDatasources();
            }, intervalInSeconds * 1000);
            this.$scope.$on('$destroy', function () {
                _this.$interval.cancel(_this.autoRefreshPromise);
            });
        };
        AppServerDatasourcesDetailsController.prototype.getDatasources = function (currentTenantId) {
            var _this = this;
            this.endTimeStamp = this.$routeParams.endTime || +moment();
            this.startTimeStamp = this.endTimeStamp - (this.$routeParams.timeOffset || 3600000);
            var tenantId = currentTenantId || this.$rootScope.currentPersona.id;
            var idParts = this.$routeParams.resourceId.split('~');
            var feedId = idParts[0];
            this.HawkularInventory.ResourceOfTypeUnderFeed.query({
                environmentId: HawkularMetrics.globalEnvironmentId,
                feedId: feedId,
                resourceTypeId: 'Datasource' }, function (aResourceList, getResponseHeaders) {
                var promises = [];
                var tmpResourceList = [];
                angular.forEach(aResourceList, function (res) {
                    if (res.id.startsWith(new RegExp(_this.$routeParams.resourceId + '~/'))) {
                        tmpResourceList.push(res);
                        promises.push(_this.HawkularMetric.GaugeMetricData(tenantId).queryMetrics({
                            gaugeId: 'MI~R~[' + res.id + ']~MT~Datasource Pool Metrics~Available Count',
                            distinct: true }, function (data) {
                            res.availableCount = data[0];
                        }).$promise);
                        promises.push(_this.HawkularMetric.GaugeMetricData(tenantId).queryMetrics({
                            gaugeId: 'MI~R~[' + res.id + ']~MT~Datasource Pool Metrics~In Use Count',
                            distinct: true }, function (data) {
                            res.inUseCount = data[0];
                        }).$promise);
                        _this.getAlerts(res.id, _this.startTimeStamp, _this.endTimeStamp, res);
                    }
                }, _this);
                _this.$q.all(promises).then(function () {
                    _this.resourceList = tmpResourceList;
                    _this.resourceList.$resolved = true;
                    _this.getDatasourceChartData();
                });
            }, function () {
                if (!_this.resourceList) {
                    _this.resourceList = [];
                    _this.resourceList.$resolved = true;
                    _this['lastUpdateTimestamp'] = new Date();
                }
            });
        };
        AppServerDatasourcesDetailsController.prototype.getDatasourceChartData = function (currentTenantId) {
            this.endTimeStamp = this.$routeParams.endTime || +moment();
            this.startTimeStamp = this.endTimeStamp - (this.$routeParams.timeOffset || 3600000);
            var tenantId = currentTenantId || this.$rootScope.currentPersona.id;
            var availPromises = [];
            var respPromises = [];
            var tmpChartAvailData = {};
            var tmpChartRespData = {};
            _.forEach(this.resourceList, function (res, idx) {
                var _this = this;
                if (!this.skipChartData[res.id + '_Available Count']) {
                    var dsAvailPromise = this.MetricsService.retrieveGaugeMetrics(this.$rootScope.currentPersona.id, 'MI~R~[' + res.id + ']~MT~Datasource Pool Metrics~Available Count', this.startTimeStamp, this.endTimeStamp, 60);
                    availPromises.push(dsAvailPromise);
                    dsAvailPromise.then(function (data) {
                        tmpChartAvailData[res.id] = tmpChartAvailData[res.id] || [];
                        tmpChartAvailData[res.id][tmpChartAvailData[res.id].length] = {
                            key: 'Available Count',
                            color: AppServerDatasourcesDetailsController.AVAILABLE_COLOR,
                            values: HawkularMetrics.MetricsService.formatBucketedChartOutput(data)
                        };
                    });
                }
                if (!this.skipChartData[res.id + '_In Use Count']) {
                    var dsInUsePromise = this.MetricsService.retrieveGaugeMetrics(this.$rootScope.currentPersona.id, 'MI~R~[' + res.id + ']~MT~Datasource Pool Metrics~In Use Count', this.startTimeStamp, this.endTimeStamp, 60);
                    availPromises.push(dsInUsePromise);
                    dsInUsePromise.then(function (data) {
                        tmpChartAvailData[res.id] = tmpChartAvailData[res.id] || [];
                        tmpChartAvailData[res.id][tmpChartAvailData[res.id].length] = {
                            key: 'In Use',
                            color: AppServerDatasourcesDetailsController.IN_USE_COLOR,
                            values: HawkularMetrics.MetricsService.formatBucketedChartOutput(data)
                        };
                    });
                }
                if (!this.skipChartData[res.id + '_Timed Out']) {
                    var dsTimedPromise = this.MetricsService.retrieveGaugeMetrics(this.$rootScope.currentPersona.id, 'MI~R~[' + res.id + ']~MT~Datasource Pool Metrics~Timed Out', this.startTimeStamp, this.endTimeStamp, 60);
                    availPromises.push(dsTimedPromise);
                    dsTimedPromise.then(function (data) {
                        tmpChartAvailData[res.id] = tmpChartAvailData[res.id] || [];
                        tmpChartAvailData[res.id][tmpChartAvailData[res.id].length] = {
                            key: 'Timed Out',
                            color: AppServerDatasourcesDetailsController.TIMED_OUT_COLOR,
                            values: HawkularMetrics.MetricsService.formatBucketedChartOutput(data)
                        };
                    });
                }
                this.$q.all(availPromises).finally(function () {
                    _this.chartAvailData[res.id] = tmpChartAvailData[res.id] || [];
                    _this.resolvedAvailData[res.id] = true;
                });
                if (!this.skipChartData[res.id + '_Average Get Time']) {
                    var dsWTimePromise = this.MetricsService.retrieveGaugeMetrics(this.$rootScope.currentPersona.id, 'MI~R~[' + res.id + ']~MT~Datasource Pool Metrics~Average Get Time', this.startTimeStamp, this.endTimeStamp, 60);
                    respPromises.push(dsWTimePromise);
                    dsWTimePromise.then(function (data) {
                        tmpChartRespData[res.id] = tmpChartRespData[res.id] || [];
                        tmpChartRespData[res.id][tmpChartRespData[res.id].length] = {
                            key: 'Wait Time (Avg.)',
                            color: AppServerDatasourcesDetailsController.WAIT_COLOR,
                            values: HawkularMetrics.MetricsService.formatBucketedChartOutput(data)
                        };
                    });
                }
                if (!this.skipChartData[res.id + '_Average Creation Time']) {
                    var dsCTimePromise = this.MetricsService.retrieveGaugeMetrics(this.$rootScope.currentPersona.id, 'MI~R~[' + res.id + ']~MT~Datasource Pool Metrics~Average Creation Time', this.startTimeStamp, this.endTimeStamp, 60);
                    respPromises.push(dsCTimePromise);
                    dsCTimePromise.then(function (data) {
                        tmpChartRespData[res.id] = tmpChartRespData[res.id] || [];
                        tmpChartRespData[res.id][tmpChartRespData[res.id].length] = {
                            key: 'Creation Time (Avg.)',
                            color: AppServerDatasourcesDetailsController.CREATION_COLOR,
                            values: HawkularMetrics.MetricsService.formatBucketedChartOutput(data)
                        };
                    });
                }
                this.$q.all(respPromises).finally(function () {
                    _this.chartRespData[res.id] = tmpChartRespData[res.id] || [];
                    _this.resolvedRespData[res.id] = true;
                });
            }, this);
        };
        AppServerDatasourcesDetailsController.prototype.toggleChartData = function (name) {
            this.skipChartData[name] = !this.skipChartData[name];
            this.getDatasourceChartData();
        };
        /// for minification only
        AppServerDatasourcesDetailsController.$inject = ['$scope', '$rootScope', '$routeParams', '$interval', '$q', 'HawkularInventory',
            'HawkularMetric', 'HawkularAlertsManager', 'MetricsService', '$log', '$modal'];
        AppServerDatasourcesDetailsController.AVAILABLE_COLOR = '#1884c7'; /// blue
        AppServerDatasourcesDetailsController.IN_USE_COLOR = '#49a547'; /// green
        AppServerDatasourcesDetailsController.TIMED_OUT_COLOR = '#515252'; /// dark gray
        AppServerDatasourcesDetailsController.WAIT_COLOR = '#d5d026'; /// yellow
        AppServerDatasourcesDetailsController.CREATION_COLOR = '#95489c'; /// purple
        AppServerDatasourcesDetailsController.DEFAULT_CONN_THRESHOLD = 200; // < 200 # connections available
        AppServerDatasourcesDetailsController.DEFAULT_WAIT_THRESHOLD = 200; // > 200 ms average wait time
        AppServerDatasourcesDetailsController.DEFAULT_CREA_THRESHOLD = 200; // > 200 ms average creatiion time
        return AppServerDatasourcesDetailsController;
    })();
    HawkularMetrics.AppServerDatasourcesDetailsController = AppServerDatasourcesDetailsController;
    HawkularMetrics._module.controller('AppServerDatasourcesDetailsController', AppServerDatasourcesDetailsController);
})(HawkularMetrics || (HawkularMetrics = {}));

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// <reference path="../metricsPlugin.ts"/>
/// <reference path="../services/alertsManager.ts"/>
/// <reference path="../services/errorsManager.ts"/>
var HawkularMetrics;
(function (HawkularMetrics) {
    var AppServerDeploymentsDetailsController = (function () {
        function AppServerDeploymentsDetailsController($scope, $rootScope, $interval, $log, $routeParams, $filter, $modal, HawkularInventory, HawkularMetric, HawkularOps, HawkularAlertsManager, ErrorsManager, $q, NotificationsService) {
            var _this = this;
            this.$scope = $scope;
            this.$rootScope = $rootScope;
            this.$interval = $interval;
            this.$log = $log;
            this.$routeParams = $routeParams;
            this.$filter = $filter;
            this.$modal = $modal;
            this.HawkularInventory = HawkularInventory;
            this.HawkularMetric = HawkularMetric;
            this.HawkularOps = HawkularOps;
            this.HawkularAlertsManager = HawkularAlertsManager;
            this.ErrorsManager = ErrorsManager;
            this.$q = $q;
            this.NotificationsService = NotificationsService;
            this.selectCount = 0;
            $scope.vm = this;
            HawkularOps.init(this.NotificationsService);
            this.startTimeStamp = +moment().subtract(1, 'hours');
            this.endTimeStamp = +moment();
            if ($rootScope.currentPersona) {
                this.getResourceList(this.$rootScope.currentPersona.id);
            }
            else {
                // currentPersona hasn't been injected to the rootScope yet, wait for it..
                $rootScope.$watch('currentPersona', function (currentPersona) { return currentPersona &&
                    _this.getResourceList(currentPersona.id); });
            }
            this.autoRefresh(20);
        }
        AppServerDeploymentsDetailsController.prototype.autoRefresh = function (intervalInSeconds) {
            var _this = this;
            this.autoRefreshPromise = this.$interval(function () {
                _this.getResourceList();
            }, intervalInSeconds * 1000);
            this.$scope.$on('$destroy', function () {
                _this.$interval.cancel(_this.autoRefreshPromise);
            });
        };
        AppServerDeploymentsDetailsController.prototype.showDeploymentAddDialog = function () {
            this.$log.debug('Starting Show Add Dialog');
            /// create a new isolate scope for dialog inherited from current scope instead of default $rootScope
            var deployAddDialog = this.$modal.open({
                templateUrl: 'plugins/metrics/html/app-details/modals/detail-deployments-add.html',
                controller: 'AppServerDeploymentsAddDialogController as dac',
                scope: this.$scope.$new()
            });
            var logger = this.$log;
            deployAddDialog.result.then(function (modalValue) {
                logger.debug('Modal Closed: ' + modalValue);
            }, function (reason) {
                logger.debug('Modal cancelled at: ' + new Date());
            });
        };
        AppServerDeploymentsDetailsController.prototype.getResourceList = function (currentTenantId) {
            var _this = this;
            this.alertList = []; // FIXME: when we have alerts for app server
            var tenantId = currentTenantId || this.$rootScope.currentPersona.id;
            var idParts = this.$routeParams.resourceId.split('~');
            var feedId = idParts[0];
            this.HawkularInventory.ResourceOfTypeUnderFeed.query({
                environmentId: HawkularMetrics.globalEnvironmentId,
                feedId: feedId,
                resourceTypeId: 'Deployment'
            }, function (aResourceList, getResponseHeaders) {
                var promises = [];
                var tmpResourceList = [];
                _.forEach(aResourceList, function (res) {
                    if (res.id.startsWith(new RegExp(_this.$routeParams.resourceId + '~/'))) {
                        tmpResourceList.push(res);
                        res.selected = _.result(_.find(_this.resourceList, { 'id': res.id }), 'selected');
                        promises.push(_this.HawkularMetric.AvailabilityMetricData(_this.$rootScope.currentPersona.id).query({
                            tenantId: tenantId,
                            availabilityId: 'AI~R~[' + res.id + ']~AT~Deployment Status~Deployment Status',
                            distinct: true
                        }, function (availResource) {
                            var latestData = _.last(availResource);
                            if (latestData) {
                                res.state = latestData.value;
                                res.updateTimestamp = latestData.timestamp;
                            }
                        }).$promise);
                    }
                    _this.lastUpdateTimestamp = new Date();
                }, _this);
                _this.$q.all(promises).then(function (notUsed) {
                    _this.resourceList = tmpResourceList;
                    _this.resourceList.$resolved = true;
                });
            }, function () {
                if (!_this.resourceList) {
                    _this.resourceList = [];
                    _this.resourceList.$resolved = true;
                    _this.lastUpdateTimestamp = new Date();
                }
            });
        };
        AppServerDeploymentsDetailsController.prototype.performOperationMulti = function (operationName) {
            var _this = this;
            var selectedList = _.filter(this.resourceList, 'selected');
            this.$log.log("performOperationMulti for operation: " + operationName);
            _.forEach(selectedList, function (item) {
                var operation = {
                    operationName: operationName,
                    resourcePath: item.path,
                    authentication: {
                        token: _this.$rootScope.userDetails.token,
                        persona: _this.$rootScope.currentPersona.id
                    }
                };
                _this.HawkularOps.performOperation(operation);
            });
        };
        AppServerDeploymentsDetailsController.prototype.selectItem = function (item) {
            item.selected = !item.selected;
            this.selectCount = _.filter(this.resourceList, 'selected').length;
        };
        AppServerDeploymentsDetailsController.prototype.selectAll = function () {
            var filteredList = this.$filter('filter')(this.resourceList, this.search);
            var toggleTo = this.selectCount !== filteredList.length;
            _.forEach(filteredList, function (item) {
                item.selected = toggleTo;
            });
            this.selectCount = toggleTo ? filteredList.length : 0;
        };
        /// this is for minification purposes
        AppServerDeploymentsDetailsController.$inject = ['$scope', '$rootScope', '$interval', '$log', '$routeParams', '$filter',
            '$modal', 'HawkularInventory', 'HawkularMetric', 'HawkularOps', 'HawkularAlertsManager',
            'ErrorsManager', '$q', 'NotificationsService'];
        return AppServerDeploymentsDetailsController;
    })();
    HawkularMetrics.AppServerDeploymentsDetailsController = AppServerDeploymentsDetailsController;
    HawkularMetrics._module.controller('AppServerDeploymentsDetailsController', AppServerDeploymentsDetailsController);
})(HawkularMetrics || (HawkularMetrics = {}));

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// <reference path="../metricsPlugin.ts"/>
/// <reference path="../services/alertsManager.ts"/>
/// <reference path="../services/errorsManager.ts"/>
var HawkularMetrics;
(function (HawkularMetrics) {
    var AppServerJmsDetailsController = (function () {
        function AppServerJmsDetailsController() {
        }
        return AppServerJmsDetailsController;
    })();
    HawkularMetrics.AppServerJmsDetailsController = AppServerJmsDetailsController;
    HawkularMetrics._module.controller('AppServerJmsDetailsController', AppServerJmsDetailsController);
})(HawkularMetrics || (HawkularMetrics = {}));

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
/// <reference path="../metricsPlugin.ts"/>
/// <reference path="../../includes.ts"/>
/// <reference path="../services/alertsManager.ts"/>
/// <reference path="../services/errorsManager.ts"/>
var HawkularMetrics;
(function (HawkularMetrics) {
    var JvmAlertController = (function () {
        function JvmAlertController($scope, HawkularAlertsManager, ErrorsManager, NotificationsService, $log, $q, $rootScope, $routeParams, $modal, $interval, HkHeaderParser) {
            this.$scope = $scope;
            this.HawkularAlertsManager = HawkularAlertsManager;
            this.ErrorsManager = ErrorsManager;
            this.NotificationsService = NotificationsService;
            this.$log = $log;
            this.$q = $q;
            this.$rootScope = $rootScope;
            this.$routeParams = $routeParams;
            this.$modal = $modal;
            this.$interval = $interval;
            this.HkHeaderParser = HkHeaderParser;
            this.alertList = [];
            this.isResolvingAll = false;
            this.resCurPage = 0;
            this.resPerPage = 5;
            this.resourceId = $routeParams.resourceId;
            this.alertsTimeOffset = $routeParams.timeOffset || 3600000;
            // If the end time is not specified in URL use current time as end time
            this.alertsTimeEnd = $routeParams.endTime ? $routeParams.endTime : (new Date()).getTime();
            this.alertsTimeStart = this.alertsTimeEnd - this.alertsTimeOffset;
            this.defaultEmail = this.$rootScope.userDetails.email || 'myemail@company.com';
            this.getAlerts();
            this.autoRefresh(20);
        }
        JvmAlertController.prototype.openSetup = function () {
            // Check if trigger exists on alerts setup modal open. If not, create the trigger before opening the modal
            var _this = this;
            var defaultEmail = this.$rootScope.userDetails.email || 'myemail@company.com';
            var defaultEmailPromise = this.HawkularAlertsManager.addEmailAction(defaultEmail);
            var heapTriggerPromise = this.HawkularAlertsManager.existTrigger(this.resourceId + '_jvm_pheap').then(function () {
                // Jvm trigger exists, nothing to do
                _this.$log.debug('Jvm trigger exists, nothing to do');
            }, function () {
                // Jvm trigger doesn't exist, need to create one
                var low = HawkularMetrics.AppServerJvmDetailsController.MAX_HEAP * 0.2;
                var high = HawkularMetrics.AppServerJvmDetailsController.MAX_HEAP * 0.8;
                var triggerId = _this.resourceId + '_jvm_pheap';
                var resourceId = triggerId.slice(0, -10);
                var dataId = 'MI~R~[' + resourceId + '~~]~MT~WildFly Memory Metrics~Heap Used';
                var fullTrigger = {
                    trigger: {
                        name: 'JVM Heap Used',
                        id: triggerId,
                        description: 'JVM Heap Used for ' + resourceId,
                        autoDisable: true,
                        autoEnable: true,
                        autoResolve: false,
                        severity: 'MEDIUM',
                        actions: { email: [_this.defaultEmail] },
                        context: {
                            description: 'JVM Heap Used for ' + resourceId,
                            resourceType: 'App Server',
                            resourceName: resourceId,
                            resourcePath: _this.$rootScope.resourcePath
                        }
                    },
                    dampenings: [
                        {
                            triggerId: triggerId,
                            evalTimeSetting: 7 * 60000,
                            triggerMode: 'FIRING',
                            type: 'STRICT_TIME'
                        }
                    ],
                    conditions: [
                        {
                            triggerId: triggerId,
                            type: 'RANGE',
                            dataId: dataId,
                            operatorLow: 'INCLUSIVE',
                            operatorHigh: 'INCLUSIVE',
                            thresholdLow: low || 20.0,
                            thresholdHigh: high || 80.0,
                            inRange: false,
                            context: {
                                description: 'Heap Used',
                                unit: 'B'
                            }
                        }
                    ]
                };
                return _this.HawkularAlertsManager.createTrigger(fullTrigger, function () {
                    _this.$log.error('Error on Trigger creation for ' + triggerId);
                });
            });
            var nonHeapTriggerPromise = this.HawkularAlertsManager.existTrigger(this.resourceId + '_jvm_nheap').then(function () {
                // Jvm trigger exists, nothing to do
                _this.$log.debug('Jvm trigger exists, nothing to do');
            }, function () {
                // Jvm trigger doesn't exist, need to create one
                var low = HawkularMetrics.AppServerJvmDetailsController.MAX_HEAP * 0.2;
                var high = HawkularMetrics.AppServerJvmDetailsController.MAX_HEAP * 0.8;
                var triggerId = _this.resourceId + '_jvm_nheap';
                var resourceId = triggerId.slice(0, -10);
                var dataId = 'MI~R~[' + resourceId + '~~]~MT~WildFly Memory Metrics~NonHeap Used';
                var fullTrigger = {
                    trigger: {
                        name: 'JVM Non Heap Used',
                        id: triggerId,
                        description: 'JVM Non Heap Used for ' + resourceId,
                        autoDisable: true,
                        autoEnable: true,
                        autoResolve: false,
                        severity: 'HIGH',
                        actions: { email: [_this.defaultEmail] },
                        context: {
                            description: 'JVM Non Heap Used for ' + resourceId,
                            resourceType: 'App Server',
                            resourceName: resourceId,
                            resourcePath: _this.$rootScope.resourcePath
                        }
                    },
                    dampenings: [
                        {
                            triggerId: triggerId,
                            evalTimeSetting: 7 * 60000,
                            triggerMode: 'FIRING',
                            type: 'STRICT_TIME'
                        }
                    ],
                    conditions: [
                        {
                            triggerId: triggerId,
                            type: 'RANGE',
                            dataId: dataId,
                            operatorLow: 'INCLUSIVE',
                            operatorHigh: 'INCLUSIVE',
                            thresholdLow: low || 20.0,
                            thresholdHigh: high || 80.0,
                            inRange: false,
                            context: {
                                description: 'Non Heap Used',
                                unit: 'B'
                            }
                        }
                    ]
                };
                return _this.HawkularAlertsManager.createTrigger(fullTrigger, function () {
                    _this.$log.error('Error on Trigger creation for ' + triggerId);
                });
            });
            var garbageTriggerPromise = this.HawkularAlertsManager.existTrigger(this.resourceId + '_jvm_garba').then(function () {
                // Jvm trigger exists, nothing to do
                _this.$log.debug('Jvm trigger exists, nothing to do');
            }, function () {
                // Jvm trigger doesn't exist, need to create one
                var triggerId = _this.resourceId + '_jvm_garba';
                var resourceId = triggerId.slice(0, -10);
                var dataId = 'MI~R~[' + resourceId + '~~]~MT~WildFly Memory Metrics~Accumulated GC Duration';
                var fullTrigger = {
                    trigger: {
                        name: 'Accumulated GC Duration',
                        id: triggerId,
                        description: 'Accumulated GC Duration for ' + resourceId,
                        autoDisable: true,
                        autoEnable: true,
                        autoResolve: false,
                        severity: 'HIGH',
                        actions: { email: [_this.defaultEmail] },
                        context: {
                            description: 'Accumulated GC Duration for ' + resourceId,
                            resourceType: 'App Server',
                            resourceName: resourceId,
                            resourcePath: _this.$rootScope.resourcePath
                        }
                    },
                    dampenings: [
                        {
                            triggerId: triggerId,
                            evalTimeSetting: 7 * 60000,
                            triggerMode: 'FIRING',
                            type: 'STRICT_TIME'
                        }
                    ],
                    conditions: [
                        {
                            triggerId: triggerId,
                            type: 'THRESHOLD',
                            dataId: dataId,
                            threshold: 200,
                            operator: 'GT',
                            context: {
                                description: 'GC Duration',
                                unit: 'ms'
                            }
                        }
                    ]
                };
                return _this.HawkularAlertsManager.createTrigger(fullTrigger, function () {
                    _this.$log.error('Error on Trigger creation for ' + triggerId);
                });
            });
            var log = this.$log;
            this.$q.all([defaultEmailPromise, heapTriggerPromise, nonHeapTriggerPromise, garbageTriggerPromise]).then(function () {
                var modalInstance = _this.$modal.open({
                    templateUrl: 'plugins/metrics/html/modals/alerts-jvm-setup.html',
                    controller: 'JvmAlertSetupController as jas',
                    resolve: {
                        resourceId: function () {
                            return _this.resourceId;
                        }
                    }
                });
                modalInstance.result.then(angular.noop, function () {
                    log.info('Jvm Alert Setup modal dismissed at: ' + new Date());
                });
            }, function () {
                _this.$log.error('Missing and unable to create new JVM Alert triggers.');
            });
        };
        JvmAlertController.prototype.autoRefresh = function (intervalInSeconds) {
            var _this = this;
            var autoRefreshPromise = this.$interval(function () {
                _this.getAlerts();
            }, intervalInSeconds * 1000);
            this.$scope.$on('$destroy', function () {
                _this.$interval.cancel(autoRefreshPromise);
            });
        };
        JvmAlertController.prototype.getAlerts = function () {
            /* FIXME: This is done in appServerJvmDetails
             this.alertsTimeEnd = this.$routeParams.endTime ? this.$routeParams.endTime : (new Date()).getTime();
             this.alertsTimeStart = this.alertsTimeEnd - this.alertsTimeOffset;
      
             this.HawkularAlertsManager.queryConsoleAlerts(this.resourceId, this.alertsTimeStart, this.alertsTimeEnd,
             undefined, this.resCurPage, this.resPerPage).then((queriedAlerts)=> {
             this.headerLinks = this.HkHeaderParser.parse(queriedAlerts.headers);
             this.alertList = queriedAlerts.alertList;
             this.alertList.$resolved = true; // FIXME
             }, (error) => { return this.ErrorsManager.errorHandler(error, 'Error fetching alerts.'); });
             */
        };
        JvmAlertController.prototype.setPage = function (page) {
            this.resCurPage = page;
            this.getAlerts();
        };
        JvmAlertController.prototype.resolveAll = function () {
            var _this = this;
            this.isResolvingAll = true;
            var alertIdList = '';
            for (var i = 0; i < this.alertList.length; i++) {
                alertIdList = alertIdList + this.alertList[i].id + ',';
            }
            alertIdList = alertIdList.slice(0, -1);
            var resolvedAlerts = {
                alertIds: alertIdList,
                resolvedBy: this.$rootScope.currentPersona.name,
                resolvedNotes: 'Manually resolved'
            };
            this.HawkularAlertsManager.resolveAlerts(resolvedAlerts).then(function () {
                _this.alertList.length = 0;
                _this.isResolvingAll = false;
            });
        };
        JvmAlertController.$inject = ['$scope', 'HawkularAlertsManager', 'ErrorsManager', 'NotificationsService',
            '$log', '$q', '$rootScope', '$routeParams', '$modal', '$interval', 'HkHeaderParser'];
        return JvmAlertController;
    })();
    HawkularMetrics.JvmAlertController = JvmAlertController;
    HawkularMetrics._module.controller('JvmAlertController', JvmAlertController);
    var JvmAlertSetupController = (function (_super) {
        __extends(JvmAlertSetupController, _super);
        function JvmAlertSetupController() {
            _super.apply(this, arguments);
            // TODO - Get the actual data from backend
            this.maxUsage = HawkularMetrics.AppServerJvmDetailsController.MAX_HEAP;
        }
        JvmAlertSetupController.prototype.loadTriggers = function () {
            var _this = this;
            function floor2Dec(doubleValue) {
                return Math.floor(doubleValue * 100) / 100;
            }
            this.maxUsage = HawkularMetrics.AppServerJvmDetailsController.MAX_HEAP;
            var heapTriggerId = this.$routeParams.resourceId + '_jvm_pheap';
            var heapTriggerPromise = this.HawkularAlertsManager.getTrigger(heapTriggerId).then(function (triggerData) {
                _this.triggerDefinition['heap'] = triggerData;
                _this.adm.heap = {};
                _this.adm.heap['email'] = triggerData.trigger.actions.email[0];
                _this.adm.heap['responseDuration'] = triggerData.dampenings[0].evalTimeSetting;
                _this.adm.heap['conditionGtEnabled'] = triggerData.conditions[0].thresholdHigh < _this.maxUsage;
                _this.adm.heap['conditionGtPercent'] = triggerData.conditions[0].thresholdHigh > 0 ?
                    floor2Dec(triggerData.conditions[0].thresholdHigh * 100 / _this.maxUsage) : 0;
                _this.adm.heap['conditionLtEnabled'] = triggerData.conditions[0].thresholdLow > 0;
                _this.adm.heap['conditionLtPercent'] = triggerData.conditions[0].thresholdLow > 0 ?
                    floor2Dec(triggerData.conditions[0].thresholdLow * 100 / _this.maxUsage) : 0;
            });
            // Non-Heap Usage trigger definition
            var nheapTriggerId = this.$routeParams.resourceId + '_jvm_nheap';
            var nheapTriggerPromise = this.HawkularAlertsManager.getTrigger(nheapTriggerId).then(function (triggerData) {
                _this.triggerDefinition['nheap'] = triggerData;
                _this.adm.nheap = {};
                _this.adm.nheap['email'] = triggerData.trigger.actions.email[0];
                _this.adm.nheap['responseDuration'] = triggerData.dampenings[0].evalTimeSetting;
                _this.adm.nheap['conditionGtEnabled'] = triggerData.conditions[0].thresholdHigh < _this.maxUsage;
                _this.adm.nheap['conditionGtPercent'] = triggerData.conditions[0].thresholdHigh > 0 ?
                    floor2Dec(triggerData.conditions[0].thresholdHigh * 100 / _this.maxUsage) : 0;
                _this.adm.nheap['conditionLtEnabled'] = triggerData.conditions[0].thresholdLow > 0;
                _this.adm.nheap['conditionLtPercent'] = triggerData.conditions[0].thresholdLow > 0 ?
                    floor2Dec(triggerData.conditions[0].thresholdLow * 100 / _this.maxUsage) : 0;
            });
            // Garbage Collection trigger definition
            var garbaTriggerId = this.$routeParams.resourceId + '_jvm_garba';
            var garbaTriggerPromise = this.HawkularAlertsManager.getTrigger(garbaTriggerId).then(function (triggerData) {
                _this.triggerDefinition['garba'] = triggerData;
                _this.adm.garba = {};
                _this.adm.garba['email'] = triggerData.trigger.actions.email[0];
                _this.adm.garba['responseDuration'] = triggerData.dampenings[0].evalTimeSetting;
                _this.adm.garba['conditionEnabled'] = triggerData.trigger.enabled;
                _this.adm.garba['conditionThreshold'] = triggerData.conditions[0].threshold;
            });
            return [heapTriggerPromise, nheapTriggerPromise, garbaTriggerPromise];
        };
        JvmAlertSetupController.prototype.saveTriggers = function (errorCallback) {
            // Heap
            var heapTrigger = angular.copy(this.triggerDefinition.heap);
            heapTrigger.trigger.actions.email[0] = this.adm.heap.email;
            heapTrigger.dampenings[0].evalTimeSetting = this.adm.heap.responseDuration;
            heapTrigger.conditions[0].thresholdHigh = this.adm.heap.conditionGtEnabled ?
                this.maxUsage * this.adm.heap.conditionGtPercent / 100 : this.maxUsage;
            heapTrigger.conditions[0].thresholdLow = this.adm.heap.conditionLtEnabled ?
                this.maxUsage * this.adm.heap.conditionLtPercent / 100 : 0;
            var heapSavePromise = this.HawkularAlertsManager.updateTrigger(heapTrigger, errorCallback, this.triggerDefinition.heap);
            // Non Heap
            var nheapTrigger = angular.copy(this.triggerDefinition.nheap);
            nheapTrigger.trigger.actions.email[0] = this.adm.nheap.email;
            nheapTrigger.dampenings[0].evalTimeSetting = this.adm.nheap.responseDuration;
            nheapTrigger.conditions[0].thresholdHigh = this.adm.nheap.conditionGtEnabled ?
                this.maxUsage * this.adm.nheap.conditionGtPercent / 100 : this.maxUsage;
            nheapTrigger.conditions[0].thresholdLow = this.adm.nheap.conditionLtEnabled ?
                this.maxUsage * this.adm.nheap.conditionLtPercent / 100 : 0;
            var nheapSavePromise = this.HawkularAlertsManager.updateTrigger(nheapTrigger, errorCallback, this.triggerDefinition.nheap);
            // Garbage Collection
            var garbaTrigger = angular.copy(this.triggerDefinition.garba);
            garbaTrigger.trigger.enabled = this.adm.garba.conditionEnabled;
            if (this.adm.garba.conditionEnabled) {
                garbaTrigger.trigger.actions.email[0] = this.adm.garba.email;
                garbaTrigger.dampenings[0].evalTimeSetting = this.adm.garba.responseDuration;
                garbaTrigger.conditions[0].threshold = this.adm.garba.conditionEnabled ?
                    this.adm.garba.conditionThreshold : 0;
            }
            var garbaSavePromise = this.HawkularAlertsManager.updateTrigger(garbaTrigger, errorCallback, this.triggerDefinition.garba);
            return [heapSavePromise, nheapSavePromise, garbaSavePromise];
        };
        return JvmAlertSetupController;
    })(HawkularMetrics.AlertSetupController);
    HawkularMetrics.JvmAlertSetupController = JvmAlertSetupController;
    HawkularMetrics._module.controller('JvmAlertSetupController', JvmAlertSetupController);
})(HawkularMetrics || (HawkularMetrics = {}));

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// <reference path="../metricsPlugin.ts"/>
/// <reference path="../services/alertsManager.ts"/>
/// <reference path="../services/errorsManager.ts"/>
var HawkularMetrics;
(function (HawkularMetrics) {
    var AppServerJvmDetailsController = (function () {
        function AppServerJvmDetailsController($location, $scope, $rootScope, $interval, $log, $filter, $routeParams, $modal, $window, HawkularInventory, HawkularMetric, HawkularAlertsManager, MetricsService, ErrorsManager, $q, md5) {
            var _this = this;
            this.$location = $location;
            this.$scope = $scope;
            this.$rootScope = $rootScope;
            this.$interval = $interval;
            this.$log = $log;
            this.$filter = $filter;
            this.$routeParams = $routeParams;
            this.$modal = $modal;
            this.$window = $window;
            this.HawkularInventory = HawkularInventory;
            this.HawkularMetric = HawkularMetric;
            this.HawkularAlertsManager = HawkularAlertsManager;
            this.MetricsService = MetricsService;
            this.ErrorsManager = ErrorsManager;
            this.$q = $q;
            this.md5 = md5;
            this.math = this.$window.Math;
            // will contain in the format: 'metric name' : true | false
            this.skipChartData = {};
            $scope.vm = this;
            this.startTimeStamp = +moment().subtract(($routeParams.timeOffset || 3600000), 'milliseconds');
            this.endTimeStamp = +moment();
            this.chartHeapData = [];
            this.chartNonHeapData = [];
            if ($rootScope.currentPersona) {
                this.getJvmData();
            }
            else {
                // currentPersona hasn't been injected to the rootScope yet, wait for it..
                $rootScope.$watch('currentPersona', function (currentPersona) { return currentPersona && _this.getJvmData(); });
            }
            this.getAlerts(this.$routeParams.resourceId, this.startTimeStamp, this.endTimeStamp);
            this.autoRefresh(20);
        }
        AppServerJvmDetailsController.prototype.getAlerts = function (metricIdPrefix, startTime, endTime) {
            var _this = this;
            var pheapArray, nheapArray, garbaArray;
            var pheapPromise = this.HawkularAlertsManager.queryAlerts({ statuses: 'OPEN',
                triggerIds: metricIdPrefix + '_jvm_pheap', startTime: startTime, endTime: endTime }).then(function (pheapData) {
                _.forEach(pheapData.alertList, function (item) {
                    item['alertType'] = 'PHEAP';
                });
                pheapArray = pheapData.alertList;
            }, function (error) {
                return _this.ErrorsManager.errorHandler(error, 'Error fetching alerts.');
            });
            var nheapPromise = this.HawkularAlertsManager.queryAlerts({ statuses: 'OPEN',
                triggerIds: metricIdPrefix + '_jvm_nheap', startTime: startTime, endTime: endTime }).then(function (nheapData) {
                _.forEach(nheapData.alertList, function (item) {
                    item['alertType'] = 'NHEAP';
                });
                nheapArray = nheapData.alertList;
            }, function (error) {
                return _this.ErrorsManager.errorHandler(error, 'Error fetching alerts.');
            });
            var garbaPromise = this.HawkularAlertsManager.queryAlerts({ statuses: 'OPEN',
                triggerIds: metricIdPrefix + '_jvm_garba', startTime: startTime, endTime: endTime }).then(function (garbaData) {
                _.forEach(garbaData.alertList, function (item) {
                    item['alertType'] = 'GARBA';
                });
                garbaArray = garbaData.alertList;
            }, function (error) {
                return _this.ErrorsManager.errorHandler(error, 'Error fetching alerts.');
            });
            this.$q.all([pheapPromise, nheapPromise, garbaPromise]).finally(function () {
                _this.alertList = [].concat(pheapArray, nheapArray, garbaArray);
            });
        };
        AppServerJvmDetailsController.prototype.autoRefresh = function (intervalInSeconds) {
            var _this = this;
            this.autoRefreshPromise = this.$interval(function () {
                _this.getJvmData();
                _this.getJvmChartData();
                _this.getAlerts(_this.$routeParams.resourceId, _this.startTimeStamp, _this.endTimeStamp);
            }, intervalInSeconds * 1000);
            this.$scope.$on('$destroy', function () {
                _this.$interval.cancel(_this.autoRefreshPromise);
            });
        };
        AppServerJvmDetailsController.prototype.getJvmData = function () {
            var _this = this;
            this.endTimeStamp = this.$routeParams.endTime || +moment();
            this.startTimeStamp = this.endTimeStamp - (this.$routeParams.timeOffset || 3600000);
            this.MetricsService.retrieveGaugeMetrics(this.$rootScope.currentPersona.id, 'MI~R~[' + this.$routeParams.resourceId + '~~]~MT~WildFly Memory Metrics~Heap Used', this.startTimeStamp, this.endTimeStamp, 1).then(function (resource) {
                if (resource.length) {
                    _this['heapUsage'] = resource[0];
                }
            });
            this.MetricsService.retrieveGaugeMetrics(this.$rootScope.currentPersona.id, 'MI~R~[' + this.$routeParams.resourceId + '~~]~MT~WildFly Memory Metrics~Heap Max', this.startTimeStamp, this.endTimeStamp, 1).then(function (resource) {
                if (resource.length) {
                    _this['heapMax'] = resource[0];
                    AppServerJvmDetailsController.MAX_HEAP = resource[0].max;
                }
            });
            this.MetricsService.retrieveCounterMetrics(this.$rootScope.currentPersona.id, 'MI~R~[' + this.$routeParams.resourceId + '~~]~MT~WildFly Memory Metrics~Accumulated GC Duration', this.startTimeStamp, this.endTimeStamp, 1).then(function (resource) {
                if (resource.length) {
                    _this['accGCDuration'] = (resource[0].max - resource[0].min);
                }
            });
            this.getJvmChartData();
        };
        AppServerJvmDetailsController.prototype.getJvmChartData = function () {
            var _this = this;
            this.endTimeStamp = this.$routeParams.endTime || +moment();
            this.startTimeStamp = this.endTimeStamp - (this.$routeParams.timeOffset || 3600000);
            var tmpChartHeapData = [];
            var heapPromises = [];
            var tmpChartNonHeapData = [];
            var nonHeapPromises = [];
            if (!this.skipChartData['Heap Committed']) {
                var hCommPromise = this.MetricsService.retrieveGaugeMetrics(this.$rootScope.currentPersona.id, 'MI~R~[' + this.$routeParams.resourceId + '~~]~MT~WildFly Memory Metrics~Heap Committed', this.startTimeStamp, this.endTimeStamp, 60);
                heapPromises.push(hCommPromise);
                hCommPromise.then(function (data) {
                    tmpChartHeapData[tmpChartHeapData.length] = {
                        key: 'Heap Committed',
                        color: AppServerJvmDetailsController.COMMITTED_COLOR,
                        values: HawkularMetrics.MetricsService.formatBucketedChartOutput(data, AppServerJvmDetailsController.BYTES2MB)
                    };
                });
            }
            if (!this.skipChartData['Heap Used']) {
                var hUsedPromise = this.MetricsService.retrieveGaugeMetrics(this.$rootScope.currentPersona.id, 'MI~R~[' + this.$routeParams.resourceId + '~~]~MT~WildFly Memory Metrics~Heap Used', this.startTimeStamp, this.endTimeStamp, 60);
                heapPromises.push(hUsedPromise);
                hUsedPromise.then(function (data) {
                    tmpChartHeapData[tmpChartHeapData.length] = {
                        key: 'Heap Used',
                        color: AppServerJvmDetailsController.USED_COLOR,
                        values: HawkularMetrics.MetricsService.formatBucketedChartOutput(data, AppServerJvmDetailsController.BYTES2MB)
                    };
                });
            }
            if (!this.skipChartData['Heap Max']) {
                var hMaxPromise = this.MetricsService.retrieveGaugeMetrics(this.$rootScope.currentPersona.id, 'MI~R~[' + this.$routeParams.resourceId + '~~]~MT~WildFly Memory Metrics~Heap Max', this.startTimeStamp, this.endTimeStamp, 60);
                heapPromises.push(hMaxPromise);
                hMaxPromise.then(function (data) {
                    tmpChartHeapData[tmpChartHeapData.length] = {
                        key: 'Heap Max',
                        color: AppServerJvmDetailsController.MAXIMUM_COLOR,
                        values: HawkularMetrics.MetricsService.formatBucketedChartOutput(data, AppServerJvmDetailsController.BYTES2MB)
                    };
                });
            }
            this.$q.all(heapPromises).finally(function () {
                _this.chartHeapData = tmpChartHeapData;
            });
            if (!this.skipChartData['NonHeap Committed']) {
                var nhCommPromise = this.MetricsService.retrieveGaugeMetrics(this.$rootScope.currentPersona.id, 'MI~R~[' + this.$routeParams.resourceId + '~~]~MT~WildFly Memory Metrics~NonHeap Committed', this.startTimeStamp, this.endTimeStamp, 60);
                nonHeapPromises.push(nhCommPromise);
                nhCommPromise.then(function (data) {
                    tmpChartNonHeapData[tmpChartNonHeapData.length] = {
                        key: 'NonHeap Committed',
                        color: AppServerJvmDetailsController.COMMITTED_COLOR,
                        values: HawkularMetrics.MetricsService.formatBucketedChartOutput(data, AppServerJvmDetailsController.BYTES2MB)
                    };
                });
            }
            if (!this.skipChartData['NonHeap Used']) {
                var nhUsedPromise = this.MetricsService.retrieveGaugeMetrics(this.$rootScope.currentPersona.id, 'MI~R~[' + this.$routeParams.resourceId + '~~]~MT~WildFly Memory Metrics~NonHeap Used', this.startTimeStamp, this.endTimeStamp, 60);
                nonHeapPromises.push(nhUsedPromise);
                nhUsedPromise.then(function (data) {
                    tmpChartNonHeapData[tmpChartNonHeapData.length] = {
                        key: 'NonHeap Used',
                        color: AppServerJvmDetailsController.USED_COLOR,
                        values: HawkularMetrics.MetricsService.formatBucketedChartOutput(data, AppServerJvmDetailsController.BYTES2MB)
                    };
                });
            }
            this.$q.all(nonHeapPromises).finally(function () {
                _this.chartNonHeapData = tmpChartNonHeapData;
            });
            this.MetricsService.retrieveCounterRateMetrics(this.$rootScope.currentPersona.id, 'MI~R~[' + this.$routeParams.resourceId + '~~]~MT~WildFly Memory Metrics~Accumulated GC Duration', this.startTimeStamp, this.endTimeStamp, 60).then(function (resource) {
                if (resource.length) {
                    _this.chartGCDurationData = HawkularMetrics.MetricsService.formatBucketedChartOutput(resource);
                }
            });
        };
        AppServerJvmDetailsController.prototype.toggleChartData = function (name) {
            this.skipChartData[name] = !this.skipChartData[name];
            this.getJvmChartData();
        };
        /// this is for minification purposes
        AppServerJvmDetailsController.$inject = ['$location', '$scope', '$rootScope', '$interval', '$log', '$filter', '$routeParams',
            '$modal', '$window', 'HawkularInventory', 'HawkularMetric', 'HawkularAlertsManager', 'MetricsService',
            'ErrorsManager', '$q', 'md5'];
        AppServerJvmDetailsController.USED_COLOR = '#1884c7'; /// blue
        AppServerJvmDetailsController.MAXIMUM_COLOR = '#f57f20'; /// orange
        AppServerJvmDetailsController.COMMITTED_COLOR = '#515252'; /// dark gray
        AppServerJvmDetailsController.MAX_HEAP = 1024 * 1024 * 1024;
        AppServerJvmDetailsController.BYTES2MB = 1 / 1024 / 1024;
        return AppServerJvmDetailsController;
    })();
    HawkularMetrics.AppServerJvmDetailsController = AppServerJvmDetailsController;
    HawkularMetrics._module.controller('AppServerJvmDetailsController', AppServerJvmDetailsController);
})(HawkularMetrics || (HawkularMetrics = {}));

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// <reference path="../metricsPlugin.ts"/>
/// <reference path="../services/alertsManager.ts"/>
/// <reference path="../services/errorsManager.ts"/>
var HawkularMetrics;
(function (HawkularMetrics) {
    /* Already defined in appServerJvmDetails
      export interface IMultiDataPoint {
        key: string;
        color: string;
        values: IChartDataPoint[];
      }
    */
    var AppServerPlatformDetailsController = (function () {
        function AppServerPlatformDetailsController($location, $scope, $rootScope, $interval, $log, $filter, $routeParams, $modal, $window, HawkularInventory, HawkularMetric, HawkularAlertsManager, MetricsService, ErrorsManager, $q, md5) {
            var _this = this;
            this.$location = $location;
            this.$scope = $scope;
            this.$rootScope = $rootScope;
            this.$interval = $interval;
            this.$log = $log;
            this.$filter = $filter;
            this.$routeParams = $routeParams;
            this.$modal = $modal;
            this.$window = $window;
            this.HawkularInventory = HawkularInventory;
            this.HawkularMetric = HawkularMetric;
            this.HawkularAlertsManager = HawkularAlertsManager;
            this.MetricsService = MetricsService;
            this.ErrorsManager = ErrorsManager;
            this.$q = $q;
            this.md5 = md5;
            this.math = this.$window.Math;
            // will contain in the format: 'metric name' : true | false
            this.skipChartData = {};
            this.resolvedChartFileSystemData = {};
            this.resolvedMemoryData = false;
            this.resolvedCPUData = false;
            $scope.os = this;
            this.startTimeStamp = +moment().subtract(($routeParams.timeOffset || 3600000), 'milliseconds');
            this.endTimeStamp = +moment();
            this.chartCpuData = [];
            this.chartFileSystemData = {};
            this.chartCpuDataMulti = [];
            this.feedId = this.$routeParams.resourceId.split('~')[0];
            if ($rootScope.currentPersona) {
                this.$log.log('We have have a persona');
                this.setup();
            }
            else {
                // currentPersona hasn't been injected to the rootScope yet, wait for it..
                $rootScope.$watch('currentPersona', function (currentPersona) { return currentPersona && _this.setup(); });
            }
            //this.getAlerts(this.$routeParams.resourceId, this.startTimeStamp, this.endTimeStamp);
            this.autoRefresh(20);
        }
        AppServerPlatformDetailsController.prototype.setup = function () {
            this.getProcessors();
            this.getFileSystems();
            this.getPlatformData();
            this.refresh();
        };
        ;
        AppServerPlatformDetailsController.prototype.getAlerts = function (metricIdPrefix, startTime, endTime) {
            var _this = this;
            var pheapArray, nheapArray, garbaArray;
            var pheapPromise = this.HawkularAlertsManager.queryAlerts({ statuses: 'OPEN',
                triggerIds: metricIdPrefix + '_platform_mem', startTime: startTime, endTime: endTime }).then(function (pheapData) {
                _.forEach(pheapData.alertList, function (item) {
                    item['alertType'] = 'P_MEM';
                });
                pheapArray = pheapData.alertList;
            }, function (error) {
                return _this.ErrorsManager.errorHandler(error, 'Error fetching alerts.');
            });
            var nheapPromise = this.HawkularAlertsManager.queryAlerts({ statuses: 'OPEN',
                triggerIds: metricIdPrefix + '_platform_cpu', startTime: startTime, endTime: endTime }).then(function (nheapData) {
                _.forEach(nheapData.alertList, function (item) {
                    item['alertType'] = 'PCPU';
                });
                nheapArray = nheapData.alertList;
            }, function (error) {
                return _this.ErrorsManager.errorHandler(error, 'Error fetching alerts.');
            });
            var garbaPromise = this.HawkularAlertsManager.queryAlerts({ statuses: 'OPEN',
                triggerIds: metricIdPrefix + '_jvm_garba', startTime: startTime, endTime: endTime }).then(function (garbaData) {
                _.forEach(garbaData.alertList, function (item) {
                    item['alertType'] = 'GARBA'; // TODO
                });
                garbaArray = garbaData.alertList;
            }, function (error) {
                return _this.ErrorsManager.errorHandler(error, 'Error fetching alerts.');
            });
            this.$q.all([pheapPromise, nheapPromise, garbaPromise]).finally(function () {
                _this.alertList = [].concat(pheapArray, nheapArray, garbaArray);
            });
        };
        AppServerPlatformDetailsController.prototype.autoRefresh = function (intervalInSeconds) {
            var _this = this;
            this.autoRefreshPromise = this.$interval(function () {
                _this.refresh();
                //this.getAlerts(this.$routeParams.resourceId, this.startTimeStamp, this.endTimeStamp);
            }, intervalInSeconds * 1000);
            this.$scope.$on('$destroy', function () {
                _this.$interval.cancel(_this.autoRefreshPromise);
            });
        };
        AppServerPlatformDetailsController.prototype.refresh = function () {
            this.getPlatformData();
            this.getCPUChartData();
            this.getMemoryChartData();
            this.getFSChartData();
            this.getCpuChartDetailData();
        };
        ;
        AppServerPlatformDetailsController.prototype.getFileSystems = function () {
            var _this = this;
            this.$log.log('getFileSystems');
            this.endTimeStamp = this.$routeParams.endTime || +moment();
            this.startTimeStamp = this.endTimeStamp - (this.$routeParams.timeOffset || 3600000);
            var tenantId = this.$rootScope.currentPersona.id;
            this.HawkularInventory.ResourceOfTypeUnderFeed.query({
                environmentId: HawkularMetrics.globalEnvironmentId,
                feedId: this.feedId,
                resourceTypeId: 'File Store' }, function (aResourceList, getResponseHeaders) {
                var promises = [];
                var tmpResourceList = [];
                _this.$q.all(promises).then(function () {
                    _this.fileStoreList = aResourceList;
                    _this.fileStoreList.$resolved = true;
                });
            }, function () {
                if (!_this.fileStoreList) {
                    _this.fileStoreList = [];
                    _this.fileStoreList.$resolved = true;
                    _this['lastUpdateTimestamp'] = new Date();
                }
            });
        };
        // retrieve the list of CPUs
        AppServerPlatformDetailsController.prototype.getProcessors = function () {
            var _this = this;
            this.$log.log('getProcessors');
            this.endTimeStamp = this.$routeParams.endTime || +moment();
            this.startTimeStamp = this.endTimeStamp - (this.$routeParams.timeOffset || 3600000);
            this.HawkularInventory.ResourceOfTypeUnderFeed.query({
                environmentId: HawkularMetrics.globalEnvironmentId,
                feedId: this.feedId,
                resourceTypeId: 'Processor' }, function (aResourceList, getResponseHeaders) {
                var promises = [];
                var tmpResourceList = [];
                _this.$q.all(promises).then(function () {
                    _this.processorList = []; // aResourceList;
                    _this.processorListNames = [];
                    // Generate metric key from resource id
                    for (var i = 0; i < aResourceList.length; i++) {
                        var tmp = _this.feedId + '~MI~R~[' + aResourceList[i].id + ']~MT~CPU Usage';
                        _this.processorList[i] = tmp;
                        _this.processorListNames[tmp] = aResourceList[i].id;
                    }
                    _this.$log.log('Success, got CPUs ' + aResourceList.length);
                    _this.getCPUChartData();
                });
            }, function () {
                if (!_this.processorList) {
                    _this.processorList = [];
                    _this['lastUpdateTimestamp'] = new Date();
                }
            });
        };
        AppServerPlatformDetailsController.prototype.getPlatformData = function () {
            var _this = this;
            this.$log.log('getPlatformData');
            this.endTimeStamp = this.$routeParams.endTime || +moment();
            this.startTimeStamp = this.endTimeStamp - (this.$routeParams.timeOffset || 3600000);
            this.HawkularMetric.GaugeMetricData(this.$rootScope.currentPersona.id).queryMetrics({
                gaugeId: this.feedId + '~MI~R~[' + 'Memory' + ']~MT~Available Memory',
                start: this.startTimeStamp,
                end: this.endTimeStamp,
                buckets: 1
            }, function (resource) {
                if (resource.length) {
                    _this['memoryAvail'] = resource[0];
                }
            }, this);
            if (this.processorList) {
                this.HawkularMetric.GaugeMetricMultipleStats(this.$rootScope.currentPersona.id).get({
                    metrics: this.processorList,
                    start: this.startTimeStamp,
                    end: this.endTimeStamp,
                    buckets: 1
                }, function (resource) {
                    if (resource.length) {
                        _this['cpuUsage'] = resource[0];
                    }
                }, this);
            }
        };
        AppServerPlatformDetailsController.prototype.getFSChartData = function () {
            this.$log.log('getFSChartData');
            this.endTimeStamp = this.$routeParams.endTime || +moment();
            this.startTimeStamp = this.endTimeStamp - (this.$routeParams.timeOffset || 3600000);
            var tenantId = this.$rootScope.currentPersona.id;
            var availPromises = [];
            var tmpChartAvailData = {};
            angular.forEach(this.fileStoreList, function (res, idx) {
                var _this = this;
                if (!this.skipChartData[res.id + '_Free']) {
                    availPromises.push(this.HawkularMetric.GaugeMetricData(tenantId).queryMetrics({
                        gaugeId: this.feedId + '~MI~R~[' + res.id + ']~MT~Usable Space',
                        start: this.startTimeStamp,
                        end: this.endTimeStamp, buckets: 60
                    }, function (data) {
                        tmpChartAvailData[res.id] = tmpChartAvailData[res.id] || [];
                        tmpChartAvailData[res.id][tmpChartAvailData[res.id].length] = {
                            key: 'Usable Space',
                            color: AppServerPlatformDetailsController.USED_COLOR,
                            values: HawkularMetrics.MetricsService.formatBucketedChartOutput(data, 1 / (1024 * 1024))
                        };
                    }, this).$promise);
                }
                if (!this.skipChartData[res.id + '_Total']) {
                    availPromises.push(this.HawkularMetric.GaugeMetricData(tenantId).queryMetrics({
                        gaugeId: this.feedId + '~MI~R~[' + res.id + ']~MT~Total Space',
                        start: this.startTimeStamp,
                        end: this.endTimeStamp,
                        buckets: 60
                    }, function (data) {
                        tmpChartAvailData[res.id] = tmpChartAvailData[res.id] || [];
                        tmpChartAvailData[res.id][tmpChartAvailData[res.id].length] = {
                            key: 'Total Space',
                            color: AppServerPlatformDetailsController.MAXIMUM_COLOR,
                            values: HawkularMetrics.MetricsService.formatBucketedChartOutput(data, 1 / (1024 * 1024))
                        };
                    }, this).$promise);
                }
                this.$q.all(availPromises).finally(function () {
                    _this.chartFileSystemData[res.id] = tmpChartAvailData[res.id] || [];
                    _this.resolvedChartFileSystemData[res.id] = true;
                });
            }, this);
        };
        AppServerPlatformDetailsController.prototype.getCPUChartData = function () {
            var _this = this;
            this.$log.log('getCPUChartData');
            var tenantId = this.$rootScope.currentPersona.id;
            this.endTimeStamp = this.$routeParams.endTime || +moment();
            this.startTimeStamp = this.endTimeStamp - (this.$routeParams.timeOffset || 3600000);
            this.$log.log('Got cpus: ' + this.processorList);
            if (this.processorList) {
                this.HawkularMetric.GaugeMetricMultipleStats(this.$rootScope.currentPersona.id).get({
                    metrics: this.processorList,
                    start: this.startTimeStamp,
                    end: this.endTimeStamp,
                    buckets: 60,
                    stacked: true
                }, function (resource) {
                    if (resource.length) {
                        _this.chartCpuData = HawkularMetrics.MetricsService.formatBucketedChartOutput(resource, 100);
                        _this.resolvedCPUData = true;
                    }
                }, this);
            }
        };
        AppServerPlatformDetailsController.prototype.getCpuChartDetailData = function () {
            var tenantId = this.$rootScope.currentPersona.id;
            this.endTimeStamp = this.$routeParams.endTime || +moment();
            this.startTimeStamp = this.endTimeStamp - (this.$routeParams.timeOffset || 3600000);
            this.$log.log('CPU Chart detail Got cpus: ' + this.processorList);
            if (this.processorList) {
                var cpuPromises = [];
                var tmpChartData = {};
                var res = '';
                //for (var i = 0; i < this.processorList.length;i++) {
                angular.forEach(this.processorList, function (res, idx) {
                    //res = this.processorList[i];
                    var _this = this;
                    cpuPromises.push(this.HawkularMetric.GaugeMetricData(tenantId).queryMetrics({
                        gaugeId: res,
                        start: this.startTimeStamp,
                        end: this.endTimeStamp,
                        buckets: 60
                    }, function (data) {
                        _this.$log.log('Loaded ' + res);
                        //tmpChartData[res] = MetricsService.formatBucketedChartOutput(data, 100);
                        _this.chartCpuDataMulti[res] = HawkularMetrics.MetricsService.formatBucketedChartOutput(data, 100);
                    }, this).$cpuPromise);
                    this.$q.all(cpuPromises).then(function () {
                        //this.chartCpuDataMulti[res] = tmpChartData[res] || [];
                    });
                }, this);
            }
        };
        AppServerPlatformDetailsController.prototype.getMemoryChartData = function () {
            var _this = this;
            this.$log.log('getMemoryChartData');
            this.HawkularMetric.GaugeMetricData(this.$rootScope.currentPersona.id).queryMetrics({
                gaugeId: this.feedId + '~MI~R~[' + 'Memory' + ']~MT~Available Memory',
                start: this.startTimeStamp,
                end: this.endTimeStamp,
                buckets: 60
            }, function (resource) {
                if (resource.length) {
                    _this.chartMemoryUsageData = HawkularMetrics.MetricsService.formatBucketedChartOutput(resource, 1 / (1024 * 1024));
                    _this.resolvedMemoryData = true;
                }
            }, this);
        };
        AppServerPlatformDetailsController.prototype.toggleChartData = function (name) {
            this.skipChartData[name] = !this.skipChartData[name];
        };
        /// this is for minification purposes
        AppServerPlatformDetailsController.$inject = ['$location', '$scope', '$rootScope', '$interval', '$log', '$filter', '$routeParams',
            '$modal', '$window', 'HawkularInventory', 'HawkularMetric', 'HawkularAlertsManager', 'MetricsService',
            'ErrorsManager', '$q', 'md5'];
        AppServerPlatformDetailsController.USED_COLOR = '#1884c7'; /// blue
        AppServerPlatformDetailsController.MAXIMUM_COLOR = '#f57f20'; /// orange
        AppServerPlatformDetailsController.COMMITTED_COLOR = '#515252'; /// dark gray
        AppServerPlatformDetailsController.MAX_HEAP = 1024 * 1024 * 1024;
        return AppServerPlatformDetailsController;
    })();
    HawkularMetrics.AppServerPlatformDetailsController = AppServerPlatformDetailsController;
    HawkularMetrics._module.controller('AppServerJvmDetailsController', HawkularMetrics.AppServerJvmDetailsController);
})(HawkularMetrics || (HawkularMetrics = {}));

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// <reference path="../metricsPlugin.ts"/>
/// <reference path="../services/alertsManager.ts"/>
/// <reference path="../services/errorsManager.ts"/>
var HawkularMetrics;
(function (HawkularMetrics) {
    var AppServerTransactionsDetailsController = (function () {
        function AppServerTransactionsDetailsController() {
        }
        return AppServerTransactionsDetailsController;
    })();
    HawkularMetrics.AppServerTransactionsDetailsController = AppServerTransactionsDetailsController;
    HawkularMetrics._module.controller('AppServerTransactionsDetailsController', AppServerTransactionsDetailsController);
})(HawkularMetrics || (HawkularMetrics = {}));

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
/// <reference path="../metricsPlugin.ts"/>
/// <reference path="../../includes.ts"/>
/// <reference path="../services/alertsManager.ts"/>
/// <reference path="../services/errorsManager.ts"/>
var HawkularMetrics;
(function (HawkularMetrics) {
    var WebAlertController = (function () {
        function WebAlertController($scope, HawkularAlertsManager, ErrorsManager, NotificationsService, $log, $q, $rootScope, $routeParams, $modal, $interval, HkHeaderParser) {
            this.$scope = $scope;
            this.HawkularAlertsManager = HawkularAlertsManager;
            this.ErrorsManager = ErrorsManager;
            this.NotificationsService = NotificationsService;
            this.$log = $log;
            this.$q = $q;
            this.$rootScope = $rootScope;
            this.$routeParams = $routeParams;
            this.$modal = $modal;
            this.$interval = $interval;
            this.HkHeaderParser = HkHeaderParser;
            this.alertList = [];
            this.isResolvingAll = false;
            this.resCurPage = 0;
            this.resPerPage = 5;
            this.resourceId = $routeParams.resourceId;
            this.alertsTimeOffset = $routeParams.timeOffset || 3600000;
            // If the end time is not specified in URL use current time as end time
            this.alertsTimeEnd = $routeParams.endTime ? $routeParams.endTime : (new Date()).getTime();
            this.alertsTimeStart = this.alertsTimeEnd - this.alertsTimeOffset;
            this.defaultEmail = this.$rootScope.userDetails.email || 'myemail@company.com';
            this.getAlerts();
            this.autoRefresh(20);
        }
        WebAlertController.prototype.openSetup = function () {
            // Check if trigger exists on alerts setup modal open. If not, create the trigger before opening the modal
            var _this = this;
            var defaultEmail = this.$rootScope.userDetails.email || 'myemail@company.com';
            var defaultEmailPromise = this.HawkularAlertsManager.addEmailAction(defaultEmail);
            var activeSessionsTriggerPromise = this.HawkularAlertsManager
                .existTrigger(this.resourceId + '_web_active_sessions').then(function () {
                // Active Web Sessions trigger exists, nothing to do
                _this.$log.debug('Active Web Sessions trigger exists, nothing to do');
            }, function () {
                // Active Web Sessions trigger doesn't exist, need to create one
                var triggerId = _this.resourceId + '_web_active_sessions';
                var resourceId = triggerId.slice(0, -20);
                var dataId = 'MI~R~[' + resourceId +
                    '~~]~MT~WildFly Aggregated Web Metrics~Aggregated Active Web Sessions';
                var fullTrigger = {
                    trigger: {
                        name: 'Active Web Sessions',
                        id: triggerId,
                        description: 'Active Web Sessions for ' + resourceId,
                        autoDisable: true,
                        autoEnable: true,
                        autoResolve: false,
                        severity: 'MEDIUM',
                        actions: { email: [_this.defaultEmail] },
                        context: {
                            description: 'Active Web Sessions for ' + resourceId,
                            resourceType: 'App Server',
                            resourceName: resourceId,
                            resourcePath: _this.$rootScope.resourcePath
                        }
                    },
                    dampenings: [
                        {
                            triggerId: triggerId,
                            evalTimeSetting: 7 * 60000,
                            triggerMode: 'FIRING',
                            type: 'STRICT_TIME'
                        }
                    ],
                    conditions: [
                        {
                            triggerId: triggerId,
                            type: 'RANGE',
                            dataId: dataId,
                            operatorLow: 'INCLUSIVE',
                            operatorHigh: 'INCLUSIVE',
                            thresholdLow: HawkularMetrics.AppServerWebDetailsController.DEFAULT_MIN_SESSIONS,
                            thresholdHigh: HawkularMetrics.AppServerWebDetailsController.DEFAULT_MAX_SESSIONS,
                            inRange: false,
                            context: {
                                description: 'Active Web Sessions',
                                unit: 'sessions'
                            }
                        }
                    ]
                };
                return _this.HawkularAlertsManager.createTrigger(fullTrigger, function () {
                    _this.$log.error('Error on Trigger creation for ' + triggerId);
                });
            });
            var expiredSessionsTriggerPromise = this.HawkularAlertsManager
                .existTrigger(this.resourceId + '_web_expired_sessions').then(function () {
                // Expired Web Sessions trigger exists, nothing to do
                _this.$log.debug('Expired Web Sessions trigger exists, nothing to do');
            }, function () {
                // Active Web Sessions trigger doesn't exist, need to create one
                var triggerId = _this.resourceId + '_web_expired_sessions';
                var resourceId = triggerId.slice(0, -21);
                var dataId = 'MI~R~[' + resourceId +
                    '~~]~MT~WildFly Aggregated Web Metrics~Aggregated Expired Web Sessions';
                var fullTrigger = {
                    trigger: {
                        name: 'Expired Web Sessions',
                        id: triggerId,
                        description: 'Expired Web Sessions for ' + resourceId,
                        autoDisable: true,
                        autoEnable: true,
                        autoResolve: false,
                        severity: 'LOW',
                        actions: { email: [_this.defaultEmail] },
                        context: {
                            description: 'Expired Web Sessions for ' + resourceId,
                            resourceType: 'App Server',
                            resourceName: resourceId,
                            resourcePath: _this.$rootScope.resourcePath
                        }
                    },
                    dampenings: [
                        {
                            triggerId: triggerId,
                            evalTimeSetting: 7 * 60000,
                            triggerMode: 'FIRING',
                            type: 'STRICT_TIME'
                        }
                    ],
                    conditions: [
                        {
                            triggerId: triggerId,
                            type: 'THRESHOLD',
                            dataId: dataId,
                            threshold: HawkularMetrics.AppServerWebDetailsController.DEFAULT_EXPIRED_SESSIONS_THRESHOLD,
                            operator: 'GT',
                            context: {
                                description: 'Expired Web Sessions',
                                unit: 'sessions'
                            }
                        }
                    ]
                };
                return _this.HawkularAlertsManager.createTrigger(fullTrigger, function () {
                    _this.$log.error('Error on Trigger creation for ' + triggerId);
                });
            });
            var rejectedSessionsTriggerPromise = this.HawkularAlertsManager
                .existTrigger(this.resourceId + '_web_rejected_sessions').then(function () {
                // Web Sessions trigger exists, nothing to do
                _this.$log.debug('Rejected Web Sessions trigger exists, nothing to do');
            }, function () {
                // Rejected Web Sessions trigger doesn't exist, need to create one
                var triggerId = _this.resourceId + '_web_rejected_sessions';
                var resourceId = triggerId.slice(0, -22);
                var dataId = 'MI~R~[' + resourceId +
                    '~~]~MT~WildFly Aggregated Web Metrics~Aggregated Rejected Web Sessions';
                var fullTrigger = {
                    trigger: {
                        name: 'Rejected Web Sessions',
                        id: triggerId,
                        description: 'Rejected Web Sessions for ' + resourceId,
                        autoDisable: true,
                        autoEnable: true,
                        autoResolve: false,
                        severity: 'LOW',
                        actions: { email: [_this.defaultEmail] },
                        context: {
                            description: 'Rejected Web Sessions for ' + resourceId,
                            resourceType: 'App Server',
                            resourceName: resourceId,
                            resourcePath: _this.$rootScope.resourcePath
                        }
                    },
                    dampenings: [
                        {
                            triggerId: triggerId,
                            evalTimeSetting: 7 * 60000,
                            triggerMode: 'FIRING',
                            type: 'STRICT_TIME'
                        }
                    ],
                    conditions: [
                        {
                            triggerId: triggerId,
                            type: 'THRESHOLD',
                            dataId: dataId,
                            threshold: HawkularMetrics.AppServerWebDetailsController.DEFAULT_REJECTED_SESSIONS_THRESHOLD,
                            operator: 'GT',
                            context: {
                                description: 'Rejected Web Sessions',
                                unit: 'sessions'
                            }
                        }
                    ]
                };
                return _this.HawkularAlertsManager.createTrigger(fullTrigger, function () {
                    _this.$log.error('Error on Trigger creation for ' + triggerId);
                });
            });
            var log = this.$log;
            this.$q.all([defaultEmailPromise, activeSessionsTriggerPromise, expiredSessionsTriggerPromise,
                rejectedSessionsTriggerPromise]).then(function () {
                var modalInstance = _this.$modal.open({
                    templateUrl: 'plugins/metrics/html/modals/alerts-web-setup.html',
                    controller: 'WebAlertSetupController as was',
                    resolve: {
                        resourceId: function () {
                            return _this.resourceId;
                        }
                    }
                });
                modalInstance.result.then(angular.noop, function () {
                    log.debug('Web Alert Setup modal dismissed at: ' + new Date());
                });
            }, function () {
                _this.$log.error('Missing and unable to create new Web Alert triggers.');
            });
        };
        WebAlertController.prototype.autoRefresh = function (intervalInSeconds) {
            var _this = this;
            var autoRefreshPromise = this.$interval(function () {
                _this.getAlerts();
            }, intervalInSeconds * 1000);
            this.$scope.$on('$destroy', function () {
                _this.$interval.cancel(autoRefreshPromise);
            });
        };
        WebAlertController.prototype.getAlerts = function () {
            // Done in appServerWebDetails.ts#getAlerts()
        };
        WebAlertController.prototype.setPage = function (page) {
            this.resCurPage = page;
            this.getAlerts();
        };
        WebAlertController.prototype.resolveAll = function () {
            var _this = this;
            this.isResolvingAll = true;
            var alertIdList = '';
            for (var i = 0; i < this.alertList.length; i++) {
                alertIdList = alertIdList + this.alertList[i].id + ',';
            }
            alertIdList = alertIdList.slice(0, -1);
            var resolvedAlerts = {
                alertIds: alertIdList,
                resolvedBy: this.$rootScope.currentPersona.name,
                resolvedNotes: 'Manually resolved'
            };
            this.HawkularAlertsManager.resolveAlerts(resolvedAlerts).then(function () {
                _this.alertList.length = 0;
                _this.isResolvingAll = false;
            });
        };
        WebAlertController.$inject = ['$scope', 'HawkularAlertsManager', 'ErrorsManager', 'NotificationsService',
            '$log', '$q', '$rootScope', '$routeParams', '$modal', '$interval', 'HkHeaderParser'];
        return WebAlertController;
    })();
    HawkularMetrics.WebAlertController = WebAlertController;
    HawkularMetrics._module.controller('WebAlertController', WebAlertController);
    var WebAlertSetupController = (function (_super) {
        __extends(WebAlertSetupController, _super);
        function WebAlertSetupController() {
            _super.apply(this, arguments);
            this.maxUsage = HawkularMetrics.AppServerWebDetailsController.MAX_SESSIONS;
        }
        WebAlertSetupController.prototype.loadTriggers = function () {
            var _this = this;
            var activeSessionsTriggerId = this.$routeParams.resourceId + '_web_active_sessions';
            var activeSessionsTriggerPromise = this.HawkularAlertsManager.getTrigger(activeSessionsTriggerId).then(function (triggerData) {
                _this.triggerDefinition['active'] = triggerData;
                _this.adm.active = {};
                _this.adm.active['email'] = triggerData.trigger.actions.email[0];
                _this.adm.active['responseDuration'] = triggerData.dampenings[0].evalTimeSetting;
                _this.adm.active['activeMaxEnabled'] = false;
                _this.adm.active['activeMaxThreshold'] = HawkularMetrics.AppServerWebDetailsController.DEFAULT_MAX_SESSIONS;
                _this.adm.active['activeMinEnabled'] = false;
                _this.adm.active['activeMinThreshold'] = HawkularMetrics.AppServerWebDetailsController.DEFAULT_MIN_SESSIONS;
                if (triggerData.conditions[0].context.description === 'Active Web Sessions') {
                    _this.adm.active['activeMaxEnabled'] = triggerData.conditions[0].thresholdHigh < _this.maxUsage;
                    _this.adm.active['activeMaxThreshold'] = triggerData.conditions[0].thresholdHigh;
                    _this.adm.active['activeMinEnabled'] = triggerData.conditions[0].thresholdLow > 0;
                    _this.adm.active['activeMinThreshold'] = triggerData.conditions[0].thresholdLow;
                }
                if (!triggerData.trigger.enabled) {
                    _this.adm.active['activeMaxEnabled'] = false;
                    _this.adm.active['activeMinEnabled'] = false;
                }
            });
            var expiredSessionsTriggerId = this.$routeParams.resourceId + '_web_expired_sessions';
            var expiredSessionsTriggerPromise = this.HawkularAlertsManager.getTrigger(expiredSessionsTriggerId).then(function (triggerData) {
                _this.triggerDefinition['expired'] = triggerData;
                _this.adm.expired = {};
                // Dampening and Notification will be shared from the active threshold
                _this.adm.expired['expiredEnabled'] = triggerData.trigger.enabled;
                ;
                _this.adm.expired['expiredThreshold'] = HawkularMetrics.AppServerWebDetailsController.DEFAULT_EXPIRED_SESSIONS_THRESHOLD;
                if (triggerData.conditions[0].context.description === 'Expired Web Sessions') {
                    _this.adm.expired['expiredThreshold'] = triggerData.conditions[0].threshold;
                }
            });
            var rejectedSessionsTriggerId = this.$routeParams.resourceId + '_web_rejected_sessions';
            var rejectedSessionsTriggerPromise = this.HawkularAlertsManager.getTrigger(rejectedSessionsTriggerId).then(function (triggerData) {
                _this.triggerDefinition['rejected'] = triggerData;
                _this.adm.rejected = {};
                // Dampening and Notification will be shared from the active threshold
                _this.adm.rejected['rejectedEnabled'] = triggerData.trigger.enabled;
                ;
                _this.adm.rejected['rejectedThreshold'] = HawkularMetrics.AppServerWebDetailsController.DEFAULT_REJECTED_SESSIONS_THRESHOLD;
                if (triggerData.conditions[0].context.description === 'Rejected Web Sessions') {
                    _this.adm.rejected['rejectedThreshold'] = triggerData.conditions[0].threshold;
                }
            });
            return [activeSessionsTriggerPromise, expiredSessionsTriggerPromise, rejectedSessionsTriggerPromise];
        };
        WebAlertSetupController.prototype.saveTriggers = function (errorCallback) {
            var activeSessionsTrigger = angular.copy(this.triggerDefinition.active);
            activeSessionsTrigger.trigger.actions.email[0] = this.adm.active.email;
            activeSessionsTrigger.dampenings[0].evalTimeSetting = this.adm.active.responseDuration;
            activeSessionsTrigger.trigger.enabled = true;
            if (this.adm.active['activeMaxEnabled'] && this.adm.active['activeMinEnabled']) {
                activeSessionsTrigger.conditions[0].thresholdLow = this.adm.active['activeMinThreshold'];
                activeSessionsTrigger.conditions[0].thresholdHigh = this.adm.active['activeMaxThreshold'];
            }
            else if (!this.adm.active['activeMaxEnabled'] && this.adm.active['activeMinEnabled']) {
                activeSessionsTrigger.conditions[0].thresholdLow = this.adm.active['activeMinThreshold'];
                activeSessionsTrigger.conditions[0].thresholdHigh = HawkularMetrics.AppServerWebDetailsController.DEFAULT_MAX_SESSIONS;
            }
            else if (this.adm.active['activeMaxEnabled'] && !this.adm.active['activeMinEnabled']) {
                activeSessionsTrigger.conditions[0].thresholdLow = 0;
                activeSessionsTrigger.conditions[0].thresholdHigh = this.adm.active['activeMaxThreshold'];
            }
            else {
                activeSessionsTrigger.trigger.enabled = false;
            }
            var activeSessionsSavePromise = this.HawkularAlertsManager.updateTrigger(activeSessionsTrigger, errorCallback, this.triggerDefinition.active);
            var expiredSessionsTrigger = angular.copy(this.triggerDefinition.expired);
            expiredSessionsTrigger.trigger.actions.email[0] = this.adm.active.email;
            expiredSessionsTrigger.dampenings[0].evalTimeSetting = this.adm.active.responseDuration;
            expiredSessionsTrigger.trigger.enabled = true;
            if (this.adm.expired['expiredEnabled']) {
                expiredSessionsTrigger.conditions[0].threshold = this.adm.expired['expiredThreshold'];
            }
            else {
                expiredSessionsTrigger.trigger.enabled = false;
            }
            var expiredSessionsSavePromise = this.HawkularAlertsManager.updateTrigger(expiredSessionsTrigger, errorCallback, this.triggerDefinition.expired);
            var rejectedSessionsTrigger = angular.copy(this.triggerDefinition.rejected);
            rejectedSessionsTrigger.trigger.actions.email[0] = this.adm.active.email;
            rejectedSessionsTrigger.dampenings[0].evalTimeSetting = this.adm.active.responseDuration;
            rejectedSessionsTrigger.trigger.enabled = true;
            if (this.adm.rejected['rejectedEnabled']) {
                rejectedSessionsTrigger.conditions[0].threshold = this.adm.rejected['rejectedThreshold'];
            }
            else {
                rejectedSessionsTrigger.trigger.enabled = false;
            }
            var rejectedSessionsSavePromise = this.HawkularAlertsManager.updateTrigger(rejectedSessionsTrigger, errorCallback, this.triggerDefinition.rejected);
            return [activeSessionsSavePromise, expiredSessionsSavePromise, rejectedSessionsSavePromise];
        };
        return WebAlertSetupController;
    })(HawkularMetrics.AlertSetupController);
    HawkularMetrics.WebAlertSetupController = WebAlertSetupController;
    HawkularMetrics._module.controller('WebAlertSetupController', WebAlertSetupController);
})(HawkularMetrics || (HawkularMetrics = {}));

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// <reference path="../metricsPlugin.ts"/>
/// <reference path="../services/alertsManager.ts"/>
/// <reference path="../services/errorsManager.ts"/>
var HawkularMetrics;
(function (HawkularMetrics) {
    var AppServerWebDetailsController = (function () {
        function AppServerWebDetailsController($scope, $rootScope, $interval, $log, $routeParams, HawkularInventory, HawkularMetric, HawkularAlertsManager, ErrorsManager, $q, MetricsService) {
            var _this = this;
            this.$scope = $scope;
            this.$rootScope = $rootScope;
            this.$interval = $interval;
            this.$log = $log;
            this.$routeParams = $routeParams;
            this.HawkularInventory = HawkularInventory;
            this.HawkularMetric = HawkularMetric;
            this.HawkularAlertsManager = HawkularAlertsManager;
            this.ErrorsManager = ErrorsManager;
            this.$q = $q;
            this.MetricsService = MetricsService;
            this.activeWebSessions = 0;
            this.requestTime = 0;
            this.requestCount = 0;
            this.chartWebSessionData = [];
            // will contain in the format: 'metric name' : true | false
            this.skipChartData = {};
            $scope.vm = this;
            this.startTimeStamp = +moment().subtract(($routeParams.timeOffset || 3600000), 'milliseconds');
            this.endTimeStamp = +moment();
            if ($rootScope.currentPersona) {
                this.getWebData();
                this.getWebChartData();
            }
            else {
                // currentPersona hasn't been injected to the rootScope yet, wait for it..
                $rootScope.$watch('currentPersona', function (currentPersona) { return currentPersona &&
                    _this.getWebData(); });
                this.getWebChartData();
            }
            this.getAlerts(this.$routeParams.resourceId, this.startTimeStamp, this.endTimeStamp);
            this.autoRefresh(20);
        }
        AppServerWebDetailsController.prototype.getAlerts = function (metricIdPrefix, startTime, endTime) {
            var _this = this;
            var activeSessionsTriggerId = metricIdPrefix + '_web_active_sessions';
            var expiredSessionsTriggerId = metricIdPrefix + '_web_expired_sessions';
            var rejectedSessionsTriggerId = metricIdPrefix + '_web_rejected_sessions';
            var triggerIds = activeSessionsTriggerId + ',' + expiredSessionsTriggerId + ',' + rejectedSessionsTriggerId;
            var sessionsArray;
            var sessionsPromise = this.HawkularAlertsManager.queryAlerts({ statuses: 'OPEN', triggerIds: triggerIds,
                startTime: startTime, endTime: endTime }).then(function (sessionsData) {
                _.forEach(sessionsData.alertList, function (item) {
                    if (item['triggerId'] === activeSessionsTriggerId) {
                        item['alertType'] = 'ACTIVE_SESSIONS';
                    }
                    else if (item['triggerId'] === expiredSessionsTriggerId) {
                        item['alertType'] = 'EXPIRED_SESSIONS';
                    }
                    else if (item['triggerId'] === rejectedSessionsTriggerId) {
                        item['alertType'] = 'REJECTED_SESSIONS';
                    }
                });
                sessionsArray = sessionsData.alertList;
            }, function (error) {
                return _this.ErrorsManager.errorHandler(error, 'Error fetching alerts.');
            });
            this.$q.all([sessionsPromise]).finally(function () {
                _this.alertList = [].concat(sessionsArray);
            });
        };
        AppServerWebDetailsController.prototype.autoRefresh = function (intervalInSeconds) {
            var _this = this;
            this.autoRefreshPromise = this.$interval(function () {
                _this.getWebData();
                _this.getWebChartData();
            }, intervalInSeconds * 1000);
            this.$scope.$on('$destroy', function () {
                _this.$interval.cancel(_this.autoRefreshPromise);
            });
        };
        AppServerWebDetailsController.prototype.getWebData = function () {
            var _this = this;
            this.endTimeStamp = this.$routeParams.endTime || +moment();
            this.startTimeStamp = this.endTimeStamp - (this.$routeParams.timeOffset || 3600000);
            this.MetricsService.retrieveGaugeMetrics(this.$rootScope.currentPersona.id, "MI~R~[" + this.$routeParams.resourceId + "~~]~MT~WildFly Aggregated Web Metrics~Aggregated Active Web Sessions", this.startTimeStamp, this.endTimeStamp, 1).then(function (resource) {
                _this.activeWebSessions = resource[0].avg;
            });
            this.MetricsService.retrieveCounterMetrics(this.$rootScope.currentPersona.id, "MI~R~[" + this.$routeParams.resourceId + "~~]~MT~WildFly Aggregated Web Metrics~Aggregated Servlet Request Time", this.startTimeStamp, this.endTimeStamp, 1).then(function (resource) {
                _this.requestTime = resource[0].max - resource[0].min;
            });
            this.MetricsService.retrieveCounterMetrics(this.$rootScope.currentPersona.id, "MI~R~[" + this.$routeParams.resourceId + "~~]~MT~WildFly Aggregated Web Metrics~Aggregated Servlet Request Count", this.startTimeStamp, this.endTimeStamp, 1).then(function (resource) {
                _this.requestCount = resource[0].max - resource[0].min;
            });
        };
        AppServerWebDetailsController.prototype.getWebChartData = function () {
            var _this = this;
            this.endTimeStamp = this.$routeParams.endTime || +moment();
            this.startTimeStamp = this.endTimeStamp - (this.$routeParams.timeOffset || 3600000);
            var tmpChartWebSessionData = [];
            var promises = [];
            if (!this.skipChartData['Active Sessions']) {
                var activeSessionsPromise = this.MetricsService.retrieveGaugeMetrics(this.$rootScope.currentPersona.id, "MI~R~[" + this.$routeParams.resourceId + "~~]~MT~WildFly Aggregated Web Metrics~Aggregated Active Web Sessions", this.startTimeStamp, this.endTimeStamp, 60);
                promises.push(activeSessionsPromise);
                activeSessionsPromise.then(function (data) {
                    tmpChartWebSessionData[tmpChartWebSessionData.length] = {
                        key: 'Active Sessions',
                        color: AppServerWebDetailsController.ACTIVE_COLOR,
                        values: HawkularMetrics.MetricsService.formatBucketedChartOutput(data)
                    };
                });
            }
            if (!this.skipChartData['Expired Sessions']) {
                var expSessionsPromise = this.MetricsService.retrieveCounterMetrics(this.$rootScope.currentPersona.id, "MI~R~[" + this.$routeParams.resourceId + "~~]~MT~WildFly Aggregated Web Metrics~Aggregated Expired Web Sessions", this.startTimeStamp, this.endTimeStamp, 60);
                promises.push(expSessionsPromise);
                expSessionsPromise.then(function (data) {
                    tmpChartWebSessionData[tmpChartWebSessionData.length] = {
                        key: 'Expired Sessions',
                        color: AppServerWebDetailsController.EXPIRED_COLOR,
                        values: HawkularMetrics.MetricsService.formatBucketedChartOutput(data)
                    };
                });
            }
            if (!this.skipChartData['Rejected Sessions']) {
                var rejSessionsPromise = this.MetricsService.retrieveCounterMetrics(this.$rootScope.currentPersona.id, "MI~R~[" + this.$routeParams.resourceId + "~~]~MT~WildFly Aggregated Web Metrics~Aggregated Rejected Web Sessions", this.startTimeStamp, this.endTimeStamp, 60);
                promises.push(rejSessionsPromise);
                rejSessionsPromise.then(function (data) {
                    tmpChartWebSessionData[tmpChartWebSessionData.length] = {
                        key: 'Rejected Sessions',
                        color: AppServerWebDetailsController.REJECTED_COLOR,
                        values: HawkularMetrics.MetricsService.formatBucketedChartOutput(data)
                    };
                });
            }
            /* FIXME: Currently this is always returning negative values, as WFLY returns -1 per webapp. is it config value?
             this.HawkularMetric.CounterMetricData(this.$rootScope.currentPersona.id).queryMetrics({
             counterId: 'MI~R~[' + this.$routeParams.resourceId +
             '~~]~MT~WildFly Aggregated Web Metrics~Aggregated Max Active Web Sessions',
             start: this.startTimeStamp,
             end: this.endTimeStamp, buckets:60}, (data) => {
             this.chartWebSessionData[3] = { key: 'Max Active Sessions',
             color: AppServerWebDetailsController.MAX_ACTIVE_COLOR, values: this.formatBucketedChartOutput(data) };
             }, this);
             */
            /*
             this.HawkularMetric.CounterMetricData(this.$rootScope.currentPersona.id).queryMetrics({
             counterId: 'MI~R~[' + this.$routeParams.resourceId +
             '~~]~MT~WildFly Aggregated Web Metrics~Aggregated Servlet Request Time',
             start: this.startTimeStamp,
             end: this.endTimeStamp, buckets:60}, (data) => {
             this.chartWebData[4] = { key: 'NonHeap Committed',
             color: AppServerWebDetailsController.COMMITTED_COLOR, values: this.formatCounterChartOutput(data) };
             }, this);
             this.HawkularMetric.CounterMetricData(this.$rootScope.currentPersona.id).queryMetrics({
             counterId: 'MI~R~[' + this.$routeParams.resourceId +
             '~~]~MT~WildFly Aggregated Web Metrics~Aggregated Servlet Request Count',
             start: this.startTimeStamp,
             end: this.endTimeStamp, buckets:60}, (data) => {
             this.chartWebData[5] = { key: 'NonHeap Used',
             color: AppServerWebDetailsController.USED_COLOR, values: this.formatCounterChartOutput(data) };
             }, this);
             */
            this.$q.all(promises).finally(function () {
                _this.chartWebSessionData = tmpChartWebSessionData;
            });
        };
        AppServerWebDetailsController.prototype.toggleChartData = function (name) {
            this.skipChartData[name] = !this.skipChartData[name];
            this.getWebChartData();
        };
        /// this is for minification purposes
        AppServerWebDetailsController.$inject = ['$scope', '$rootScope', '$interval', '$log', '$routeParams',
            'HawkularInventory', 'HawkularMetric', 'HawkularAlertsManager', 'ErrorsManager', '$q', 'MetricsService'];
        AppServerWebDetailsController.MAX_ACTIVE_COLOR = '#1884c7'; /// blue
        AppServerWebDetailsController.EXPIRED_COLOR = '#f57f20'; /// orange
        AppServerWebDetailsController.ACTIVE_COLOR = '#49a547'; /// green
        AppServerWebDetailsController.REJECTED_COLOR = '#e12226'; /// red
        AppServerWebDetailsController.DEFAULT_MIN_SESSIONS = 20;
        AppServerWebDetailsController.DEFAULT_MAX_SESSIONS = 5000;
        AppServerWebDetailsController.MAX_SESSIONS = 9999;
        AppServerWebDetailsController.DEFAULT_EXPIRED_SESSIONS_THRESHOLD = 15;
        AppServerWebDetailsController.DEFAULT_REJECTED_SESSIONS_THRESHOLD = 15;
        return AppServerWebDetailsController;
    })();
    HawkularMetrics.AppServerWebDetailsController = AppServerWebDetailsController;
    HawkularMetrics._module.controller('AppServerWebDetailsController', AppServerWebDetailsController);
})(HawkularMetrics || (HawkularMetrics = {}));

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// <reference path="../metricsPlugin.ts"/>
/// <reference path="../../../includes.ts"/>
var HawkularMetrics;
(function (HawkularMetrics) {
    var HkAlertPanel = (function () {
        function HkAlertPanel(HawkularAlertsManager) {
            var _this = this;
            this.HawkularAlertsManager = HawkularAlertsManager;
            this.replace = 'true';
            this.scope = {
                alert: '=hkAlert',
                refresh: '&hkRefresh',
                persona: '=hkPersona'
            };
            this.templateUrl = 'plugins/metrics/html/directives/alert.html';
            this.link = function (scope, element, attrs) {
                scope.alertResolve = function () {
                    var resolvedAlerts = {
                        alertIds: scope.alert.id,
                        resolvedBy: scope.persona.name,
                        resolvedNotes: 'Manually resolved'
                    };
                    _this.HawkularAlertsManager.resolveAlerts(resolvedAlerts).then(function () {
                        scope.refresh({ hkAlert: scope.alert });
                    });
                };
            };
        }
        HkAlertPanel.Factory = function () {
            var directive = function (HawkularAlertsManager) {
                return new HkAlertPanel(HawkularAlertsManager);
            };
            directive['$inject'] = ['HawkularAlertsManager'];
            return directive;
        };
        return HkAlertPanel;
    })();
    HawkularMetrics.HkAlertPanel = HkAlertPanel;
    var HkAlertPanelList = (function () {
        function HkAlertPanelList() {
            this.replace = 'true';
            this.scope = {
                alertList: '=hkAlertList',
                limit: '=hkLimit'
            };
            this.templateUrl = 'plugins/metrics/html/directives/alert-list.html';
            this.link = function (scope, element, attrs) {
                scope.alertResolve = function (alert) {
                    for (var i = 0; i < scope.alertList.length; i++) {
                        if (scope.alertList[i].id === alert.id) {
                            scope.alertList.splice(i, 1);
                            break;
                        }
                    }
                };
            };
        }
        HkAlertPanelList.Factory = function () {
            var directive = function () {
                return new HkAlertPanelList();
            };
            directive['$inject'] = [];
            return directive;
        };
        return HkAlertPanelList;
    })();
    HawkularMetrics.HkAlertPanelList = HkAlertPanelList;
    var HkTime = (function () {
        function HkTime() {
        }
        HkTime.prototype.humanizeTime = function (timeMillis) {
            var result = {};
            var sec_num = Math.floor(timeMillis / 1000);
            var hours = Math.floor(sec_num / 3600);
            var minutes = Math.floor((sec_num - (hours * 3600)) / 60);
            var seconds = sec_num - (hours * 3600) - (minutes * 60);
            if (hours !== 0) {
                result.hours = hours;
            }
            if (minutes !== 0) {
                result.minutes = minutes;
            }
            if (seconds !== 0) {
                result.seconds = seconds;
            }
            return result;
        };
        HkTime.$inject = [];
        return HkTime;
    })();
    HawkularMetrics.HkTime = HkTime;
    var HkTimeInterval = (function () {
        function HkTimeInterval(HkTime) {
            this.HkTime = HkTime;
            this.replace = 'true';
            this.scope = {
                hkTimeMillis: '=hkTime'
            };
            this.templateUrl = 'plugins/metrics/html/directives/time-interval.html';
            this.link = function (scope, element, attrs) {
                scope.hkTime = HkTime.humanizeTime(scope.hkTimeMillis);
            };
        }
        HkTimeInterval.Factory = function () {
            var directive = function (HkTime) {
                return new HkTimeInterval(HkTime);
            };
            directive['$inject'] = ['hkTime'];
            return directive;
        };
        return HkTimeInterval;
    })();
    HawkularMetrics.HkTimeInterval = HkTimeInterval;
    HawkularMetrics._module.service('hkTime', HawkularMetrics.HkTime);
    HawkularMetrics._module.directive('hkAlertPanelList', HawkularMetrics.HkAlertPanelList.Factory());
    HawkularMetrics._module.directive('hkAlertPanel', HawkularMetrics.HkAlertPanel.Factory());
    HawkularMetrics._module.directive('hkTimeInterval', HawkularMetrics.HkTimeInterval.Factory());
    var HkFieldsetNotification = (function () {
        function HkFieldsetNotification() {
            this.replace = 'true';
            this.scope = {
                hkAlertEmail: '=',
                hkDisabled: '='
            };
            this.templateUrl = 'plugins/metrics/html/directives/fieldset-notification.html';
        }
        HkFieldsetNotification.Factory = function () {
            var directive = function () {
                return new HkFieldsetNotification();
            };
            directive['$inject'] = [];
            return directive;
        };
        return HkFieldsetNotification;
    })();
    HawkularMetrics.HkFieldsetNotification = HkFieldsetNotification;
    HawkularMetrics._module.directive('hkFieldsetNotification', HawkularMetrics.HkFieldsetNotification.Factory());
    var HkTimeUnit = (function () {
        function HkTimeUnit() {
            var _this = this;
            this.timeUnits = [
                { value: 1, label: 'milliseconds' },
                { value: 1000, label: 'seconds' },
                { value: 60000, label: 'minutes' },
                { value: 3600000, label: 'hours' }
            ];
            this.timeUnitDictionary = {};
            _.forEach(this.timeUnits, function (timeUnit) {
                _this.timeUnitDictionary[timeUnit.value] = timeUnit.label;
            });
        }
        // Get the most meaningful time unit (so that time value is not a very long fraction).
        HkTimeUnit.prototype.getFittestTimeUnit = function (timeValue) {
            if (timeValue === 0) {
                return 1;
            }
            var timeUnit = 1;
            _.forEach(this.timeUnits, function (unit) {
                if (timeValue % unit.value === 0 && unit.value > timeUnit) {
                    timeUnit = unit.value;
                }
            });
            return timeUnit;
        };
        HkTimeUnit.Factory = function () {
            var directive = function () {
                return new HkTimeUnit();
            };
            directive['$inject'] = [];
            return directive;
        };
        HkTimeUnit.$inject = [];
        return HkTimeUnit;
    })();
    HawkularMetrics.HkTimeUnit = HkTimeUnit;
    HawkularMetrics._module.service('hkTimeUnit', HawkularMetrics.HkTimeUnit.Factory());
    var HkFieldsetDampening = (function () {
        function HkFieldsetDampening(hkTimeUnit) {
            this.hkTimeUnit = hkTimeUnit;
            this.replace = 'true';
            this.scope = {
                hkDuration: '=',
                hkSwitch: '=',
                hkDisabled: '=',
                hkTitle: '@'
            };
            this.templateUrl = 'plugins/metrics/html/directives/fieldset-dampening.html';
            this.link = function (scope) {
                var localChange = false;
                var durationBackup = scope.hkDuration || 1;
                scope.durationChange = function () {
                    localChange = true;
                };
                scope.durationToggle = function () {
                    if (scope.durationEnabled) {
                        scope.hkDuration = durationBackup;
                        if (scope.hkDuration === 1) {
                            scope.responseUnit = hkTimeUnit.getFittestTimeUnit(scope.hkDuration);
                        }
                    }
                    else {
                        durationBackup = scope.hkDuration;
                        scope.hkDuration = 1;
                    }
                };
                scope.$watch('hkDuration', function () {
                    if (!localChange) {
                        scope.durationEnabled = scope.hkDuration !== 1;
                    }
                    localChange = false;
                });
                scope.$watch('hkSwitch', function () {
                    scope.hkSwitchEnabled = (scope.hkSwitch !== undefined);
                });
            };
        }
        HkFieldsetDampening.Factory = function () {
            var directive = function (hkTimeUnit) {
                return new HkFieldsetDampening(hkTimeUnit);
            };
            directive['$inject'] = ['hkTimeUnit'];
            return directive;
        };
        return HkFieldsetDampening;
    })();
    HawkularMetrics.HkFieldsetDampening = HkFieldsetDampening;
    HawkularMetrics._module.directive('hkFieldsetDampening', HawkularMetrics.HkFieldsetDampening.Factory());
})(HawkularMetrics || (HawkularMetrics = {}));

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// <reference path="../metricsPlugin.ts"/>
/// <reference path="../../includes.ts"/>
var HawkularMetrics;
(function (HawkularMetrics) {
    var HkAlertNotification = (function () {
        function HkAlertNotification() {
            this.templateUrl = 'plugins/metrics/html/alert-setup-notification.html';
            this.replace = 'true';
        }
        HkAlertNotification.Factory = function () {
            var directive = function () {
                return new HkAlertNotification();
            };
            directive['$inject'] = [];
            return directive;
        };
        return HkAlertNotification;
    })();
    HawkularMetrics._module.directive('hkAlertNotification', HkAlertNotification.Factory());
})(HawkularMetrics || (HawkularMetrics = {}));

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// <reference path="../metricsPlugin.ts"/>
/// <reference path="../../../includes.ts"/>
var HawkularMetrics;
(function (HawkularMetrics) {
    HawkularMetrics._module.directive('fileread', [function () {
            return {
                scope: {
                    fileread: '='
                },
                link: function (scope, element) {
                    element.bind('change', function (changeEvent) {
                        var theFile = changeEvent.target.files[0];
                        var reader = new FileReader();
                        reader.onload = function (readEvent) {
                            if (readEvent.target.readyState === FileReader.DONE) {
                                scope.$apply(function () {
                                    scope.fileread = new Uint8Array(readEvent.target.result);
                                });
                            }
                        };
                        reader.onerror = function (error) {
                            console.error('Error occurred in fileread directive: ' + error);
                        };
                        console.log("Reading file: " + theFile.name + " to deploy. Size: " + theFile.size);
                        reader.readAsArrayBuffer(theFile);
                    });
                }
            };
        }]);
})(HawkularMetrics || (HawkularMetrics = {}));

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// <reference path="../metricsPlugin.ts"/>
/// <reference path="../../../includes.ts"/>
var HawkularMetrics;
(function (HawkularMetrics) {
    var HkSwitch = (function () {
        function HkSwitch() {
            this.restrict = 'E';
            this.replace = 'true';
            this.scope = {
                name: '@',
                id: '@',
                hkModel: '=',
                hkDisabled: '=',
                hkChange: '&',
                hkClick: '&'
            };
            this.templateUrl = 'plugins/metrics/html/directives/hk-switch.html';
            this.link = function (scope, element, attrs) {
                element.removeAttr('name');
                element.removeAttr('id');
                scope.hkOnText = attrs.onText || 'ON';
                scope.hkOffText = attrs.offText || 'OFF';
                element.bind('keydown', function (e) {
                    var code = e.keyCode || e.which;
                    if (code === 32 || code === 13) {
                        e.stopImmediatePropagation();
                        e.preventDefault();
                        $(e.target).find('input').click();
                    }
                });
            };
        }
        HkSwitch.Factory = function () {
            var directive = function () {
                return new HkSwitch();
            };
            directive['$inject'] = [];
            return directive;
        };
        return HkSwitch;
    })();
    HawkularMetrics.HkSwitch = HkSwitch;
    HawkularMetrics._module.directive('hkSwitch', HawkularMetrics.HkSwitch.Factory());
    var HkTimeInput = (function () {
        function HkTimeInput(hkTimeUnit) {
            this.hkTimeUnit = hkTimeUnit;
            this.replace = 'true';
            this.restrict = 'E';
            this.scope = {
                id: '@',
                hkDuration: '=',
                hkDisabled: '=',
                hkAutoConvert: '=',
                hkChange: '&'
            };
            this.templateUrl = 'plugins/metrics/html/directives/time-input.html';
            this.link = function (scope, element, attrs) {
                element.removeAttr('id');
                var localChange = false;
                scope.timeUnits = hkTimeUnit.timeUnits;
                scope.timeUnitsDict = hkTimeUnit.timeUnitDictionary;
                scope.durationChange = function () {
                    localChange = true;
                    scope.hkDuration = scope.hkConvertedDuration * scope.responseUnit;
                    scope.hkChange();
                };
                scope.computeTimeInUnits = function () {
                    scope.hkConvertedDuration = scope.hkDuration / scope.responseUnit;
                };
                scope.$watch('hkDuration', function (newDuration, oldDuration) {
                    scope.durationEnabled = scope.hkDuration !== 0;
                    if (!localChange) {
                        scope.responseUnit = hkTimeUnit.getFittestTimeUnit(scope.hkDuration);
                        scope.computeTimeInUnits();
                    }
                    localChange = false;
                });
            };
        }
        HkTimeInput.Factory = function () {
            var directive = function (hkTimeUnit) {
                return new HkTimeInput(hkTimeUnit);
            };
            directive['$inject'] = ['hkTimeUnit'];
            return directive;
        };
        return HkTimeInput;
    })();
    HawkularMetrics.HkTimeInput = HkTimeInput;
    HawkularMetrics._module.directive('hkTimeInput', HawkularMetrics.HkTimeInput.Factory());
})(HawkularMetrics || (HawkularMetrics = {}));

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// <reference path="../metricsPlugin.ts"/>
/// <reference path="../../../includes.ts"/>
var HawkularMetrics;
(function (HawkularMetrics) {
    /// TODO: use ControllerAs syntax
    var paginationController = function ($scope) {
        $scope.currentPageView = $scope.currentPage + 1;
        $scope.pagesNumber = getPagesNumber();
        function getPagesNumber() {
            return $scope.headers && Math.ceil(($scope.headers.total || 1) / $scope.perPage);
        }
        $scope.setPage = function (pageNumber) {
            $scope.pagesNumber = getPagesNumber();
            if ($scope.pagesNumber === 1) {
                $scope.currentPageView = 1;
                return;
            }
            if (pageNumber < 1) {
                $scope.pageSetter({ pageNumber: 0 });
                $scope.currentPageView = 1;
            }
            else if (pageNumber >= $scope.pagesNumber) {
                $scope.pageSetter({ pageNumber: $scope.pagesNumber - 1 });
                $scope.currentPageView = pageNumber;
            }
            else {
                $scope.pageSetter({ pageNumber: pageNumber });
            }
        };
        $scope.goToFirst = function () {
            $scope.pageSetter({ pageNumber: 0 });
        };
        $scope.goToLast = function () {
            $scope.pagesNumber = getPagesNumber();
            $scope.pageSetter({ pageNumber: $scope.pagesNumber - 1 });
        };
        $scope.goTos = [0];
        $scope.$watch('currentPage', function (recentCurrentPage) {
            $scope.currentPageView = parseInt(recentCurrentPage, 10) + 1;
        });
        $scope.$watchGroup(['headers', 'perPage'], function () {
            $scope.pagesNumber = getPagesNumber();
            $scope.goTos = new Array($scope.pagesNumber);
        });
    };
    var HkPagination = (function () {
        function HkPagination() {
            this.templateUrl = 'plugins/metrics/html/url-pagination.html';
            this.scope = {
                resourceList: '=',
                currentPage: '=',
                linkHeader: '=',
                pageSetter: '&',
                perPage: '=',
                headers: '='
            };
            this.replace = 'true';
            this.controller = paginationController;
        }
        HkPagination.Factory = function () {
            var directive = function () {
                return new HkPagination();
            };
            directive['$inject'] = [];
            return directive;
        };
        return HkPagination;
    })();
    HawkularMetrics._module.directive('hkPagination', HkPagination.Factory());
    var HkDataPagination = (function () {
        function HkDataPagination() {
            this.templateUrl = 'plugins/metrics/html/data-pagination.html';
            this.scope = {
                resourceList: '=',
                currentPage: '=',
                linkHeader: '=',
                pageSetter: '&',
                perPage: '=',
                headers: '='
            };
            this.replace = 'true';
            this.controller = paginationController;
        }
        HkDataPagination.Factory = function () {
            var directive = function () {
                return new HkDataPagination();
            };
            directive['$inject'] = [];
            return directive;
        };
        return HkDataPagination;
    })();
    HawkularMetrics._module.directive('hkDataPagination', HkDataPagination.Factory());
})(HawkularMetrics || (HawkularMetrics = {}));

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// <reference path="../metricsPlugin.ts"/>
/// <reference path="../../../includes.ts"/>
var HawkularMetrics;
(function (HawkularMetrics) {
    /**
     *
     */
    HawkularMetrics._module.directive('hkValidFile', function () {
        return {
            require: 'ngModel',
            link: function (scope, el, attrs, ngModel) {
                //change event is fired when file is selected
                el.bind('change', function () {
                    scope.$apply(function () {
                        ngModel.$setViewValue(el.val());
                        ngModel.$render();
                    });
                });
            }
        };
    });
})(HawkularMetrics || (HawkularMetrics = {}));

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// <reference path="../metricsPlugin.ts"/>
/// <reference path="../../includes.ts"/>
// from https://github.com/erykpiast/angular-duration-format
var HawkularMetrics;
(function (HawkularMetrics) {
    HawkularMetrics._module.filter('duration', function () {
        var DURATION_FORMATS_SPLIT = /((?:[^ydhms']+)|(?:'(?:[^']|'')*')|(?:y+|d+|h+|m+|s+))(.*)/;
        var DURATION_FORMATS = {
            'y': {
                // "longer" years are not supported
                value: 365 * 24 * 60 * 60 * 1000
            },
            'yy': {
                value: 'y',
                pad: 2
            },
            'd': {
                value: 24 * 60 * 60 * 1000
            },
            'dd': {
                value: 'd',
                pad: 2
            },
            'h': {
                value: 60 * 60 * 1000
            },
            'hh': {
                value: 'h',
                pad: 2
            },
            'm': {
                value: 60 * 1000
            },
            'mm': {
                value: 'm',
                pad: 2
            },
            's': {
                value: 1000
            },
            'ss': {
                value: 's',
                pad: 2
            },
            'sss': {
                value: 1
            },
            'ssss': {
                value: 'sss',
                pad: 4
            }
        };
        function _parseFormat(string) {
            // @inspiration AngularJS date filter
            var parts = [];
            var format = string;
            while (format) {
                var match = DURATION_FORMATS_SPLIT.exec(format);
                if (match) {
                    parts = parts.concat(match.slice(1));
                    format = parts.pop();
                }
                else {
                    parts.push(format);
                    format = null;
                }
            }
            return parts;
        }
        function _formatDuration(timestamp, format) {
            var text = '';
            var values = {};
            format.filter(function (format) {
                return DURATION_FORMATS.hasOwnProperty(format);
            }).map(function (format) {
                var config = DURATION_FORMATS[format];
                if (config.hasOwnProperty('pad')) {
                    return config.value;
                }
                else {
                    return format;
                }
            }).filter(function (format, index, arr) {
                return (arr.indexOf(format) === index);
            }).map(function (format) {
                return angular.extend({
                    name: format
                }, DURATION_FORMATS[format]);
            }).sort(function (a, b) {
                return b.value - a.value;
            }).forEach(function (format) {
                var value = values[format.name] = Math.floor(timestamp / format.value);
                timestamp = timestamp - (value * format.value);
            });
            format.forEach(function (part) {
                var format = DURATION_FORMATS[part];
                if (format) {
                    var value = values[format.value];
                    text += (format.hasOwnProperty('pad') ?
                        _padNumber(value, Math.max(format.pad, value.toString().length)) : values[part]);
                }
                else {
                    text += part.replace(/(^'|'$)/g, '').replace(/''/g, '\'');
                }
            });
            return text;
        }
        function _padNumber(number, len) {
            return ((new Array(len + 1)).join('0') + number).slice(-len);
        }
        return function (value, format) {
            if (typeof value !== 'number') {
                return value;
            }
            var timestamp = parseInt(value.valueOf(), 10);
            if (isNaN(timestamp)) {
                return value;
            }
            else {
                return _formatDuration(timestamp, _parseFormat(format));
            }
        };
    });
})(HawkularMetrics || (HawkularMetrics = {}));

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// <reference path="../metricsPlugin.ts"/>
/// <reference path="../../includes.ts"/>
var HawkularMetrics;
(function (HawkularMetrics) {
    HawkularMetrics._module.filter('firstUpper', function () {
        return function (input) {
            if (input != null) {
                input = input.toLowerCase();
                return input.substring(0, 1).toUpperCase() + input.substring(1);
            }
        };
    });
})(HawkularMetrics || (HawkularMetrics = {}));

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// <reference path="../../metricsPlugin.ts"/>
var HawkularMetrics;
(function (HawkularMetrics) {
    var AppServerDatasourcesAddDialogController = (function () {
        function AppServerDatasourcesAddDialogController($rootScope, $scope, $q, $timeout, $log, HawkularOps, $modalInstance, NotificationsService, $routeParams, HawkularInventory) {
            var _this = this;
            this.$rootScope = $rootScope;
            this.$scope = $scope;
            this.$q = $q;
            this.$timeout = $timeout;
            this.$log = $log;
            this.HawkularOps = HawkularOps;
            this.$modalInstance = $modalInstance;
            this.NotificationsService = NotificationsService;
            this.$routeParams = $routeParams;
            this.HawkularInventory = HawkularInventory;
            this.tmpDSProperties = [];
            this.dsNameChanged = false;
            this.jndiNameChanged = false;
            /// make sure our WS socket is open
            HawkularOps.init(this.NotificationsService);
            HawkularInventory.ResourceUnderFeed.get({
                environmentId: HawkularMetrics.globalEnvironmentId,
                feedId: this.$routeParams.resourceId.split('~')[0],
                resourcePath: this.$routeParams.resourceId + '~~'
            }, function (resource) {
                _this.dsData.resourcePath = resource.path;
            });
            $scope.$on('DatasourceAddSuccess', function (event, data) {
                _this.dsData.uploading = false;
                _this.dsData.hasOperationSucceeded = true;
                _this.dsData.hasOperationFailed = false;
            });
            $scope.$on('DatasourceAddError', function (event, data) {
                _this.dsData.uploading = false;
                _this.dsData.hasOperationFailed = true;
                _this.dsData.hasOperationSucceeded = false;
            });
        }
        AppServerDatasourcesAddDialogController.prototype.onClose = function () {
            this.$modalInstance.close('ok');
        };
        AppServerDatasourcesAddDialogController.prototype.onDSNameChange = function () {
            this.dsNameChanged = true;
            if (!this.jndiNameChanged) {
                this.dsData.jndiName = 'java:/' + this.dsData.datasourceName;
            }
        };
        AppServerDatasourcesAddDialogController.prototype.onJNDINameChange = function () {
            this.jndiNameChanged = true;
            if (!this.dsNameChanged) {
                this.dsData.datasourceName = this.dsData.jndiName.replace('java:/', '').replace('java:jboss/', '');
            }
        };
        AppServerDatasourcesAddDialogController.prototype.exitStepDatasourceAttributes = function () {
            var _this = this;
            this.HawkularInventory.ResourceOfTypeUnderFeed.query({
                environmentId: HawkularMetrics.globalEnvironmentId, feedId: this.$routeParams.resourceId.split('~')[0],
                resourceTypeId: 'JDBC Driver' }, function (aResourceList, getResponseHeaders) {
                _this.driversList = aResourceList;
                _.forEach(_this.driversList, function (item) {
                    item.name = item.id.split('jdbc-driver=')[1];
                }, _this);
            });
        };
        AppServerDatasourcesAddDialogController.prototype.removeDSProperty = function (idx) {
            this.tmpDSProperties.splice(idx, 1);
        };
        AppServerDatasourcesAddDialogController.prototype.addDSProperty = function () {
            this.tmpDSProperties.push({ name: '', value: '' });
        };
        AppServerDatasourcesAddDialogController.prototype.exitStepXAProperties = function () {
            this.dsData.datasourceProperties = {};
            _.forEach(this.tmpDSProperties, function (prop) {
                this.dsData.datasourceProperties[prop.name] = prop.value;
            }, this);
        };
        AppServerDatasourcesAddDialogController.prototype.backStepReview = function () {
            this.dsData.uploading = false;
            this.dsData.hasOperationFailed = false;
            this.dsData.hasOperationSucceeded = false;
        };
        AppServerDatasourcesAddDialogController.prototype.addDatasource = function () {
            console.log('adding DS', this.dsData);
            this.dsData.uploading = true;
            this.HawkularOps.performAddDatasourceOperation(this.dsData.resourcePath, this.$rootScope.userDetails.token, this.$rootScope.currentPersona.id, this.dsData.xaDatasource, this.dsData.datasourceName, this.dsData.jndiName, this.dsData.driverName, this.dsData.driverClass, this.dsData.connectionUrl, this.dsData.xaDatasourceClass, this.dsData.datasourceProperties || { URL: 'jdbc:h2:mem:test' }, this.dsData.conn.username, this.dsData.conn.password, this.dsData.conn.securityDomain);
        };
        AppServerDatasourcesAddDialogController.prototype.finishedAddDatasourceWizard = function () {
            //this.$log.log('Finished add Datasource wizard');
            this.$modalInstance.close('ok');
        };
        /// this is for minification purposes
        AppServerDatasourcesAddDialogController.$inject = ['$rootScope', '$scope', '$q', '$timeout', '$log', 'HawkularOps',
            '$modalInstance', 'NotificationsService', '$routeParams', 'HawkularInventory'];
        return AppServerDatasourcesAddDialogController;
    })();
    HawkularMetrics.AppServerDatasourcesAddDialogController = AppServerDatasourcesAddDialogController;
    HawkularMetrics._module.controller('AppServerDatasourcesAddDialogController', AppServerDatasourcesAddDialogController);
})(HawkularMetrics || (HawkularMetrics = {}));

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// <reference path="../../metricsPlugin.ts"/>
var HawkularMetrics;
(function (HawkularMetrics) {
    var AppServerDatasourcesDeleteDialogController = (function () {
        function AppServerDatasourcesDeleteDialogController($scope, $rootScope, $modalInstance, $q, HawkularOps, NotificationsService, datasource) {
            var _this = this;
            this.$scope = $scope;
            this.$rootScope = $rootScope;
            this.$modalInstance = $modalInstance;
            this.$q = $q;
            this.HawkularOps = HawkularOps;
            this.NotificationsService = NotificationsService;
            this.datasource = datasource;
            /// make sure our WS socket is open
            HawkularOps.init(this.NotificationsService);
            $scope.$on('DatasourceRemoveSuccess', function (event, data) {
                _this.$modalInstance.close(data);
            });
            $scope.$on('DatasourceRemoveError', function (event, data) {
                _this.NotificationsService.error('The Datasource ' + _this.datasource.name +
                    ' failed to be deleted.');
            });
        }
        AppServerDatasourcesDeleteDialogController.prototype.deleteDatasource = function () {
            this.HawkularOps.performRemoveDatasourceOperation(this.datasource.path, this.$rootScope.userDetails.token, this.$rootScope.currentPersona.id);
        };
        AppServerDatasourcesDeleteDialogController.prototype.cancel = function () {
            this.$modalInstance.dismiss('cancel');
        };
        AppServerDatasourcesDeleteDialogController.$inject = ['$scope', '$rootScope', '$modalInstance', '$q', 'HawkularOps', 'NotificationsService',
            'datasource'];
        return AppServerDatasourcesDeleteDialogController;
    })();
    HawkularMetrics.AppServerDatasourcesDeleteDialogController = AppServerDatasourcesDeleteDialogController;
    HawkularMetrics._module.controller('AppServerDatasourcesDeleteDialogController', AppServerDatasourcesDeleteDialogController);
})(HawkularMetrics || (HawkularMetrics = {}));

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// <reference path="../../metricsPlugin.ts"/>
var HawkularMetrics;
(function (HawkularMetrics) {
    var AppServerDatasourcesDriverAddDialogController = (function () {
        function AppServerDatasourcesDriverAddDialogController($rootScope, $scope, $q, $timeout, $log, HawkularOps, $modalInstance, NotificationsService, $routeParams, HawkularInventory) {
            var _this = this;
            this.$rootScope = $rootScope;
            this.$scope = $scope;
            this.$q = $q;
            this.$timeout = $timeout;
            this.$log = $log;
            this.HawkularOps = HawkularOps;
            this.$modalInstance = $modalInstance;
            this.NotificationsService = NotificationsService;
            this.$routeParams = $routeParams;
            this.HawkularInventory = HawkularInventory;
            this.driverData = {
                resourcePath: '',
                filePath: '',
                driverName: '',
                moduleName: '',
                driverClass: '',
                driverMajorVersion: undefined,
                driverMinorVersion: undefined,
                binaryFile: undefined,
                uploading: false,
                hasDeploymentError: false,
                hasDeployedSuccessfully: false
            };
            /// make sure our WS socket is open
            HawkularOps.init(this.NotificationsService);
            HawkularInventory.ResourceUnderFeed.get({
                environmentId: HawkularMetrics.globalEnvironmentId,
                feedId: this.$routeParams.resourceId.split('~')[0],
                resourcePath: this.$routeParams.resourceId + '~~'
            }, function (resource) {
                _this.driverData.resourcePath = resource.path;
            });
            $scope.$on('JDBCDriverAddSuccess', function (event, data) {
                //this.$log.info('Deployment Add Succeeded!');
                _this.driverData.uploading = false;
                _this.driverData.hasDeployedSuccessfully = true;
                _this.driverData.hasDeploymentError = false;
            });
            $scope.$on('JDBCDriverAddError', function (event, data) {
                //this.$log.warn('Deployment Add Failed!');
                //this.$log.warn(data);
                _this.driverData.uploading = false;
                _this.driverData.hasDeploymentError = true;
                _this.driverData.hasDeployedSuccessfully = false;
            });
        }
        AppServerDatasourcesDriverAddDialogController.prototype.cleanFilePath = function (filePath) {
            return filePath.replace('C:\\fakepath\\', '');
        };
        AppServerDatasourcesDriverAddDialogController.prototype.onClose = function () {
            this.$modalInstance.close('ok');
        };
        AppServerDatasourcesDriverAddDialogController.prototype.exitStepFileSelect = function () {
            this.driverData.filePath = this.cleanFilePath(this.driverData.filePath);
        };
        AppServerDatasourcesDriverAddDialogController.prototype.exitStepDefineParameters = function () {
            this.driverData.uploading = false;
            this.driverData.hasDeploymentError = false;
            this.driverData.hasDeployedSuccessfully = false;
        };
        AppServerDatasourcesDriverAddDialogController.prototype.addDriver = function () {
            this.driverData.uploading = true;
            this.HawkularOps.performAddJDBCDriverOperation(this.driverData.resourcePath, this.driverData.filePath, this.driverData.driverName, this.driverData.moduleName, this.driverData.driverClass, this.driverData.driverMajorVersion, this.driverData.driverMinorVersion, this.driverData.binaryFile, this.$rootScope.userDetails.token, this.$rootScope.currentPersona.id);
        };
        AppServerDatasourcesDriverAddDialogController.prototype.finishedAddDriverWizard = function () {
            //this.$log.log('Finished add jdbc driver wizard');
            this.$modalInstance.close('ok');
        };
        /// this is for minification purposes
        AppServerDatasourcesDriverAddDialogController.$inject = ['$rootScope', '$scope', '$q', '$timeout', '$log', 'HawkularOps',
            '$modalInstance', 'NotificationsService', '$routeParams', 'HawkularInventory'];
        return AppServerDatasourcesDriverAddDialogController;
    })();
    HawkularMetrics.AppServerDatasourcesDriverAddDialogController = AppServerDatasourcesDriverAddDialogController;
    HawkularMetrics._module.controller('AppServerDatasourcesDriverAddDialogController', AppServerDatasourcesDriverAddDialogController);
})(HawkularMetrics || (HawkularMetrics = {}));

///
/// Copyright 2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// <reference path="../../metricsPlugin.ts"/>
var HawkularMetrics;
(function (HawkularMetrics) {
    var AppServerDeploymentsAddDialogController = (function () {
        function AppServerDeploymentsAddDialogController($rootScope, $scope, $q, $timeout, $log, HawkularOps, $modalInstance, NotificationsService, $routeParams, HawkularInventory) {
            var _this = this;
            this.$rootScope = $rootScope;
            this.$scope = $scope;
            this.$q = $q;
            this.$timeout = $timeout;
            this.$log = $log;
            this.HawkularOps = HawkularOps;
            this.$modalInstance = $modalInstance;
            this.NotificationsService = NotificationsService;
            this.$routeParams = $routeParams;
            this.HawkularInventory = HawkularInventory;
            this.deploymentData = {
                resourcePath: '',
                runtimeFileName: '',
                filePath: '',
                binaryFile: undefined,
                dontEnableDuringDeployment: false,
                uploading: false,
                hasDeploymentError: false,
                hasDeployedSuccessfully: false,
                editDeploymentFiles: false
            };
            /// make sure our WS socket is open
            HawkularOps.init(this.NotificationsService);
            HawkularInventory.ResourceUnderFeed.get({
                environmentId: HawkularMetrics.globalEnvironmentId,
                feedId: this.$routeParams.resourceId.split('~')[0],
                resourcePath: this.$routeParams.resourceId + '~~'
            }, function (resource) {
                _this.deploymentData.resourcePath = resource.path;
            });
            $scope.$on('DeploymentAddSuccess', function (event, data) {
                _this.$log.info('Deployment Add Succeeded!');
                _this.deploymentData.uploading = false;
                _this.deploymentData.hasDeployedSuccessfully = true;
                _this.deploymentData.hasDeploymentError = false;
            });
            $scope.$on('DeploymentAddError', function (event, data) {
                _this.$log.warn('Deployment Add Failed!');
                _this.$log.warn(data);
                _this.deploymentData.uploading = false;
                _this.deploymentData.hasDeploymentError = true;
                _this.deploymentData.hasDeployedSuccessfully = false;
            });
        }
        AppServerDeploymentsAddDialogController.prototype.cleanFilePath = function (filePath) {
            return filePath.replace('C:\\fakepath\\', '');
        };
        AppServerDeploymentsAddDialogController.prototype.onClose = function () {
            this.$modalInstance.close('ok');
        };
        AppServerDeploymentsAddDialogController.prototype.exitStep1 = function () {
            this.$log.log('Exit Step 1 for resourceId: ' + this.$routeParams.resourceId);
            this.deploymentData.editDeploymentFiles = false;
            this.deploymentData.filePath = this.cleanFilePath(this.deploymentData.filePath);
            this.deploymentData.runtimeFileName = this.deploymentData.filePath;
        };
        AppServerDeploymentsAddDialogController.prototype.exitStep2 = function () {
            this.deploymentData.uploading = true;
            this.$log.log('Deploying file: ' + this.deploymentData.runtimeFileName);
            this.HawkularOps.performAddDeployOperation(this.deploymentData.resourcePath, this.deploymentData.runtimeFileName, this.deploymentData.binaryFile, this.$rootScope.userDetails.token, this.$rootScope.currentPersona.id, !this.deploymentData.dontEnableDuringDeployment);
        };
        AppServerDeploymentsAddDialogController.prototype.editVerifyFile = function () {
            this.deploymentData.editDeploymentFiles = true;
            this.editableDeploymentData = angular.copy(this.deploymentData);
            this.originalDeploymentData = angular.copy(this.deploymentData);
        };
        AppServerDeploymentsAddDialogController.prototype.saveVerifyFile = function () {
            this.deploymentData = angular.copy(this.editableDeploymentData);
            this.deploymentData.editDeploymentFiles = false;
        };
        AppServerDeploymentsAddDialogController.prototype.resetVerifyFile = function () {
            this.editableDeploymentData = angular.copy(this.originalDeploymentData);
        };
        AppServerDeploymentsAddDialogController.prototype.finishDeployWizard = function () {
            this.$log.log('Finished deploy add wizard');
            this.$modalInstance.close('ok');
        };
        /// this is for minification purposes
        AppServerDeploymentsAddDialogController.$inject = ['$rootScope', '$scope', '$q', '$timeout', '$log', 'HawkularOps',
            '$modalInstance', 'NotificationsService', '$routeParams', 'HawkularInventory'];
        return AppServerDeploymentsAddDialogController;
    })();
    HawkularMetrics.AppServerDeploymentsAddDialogController = AppServerDeploymentsAddDialogController;
    HawkularMetrics._module.controller('AppServerDeploymentsAddDialogController', AppServerDeploymentsAddDialogController);
})(HawkularMetrics || (HawkularMetrics = {}));

angular.module("hawkular-console-templates", []).run(["$templateCache", function($templateCache) {$templateCache.put("plugins/accessPortal/html/my_cases.html","<iframe id=\"myCasesWindow\" width=\"100%\" frameborder=\"0\" src=\"/support.html#/case/list\" scrolling=\"auto\"\n        data-ng-controller=\"AccessPortal.AccessPortalMainController as accessPortalMain\">\n</iframe>\n");
$templateCache.put("plugins/accessPortal/html/open_case.html","<iframe id=\"openCaseWindow\" width=\"100%\" frameborder=\"0\" src=\"/support.html#/case/new\" scrolling=\"auto\"\n        data-ng-controller=\"AccessPortal.AccessPortalMainController as accessPortalMain\">\n</iframe>\n");
$templateCache.put("plugins/accessPortal/html/search.html","<iframe id=\"searchWindow\" width=\"100%\" frameborder=\"0\" src=\"/support.html#/search\" scrolling=\"auto\"\n        data-ng-controller=\"AccessPortal.AccessPortalMainController as accessPortalMain\">\n</iframe>\n");
$templateCache.put("plugins/accounts/html/inactivityModal.html","<div class=\"modal-header\">\n  <h3 class=\"modal-title\">Session expired</h3>\n</div>\n<div class=\"modal-body\">\n  Due to inactivity, we had to close your session.\n</div>\n<div class=\"modal-footer\">\n  <button id=\"logoutBtn\" class=\"btn btn-primary\" ng-click=\"userDetails.logout()\">OK</button>\n</div>\n");
$templateCache.put("plugins/accounts/html/organization-accept-invitation.html","<div ng-controller=\"HawkularAccounts.InvitationController as controller\">\n\n  <div class=\"hk-screen-top-nav\">\n    <div class=\"row hk-top-row\" >\n      <div class=\"col-xs-6\" ng-show=\"!controller.loading\">\n        <a data-ng-href=\"/hawkular-ui/organizations\">&laquo; All organizations</a>\n      </div>\n    </div>\n    <div class=\"hk-heading\">\n      <h1 ng-show=\"controller.success\">Invitation for {{controller.invitation.organization.name}}</h1>\n      <h1 ng-show=\"!controller.success\">Invitation</h1>\n    </div>\n  </div>\n\n  <div class=\"text-center hk-spinner-container-alone\" ng-show=\"controller.loading\">\n    <div class=\"spinner spinner-lg\"></div>\n    <p class=\"hk-spinner-legend-below\">Loading...</p>\n  </div>\n\n  <div class=\"blank-slate-pf\" ng-show=\"!controller.loading && controller.success\">\n    <div class=\"blank-slate-pf-icon\">\n      <i class=\"fa fa-users\" id=\"accepted-invitation-icon\"></i>\n    </div>\n    <h1>Invitation accepted</h1>\n    <p>\n      You can now use Hawkular as {{controller.invitation.organization.name}}. To do that, select\n      \'{{controller.invitation.organization.name}}\' in the account switcher.\n    </p>\n  </div>\n\n  <div class=\"blank-slate-pf\" ng-show=\"!controller.loading && !controller.success\">\n    <div class=\"blank-slate-pf-icon\">\n      <i class=\"fa fa-meh-o\" id=\"error-accepted-invitation-icon\"></i>\n    </div>\n    <h1>Something went wrong while processing your invitation.</h1>\n    <p>\n      {{controller.error.data.message}}\n    </p>\n  </div>\n\n</div>\n");
$templateCache.put("plugins/accounts/html/organization-invite.html","<div class=\"modal-header\">\n  <button type=\"button\" class=\"close\" dismiss=\"modal\" aria-label=\"Close\" ng-click=\"inviteModal.cancel()\">\n    <span aria-hidden=\"true\">&times;</span>\n  </button>\n  <h4 class=\"modal-title\">Invite people</h4>\n</div>\n\n<div class=\"modal-body\">\n  <form role=\"form\" name=\"form\" class=\"form-horizontal\">\n    <div class=\"form-group\">\n      <label for=\"emails\" class=\"col-md-4 control-label\">Invite via email</label>\n      <div class=\"col-md-6\">\n        <input type=\"text\"\n               class=\"form-control\"\n               name=\"emails\"\n               id=\"emails\"\n               placeholder=\"Emails, separated by comma or space\"\n               hawkular-emails\n               ng-model=\"inviteModal.invitation.emails\"/>\n          <span class=\"help-block\" ng-show=\"form.emails.$error.emails\">\n            Please enter valid email addresses.\n          </span>\n      </div>\n    </div>\n  </form>\n</div>\n\n<div class=\"modal-footer\">\n  <button type=\"button\" class=\"btn btn-default\" dismiss=\"modal\" ng-click=\"inviteModal.cancel()\"\n          id=\"inviteToOrganizationFormCancelBtn\">\n    Cancel\n  </button>\n  <button type=\"button\"\n          class=\"btn btn-primary\"\n          id=\"inviteToOrganizationFormBtn\"\n          ng-disabled=\"!form.$valid\"\n          ng-click=\"inviteModal.invite()\">\n    Invite\n  </button>\n</div>\n");
$templateCache.put("plugins/accounts/html/organization-memberships.html","<div class=\"hk-organization-memberships\" ng-controller=\"HawkularAccounts.OrganizationMembershipController as controller\">\n\n  <div ng-show=\"!controller.isOrganization\">\n    <div class=\"text-center hk-spinner-container-alone\" ng-show=\"controller.loading\">\n      <div class=\"spinner spinner-lg\"></div>\n      <p class=\"hk-spinner-legend-below\">Loading...</p>\n    </div>\n\n    <div class=\"hk-screen-top-nav\">\n      <div class=\"row hk-top-row\" >\n        <div class=\"col-xs-6\" ng-show=\"!controller.loading\">\n          <a data-ng-href=\"/hawkular-ui/organizations\">&laquo; All organizations</a>\n        </div>\n      </div>\n      <div class=\"hk-heading\">\n        <h1 ng-show=\"!controller.loading\">{{controller.organization.name}} Members</h1>\n      </div>\n    </div>\n\n    <div class=\"text-right\" ng-show=\"controller.memberships.length && !controller.loading && controller.foundOrganization\">\n      <button\n        class=\"btn btn-primary\"\n        type=\"button\"\n        role=\"button\"\n        ng-click=\"controller.showInviteModal()\"\n        ng-show=\"controller.isAllowedToInvite\">\n        Invite People\n      </button>\n    </div>\n\n    <div ng-show=\"!controller.loading && controller.foundOrganization\">\n      <div class=\"blank-slate-pf\" ng-show=\"!controller.memberships.length\">\n        <div class=\"blank-slate-pf-icon\">\n          <i class=\"fa fa-users\"></i>\n        </div>\n        <!--         <h2>No members for this organization (not even you?). Found organization: {{controller.foundOrganization}}</h2> -->\n        <h1>No members.</h1>\n        <button\n          class=\"btn btn-primary\"\n          type=\"button\"\n          role=\"button\"\n          ng-click=\"controller.showInviteModal()\"\n          ng-show=\"controller.isAllowedToInvite\">\n          Invite People\n        </button>\n      </div>\n    </div>\n\n    <div class=\"hk-table-container\" ng-show=\"controller.memberships.length\">\n      <table class=\"table table-bordered hk-table-clean\">\n        <thead>\n        <tr>\n          <th>Name</th>\n          <th>Role</th>\n        </tr>\n        </thead>\n        <tbody>\n        <tr ng-repeat=\"membership in controller.memberships\">\n          <td>{{membership.member.name}}</td>\n          <td>\n            <span ng-show=\"membership.member.id === controller.organization.owner.id\">Owner</span>\n\n          <span ng-show=\"membership.member.id !== controller.organization.owner.id\">\n            <span ng-show=\"controller.isAllowedToChangeRoleOfMembers\">\n              <select\n                ng-model=\"membership.role\"\n                ng-change=\"controller.changeRole(membership)\"\n                ng-options=\"role.name for role in controller.possibleRoles track by role.name\"\n                >\n              </select>\n            </span>\n\n            <span ng-show=\"!controller.isAllowedToChangeRoleOfMembers\">\n              {{membership.role.name}}\n            </span>\n\n            <span ng-show=\"controller.membershipsToUpdate[membership.id] === PersistenceState.PERSISTING\">\n              <i class=\"fa fa-spinner fa-spin\"></i>\n            </span>\n            <span ng-show=\"controller.membershipsToUpdate[membership.id] === PersistenceState.SUCCESS\">\n              <i class=\"fa fa-check\"></i>\n            </span>\n            <span ng-show=\"controller.membershipsToUpdate[membership.id] === PersistenceState.ERROR\">\n              <i class=\"fa fa-exclamation\"></i>\n            </span>\n          </span>\n          </td>\n        </tr>\n        <tr ng-repeat=\"invitation in controller.pending\" ng-show=\"controller.isAllowedToListPending\">\n          <td>{{invitation.email}} <span class=\"label label-default\">INVITED</span></td>\n          <td>{{invitation.role.name}}</td>\n        </tr>\n        </tbody>\n      </table>\n    </div>\n\n    <div class=\"blank-slate-pf\" ng-show=\"!controller.loading && !controller.foundOrganization\">\n      <div class=\"blank-slate-pf-icon\">\n        <i class=\"fa fa-building-o\"></i>\n      </div>\n      <h1>Organization not found.</h1>\n      <p>\n        The requested organization could not be found. You can try to find it in the <a href=\"#\">organizations list</a>.\n      </p>\n    </div>\n  </div>\n\n  <div class=\"blank-slate-pf\" ng-show=\"controller.isOrganization\">\n    <div class=\"blank-slate-pf-icon\">\n      <i class=\"fa fa-building-o\"></i>\n    </div>\n    <h1>Organization management can be done only by users.</h1>\n    <p>\n      To manage this organization, switch from the current organization to your main user account. You can do that\n      by selecting your user at the account switcher, on the top-right corner of the screen.\n    </p>\n  </div>\n<!-- /col -->\n</div>\n");
$templateCache.put("plugins/accounts/html/organization-new.html","<div class=\"modal-header\">\n  <button type=\"button\" class=\"close\" dismiss=\"modal\" aria-label=\"Close\" ng-click=\"newModal.cancel()\">\n    <span aria-hidden=\"true\">&times;</span>\n  </button>\n  <h4 class=\"modal-title\">Create Organization</h4>\n</div>\n\n<div class=\"modal-body\">\n  <form role=\"form\" class=\"form-horizontal\">\n    <div class=\"form-group\">\n      <label for=\"name\" class=\"col-md-4 control-label\">Organization name</label>\n      <div class=\"col-md-6\">\n        <input type=\"text\" class=\"form-control\" id=\"name\" ng-model=\"newModal.organizationNew.name\" autofocus>\n      </div>\n    </div>\n  </form>\n</div>\n\n<div class=\"modal-footer\">\n  <button type=\"button\" class=\"btn btn-default\" dismiss=\"modal\" ng-click=\"newModal.cancel()\">Cancel</button>\n  <button type=\"button\" class=\"btn btn-primary\" ng-click=\"newModal.persist()\">Create</button>\n</div>\n");
$templateCache.put("plugins/accounts/html/organization-remove-modal.html","<div class=\"modal-header\">\n  <button type=\"button\" class=\"close\" ng-click=\"removeModal.cancel()\">\n    <span class=\"pficon pficon-close\"></span>\n  </button>\n  <h4 class=\"modal-title\">Delete Organization</h4>\n</div>\n<div class=\"modal-body\">\n  <div class=\"form-group\">\n    <p class=\"primary-message\">\n      Are you sure you want to delete the organization <strong>{{removeModal.organization.name}}</strong>?\n    </p>\n    <p>This action can\'t be undone.</p>\n  </div>\n</div>\n<div class=\"modal-footer\">\n  <button type=\"button\" class=\"btn btn-default\" ng-click=\"removeModal.cancel()\">Cancel</button>\n  <button type=\"button\" class=\"btn btn-danger\" ng-click=\"removeModal.remove()\">Delete</button>\n</div>\n");
$templateCache.put("plugins/accounts/html/organization-transfer-modal.html","<div class=\"modal-header\">\n  <button type=\"button\" class=\"close\" dismiss=\"modal\" aria-label=\"Close\" ng-click=\"transferModal.cancel()\">\n    <span aria-hidden=\"true\">&times;</span>\n  </button>\n  <h4 class=\"modal-title\">Transfer ownership</h4>\n</div>\n\n<div class=\"modal-body\">\n  Are you sure you want to transfer the ownership of\n  {{transferModal.organization.name}}\n  to\n  {{transferModal.transferTo.name}}?\n</div>\n\n<div class=\"modal-footer\">\n  <button type=\"button\" class=\"btn btn-default\" dismiss=\"modal\" ng-click=\"transferModal.cancel()\"\n          id=\"transferOrgCancelBtn\">\n    Cancel\n  </button>\n  <button type=\"button\" class=\"btn btn-danger\" id=\"transferOrgTransferBtn\" ng-click=\"transferModal.transfer()\">\n    Transfer\n  </button>\n</div>\n");
$templateCache.put("plugins/accounts/html/organizations.html","<div class=\"hk-organizations\" ng-controller=\"HawkularAccounts.OrganizationsController as controller\">\n\n  <div ng-show=\"!controller.isOrganization\">\n    <h1 class=\"text-center\" ng-show=\"!controller.loading\">Organizations</h1>\n\n    <div class=\"text-center hk-spinner-container-alone\" ng-show=\"controller.loading\">\n      <div class=\"spinner spinner-lg\"></div>\n      <p class=\"hk-spinner-legend-below\">Loading...</p>\n    </div>\n\n    <div class=\"blank-slate-pf\" ng-show=\"!controller.organizations.length && !controller.loading\">\n      <div class=\"blank-slate-pf-icon\">\n        <i class=\"fa fa-building-o\"></i>\n      </div>\n      <h1>No organizations created.</h1>\n      <p>\n        With organizations, multiple users can have access to the same resources, with multiple roles.\n      </p>\n      <div class=\"blank-slate-pf-main-action\">\n        <button class=\"btn btn-primary btn-lg\" type=\"button\" role=\"button\" ng-click=\"controller.showCreateForm()\">\n          Create Organization\n        </button>\n      </div>\n    </div>\n\n    <div class=\"text-right\" ng-show=\"controller.organizations.length && !controller.loading\">\n      <button class=\"btn btn-primary\" type=\"button\" role=\"button\" ng-click=\"controller.showCreateForm()\">Create Organization</button>\n    </div>\n    <div class=\"hk-table-container\" ng-show=\"controller.organizations.length && !controller.loading\">\n      <table class=\"table table-bordered hk-table-clean\">\n        <thead>\n        <tr>\n          <th>Name</th>\n          <th></th>\n        </tr>\n        </thead>\n        <tbody>\n        <tr ng-repeat=\"organization in controller.organizations\">\n          <td>\n            <a href=\"/hawkular-ui/organization/{{organization.id}}/memberships\">\n              {{organization.name}}\n            </a>\n          </td>\n          <td class=\"hk-actions-one\">\n            <button type=\"button\"\n                    class=\"btn btn-link\"\n                    tooltip-trigger\n                    tooltip-placement=\"top\"\n                    tooltip=\"Delete\"\n                    ng-click=\"controller.remove(organization)\">\n              <i class=\"fa fa-trash-o\"></i>\n            </button>\n          </td>\n        </tr>\n        </tbody>\n      </table>\n    </div>\n  </div>\n\n  <div class=\"blank-slate-pf\" ng-show=\"controller.isOrganization\">\n    <div class=\"blank-slate-pf-icon\">\n      <i class=\"fa fa-users\"></i>\n    </div>\n    <h1>No organizations inside organization.</h1>\n    <p>\n      It is not possible to have organizations managed by an organization. <br/> To create an organization, switch to your user profile.\n    </p>\n  </div>\n</div>\n");
$templateCache.put("plugins/accounts/html/user-settings.html","<div class=\"hk-user-settings row\" ng-controller=\"HawkularAccounts.UserSettingsController as controller\">\n  <div class=\"col-lg-8 col-lg-offset-2 col-md-10 col-md-offset-1\">\n\n    <div ng-show=\"!controller.isOrganization\">\n\n      <div class=\"text-center hk-spinner-container-alone\" ng-show=\"controller.loading\">\n        <div class=\"spinner spinner-lg\"></div>\n        <p class=\"hk-spinner-legend-below\">Loading...</p>\n      </div>\n\n      <h1 class=\"text-center\" ng-show=\"!controller.loading\">User Settings</h1>\n      <form name=\"form\" class=\"form-horizontal\" ng-show=\"!controller.loading\" novalidate>\n        <fieldset>\n          <legend>Alert Notifications</legend>\n          <p>Receive alert notifications on the following emails.</p>\n          <div class=\"form-group\" ng-class=\"{\'has-error\': form.email.$error.emails}\">\n            <label class=\"col-sm-3 control-label\" for=\"email\">Emails</label>\n            <div class=\"col-sm-6\">\n              <input\n                type=\"text\"\n                name=\"email\"\n                id=\"email\"\n                class=\"form-control\"\n                placeholder=\"Multiple emails separated by comma\"\n                hawkular-emails\n                ng-model=\"controller.settings[\'hawkular.settings.emails\']\">\n            <span class=\"help-block\" ng-show=\"form.email.$error.emails\">\n              Please enter valid email addresses.\n            </span>\n\n            <span class=\"help-block hk-success\" ng-show=\"!form.email.$error.emails\">\n              Emails are valid.\n            </span>\n            </div>\n          </div>\n        </fieldset>\n        <div class=\"form-actions text-right\" ng-show=\"!controller.loading\">\n          <button type=\"button\" class=\"btn btn-primary\" ng-disabled=\"!form.$valid\" ng-click=\"controller.save()\">\n            Save\n          </button>\n        </div>\n      </form>\n    </div>\n\n    <div class=\"blank-slate-pf\" ng-show=\"controller.isOrganization\">\n      <div class=\"blank-slate-pf-icon\">\n        <i class=\"fa fa-users\"></i>\n      </div>\n      <h1>User settings are for users only.</h1>\n      <p>\n        To change your user settings, switch from the current organization to your main user account. You can do that\n        by selecting your user at the account switcher, on the top-right corner of the screen.\n      </p>\n    </div>\n  </div>\n</div>");
$templateCache.put("plugins/topology/html/index.html","<div class=\"hk-application-servers\" data-ng-controller=\"HawkularTopology.TopologyController as vm\">\n\n  <div class=\"text-center hk-urls-list hk-spinner-container hawkular-topology-spinner\" ng-hide=\"vm.data.relations.length\">\n    <div class=\"spinner spinner-lg\"></div>\n    <p class=\"hk-spinner-legend-below\">Loading...</p>\n  </div>\n  <div ng-class=\"{\'hk-fade-in\': vm.data.relations.length}\">\n\n    <hawkular-topology-graph items=\"vm.data.items\" relations=\"vm.data.relations\" kinds=\"vm.kinds\">\n    </hawkular-topology-graph>\n\n    <div class=\"controls\">\n      <label id=\"selected\"></label>\n      <!--<button ng-click=\"vm.poke()\" >Random Data</button>-->\n      <!--<button ng-click=\"vm.testClick()\">test</button>-->\n\n       <div class=\"iconWithLabel\">\n         <hawkular-topology-icon kind=\"Server\">\n           <svg class=\"hawkular-topology\">\n             <use xlink:href=\"#vertex-Server\" x=\"15\" y=\"15\"></use>\n           </svg>\n         </hawkular-topology-icon>\n         <label>Servers</label>\n         <br/>\n       </div>\n\n       <div class=\"iconWithLabel\">\n         <hawkular-topology-icon kind=\"App\">\n           <svg class=\"hawkular-topology\">\n             <use xlink:href=\"#vertex-App\" x=\"15\" y=\"15\"></use>\n           </svg>\n         </hawkular-topology-icon>\n         <label>Apps</label>\n         <br/>\n       </div>\n\n       <!--<hawkular-topology-icon kind=\"Database\">\n         <svg class=\"hawkular-topology\">\n           <use xlink:href=\"#vertex-Database\" x=\"15\" y=\"15\"></use>\n         </svg>\n       </hawkular-topology-icon>\n       <label>Databases</label>-->\n\n       <div class=\"iconWithLabel\">\n         <hawkular-topology-icon kind=\"DataSource\">\n           <svg class=\"hawkular-topology\">\n             <use xlink:href=\"#vertex-DataSource\" x=\"15\" y=\"15\"></use>\n           </svg>\n         </hawkular-topology-icon>\n         <label>Datasources</label>\n         <br/>\n       </div>\n    </div>\n\n    <svg class=\"hawkular-topology\" hidden>\n      <defs><!--\n        <g class=\"Database\" id=\"vertex-Database\">\n          <circle r=\"15\"></circle>\n          <text y=\"6\">&#xf1c0;</text>\n        </g>-->\n        <g class=\"Server\" id=\"vertex-Server\">\n          <circle r=\"15\"></circle>\n          <!-- <text y=\"6\" x=\"0.5\">&#xf233;</text> -->\n          <text y=\"6\" x=\"0.5\">&#xf233;</text>\n        </g>\n        <g class=\"App\" id=\"vertex-App\">\n          <circle r=\"15\"></circle>\n          <!-- <text y=\"10\" x=\"1\">&#xf135;</text> -->\n          <text y=\"7\" x=\"0\">&#xf135;</text>\n        </g>\n        <g class=\"DataSource\" id=\"vertex-DataSource\">\n          <circle r=\"15\"></circle>\n          <!-- <text y=\"7.5\">&#xf0ec;</text> -->\n          <text y=\"5\">&#xf1c0;</text>\n        </g>\n      </defs>\n    </svg>\n    </div>\n</div>");
$templateCache.put("plugins/metrics/html/alerts-center-detail.html","<div class=\"hk-alert-center-detail\">\n\n  <div class=\"hk-screen-top-nav\">\n    <div class=\"container\">\n      <div class=\"row hk-top-row\">\n        <div class=\"col-xs-6\">\n          <a href=\"/hawkular-ui/alerts-center\" class=\"back\">&laquo; All Alerts</a>\n        </div>\n      </div>\n      <div class=\"hk-heading\">\n        <h1>Alert Details</h1>\n      </div>\n    </div>\n  </div>\n\n  <div class=\"container\">\n\n    <div class=\"row\">\n      <div class=\"col-md-9\">\n        <div class=\"panel panel-default clearfix\">\n          <div class=\"panel-heading\">\n            <h2>{{acd.description | characters: 55}}</h2>\n          </div>\n          <div class=\"panel-body\">\n            <form class=\"form-horizontal\">\n              <fieldset>\n                <div class=\"form-group\">\n                  <label class=\"col-sm-2 control-label\" for=\"status\">State</label>\n                  <div class=\"col-sm-6\">\n                    <select pf-select ng-model=\"acd.status\" id=\"status\">\n                      <option ng-repeat=\"status in acd.statuses\" value=\"{{status}}\">{{status | firstUpper}}</option>\n                    </select>\n                  </div>\n                </div>\n                <div class=\"form-group\">\n                  <label class=\"col-sm-2 control-label\">Severity</label>\n                  <div class=\"col-sm-10\">\n                    <span class=\"hk-input-text\">{{acd.detailAlert.severity | firstUpper}}</span>\n                  </div>\n                </div>\n                <div class=\"form-group\">\n                  <label class=\"col-sm-2 control-label\">Description\n                    <a class=\"hk-btn-icon\"><i tooltip=\"Trigger description\" tooltip-trigger tooltip-placement=\"top\" class=\"fa fa-info-circle\"></i></a>\n                  </label>\n                  <div class=\"col-sm-10\">\n                    <span class=\"hk-input-text\">{{acd.description}}</span>\n                  </div>\n                </div>\n                <div class=\"form-group\">\n                  <label class=\"col-sm-2 control-label\">Created</label>\n                  <div class=\"col-sm-10\">\n                    <span class=\"hk-input-text\">{{acd.detailAlert.ctime | date:\'d MMM yyyy, HH:mm\'}}</span>\n                  </div>\n                </div>\n                <div class=\"form-group\">\n                  <label class=\"col-sm-2 control-label\">Resource Path\n                    <a class=\"hk-btn-icon\"><i tooltip=\"e = environment, f = feed, r = the resource id\" tooltip-trigger tooltip-placement=\"top\" class=\"fa fa-info-circle\"></i></a>\n                  </label>\n                  <div class=\"col-sm-10\">\n                    <span class=\"hk-input-text\">{{acd.detailAlert.context.resourcePath}}</span>\n                  </div>\n                </div>\n                <div class=\"form-group\">\n                  <label class=\"col-sm-2 control-label\">Feed Id</label>\n                  <div class=\"col-sm-10\">\n                    <span class=\"hk-input-text\">{{acd.feedId}}</span>\n                  </div>\n                </div>\n                <div class=\"form-group\">\n                  <label class=\"col-sm-2 control-label\">Comments</label>\n                  <div class=\"col-sm-10\">\n                    <ul class=\"hk-comment-list\">\n                      <li ng-repeat=\"note in acd.detailAlert.notes\">\n                        <span class=\"pficon pficon-user\"></span>\n                        <span class=\"hk-author\">{{note.user}}</span>\n                        <span class=\"hk-date\">{{note.ctime | date:\'d MMM yyyy, HH:mm\'}}</span>\n                        <p>{{note.text}}</p>\n                      </li>\n                    </ul>\n                    <textarea class=\"form-control\" rows=\"2\" ng-model=\"acd.comments\" placeholder=\"Add a comment...\"></textarea>\n                  </div>\n                </div>\n                <div class=\"form-actions\">\n                  <button class=\"btn btn-default\" type=\"button\" ng-click=\"acd.save()\">Comment</button>\n                </div>\n              </fieldset>\n            </form>\n          </div>\n        </div>\n      </div>\n\n      <div class=\"col-md-3\">\n        <div class=\"panel panel-default clearfix\" ng-show=\"acd.actionsHistory.length > 0\">\n          <div class=\"panel-heading\">\n            <h2>Notifications</h2>\n          </div>\n          <div class=\"panel-body\">\n            <div class=\"hk-box-v-item\" ng-repeat=\"action in acd.actionsHistory\">\n              <div class=\"hk-display-table\">\n                <div class=\"hk-icon-container\">\n                  <i class=\"fa fa-envelope-o\"></i>\n                </div>\n                <div class=\"hk-info-container\">\n                  <div class=\"hk-info-heading\">{{action.actionId}}</div>\n                  <p class=\"hk-info-info\">{{action.actionPlugin | firstUpper}}</p>\n                  <p class=\"hk-info-info\">{{action.alert.status | firstUpper}}</p>\n                  <p class=\"hk-info-info\">{{action.ctime | date:\'d MMM yyyy, HH:mm\'}}</p>\n                </div>\n              </div>\n            </div>\n          </div>\n        </div>\n      </div>\n\n    </div>\n\n  </div>\n\n</div>\n");
$templateCache.put("plugins/metrics/html/alerts-center-list.html","<div class=\"hk-screen-content\">\n  <hawkular-subtab ng-controller=\"Subtab.SubtabController\">\n    <div class=\"hk-nav-tabs-container\">\n      <ul class=\"nav nav-tabs nav-tabs-pf\">\n        <li class=\"active\"><a href=\"/hawkular-ui/alerts-center\" class=\"hk-alerts\">Alerts</a></li>\n        <li><a href=\"/hawkular-ui/alerts-center-triggers\" class=\"hk-availability\">Definitions</a></li>\n      </ul>\n    </div>\n  </hawkular-subtab>\n\n  <div class=\"hk-alert-center\">\n\n    <!-- No Alerts -->\n    <div ng-show=\"ac.alertsList.length === 0\">\n      <div class=\"hk-info-top clearfix\">\n        <h3>Alerts ({{ac.alertsList.length}})</h3>\n      </div>\n      <div class=\"checkbox\">\n        <label>\n          <input type=\"checkbox\" ng-model=\"ac.hasResolvedAlerts\" ng-change=\"ac.changeResolvedFilter()\"> Display Resolved Alerts\n        </label>\n      </div>\n      <div class=\"blank-slate-pf\">\n        <div class=\"blank-slate-pf-icon\">\n          <i class=\"fa fa-flag\"></i>\n        </div>\n        <h1>No Alerts.</h1>\n      </div>\n    </div>\n\n    <div ng-show=\"ac.alertsList.length > 0\">\n\n      <div class=\"hk-info-top clearfix\">\n        <h3 class=\"pull-left\">Alerts ({{ac.headerLinks.total}})</h3>\n      <span class=\"hk-update pull-right\" data-toggle=\"tooltip\" data-placement=\"top\" title=\"Last update\">\n        <i class=\"fa fa-clock-o\" ng-click=\"ac.getAlerts()\"></i>{{ac.lastUpdateDate | date:\'HH:mm\'}}</span>\n      </div>\n\n      <div class=\"hk-table-container\">\n        <div class=\"hk-actions-table\">\n          <div class=\"dropdown\">\n            <a href=\"#\" class=\"btn btn-default\" dropdown-toggle>\n              Change State <b class=\"caret\"></b>\n            </a>\n            <ul class=\"dropdown-menu dropdown-menu-right\">\n              <li><a href=\"#\" ng-click=\"ac.ackSelected()\" ng-disabled=\"!ac.hasOpenSelectedItems || ac.isWorking\">Acknowledge</a></li>\n              <li><a href=\"#\" ng-click=\"ac.resolveSelected()\" ng-disabled=\"ac.selectCount < 1 || ac.isWorking || ac.hasResolvedItems()\">Resolve</a></li>\n            </ul>\n          </div>\n        </div>\n        <div class=\"dataTables_header\">\n          <div id=\"DataTables_Table_0_filter\" class=\"dataTables_filter\">\n            <label><input type=\"search\" ng-model=\"ac.search\" aria-controls=\"DataTables_Table_0\"></label>\n          </div>\n          <div class=\"hk-actions-table-search\">\n            <div class=\"checkbox\">\n              <label>\n                <input type=\"checkbox\" ng-model=\"ac.hasResolvedAlerts\" ng-change=\"ac.changeResolvedFilter()\"> Display Resolved Alerts\n              </label>\n            </div>\n          </div>\n          <div class=\"dataTables_info\" id=\"DataTables_Table_0_info\" role=\"status\" aria-live=\"polite\">Showing <b>1</b> to <b>{{(ac.alertsList | filter:ac.search).length}}</b> of <b>{{ac.alertsList.length}}</b> Items</div>\n        </div>\n        <table class=\"datatable table table-bordered hk-table-alerts hk-table-detailed hk-table-select\">\n          <thead>\n          <tr>\n            <th ng-click=\"ac.selectAll()\"><input type=\"checkbox\"/></th>\n            <th ng-class=\"{\'sorting_asc\': ac.sortField == \'status\' && ac.sortAsc, \'sorting_desc\': ac.sortField == \'status\' && !ac.sortAsc, \'sorting\': ac.sortField != \'status\'}\" ng-click=\"ac.sortBy(\'status\')\">State</th>\n            <th ng-class=\"{\'sorting_asc\': ac.sortField == \'severity\' && ac.sortAsc, \'sorting_desc\': ac.sortField == \'severity\' && !ac.sortAsc, \'sorting\': ac.sortField != \'severity\'}\" ng-click=\"ac.sortBy(\'severity\')\">Severity</th>\n            <th ng-class=\"{\'sorting_asc\': ac.sortField == \'context.description\' && ac.sortAsc, \'sorting_desc\': ac.sortField == \'context.description\' && !ac.sortAsc, \'sorting\': ac.sortField != \'context.description\'}\" ng-click=\"ac.sortBy(\'context.description\')\">Description</th>\n            <th ng-class=\"{\'sorting_asc\': ac.sortField == \'ctime\' && ac.sortAsc, \'sorting_desc\': ac.sortField == \'ctime\' && !ac.sortAsc, \'sorting\': ac.sortField != \'ctime\'}\" ng-click=\"ac.sortBy(\'ctime\')\" ng-click=\"ac.sortBy(\'ctime\')\">Created</th>\n            <th ng-class=\"{\'sorting_asc\': ac.sortField == \'context.resourcePath\' && ac.sortAsc, \'sorting_desc\': ac.sortField == \'context.resourcePath\' && !ac.sortAsc, \'sorting\': ac.sortField != \'context.resourcePath\'}\" ng-click=\"ac.sortBy(\'context.resourcePath\')\">Resource Path</th>\n            <th></th>\n          </tr>\n          </thead>\n          <tbody>\n          <tr ng-repeat=\"alert in ac.alertsList | filter:ac.search\" ng-class=\"{\'hk-selected\': ac.selected}\"\n              ng-click=\"ac.selectItem(alert)\">\n            <td><input type=\"checkbox\" ng-checked=\"alert.selected\"/></td>\n            <td ng-class=\"{\'hk-bold\': alert.status === \'OPEN\'}\" class=\"text-nowrap\">{{alert.status|firstUpper}} <i ng-show=\"(alert.notes.length > 0)\" class=\"fa fa-comment-o\" tooltip=\"With comments\" tooltip-trigger tooltip-placement=\"top\"></i></td>\n            <td>{{alert.severity|firstUpper}}</td>\n            <td>{{alert.trigger.description| characters: 50}}</td>\n            <td>{{alert.ctime | date:\'d MMM yyyy, HH:mm\'}}</td>\n            <td>{{alert.context.resourcePath | truncate: 30}}</td>\n            <td><a class=\"btn btn-link\"><i class=\"fa fa-chevron-circle-right fa-lg\"\n                                           tooltip=\"View Details\" tooltip-trigger tooltip-placement=\"top\"\n                                           ng-click=\"ac.showDetailPage(alert.alertId)\">\n            </i></a>\n            </td>\n          </tr>\n          </tbody>\n        </table>\n        <div class=\"dataTables_footer\">\n          <hk-data-pagination resource-list=\"ac.alertsList\" current-page=\"ac.alertsCurPage\"\n                              page-setter=\"ac.setPage(pageNumber)\"\n                              per-page=\"ac.alertsPerPage\" headers=\"ac.headerLinks\"></hk-data-pagination>\n        </div>\n      </div>\n\n    </div>\n  </div>\n\n</div>\n");
$templateCache.put("plugins/metrics/html/alerts-center-triggers.html","<div class=\"hk-screen-content\">\n  <hawkular-subtab ng-controller=\"Subtab.SubtabController\">\n    <div class=\"hk-nav-tabs-container\">\n      <ul class=\"nav nav-tabs nav-tabs-pf\">\n        <li><a href=\"/hawkular-ui/alerts-center\" class=\"hk-alerts\">Alerts</a></li>\n        <li class=\"active\"><a href=\"/hawkular-ui/alerts-center-triggers\" class=\"hk-alerts\">Definitions</a></li>\n      </ul>\n    </div>\n  </hawkular-subtab>\n\n  <div class=\"hk-alert-center\">\n\n    <!-- No Triggers -->\n    <div ng-show=\"act.triggersList.length === 0\">\n      <div class=\"hk-info-top clearfix\">\n        <h3>Triggers ({{act.triggersList.length}})</h3>\n      </div>\n      <div class=\"blank-slate-pf\">\n        <div class=\"blank-slate-pf-icon\">\n          <i class=\"fa fa-flag\"></i>\n        </div>\n        <h1>No Triggers.</h1>\n      </div>\n    </div>\n\n    <div ng-show=\"act.triggersList.length > 0\">\n\n      <div class=\"hk-info-top clearfix\">\n        <h3 class=\"pull-left\">Triggers ({{act.headerLinks.total}})</h3>\n      <span class=\"hk-update pull-right\" data-toggle=\"tooltip\" data-placement=\"top\" title=\"Last update\">\n        <i class=\"fa fa-clock-o\" ng-click=\"act.getTriggers()\"></i>{{act.lastUpdateDate | date:\'HH:mm\'}}</span>\n      </div>\n\n      <div class=\"hk-table-container\">\n        <div class=\"hk-actions-table\">\n          <div class=\"dropdown\">\n            <a href=\"#\" class=\"btn btn-default\" dropdown-toggle>\n              Change State <b class=\"caret\"></b>\n            </a>\n            <ul class=\"dropdown-menu\">\n              <li><a href=\"#\" ng-click=\"act.enableSelected()\" ng-disabled=\"!act.hasDisabledSelectedItems || act.isWorking\">Enable</a></li>\n              <li><a href=\"#\" ng-click=\"act.disableSelected()\" ng-disabled=\"!act.hasEnabledSelectedItems || act.isWorking\">Disable</a></li>\n            </ul>\n          </div>\n        </div>\n        <div class=\"dataTables_header\">\n          <div id=\"DataTables_Table_0_filter\" class=\"dataTables_filter\">\n            <label><input type=\"search\" ng-model=\"act.search\" aria-controls=\"DataTables_Table_0\"></label>\n          </div>\n          <div class=\"dataTables_info\" id=\"DataTables_Table_0_info\" role=\"status\" aria-live=\"polite\">Showing <b>1</b> to <b>{{(act.triggersList | filter:act.search).length}}</b> of <b>{{act.triggersList.length}}</b> Items</div>\n        </div>\n        <table class=\"datatable table table-bordered hk-table-alerts hk-table-detailed hk-table-select\">\n          <thead>\n          <tr>\n            <th ng-click=\"act.selectAll()\"><input type=\"checkbox\"/></th>\n            <th ng-class=\"{\'sorting_asc\': act.sortField == \'name\' && act.sortAsc, \'sorting_desc\': act.sortField == \'name\' && !act.sortAsc, \'sorting\': act.sortField != \'name\'}\" ng-click=\"act.sortBy(\'name\')\">Name</th>\n            <th ng-class=\"{\'sorting_asc\': act.sortField == \'description\' && act.sortAsc, \'sorting_desc\': act.sortField == \'description\' && !act.sortAsc, \'sorting\': act.sortField != \'description\'}\" ng-click=\"act.sortBy(\'description\')\">Description</th>\n            <th ng-class=\"{\'sorting_asc\': act.sortField == \'context.resourceName\' && act.sortAsc, \'sorting_desc\': act.sortField == \'context.resourceName\' && !act.sortAsc, \'sorting\': act.sortField != \'context.resourceName\'}\" ng-click=\"act.sortBy(\'context.resourceName\')\">Resource</th>\n            <th ng-class=\"{\'sorting_asc\': act.sortField == \'severity\' && act.sortAsc, \'sorting_desc\': act.sortField == \'severity\' && !act.sortAsc, \'sorting\': act.sortField != \'severity\'}\" ng-click=\"act.sortBy(\'severity\')\" ng-click=\"act.sortBy(\'severity\')\">Severity</th>\n            <th ng-class=\"{\'sorting_asc\': act.sortField == \'enabled\' && act.sortAsc, \'sorting_desc\': act.sortField == \'enabled\' && !act.sortAsc, \'sorting\': act.sortField != \'enabled\'}\" ng-click=\"act.sortBy(\'enabled\')\" ng-click=\"act.sortBy(\'enabled\')\">Enabled</th>\n            <th ng-class=\"{\'sorting_asc\': act.sortField == \'notifications\' && act.sortAsc, \'sorting_desc\': act.sortField == \'notifications\' && !act.sortAsc, \'sorting\': act.sortField != \'notifications\'}\" ng-click=\"act.sortBy(\'notifications\')\" ng-click=\"act.sortBy(\'notifications\')\">Notifications</th>\n            <th></th>\n          </tr>\n          </thead>\n          <tbody>\n          <tr ng-repeat=\"trigger in act.triggersList | filter:act.search\" ng-class=\"{\'hk-selected\': act.selected}\"\n              ng-click=\"act.selectItem(trigger)\">\n            <td><input type=\"checkbox\" ng-checked=\"trigger.selected\"/></td>\n            <td>{{trigger.name}}</td>\n            <td>{{trigger.description}}</td>\n            <td>{{trigger.context.resourceName|truncate: 30}}</td>\n            <td>{{trigger.severity|firstUpper}}</td>\n            <td>{{trigger.enabled ? \"True\" : \"False\"}}</td>\n            <td>{{trigger.actions.email.length}} <i class=\"fa fa-envelope\"></i></td>\n            <td><a class=\"btn btn-link\"><i class=\"fa fa-chevron-circle-right fa-lg\"\n                                           tooltip=\"View Details\" tooltip-trigger tooltip-placement=\"top\"\n                                           ng-click=\"act.showDetailPage(trigger.id)\">\n            </i></a>\n            </td>\n          </tr>\n          </tbody>\n        </table>\n        <div class=\"dataTables_footer\">\n          <hk-data-pagination resource-list=\"act.triggersList\" current-page=\"act.triggersCurPage\"\n                              page-setter=\"act.setPage(pageNumber)\"\n                              per-page=\"act.triggersPerPage\" headers=\"act.headerLinks\"></hk-data-pagination>\n        </div>\n      </div>\n\n    </div>\n  </div>\n\n</div>\n");
$templateCache.put("plugins/metrics/html/app-server-list.html","<div class=\"hk-application-servers\" ng-controller=\"AppServerListController as vm\">\n\n  <div class=\"text-center hk-urls-list hk-spinner-container\" ng-hide=\"vm.resourceList\">\n    <div class=\"spinner spinner-lg\"></div>\n    <p class=\"hk-spinner-legend-below\">Loading...</p>\n  </div>\n\n  <div ng-show=\"vm.resourceList\" ng-class=\"{\'hk-fade-in\': vm.resourceList}\">\n    <h1 class=\"text-center\">{{userDetails.firstName}}\'s application servers</h1>\n\n    <h3 class=\"pull-left\">Current Status</h3>\n    <span class=\"hk-update pull-right\" tooltip-trigger tooltip-placement=\"top\" tooltip=\"Last update\"><i class=\"fa fa-clock-o\"></i>{{vm.lastUpdateTimestamp | date:\'HH:mm:ss\'}}</span>\n\n    <div class=\"panel panel-default hk-summary\">\n      <div class=\"row\">\n        <!--\n        <div class=\"col-sm-2 hk-summary-item\">\n          <span class=\"hk-data\">0 <i class=\"fa fa-flag\" ng-show=\"alertsNumTBD > 0\"></i></span>\n          <span class=\"hk-item\">Alerts</span>\n        </div>\n        -->\n        <div class=\"col-sm-2 hk-summary-item\">\n          <span class=\"hk-data\">{{vm.resourceList.length}}</span>\n          <span class=\"hk-item\">Servers</span>\n        </div>\n        <div class=\"col-sm-2 hk-summary-item\">\n          <a href=\"#\">\n            <span class=\"hk-data\">{{(vm.resourceList|filter:{state: \'up\'}:true).length}} <i class=\"fa fa-arrow-up\"></i></span>\n            <span class=\"hk-item\">Up</span>\n          </a>\n        </div>\n        <div class=\"col-sm-2 hk-summary-item\">\n          <a href=\"#\">\n            <span class=\"hk-data\">{{(vm.resourceList|filter:{state: \'down\'}:true).length}} <i class=\"fa fa-arrow-down\"></i></span>\n            <span class=\"hk-item\">Down</span>\n          </a>\n        </div>\n        <div class=\"col-sm-2 hk-summary-item\">\n          <a href=\"#\">\n            <span class=\"hk-data\">{{(vm.resourceList|filter:{state: \'unknown\'}:true).length}} <i class=\"fa fa-chain-broken\"></i></span>\n            <span class=\"hk-item\">Unknown</span>\n          </a>\n        </div>\n        <div class=\"col-sm-2 hk-summary-item\">\n          <a href=\"#\">\n            <span class=\"hk-data\">{{(vm.resourceList|filter:{state: \'starting\'}:true).length}} <i class=\"fa fa-spinner\"></i></span>\n            <span class=\"hk-item\">Starting</span>\n          </a>\n        </div>\n        <div class=\"col-sm-2 hk-summary-item\">\n          <a href=\"#\">\n            <span class=\"hk-data\">{{(vm.resourceList|filter:{state: \'restart required\'}:true).length}} <i class=\"fa fa-repeat\"></i></span>\n            <span class=\"hk-item\">Restart Required</span>\n          </a>\n        </div>\n      </div>\n    </div>\n\n    <h3>Application Servers ({{vm.resourceList.length}})</h3>\n\n    <div class=\"blank-slate-pf\" ng-show=\"vm.resourceList.$resolved && vm.resourceList.length === 0\">\n      <div class=\"blank-slate-pf-icon\">\n        <i class=\"fa fa-server\"></i>\n      </div>\n      <h1>No application servers set up.</h1>\n    </div>\n\n    <div ng-show=\"vm.resourceList.length > 0\">\n      <div class=\"dataTables_header\"><div id=\"DataTables_Table_0_filter\" class=\"dataTables_filter\"><label><input type=\"search\" ng-model=\"vm.search\" aria-controls=\"DataTables_Table_0\"></label></div>\n\n      <div class=\"dataTables_info\" id=\"DataTables_Table_0_info\" role=\"status\" aria-live=\"polite\">Showing <b>1</b> to <b>{{(vm.resourceList | filter:vm.search).length}}</b> of <b>{{vm.resourceList.length}}</b> Items</div></div>\n      <table class=\"datatable table table-striped table-bordered\" ng-show=\"vm.resourceList.length > 0\">\n        <thead>\n          <tr>\n            <th>State</th>\n            <th>Application Server Name <span class=\"label label-default label-alert pull-right\" ng-show=\"alertsNumTBD > 0\" tooltip-trigger tooltip-placement=\"top\" tooltip=\"Total alerts\">{{alertsNumTBD}}</span></th>\n            <th>Bound Address</th>\n            <th>Type</th>\n            <th>Host</th>\n            <!-- <th>Custom Tags</th> -->\n          </tr>\n        </thead>\n        <tbody>\n          <tr class=\"odd\"><td valign=\"top\" colspan=\"5\" class=\"dataTables_empty\" ng-show=\"vm.search && (vm.resourceList | filter:vm.search).length === 0\"><p>Suggestions</p><ul><li>Check the syntax of the search term.</li><li>Check that the correct menu option is chosen (token ID vs. user ID).</li><li>Use wildcards (* to match zero or more characters or ? to match a single character).</li><li>Clear the search field, then click Search to return to the 20 most recent records.</li></ul></td></tr>\n          <tr ng-repeat=\"res in vm.resourceList | filter:vm.search | orderBy:\'properties.url\':vm.reverse\">\n            <td class=\"state\">\n              <i class=\"fa fa-arrow-up\" ng-show=\"res.state === \'up\'\"></i>\n              <i class=\"fa fa-arrow-down\" ng-show=\"res.state === \'down\'\"></i>\n              <i class=\"fa fa-chain-broken\" ng-show=\"res.state === \'unknown\'\"></i>\n              <i class=\"fa fa-spinner fa-spin\" ng-show=\"res.state === \'starting\'\"></i>\n              <i class=\"fa fa-repeat\" ng-show=\"res.state === \'restart required\'\"></i>\n              <p ng-hide=\"res.state\"><span class=\"spinner spinner-sm spinner-inline\"></span> <span class=\"fetching\">Fetching state...</span></p>\n              {{res.state | firstUpper}}\n            </td>\n            <td><a href=\"/hawkular-ui/app/app-details/{{res.id | limitTo : res.id.length-2}}/jvm\">{{res.id | limitTo : res.id.length-2}}</a> <a href=\"/hawkular-ui/app/app-details/{{res.id}}/jvm\" class=\"pull-right\"><span class=\"label label-danger label-alert\" tooltip-trigger tooltip-placement=\"top\" tooltip=\"Server alerts\" ng-show=\"res.alerts.length > 0\">{{res.alerts.length}}</span></a></td>\n            <td>{{ res.resourceConfiguration.value[\'Bound Address\'] || \'n/a\' }}</td>\n            <td>{{ res.type.id }}</td>\n            <td>{{ res.resourceConfiguration.value[\'Hostname\'] || \'n/a\'}}</td>\n            <!-- <td class=\"center\"><span class=\"label label-primary\" ng-repeat=\"tag in res.tags\">{{tag}}</span><span ng-hide=\"res.tags.length > 0\">--</span></td> -->\n          </tr>\n        </tbody>\n      </table>\n      <div class=\"dataTables_footer\">\n        <hk-data-pagination resource-list=\"vm.resourceList\" current-page=\"vm.resCurPage\" page-setter=\"vm.setPage(pageNumber)\"\n                       per-page=\"vm.resPerPage\" headers=\"vm.headerLinks\"></hk-data-pagination>\n      </div>\n    </div>\n  </div>\n</div>\n");
$templateCache.put("plugins/metrics/html/data-pagination.html","<div class=\"dataTables_paginate paging_bootstrap_input\" id=\"DataTables_Table_0_paginate\">\n  <ul class=\"pagination\">\n    <li ng-class=\"{disabled: pagesNumber === 1}\" class=\"first\" ng-click=\"goToFirst()\"><span class=\"i fa fa-angle-double-left\"></span></li>\n    <li ng-class=\"{disabled: pagesNumber === 1}\" class=\"prev\" ng-click=\"setPage(currentPage - 1)\"><span class=\"i fa fa-angle-left\"></span></li>\n  </ul>\n  <div class=\"pagination-input\">\n    <form ng-submit=\"setPage(currentPageView - 1)\">\n      <input type=\"text\" class=\"paginate_input\" ng-model=\"currentPageView\">\n    <span class=\"paginate_of\">of <b>{{goTos.length}}</b></span>\n    </form>\n  </div>\n  <ul class=\"pagination\">\n    <li ng-class=\"{disabled: pagesNumber === 1}\" class=\"next\" ng-click=\"setPage(currentPage + 1)\"><span class=\"i fa fa-angle-right\"></span></li>\n    <li ng-class=\"{disabled: pagesNumber === 1}\" class=\"last\" ng-click=\"goToLast()\"><span class=\"i fa fa-angle-double-right\"></span></li>\n  </ul>\n</div>");
$templateCache.put("plugins/metrics/html/url-alerts.html","<div class=\"hk-screen-content\" ng-controller=\"MetricsAlertController as mac\">\n  <hawkular-subtab ng-controller=\"Subtab.SubtabController\">\n    <div class=\"hk-nav-tabs-container\">\n      <ul class=\"nav nav-tabs nav-tabs-pf\">\n        <li class=\"active\"><a href=\"/hawkular-ui/url/alerts/{{mac.$routeParams.resourceId}}/{{mac.$routeParams.timeOffset}}\" class=\"hk-alerts\">All Alerts</a></li>\n        <li><a href=\"/hawkular-ui/url/availability/{{mac.$routeParams.resourceId}}/{{mac.$routeParams.timeOffset}}\" class=\"hk-availability\">Availability</a></li>\n        <li><a href=\"/hawkular-ui/url/response-time/{{mac.$routeParams.resourceId}}/{{mac.$routeParams.timeOffset}}\" class=\"hk-response-time\">Response Time</a></li>\n      </ul>\n    </div>\n  </hawkular-subtab>\n\n  <section id=\"hk-alerts\" class=\"hk-tab-content\">\n    <div class=\"hk-info-top clearfix\">\n      <h3 class=\"pull-left\">Alerts <span>({{(mac.alertList).length}})</span></h3>\n      <span class=\"hk-settings pull-left\">\n        <a href=\"#\" ng-click=\"mac.openResponseSetup()\"><i class=\"fa fa-cog\"></i>Response Time Alert Settings</a>\n        <a href=\"#\" ng-controller=\"MetricsAvailabilityController as vm\" ng-click=\"vm.openAvailabilitySetup()\">\n          <i class=\"fa fa-cog\"></i>Availability Alert Settings</a>\n      </span>\n    </div>\n    <div ng-include=\"\'plugins/metrics/html/partials/url-alerts-view.html\'\"></div>\n  </section>\n</div>\n");
$templateCache.put("plugins/metrics/html/url-availability.html","<div class=\"hk-screen-content\" ng-controller=\"MetricsAvailabilityController as vm\">\n  <hawkular-subtab ng-controller=\"Subtab.SubtabController\">\n    <div class=\"hk-nav-tabs-container\">\n      <ul class=\"nav nav-tabs nav-tabs-pf\">\n        <li><a href=\"/hawkular-ui/url/alerts/{{vm.$routeParams.resourceId}}/{{vm.$routeParams.timeOffset}}\"\n               class=\"hk-alerts\">All Alerts</a></li>\n        <li class=\"active\"><a\n          href=\"/hawkular-ui/url/availability/{{vm.$routeParams.resourceId}}/{{vm.$routeParams.timeOffset}}\"\n          class=\"hk-availability\">Availability</a></li>\n        <li><a href=\"/hawkular-ui/url/response-time/{{vm.$routeParams.resourceId}}/{{vm.$routeParams.timeOffset}}\"\n               class=\"hk-response-time\">Response Time</a></li>\n      </ul>\n    </div>\n  </hawkular-subtab>\n\n  <section id=\"hk-availability\" class=\"hk-tab-content\">\n\n    <hk-alert-notification></hk-alert-notification>\n\n    <!-- Summary -->\n    <h3 class=\"pull-left\">Availability Status</h3>\n    <span class=\"hk-update pull-right\" tooltip-trigger tooltip-placement=\"top\" tooltip=\"Last update\"><i\n      class=\"fa fa-clock-o\"></i>{{vm.endTimeStamp | date:\'HH:mm:ss\'}}</span>\n\n    <div class=\"panel panel-default hk-summary\">\n      <div class=\"row\">\n        <div class=\"col-sm-3 hk-summary-item\">\n          <span class=\"hk-data\" ng-show=\"vm.uptimeRatio !== 1\">{{vm.uptimeRatio * 100 | number:3}} %</span>\n          <span class=\"hk-data\" ng-show=\"vm.uptimeRatio === 1\">100 %</span>\n          <span class=\"hk-item\">Availability</span>\n        </div>\n        <div class=\"col-sm-3 hk-summary-item\">\n          <span class=\"hk-data\" ng-hide=\"vm.downtimeDuration\">Always Up</span>\n          <span class=\"hk-data\" ng-show=\"vm.downtimeDuration\" tooltip-trigger tooltip-placement=\"top\"\n                tooltip-popup-delay=\"1000\"\n                tooltip=\"{{ vm.downtimeDuration | duration:\'d\\\'d \\\'h\\\'h \\\'m\\\'min \\\'s\\\' s\\\'\' }}\"><ph\n            ng-repeat=\"val in vm.downtimeDurationJson\">{{val.value}}<span> {{val.unit}} </span></ph></span>\n          <span class=\"hk-item\">Total Downtime Duration</span>\n        </div>\n        <div class=\"col-sm-3 hk-summary-item\">\n          <span class=\"hk-data\" ng-hide=\"vm.lastDowntime.valueOf() === 0 || (vm.availabilityDataPoints.length === 1 && vm.availabilityDataPoints[0].value === \'down\')\" am-time-ago=\"vm.lastDowntime\" tooltip-trigger tooltip-placement=\"top\" tooltip-popup-delay=\"1000\" tooltip=\"{{ vm.lastDowntime | date:\'d MMM yyyy, HH:mm:ss\' }}\"></span>\n          <span class=\"hk-data\" ng-show=\"vm.availabilityDataPoints.length === 1 && vm.availabilityDataPoints[0].value === \'down\'\">Always Down</span>\n          <span class=\"hk-data\" ng-show=\"!vm.lastDowntime || vm.lastDowntime.valueOf() === 0\">Always Up</span>\n          <span class=\"hk-item\">Last Downtime</span>\n        </div>\n        <div class=\"col-sm-3 hk-summary-item\">\n          <span class=\"hk-data\">{{vm.downtimeCount}}</span>\n          <span class=\"hk-item\">Downtime Events</span>\n        </div>\n      </div>\n    </div>\n\n    <!-- Alerts -->\n    <div class=\"hk-info-top clearfix\">\n      <h3 class=\"pull-left\" data-toggle=\"tooltip\" data-placement=\"top\" title=\"\" data-original-title=\"Expand/collapse\">\n        <button class=\"btn btn-link hk-trigger\" ng-click=\"showAllAlerts = !showAllAlerts\"><i class=\"fa\"\n                                                                                             ng-show=\"vm.alertList.length > 0\"\n                                                                                             ng-class=\"showAllAlerts ? \'fa-minus-square-o\' : \'fa-plus-square-o\'\"></i>\n          Availability Alerts <span ng-show=\"vm.alertList.length > 0\">({{showAllAlerts ? vm.alertList.length : MetricsAvailabilityController.min(vm.alertList.length, 3)}} of {{vm.alertList.length}})</span>\n        </button>\n      </h3>\n      <span class=\"hk-settings pull-left\">\n        <a href=\"#\" ng-click=\"vm.openAvailabilitySetup()\"><i class=\"fa fa-cog\"></i>Alert Settings</a>\n      </span>\n    </div>\n\n    <div class=\"clearfix\">\n      <!-- No Alerts -->\n      <div class=\"panel panel-default alert alert-info\" ng-show=\"vm.alertList.length === 0\">\n        <div class=\"hk-alert-icon\"><i class=\"fa fa-flag gray\"></i></div>\n        <div class=\"hk-event\">No Alerts.</div>\n      </div>\n      <!-- Alerts exist -->\n      <hk-alert-panel-list class=\"clearfix\" hk-alert-list=\"vm.alertList\"\n                           hk-limit=\"(showAllAlerts ? 100000 : 3)\"></hk-alert-panel-list>\n    </div>\n\n    <!-- Availability Chart -->\n    <div class=\"hk-info-top clearfix\">\n      <h3 class=\"pull-left\">Metrics</h3>\n\n      <div class=\"hk-update pull-right\">\n        <button ng-click=\"vm.refreshAvailPageNow(vm.getResourceId())\" class=\"btn btn-link hk-chart-update\"\n                tooltip-trigger tooltip-placement=\"top\" tooltip=\"Update chart\"><i class=\"fa fa-refresh\"></i></button>\n      </div>\n    </div>\n\n    <div class=\"panel panel-default hk-graph\">\n      <h2>Availability</h2>\n      <div class=\"hk-graph-container hk-graph-availability\">\n        <availability-chart\n          start-timestamp=\"{{vm.startTimeStamp}}\"\n          end-timestamp=\"{{vm.endTimeStamp}}\"\n          data=\"vm.availabilityDataPoints\" >\n        </availability-chart>\n      </div>\n      <div class=\"hk-legend text-left hk-legend-availability\">\n        <span><span class=\"hk-legend-square hk-green\"></span>Available</span>\n        <span><span class=\"hk-legend-square hk-red\"></span>Down</span>\n        <span><span class=\"hk-legend-square hk-gray-light\"></span>Unknown</span>\n      </div>\n    </div>\n\n\n  </section>\n</div>\n");
$templateCache.put("plugins/metrics/html/url-list.html","<div ng-controller=\"UrlListController as vm\">\n  <div class=\"text-center hk-urls-list hk-spinner-container\" ng-hide=\"vm.resourceList\">\n    <div class=\"spinner spinner-lg\"></div>\n    <p class=\"hk-spinner-legend-below\">Loading...</p>\n  </div>\n  <div class=\"hk-urls-list\" ng-class=\"{\'hk-urls-empty text-center\': vm.resourceList.length === 0, \'hk-fade-in\': vm.resourceList}\" ng-show=\"vm.resourceList\">\n    <h1 class=\"text-center\">Hello {{userDetails.firstName}}!</h1>\n    <i class=\"fa fa-line-chart\" ng-show=\"vm.resourceList.length === 0\"></i>\n    <h2 ng-show=\"vm.resourceList.length === 0\">Collect metrics from a URL that you want to monitor.</h2>\n    <form class=\"form-horizontal hk-add-url\" name=\"addUrlForm\" role=\"form\" novalidate ng-submit=\"vm.addUrl(vm.resourceUrl)\">\n      <div class=\"form-group input\">\n        <div class=\"col-lg-6 col-sm-8 col-xs-12 hk-align-center\">\n          <div class=\"input-group input-group-lg\">\n            <input type=\"url\" class=\"form-control\" name=\"resourceUrl\" ng-model=\"vm.resourceUrl\"\n                   ng-model-options=\"{ updateOn: \'default blur\'}\"\n                   placeholder=\"Enter a website URL (e.g.: http://www.website.com)\" required>\n            <span class=\"input-group-btn\">\n              <button class=\"btn btn-primary\" type=\"submit\" ng-disabled=\"addUrlForm.$invalid || vm.addProgress\">\n               <div ng-show=\"vm.addProgress\" class=\"spinner spinner-sm\"></div>\n              Add URL\n              </button>\n            </span>\n          </div>\n          <span class=\"help-block\"\n                  ng-show=\"addUrlForm.resourceUrl.$dirty && addUrlForm.resourceUrl.$invalid\">The URL you entered is not valid. Please enter a valid URL.</span>\n\n        </div>\n      </div>\n    </form>\n  </div>\n\n  <h2 ng-show=\"vm.resourceList.length > 0\" class=\"text-center hk-fade-in\">Current status of your URLs</h2>\n\n  <div class=\"row hk-urls-list-labels\" ng-class=\"{\'hk-fade-in\': vm.resourceList}\" ng-show=\"vm.resourceList.length > 0\">\n    <div class=\"col-sm-6 text-left\">\n      <button class=\"btn btn-link\" tooltip=\"Sort\" tooltip-trigger tooltip-placement=\"top\" ng-click=\"vm.reverse = !vm.reverse\">\n        URL (A-Z) <i class=\"fa\" ng-class=\"vm.reverse ? \'fa-angle-up\' : \'fa-angle-down\'\"></i>\n      </button>\n    </div>\n    <div class=\"col-sm-6 text-right\">\n      <span class=\"hk-update pull-right\" tooltip-trigger tooltip-placement=\"top\" tooltip=\"Last update\"><i class=\"fa fa-clock-o\"></i>{{vm.lastUpdateTimestamp | date:\'HH:mm:ss\'}}</span>\n    </div>\n  </div>\n\n  <div ng-class=\"{\'hk-fade-in\': vm.resourceList}\" infinite-scroll=\"vm.loadMoreItems()\"\n       infinite-scroll-listen-for-event=\"list:updated\">\n    <!--<div class=\"hk-url-item\" ng-repeat=\"res in vm.resourceList | orderBy:\'properties.url\':vm.reverse\">-->\n    <div class=\"hk-url-item\" ng-repeat=\"res in vm.resourceList\">\n      <div class=\"panel panel-default hk-url-heading\">\n        <a href=\"/hawkular-ui/url/availability/{{res.id}}\">{{res.properties.url}}</a>\n        <span ng-show=\"res.properties[\'trait-collected-on\']\" class=\"pull-right\">{{res.traits}}</span>\n      </div>\n\n      <div class=\"panel panel-default hk-summary\">\n        <div class=\"row\">\n          <div class=\"col-sm-3 hk-summary-item\">\n            <a href=\"/hawkular-ui/url/alerts/{{res.id}}\">\n              <span class=\"hk-data\">{{(vm.alertList|filter:{triggerId: (res.id + \'_trigger\')}).length || 0}} <i class=\"fa fa-flag\" ng-show=\"(vm.alertList|filter:{triggerId: (res.id + \'_trigger\')}).length > 0\"></i></span>\n              <span class=\"hk-item\">Unresolved Alerts</span>\n            </a>\n          </div>\n          <div class=\"col-sm-3 hk-summary-item\">\n            <a href=\"/hawkular-ui/url/availability/{{res.id}}\">\n              <span class=\"hk-data\" ng-show=\"res.responseTime.length > 0\"><i class=\"fa \" ng-class=\"res.isUp ? \'fa-arrow-up\' : \'fa-arrow-down\'\"></i>{{res.isUp ? \'Up\' : \'Down\'}}</span>\n              <span class=\"hk-data spinner\" ng-hide=\"res.responseTime.length > 0\" popover=\"Your data is being collected. You should see something in a few seconds.\" popover-trigger=\"mouseenter\" popover-placement=\"bottom\"></span>\n              <span class=\"hk-item\">Current Availability</span>\n            </a>\n          </div>\n          <div class=\"col-sm-3 hk-summary-item\">\n            <a href=\"/hawkular-ui/url/availability/{{res.id}}\">\n              <span class=\"hk-data\" ng-show=\"res.lastDowntime > 0\" am-time-ago=\"res.lastDowntime\" tooltip-trigger tooltip-placement=\"top\" tooltip-popup-delay=\"1000\" tooltip=\"{{ res.lastDowntime | date:\'d MMM yyyy, HH:mm:ss\' }}\"></span>\n              <span class=\"hk-data\" ng-show=\"res.lastDowntime <= 0\">n/a</span>\n              <span class=\"hk-item\">Last Downtime</span>\n            </a>\n          </div>\n          <div class=\"col-sm-3 hk-summary-item\">\n            <a href=\"/hawkular-ui/url/response-time/{{res.id}}\">\n              <span class=\"hk-data\" ng-show=\"res.responseTime.length > 0 && res.responseTime[0].value >= 0\">{{res.responseTime[0].value}} <span>ms</span></span>\n              <span class=\"hk-data\" ng-show=\"res.responseTime.length > 0 && res.responseTime[0].value < 0\">n/a</span>\n              <span class=\"hk-data spinner\" ng-hide=\"res.responseTime.length > 0\" popover=\"Your data is being collected. You should see something in a few seconds.\" popover-trigger=\"mouseenter\" popover-placement=\"bottom\"></span>\n              <span class=\"hk-item\">Current Response Time</span>\n            </a>\n          </div>\n        </div>\n        <button class=\"btn btn-link hk-delete\" tooltip=\"Delete\" tooltip-trigger tooltip-placement=\"left\"  ng-click=\"vm.deleteResource(res)\"><i class=\"fa fa-trash-o\"></i></button>\n      </div>\n    </div>\n    <div class=\"spinner\" ng-show=\"vm.loadingMoreItems\"></div>\n  </div>\n\n  <!--<hk-pagination resource-list=\"vm.resourceList\" current-page=\"vm.resCurPage\" page-setter=\"vm.setPage(pageNumber)\"\n      per-page=\"vm.resPerPage\" headers=\"vm.headerLinks\"></hk-pagination>-->\n\n</div>\n");
$templateCache.put("plugins/metrics/html/url-response-time.html","<div class=\"hk-screen-content\" ng-controller=\"MetricsViewController as vm\">\n\n  <hawkular-subtab ng-controller=\"Subtab.SubtabController\">\n    <div class=\"hk-nav-tabs-container\">\n      <ul class=\"nav nav-tabs nav-tabs-pf\">\n        <li><a href=\"/hawkular-ui/url/alerts/{{vm.$routeParams.resourceId}}/{{vm.$routeParams.timeOffset}}\" class=\"hk-alerts\">All Alerts</a></li>\n        <li><a href=\"/hawkular-ui/url/availability/{{vm.$routeParams.resourceId}}/{{vm.$routeParams.timeOffset}}\" class=\"hk-availability\">Availability</a></li>\n        <li class=\"active\"><a href=\"/hawkular-ui/url/response-time/{{vm.$routeParams.resourceId}}/{{vm.$routeParams.timeOffset}}\" class=\"hk-response-time\">Response Time</a></li>\n      </ul>\n    </div>\n  </hawkular-subtab>\n\n  <section class=\"hk-tab-content\" id=\"hk-response-time\">\n\n    <hk-alert-notification></hk-alert-notification>\n\n    <!-- Summary -->\n    <h3 class=\"pull-left\">Response Time Status</h3>\n    <span class=\"hk-update pull-right\" tooltip-trigger tooltip-placement=\"top\" tooltip=\"Last update\"><i class=\"fa fa-clock-o\"></i>{{vm.endTimeStamp | date:\'HH:mm:ss\'}}</span>\n    <div class=\"panel panel-default hk-summary\">\n      <div class=\"row\">\n        <div class=\"col-sm-4 hk-summary-item\">\n          <span class=\"hk-data\" ng-show=\"vm.average >= 0\">{{vm.average}} <span>ms</span></span>\n          <span class=\"hk-data\" ng-hide=\"vm.average >= 0\">n/a</span>\n          <span class=\"hk-item\">Average</span>\n        </div>\n        <div class=\"col-sm-4 hk-summary-item\">\n          <span class=\"hk-data\" ng-show=\"vm.median >= 0\">{{vm.median}} <span>ms</span></span>\n          <span class=\"hk-data\" ng-hide=\"vm.median >= 0\">n/a</span>\n          <span class=\"hk-item\">Median</span>\n        </div>\n        <div class=\"col-sm-4 hk-summary-item\">\n          <span class=\"hk-data\" ng-show=\"vm.percentile95th >= 0\">{{vm.percentile95th}} <span>ms</span></span>\n          <span class=\"hk-data\" ng-hide=\"vm.percentile95th >= 0\">n/a</span>\n          <span class=\"hk-item\">95th percentile</span>\n        </div>\n      </div>\n    </div>\n\n    <!-- Alerts -->\n    <div class=\"hk-info-top clearfix\">\n      <h3 class=\"pull-left\" data-toggle=\"tooltip\" data-placement=\"top\" title=\"\" data-original-title=\"Expand/collapse\">\n        <button class=\"btn btn-link hk-trigger\" ng-click=\"showAllAlerts = !showAllAlerts\">\n          <i class=\"fa\" ng-show=\"vm.alertList.length > 0\" ng-class=\"showAllAlerts ? \'fa-minus-square-o\' : \'fa-plus-square-o\'\"></i>\n          Response Time Alerts <span ng-show=\"vm.alertList.length > 0\">({{showAllAlerts ? vm.alertList.length : MetricsViewController.min(vm.alertList.length, 3)}} of {{vm.alertList.length}})</span></button>\n      </h3>\n      <span class=\"hk-settings pull-left\"><a href=\"#\" ng-controller=\"MetricsAlertController as mac\" ng-click=\"mac.openResponseSetup()\"><i class=\"fa fa-cog\"></i>Alert Settings</a></span>\n    </div>\n    <div class=\"clearfix\">\n      <!-- No Alerts -->\n      <div class=\"panel panel-default alert alert-info\" ng-show=\"vm.alertList.length === 0\">\n        <div class=\"hk-alert-icon\"><i class=\"fa fa-flag gray\"></i></div>\n        <div>No alerts.</div>\n      </div>\n      <!-- Alerts exist -->\n      <hk-alert-panel-list class=\"clearfix\" hk-alert-list=\"vm.alertList\" hk-limit=\"(showAllAlerts ? 100000 : 3)\"></hk-alert-panel-list>\n    </div>\n\n    <!-- Response Time Graph -->\n    <div class=\"hk-info-top clearfix\">\n      <h3 class=\"pull-left\">Metrics</h3>\n      <div class=\"hk-update pull-right\">\n        <button class=\"btn btn-link hk-chart-update\" tooltip-trigger tooltip-placement=\"top\" tooltip=\"Update chart\" ng-click=\"vm.refreshChartDataNow(vm.getMetricId())\"><i class=\"fa fa-refresh\"></i></button>\n      </div>\n    </div>\n\n    <div class=\"panel panel-default hk-graph\" ng-if=\"vm.average >= 0\">\n      <h2>Response Time</h2>\n\n      <div class=\"text-center hk-spinner-container\" ng-hide=\"vm.chartData.dataPoints.length > 0\">\n        <div class=\"spinner spinner-lg\"></div>\n      </div>\n\n      <div class=\"hk-graph-container hk-graph-metrics\">\n        <!-- HINT: colors for the chart can be changed in the hawkular-charts.css -->\n        <hawkular-chart\n          data=\"vm.chartData.dataPoints\"\n          chart-type=\"hawkularmetric\"\n          alert-value=\"{{vm.threshold}}\"\n          use-zero-min-value=\"true\"\n          y-axis-units=\"Response Time (ms)\"\n          chart-height=\"250\">\n        </hawkular-chart>\n      </div>\n\n      <div class=\"hk-legend text-left hk-legend-metrics\" ng-show=\"vm.chartData.dataPoints.length > 0\">\n        <span><i class=\"fa fa-circle hk-blue\"></i>Response Time</span>\n        <span><i class=\"fa fa-circle hk-red\"></i>Threshold</span>\n        <span><span class=\"hk-legend-square hk-red-light\"></span>Interval above the threshold</span>\n      </div>\n    </div>\n\n    <div class=\"panel panel-default hk-graph\" ng-if=\"vm.average < 0\">\n      <h2>Response Time</h2>\n      <div class=\"blank-slate-pf\">\n        <div class=\"blank-slate-pf-icon\">\n          <i class=\"fa fa-line-chart\"></i>\n        </div>\n        <h1>The server hasn\'t been reachable for this time range.</h1>\n      </div>\n    </div>\n\n  </section>\n</div>\n");
$templateCache.put("plugins/directives/subtab/html/subtab.html","<div class=\"hk-screen-top-nav\">\n  <div>\n    <div class=\"row hk-top-row\">\n      <div class=\"col-xs-6\">\n        <a ng-show=\"isAppServerPage()\" href=\"/hawkular-ui/app/app-list\" class=\"back\">« All Application Servers</a>\n        <a ng-hide=\"isUrlPage()\" href=\"/hawkular-ui/url/url-list\" class=\"back\">« All URLs</a>\n        <a ng-show=\"isAlertsPage()\" href=\"/hawkular-ui/alerts-center\" class=\"back\">« All Alerts</a>\n      </div>\n      <div class=\"col-xs-6\">\n        <div class=\"hk-date-range dropdown\">\n          <i class=\"fa fa-calendar\" dropdown-toggle></i>\n          <div class=\"hk-input\" dropdown-toggle>\n            <span ng-show=\"false\">{{offsetName}}</span> {{getFormattedDate()}}\n          </div>\n          <div class=\"dropdown-menu infotip bottom-right\">\n            <div class=\"arrow\"></div>\n            <div class=\"dropdown-menu-content\">\n              <span class=\"hk-label\">Last</span>\n              <div class=\"btn-group\">\n                <button type=\"button\" class=\"btn btn-default\" ng-class=\"{\'active\': offsetName === \'Last Hour\'}\" ng-click=\"setRange({hour: 1})\">1h</button>\n                <button type=\"button\" class=\"btn btn-default\" ng-class=\"{\'active\': offsetName === \'Last 12 Hours\'}\" ng-click=\"setRange({hours: 12})\">12h</button>\n                <button type=\"button\" class=\"btn btn-default\" ng-class=\"{\'active\': offsetName === \'Last Day\'}\" ng-click=\"setRange({day: 1})\">Day</button>\n                <button type=\"button\" class=\"btn btn-default\" ng-class=\"{\'active\': offsetName === \'Last Week\'}\" ng-click=\"setRange({week: 1})\">Week</button>\n                <button type=\"button\" class=\"btn btn-default\" ng-class=\"{\'active\': offsetName === \'Last Month\'}\" ng-click=\"setRange({month: 1})\">Month</button>\n                <button type=\"button\" class=\"btn btn-default\" ng-class=\"{\'active\': offsetName === \'Last Year\'}\" ng-click=\"setRange({year: 1})\">Year</button>\n              </div>\n            </div>\n          </div>\n        </div>\n      </div>\n    </div>\n    <div class=\"hk-heading\">\n      <h1 ng-init=\"isAppServerPage() ? getAppServerFromId(hkParams.resourceId) : getUrlFromId(hkParams.resourceId)\">{{resourceName}}</h1>\n      <h1 ng-show=\"isAlertsPage()\">Alert Center</h1>\n    </div>\n    <div ng-transclude></div>\n  </div>\n</div>\n\n");
$templateCache.put("plugins/directives/topbar/html/topbar.html","<ul class=\"nav navbar-nav navbar-primary\">\n  <li ng-class=\"getClass(\'/hawkular-ui/alerts-center\')\">\n    <a href=\"/hawkular-ui/alerts-center\">Alert Center</a>\n  </li>\n  <li ng-class=\"getClass(\'/hawkular-ui/url/\')\">\n    <a href=\"/hawkular-ui/url/url-list\">URLs</a>\n  </li>\n  <li ng-class=\"getClass(\'/hawkular-ui/app/\')\">\n    <a href=\"/hawkular-ui/app/app-list\">Application Servers</a>\n  </li>\n  <li ng-class=\"getClass(\'/hawkular-ui/topology/\')\" ng-show=\"$root.isExperimental\">\n    <a href=\"/hawkular-ui/topology/view\">Topology</a>\n  </li>\n</ul>\n");
$templateCache.put("plugins/metrics/html/app-details/app-server-details.html","<div class=\"hk-screen-content\" ng-controller=\"AppServerDetailsController as tabs\">\n\n  <hawkular-subtab ng-controller=\"Subtab.SubtabController\">\n    <div class=\"hk-nav-tabs-container\">\n      <ul class=\"nav nav-tabs nav-tabs-pf\" ng-init=\"tabs.activeTab = tabs.activeTab || \'jvm\'\">\n        <li ng-repeat=\"tab in tabs.availableTabs\" ng-class=\"tabs.activeTab === tab.id ? \'active\' : \'\'\"\n            ng-show=\"tab.enabled\">\n          <a href=\"#\" ng-click=\"tabs.updateTab(tab.id)\" class=\"hk-{{tab.id}}\">{{tab.name}}\n            <span class=\"label label-danger label-alert pull-right\" ng-show=\"false\">3</span></a>\n        </li>\n      </ul>\n    </div>\n\n  </hawkular-subtab>\n\n  <div ng-repeat=\"tab in tabs.availableTabs\">{{tab.controller}}</div>\n\n  <ng-include ng-repeat=\"tab in tabs.availableTabs\" src=\"tab.src\" ng-if=\"tabs.activeTab === tab.id\"\n              ng-controller=\"tab.controller\"></ng-include>\n\n  <div class=\"hk-nav-tabs-container pull-right\">\n    <button type=\"button\" class=\"btn btn-primary\" ng-click=\"tabs.requestExportJDR()\"\n            ng-disabled=\"tabs.jdrGenerating\">\n      Export JDR\n    </button>\n  </div>\n\n</div>\n");
$templateCache.put("plugins/metrics/html/app-details/detail-alerts.html","<section id=\"hk-alerts\" class=\"hk-tab-content\">\n\n  <div class=\"hk-info-top clearfix\">\n    <h3 class=\"pull-left\" tooltip-trigger tooltip-placement=\"top\" tooltip=\"Expand/collapse\">Alerts <span>(29)</span></h3>\n    <span class=\"hk-settings pull-right\"><a href=\"#\" ng-controller=\"MetricsAlertController as mac\" ng-click=\"mac.openSetup()\"><i class=\"fa fa-cog\"></i>Alert Settings</a></span>\n  </div>\n  <div class=\"clearfix\">\n    <div class=\"panel panel-default alert alert-danger\">\n      <div class=\"hk-alert-icon\">\n        <i class=\"fa fa-flag\"></i>\n      </div>\n      <div class=\"hk-date\">\n        12 Feb, 5:35 PM\n      </div>\n      <div class=\"hk-event\">\n        Server <strong>down</strong> for 4 minutes (until 5:39 PM).\n      </div>\n    </div>\n    <div class=\"panel panel-default alert alert-danger\">\n      <div class=\"hk-alert-icon\">\n        <i class=\"fa fa-flag\"></i>\n      </div>\n      <div class=\"hk-date\">\n        11 Feb, 3:53 PM\n      </div>\n      <div class=\"hk-event\">\n        <strong>Response time</strong> was above the threshold for 7 minutes (until 4:00 PM).\n      </div>\n    </div>\n  </div>\n\n</section>");
$templateCache.put("plugins/metrics/html/app-details/detail-datasources.html","<section id=\"hk-datasources\" class=\"hk-tab-content\">\n\n  <div class=\"clearfix\">\n\n    <div class=\"hk-control-actions-bar pull-left\">\n      <div class=\"hk-container-separator\">\n        <input type=\"text\" class=\"form-control separator\" ng-model=\"vm.filter.name\"\n               placeholder=\"Filter by Name...\">\n      </div>\n\n      <div class=\"hk-container-separator\">\n        <div class=\"btn-group\" dropdown auto-close=\"always\">\n          <button id=\"simple-btn-keyboard-nav\" type=\"button\" class=\"btn btn-default\" dropdown-toggle>\n            Sort {{vm.sortInv ? \'Z - A\' : \'A - Z\'}}  <span class=\"caret\"></span>\n          </button>\n          <ul class=\"dropdown-menu\" role=\"menu\" aria-labelledby=\"simple-btn-keyboard-nav\">\n            <li ng-class=\"{\'active\': !vm.sortInv}\">\n              <a href=\"\" ng-click=\"vm.sortInv = false\" dropdown-toggle>Sort A - Z</a>\n            </li>\n            <li ng-class=\"{\'active\': vm.sortInv}\">\n              <a href=\"\" ng-click=\"vm.sortInv = true\" dropdown-toggle>Sort Z - A</a>\n            </li>\n          </ul>\n        </div>\n      </div>\n\n      <button class=\"btn btn-default\" type=\"button\" ng-click=\"vm.showDriverAddDialog()\">Add Driver</button>\n      <button class=\"btn btn-default\" type=\"button\" ng-click=\"vm.showDatasourceAddDialog()\">Add Datasource</button>\n    </div>\n\n    <span class=\"hk-update pull-right\" tooltip-trigger tooltip-placement=\"top\" tooltip=\"Last update\">\n      <i class=\"fa fa-clock-o\"></i>{{vm.endTimeStamp | date:\'HH:mm:ss\'}}\n    </span>\n  </div>\n\n  <div class=\"hk-resource-container\"\n       ng-repeat=\"ds in vm.resourceList | filter:vm.filter | orderBy:\'name\':vm.sortInv\">\n\n    <div class=\"panel panel-default hk-summary\">\n      <div class=\"panel-heading\">\n        <span class=\"hk-heading\">{{ds.name}}</span>\n        <div class=\"btn-group pull-right\" dropdown auto-close=\"always\">\n          <button id=\"ds-actions\" class=\"btn btn-link\" type=\"button\" dropdown-toggle aria-haspopup=\"true\"\n                  aria-expanded=\"true\">\n            Actions\n            <span class=\"caret\"></span>\n          </button>\n          <ul class=\"dropdown-menu\" role=\"menu\" aria-labelledby=\"ds-actions\">\n            <li class=\"disabled\"><a href=\"#\">Edit</a></li>\n            <li><a href=\"\" ng-click=\"vm.deleteDatasource(ds)\">Delete</a></li>\n            <li class=\"disabled\"><a href=\"#\">Enable</a></li>\n            <li class=\"disabled\"><a href=\"#\">Disable</a></li>\n          </ul>\n        </div>\n      </div>\n      <div class=\"row\">\n        <div class=\"col-sm-4 hk-summary-item\">\n          <span class=\"hk-data\">{{ds.alertList.length}} <i class=\"fa fa-flag\" ng-show=\"ds.alertList.length\"></i></span>\n          <span class=\"hk-item\">Datasources Alerts</span>\n        </div>\n        <div class=\"col-sm-4 hk-summary-item\">\n          <span class=\"hk-data\" ng-show=\"ds.availableCount.value\">\n            {{ ds.inUseCount.value / (ds.inUseCount.value + ds.availableCount.value) * 100 | number : 0 }} %\n          </span>\n          <span class=\"hk-data\" ng-hide=\"ds.availableCount.value\">n/a</span>\n          <span class=\"hk-item\">Connections Used (%)</span>\n        </div>\n        <div class=\"col-sm-4 hk-summary-item\">\n          <span class=\"hk-data\" ng-show=\"ds.availableCount.value\">\n            {{ ds.availableCount.value }} Available (of {{ ds.inUseCount.value + ds.availableCount.value }})\n          </span>\n          <span class=\"hk-data\" ng-hide=\"ds.availableCount.value\">n/a</span>\n          <span class=\"hk-item\">Available Connections (of total)</span>\n        </div>\n      </div>\n    </div>\n    <div class=\"hk-panel-collapse-area\" ng-class=\"{\'hk-collapsed\' : !vm.expandedList[ds.id]}\">\n      <a href=\"#\" ng-click=\"vm.expandedList[ds.id] = !vm.expandedList[ds.id]\">\n        <span ng-hide=\"vm.expandedList[ds.id]\">View Metrics</span>\n        <span ng-show=\"vm.expandedList[ds.id]\">Hide Metrics</span>\n        <i class=\"fa\" ng-class=\"vm.expandedList[ds.id] ? \'fa-chevron-circle-up\' : \'fa-chevron-circle-down\'\"></i>\n      </a>\n    </div>\n\n    <div class=\"hk-collapsible-area\" ng-class=\"{ \'hide\': !vm.expandedList[ds.id]}\" ng-if=\"vm.expandedList[ds.id]\">\n\n\n      <div class=\"hk-info-top clearfix\">\n        <h3 class=\"pull-left\">\n          <button class=\"btn btn-link hk-trigger\" ng-click=\"vm.showAllAlerts = !vm.showAllAlerts\" tooltip-trigger\n                  tooltip-placement=\"top\" tooltip=\"Expand/collapse\">\n            <i class=\"fa\" ng-show=\"ds.alertList.length > 0\"\n               ng-class=\"vm.showAllAlerts ? \'fa-minus-square-o\' : \'fa-plus-square-o\'\"></i> Datasource Alerts\n            <span ng-show=\"ds.alertList.length > 0\">\n              ({{vm.showAllAlerts ? ds.alertList.length : vm.math.min(ds.alertList.length, 3)}} of\n              {{ds.alertList.length}})\n            </span>\n          </button>\n        </h3>\n        <span class=\"hk-settings pull-left\">\n          <a href=\"#\" ng-click=\"vm.openSetup(ds.id)\">\n            <i class=\"fa fa-cog\"></i>Alert Settings\n          </a>\n        </span>\n      </div>\n      <div class=\"clearfix\">\n        <!-- No Alerts -->\n        <div class=\"panel panel-default alert alert-info\" ng-show=\"ds.alertList.length === 0\">\n          <div class=\"hk-alert-icon\"><i class=\"fa fa-flag gray\"></i></div>\n          <div class=\"hk-event\">No Alerts.</div>\n        </div>\n        <!-- Alerts exist -->\n        <hk-alert-panel-list class=\"clearfix\" hk-alert-list=\"ds.alertList\"\n                             hk-limit=\"(vm.showAllAlerts ? 100000 : 3)\"></hk-alert-panel-list>\n      </div>\n\n      <!-- Alerts ->\n      <div class=\"hk-info-top clearfix\">\n        <h3 class=\"pull-left\">\n          <button class=\"btn btn-link hk-trigger\" ng-click=\"showAllAlerts = !showAllAlerts\" tooltip-trigger\n                  tooltip-placement=\"top\" tooltip=\"Expand/collapse\">\n            <i class=\"fa\" ng-show=\"vm.alertList.length > 0\"\n               ng-class=\"showAllAlerts ? \'fa-minus-square-o\' : \'fa-plus-square-o\'\">\n            </i>\n            Deployment Alerts\n            <span ng-show=\"vm.alertList.length > 0\">\n              ({{showAllAlerts ? vm.alertList.length : vm.math.min(vm.alertList.length, 3)}} of {{vm.alertList.length}})\n            </span>\n          </button>\n        </h3>-->\n        <!--\n        <span class=\"hk-settings pull-right\">\n          <a href=\"#\" ng-controller=\"MetricsAlertController as mac\" ng-click=\"mac.openSetup()\">\n            <i class=\"fa fa-cog\"></i>Alert Settings\n          </a>\n        </span>\n        ->\n      </div>\n      <div class=\"clearfix\">\n        <!-- No Alerts ->\n        <div class=\"panel panel-default alert alert-info\" ng-show=\"vm.alertList.length === 0\">\n          <div class=\"hk-alert-icon\"><i class=\"fa fa-flag gray\"></i></div>\n          <div>No alerts have been fired in this category and time range.</div>\n        </div>\n        <!-- Alerts exist --\n        <div class=\"panel panel-default alert alert-danger\"\n             ng-repeat=\"alert in vm.alertList | limitTo: (showAllAlerts ? 100000 : 3) track by $index\">\n          <div class=\"hk-alert-icon\"><i class=\"fa fa-flag\"></i></div>\n          <div class=\"hk-date\">{{alert.evalSets[0][0].evalTimestamp | date:\'medium\' }}</div>\n          <div class=\"hk-event\"><strong>Alert Summary</strong>: alert details.</div>\n        </div>\n      </div-->\n\n      <div class=\"hk-info-top clearfix\">\n        <h3 class=\"pull-left\">Metrics</h3>\n\n        <div class=\"hk-update pull-right\">\n          <button class=\"btn btn-link hk-chart-update\" tooltip-trigger tooltip-placement=\"top\" tooltip=\"Update chart\">\n            <i class=\"fa fa-refresh\"></i>\n          </button>\n        </div>\n      </div>\n\n      <div class=\"panel panel-default hk-graph\" ng-if=\"vm.resolvedAvailData[ds.id]\">\n        <h2>Availability</h2>\n        <div class=\"hk-graph-container hk-graph-metrics\">\n          <hawkular-chart\n              multi-data=\"vm.chartAvailData[ds.id]\"\n              chart-type=\"multiline\"\n              y-axis-units=\"Availability (#)\"\n              chart-height=\"250\">\n          </hawkular-chart>\n        </div>\n        <div class=\"row hk-legend hk-legend-inline text-left hk-legend-metrics\">\n          <div class=\"col-md-12\">\n            <h4>Connection Availability</h4>\n            <div class=\"hk-graphselector hk-blue\">\n              <input id=\"connavail_{{$index}}\" type=\"checkbox\"\n                     ng-checked=\"!vm.skipChartData[ds.id + \'_Available Count\']\"\n                     ng-click=\"vm.toggleChartData(ds.id + \'_Available Count\')\">\n              <label for=\"connavail_{{$index}}\"><span>Available Connections</span></label>\n            </div>\n            <div class=\"hk-graphselector hk-green\">\n              <input id=\"conninuse_{{$index}}\" type=\"checkbox\"\n                     ng-checked=\"!vm.skipChartData[ds.id + \'_In Use Count\']\"\n                     ng-click=\"vm.toggleChartData(ds.id + \'_In Use Count\')\">\n              <label for=\"conninuse_{{$index}}\"><span>Connections in Use</span></label>\n            </div>\n            <div class=\"hk-graphselector hk-gray\">\n              <input id=\"conntimed_{{$index}}\" type=\"checkbox\"\n                     ng-checked=\"!vm.skipChartData[ds.id + \'_Timed Out\']\"\n                     ng-click=\"vm.toggleChartData(ds.id + \'_Timed Out\')\">\n              <label for=\"conntimed_{{$index}}\"><span>Timed-out Connections</span></label>\n            </div>\n          </div>\n        </div>\n      </div>\n\n      <div class=\"panel panel-default hk-graph\" ng-if=\"vm.resolvedRespData[ds.id]\">\n        <h2>Responsiveness</h2>\n        <div class=\"hk-graph-container hk-graph-metrics\">\n          <hawkular-chart\n              multi-data=\"vm.chartRespData[ds.id]\"\n              chart-type=\"multiline\"\n              y-axis-units=\"Responsiveness (ms)\"\n              chart-height=\"250\">\n          </hawkular-chart>\n        </div>\n        <div class=\"row hk-legend hk-legend-inline text-left hk-legend-metrics\">\n          <div class=\"col-md-12\">\n            <h4>Responsiveness</h4>\n            <div class=\"hk-graphselector hk-yellow\">\n              <input id=\"waittime_{{$index}}\" type=\"checkbox\"\n                     ng-checked=\"!vm.skipChartData[ds.id + \'_Average Get Time\']\"\n                     ng-click=\"vm.toggleChartData(ds.id + \'_Average Get Time\')\">\n              <label for=\"waittime_{{$index}}\"><span>Wait Time (Avg.)</span></label>\n            </div>\n            <div class=\"hk-graphselector hk-purple\">\n              <input id=\"creationtime_{{$index}}\" type=\"checkbox\"\n                     ng-checked=\"!vm.skipChartData[ds.id + \'_Average Creation Time\']\"\n                     ng-click=\"vm.toggleChartData(ds.id + \'_Average Creation Time\')\">\n              <label for=\"creationtime_{{$index}}\"><span>Creation Time (Avg.)</span></label>\n            </div>\n          </div>\n        </div>\n      </div>\n    </div>\n\n  </div><!-- .hk-resource-container -->\n\n</section>\n");
$templateCache.put("plugins/metrics/html/app-details/detail-deployments.html","<section id=\"hk-deployments\" class=\"hk-tab-content\">\n\n  <h3 class=\"pull-left\">Deployment Status</h3>\n  <span class=\"hk-update pull-right\" tooltip-trigger tooltip-placement=\"bottom\" tooltip=\"Last update\"><i class=\"fa fa-clock-o\"></i>{{vm.endTimeStamp | date:\'HH:mm:ss\'}}</span>\n  <div class=\"panel panel-default hk-summary\">\n    <div class=\"row\">\n      <div class=\"col-sm-3 hk-summary-item\">\n        <span class=\"hk-data\">{{vm.alertList.length}} <i class=\"fa fa-flag\" ng-show=\"false\"></i></span>\n        <span class=\"hk-item\">Deployment Alerts</span>\n      </div>\n      <div class=\"col-sm-3 hk-summary-item\">\n        <span class=\"hk-data\">{{vm.failedDeployments || 0}} Failed</span>\n        <span class=\"hk-item\">Deployments</span>\n      </div>\n      <div class=\"col-sm-3 hk-summary-item\">\n        <span class=\"hk-data\">{{vm.resourceList.length || 0}} Enabled</span>\n        <span class=\"hk-item\">Deployments</span>\n      </div>\n      <div class=\"col-sm-3 hk-summary-item\">\n        <span class=\"hk-data\">{{vm.disabledDeployments || 0}} Disabled</span>\n        <span class=\"hk-item\">Deployments</span>\n      </div>\n    </div>\n  </div>\n\n  <!-- Alerts -->\n  <div class=\"hk-info-top clearfix\">\n    <h3 class=\"pull-left\">\n      <button class=\"btn btn-link hk-trigger\" ng-click=\"showAllAlerts = !showAllAlerts\" tooltip-trigger tooltip-placement=\"top\" tooltip=\"Expand/collapse\"><i class=\"fa\" ng-show=\"vm.alertList.length > 0\" ng-class=\"showAllAlerts ? \'fa-minus-square-o\' : \'fa-plus-square-o\'\"></i> Deployment Alerts <span ng-show=\"vm.alertList.length > 0\">({{showAllAlerts ? vm.alertList.length : vm.math.min(vm.alertList.length, 3)}} of {{vm.alertList.length}})</span></button>\n    </h3>\n    <!--<span class=\"hk-settings pull-right\"><a href=\"#\" ng-controller=\"MetricsAlertController as mac\" ng-click=\"mac.openSetup()\"><i class=\"fa fa-cog\"></i>Alert Settings</a></span>-->\n  </div>\n  <div class=\"clearfix\">\n    <!-- No Alerts -->\n    <div class=\"panel panel-default alert alert-info\" ng-show=\"vm.alertList.length === 0\">\n      <div class=\"hk-alert-icon\"><i class=\"fa fa-flag gray\"></i></div>\n      <div>No alerts.</div>\n    </div>\n    <!-- Alerts exist -->\n    <div class=\"panel panel-default alert alert-danger\" ng-repeat=\"alert in vm.alertList | limitTo: (showAllAlerts ? 100000 : 3) track by $index\">\n      <div class=\"hk-alert-icon\"><i class=\"fa fa-flag\"></i></div>\n      <div class=\"hk-date\">{{alert.evalSets[0][0].evalTimestamp | date:\'medium\' }}</div>\n      <div class=\"hk-event\"><strong>Alert Summary</strong>: alert details.</div>\n    </div>\n  </div>\n  <!-- Deployments Table -->\n  <div ng-show=\"vm.resourceList.$resolved && vm.resourceList.length <= 0\">\n    <div class=\"hk-info-top clearfix\">\n      <h3>Deployments</h3>\n      <div class=\"blank-slate-pf\">\n        <div class=\"blank-slate-pf-icon\">\n          <i class=\"fa fa-cubes\"></i>\n        </div>\n        <h1>No deployments.</h1>\n        <div style=\"padding-top: 20px;\">\n          <button class=\"btn btn-primary btn-lg\"\n                  ng-click=\"vm.showDeploymentAddDialog()\">Add Deployment</button></div>\n      </div>\n    </div>\n  </div>\n\n  <div ng-show=\"vm.resourceList.length > 0\">\n    <div class=\"hk-info-top clearfix\">\n      <h3>Deployments</h3>\n      <div class=\"actions-table\">\n        <button class=\"btn btn-primary add\" type=\"button\"\n                ng-click=\"vm.showDeploymentAddDialog()\">Add Deployment</button>\n        <div class=\"dropdown\">\n          <button class=\"btn btn-default\" type=\"button\" id=\"dropdownMenu1\" dropdown-toggle ng-disabled=\"vm.selectCount === 0\">\n            Actions\n            <span class=\"caret\"></span>\n          </button>\n          <ul class=\"dropdown-menu disabled\" role=\"menu\" aria-labelledby=\"dropdownMenu1\">\n            <li role=\"presentation\"><a role=\"menuitem\" tabindex=\"-1\" href=\"#\" ng-click=\"vm.performOperationMulti(\'Deploy\', vm.resourceList)\" dropdown-toggle>Enable</a></li>\n            <li role=\"presentation\"><a role=\"menuitem\" tabindex=\"-1\" href=\"#\" ng-click=\"vm.performOperationMulti(\'Redeploy\', vm.resourceList)\" dropdown-toggle>Redeploy</a></li>\n            <li role=\"presentation\"><a role=\"menuitem\" tabindex=\"-1\" href=\"#\" ng-click=\"vm.performOperationMulti(\'Undeploy\', vm.resourceList)\" dropdown-toggle>Disable</a></li>\n            <li role=\"presentation\"><a role=\"menuitem\" tabindex=\"-1\" href=\"#\" ng-click=\"vm.performOperationMulti(\'Remove\', vm.resourceList)\" dropdown-toggle>Remove</a></li>\n          </ul>\n        </div>\n      </div>\n    </div>\n\n    <div id=\"DataTables_Table_0_wrapper\" class=\"dataTables_wrapper no-footer\">\n      <div class=\"dataTables_header\">\n        <div id=\"DataTables_Table_0_filter\" class=\"dataTables_filter\">\n          <label><input type=\"search\" ng-model=\"vm.search.name\" aria-controls=\"DataTables_Table_0\"></label>\n        </div>\n        <div class=\"dataTables_info\" role=\"status\" aria-live=\"polite\" ng-hide=\"vm.selectCount > 0\">Showing <b>1</b> to <b>{{vm.resourceList.length}}</b> of <b>{{vm.resourceList.length}}</b> Items</div>\n        <div class=\"dataTables_info\" role=\"status\" aria-live=\"polite\" ng-show=\"vm.selectCount > 0\"><b>{{vm.selectCount}}</b> item<span ng-show=\"vm.selectCount > 1\">s</span> selected</div>\n      </div>\n      <div class=\"table-responsive\">\n        <table class=\"datatable table table-striped table-bordered table-checkbox dataTable no-footer hk-table-select\" id=\"DataTables_Table_0\" aria-describedby=\"DataTables_Table_0_info\" role=\"grid\">\n          <thead>\n            <tr role=\"row\">\n              <th class=\"sorting\" tabindex=\"0\" aria-controls=\"DataTables_Table_0\" rowspan=\"1\" colspan=\"1\" aria-sort=\"ascending\" aria-label=\"Select All\" ng-click=\"vm.selectAll()\"><input type=\"checkbox\" ng-checked=\"vm.selectCount && vm.selectCount === filteredResList.length\"></th>\n              <th class=\"sorting\" tabindex=\"0\" aria-controls=\"DataTables_Table_0\" rowspan=\"1\" colspan=\"1\" aria-label=\"Current State: activate to sort column ascending\">Current State</th>\n              <th class=\"sorting\" tabindex=\"0\" aria-controls=\"DataTables_Table_0\" rowspan=\"1\" colspan=\"1\" aria-label=\"Deployments 10: activate to sort column ascending\">Deployments <span class=\"label label-default label-alert pull-right\" tooltip-trigger tooltip-placement=\"top\" tooltip=\"Total alerts\" ng-show=\"vm.alertList.length\">{{vm.alertList.length}}</span></th>\n              <th class=\"sorting\" tabindex=\"0\" aria-controls=\"DataTables_Table_0\" rowspan=\"1\" colspan=\"1\" aria-label=\"Enabled/Disabled: activate to sort column ascending\">Enabled/Disabled</th>\n              <th class=\"sorting\" tabindex=\"0\" aria-controls=\"DataTables_Table_0\" rowspan=\"1\" colspan=\"1\" aria-label=\"Computed Health: activate to sort column ascending\">Computed Health</th>\n            </tr>\n          </thead>\n          <tbody>\n            <tr class=\"odd\"><td valign=\"top\" colspan=\"6\" class=\"dataTables_empty\" ng-show=\"vm.search && filteredResList.length === 0\"><p>Suggestions</p><ul><li>Check the syntax of the search term.</li><li>Check that the correct menu option is chosen (token ID vs. user ID).</li><li>Use wildcards (* to match zero or more characters or ? to match a single character).</li><li>Clear the search field, then click Search to return to the 20 most recent records.</li></ul></td></tr>\n            <tr role=\"row\" ng-repeat=\"res in filteredResList = (vm.resourceList | filter:vm.search)\" ng-class=\"{\'hk-selected\': res.selected}\" ng-click=\"vm.selectItem(res)\">\n              <td><input type=\"checkbox\" ng-checked=\"res.selected\"></td>\n              <td class=\"state\" ng-show=\"res.state === \'up\'\"><i class=\"fa fa-check-circle-o\"></i> OK</td>\n              <td class=\"state\" ng-show=\"res.state === \'down\'\"><i class=\"fa fa-square\"></i> Stopped</td>\n              <td class=\"state\" ng-show=\"res.state === \'unknown\'\"><i class=\"fa fa-times-circle-o\"></i> Failed</td>\n              <td class=\"state\" ng-hide=\"res.state\"><i class=\"fa fa-chain-broken\"></i> Unknown</td>\n              <td><strong>{{res.name | limitTo : (res.name.length-13) : 12}}</strong> <span ng-show=\"false\">({{res.name | limitTo : (res.name.length-13) : 12}})</span> <span class=\"label label-danger label-alert pull-right\" tooltip-trigger tooltip-placement=\"top\" tooltip=\"Deployment alerts\">{{res.alerts}}</span></td>\n              <td ng-show=\"true\">Enabled</td>\n              <td ng-show=\"false\">Disabled</td>\n              <td class=\"success\" ng-show=\"true\">Good</td>\n              <td class=\"warning\" ng-show=\"false\">Fair</td>\n              <td class=\"danger\" ng-show=\"false\">Poor</td>\n            </tr>\n          </tbody>\n        </table>\n      </div>\n      <div class=\"dataTables_footer\">\n        <div class=\"dataTables_paginate paging_bootstrap_input\" id=\"DataTables_Table_0_paginate\">\n          <ul class=\"pagination\">\n            <li class=\"first disabled\"><span class=\"i fa fa-angle-double-left\"></span></li>\n            <li class=\"prev disabled\"><span class=\"i fa fa-angle-left\"></span></li>\n          </ul>\n          <div class=\"pagination-input\">\n            <input type=\"text\" class=\"paginate_input\" value=\"1\"><span class=\"paginate_of\">of <b>1</b></span>\n          </div>\n          <ul class=\"pagination\">\n            <li class=\"next disabled\"><span class=\"i fa fa-angle-right\"></span></li>\n            <li class=\"last disabled\"><span class=\"i fa fa-angle-double-right\"></span></li>\n          </ul>\n        </div>\n      </div>\n    </div>\n  </div>\n</section><!-- .deployments -->\n");
$templateCache.put("plugins/metrics/html/app-details/detail-jms.html","<section id=\"hk-jms\" class=\"hk-tab-content\">\n\n  <h3 class=\"pull-left\">JMS</h3>\n  <span class=\"hk-update pull-right\" tooltip-trigger tooltip-placement=\"bottom\" tooltip=\"Last update\"><i class=\"fa fa-clock-o\"></i>{{vm.endTimeStamp | date:\'HH:mm:ss\'}}</span>\n  <div class=\"panel panel-default hk-summary\">\n    <div class=\"row\">\n      <div class=\"col-sm-3 hk-summary-item\">\n        <span class=\"hk-data\">2 <i class=\"fa fa-flag\"></i></span>\n        <span class=\"hk-item\">Alerts</span>\n      </div>\n      <div class=\"col-sm-3 hk-summary-item\">\n        <span class=\"hk-data\">1270 MB</span>\n        <span class=\"hk-item\">Average Heap Usage</span>\n      </div>\n      <div class=\"col-sm-3 hk-summary-item\">\n        <span class=\"hk-data\">5 s</span>\n        <span class=\"hk-item\">Last Garbage Collection (Duration)</span>\n      </div>\n      <div class=\"col-sm-3 hk-summary-item\">\n        <span class=\"hk-data\">2000 MB</span>\n        <span class=\"hk-item\">Maximum Heap</span>\n      </div>\n    </div>\n  </div>\n\n  <div class=\"hk-info-top clearfix\">\n    <h3 class=\"pull-left\" tooltip-trigger tooltip-placement=\"top\" tooltip=\"Expand/collapse\"><button class=\"btn btn-link hk-trigger\"><i class=\"fa fa-plus-square-o\"></i> Alerts <span>(0)</span></button></h3>\n    <span class=\"hk-settings pull-right\"><a href=\"#\" ng-controller=\"MetricsAlertController as mac\" ng-click=\"mac.openSetup()\"><i class=\"fa fa-cog\"></i>Alert Settings</a></span>\n  </div>\n  <div class=\"clearfix\">\n    <p>No alerts.</p>\n  </div>\n\n</section>");
$templateCache.put("plugins/metrics/html/app-details/detail-jvm.html","<section id=\"hk-jvm-metrics\" class=\"hk-tab-content\">\n\n  <h3 class=\"pull-left\">JVM Status</h3>\n\n  <span class=\"hk-update pull-right\" tooltip-trigger tooltip-placement=\"top\" tooltip=\"Last update\"><i class=\"fa fa-clock-o\"></i>{{vm.endTimeStamp | date:\'HH:mm:ss\'}}</span>\n  <div class=\"panel panel-default hk-summary\">\n    <div class=\"row\">\n      <div class=\"col-sm-3 hk-summary-item\">\n        <span class=\"hk-data\">{{vm.alertList.length}} <i class=\"fa fa-flag\" ng-show=\"vm.alertList.length > 0\"></i></span>\n        <span class=\"hk-item\">JVM Alerts</span>\n      </div>\n      <div class=\"col-sm-3 hk-summary-item\">\n        <span class=\"hk-data\" ng-show=\"vm.heapUsage\">{{ vm.heapUsage.avg / 1024 / 1024 | number : 0 }} MB</span>\n        <span class=\"hk-data\" ng-hide=\"vm.heapUsage\">n/a</span>\n        <span class=\"hk-item\">Average Heap Usage</span>\n      </div>\n      <div class=\"col-sm-3 hk-summary-item\">\n        <span class=\"hk-data\" ng-show=\"vm.accGCDuration\">{{ vm.accGCDuration }} ms</span>\n        <span class=\"hk-data\" ng-hide=\"vm.accGCDuration\">n/a</span>\n        <span class=\"hk-item\">GC Duration</span>\n      </div>\n      <div class=\"col-sm-3 hk-summary-item\">\n        <span class=\"hk-data\" ng-show=\"vm.heapMax\">{{ vm.heapMax.max / 1024 / 1024 | number : 0 }} MB</span>\n        <span class=\"hk-data\" ng-hide=\"vm.heapUsage\">n/a</span>\n        <span class=\"hk-item\">Maximum Heap Usage</span>\n      </div>\n    </div>\n  </div>\n\n  <div class=\"hk-info-top clearfix\">\n    <h3 class=\"pull-left\">\n      <button class=\"btn btn-link hk-trigger\" ng-click=\"vm.showAllAlerts = !vm.showAllAlerts\" tooltip-trigger\n              tooltip-placement=\"top\" tooltip=\"Expand/collapse\">\n        <i class=\"fa\" ng-show=\"vm.alertList.length > 0\"\n           ng-class=\"vm.showAllAlerts ? \'fa-minus-square-o\' : \'fa-plus-square-o\'\"></i> JVM Alerts\n        <span ng-show=\"vm.alertList.length > 0\">\n          ({{vm.showAllAlerts ? vm.alertList.length : vm.math.min(vm.alertList.length, 3)}} of {{vm.alertList.length}})\n        </span>\n      </button>\n    </h3>\n    <span class=\"hk-settings pull-left\">\n      <a href=\"#\" ng-controller=\"JvmAlertController as jac\" ng-click=\"jac.openSetup()\">\n        <i class=\"fa fa-cog\"></i>Alert Settings\n      </a>\n    </span>\n  </div>\n  <div class=\"clearfix\">\n    <!-- No Alerts -->\n    <div class=\"panel panel-default alert alert-info\" ng-show=\"vm.alertList.length === 0\">\n      <div class=\"hk-alert-icon\"><i class=\"fa fa-flag gray\"></i></div>\n      <div class=\"hk-event\">No Alerts.</div>\n    </div>\n    <!-- Alerts exist -->\n    <hk-alert-panel-list class=\"clearfix\" hk-alert-list=\"vm.alertList\"\n                         hk-limit=\"(vm.showAllAlerts ? 100000 : 3)\"></hk-alert-panel-list>\n  </div>\n\n\n  <div class=\"hk-info-top clearfix\">\n    <h3 class=\"pull-left\">Metrics</h3>\n    <div class=\"hk-update pull-right\">\n      <button class=\"btn btn-link hk-chart-update\" tooltip-trigger tooltip-placement=\"top\" tooltip=\"Update chart\" ng-click=\"vm.getJvmChartData()\"><i class=\"fa fa-refresh\"></i></button>\n    </div>\n  </div>\n\n  <div class=\"panel panel-default hk-graph\" ng-if=\"vm.chartGCDurationData\">\n    <h2>JVM Heap Usage</h2>\n    <div class=\"hk-graph-container hk-graph-metrics\">\n      <!-- HINT: colors for the chart can be changed in the hawkular-charts.css -->\n      <hawkular-chart\n          multi-data=\"vm.chartHeapData\"\n          chart-type=\"multiline\"\n          y-axis-units=\"Usage (MB)\"\n          chart-height=\"250\">\n      </hawkular-chart>\n    </div>\n    <div class=\"row hk-legend text-left hk-legend-metrics\">\n      <div class=\"col-md-3 col-lg-2\">\n        <div class=\"hk-graphselector hk-blue\">\n          <input type=\"checkbox\" id=\"h-used\" checked=\"checked\" ng-click=\"vm.toggleChartData(\'Heap Used\')\">\n          <label for=\"h-used\"><span>Used</span></label>\n        </div>\n      </div>\n      <div class=\"col-md-3 col-lg-2\">\n        <div class=\"hk-graphselector hk-gray\">\n          <input type=\"checkbox\" id=\"h-committed\" checked=\"checked\" ng-click=\"vm.toggleChartData(\'Heap Committed\')\">\n          <label for=\"h-committed\"><span>Committed</span></label>\n        </div>\n      </div>\n      <div class=\"col-md-3 col-lg-2\">\n        <div class=\"hk-graphselector hk-orange\">\n          <input type=\"checkbox\" id=\"h-maximum\" checked=\"checked\" ng-click=\"vm.toggleChartData(\'Heap Max\')\">\n          <label for=\"h-maximum\"><span>Maximum</span></label>\n        </div>\n      </div>\n    </div>\n  </div>\n\n  <div class=\"panel panel-default hk-graph\" ng-if=\"vm.chartGCDurationData\">\n    <h2>Non Heap Usage</h2>\n    <div class=\"hk-graph-container hk-graph-metrics\">\n      <!-- HINT: colors for the chart can be changed in the hawkular-charts.css -->\n      <hawkular-chart\n          multi-data=\"vm.chartNonHeapData\"\n          chart-type=\"multiline\"\n          y-axis-units=\"Usage (MB)\"\n          chart-height=\"250\">\n      </hawkular-chart>\n    </div>\n    <div class=\"row hk-legend text-left hk-legend-metrics\">\n      <div class=\"col-md-3 col-lg-2\">\n        <div class=\"hk-graphselector hk-blue\">\n          <input type=\"checkbox\" id=\"nh-used\" checked=\"checked\" ng-click=\"vm.toggleChartData(\'NonHeap Used\')\">\n          <label for=\"nh-used\"><span>Used</span></label>\n        </div>\n      </div>\n      <div class=\"col-md-3 col-lg-2\">\n        <div class=\"hk-graphselector hk-gray\">\n          <input type=\"checkbox\" id=\"nh-committed\" checked=\"checked\" ng-click=\"vm.toggleChartData(\'NonHeap Committed\')\">\n          <label for=\"nh-committed\"><span>Committed</span></label>\n        </div>\n      </div>\n    </div>\n  </div>\n\n  <div class=\"panel panel-default hk-graph\" ng-if=\"vm.chartGCDurationData\">\n    <h2>GC Duration</h2>\n    <div class=\"hk-graph-container hk-graph-metrics\">\n      <!-- HINT: colors for the chart can be changed in the hawkular-charts.css -->\n      <hawkular-chart\n        data=\"vm.chartGCDurationData\"\n        chart-type=\"histogram\"\n        alert-value=\"{{vm.threshold}}\"\n        use-zero-min-value=\"true\"\n        hide-high-low-values=\"true\"\n        y-axis-units=\"GC Duration (ms)\"\n        chart-height=\"250\">\n      </hawkular-chart>\n    </div>\n    <div class=\"hk-legend text-left hk-legend-metrics\">\n    </div>\n  </div>\n\n</section>\n");
$templateCache.put("plugins/metrics/html/app-details/detail-platform.html","<section id=\"hk-platform-metrics\" class=\"hk-tab-content\" xmlns=\"http://www.w3.org/1999/html\">\n\n  <h3 class=\"pull-left\">Platform Status</h3>\n\n  <span class=\"hk-update pull-right\" tooltip-trigger tooltip-placement=\"top\" tooltip=\"Last update\"><i class=\"fa fa-clock-o\"></i>{{vm.endTimeStamp | date:\'HH:mm:ss\'}}</span>\n  <div class=\"panel panel-default hk-summary\">\n    <div class=\"row\">\n      <div class=\"col-sm-3 hk-summary-item\">\n        <span class=\"hk-data\">{{os.alertList.length}}\n            <i class=\"fa fa-flag\" ng-show=\"os.alertList.length > 0\"></i></span>\n        <span class=\"hk-item\">Platform Alerts</span>\n      </div>\n      <div class=\"col-sm-3 hk-summary-item\">\n        <span class=\"hk-data\" ng-show=\"os.memoryAvail\">{{ os.memoryAvail.avg / 1024 / 1024 | number : 0 }} MB</span>\n        <span class=\"hk-data\" ng-hide=\"os.memoryAvail\">Loading...</span>\n        <span class=\"hk-item\">Average Memory Available</span>\n      </div>\n      <div class=\"col-sm-3 hk-summary-item\">\n        <span class=\"hk-data\" ng-show=\"os.cpuUsage\">{{ os.cpuUsage.avg * 100 | number : 1 }} %</span>\n        <span class=\"hk-data\" ng-hide=\"os.cpuUsage\">Loading...</span>\n        <span class=\"hk-item\">CPU Usage</span>\n      </div>\n      <div class=\"col-sm-3 hk-summary-item\">\n        <span class=\"hk-data\" ng-show=\"os.cpuUsage\">{{ os.cpuUsage.max * 100 | number : 1 }} %</span>\n        <span class=\"hk-data\" ng-hide=\"os.cpuUsage\">Loading...</span>\n        <span class=\"hk-item\">Maximum CPU Usage</span>\n      </div>\n    </div>\n  </div>\n\n<!--\n  <div class=\"hk-info-top clearfix\">\n    <h3 class=\"pull-left\">\n      <button class=\"btn btn-link hk-trigger\" ng-click=\"vm.showAllAlerts = !vm.showAllAlerts\" tooltip-trigger\n              tooltip-placement=\"top\" tooltip=\"Expand/collapse\">\n        <i class=\"fa\" ng-show=\"vm.alertList.length > 0\"\n           ng-class=\"vm.showAllAlerts ? \'fa-minus-square-o\' : \'fa-plus-square-o\'\"></i> JVM Alerts\n        <span ng-show=\"vm.alertList.length > 0\">\n          ({{vm.showAllAlerts ? vm.alertList.length : vm.math.min(vm.alertList.length, 3)}} of {{vm.alertList.length}})\n        </span>\n      </button>\n    </h3>\n    <span class=\"hk-settings pull-left\">\n      <a href=\"#\" ng-controller=\"JvmAlertController as jac\" ng-click=\"jac.openSetup()\">\n        <i class=\"fa fa-cog\"></i>Alert Settings\n      </a>\n    </span>\n  </div>\n-->\n  <div class=\"clearfix\">\n    <!-- No Alerts -->\n    <div class=\"panel panel-default alert alert-info\" ng-show=\"os.alertList.length === 0\">\n      <div class=\"hk-alert-icon\"><i class=\"fa fa-flag gray\"></i></div>\n      <div class=\"hk-event\">No Alerts.</div>\n    </div>\n    <!-- Alerts exist -->\n    <hk-alert-panel-list class=\"clearfix\" hk-alert-list=\"os.alertList\"\n                         hk-limit=\"(os.showAllAlerts ? 100000 : 3)\"></hk-alert-panel-list>\n  </div>\n\n\n  <div class=\"hk-info-top clearfix\">\n    <h3 class=\"pull-left\">Metrics</h3>\n    <div class=\"hk-update pull-right\">\n      <button class=\"btn btn-link hk-chart-update\" tooltip-trigger tooltip-placement=\"top\"\n              tooltip=\"Update chart\" ng-click=\"os.getCPUChartData()\"><i class=\"fa fa-refresh\"></i></button>\n    </div>\n  </div>\n\n  <div class=\"panel panel-default hk-graph\" ng-if=\"os.chartMemoryUsageData\">\n    <h2>Memory Usage</h2>\n    <div class=\"hk-graph-container hk-graph-metrics\" ng-if=\"os.resolvedMemoryData\">\n      <!-- HINT: colors for the chart can be changed in the hawkular-charts.css -->\n      <hawkular-chart\n          data=\"os.chartMemoryUsageData\"\n          chart-type=\"area\"\n          hide-high-low-values=\"false\"\n          y-axis-units=\"Available (MB)\"\n          chart-height=\"250\">\n      </hawkular-chart>\n    </div>\n  </div>\n\n  <div class=\"panel panel-default hk-graph\" ng-if=\"os.chartCpuData\">\n    <h2>CPU Usage</h2>\n      <!-- cpu summary usage over all cpus -->\n    <div class=\"hk-graph-container hk-graph-metrics\" ng-if=\"os.resolvedCPUData\">\n      <!-- HINT: colors for the chart can be changed in the hawkular-charts.css -->\n      <hawkular-chart\n          data=\"os.chartCpuData\"\n          chart-type=\"rhqbar\"\n          hide-high-low-values=\"false\"\n          y-axis-units=\"Usage (%)\"\n          chart-height=\"250\">\n      </hawkular-chart>\n    </div>\n\n      <!-- mini charts per cpu -->\n\n      <div class=\"panel panel-default hk-graph\" ng-if=\"os.resolvedCPUData\">\n        <div class=\"row\">\n          <!-- TODO we should show them as rows of 2 mini-charts -->\n        <div class=\"hk-graph-container hk-graph-metrics\"  ng-repeat=\"cpu in os.processorList\">\n          <span ng-show=\"os.chartCpuDataMulti[cpu]\">\n              <!-- HINT: colors for the chart can be changed in the hawkular-charts.css -->\n            <hawkular-chart\n              data=\"os.chartCpuDataMulti[cpu]\"\n              chart-type=\"rhqbar\"\n              hide-high-low-values=\"false\"\n              y-axis-units=\"Usage (%)\"\n              chart-height=\"150\">\n             </hawkular-chart>\n           </span>\n           <span class=\"hk-data\" ng-show=\"!os.chartCpuDataMulti[cpu]\">Loading ...</span>\n          <span class=\"hk-item\">{{os.processorListNames[cpu]}}</span>\n        </div>\n      </div>\n    </div>\n  </div>\n\n  <div class=\"panel panel-default hk-graph\">\n    <h2>File System usage</h2>\n\n\n      <div class=\"hk-resource-container\"\n       ng-repeat=\"fs in os.fileStoreList | filter: os.filter| orderBy:\'name\':osSortInv\">\n\n      <div class=\"panel panel-default hk-summary\">\n          <div class=\"panel-heading\">\n              <span class=\"hk-heading pull-left\">{{fs.name}}</span>\n          </div>\n          <div class=\"row\"></div>\n      </div>\n      <div class=\"hk-panel-collapse-area\" ng-class=\"{\'hk-collapsed\' : !os.expandedList[fs.id]}\">\n        <a href=\"#\" ng-click=\"os.expandedList[fs.id] = !os.expandedList[fs.id]\">\n          <span ng-hide=\"os.expandedList[fs.id]\">View Metrics</span>\n          <span ng-show=\"os.expandedList[fs.id]\">Hide Metrics</span>\n          <i class=\"fa\"\n             ng-class=\"os.expandedList[fs.id] ? \'fa-chevron-circle-up\' : \'fa-chevron-circle-down\'\"></i>\n        </a>\n      </div>\n\n      <div class=\"hk-collapsible-area\" ng-class=\"{ \'hide\': !os.expandedList[fs.id]}\" ng-if=\"os.expandedList[fs.id]\">\n\n        <div class=\"hk-info-top clearfix\">\n          <h3 class=\"pull-left\">Metrics</h3>\n\n          <div class=\"hk-update pull-right\">\n            <button class=\"btn btn-link hk-chart-update\" tooltip-trigger tooltip-placement=\"top\" tooltip=\"Update chart\">\n              <i class=\"fa fa-refresh\"></i>\n            </button>\n          </div>\n        </div>\n\n        <div class=\"panel panel-default hk.graph\" ng-if=\"os.resolvedChartFileSystemData[fs.id]\">\n          <div class=\"hk-graph-container hk-graph-metrics\">\n            <!-- HINT: colors for the chart can be changed in the hawkular-charts.css -->\n            <hawkular-chart\n                  multi-data=\"os.chartFileSystemData[fs.id]\"\n                  chart-type=\"multiline\"\n                  y-axis-units=\"FS Usage (MB)\"\n                  chart-height=\"250\">\n            </hawkular-chart>\n          </div>\n          <div class=\"hk-legend text-left hk-legend-metrics\">\n            <div class=\"col-md-12\">\n              <h4>Connection Availability</h4>\n              <div class=\"hk-graphselector hk-orange\">\n                <input id=\"connavail_{{$index}}\" type=\"checkbox\"\n                     ng-checked=\"!os.skipChartData[fs.id + \'_Total\']\"\n                     ng-click=\"os.toggleChartData(fs.id + \'_Total\')\">\n                <label for=\"connavail_{{$index}}\"><span>Total space</span></label>\n              </div>\n              <div class=\"hk-graphselector hk-blue\">\n                <input id=\"conninuse_{{$index}}\" type=\"checkbox\"\n                     ng-checked=\"!os.skipChartData[fs.id + \'_Free\']\"\n                     ng-click=\"os.toggleChartData(fs.id + \'_Free\')\">\n                <label for=\"conninuse_{{$index}}\"><span>Free space</span></label>\n              </div>\n            </div>\n          </div>\n        </div>\n        </div>\n      </div>\n    </div>\n\n</section>\n");
$templateCache.put("plugins/metrics/html/app-details/detail-transactions.html","<section id=\"hk-transactions\" class=\"hk-tab-content\">\n\n  <h3 class=\"pull-left\">Transactions</h3>\n  <span class=\"hk-update pull-right\" tooltip-trigger tooltip-placement=\"bottom\" tooltip=\"Last update\"><i class=\"fa fa-clock-o\"></i>{{vm.endTimeStamp | date:\'HH:mm:ss\'}}</span>\n  <div class=\"panel panel-default hk-summary\">\n    <div class=\"row\">\n      <div class=\"col-sm-3 hk-summary-item\">\n        <span class=\"hk-data\">2 <i class=\"fa fa-flag\"></i></span>\n        <span class=\"hk-item\">Alerts</span>\n      </div>\n      <div class=\"col-sm-3 hk-summary-item\">\n        <span class=\"hk-data\">1270 MB</span>\n        <span class=\"hk-item\">Average Heap Usage</span>\n      </div>\n      <div class=\"col-sm-3 hk-summary-item\">\n        <span class=\"hk-data\">5 s</span>\n        <span class=\"hk-item\">Last Garbage Collection (Duration)</span>\n      </div>\n      <div class=\"col-sm-3 hk-summary-item\">\n        <span class=\"hk-data\">2000 MB</span>\n        <span class=\"hk-item\">Maximum Heap</span>\n      </div>\n    </div>\n  </div>\n\n  <div class=\"hk-info-top clearfix\">\n    <h3 class=\"pull-left\" tooltip-trigger tooltip-placement=\"top\" tooltip=\"Expand/collapse\"><button class=\"btn btn-link hk-trigger\"><i class=\"fa fa-plus-square-o\"></i> Alerts <span>(0)</span></button></h3>\n    <span class=\"hk-settings pull-right\"><a href=\"#\" ng-controller=\"MetricsAlertController as mac\" ng-click=\"mac.openSetup()\"><i class=\"fa fa-cog\"></i>Alert Settings</a></span>\n  </div>\n  <div class=\"clearfix\">\n    <p>No alerts.</p>\n  </div>\n\n</section>");
$templateCache.put("plugins/metrics/html/app-details/detail-web.html","<section id=\"hk-web\" class=\"hk-tab-content\">\n\n  <h3 class=\"pull-left\">Web Status</h3>\n  <span class=\"hk-update pull-right\" tooltip-trigger tooltip-placement=\"top\" tooltip=\"Last update\"><i class=\"fa fa-clock-o\"></i>{{vm.endTimeStamp | date:\'HH:mm:ss\'}}</span>\n  <div class=\"panel panel-default hk-summary\">\n    <div class=\"row\">\n      <div class=\"col-sm-3 hk-summary-item\">\n        <span class=\"hk-data\">{{vm.alertList.length}} <i class=\"fa fa-flag\" ng-show=\"vm.alertList.length > 0\"></i></span>\n        <span class=\"hk-item\">Web Alerts</span>\n      </div>\n      <div class=\"col-sm-3 hk-summary-item\">\n        <span class=\"hk-data\">{{ vm.activeWebSessions | number:0 }}</span>\n        <span class=\"hk-item\">Active Sessions (Average)</span>\n      </div>\n      <div class=\"col-sm-3 hk-summary-item\">\n        <span class=\"hk-data\">{{ vm.requestTime / vm.requestCount | number:0 }} ms</span>\n        <span class=\"hk-item\">Response Time (Average)</span>\n      </div>\n      <div class=\"col-sm-3 hk-summary-item\">\n        <span class=\"hk-data\">{{ vm.requestCount }}</span>\n        <span class=\"hk-item\">Request Count</span>\n      </div>\n    </div>\n  </div>\n\n  <!-- Alerts -->\n  <div class=\"hk-info-top clearfix\">\n    <h3 class=\"pull-left\">\n      <button class=\"btn btn-link hk-trigger\" ng-click=\"showAllAlerts = !showAllAlerts\" tooltip-trigger tooltip-placement=\"top\" tooltip=\"Expand/collapse\"><i class=\"fa\" ng-show=\"vm.alertList.length > 0\" ng-class=\"showAllAlerts ? \'fa-minus-square-o\' : \'fa-plus-square-o\'\"></i> Web Alerts <span ng-show=\"vm.alertList.length > 0\">({{showAllAlerts ? vm.alertList.length : vm.math.min(vm.alertList.length, 3)}} of {{vm.alertList.length}})</span></button>\n    </h3>\n    <span class=\"hk-settings pull-left\">\n      <a href=\"#\" ng-controller=\"WebAlertController as wac\" ng-click=\"wac.openSetup()\">\n        <i class=\"fa fa-cog\"></i>Alert Settings\n      </a>\n    </span>\n  </div>\n  <div class=\"clearfix\">\n    <!-- No Alerts -->\n    <div class=\"panel panel-default alert alert-info\" ng-show=\"vm.alertList.length === 0\">\n      <div class=\"hk-alert-icon\"><i class=\"fa fa-flag gray\"></i></div>\n      <div>No alerts.</div>\n    </div>\n    <!-- Alerts exist -->\n    <!-- Alerts exist -->\n    <hk-alert-panel-list class=\"clearfix\" hk-alert-list=\"vm.alertList\"\n                         hk-limit=\"(vm.showAllAlerts ? 100000 : 3)\"></hk-alert-panel-list>\n  </div>\n\n\n  <div class=\"hk-info-top clearfix\">\n    <h3 class=\"pull-left\">Metrics</h3>\n    <div class=\"hk-update pull-right\">\n      <button class=\"btn btn-link hk-chart-update\" tooltip-trigger tooltip-placement=\"top\" tooltip=\"Update chart\" ng-click=\"vm.getWebChartData()\"><i class=\"fa fa-refresh\"></i></button>\n    </div>\n  </div>\n\n  <div class=\"panel panel-default hk-graph\" >\n    <h2>Web Sessions</h2>\n    <div class=\"hk-graph-container hk-graph-metrics\">\n      <!-- HINT: colors for the chart can be changed in the hawkular-charts.css -->\n      <hawkular-chart\n        multi-data=\"vm.chartWebSessionData\"\n        chart-type=\"multiline\"\n        y-axis-units=\"Count (#)\"\n        chart-height=\"250\">\n      </hawkular-chart>\n    </div>\n    <div class=\"row hk-legend text-left hk-legend-metrics\">\n      <div class=\"col-md-3 col-lg-2\">\n        <div class=\"hk-graphselector hk-green\">\n          <input type=\"checkbox\" id=\"active\" checked=\"checked\" ng-click=\"vm.toggleChartData(\'Active Sessions\')\">\n          <label for=\"active\"><span>Active Sessions</span></label>\n        </div>\n      </div>\n      <div class=\"col-md-3 col-lg-2\">\n        <div class=\"hk-graphselector hk-orange\">\n          <input type=\"checkbox\" id=\"expired\" checked=\"checked\" ng-click=\"vm.toggleChartData(\'Expired Sessions\')\">\n          <label for=\"expired\"><span>Expired Sessions</span></label>\n        </div>\n      </div>\n      <div class=\"col-md-3 col-lg-2\">\n        <div class=\"hk-graphselector hk-red\">\n          <input type=\"checkbox\" id=\"rejected\" checked=\"checked\" ng-click=\"vm.toggleChartData(\'Rejected Sessions\')\">\n          <label for=\"rejected\"><span>Rejected Sessions</span></label>\n        </div>\n      </div>\n    </div>\n  </div>\n\n\n</section>\n");
$templateCache.put("plugins/metrics/html/directives/alert-list.html","<div>\n  <hk-alert-panel ng-repeat=\"alert in alertList | orderBy: \'-start\' | limitTo: (limit ? limit : 1000) track by $index\"\n                  hk-alert=\"alert\" hk-refresh=\"alertResolve(hkAlert)\"\n                  hk-persona=\"$root.currentPersona\"></hk-alert-panel>\n</div>\n");
$templateCache.put("plugins/metrics/html/directives/alert-setup-notification.html","<div class=\"hk-alerts-feedback\" hk-clear-notifications=\"hkNotifications.alerts\">\n    <div ng-repeat=\"notification in hkNotifications.alerts\">\n        <div ng-switch=\"notification.type\">\n            <div class=\"alert alert-success\" ng-switch-when=\"success\">\n                <span class=\"pficon pficon-ok\"></span>\n                <strong>{{notification.message}}</strong>\n            </div>\n\n            <div class=\"alert alert-danger\" ng-switch-when=\"error\">\n        <span class=\"pficon-layered\">\n          <span class=\"pficon pficon-error-octagon\"></span>\n          <span class=\"pficon pficon-error-exclamation\"></span>\n        </span>\n                <strong>Error:</strong> {{notification.message}}</a>\n            </div>\n        </div>\n    </div>\n</div>");
$templateCache.put("plugins/metrics/html/directives/alert.html","<div>\n  <div class=\"panel panel-default alert alert-danger\">\n    <div class=\"hk-alert-icon\">\n      <i class=\"fa fa-flag\"></i>\n    </div>\n\n    <div class=\"hk-date\">\n      {{alert.start | date:\'d MMM y HH:mm:ss\' }}\n    </div>\n\n    <div class=\"hk-event\" ng-switch on=\"alert.alertType\">\n      <div ng-switch-when=\"PINGAVAIL\">\n        Server <strong>down</strong> for\n        <hk-time-interval hk-time=\"alert.durationTime\"></hk-time-interval>\n        (until\n        <span ng-show=\"alert.isThisYear && alert.isToday\">{{alert.end | date:\'HH:mm\' }}).</span>\n        <span ng-show=\"alert.isThisYear && !alert.isToday\">{{alert.end | date:\'d MMM HH:mm:ss\' }}).</span>\n        <span ng-show=\"!alert.isThisYear\">{{alert.end | date:\'d MMM y HH:mm:ss\' }}).</span>\n      </div>\n      <div ng-switch-when=\"PINGRESPONSE\">\n        <strong>Response time</strong> was above the threshold ({{alert.threshold | number: 0}} ms) for\n        <hk-time-interval hk-time=\"alert.durationTime\"></hk-time-interval>\n        (until\n        <span ng-show=\"alert.isThisYear && alert.isToday\">{{alert.end | date:\'HH:mm\' }}).</span>\n        <span ng-show=\"alert.isThisYear && !alert.isToday\">{{alert.end | date:\'d MMM HH:mm:ss\' }}).</span>\n        <span ng-show=\"!alert.isThisYear\">{{alert.end | date:\'d MMM y HH:mm:ss\' }}).</span>\n        The average response time was {{alert.avg | number: 0}} ms.\n      </div>\n      <div ng-switch-when=\"PHEAP\">\n        <strong>Heap Memory</strong>: The Heap memory usage was {{alert.avg / 1024 / 1024 | number:2}} MB.\n      </div>\n      <div ng-switch-when=\"NHEAP\">\n        <strong>Non Heap Memory</strong>: The Non Heap memory usage was {{alert.avg / 1024 / 1024 | number:2}} MB.\n      </div>\n      <div ng-switch-when=\"GARBA\">\n        <strong>Garbage collection</strong>: The garbage collection took more than {{alert.avg | number:2}} ms.\n      </div>\n      <div ng-switch-when=\"DSCONN\">\n        <strong>Available Connections</strong>: The number of available connections was {{alert.avg}}.\n      </div>\n      <div ng-switch-when=\"DSRESP\">\n        <strong>Responsiveness</strong>: The connection {{alert.condition}} was {{alert.avg}} ms.\n      </div>\n      <div ng-switch-when=\"ACTIVE_SESSIONS\">\n        <strong>Active Web Sessions</strong>: The number of active web sessions was {{alert.avg}}.\n      </div>\n      <div ng-switch-when=\"EXPIRED_SESSIONS\">\n        <strong>Expired Web Sessions</strong>: The number of expired web sessions was {{alert.avg}}.\n      </div>\n      <div ng-switch-when=\"REJECTED_SESSIONS\">\n        <strong>Rejected Web Sessions</strong>: The number of rejected web sessions was {{alert.avg}}.\n      </div>\n      <div ng-switch-default>\n        <strong>Alert</strong>: <code>{{alert}}</code>\n      </div>\n    </div>\n\n    <div class=\"alert-resolver\">\n      <a ng-click=\"alertResolve(alert, $index)\" tooltip=\"Mark as resolved\"\n         tooltip-placement=\"top\"\n         tooltip-trigger=\"mouseenter\"\n         tooltip-popup-delay=\"500\">\n        <i class=\"fa\" ng-class=\"{\'fa-check-square-o\': hover, \'fa-square-o\': !hover}\"\n           ng-mouseenter=\"hover = true\"\n           ng-mouseleave=\"hover = false\">\n        </i>\n      </a>\n    </div>\n  </div>\n</div>\n");
$templateCache.put("plugins/metrics/html/directives/fieldset-dampening.html","<fieldset>\n  <hk-switch ng-show=\"hkSwitchEnabled\"\n             hk-model=\"hkSwitch\"\n             id=\"usage-less-switch\" class=\"pull-right-switch\"></hk-switch>\n  <legend>{{hkTitle || \'Alert\'}}</legend>\n  <div class=\"form-group\">\n    <label class=\"col-sm-3 control-label\">Create Alert</label>\n\n    <div class=\"col-sm-9\">\n      <div class=\"radio\">\n        <label for=\"every-time-heap\">\n          <input type=\"radio\" name=\"alert-heap\" id=\"every-time-heap\" ng-value=\"false\" ng-model=\"durationEnabled\"\n                 ng-click=\"durationToggle()\" checked=\"\" ng-disabled=\"hkDisabled || (hkSwitchEnabled && !hkSwitch)\">\n          {{hkTitleMet || \'Every time conditions are met.\'}}\n        </label>\n      </div>\n      <div class=\"radio\">\n        <label for=\"greater-time-heap\">\n          <input type=\"radio\" name=\"alert-heap\" id=\"greater-time-heap\" ng-value=\"true\" ng-model=\"durationEnabled\"\n                 ng-click=\"durationToggle()\" ng-disabled=\"hkDisabled || (hkSwitchEnabled && !hkSwitch)\">\n          {{hkTitleUnmet || \'Only when conditions are met for greater than:\'}}\n        </label>\n      </div>\n      <hk-time-input hk-duration=\"hkDuration\"\n                     hk-disabled=\"hkDisabled || !durationEnabled || (hkSwitchEnabled && !hkSwitch)\"\n                     hk-change=\"durationChange()\"\n                     id=\"dw-duration\"></hk-time-input>\n    </div>\n  </div>\n</fieldset>\n");
$templateCache.put("plugins/metrics/html/directives/fieldset-notification.html","<fieldset>\n  <legend>Notification</legend>\n  <p>Receive an email notification every time the conditions are met.</p>\n\n  <div class=\"form-group\">\n    <label class=\"col-sm-3 control-label\" for=\"email-heap\">Email</label>\n\n    <div class=\"col-sm-6\">\n      <input type=\"text\" id=\"email-heap\" class=\"form-control\" ng-model=\"hkAlertEmail\" ng-disabled=\"hkDisabled\">\n    </div>\n  </div>\n</fieldset>\n");
$templateCache.put("plugins/metrics/html/directives/hk-switch.html","<div class=\"onoffswitch\" tabindex=\'0\'>\n  <input type=\"checkbox\"\n         class=\"onoffswitch-checkbox\"\n         ng-model=\"hkModel\"\n         ng-disabled=\"hkDisabled\"\n         ng-click=\"hkClick()\"\n         ng-change=\"hkChange()\"\n         id=\"{{id}}\">\n  <label class=\"onoffswitch-label\" for=\"{{id}}\">\n    <span class=\"onoffswitch-inner\">\n      <span class=\"onoffswitch-active ng-binding\">{{hkOnText}}</span>\n      <span class=\"onoffswitch-inactive ng-binding\">{{hkOffText}}</span>\n    </span>\n    <span class=\"onoffswitch-switch\"></span>\n  </label>\n</div>\n");
$templateCache.put("plugins/metrics/html/directives/time-input.html","<div class=\"input-group input-select indented\">\n  <input type=\"number\" class=\"form-control\" placeholder=\"Duration\" ng-model=\"hkConvertedDuration\"\n         ng-disabled=\"hkDisabled\" ng-change=\"durationChange()\" id=\"{{id}}\">\n  <select pf-select ng-model=\"responseUnit\" id=\"responseUnit\"\n          ng-disabled=\"hkDisabled\"\n          ng-options=\"item.value as item.label for item in timeUnits\"\n          ng-change=\"computeTimeInUnits()\"></select>\n</div>\n");
$templateCache.put("plugins/metrics/html/directives/time-interval.html","<span>\n    <span ng-show=\"hkTime.hours\">{{hkTime.hours}} hour{{hkTime.hours > 1 ? \'s\':\'\'}}</span>\n    <span ng-show=\"hkTime.hours && hkTime.minutes\">and</span>\n    <span ng-show=\"hkTime.minutes\">{{hkTime.minutes}} minute{{hkTime.minutes > 1 ? \'s\':\'\'}}</span>\n    <span ng-show=\"(hkTime.minutes && hkTime.seconds) || (hkTime.hours && hkTime.seconds)\">and</span>\n    <span ng-show=\"hkTime.seconds\">{{hkTime.seconds}} second{{hkTime.seconds > 1 ? \'s\':\'\'}}</span>\n</span>");
$templateCache.put("plugins/metrics/html/modals/alerts-ds-setup.html","<div class=\"modal-header\">\n  <button type=\"button\" class=\"close\" ng-click=\"das.cancel()\">\n    <span class=\"pficon pficon-close\"></span>\n  </button>\n  <h4 class=\"modal-title\">Datasource Alert Settings</h4>\n</div>\n<div class=\"modal-body alert-settings\">\n  <tabset>\n    <tab heading=\"Connection Availability\">\n\n      <div class=\"hk-tab-content\">\n        <p>Configure conditions settings for Connection Availability alerts and notifications.</p>\n\n        <form class=\"form-horizontal\">\n          <fieldset>\n            <legend>Available Connections</legend>\n\n            <div class=\"form-group\">\n              <label class=\"col-sm-3 control-label\" for=\"dsc-connections\">Less than</label>\n              <div class=\"col-sm-5\">\n                <input ng-model=\"das.adm.conn.conditionThreshold\"\n                       type=\"number\" min=\"0\" value=\"200\" class=\"form-control hk-input-small\" id=\"dsc-connections\">\n              </div>\n              <div class=\"col-sm-4\">\n                <hk-switch hk-model=\"das.adm.conn.conditionEnabled\"\n                           id=\"dsc-connections-switch\" class=\"pull-right\"></hk-switch>\n              </div>\n            </div>\n          </fieldset>\n          <hk-fieldset-dampening hk-duration=\"das.adm.conn.responseDuration\"\n                                 hk-disabled=\"!das.adm.conn.conditionEnabled\">\n          </hk-fieldset-dampening>\n\n          <hk-fieldset-notification hk-alert-email=\"das.adm.conn.email\"\n                                    hk-disabled=\"!das.adm.conn.conditionEnabled\">\n          </hk-fieldset-notification>\n        </form>\n      </div>\n    </tab>\n    <tab heading=\"Responsivness\">\n      <div class=\"hk-tab-content\">\n        <p>Configure conditions settings for Responsiveness alerts and notifications.</p>\n\n        <form class=\"form-horizontal\">\n          <fieldset>\n            <legend>Wait Time</legend>\n            <div class=\"form-group\">\n              <label class=\"col-sm-3 control-label\" for=\"dsc-wait\">Greater than</label>\n              <div class=\"col-sm-5\">\n                <input ng-model=\"das.adm.resp.waitTimeThreshold\" ng-disabled=\"!das.adm.resp.waitTimeEnabled\"\n                       type=\"number\" min=\"0\" value=\"200\" class=\"form-control hk-input-small\" id=\"dsc-wait\">\n              </div>\n              <div class=\"col-sm-4\">\n                <hk-switch hk-model=\"das.adm.resp.waitTimeEnabled\"\n                           id=\"dsc-wait-switch\" class=\"pull-right\"></hk-switch>\n              </div>\n            </div>\n          </fieldset>\n\n          <fieldset>\n            <legend>Creation Time</legend>\n            <div class=\"form-group\">\n              <label class=\"col-sm-3 control-label\" for=\"dsc-creation\">Greater than</label>\n              <div class=\"col-sm-5\">\n                <input ng-model=\"das.adm.resp.creationTimeThreshold\" ng-disabled=\"!das.adm.resp.creationTimeEnabled\"\n                       type=\"number\" min=\"0\" value=\"200\" class=\"form-control hk-input-small\" id=\"dsc-creation\">\n              </div>\n              <div class=\"col-sm-4\">\n                <hk-switch hk-model=\"das.adm.resp.creationTimeEnabled\"\n                           id=\"dsc-creation-switch\" class=\"pull-right\"></hk-switch>\n              </div>\n            </div>\n          </fieldset>\n\n          <hk-fieldset-dampening hk-duration=\"das.adm.resp.responseDuration\"\n                                 hk-disabled=\"!das.adm.resp.waitTimeEnabled && !das.adm.resp.creationTimeEnabled\">\n          </hk-fieldset-dampening>\n\n          <hk-fieldset-notification hk-alert-email=\"das.adm.resp.email\"\n                                    hk-disabled=\"!das.adm.resp.waitTimeEnabled && !das.adm.resp.creationTimeEnabled\">\n          </hk-fieldset-notification>\n        </form>\n      </div>\n    </tab>\n  </tabset>\n</div>\n<div class=\"modal-footer alert-settings\">\n  <button type=\"button\" class=\"btn btn-default\" ng-click=\"das.cancel()\">Cancel</button>\n  <button type=\"button\" class=\"btn btn-primary\" ng-click=\"das.save()\"\n          ng-disabled=\"das.saveProgress || !das.isSettingChange\">\n    <div ng-show=\"das.saveProgress\" class=\"spinner spinner-xs hk-modal-spinner\"></div>\n    Save\n  </button>\n</div>\n");
$templateCache.put("plugins/metrics/html/modals/alerts-jvm-setup.html","<div class=\"modal-header\">\n  <button type=\"button\" class=\"close\" ng-click=\"jas.cancel()\">\n    <span class=\"pficon pficon-close\"></span>\n  </button>\n  <h4 class=\"modal-title\">JVM Alert Settings</h4>\n</div>\n<div class=\"modal-body hk-alert-settings\">\n  <tabset>\n    <tab heading=\"Heap Usage\">\n\n      <div id=\"hk-heap\" class=\"hk-tab-content\">\n        <p>Configure conditions settings for Heap usage alerts and notifications.</p>\n\n        <form class=\"form-horizontal\">\n          <fieldset>\n            <legend>Threshold Conditions</legend>\n            <div class=\"form-group\">\n              <label class=\"col-sm-3 control-label\">Maximum usage</label>\n\n              <div class=\"col-sm-6\">\n                <span class=\"hk-input-text\">{{jas.maxUsage / 1024 / 1024 | number : 2}} MB</span>\n              </div>\n            </div>\n            <div class=\"form-group\">\n              <label class=\"col-sm-3 control-label\" for=\"usage-greater\">Usage greater than</label>\n\n              <div class=\"col-sm-5\">\n                <div class=\"input-group hk-input-small\">\n                  <input type=\"number\" min=\"0\" max=\"100\" ng-model=\"jas.adm.heap.conditionGtPercent\" class=\"form-control\"\n                         id=\"usage-greater\" ng-disabled=\"!jas.adm.heap.conditionGtEnabled\">\n\n                  <div class=\"input-group-addon\">%</div>\n                </div>\n                <span class=\"input-detail\">({{jas.adm.heap.conditionGtEnabled && jas.adm.heap.conditionGtPercent ? (jas.maxUsage * jas.adm.heap.conditionGtPercent / 100/1024/1024 | number:2) : \'-\'}} MB)</span>\n              </div>\n              <div class=\"col-sm-4\">\n                  <hk-switch hk-model=\"jas.adm.heap.conditionGtEnabled\"\n                             id=\"usage-greater-switch\" class=\"pull-right\"></hk-switch>\n              </div>\n            </div>\n            <div class=\"form-group\">\n              <label class=\"col-sm-3 control-label\" for=\"usage-less\">Usage less than</label>\n\n              <div class=\"col-sm-5\">\n                <div class=\"input-group hk-input-small\">\n                  <input type=\"number\" min=\"0\" max=\"100\" ng-model=\"jas.adm.heap.conditionLtPercent\" class=\"form-control\"\n                         id=\"usage-less\" ng-disabled=\"!jas.adm.heap.conditionLtEnabled\">\n\n                  <div class=\"input-group-addon\">%</div>\n                </div>\n                <span class=\"input-detail\">({{jas.adm.heap.conditionLtEnabled && jas.adm.heap.conditionLtPercent ? (jas.maxUsage * jas.adm.heap.conditionLtPercent / 100/1024/1024 | number:2) : \'-\'}} MB)</span>\n              </div>\n              <div class=\"col-sm-4\">\n                <hk-switch hk-model=\"jas.adm.heap.conditionLtEnabled\"\n                           id=\"usage-less-switch\" class=\"pull-right\"></hk-switch>\n              </div>\n            </div>\n          </fieldset>\n          <hk-fieldset-dampening hk-duration=\"jas.adm.heap.responseDuration\"\n                                 hk-disabled=\"!jas.adm.heap.conditionLtEnabled && !jas.adm.heap.conditionGtEnabled\">\n          </hk-fieldset-dampening>\n\n          <hk-fieldset-notification hk-alert-email=\"jas.adm.heap.email\"\n                                    hk-disabled=\"!jas.adm.heap.conditionLtEnabled && !jas.adm.heap.conditionGtEnabled\">\n          </hk-fieldset-notification>\n        </form>\n      </div>\n    </tab>\n    <tab heading=\"Non-Heap Usage\">\n      <div id=\"hk-non-heap\" class=\"hk-tab-content\">\n        <p>Configure conditions settings for Non-Heap usage alerts and notifications.</p>\n\n        <form class=\"form-horizontal\">\n          <fieldset>\n            <legend>Threshold Conditions</legend>\n            <div class=\"form-group\">\n              <label class=\"col-sm-3 control-label\">Maximum usage</label>\n\n              <div class=\"col-sm-6\">\n                <span class=\"hk-input-text\">{{jas.maxUsage / 1024 / 1024 | number : 2}} MB</span>\n              </div>\n            </div>\n            <div class=\"form-group\">\n              <label class=\"col-sm-3 control-label\" for=\"usage-greater2\">Usage greater than</label>\n\n              <div class=\"col-sm-5\">\n                <div class=\"input-group hk-input-small\">\n                  <input type=\"number\" min=\"0\" max=\"100\" ng-model=\"jas.adm.nheap.conditionGtPercent\"\n                         class=\"form-control\"\n                         id=\"usage-greater2\" ng-disabled=\"!jas.adm.nheap.conditionGtEnabled\">\n\n                  <div class=\"input-group-addon\">%</div>\n                </div>\n                <span class=\"input-detail\">({{jas.adm.nheap.conditionGtEnabled && jas.adm.nheap.conditionGtPercent ? (jas.maxUsage * jas.adm.nheap.conditionGtPercent / 100/1024/1024 | number:2) : \'-\'}} MB)</span>\n              </div>\n              <div class=\"col-sm-4\">\n                <hk-switch hk-model=\"jas.adm.nheap.conditionGtEnabled\"\n                           id=\"usage-ngreater-switch\" class=\"pull-right\"></hk-switch>\n              </div>\n            </div>\n            <div class=\"form-group\">\n              <label class=\"col-sm-3 control-label\" for=\"usage-less2\">Usage less than</label>\n\n              <div class=\"col-sm-5\">\n                <div class=\"input-group hk-input-small\">\n                  <input type=\"number\" min=\"0\" max=\"100\" ng-model=\"jas.adm.nheap.conditionLtPercent\"\n                         class=\"form-control\"\n                         id=\"usage-less2\" ng-disabled=\"!jas.adm.nheap.conditionLtEnabled\">\n\n                  <div class=\"input-group-addon\">%</div>\n                </div>\n                <span class=\"input-detail\">({{jas.adm.nheap.conditionLtEnabled && jas.adm.nheap.conditionLtPercent ? (jas.maxUsage * jas.adm.nheap.conditionLtPercent / 100/1024/1024 | number:2) : \'-\'}} MB)</span>\n              </div>\n              <div class=\"col-sm-4\">\n                <hk-switch hk-model=\"jas.adm.nheap.conditionLtEnabled\"\n                           id=\"usage-nless-switch\" class=\"pull-right\"></hk-switch>\n              </div>\n            </div>\n          </fieldset>\n          <hk-fieldset-dampening hk-duration=\"jas.adm.nheap.responseDuration\"\n                                 hk-disabled=\"!jas.adm.nheap.conditionLtEnabled && !jas.adm.nheap.conditionGtEnabled\">\n          </hk-fieldset-dampening>\n\n          <hk-fieldset-notification hk-alert-email=\"jas.adm.nheap.email\"\n                                    hk-disabled=\"!jas.adm.nheap.conditionLtEnabled && !jas.adm.nheap.conditionGtEnabled\">\n          </hk-fieldset-notification>\n        </form>\n      </div>\n    </tab>\n    <tab heading=\"Garbage Collection\">\n      <div id=\"hk-gc\" class=\"hk-tab-content\">\n        <p>Configure conditions settings for Garbage Collection alerts and notifications.</p>\n\n        <form class=\"form-horizontal\">\n          <fieldset>\n            <legend>Duration (major)</legend>\n            <div class=\"form-group\">\n              <label class=\"col-sm-3 control-label\" for=\"usage-greater\">Greater than</label>\n\n              <div class=\"col-sm-5\">\n                <div class=\"input-group hk-input-small\">\n                  <input type=\"number\" ng-model=\"jas.adm.garba.conditionThreshold\" class=\"form-control\" id=\"usage-garba\"\n                         ng-disabled=\"!jas.adm.garba.conditionEnabled\">\n\n                  <div class=\"input-group-addon\">ms</div>\n                </div>\n              </div>\n              <div class=\"col-sm-4\">\n                <hk-switch hk-model=\"jas.adm.garba.conditionEnabled\"\n                           id=\"usage-garba-switch\" class=\"pull-right\"></hk-switch>\n              </div>\n            </div>\n          </fieldset>\n          <hk-fieldset-dampening hk-duration=\"jas.adm.garba.responseDuration\"\n                                 hk-disabled=\"!jas.adm.garba.conditionEnabled\"></hk-fieldset-dampening>\n\n          <hk-fieldset-notification hk-alert-email=\"jas.adm.garba.email\"\n                                    hk-disabled=\"!jas.adm.garba.conditionEnabled\"></hk-fieldset-notification>\n        </form>\n      </div>\n    </tab>\n  </tabset>\n\n\n</div>\n<div class=\"modal-footer\">\n  <button type=\"button\" class=\"btn btn-default\" ng-click=\"jas.cancel()\">Cancel</button>\n  <button type=\"button\" class=\"btn btn-primary\" ng-click=\"jas.save()\"\n          ng-disabled=\"jas.saveProgress || !jas.isSettingChange\">\n    <div ng-show=\"jas.saveProgress\" class=\"spinner spinner-xs hk-modal-spinner\"></div>\n    Save\n  </button>\n</div>\n");
$templateCache.put("plugins/metrics/html/modals/alerts-url-availability-setup.html","<div class=\"modal-header\">\n  <button type=\"button\" class=\"close\" ng-click=\"mas.cancel()\">\n    <span class=\"pficon pficon-close\"></span>\n  </button>\n  <h4 class=\"modal-title\">Availability Alert Settings</h4>\n</div>\n\n<div class=\"modal-body hk-alert-settings\">\n  <p>Configure conditions settings for Availability alerts and notifications.</p>\n\n  <form class=\"form-horizontal\">\n    <hk-fieldset-dampening hk-duration=\"mas.adm.avail.responseDuration\"\n                           hk-title=\"Downtime\"\n                           hk-switch=\"mas.adm.avail.conditionEnabled\"\n                           hk-title-met=\"Everytime the URL is down.\"\n                           hk-title-unmet=\"Only when the URL is down for more than:\"></hk-fieldset-dampening>\n\n    <hk-fieldset-notification hk-alert-email=\"mas.adm.avail.email\"\n                              hk-disabled=\"!mas.adm.avail.conditionEnabled\"></hk-fieldset-notification>\n  </form>\n</div>\n\n<div class=\"modal-footer\">\n  <button type=\"button\" class=\"btn btn-default\" ng-click=\"mas.cancel()\">Cancel</button>\n  <button type=\"button\" class=\"btn btn-primary\" ng-click=\"mas.save()\"\n          ng-disabled=\"!mas.isSettingChange || mas.saveProgress\">\n    <div ng-show=\"mas.saveProgress\" class=\"spinner spinner-xs hk-modal-spinner\"></div>\n    Save\n  </button>\n</div>\n");
$templateCache.put("plugins/metrics/html/modals/alerts-url-response-setup.html","<div class=\"modal-header\">\n  <button type=\"button\" class=\"close\" ng-click=\"mas.cancel()\">\n    <span class=\"pficon pficon-close\"></span>\n  </button>\n  <h4 class=\"modal-title\">Response Time Alert Settings</h4>\n</div>\n\n<div class=\"modal-body hk-alert-settings\">\n  <div class=\"row\">\n    <div class=\"col-sm-9\">\n      <p>Configure conditions settings for Response Time alerts and notifications.</p>\n    </div>\n    <div class=\"col-sm-3\">\n      <hk-switch hk-model=\"mas.adm.thres.conditionEnabled\"\n                 id=\"usage-less-switch\" class=\"pull-right\"></hk-switch>\n    </div>\n  </div>\n\n  <form class=\"form-horizontal\">\n    <fieldset>\n      <legend>Response Time</legend>\n      <div class=\"form-group\">\n        <label class=\"col-sm-3 control-label\" >Time (maximum)</label>\n        <div class=\"col-sm-5 inline-row\">\n          <hk-time-input hk-duration=\"mas.adm.thres.conditionThreshold\"\n                         hk-disabled=\"!mas.adm.thres.conditionEnabled\"\n                         id=\"dw-duration\"></hk-time-input>\n        </div>\n      </div>\n    </fieldset>\n\n    <hk-fieldset-dampening hk-duration=\"mas.adm.thres.responseDuration\"\n                           hk-disabled=\"!mas.adm.thres.conditionEnabled\"></hk-fieldset-dampening>\n\n    <hk-fieldset-notification hk-alert-email=\"mas.adm.thres.email\"\n                              hk-disabled=\"!mas.adm.thres.conditionEnabled\"></hk-fieldset-notification>\n  </form>\n</div>\n\n<div class=\"modal-footer\">\n  <button type=\"button\" class=\"btn btn-default\" ng-click=\"mas.cancel()\">Cancel</button>\n  <button type=\"button\" class=\"btn btn-primary\" ng-click=\"mas.save()\"\n          ng-disabled=\"!mas.isSettingChange || mas.saveProgress\">\n    <div ng-show=\"mas.saveProgress\" class=\"spinner spinner-xs hk-modal-spinner\"></div>\n    Save\n  </button>\n</div>\n");
$templateCache.put("plugins/metrics/html/modals/alerts-web-setup.html","<div class=\"modal-header\">\n  <button type=\"button\" class=\"close\" ng-click=\"was.cancel()\">\n    <span class=\"pficon pficon-close\"></span>\n  </button>\n  <h4 class=\"modal-title\">Web Alert Settings</h4>\n</div>\n<div class=\"modal-body hk-alert-settings\">\n  <tabset>\n    <tab heading=\"Sessions\">\n\n      <div id=\"hk-heap\" class=\"hk-tab-content\">\n        <p>Configure conditions settings for Web Sessions alerts and notifications.</p>\n\n        <form class=\"form-horizontal\">\n          <fieldset>\n            <legend>Active Sessions Thresholds</legend>\n            <div class=\"form-group\">\n              <label class=\"col-sm-3 control-label\" for=\"active-min\">Minimun</label>\n\n              <div class=\"col-sm-5\">\n                <div class=\"input-group hk-input-small\">\n                  <input type=\"number\" min=\"0\" max=\"10000\" ng-model=\"was.adm.active.activeMinThreshold\" class=\"form-control\"\n                         id=\"active-min\" ng-disabled=\"!was.adm.active.activeMinEnabled\">\n\n                </div>\n              </div>\n              <div class=\"col-sm-4\">\n                  <hk-switch hk-model=\"was.adm.active.activeMinEnabled\"\n                             id=\"active-min-switch\" class=\"pull-right\"></hk-switch>\n              </div>\n            </div>\n            <div class=\"form-group\">\n              <label class=\"col-sm-3 control-label\" for=\"active-max\">Maximun</label>\n\n              <div class=\"col-sm-5\">\n                <div class=\"input-group hk-input-small\">\n                  <input type=\"number\" min=\"0\" max=\"10000\" ng-model=\"was.adm.active.activeMaxThreshold\"\n                         class=\"form-control\" id=\"active-max\" ng-disabled=\"!was.adm.active.activeMaxEnabled\">\n\n                </div>\n              </div>\n              <div class=\"col-sm-4\">\n                <hk-switch hk-model=\"was.adm.active.activeMaxEnabled\"\n                           id=\"active-max-switch\" class=\"pull-right\"></hk-switch>\n              </div>\n            </div>\n          </fieldset>\n\n          <fieldset>\n            <legend>Expired Sessions</legend>\n            <div class=\"form-group\">\n              <label class=\"col-sm-3 control-label\" for=\"expired-threshold\">Sessions Exceeding</label>\n\n              <div class=\"col-sm-5\">\n                <div class=\"input-group hk-input-small\">\n                  <input type=\"number\" min=\"0\" max=\"10000\" ng-model=\"was.adm.expired.expiredThreshold\"\n                         class=\"form-control\" id=\"expired-threshold\" ng-disabled=\"!was.adm.expired.expiredEnabled\">\n\n                </div>\n              </div>\n              <div class=\"col-sm-4\">\n                <hk-switch hk-model=\"was.adm.expired.expiredEnabled\"\n                           id=\"expired-threshold-switch\" class=\"pull-right\"></hk-switch>\n              </div>\n            </div>\n          </fieldset>\n\n          <fieldset>\n            <legend>Rejected Sessions</legend>\n            <div class=\"form-group\">\n              <label class=\"col-sm-3 control-label\" for=\"rejected-threshold\">Sessions Exceeding</label>\n\n              <div class=\"col-sm-5\">\n                <div class=\"input-group hk-input-small\">\n                  <input type=\"number\" min=\"0\" max=\"10000\" ng-model=\"was.adm.rejected.rejectedThreshold\"\n                         class=\"form-control\" id=\"rejected-threshold\" ng-disabled=\"!was.adm.rejected.rejectedEnabled\">\n\n                </div>\n              </div>\n              <div class=\"col-sm-4\">\n                <hk-switch hk-model=\"was.adm.rejected.rejectedEnabled\"\n                           id=\"rejected-threshold-switch\" class=\"pull-right\"></hk-switch>\n              </div>\n            </div>\n          </fieldset>\n\n          <hk-fieldset-dampening hk-duration=\"was.adm.active.responseDuration\"\n                                 hk-disabled=\"!was.adm.active.activeMinEnabled &&\n                                      !was.adm.active.activeMaxEnabled &&\n                                      !was.adm.expired.expiredEnabled &&\n                                      !was.adm.rejected.rejectedEnabled\">\n          </hk-fieldset-dampening>\n\n          <hk-fieldset-notification hk-alert-email=\"was.adm.active.email\"\n                                    hk-disabled=\"!was.adm.active.activeMinEnabled &&\n                                      !was.adm.active.activeMaxEnabled &&\n                                      !was.adm.expired.expiredEnabled &&\n                                      !was.adm.rejected.rejectedEnabled\">\n          </hk-fieldset-notification>\n        </form>\n      </div>\n    </tab>\n  </tabset>\n\n\n</div>\n<div class=\"modal-footer\">\n  <button type=\"button\" class=\"btn btn-default\" ng-click=\"was.cancel()\">Cancel</button>\n  <button type=\"button\" class=\"btn btn-primary\" ng-click=\"was.save()\"\n          ng-disabled=\"was.saveProgress || !was.isSettingChange\">\n    <div ng-show=\"was.saveProgress\" class=\"spinner spinner-xs hk-modal-spinner\"></div>\n    Save\n  </button>\n</div>\n");
$templateCache.put("plugins/metrics/html/modals/delete-resource.html","<div class=\"modal-header\">\n  <button type=\"button\" class=\"close\" ng-click=\"vm.cancel()\">\n    <span class=\"pficon pficon-close\"></span>\n  </button>\n  <h4 class=\"modal-title\">Delete URL</h4>\n</div>\n<div class=\"modal-body\">\n  <div class=\"form-group\">\n    <p class=\"primary-message\">Are you sure you want to stop monitoring and delete the data for the URL <strong>{{ vm.resource.properties.url }}</strong> (Resource ID: {{ vm.resource.id }}) ?</p>\n    <p>This action can\'t be undone.</p>\n  </div>\n</div>\n<div class=\"modal-footer\">\n  <button type=\"button\" class=\"btn btn-default\" ng-click=\"vm.cancel()\">Cancel</button>\n  <button type=\"button\" class=\"btn btn-danger\" ng-click=\"vm.deleteResource()\">Delete</button>\n</div>\n");
$templateCache.put("plugins/metrics/html/partials/url-alerts-view.html","<hk-alert-notification></hk-alert-notification>\n\n<div class=\"blank-slate-pf\" ng-show=\"mac.alertList.$resolved && mac.alertList.length === 0\">\n  <div class=\"blank-slate-pf-icon\">\n    <i class=\"fa fa-flag\"></i>\n  </div>\n  <h1>No alerts.</h1>\n</div>\n\n<hk-alert-panel-list class=\"clearfix\" hk-alert-list=\"mac.alertList\"></hk-alert-panel-list>\n\n<hk-pagination resource-list=\"mac.alertList\" current-page=\"mac.resCurPage\" page-setter=\"mac.setPage(pageNumber)\"\n               per-page=\"mac.resPerPage\" headers=\"mac.headerLinks\"></hk-pagination>\n\n<div class=\"clearfix\" ng-show=\"mac.alertList.length > 0\">\n  <button class=\"btn btn-default pull-right\" ng-click=\"mac.resolveAll()\" ng-disabled=\"mac.isWorking\">\n    <i class=\"fa fa-check-square-o\"></i> Resolve all\n  </button>\n</div>\n");
$templateCache.put("plugins/metrics/html/app-details/modals/detail-datasources-add.html","<div class=\"modal-header\">\n  <button type=\"button\" class=\"close\" aria-hidden=\"true\" ng-click=\"dac.onClose()\">\n    <span class=\"pficon pficon-close\"></span>\n  </button>\n  <h4 class=\"modal-title\">Add Datasource</h4>\n</div>\n\n<wizard name=\"driverAdd\" on-finish=\"dac.finishedAddDriverWizard()\" hide-indicators=\"true\">\n\n  <wz-step title=\"Select XA or Non-XA Datasource\">\n    <div class=\"modal-body\">\n      <p><strong>Step 1 of 5: Datasource Type</strong></p>\n\n      <form class=\"hk-form-horizontal\" name=\"addDatasourceForm\" novalidate>\n        <div class=\"form-group\">\n          <label>Select XA or Non-XA Datasource</label>\n          <div class=\"radio\">\n            <label>\n              <input type=\"radio\" name=\"datasource-type\" ng-model=\"dac.dsData.xaDatasource\" ng-value=\"true\"\n                     ng-init=\"dac.dsData.xaDatasource = true\">\n              XA Datasource\n              <a class=\"hk-btn-icon\" tabindex=\"-1\" role=\"button\" popover-append-to-body=\"true\" popover-placement=\"top\"\n                 popover-trigger=\"click\" popover=\"XA datasources are used by applications whose transactions are\n                 distributed across multiple databases.\"><i class=\"fa fa-info-circle\"></i>\n              </a>\n            </label>\n          </div>\n          <div class=\"radio\">\n            <label>\n              <input type=\"radio\" name=\"datasource-type\" ng-model=\"dac.dsData.xaDatasource\" ng-value=\"false\">\n              Non-XA Datasource\n              <a class=\"hk-btn-icon\" tabindex=\"-1\" role=\"button\" popover-append-to-body=\"true\" popover-placement=\"top\"\n                 popover-trigger=\"click\" popover=\"Non-XA datasources are used for applications which do not use\n                 transactions, or applications which use transactions with a single database.\">\n                <i class=\"fa fa-info-circle\"></i>\n              </a>\n            </label>\n          </div>\n        </div>\n      </form>\n\n    </div>\n    <div class=\"modal-footer\">\n      <button type=\"button\" class=\"btn btn-default hk-btn-distant\" ng-click=\"dac.onClose()\">Cancel</button>\n      <button type=\"button\" class=\"btn btn-default\" disabled >&#60; Back</button>\n      <button type=\"button\" wz-next class=\"btn btn-primary\"\n              ng-disabled=\"addDatasourceForm.$invalid\">Next &#62;</button>\n    </div>\n  </wz-step>\n\n  <wz-step title=\"Datasource Attributes\">\n    <div class=\"modal-body\">\n      <p><strong>Step 2 of 5: Datasource Attributes</strong></p>\n\n      <form class=\"form-horizontal\">\n        <fieldset>\n          <p class=\"hk-required-info pull-right\"><span class=\"hk-required\">*</span> Required field</p>\n          <div class=\"form-group\">\n            <label class=\"col-sm-3 control-label\" for=\"name\">Name</label>\n            <div class=\"col-sm-6\">\n              <input type=\"text\" id=\"name\" class=\"form-control\" ng-model=\"dac.dsData.datasourceName\"\n                     ng-change=\"dac.onDSNameChange()\">\n            </div>\n          </div>\n          <div class=\"form-group\">\n            <label class=\"col-sm-3 control-label\" for=\"jndi\"><span class=\"hk-required\">*</span> JNDI  Name\n              <a class=\"hk-btn-icon\" tabindex=\"-1\" role=\"button\" popover-append-to-body=\"true\"\n                 popover-placement=\"top\" popover-trigger=\"click\" popover=\"Specifies the JNDI Name for the datasource\">\n                <i class=\"fa fa-info-circle\"></i></a>\n            </label>\n            <div class=\"col-sm-6\">\n              <input type=\"text\" id=\"jndi\" class=\"form-control\" ng-model=\"dac.dsData.jndiName\"\n                     ng-change=\"dac.onJNDINameChange()\">\n              <span class=\"help-block\" ng-show=\"false\">JNDI Name has to start with \'java:/\' or \'java:jboss/\'</span>\n            </div>\n          </div>\n        </fieldset>\n      </form>\n    </div>\n    <div class=\"modal-footer\">\n      <button type=\"button\" class=\"btn btn-default hk-btn-distant\" ng-click=\"dac.onClose()\">Cancel</button>\n      <button type=\"button\" wz-previous class=\"btn btn-default\">&#60; Back</button>\n      <button type=\"button\" wz-next class=\"btn btn-primary\" ng-click=\"dac.exitStepDatasourceAttributes()\"\n              ng-disabled=\"!dac.dsData.jndiName\">Next &#62;</button>\n    </div>\n  </wz-step>\n\n  <wz-step title=\"Datasource Driver\">\n    <div class=\"modal-body\">\n      <p><strong>Step 3 of 5: Datasource Driver</strong></p>\n\n      <p>To connect to a datasource, your datasource vendor\'s drivers need to be installed and configured.</p>\n      <p class=\"hk-required-info pull-right\"><span class=\"hk-required\">*</span> Required field</p>\n\n      <p><span class=\"hk-required\">*</span> Add a new driver or select from an existing one.</p>\n      <div class=\"btn-table-list-container\">\n        <table class=\"table hk-table-list hk-table-select\">\n          <tbody>\n          <tr ng-hide=\"dac.driversList.$resolved\">\n            <td colspan=\"3\">\n              <div class=\"text-center hk-spinner-container\">\n                <div class=\"spinner spinner-sm\"></div> Loading JDBC Drivers\n              </div>\n            </td>\n          </tr>\n          <!-- TODO: Support sub-wizard for JDBC Driver\n          <tr ng-show=\"dac.driversList.$resolved\">\n            <td class=\"hk-td-radio\">\n              <input type=\"radio\" name=\"driver\">\n            </td>\n            <td>\n              <i class=\"fa fa-plus\"></i> Add Driver\n            </td>\n            <td class=\"hk-actions-two\">\n            </td>\n          </tr>\n          -->\n          <tr class=\"link\" ng-repeat=\"driver in dac.driversList\">\n            <td class=\"hk-td-radio\" ng-init=\"dac.dsData.driverName = dac.driversList[0].name\">\n              <input type=\"radio\" name=\"driver\" ng-model=\"dac.dsData.driverName\" value=\"{{driver.name}}\">\n            </td>\n            <td colspan=\"2\">\n              {{driver.name}}\n            </td>\n            <!-- TODO: Support for driver details and delete (does delete make sense here at all?)\n            <td class=\"hk-actions-two\">\n              <button class=\"btn btn-link\" tooltip-trigger tooltip-placement=\"top\" tooltip=\"View\">\n                <i class=\"fa fa-eye\"></i>\n              </button>\n              <button class=\"btn btn-link\" tooltip-trigger tooltip-placement=\"top\" tooltip=\"Remove\">\n                <i class=\"fa fa-trash-o\"></i>\n              </button>\n            </td>\n            -->\n          </tr>\n          </tbody>\n        </table>\n      </div>\n\n      <form class=\"form-horizontal\" ng-show=\"dac.driversList.$resolved\">\n        <fieldset ng-show=\"dac.dsData.xaDatasource\">\n          <div class=\"form-group\">\n            <label class=\"col-sm-3 control-label\" for=\"xaDSClass\"><span class=\"hk-required\">*</span> XA Datasource Class\n            </label>\n            <div class=\"col-sm-6\">\n              <input type=\"text\" id=\"xaDSClass\" class=\"form-control\" ng-model=\"dac.dsData.xaDatasourceClass\">\n            </div>\n          </div>\n        </fieldset>\n        <fieldset ng-show=\"!dac.dsData.xaDatasource\">\n          <div class=\"form-group\">\n            <label class=\"col-sm-3 control-label\" for=\"dsClass\"><span class=\"hk-required\">*</span> Datasource Class\n            </label>\n            <div class=\"col-sm-6\">\n              <input type=\"text\" id=\"dsClass\" class=\"form-control\" ng-model=\"dac.dsData.datasourceClass\">\n            </div>\n          </div>\n          <div class=\"form-group\">\n            <label class=\"col-sm-3 control-label\" for=\"connUrl\"><span class=\"hk-required\">*</span> Connection URL\n            </label>\n            <div class=\"col-sm-6\">\n              <input type=\"text\" id=\"connUrl\" class=\"form-control\" ng-model=\"dac.dsData.connectionUrl\">\n            </div>\n          </div>\n        </fieldset>\n      </form>\n\n    </div>\n    <div class=\"modal-footer\">\n      <button type=\"button\" class=\"btn btn-default hk-btn-distant\" ng-click=\"dac.onClose()\">Cancel</button>\n      <button type=\"button\" wz-previous class=\"btn btn-default\">&#60; Back</button>\n      <button type=\"button\" wz-next class=\"btn btn-primary\"\n              ng-disabled=\"!dac.dsData.driverName  ||\n              (dac.dsData.xaDatasource && !dac.dsData.xaDatasourceClass) ||\n              (!dac.dsData.xaDatasource && (!dac.dsData.datasourceClass || !dac.dsData.connectionUrl))\">\n        Next &#62;</button>\n    </div>\n  </wz-step>\n\n  <wz-step title=\"XA Properties\" wz-disabled=\"{{dac.dsData.xaDatasource ? \'false\' : \'true\' }}\">\n    <div class=\"modal-body\">\n      <p><strong>Step 4 of 5: XA Properties</strong></p>\n\n      <p>Each property is identified by the name attribute and the property value is given by the\n        xa-datasource-property element content.</p>\n\n      <form>\n        <table class=\"table hk-table-list\">\n          <thead>\n          <tr>\n            <th>\n              Name Attribute\n              <a href=\"#\" class=\"hk-btn-icon\" popover-append-to-body=\"true\" popover-placement=\"top\"\n                 popover-trigger=\"click\" popover=\"Each property is identified by the name attribute.\">\n                <i class=\"fa fa-question-circle\"></i>\n              </a>\n            </th>\n            <th>\n              Property Value\n              <a href=\"#\" class=\"hk-btn-icon\" popover-append-to-body=\"true\" popover-placement=\"top\"\n                 popover-trigger=\"click\" popover=\"Specifies a property value to assign to the XADataSource\n                 implementation class.\">\n              <i class=\"fa fa-question-circle\"></i></a>\n            </th>\n            <th></th>\n          </tr>\n          </thead>\n          <tbody>\n          <tr ng-hide=\"dac.tmpDSProperties.length\">\n            <td colspan=\"3\" class=\"text-center\">\n              No Properties defined. For XA Datasources at least one property must be specified.\n            </td>\n          </tr>\n          <tr ng-repeat=\"dsProp in dac.tmpDSProperties\">\n            <td>\n              <input type=\"text\" class=\"form-control\" ng-model=\"dsProp.name\">\n            </td>\n            <td>\n              <input type=\"text\" class=\"form-control\" ng-model=\"dsProp.value\">\n            </td>\n            <td class=\"hk-actions-one\">\n              <button class=\"btn btn-link\" tooltip-trigger tooltip-placement=\"top\" tooltip=\"Remove\"\n                      ng-click=\"dac.removeDSProperty($index)\">\n                <i class=\"fa fa-trash-o\"></i>\n              </button>\n            </td>\n          </tr>\n          <tr>\n            <td>Add Property</td>\n            <td></td>\n            <td class=\"hk-actions-one\">\n              <button class=\"btn btn-link\" tooltip-trigger tooltip-placement=\"top\" tooltip=\"Add\"\n                      ng-click=\"dac.addDSProperty()\">\n                <i class=\"fa fa-plus\"></i>\n              </button>\n            </td>\n          </tr>\n          </tbody>\n        </table>\n      </form>\n    </div>\n    <div class=\"modal-footer\">\n      <button type=\"button\" class=\"btn btn-default hk-btn-distant\" ng-click=\"dac.onClose()\">Cancel</button>\n      <button type=\"button\" wz-previous class=\"btn btn-default\">&#60; Back</button>\n      <button type=\"button\" wz-next class=\"btn btn-primary\" ng-click=\"dac.exitStepXAProperties()\"\n              ng-disabled=\"dac.dsData.xaDatasource && (!dac.tmpDSProperties.length || !dac.tmpDSProperties[0].name ||\n              !dac.tmpDSProperties[0].value)\">Next &#62;</button>\n    </div>\n  </wz-step>\n\n  <wz-step title=\"Connection Settings\">\n    <div class=\"modal-body\">\n      <p><strong>Step 5 of 5: Connection Settings</strong></p>\n\n      <form class=\"form-horizontal\">\n        <fieldset>\n          <!--<p class=\"hk-required-info pull-right\"><span class=\"hk-required\">*</span> Required field</p>-->\n          <div class=\"form-group\">\n            <label class=\"col-sm-3 control-label\" for=\"un\">User  Name</label>\n            <div class=\"col-sm-6\">\n              <input type=\"text\" id=\"un\" class=\"form-control\" ng-model=\"dac.dsData.conn.username\">\n            </div>\n          </div>\n          <div class=\"form-group\">\n            <label class=\"col-sm-3 control-label\" for=\"pw\"><!--<span class=\"hk-required\">*</span>--> Password</label>\n            <div class=\"col-sm-6\">\n              <input type=\"password\" id=\"pw\" class=\"form-control\" ng-model=\"dac.dsData.conn.password\">\n            </div>\n          </div>\n          <div class=\"form-group\">\n            <label class=\"col-sm-3 control-label\" for=\"sd\">Security Domain\n              <a class=\"hk-btn-icon\" tabindex=\"-1\" role=\"button\" popover-append-to-body=\"true\" popover-placement=\"top\"\n                 popover-trigger=\"click\" popover=\"Specify the security domain which defines the javax.security.auth.\">\n                <i class=\"fa fa-info-circle\"></i>\n              </a>\n            </label>\n            <div class=\"col-sm-6\">\n              <input type=\"text\" id=\"sd\" class=\"form-control\" ng-model=\"dac.dsData.conn.secDomain\">\n            </div>\n          </div>\n        </fieldset>\n      </form>\n\n    </div>\n    <div class=\"modal-footer\">\n      <button type=\"button\" class=\"btn btn-default hk-btn-distant\" ng-click=\"dac.onClose()\">Cancel</button>\n      <button type=\"button\" wz-previous class=\"btn btn-default\">&#60; Back</button>\n      <button type=\"button\" wz-next class=\"btn btn-primary\" ng-click=\"dac.exitStepDefineParameters()\"\n              ng-disabled=\"!dac.dsData.jndiName\">Next &#62;</button>\n    </div>\n  </wz-step>\n\n  <wz-step title=\"Review and Create\">\n\n    <div class=\"modal-body\">\n      <p><strong>Confirm - Create and Test Datasource</strong></p>\n\n      <div class=\"text-center hk-spinner-container\" ng-show=\"dac.dsData.uploading\">\n        <div class=\"spinner spinner-lg\"></div>\n      </div>\n\n      <div class=\"alert alert-success\" ng-show=\"dac.dsData.hasOperationSucceeded\">\n        <span class=\"pficon pficon-ok\"></span>\n        <strong>Success!</strong> The Datasource \"{{dac.dsData.datasourceName}}\" was created.\n      </div>\n\n      <div class=\"alert alert-danger\" ng-show=\"dac.dsData.hasOperationFailed\">\n        <span class=\"pficon pficon-error-circle-o\"></span>\n        <strong>Datasource Creation Failed.</strong><br>\n        You may re-check the data that you provided and then try again, or cancel. Cancel will permanently delete the failed datasource.\n      </div>\n\n      <form class=\"form-horizontal\">\n        <fieldset>\n          <div class=\"form-group\">\n            <label class=\"col-sm-3 control-label\">Datasource Type</label>\n            <div class=\"col-sm-6\">\n              <span class=\"hk-input-text\">{{dac.dsData.xaDatasource ? \'\' : \'Non-\'}}XA Datasource</span>\n            </div>\n          </div>\n          <div class=\"form-group\">\n            <label class=\"col-sm-3 control-label\">Datasource Name</label>\n            <div class=\"col-sm-6\">\n              <span class=\"hk-input-text\">{{dac.dsData.datasourceName}}</span>\n            </div>\n          </div>\n          <div class=\"form-group\">\n            <label class=\"col-sm-3 control-label\">Datasource JNDI Name</label>\n            <div class=\"col-sm-6\">\n              <span class=\"hk-input-text\">{{dac.dsData.jndiName}}</span>\n            </div>\n          </div>\n          <div class=\"form-group\">\n            <label class=\"col-sm-3 control-label\">Driver Name</label>\n            <div class=\"col-sm-6\">\n              <span class=\"hk-input-text\">{{dac.dsData.driverName}}</span>\n            </div>\n          </div>\n          <div class=\"form-group\" ng-show=\"dac.dsData.xaDatasource\">\n            <label class=\"col-sm-3 control-label\">Datasource XA Properties</label>\n            <div class=\"col-sm-6\">\n              <span class=\"hk-input-text\" style=\"display: block;\"\n                    ng-repeat=\"(pName, pValue) in dac.dsData.datasourceProperties\">\n                {{pName}}: {{pValue}}\n              </span>\n            </div>\n          </div>\n          <div class=\"form-group\" ng-show=\"dac.dsData.xaDatasource\">\n            <label class=\"col-sm-3 control-label\">XA Datasource Class</label>\n            <div class=\"col-sm-6\">\n              <span class=\"hk-input-text\">{{dac.dsData.xaDatasourceClass}}</span>\n            </div>\n          </div>\n          <div class=\"form-group\" ng-show=\"!dac.dsData.xaDatasource\">\n            <label class=\"col-sm-3 control-label\">Datasource Class</label>\n            <div class=\"col-sm-6\">\n              <span class=\"hk-input-text\">{{dac.dsData.driverClass}}</span>\n            </div>\n          </div>\n          <div class=\"form-group\" ng-show=\"!dac.dsData.xaDatasource\">\n            <label class=\"col-sm-3 control-label\">Connection URL</label>\n            <div class=\"col-sm-6\">\n              <span class=\"hk-input-text\">{{dac.dsData.connectionUrl}}</span>\n            </div>\n          </div>\n          <div class=\"form-group\" ng-show=\"dac.dsData.conn.username\">\n            <label class=\"col-sm-3 control-label\">Username</label>\n            <div class=\"col-sm-6\">\n              <span class=\"hk-input-text\">{{dac.dsData.conn.username}}</span>\n            </div>\n          </div>\n          <div class=\"form-group\" ng-show=\"dac.dsData.conn.secDomain\">\n            <label class=\"col-sm-3 control-label\">Security Domain</label>\n            <div class=\"col-sm-6\">\n              <span class=\"hk-input-text\">{{dac.dsData.conn.secDomain}}</span>\n            </div>\n          </div>\n        </fieldset>\n      </form>\n\n    </div>\n\n    <div class=\"modal-footer\">\n      <button type=\"button\" class=\"btn btn-default hk-btn-distant\" ng-click=\"dac.onClose()\"\n              ng-hide=\"dac.dsData.hasOperationFailed || dac.dsData.hasOperationSucceeded\"\n              ng-disabled=\"dac.dsData.uploading\">Cancel</button>\n      <button type=\"button\" wz-previous class=\"btn btn-default\" ng-disabled=\"dac.dsData.uploading\"\n              ng-hide=\"dac.dsData.hasOperationSucceeded\" ng-click=\"dac.backStepReview()\"> &#60; Back</button>\n      <button type=\"button\" class=\"btn btn-primary\" ng-click=\"dac.addDatasource()\"\n              ng-hide=\"dac.dsData.hasOperationFailed || dac.dsData.hasOperationSucceeded\"\n              ng-disabled=\"dac.dsData.uploading\">Add</button>\n      <button type=\"button\" class=\"btn btn-primary\" wz-finish ng-disabled=\"dac.dsData.uploading\"\n              ng-show=\"dac.dsData.hasOperationFailed || dac.dsData.hasOperationSucceeded\"\n              ng-click=\"dac.onClose()\">Exit</button>\n    </div>\n\n  </wz-step>\n\n</wizard>\n");
$templateCache.put("plugins/metrics/html/app-details/modals/detail-datasources-delete.html","<div class=\"modal-header\">\n  <button type=\"button\" class=\"close\" ng-click=\"mvm.cancel()\">\n    <span class=\"pficon pficon-close\"></span>\n  </button>\n  <h4 class=\"modal-title\">Delete Datasource</h4>\n</div>\n<div class=\"modal-body\">\n  <div class=\"form-group\">\n    <p class=\"primary-message\">Are you sure you want to delete the Datasource <strong>{{ mvm.datasource.name }}</strong> ?</p>\n    <p>This action can\'t be undone.</p>\n  </div>\n</div>\n<div class=\"modal-footer\">\n  <button type=\"button\" class=\"btn btn-default\" ng-click=\"mvm.cancel()\">Cancel</button>\n  <button type=\"button\" class=\"btn btn-danger\" ng-click=\"mvm.deleteDatasource()\">Delete</button>\n</div>\n");
$templateCache.put("plugins/metrics/html/app-details/modals/detail-datasources-driver-add.html","<div class=\"modal-header\">\n  <button type=\"button\" class=\"close\" aria-hidden=\"true\" ng-click=\"dac.onClose()\">\n    <span class=\"pficon pficon-close\"></span>\n  </button>\n  <h4 class=\"modal-title\">Add JDBC Driver</h4>\n</div>\n\n<wizard name=\"driverAdd\" on-finish=\"dac.finishedAddDriverWizard()\" hide-indicators=\"true\">\n\n  <wz-step title=\"Select a JDBC Driver File\">\n    <div class=\"modal-body\">\n      <p><strong>Step 1 of 3: Select JDBC Driver File</strong></p>\n\n      <form class=\"hk-form-horizontal\" name=\"addJdbcDriverForm\" novalidate>\n        <fieldset>\n          <div class=\"form-group\">\n            <label for=\"driver-file\">Download the JDBC driver from your database vendor</label>\n            <div class=\"row\">\n              <div class=\"col-md-6\">\n                <input class=\"form-control\" fileread=\"dac.driverData.binaryFile\" type=\"file\" accept=\"application/zip\"\n                       ng-model=\"dac.driverData.filePath\" hk-valid-file required\n                       name=\"driverFile\" id=\"driver-file\"/>\n              </div>\n            </div>\n          </div>\n        </fieldset>\n      </form>\n    </div>\n    <div class=\"modal-footer\">\n      <button type=\"button\" class=\"btn btn-default hk-btn-distant\" ng-click=\"dac.onClose()\">Cancel</button>\n      <button type=\"button\" class=\"btn btn-default\" disabled >&#60; Back</button>\n      <button type=\"button\" wz-next class=\"btn btn-primary\"\n              ng-disabled=\"addJdbcDriverForm.$invalid\"\n              ng-click=\"dac.exitStepFileSelect()\">Next &#62;</button>\n    </div>\n  </wz-step>\n\n  <wz-step title=\"Define Parameters\">\n    <div class=\"modal-body\">\n      <p><strong>Step 2 of 3: Define Parameters</strong></p>\n\n      <form class=\"form-horizontal\">\n        <fieldset>\n          <p class=\"hk-required-info pull-right\"><span class=\"hk-required\">*</span> Required field</p>\n          <div class=\"form-group\">\n            <label class=\"col-sm-4 control-label\">Driver File Name</label>\n            <div class=\"col-sm-6\">\n              <span class=\"hk-input-text\">{{dac.driverData.filePath}}</span>\n            </div>\n          </div>\n          <div class=\"form-group\">\n            <label class=\"col-sm-4 control-label\" for=\"dn\"><span class=\"hk-required\">*</span> Driver  Name\n              <a class=\"hk-btn-icon\" tabindex=\"-1\" role=\"button\" popover-append-to-body=\"true\"\n                 popover-placement=\"top\" popover-trigger=\"click\" popover=\"The symbolic name of the driver to be\n                 referenced by the Datsource(s)\"><i class=\"fa fa-info-circle\"></i></a>\n            </label>\n            <div class=\"col-sm-6\">\n              <input type=\"text\" id=\"dn\" class=\"form-control\" placeholder=\"e.g.: mysql\" required\n                     ng-model=\"dac.driverData.driverName\">\n            </div>\n          </div>\n          <div class=\"form-group\">\n            <label class=\"col-sm-4 control-label\" for=\"dmn\"><span class=\"hk-required\">*</span> Driver Module Name\n              <a class=\"hk-btn-icon\" tabindex=\"-1\" role=\"button\" popover-append-to-body=\"true\"\n                 popover-placement=\"top\" popover-trigger=\"click\" popover=\"The name of the module that will be created in\n                 the EAP server\"><i class=\"fa fa-info-circle\"></i></a>\n            </label>\n            <div class=\"col-sm-6\">\n              <input type=\"text\" id=\"dmn\" class=\"form-control\" placeholder=\"e.g.: com.mysql\" required\n                     ng-model=\"dac.driverData.moduleName\">\n            </div>\n          </div>\n          <div class=\"form-group\">\n            <label class=\"col-sm-4 control-label\" for=\"dc\"><span class=\"hk-required\">*</span> Driver  Class</label>\n            <div class=\"col-sm-6\">\n              <input type=\"text\" id=\"dc\" class=\"form-control\" placeholder=\"e.g.: com.mysql.jdbc.Driver\" required\n                     ng-model=\"dac.driverData.driverClass\">\n            </div>\n          </div>\n          <div class=\"form-group\">\n            <label class=\"col-sm-4 control-label\" for=\"dmv\">Driver Major Version</label>\n            <div class=\"col-sm-6\">\n              <input type=\"number\" min=\"0\" value=\"1\" class=\"form-control hk-input-small\" id=\"dmv\"\n                     ng-model=\"dac.driverData.driverMajorVersion\">\n            </div>\n          </div>\n          <div class=\"form-group\">\n            <label class=\"col-sm-4 control-label\" for=\"dmiv\">Driver Minor Version</label>\n            <div class=\"col-sm-6\">\n              <input type=\"number\" min=\"0\" value=\"1\" class=\"form-control hk-input-small\" id=\"dmiv\"\n                     ng-model=\"dac.driverData.driverMinorVersion\">\n            </div>\n          </div>\n        </fieldset>\n      </form>\n    </div>\n    <div class=\"modal-footer\">\n      <button type=\"button\" class=\"btn btn-default hk-btn-distant\" ng-click=\"dac.onClose()\">Cancel</button>\n      <button type=\"button\" wz-previous class=\"btn btn-default\">&#60; Back\n      </button>\n      <button type=\"button\" wz-next class=\"btn btn-primary\" ng-click=\"dac.exitStepDefineParameters()\"\n              ng-disabled=\"!dac.driverData.driverName || !dac.driverData.moduleName || !dac.driverData.driverClass\">\n        Next &#62;</button>\n    </div>\n  </wz-step>\n\n\n  <wz-step title=\"Review and Add Driver\">\n\n    <div class=\"modal-body\">\n      <p><strong>Step 3 of 3: Review and Add Driver</strong></p>\n\n      <div class=\"text-center hk-spinner-container\" ng-show=\"dac.driverData.uploading\">\n        <div class=\"spinner spinner-lg\"></div>\n      </div>\n\n      <div class=\"alert alert-success\" ng-show=\"dac.driverData.hasDeployedSuccessfully\">\n        <span class=\"pficon pficon-ok\"></span>\n        <strong>Success!</strong> The driver \"{{dac.driverData.driverName}}\" was installed.\n      </div>\n\n      <div class=\"alert alert-danger\" ng-show=\"dac.driverData.hasDeploymentError\">\n        <span class=\"pficon pficon-error-circle-o\"></span>\n        <strong>Error!</strong> Driver file installation failed.\n      </div>\n\n      <form class=\"form-horizontal\">\n        <fieldset>\n          <p class=\"hk-required-info pull-right\"><span class=\"hk-required\">*</span> Required field</p>\n          <div class=\"form-group\">\n            <label class=\"col-sm-4 control-label\">Driver File Name</label>\n            <div class=\"col-sm-6\">\n              <span class=\"hk-input-text\">{{dac.driverData.filePath}}</span>\n            </div>\n          </div>\n          <div class=\"form-group\">\n            <label class=\"col-sm-4 control-label\" for=\"dn\"><span class=\"hk-required\">*</span> Driver  Name\n              <a class=\"hk-btn-icon\" tabindex=\"0\" role=\"button\" popover-append-to-body=\"true\"\n                 popover-placement=\"top\" popover-trigger=\"click\" popover=\"The symbolic name of the driver to be\n                 referenced by the Datsource(s)\"><i class=\"fa fa-info-circle\"></i></a>\n            </label>\n            <div class=\"col-sm-6\">\n              <span class=\"hk-input-text\">{{dac.driverData.driverName}}</span>\n            </div>\n          </div>\n          <div class=\"form-group\">\n            <label class=\"col-sm-4 control-label\" for=\"dmn\"><span class=\"hk-required\">*</span> Driver Module Name\n              <a class=\"hk-btn-icon\" tabindex=\"0\" role=\"button\" popover-append-to-body=\"true\"\n                 popover-placement=\"top\" popover-trigger=\"click\" popover=\"The name of the module that will be created in\n                 the EAP server\"><i class=\"fa fa-info-circle\"></i></a>\n            </label>\n            <div class=\"col-sm-6\">\n              <span class=\"hk-input-text\">{{dac.driverData.moduleName}}</span>\n            </div>\n          </div>\n          <div class=\"form-group\">\n            <label class=\"col-sm-4 control-label\" for=\"dc\"><span class=\"hk-required\">*</span> Driver  Class</label>\n            <div class=\"col-sm-6\">\n              <span class=\"hk-input-text\">{{dac.driverData.driverClass}}</span>\n            </div>\n          </div>\n          <div class=\"form-group\">\n            <label class=\"col-sm-4 control-label\" for=\"dmv\">Driver Major Version</label>\n            <div class=\"col-sm-6\">\n              <span class=\"hk-input-text\">{{dac.driverData.driverMajorVersion || \'-\'}}</span>\n            </div>\n          </div>\n          <div class=\"form-group\">\n            <label class=\"col-sm-4 control-label\" for=\"dmiv\">Driver Minor Version</label>\n            <div class=\"col-sm-6\">\n              <span class=\"hk-input-text\">{{dac.driverData.driverMinorVersion || \'-\'}}</span>\n            </div>\n          </div>\n        </fieldset>\n      </form>\n\n    </div>\n\n    <div class=\"modal-footer\">\n      <button type=\"button\" class=\"btn btn-default hk-btn-distant\" ng-click=\"dac.onClose()\"\n              ng-hide=\"dac.driverData.hasDeploymentError || dac.driverData.hasDeployedSuccessfully\"\n              ng-disabled=\"dac.driverData.uploading\">Cancel</button>\n      <button type=\"button\" wz-previous class=\"btn btn-default\" ng-disabled=\"dac.driverData.uploading\"\n              ng-hide=\"dac.driverData.hasDeployedSuccessfully\"> &#60; Back</button>\n      <button type=\"button\" class=\"btn btn-primary\" ng-click=\"dac.addDriver()\"\n              ng-hide=\"dac.driverData.hasDeploymentError || dac.driverData.hasDeployedSuccessfully\"\n              ng-disabled=\"dac.driverData.uploading\">Add</button>\n      <button type=\"button\" class=\"btn btn-primary\" wz-finish ng-disabled=\"dac.driverData.uploading\"\n              ng-show=\"dac.driverData.hasDeploymentError || dac.driverData.hasDeployedSuccessfully\">Exit</button>\n    </div>\n\n  </wz-step>\n\n</wizard>\n");
$templateCache.put("plugins/metrics/html/app-details/modals/detail-deployments-add.html","<div class=\"modal-header\">\n  <button type=\"button\" class=\"close\" aria-hidden=\"true\" ng-click=\"dac.onClose()\">\n    <span class=\"pficon pficon-close\"></span>\n  </button>\n  <h4 class=\"modal-title\">Add Deployment</h4>\n</div>\n\n<wizard name=\"deployAdd\" on-finish=\"dac.finishedDeployWizard()\" hide-indicators=\"true\">\n\n  <wz-step title=\"Select a Deployment File\">\n    <div class=\"modal-body\">\n      <p><strong>Step 1 of 3: Select a Deployment File</strong></p>\n\n      <p class=\"hk-required-info\"><span class=\"hk-required\">*</span> All fields are required.</p>\n\n      <form class=\"form-horizontal\" name=\"deployFileForm\" novalidate>\n        <div class=\"form-group\">\n          <label class=\"col-sm-3 control-label\">Deployment File</label>\n\n          <div class=\"col-sm-9\">\n            <input fileread=\"dac.deploymentData.binaryFile\" type=\"file\" accept=\"*/*\"\n                   ng-model=\"dac.deploymentData.filePath\" hk-valid-file required\n                   name=\"deployFile\"/>\n          </div>\n        </div>\n      </form>\n    </div>\n    <div class=\"modal-footer\">\n      <button type=\"button\" class=\"btn btn-default\" ng-click=\"dac.onClose()\">Cancel</button>\n      <button type=\"button\" wz-next class=\"btn btn-primary\"\n              ng-disabled=\"deployFileForm.$invalid\"\n              ng-click=\"dac.exitStep1()\">Next &#62;</button>\n    </div>\n  </wz-step>\n\n  <wz-step title=\"Verify File\">\n    <div class=\"modal-body\">\n      <p><strong>Step 2 of 3: Verify File</strong></p>\n\n      <div class=\"hk-form-verify hk-form-read-only\">\n        <div class=\"hk-form-buttons pull-right\">\n          <div class=\"hk-rename-button\" ng-show=\"!dac.deploymentData.editDeploymentFiles\">\n            <button class=\"btn btn-default\" data-toggle=\"tooltip\" data-placement=\"top\"\n                    ng-click=\"dac.editVerifyFile()\"\n                    data-original-title=\"Rename\">\n              <i class=\"fa fa-pencil\"></i>\n            </button>\n          </div>\n          <div class=\"hk-discard-confirm-buttons\" ng-show=\"dac.deploymentData.editDeploymentFiles\">\n            <button class=\"btn btn-default\" data-toggle=\"tooltip\" data-placement=\"top\" data-original-title=\"Discard\"\n                    ng-disabled=\"!dac.deploymentData.editDeploymentFiles\"\n                    ng-click=\"dac.resetVerifyFile()\">\n              <i class=\"fa fa-close\"></i>\n            </button>\n            <button class=\"btn btn-default\" data-toggle=\"tooltip\" data-placement=\"top\" data-original-title=\"Confirm\"\n                    ng-disabled=\"!dac.deploymentData.editDeploymentFiles\"\n                    ng-click=\"dac.saveVerifyFile()\">\n              <i class=\"fa fa-check\"></i>\n            </button>\n          </div>\n        </div>\n\n        <form name=\"deploymentDataForm\" class=\"form-horizontal\">\n          <div class=\"editable-container\">\n            <div class=\"form-group\">\n              <label class=\"col-sm-3 control-label\" for=\"hk-deploy-name\">Name</label>\n\n              <div class=\"col-sm-7\">\n                <span class=\"hk-input-text\" ng-show=\"!dac.deploymentData.editDeploymentFiles\">\n                  {{dac.deploymentData.filePath}}</span>\n                <input type=\"text\" class=\"form-control\"\n                       ng-show=\"dac.deploymentData.editDeploymentFiles\"\n                       id=\"hk-deploy-name\"\n                       ng-model=\"dac.editableDeploymentData.filePath\">\n              </div>\n            </div>\n\n            <div class=\"form-group\">\n              <label class=\"col-sm-3 control-label\" for=\"hk-runtime-name\">Runtime Name</label>\n\n              <div class=\"col-sm-7\">\n                <span class=\"hk-input-text\" ng-show=\"!dac.deploymentData.editDeploymentFiles\">\n                  {{dac.deploymentData.runtimeFileName}}</span>\n                <input type=\"text\" class=\"form-control text\"\n                       ng-show=\"dac.deploymentData.editDeploymentFiles\"\n                       id=\"hk-runtime-name\"\n                       ng-model=\"dac.editableDeploymentData.runtimeFileName\">\n              </div>\n            </div>\n          </div>\n          <div class=\"checkbox\">\n            <label>\n              <input type=\"checkbox\" ng-model=\"dac.deploymentData.dontEnableDuringDeployment\"\n                     name=\"checkBoxDisable\"> Do not enable, during deployment.\n              <i class=\"fa fa-info-circle\"\n                 data-toggle=\"tooltip\"\n                 data-placement=\"top\"\n                 data-original-title=\"Enabling activates the deployment.\">\n              </i>\n            </label>\n          </div>\n        </form>\n      </div>\n    </div>\n    <div class=\"modal-footer\">\n      <button type=\"button\" wz-previous class=\"btn btn-default\"\n              ng-disabled=\"dac.deploymentData.editDeploymentFiles\">&#60; Back\n      </button>\n      <button type=\"button\" wz-next class=\"btn btn-primary\" ng-click=\"dac.exitStep2()\"\n              ng-disabled=\"dac.deploymentData.editDeploymentFiles\">Next &#62;</button>\n    </div>\n  </wz-step>\n\n\n  <wz-step title=\"Upload and Deploy\">\n\n    <div class=\"modal-body\">\n      <p><strong>Step 3 of 3: Upload and Deploy</strong></p>\n\n      <div class=\"text-center hk-spinner-container\" ng-show=\"dac.deploymentData.uploading\">\n        <div class=\"spinner spinner-lg\"></div>\n      </div>\n\n      <div class=\"alert alert-success\" ng-show=\"dac.deploymentData.hasDeployedSuccessfully\">\n        <span class=\"pficon pficon-ok\"></span>\n        <strong>Success!</strong> The file was successfully uploaded and deployed.\n      </div>\n\n      <div class=\"alert alert-error\" ng-show=\"dac.deploymentData.hasDeploymentError\">\n        <span class=\"pficon pficon-error-circle-o-\"></span>\n        <strong>Error!</strong> An error has occurred with the deployment.\n      </div>\n    </div>\n\n    <div class=\"modal-footer\">\n      <button type=\"button\" class=\"btn btn-primary\" wz-finish\n              ng-click=\"dac.onClose()\"\n              ng-disabled=\"dac.deploymentData.uploading\">OK\n      </button>\n    </div>\n\n  </wz-step>\n\n</wizard>\n");}]); hawtioPluginLoader.addModule("hawkular-console-templates");
var HawkularVersion = "dd02463";
//# sourceMappingURL=data:application/json;base64,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