/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.console.configuration;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@WebServlet(value={"/keycloak.json"})
public class KeycloakConfigurationServlet
extends HttpServlet {
    private static final Pattern PROPERTY_REPLACEMENT_PATTERN = Pattern.compile("\\$\\{([^}]*)\\}");

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setContentType("application/json");
        PrintWriter writer = resp.getWriter();
        writer.println(this.getKeycloakJson());
        writer.close();
    }

    private String getKeycloakJson() throws IOException {
        String rawKeycloakJson = this.getRawKeycloakJson();
        Matcher matcher = PROPERTY_REPLACEMENT_PATTERN.matcher(rawKeycloakJson);
        while (matcher.find()) {
            String propertyNotation = matcher.group();
            String propertyName = matcher.group(1);
            String value = System.getProperty(propertyName);
            if (null == value || value.isEmpty()) {
                value = propertyNotation;
            }
            rawKeycloakJson = rawKeycloakJson.replaceFirst(Pattern.quote(propertyNotation), Matcher.quoteReplacement(value));
        }
        return rawKeycloakJson;
    }

    private String getRawKeycloakJson() throws IOException {
        InputStream keycloakJson = this.getClass().getResourceAsStream("/keycloak.json");
        try (BufferedReader buffer = new BufferedReader(new InputStreamReader(keycloakJson));){
            String string = buffer.lines().collect(Collectors.joining("\n"));
            return string;
        }
    }
}

