/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.openshift.cassandra;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.apache.cassandra.config.Config;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.locator.SeedProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenshiftSeedProvider
implements SeedProvider {
    private static final Logger logger = LoggerFactory.getLogger(OpenshiftSeedProvider.class);
    private static final String PARAMETER_SEEDS = "seeds";
    private static final String CASSANDRA_NODES_SERVICE_NAME = OpenshiftSeedProvider.getEnv("CASSANDRA_NODES_SERVICE_NAME", "hawkular-cassandra");
    private static final String KUBERNETES_MASTER_URL = OpenshiftSeedProvider.getEnv("KUBERNETES_MASTER_URL", "https://kubernetes.default.svc.cluster.local:443");
    private static final String POD_NAMESPACE = OpenshiftSeedProvider.getEnv("POD_NAMESPACE", "default");
    private static final String KUBERNETES_MASTER_CERTIFICATE_FILENAME = "/var/run/secrets/kubernetes.io/serviceaccount/ca.crt";
    private static final String MASTER = OpenshiftSeedProvider.getEnv("CASSANDRA_MASTER", "false");
    private List<InetAddress> seeds = null;
    private static final int SERVICE_TRIES = 30;
    private static final int SERVICE_TRY_WAIT_TIME_MILLISECONDS = 2000;
    private SSLContext sslContext;

    public OpenshiftSeedProvider(Map<String, String> args) {
        try {
            this.sslContext = this.setupSSL();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not setup security properly for Cassandra", e);
        }
    }

    public List<InetAddress> getSeeds() {
        if (this.seeds == null) {
            this.seeds = new ArrayList<InetAddress>();
            try {
                for (int i = 0; i < 30; ++i) {
                    List<InetAddress> serviceList = this.getInetAddresses(CASSANDRA_NODES_SERVICE_NAME);
                    if (!serviceList.isEmpty()) {
                        this.seeds = serviceList;
                        break;
                    }
                    if (MASTER.equalsIgnoreCase("true") && i >= 3) {
                        logger.debug("Did not find any other nodes running in the cluster and this instance is marked as a Master. Configuring this node to use its own IP as a seed.");
                        this.seeds = this.getSeedsFromConfig();
                        return this.seeds;
                    }
                    Thread.sleep(2000L);
                }
            }
            catch (Exception exception) {
                logger.error("Could not resolve the list of seeds for the Cassandra cluster. Aborting.", (Throwable)exception);
                throw new RuntimeException(exception);
            }
        }
        return this.seeds;
    }

    private SSLContext setupSSL() throws CertificateException, IOException, KeyStoreException, NoSuchAlgorithmException, KeyManagementException {
        CertificateFactory cFactory = CertificateFactory.getInstance("X.509");
        FileInputStream certInputStream = new FileInputStream(KUBERNETES_MASTER_CERTIFICATE_FILENAME);
        Certificate certificate = cFactory.generateCertificate(certInputStream);
        ((InputStream)certInputStream).close();
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        keyStore.load(null, null);
        keyStore.setCertificateEntry("kubernetes_master_ca", certificate);
        TrustManagerFactory tmFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmFactory.init(keyStore);
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(null, tmFactory.getTrustManagers(), null);
        return sslContext;
    }

    private List<InetAddress> getInetAddresses(String serviceName) throws UnknownHostException, InterruptedException {
        ArrayList<InetAddress> inetAddresses = new ArrayList<InetAddress>();
        try {
            InetAddress[] inetArray;
            for (InetAddress address : inetArray = InetAddress.getAllByName(serviceName)) {
                inetAddresses.add(address);
            }
        }
        catch (UnknownHostException e) {
            logger.warn("UnknownHostException for service '" + serviceName + "'. It may not be up yet. Trying again");
        }
        return inetAddresses;
    }

    private List<InetAddress> getSeedsFromConfig() throws ConfigurationException {
        ArrayList<InetAddress> seedsAddresses = new ArrayList<InetAddress>();
        Config config = DatabaseDescriptor.loadConfig();
        String seeds = (String)config.seed_provider.parameters.get(PARAMETER_SEEDS);
        for (String seed : seeds.split(",")) {
            try {
                InetAddress inetAddress = InetAddress.getByName(seed);
                logger.debug("Adding seed '" + inetAddress.getHostAddress() + "' from the configuration file.");
                seedsAddresses.add(inetAddress);
            }
            catch (UnknownHostException e) {
                logger.warn("Could not get address for seed entry '" + seed + "'", (Throwable)e);
            }
        }
        return seedsAddresses;
    }

    private static String getEnv(String name, String defaultValue) {
        String value = System.getenv(name);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }
}

