/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.openshift.cassandra;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.config.Config;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.locator.SeedProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenshiftSeedProvider
implements SeedProvider {
    private static final Logger logger = LoggerFactory.getLogger(OpenshiftSeedProvider.class);
    private static final String PARAMETER_SEEDS = "seeds";
    private static final String CASSANDRA_NODES_SERVICE_NAME_ENVAR_NAME = "CASSANDRA_NODES_SERVICE_NAME";
    private static final String DEFAULT_CASSANDRA_NODES_SERVICE_NAME = "cassandra-nodes";
    private static final int SERVICE_TRIES = 30;
    private static final int SERVICE_TRY_WAIT_TIME_MILLISECONDS = 2000;

    public OpenshiftSeedProvider(Map<String, String> args) {
    }

    public List<InetAddress> getSeeds() {
        List<InetAddress> seeds = new ArrayList<InetAddress>();
        String serviceName = this.getEnv(CASSANDRA_NODES_SERVICE_NAME_ENVAR_NAME, DEFAULT_CASSANDRA_NODES_SERVICE_NAME);
        try {
            InetAddress[] inetAddresses = null;
            for (int i = 0; i < 30; ++i) {
                try {
                    inetAddresses = InetAddress.getAllByName(serviceName);
                    continue;
                }
                catch (UnknownHostException e) {
                    if (i == 29) {
                        logger.error("Could not detect service. Aborting.");
                        throw e;
                    }
                    logger.warn("Could not detect service '" + serviceName + "'. It may not be up yet trying again.", (Throwable)e);
                    Thread.sleep(2000L);
                }
            }
            if (inetAddresses == null) {
                inetAddresses = InetAddress.getAllByName(serviceName);
            }
            logger.debug(inetAddresses.length + " addresses found for service name " + serviceName);
            if (inetAddresses.length >= 1) {
                for (InetAddress inetAddress : inetAddresses) {
                    logger.debug("Adding address " + inetAddress.getHostAddress() + " to seed list");
                    seeds.add(inetAddress);
                }
            } else {
                logger.debug("No hosts found for server '" + serviceName + "' getting this hosts address from the configuration file.");
                seeds = this.getSeedsFromConfig();
            }
        }
        catch (Exception exception) {
            logger.error("Could not resolve the list of seeds for the Cassandra cluster. Aborting.", (Throwable)exception);
            throw new RuntimeException(exception);
        }
        return seeds;
    }

    private List<InetAddress> getSeedsFromConfig() throws ConfigurationException {
        ArrayList<InetAddress> seedsAddresses = new ArrayList<InetAddress>();
        Config config = DatabaseDescriptor.loadConfig();
        String seeds = (String)config.seed_provider.parameters.get(PARAMETER_SEEDS);
        for (String seed : seeds.split(",")) {
            try {
                InetAddress inetAddress = InetAddress.getByName(seed);
                logger.debug("Adding seed '" + inetAddress.getHostAddress() + "' from the configuration file.");
                seedsAddresses.add(inetAddress);
            }
            catch (UnknownHostException e) {
                logger.warn("Could not get address for seed entry '" + seed + "'", (Throwable)e);
            }
        }
        return seedsAddresses;
    }

    private String getEnv(String name, String defaultValue) {
        String value = System.getenv(name);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }
}

