/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.dropwizard;

import com.codahale.metrics.Clock;
import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Timer;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import org.hawkular.metrics.dropwizard.HawkularReporterBuilder;
import org.hawkular.metrics.dropwizard.MetricComposer;
import org.hawkular.metrics.dropwizard.MetricComposers;
import org.hawkular.metrics.dropwizard.MetricsTagger;
import org.hawkular.metrics.dropwizard.RegexTags;
import org.hawkular.metrics.reporter.http.HawkularHttpClient;
import org.hawkular.metrics.reporter.http.HawkularJson;

public class HawkularReporter
extends ScheduledReporter {
    private final Optional<String> prefix;
    private final Clock clock;
    private final HawkularHttpClient hawkularClient;
    private final MetricsTagger metricsTagger;

    HawkularReporter(MetricRegistry registry, HawkularHttpClient hawkularClient, Optional<String> prefix, Map<String, String> globalTags, Map<String, Map<String, String>> perMetricTags, Collection<RegexTags> regexTags, boolean enableAutoTagging, TimeUnit rateUnit, TimeUnit durationUnit, MetricFilter filter) {
        super(registry, "hawkular-reporter", filter, rateUnit, durationUnit);
        this.prefix = prefix;
        this.clock = Clock.defaultClock();
        this.hawkularClient = hawkularClient;
        this.metricsTagger = new MetricsTagger(prefix, globalTags, perMetricTags, regexTags, enableAutoTagging, hawkularClient, registry, filter);
    }

    @Override
    public void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
        this.hawkularClient.manageFailover();
        if (gauges.isEmpty() && counters.isEmpty() && histograms.isEmpty() && meters.isEmpty() && timers.isEmpty()) {
            return;
        }
        long timestamp = this.clock.getTime();
        DataAccumulator accu = new DataAccumulator();
        HawkularReporter.processGauges(accu, gauges);
        HawkularReporter.processCounters(accu, counters);
        HawkularReporter.processMeters(accu, meters);
        HawkularReporter.processHistograms(accu, histograms);
        HawkularReporter.processTimers(accu, timers);
        if (!accu.getCounters().isEmpty() || !accu.getGauges().isEmpty()) {
            String json = HawkularJson.metricsToString(timestamp, accu.getCounters(), accu.getGauges());
            this.hawkularClient.postMetrics(json);
        }
    }

    private static void processGauges(DataAccumulator builder, Map<String, Gauge> gauges) {
        for (Map.Entry<String, Gauge> e : gauges.entrySet()) {
            builder.addGauge(e.getKey(), e.getValue().getValue());
        }
    }

    private static void processCounters(DataAccumulator builder, Map<String, Counter> counters) {
        for (Map.Entry<String, Counter> e : counters.entrySet()) {
            builder.addCounter(e.getKey(), e.getValue().getCount());
        }
    }

    private static void processMeters(DataAccumulator builder, Map<String, Meter> meters) {
        for (Map.Entry<String, Meter> e : meters.entrySet()) {
            MetricComposers.COUNTINGS.forEach(metricComposer -> builder.addSubCounter(metricComposer, e));
            MetricComposers.METERED.forEach(metricComposer -> builder.addSubGauge(metricComposer, e));
        }
    }

    private static void processHistograms(DataAccumulator builder, Map<String, Histogram> histograms) {
        for (Map.Entry<String, Histogram> e : histograms.entrySet()) {
            MetricComposers.COUNTINGS.forEach(metricComposer -> builder.addSubCounter(metricComposer, e));
            MetricComposers.SAMPLING.forEach(metricComposer -> builder.addSubGauge(metricComposer, e));
        }
    }

    private static void processTimers(DataAccumulator builder, Map<String, Timer> timers) {
        for (Map.Entry<String, Timer> e : timers.entrySet()) {
            MetricComposers.COUNTINGS.forEach(metricComposer -> builder.addSubCounter(metricComposer, e));
            MetricComposers.METERED.forEach(metricComposer -> builder.addSubGauge(metricComposer, e));
            MetricComposers.SAMPLING.forEach(metricComposer -> builder.addSubGauge(metricComposer, e));
        }
    }

    public Optional<String> getPrefix() {
        return this.prefix;
    }

    public Map<String, String> getGlobalTags() {
        return this.metricsTagger.getGlobalTags();
    }

    public HawkularHttpClient getHawkularClient() {
        return this.hawkularClient;
    }

    public Map<String, String> getTagsForMetrics(String m) {
        return this.metricsTagger.getTagsForMetrics(m);
    }

    public boolean isEnableAutoTagging() {
        return this.metricsTagger.isEnableAutoTagging();
    }

    public static HawkularReporterBuilder builder(MetricRegistry registry, String tenant) {
        return new HawkularReporterBuilder(registry, tenant);
    }

    private class DataAccumulator {
        private Map<String, Double> gauges = new HashMap<String, Double>();
        private Map<String, Long> counters = new HashMap<String, Long>();

        private DataAccumulator() {
        }

        private Map<String, Double> getGauges() {
            return this.gauges;
        }

        private Map<String, Long> getCounters() {
            return this.counters;
        }

        private DataAccumulator addCounter(String name, long l) {
            String fullName = HawkularReporter.this.prefix.map(p -> p + name).orElse(name);
            this.counters.put(fullName, l);
            return this;
        }

        private DataAccumulator addGauge(String name, Object value) {
            String fullName = HawkularReporter.this.prefix.map(p -> p + name).orElse(name);
            if (value instanceof BigDecimal) {
                this.gauges.put(fullName, ((BigDecimal)value).doubleValue());
            } else if (value != null && value.getClass().isAssignableFrom(Double.class) && !Double.isNaN((Double)value) && Double.isFinite((Double)value)) {
                this.gauges.put(fullName, (Double)value);
            }
            return this;
        }

        private <T> DataAccumulator addSubCounter(MetricComposer<T, Long> metricComposer, Map.Entry<String, ? extends T> counterEntry) {
            String nameWithSuffix = metricComposer.getMetricNameWithSuffix(counterEntry.getKey());
            String fullName = HawkularReporter.this.prefix.map(p -> p + nameWithSuffix).orElse(nameWithSuffix);
            this.counters.put(fullName, metricComposer.getData(counterEntry.getValue()));
            return this;
        }

        private <T> DataAccumulator addSubGauge(MetricComposer<T, Object> metricComposer, Map.Entry<String, ? extends T> gaugeEntry) {
            String nameWithSuffix = metricComposer.getMetricNameWithSuffix(gaugeEntry.getKey());
            String fullName = HawkularReporter.this.prefix.map(p -> p + nameWithSuffix).orElse(nameWithSuffix);
            Object value = metricComposer.getData(gaugeEntry.getValue());
            if (value instanceof BigDecimal) {
                this.gauges.put(fullName, ((BigDecimal)value).doubleValue());
            } else if (value != null && value.getClass().isAssignableFrom(Double.class) && !Double.isNaN((Double)value) && Double.isFinite((Double)value)) {
                this.gauges.put(fullName, (Double)value);
            }
            return this;
        }
    }
}

