/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.dropwizard;

import com.codahale.metrics.Counting;
import com.codahale.metrics.Metered;
import com.codahale.metrics.Sampling;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.hawkular.metrics.dropwizard.MetricComposer;

final class MetricComposers {
    static final List<MetricComposer<Counting, Long>> COUNTINGS = new ArrayList<MetricComposer<Counting, Long>>(1);
    static final List<MetricComposer<Metered, Object>> METERED;
    static final List<MetricComposer<Sampling, Object>> SAMPLING;

    private MetricComposers() {
    }

    private static <T, U> MetricComposer<T, U> metricComposer(final Function<T, U> getter, final String suffix, final String type) {
        return new MetricComposer<T, U>(){

            @Override
            public U getData(T input) {
                return getter.apply(input);
            }

            @Override
            public String getSuffix() {
                return suffix;
            }

            @Override
            public String getMetricType() {
                return type;
            }
        };
    }

    static {
        COUNTINGS.add(MetricComposers.metricComposer(Counting::getCount, "count", "counters"));
        METERED = new ArrayList<MetricComposer<Metered, Object>>(4);
        METERED.add(MetricComposers.metricComposer(Metered::getOneMinuteRate, "1min", "gauges"));
        METERED.add(MetricComposers.metricComposer(Metered::getFiveMinuteRate, "5min", "gauges"));
        METERED.add(MetricComposers.metricComposer(Metered::getFifteenMinuteRate, "15min", "gauges"));
        METERED.add(MetricComposers.metricComposer(Metered::getMeanRate, "mean", "gauges"));
        SAMPLING = new ArrayList<MetricComposer<Sampling, Object>>(10);
        SAMPLING.add(MetricComposers.metricComposer(s -> s.getSnapshot().getMin(), "min", "gauges"));
        SAMPLING.add(MetricComposers.metricComposer(s -> s.getSnapshot().getMax(), "max", "gauges"));
        SAMPLING.add(MetricComposers.metricComposer(s -> s.getSnapshot().getMean(), "mean", "gauges"));
        SAMPLING.add(MetricComposers.metricComposer(s -> s.getSnapshot().getMedian(), "median", "gauges"));
        SAMPLING.add(MetricComposers.metricComposer(s -> s.getSnapshot().getStdDev(), "stddev", "gauges"));
        SAMPLING.add(MetricComposers.metricComposer(s -> s.getSnapshot().get75thPercentile(), "75perc", "gauges"));
        SAMPLING.add(MetricComposers.metricComposer(s -> s.getSnapshot().get95thPercentile(), "95perc", "gauges"));
        SAMPLING.add(MetricComposers.metricComposer(s -> s.getSnapshot().get98thPercentile(), "98perc", "gauges"));
        SAMPLING.add(MetricComposers.metricComposer(s -> s.getSnapshot().get99thPercentile(), "99perc", "gauges"));
        SAMPLING.add(MetricComposers.metricComposer(s -> s.getSnapshot().get999thPercentile(), "999perc", "gauges"));
    }
}

