/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.dropwizard;

import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

class RegexTags {
    private final Pattern regex;
    private final Map<String, String> tags;

    RegexTags(Pattern regex, Map<String, String> tags) {
        this.regex = regex;
        this.tags = tags;
    }

    static Optional<RegexTags> checkAndCreate(String maybeRegex, Map<String, String> tags) {
        if (maybeRegex.startsWith("/") && maybeRegex.endsWith("/")) {
            try {
                Pattern regex = Pattern.compile(maybeRegex.substring(1, maybeRegex.length() - 1));
                return Optional.of(new RegexTags(regex, tags));
            }
            catch (PatternSyntaxException e) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    Optional<Map<String, String>> match(String metricName) {
        if (this.regex.matcher(metricName).find()) {
            return Optional.of(this.tags);
        }
        return Optional.empty();
    }
}

