/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.dropwizard;

import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.hawkular.metrics.client.common.http.HawkularHttpClient;
import org.hawkular.metrics.client.common.http.JdkHawkularHttpClient;
import org.hawkular.metrics.dropwizard.HawkularReporter;
import org.hawkular.metrics.dropwizard.HawkularReporterConfig;
import org.hawkular.metrics.dropwizard.MetricsDecomposer;
import org.hawkular.metrics.dropwizard.MetricsTagger;
import org.hawkular.metrics.dropwizard.RegexContainer;

public class HawkularReporterBuilder {
    private static final String KEY_HEADER_TENANT = "Hawkular-Tenant";
    private static final String KEY_HEADER_AUTHORIZATION = "Authorization";
    private final MetricRegistry registry;
    private String uri = "http://localhost:8080";
    private Map<String, String> headers = new HashMap<String, String>();
    private Optional<String> prefix = Optional.empty();
    private MetricFilter filter = MetricFilter.ALL;
    private TimeUnit rateUnit = TimeUnit.SECONDS;
    private TimeUnit durationUnit = TimeUnit.MILLISECONDS;
    private Optional<Function<String, HawkularHttpClient>> httpClientProvider = Optional.empty();
    private final Map<String, String> globalTags = new HashMap<String, String>();
    private final Map<String, Map<String, String>> perMetricTags = new HashMap<String, Map<String, String>>();
    private final Collection<RegexContainer<Map<String, String>>> regexTags = new ArrayList<RegexContainer<Map<String, String>>>();
    private boolean tagComposition = true;
    private Optional<Long> failoverCacheDuration = Optional.of(600000L);
    private Optional<Integer> failoverCacheMaxSize = Optional.empty();
    private final Map<String, Set<String>> namedMetricsComposition = new HashMap<String, Set<String>>();
    private final Collection<RegexContainer<Set<String>>> regexComposition = new ArrayList<RegexContainer<Set<String>>>();

    public HawkularReporterBuilder(MetricRegistry registry, String tenant) {
        this.registry = registry;
        this.headers.put(KEY_HEADER_TENANT, tenant);
    }

    public HawkularReporterBuilder withNullableConfig(HawkularReporterConfig config) {
        if (config.getUri() != null) {
            this.uri(config.getUri());
        }
        if (config.getPrefix() != null) {
            this.prefixedWith(config.getPrefix());
        }
        if (config.getBearerToken() != null) {
            this.bearerToken(config.getBearerToken());
        }
        if (config.getHeaders() != null) {
            config.getHeaders().forEach(this::addHeader);
        }
        if (config.getGlobalTags() != null) {
            this.globalTags(config.getGlobalTags());
        }
        if (config.getPerMetricTags() != null) {
            this.perMetricTags(config.getPerMetricTags());
        }
        if (config.getTagComposition() != null && !config.getTagComposition().booleanValue()) {
            this.disableTagComposition();
        }
        if (config.getUsername() != null && config.getPassword() != null) {
            this.basicAuth(config.getUsername(), config.getPassword());
        }
        if (config.getMetricComposition() != null) {
            this.metricComposition(config.getMetricComposition());
        }
        this.failoverCacheDuration = Optional.ofNullable(config.getFailoverCacheDuration());
        this.failoverCacheMaxSize = Optional.ofNullable(config.getFailoverCacheMaxSize());
        return this;
    }

    public HawkularReporterBuilder uri(String uri) {
        this.uri = uri;
        return this;
    }

    public HawkularReporterBuilder basicAuth(String username, String password) {
        String encoded = Base64.getEncoder().encodeToString((username + ":" + password).getBytes());
        this.headers.put(KEY_HEADER_AUTHORIZATION, "Basic " + encoded);
        return this;
    }

    public HawkularReporterBuilder bearerToken(String token) {
        this.headers.put(KEY_HEADER_AUTHORIZATION, "Bearer " + token);
        return this;
    }

    public HawkularReporterBuilder addHeader(String key, String value) {
        this.headers.put(key, value);
        return this;
    }

    public HawkularReporterBuilder prefixedWith(String prefix) {
        this.prefix = Optional.of(prefix);
        return this;
    }

    public HawkularReporterBuilder filter(MetricFilter filter) {
        this.filter = filter;
        return this;
    }

    public HawkularReporterBuilder convertRatesTo(TimeUnit rateUnit) {
        this.rateUnit = rateUnit;
        return this;
    }

    public HawkularReporterBuilder convertDurationsTo(TimeUnit durationUnit) {
        this.durationUnit = durationUnit;
        return this;
    }

    public HawkularReporterBuilder globalTags(Map<String, String> tags) {
        this.globalTags.clear();
        this.globalTags.putAll(tags);
        return this;
    }

    public HawkularReporterBuilder addGlobalTag(String key, String value) {
        this.globalTags.put(key, value);
        return this;
    }

    public HawkularReporterBuilder perMetricTags(Map<String, Map<String, String>> tags) {
        this.perMetricTags.clear();
        this.regexTags.clear();
        tags.forEach((k, v) -> {
            Optional<RegexContainer<Map>> optRegexTags = RegexContainer.checkAndCreate(k, v);
            if (optRegexTags.isPresent()) {
                this.regexTags.add(optRegexTags.get());
            } else {
                this.perMetricTags.put((String)k, (Map<String, String>)v);
            }
        });
        return this;
    }

    public HawkularReporterBuilder addMetricTag(String metric, String key, String value) {
        Optional<RegexContainer<Map<String, String>>> optRegexTags = RegexContainer.checkAndCreate(metric, Collections.singletonMap(key, value));
        if (optRegexTags.isPresent()) {
            this.regexTags.add(optRegexTags.get());
        } else {
            Map<Object, Object> tags;
            if (this.perMetricTags.containsKey(metric)) {
                tags = this.perMetricTags.get(metric);
            } else {
                tags = new HashMap();
                this.perMetricTags.put(metric, tags);
            }
            tags.put(key, value);
        }
        return this;
    }

    public HawkularReporterBuilder addRegexTag(Pattern pattern, String key, String value) {
        this.regexTags.add(new RegexContainer<Map<String, String>>(pattern, Collections.singletonMap(key, value)));
        return this;
    }

    public HawkularReporterBuilder disableTagComposition() {
        this.tagComposition = false;
        return this;
    }

    public HawkularReporterBuilder metricComposition(Map<String, Collection<String>> conversions) {
        this.namedMetricsComposition.clear();
        this.regexComposition.clear();
        conversions.forEach((k, v) -> {
            HashSet uniqueParts = new HashSet(v);
            Optional optRegexTags = RegexContainer.checkAndCreate(k, uniqueParts);
            if (optRegexTags.isPresent()) {
                this.regexComposition.add(optRegexTags.get());
            } else {
                this.namedMetricsComposition.put((String)k, uniqueParts);
            }
        });
        return this;
    }

    public HawkularReporterBuilder setMetricComposition(String metric, Collection<String> parts) {
        HashSet<String> uniqueParts = new HashSet<String>(parts);
        Optional<RegexContainer<HashSet<String>>> optRegexTags = RegexContainer.checkAndCreate(metric, uniqueParts);
        if (optRegexTags.isPresent()) {
            this.regexComposition.add(optRegexTags.get());
        } else {
            this.namedMetricsComposition.put(metric, uniqueParts);
        }
        return this;
    }

    public HawkularReporterBuilder setRegexMetricComposition(Pattern pattern, Collection<String> parts) {
        this.regexComposition.add(new RegexContainer<HashSet<String>>(pattern, new HashSet<String>(parts)));
        return this;
    }

    public HawkularReporterBuilder failoverCacheDuration(long milliseconds) {
        this.failoverCacheDuration = Optional.of(milliseconds);
        return this;
    }

    public HawkularReporterBuilder failoverCacheDurationInMinutes(long minutes) {
        this.failoverCacheDuration = Optional.of(TimeUnit.MILLISECONDS.convert(minutes, TimeUnit.MINUTES));
        return this;
    }

    public HawkularReporterBuilder failoverCacheDurationInHours(long hours) {
        this.failoverCacheDuration = Optional.of(TimeUnit.MILLISECONDS.convert(hours, TimeUnit.HOURS));
        return this;
    }

    public HawkularReporterBuilder failoverCacheMaxSize(int reqs) {
        this.failoverCacheMaxSize = Optional.of(reqs);
        return this;
    }

    public HawkularReporterBuilder useHttpClient(Function<String, HawkularHttpClient> httpClientProvider) {
        this.httpClientProvider = Optional.of(httpClientProvider);
        return this;
    }

    public HawkularReporter build() {
        HawkularHttpClient client = this.httpClientProvider.map(provider -> (HawkularHttpClient)provider.apply(this.uri)).orElseGet(() -> new JdkHawkularHttpClient(this.uri));
        client.addHeaders(this.headers);
        client.setFailoverOptions(this.failoverCacheDuration, this.failoverCacheMaxSize);
        MetricsDecomposer decomposer = new MetricsDecomposer(this.namedMetricsComposition, this.regexComposition);
        MetricsTagger tagger = new MetricsTagger(this.prefix, this.globalTags, this.perMetricTags, this.regexTags, this.tagComposition, decomposer, client, this.registry, this.filter);
        return new HawkularReporter(this.registry, client, this.prefix, decomposer, tagger, this.rateUnit, this.durationUnit, this.filter);
    }
}

