/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.dropwizard;

import com.codahale.metrics.Counting;
import com.codahale.metrics.Metered;
import com.codahale.metrics.Sampling;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.hawkular.metrics.dropwizard.MetricPart;
import org.hawkular.metrics.dropwizard.RegexContainer;

final class MetricsDecomposer {
    private static final List<MetricPart<Counting, Long>> COUNTINGS = new ArrayList<MetricPart<Counting, Long>>(1);
    private static final List<MetricPart<Metered, Object>> METERED;
    private static final List<MetricPart<Sampling, Object>> SAMPLING;
    private final Map<String, Set<String>> namedMetricsComposition;
    private final Collection<RegexContainer<Set<String>>> regexComposition;

    MetricsDecomposer(Map<String, Set<String>> namedMetricsComposition, Collection<RegexContainer<Set<String>>> regexComposition) {
        this.namedMetricsComposition = namedMetricsComposition;
        this.regexComposition = regexComposition;
    }

    Optional<Collection<String>> getAllowedParts(String metricName) {
        if (this.namedMetricsComposition.containsKey(metricName)) {
            return Optional.of(this.namedMetricsComposition.get(metricName));
        }
        for (RegexContainer<Set<String>> reg : this.regexComposition) {
            Optional<Set<String>> match = reg.match(metricName);
            if (!match.isPresent()) continue;
            return Optional.of(match.get());
        }
        return Optional.empty();
    }

    private static <T, U> MetricPart<T, U> part(final Function<T, U> getter, final String suffix, final String type) {
        return new MetricPart<T, U>(){

            @Override
            public U getData(T input) {
                return getter.apply(input);
            }

            @Override
            public String getSuffix() {
                return suffix;
            }

            @Override
            public String getMetricType() {
                return type;
            }
        };
    }

    PartsStreamer streamParts(String metricName) {
        Predicate<String> p = this.getAllowedParts(metricName).map(allowed -> allowed::contains).orElse(part -> true);
        return new PartsStreamer(p);
    }

    static {
        COUNTINGS.add(MetricsDecomposer.part(Counting::getCount, "count", "counters"));
        METERED = new ArrayList<MetricPart<Metered, Object>>(4);
        METERED.add(MetricsDecomposer.part(Metered::getOneMinuteRate, "1minrt", "gauges"));
        METERED.add(MetricsDecomposer.part(Metered::getFiveMinuteRate, "5minrt", "gauges"));
        METERED.add(MetricsDecomposer.part(Metered::getFifteenMinuteRate, "15minrt", "gauges"));
        METERED.add(MetricsDecomposer.part(Metered::getMeanRate, "meanrt", "gauges"));
        SAMPLING = new ArrayList<MetricPart<Sampling, Object>>(10);
        SAMPLING.add(MetricsDecomposer.part(s -> s.getSnapshot().getMin(), "min", "gauges"));
        SAMPLING.add(MetricsDecomposer.part(s -> s.getSnapshot().getMax(), "max", "gauges"));
        SAMPLING.add(MetricsDecomposer.part(s -> s.getSnapshot().getMean(), "mean", "gauges"));
        SAMPLING.add(MetricsDecomposer.part(s -> s.getSnapshot().getMedian(), "median", "gauges"));
        SAMPLING.add(MetricsDecomposer.part(s -> s.getSnapshot().getStdDev(), "stddev", "gauges"));
        SAMPLING.add(MetricsDecomposer.part(s -> s.getSnapshot().get75thPercentile(), "75perc", "gauges"));
        SAMPLING.add(MetricsDecomposer.part(s -> s.getSnapshot().get95thPercentile(), "95perc", "gauges"));
        SAMPLING.add(MetricsDecomposer.part(s -> s.getSnapshot().get98thPercentile(), "98perc", "gauges"));
        SAMPLING.add(MetricsDecomposer.part(s -> s.getSnapshot().get99thPercentile(), "99perc", "gauges"));
        SAMPLING.add(MetricsDecomposer.part(s -> s.getSnapshot().get999thPercentile(), "999perc", "gauges"));
    }

    static class PartsStreamer {
        private final Predicate<String> metricPredicate;

        private PartsStreamer(Predicate<String> metricPredicate) {
            this.metricPredicate = metricPredicate;
        }

        Stream<MetricPart<Counting, Long>> countings() {
            return COUNTINGS.stream().filter(metricPart -> this.metricPredicate.test(metricPart.getSuffix()));
        }

        Stream<MetricPart<Metered, Object>> metered() {
            return METERED.stream().filter(metricPart -> this.metricPredicate.test(metricPart.getSuffix()));
        }

        Stream<MetricPart<Sampling, Object>> samplings() {
            return SAMPLING.stream().filter(metricPart -> this.metricPredicate.test(metricPart.getSuffix()));
        }
    }
}

